/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPConnection
implements LDAPv3,
Cloneable {
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    private static final String defaultFilter = "(objectClass=*)";
    private static final LDAPSearchConstraints readConstraints = new LDAPSearchConstraints();
    private transient LDAPSearchConstraints defaultConstraints = new LDAPSearchConstraints();
    private transient Vector responseListeners;
    private transient Vector searchListeners;
    private transient boolean bound;
    private transient String host;
    private transient String[] m_hostList;
    private transient int port = -1;
    private transient int[] m_portList;
    private transient int m_defaultPort;
    private transient String prevBoundDN;
    private transient String prevBoundPasswd;
    private transient String boundDN;
    private transient String boundPasswd;
    private transient int protocolVersion = 2;
    private transient LDAPSocketFactory m_factory;
    private transient LDAPConnThread th;
    private transient Vector m_attachedList = new Vector();
    private transient Hashtable m_responseControlTable = new Hashtable();
    private transient LDAPCache m_cache;
    static Hashtable m_threadConnTable = new Hashtable();
    private boolean m_anonymousBound = false;
    private static final Float SdkVersion = new Float(3.02f);
    private static final Float ProtocolVersion = new Float(3.0f);
    private static final String SecurityVersion = new String("none,simple");
    private static final Float MajorVersion = new Float(0.9f);
    private static final Float MinorVersion = new Float(0.1f);
    private static final String DELIM = "#";
    private static final String PersistSearchPackageName = "netscape.ldap.controls.LDAPPersistSearchControl";
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static final boolean debug = false;

    public LDAPConnection() {
        this.m_factory = null;
    }

    public LDAPConnection(LDAPSocketFactory factory) {
        this.m_factory = factory;
    }

    public void finalize() throws LDAPException {
        if (this.th != null) {
            this.disconnect();
        }
    }

    public void setCache(LDAPCache cache) {
        this.m_cache = cache;
    }

    public LDAPCache getCache() {
        return this.m_cache;
    }

    public Object getProperty(String name) throws LDAPException {
        if (name.equals(LDAP_PROPERTY_SDK)) {
            return SdkVersion;
        }
        if (name.equals(LDAP_PROPERTY_PROTOCOL)) {
            return ProtocolVersion;
        }
        if (name.equals(LDAP_PROPERTY_SECURITY)) {
            return SecurityVersion;
        }
        if (name.equals("version.major")) {
            return MajorVersion;
        }
        if (name.equals("version.minor")) {
            return MinorVersion;
        }
        return null;
    }

    public void setProperty(String name, Object val) throws LDAPException {
        throw new LDAPException("No property has been set");
    }

    private void setProtocolVersion(int version) {
        this.protocolVersion = version;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthenticationDN() {
        return this.boundDN;
    }

    public String getAuthenticationPassword() {
        return this.boundPasswd;
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.m_factory;
    }

    public void setSocketFactory(LDAPSocketFactory factory) {
        this.m_factory = factory;
    }

    public boolean isConnected() {
        return this.th != null && this.th.isAlive();
    }

    public boolean isAuthenticated() {
        return this.bound;
    }

    public void connect(String host, int port) throws LDAPException {
        this.connect(host, port, null, null);
    }

    public void connect(String host, int port, String dn, String passwd) throws LDAPException {
        if (this.th != null) {
            this.disconnect();
        }
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        this.m_defaultPort = port;
        StringTokenizer st = new StringTokenizer(host);
        this.m_hostList = new String[st.countTokens()];
        this.m_portList = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int colon = s.indexOf(58);
            if (colon > 0) {
                this.m_hostList[i] = s.substring(0, colon);
                this.m_portList[i] = Integer.parseInt(s.substring(colon + 1));
            } else {
                this.m_hostList[i] = s;
                this.m_portList[i] = this.m_defaultPort;
            }
            ++i;
        }
        LDAPException conex = null;
        i = 0;
        while (i < this.m_hostList.length) {
            try {
                this.host = this.m_hostList[i];
                this.port = this.m_portList[i];
                this.connect();
                conex = null;
                break;
            }
            catch (LDAPException e) {
                conex = e;
                ++i;
            }
        }
        if (conex != null) {
            this.host = this.m_hostList[0];
            this.port = this.m_defaultPort;
            throw conex;
        }
        this.authenticate(dn, passwd);
    }

    public void connect(int version, String host, int port, String dn, String passwd) throws LDAPException {
        this.setProtocolVersion(version);
        this.connect(host, port, dn, passwd);
    }

    private synchronized void connect() throws LDAPException {
        if (this.th != null) {
            return;
        }
        if (this.host == null || this.port < 0) {
            throw new LDAPException("no connection parameters", 89);
        }
        this.th = this.getNewThread(this.host, this.port, this.m_factory, this.m_cache);
    }

    private synchronized LDAPConnThread getNewThread(String host, int port, LDAPSocketFactory factory, LDAPCache cache) throws LDAPException {
        LDAPConnThread newThread = null;
        Vector v = null;
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            Enumeration keys = m_threadConnTable.keys();
            boolean connExist = false;
            while (keys.hasMoreElements()) {
                LDAPConnThread connThread = (LDAPConnThread)keys.nextElement();
                Vector connVector = (Vector)m_threadConnTable.get(connThread);
                Enumeration enumv = connVector.elements();
                while (enumv.hasMoreElements()) {
                    LDAPConnection conn = (LDAPConnection)enumv.nextElement();
                    if (!conn.equals(this)) continue;
                    connExist = true;
                    if (connThread.isAlive()) break;
                    try {
                        newThread = new LDAPConnThread(host, port, factory, cache);
                        v = (Vector)m_threadConnTable.remove(connThread);
                        break;
                    }
                    catch (Exception exception) {
                        throw new LDAPException("unable to establish connection", 52);
                    }
                }
                if (connExist) break;
            }
            if (!connExist) {
                try {
                    newThread = new LDAPConnThread(host, port, factory, cache);
                    v = new Vector();
                    v.addElement(this);
                }
                catch (Exception exception) {
                    throw new LDAPException("unable to establish connection", 52);
                }
            }
            if (newThread != null) {
                m_threadConnTable.put(newThread, v);
                int i = 0;
                int n = v.size();
                while (i < n) {
                    LDAPConnection c = (LDAPConnection)v.elementAt(i);
                    newThread.register(c);
                    c.th = newThread;
                    ++i;
                }
            }
        }
        return newThread;
    }

    public void abandon(LDAPSearchResults searchResults) throws LDAPException {
        if (this.th == null || !this.th.isAlive() || searchResults == null) {
            return;
        }
        searchResults.abandon();
        int id = searchResults.getID();
        int i = 0;
        while (i < 3) {
            try {
                this.th.abandon(id);
                this.th.sendRequest(new JDAPAbandonRequest(id), null, this.defaultConstraints);
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++i;
            }
        }
        if (this.th == null || !this.th.isAlive()) {
            throw new LDAPException("Failed to send abandon request to the server.", 80);
        }
    }

    public void authenticate(String dn, String passwd) throws LDAPException {
        this.authenticate(this.protocolVersion, dn, passwd);
    }

    public void authenticate(int version, String dn, String passwd) throws LDAPException {
        this.prevBoundDN = this.boundDN;
        this.prevBoundPasswd = this.boundPasswd;
        this.boundDN = dn;
        this.boundPasswd = passwd;
        this.m_anonymousBound = this.prevBoundDN == null || this.prevBoundPasswd == null;
        this.bind(version, true);
    }

    private void bind(int version, boolean rebind) throws LDAPException {
        if (this.th == null || !this.th.isAlive()) {
            this.bound = false;
            this.th = null;
            this.connect();
        } else if (!this.bound && rebind && this.th.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (this.bound && !rebind) {
            return;
        }
        if (!(this.m_anonymousBound || this.boundDN != null && this.boundPasswd != null || rebind)) {
            return;
        }
        if (this.bound && rebind) {
            if (this.protocolVersion == version) {
                if (this.m_anonymousBound && (this.boundDN == null || this.boundPasswd == null)) {
                    return;
                }
                if (!this.m_anonymousBound && this.boundDN != null && this.boundPasswd != null && this.boundDN.equals(this.prevBoundDN) && this.boundPasswd.equals(this.prevBoundPasswd)) {
                    return;
                }
            }
            if (this.th.getClientCount() > 1) {
                this.disconnect();
                this.connect();
            }
        }
        this.protocolVersion = version;
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            this.sendRequest(new JDAPBindRequest(this.protocolVersion, this.boundDN, this.boundPasswd), myListener, this.defaultConstraints);
            JDAPMessage response = myListener.getResponse();
            this.checkMsg(response);
        }
        finally {
            Object var6_5 = null;
            this.releaseResponseListener(myListener);
        }
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            if (m_threadConnTable.containsKey(this.th)) {
                Vector v = (Vector)m_threadConnTable.get(this.th);
                int i = 0;
                int n = v.size();
                while (i < n) {
                    LDAPConnection conn = (LDAPConnection)v.elementAt(i);
                    conn.bound = true;
                    ++i;
                }
            } else {
                LDAPConnection.printDebug("Thread table does not contain the specified thread");
            }
            return;
        }
    }

    private void sendRequest(JDAPProtocolOp oper, LDAPResponseListener myListener, LDAPSearchConstraints cons) throws LDAPException {
        int i = 0;
        while (i < 3) {
            try {
                this.th.sendRequest(oper, myListener, cons);
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++i;
            }
        }
        if (this.th == null || !this.th.isAlive()) {
            throw new LDAPException("The connection is not available", 80);
        }
    }

    private void bind() throws LDAPException {
        this.bind(this.protocolVersion, false);
    }

    public synchronized void disconnect() throws LDAPException {
        if (this.th == null || !this.th.isAlive()) {
            throw new LDAPException("unable to disconnect() without connecting", 80);
        }
        if (this.m_cache != null) {
            this.m_cache.cleanup();
            this.m_cache = null;
        }
        this.deleteThreadConnEntry();
        this.deregisterConnection();
    }

    private void deleteThreadConnEntry() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            Enumeration keys = m_threadConnTable.keys();
            while (keys.hasMoreElements()) {
                LDAPConnThread connThread = (LDAPConnThread)keys.nextElement();
                Vector connVector = (Vector)m_threadConnTable.get(connThread);
                Enumeration enumv = connVector.elements();
                while (enumv.hasMoreElements()) {
                    LDAPConnection c = (LDAPConnection)enumv.nextElement();
                    if (!c.equals(this)) continue;
                    connVector.removeElement(c);
                    Object var2_7 = null;
                    return;
                }
            }
            return;
        }
    }

    synchronized void deregisterConnection() {
        this.th.deregister(this);
        this.th = null;
        this.bound = false;
    }

    public LDAPEntry read(String DN2) throws LDAPException {
        return this.read(DN2, null);
    }

    public LDAPEntry read(String DN2, String[] attrs) throws LDAPException {
        return this.read(DN2, attrs, this.defaultConstraints);
    }

    private LDAPEntry read(String DN2, String[] attrs, LDAPSearchConstraints cons) throws LDAPException {
        LDAPSearchResults results = this.search(DN2, 0, defaultFilter, attrs, false, cons);
        if (results == null) {
            return null;
        }
        return results.next();
    }

    public static LDAPEntry read(LDAPUrl toGet) throws LDAPException {
        String host = toGet.getHost();
        int port = toGet.getPort();
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] attributes = toGet.getAttributeArray();
        String DN2 = toGet.getDN();
        LDAPConnection connection = new LDAPConnection();
        connection.connect(host, port);
        LDAPEntry returnValue = connection.read(DN2, attributes);
        connection.disconnect();
        return returnValue;
    }

    public static LDAPSearchResults search(LDAPUrl toGet) throws LDAPException {
        return LDAPConnection.search(toGet, null);
    }

    public static LDAPSearchResults search(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        String host = toGet.getHost();
        int port = toGet.getPort();
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] attributes = toGet.getAttributeArray();
        String DN2 = toGet.getDN();
        String filter = toGet.getFilter();
        if (filter == null) {
            filter = defaultFilter;
        }
        int scope = toGet.getScope();
        LDAPConnection connection = new LDAPConnection();
        connection.connect(host, port);
        LDAPSearchResults results = cons != null ? connection.search(DN2, scope, filter, attributes, false, cons) : connection.search(DN2, scope, filter, attributes, false);
        results.closeOnCompletion(connection);
        return results;
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly) throws LDAPException {
        return this.search(base, scope, filter, attrs, attrsOnly, this.defaultConstraints);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly, LDAPSearchConstraints cons) throws LDAPException {
        Object var18_22;
        LDAPSearchResults returnValue = new LDAPSearchResults(this, cons, base, scope, filter, attrs, attrsOnly);
        Vector cacheValue = null;
        Long key = null;
        boolean isKeyValid = true;
        try {
            if (this.m_cache != null && (cacheValue = (Vector)this.m_cache.getEntry(key = this.m_cache.createKey(this.host, this.port, base, filter, scope, attrs, this.boundDN, cons))) != null) {
                return new LDAPSearchResults(cacheValue, this, cons, base, scope, filter, attrs, attrsOnly);
            }
        }
        catch (LDAPException e) {
            isKeyValid = false;
            System.out.println("Exception: " + e);
        }
        this.bind();
        LDAPSearchListener myListener = this.getSearchListener();
        int deref = cons.getDereference();
        JDAPSearchRequest request = new JDAPSearchRequest(base, scope, deref, cons.getMaxResults(), cons.getTimeLimit(), attrsOnly, filter, attrs);
        LDAPSearchListener lDAPSearchListener = myListener;
        synchronized (lDAPSearchListener) {
            boolean success = false;
            try {
                this.sendRequest(request, myListener, cons);
                success = true;
            }
            finally {
                var18_22 = null;
                if (!success) {
                    this.releaseSearchListener(myListener);
                }
            }
            if (this.m_cache != null && isKeyValid) {
                myListener.setKey(key);
            }
        }
        LDAPSearchResults[] res = new LDAPSearchResults[1];
        if (cons.getBatchSize() == 0) {
            try {
                try {
                    myListener.getResponse();
                    Enumeration results = myListener.getSearchResults();
                    while (results.hasMoreElements()) {
                        JDAPMessage msg = (JDAPMessage)results.nextElement();
                        this.checkMsg(msg);
                        returnValue.add(msg.getProtocolOp());
                    }
                }
                catch (LDAPReferralException e) {
                    this.performReferrals(e, cons, 3, base, scope, filter, attrs, attrsOnly, null, null, null, res, null);
                    if (res[0] == null) {
                        res[0] = new LDAPSearchResults();
                    }
                    LDAPSearchResults lDAPSearchResults = res[0];
                    Object var17_27 = null;
                    this.releaseSearchListener(myListener);
                    return lDAPSearchResults;
                }
                catch (LDAPException ee) {
                    throw ee;
                }
                Object var17_28 = null;
                this.releaseSearchListener(myListener);
            }
            catch (Throwable success) {
                Object var17_29 = null;
                this.releaseSearchListener(myListener);
                throw success;
            }
        }
        JDAPMessage firstResult = myListener.nextResult();
        if (firstResult == null) {
            firstResult = myListener.getResponse();
            try {
                try {
                    this.checkMsg(firstResult);
                }
                catch (LDAPReferralException e) {
                    this.performReferrals(e, cons, 3, base, scope, filter, attrs, attrsOnly, null, null, null, res, null);
                    if (res[0] == null) {
                        res[0] = new LDAPSearchResults();
                    }
                    LDAPSearchResults success = res[0];
                    var18_22 = null;
                    this.releaseSearchListener(myListener);
                    return success;
                }
                catch (LDAPException ee) {
                    throw ee;
                }
                var18_22 = null;
                this.releaseSearchListener(myListener);
            }
            catch (Throwable throwable) {
                var18_22 = null;
                this.releaseSearchListener(myListener);
                throw throwable;
            }
        }
        try {
            this.checkMsg(firstResult);
            returnValue.add(firstResult.getProtocolOp());
        }
        catch (LDAPReferralException e) {
            this.performReferrals(e, cons, 3, base, scope, filter, attrs, attrsOnly, null, null, null, res, null);
            if (res[0] != null) {
                returnValue.addReferralEntries(res[0]);
            }
        }
        catch (LDAPException ee) {
            throw ee;
        }
        LDAPControl[] controls = (LDAPControl[])LDAPConnection.getOption(12, cons);
        int i = 0;
        while (controls != null && i < controls.length) {
            if (controls[i].getClass().getName().equals(PersistSearchPackageName)) {
                returnValue.associatePersistentSearch(myListener);
                return returnValue;
            }
            ++i;
        }
        returnValue.associate(myListener);
        return returnValue;
    }

    public boolean compare(String DN2, LDAPAttribute attr) throws LDAPException {
        return this.compare(DN2, attr, this.defaultConstraints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compare(String DN2, LDAPAttribute attr, LDAPSearchConstraints cons) throws LDAPException {
        LDAPResponseListener myListener;
        block9: {
            boolean bl;
            block8: {
                this.bind();
                myListener = this.getResponseListener();
                Enumeration en = attr.getByteValues();
                byte[] val = (byte[])en.nextElement();
                String debug = "";
                try {
                    debug = new String(val, "UTF8");
                }
                catch (Throwable throwable) {}
                JDAPAVA ass = new JDAPAVA(attr.getName(), debug);
                try {
                    try {
                        this.sendRequest(new JDAPCompareRequest(DN2, ass), myListener, cons);
                        JDAPMessage response = myListener.getResponse();
                        int resultCode = ((JDAPResult)((Object)response.getProtocolOp())).getResultCode();
                        if (resultCode == 5) {
                            boolean bl2 = false;
                            Object var12_15 = null;
                            this.releaseResponseListener(myListener);
                            return bl2;
                        }
                        if (resultCode == 6) {
                            bl = true;
                            break block8;
                        }
                        this.checkMsg(response);
                        break block9;
                    }
                    catch (LDAPReferralException e) {
                        boolean[] res = new boolean[1];
                        this.performReferrals(e, cons, 14, DN2, 0, null, null, false, null, null, attr, null, res);
                        boolean bl3 = res[0];
                        Object var12_17 = null;
                        this.releaseResponseListener(myListener);
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    this.releaseResponseListener(myListener);
                    throw throwable;
                }
            }
            Object var12_16 = null;
            this.releaseResponseListener(myListener);
            return bl;
        }
        Object var12_18 = null;
        this.releaseResponseListener(myListener);
        return false;
    }

    public void add(LDAPEntry entry) throws LDAPException {
        this.add(entry, this.defaultConstraints);
    }

    private void add(LDAPEntry entry, LDAPSearchConstraints cons) throws LDAPException {
        this.bind();
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPAttributeSet attrs = entry.getAttributeSet();
        LDAPAttribute[] attrList = new LDAPAttribute[attrs.size()];
        int i = 0;
        while (i < attrs.size()) {
            attrList[i] = attrs.elementAt(i);
            ++i;
        }
        try {
            try {
                this.sendRequest(new JDAPAddRequest(entry.getDN(), attrList), myListener, cons);
                JDAPMessage response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 8, null, 0, null, null, false, null, entry, null, null, null);
            }
            Object var9_9 = null;
            this.releaseResponseListener(myListener);
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op) throws LDAPException {
        String resultID;
        this.bind();
        LDAPResponseListener myListener = this.getResponseListener();
        JDAPMessage response = null;
        byte[] results = null;
        LDAPSearchConstraints cons = this.defaultConstraints;
        try {
            try {
                this.sendRequest(new JDAPExtendedRequest(op.getID(), op.getValue()), myListener, cons);
                response = myListener.getResponse();
                this.checkMsg(response);
                JDAPExtendedResponse res = (JDAPExtendedResponse)response.getProtocolOp();
                results = res.getValue();
                resultID = res.getID();
            }
            catch (LDAPReferralException e) {
                LDAPExtendedOperation lDAPExtendedOperation = this.performExtendedReferrals(e, cons, op);
                Object var9_10 = null;
                this.releaseResponseListener(myListener);
                return lDAPExtendedOperation;
            }
            Object var9_11 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
        return new LDAPExtendedOperation(resultID, results);
    }

    public void modify(String DN2, LDAPModification mod) throws LDAPException {
        this.modify(DN2, mod, this.defaultConstraints);
    }

    private void modify(String DN2, LDAPModification mod, LDAPSearchConstraints cons) throws LDAPException {
        LDAPModification[] mods = new LDAPModification[]{mod};
        this.modify(DN2, mods, cons);
    }

    public void modify(String DN2, LDAPModificationSet mods) throws LDAPException {
        this.modify(DN2, mods, this.defaultConstraints);
    }

    private void modify(String DN2, LDAPModificationSet mods, LDAPSearchConstraints cons) throws LDAPException {
        LDAPModification[] modList = new LDAPModification[mods.size()];
        int i = 0;
        while (i < mods.size()) {
            modList[i] = mods.elementAt(i);
            ++i;
        }
        this.modify(DN2, modList, cons);
    }

    private void modify(String DN2, LDAPModification[] mods) throws LDAPException {
        this.modify(DN2, mods, this.defaultConstraints);
    }

    private void modify(String DN2, LDAPModification[] mods, LDAPSearchConstraints cons) throws LDAPException {
        this.bind();
        LDAPResponseListener myListener = this.getResponseListener();
        JDAPMessage response = null;
        try {
            try {
                this.sendRequest(new JDAPModifyRequest(DN2, mods), myListener, cons);
                response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 6, DN2, 0, null, null, false, mods, null, null, null, null);
            }
            Object var7_7 = null;
            this.releaseResponseListener(myListener);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public void delete(String DN2) throws LDAPException {
        this.delete(DN2, this.defaultConstraints);
    }

    private void delete(String DN2, LDAPSearchConstraints cons) throws LDAPException {
        this.bind();
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            try {
                this.sendRequest(new JDAPDeleteRequest(DN2), myListener, cons);
                JDAPMessage response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 10, DN2, 0, null, null, false, null, null, null, null, null);
            }
            Object var6_6 = null;
            this.releaseResponseListener(myListener);
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public void rename(String DN2, String newRDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(DN2, newRDN, null, deleteOldRDN);
    }

    public void rename(String dn, String newRDN, String newParentDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(dn, newRDN, newParentDN, deleteOldRDN, this.defaultConstraints);
    }

    private void rename(String DN2, String newRDN, String newParentDN, boolean deleteOldRDN, LDAPSearchConstraints cons) throws LDAPException {
        this.bind();
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            try {
                JDAPModifyRDNRequest request = null;
                request = newParentDN != null ? new JDAPModifyRDNRequest(DN2, newRDN, deleteOldRDN, newParentDN) : new JDAPModifyRDNRequest(DN2, newRDN, deleteOldRDN);
                this.sendRequest(request, myListener, cons);
                JDAPMessage response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 12, DN2, 0, newRDN, null, deleteOldRDN, null, null, null, null, null);
            }
            Object var9_10 = null;
            this.releaseResponseListener(myListener);
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public Object getOption(int option) throws LDAPException {
        if (option == 17) {
            return new Integer(this.protocolVersion);
        }
        return LDAPConnection.getOption(option, this.defaultConstraints);
    }

    private static Object getOption(int option, LDAPSearchConstraints cons) throws LDAPException {
        switch (option) {
            case 2: {
                return new Integer(cons.getDereference());
            }
            case 3: {
                return new Integer(cons.getMaxResults());
            }
            case 4: {
                return new Integer(cons.getTimeLimit());
            }
            case 8: {
                return new Boolean(cons.getReferrals());
            }
            case 9: {
                return cons.getRebindProc();
            }
            case 10: {
                return new Integer(cons.getHopLimit());
            }
            case 20: {
                return new Integer(cons.getBatchSize());
            }
            case 11: {
                return cons.getClientControls();
            }
            case 12: {
                return cons.getServerControls();
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    public void setOption(int option, Object value) throws LDAPException {
        if (option == 17) {
            this.setProtocolVersion((Integer)value);
            return;
        }
        LDAPConnection.setOption(option, value, this.defaultConstraints);
    }

    private static void setOption(int option, Object value, LDAPSearchConstraints cons) throws LDAPException {
        try {
            switch (option) {
                case 2: {
                    cons.setDereference((Integer)value);
                    return;
                }
                case 3: {
                    cons.setMaxResults((Integer)value);
                    return;
                }
                case 4: {
                    cons.setTimeLimit((Integer)value);
                    return;
                }
                case 8: {
                    cons.setReferrals((Boolean)value);
                    return;
                }
                case 9: {
                    cons.setRebindProc((LDAPRebind)value);
                    return;
                }
                case 10: {
                    cons.setHopLimit((Integer)value);
                    return;
                }
                case 20: {
                    cons.setBatchSize((Integer)value);
                    return;
                }
                case 11: {
                    if (value == null) {
                        cons.setClientControls((LDAPControl[])null);
                        return;
                    }
                    if (value instanceof LDAPControl) {
                        cons.setClientControls((LDAPControl)value);
                        return;
                    }
                    if (value instanceof LDAPControl[]) {
                        cons.setClientControls((LDAPControl[])value);
                        return;
                    }
                    throw new LDAPException("invalid LDAPControl", 89);
                }
                case 12: {
                    if (value == null) {
                        cons.setServerControls((LDAPControl[])null);
                        return;
                    }
                    if (value instanceof LDAPControl) {
                        cons.setServerControls((LDAPControl)value);
                        return;
                    }
                    if (value instanceof LDAPControl[]) {
                        cons.setServerControls((LDAPControl[])value);
                        return;
                    }
                    throw new LDAPException("invalid LDAPControl", 89);
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException classCastException) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    public LDAPControl[] getResponseControls() {
        LDAPControl[] con;
        LDAPControl[] controls = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            con = (LDAPControl[])this.m_responseControlTable.get(Thread.currentThread());
        }
        if (con != null && con.length > 0) {
            controls = new LDAPControl[con.length];
            int i = 0;
            while (i < con.length) {
                controls[i] = (LDAPControl)con[i].clone();
                ++i;
            }
        }
        return controls;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return this.defaultConstraints;
    }

    private synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener l;
        if (this.responseListeners == null) {
            this.responseListeners = new Vector(5);
        }
        if (this.responseListeners.size() < 1) {
            l = new LDAPResponseListener(this);
        } else {
            l = (LDAPResponseListener)this.responseListeners.elementAt(0);
            this.responseListeners.removeElementAt(0);
        }
        l.setThread();
        return l;
    }

    private synchronized LDAPSearchListener getSearchListener() {
        LDAPSearchListener l;
        if (this.searchListeners == null) {
            this.searchListeners = new Vector(5);
        }
        if (this.searchListeners.size() < 1) {
            l = new LDAPSearchListener(this);
        } else {
            l = (LDAPSearchListener)this.searchListeners.elementAt(0);
            this.searchListeners.removeElementAt(0);
        }
        l.setThread();
        return l;
    }

    private synchronized void releaseResponseListener(LDAPResponseListener l) {
        if (this.responseListeners == null) {
            this.responseListeners = new Vector(5);
        }
        l.reset();
        this.responseListeners.addElement(l);
    }

    private synchronized void releaseSearchListener(LDAPSearchListener l) {
        if (this.searchListeners == null) {
            this.searchListeners = new Vector(5);
        }
        l.reset();
        this.searchListeners.addElement(l);
    }

    void checkMsg(JDAPMessage m) throws LDAPException {
        if (m.getProtocolOp() instanceof JDAPResult) {
            JDAPResult response = (JDAPResult)((Object)m.getProtocolOp());
            int resultCode = response.getResultCode();
            if (resultCode == 0) {
                return;
            }
            if (resultCode == 10) {
                throw new LDAPReferralException("referral", resultCode, response.getReferrals());
            }
            if (resultCode == 9) {
                throw new LDAPReferralException("referral", resultCode, response.getErrorMessage());
            }
            throw new LDAPException("error result", resultCode, response.getErrorMessage(), response.getMatchedDN());
        }
        if (m.getProtocolOp() instanceof JDAPSearchResultReference) {
            String[] referrals = ((JDAPSearchResultReference)m.getProtocolOp()).getUrls();
            throw new LDAPReferralException("referral", 0, referrals);
        }
    }

    void setResponseControls(Thread current, LDAPControl[] con) {
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            if (con != null) {
                this.m_responseControlTable.put(current, con);
            } else {
                this.m_responseControlTable.remove(current);
            }
            Enumeration e = this.m_attachedList.elements();
            while (e.hasMoreElements()) {
                Thread aThread = (Thread)e.nextElement();
                if (aThread.isAlive()) continue;
                this.m_responseControlTable.remove(aThread);
                this.m_attachedList.removeElement(aThread);
            }
        }
        if (this.m_attachedList.indexOf(current) < 0) {
            this.m_attachedList.addElement(current);
        }
    }

    private LDAPConnection prepareReferral(LDAPUrl u, LDAPSearchConstraints cons) throws LDAPException {
        LDAPConnection connection = new LDAPConnection(this.getSocketFactory());
        connection.setOption(8, new Boolean(true));
        connection.setOption(9, cons.getRebindProc());
        connection.setOption(10, new Integer(cons.getHopLimit() - 1));
        connection.connect(u.getHost(), u.getPort());
        if (cons.getRebindProc() == null) {
            connection.authenticate(null, null);
        } else {
            LDAPRebindAuth auth = cons.getRebindProc().getRebindAuthentication(u.getHost(), u.getPort());
            connection.authenticate(auth.getDN(), auth.getPassword());
        }
        return connection;
    }

    void performReferrals(LDAPReferralException e, LDAPSearchConstraints cons, int ops, String dn, int scope, String filter, String[] types, boolean attrsOnly, LDAPModification[] mods, LDAPEntry entry, LDAPAttribute attr, LDAPSearchResults[] search_res, boolean[] compare_res) throws LDAPException {
        if (cons.getHopLimit() < 0) {
            throw new LDAPReferralException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            throw e;
        }
        LDAPUrl[] u = e.getURLs();
        if (u == null) {
            return;
        }
        int i = 0;
        while (i < u.length) {
            try {
                LDAPConnection connection = this.prepareReferral(u[i], cons);
                String newDN = u[i].getDN();
                String DN2 = null;
                DN2 = newDN != null ? newDN : dn;
                switch (ops) {
                    case 3: {
                        LDAPSearchConstraints newcons = (LDAPSearchConstraints)cons.clone();
                        newcons.setHopLimit(cons.getHopLimit() - 1);
                        search_res[0] = connection.search(DN2, scope, filter, types, attrsOnly, newcons);
                        if (search_res[0] != null) {
                            search_res[0].closeOnCompletion(connection);
                        }
                        return;
                    }
                    case 6: {
                        connection.modify(DN2, mods);
                        break;
                    }
                    case 8: {
                        connection.add(entry);
                        break;
                    }
                    case 10: {
                        connection.delete(DN2);
                        break;
                    }
                    case 12: {
                        connection.rename(DN2, filter, attrsOnly);
                        break;
                    }
                    case 14: {
                        compare_res[0] = connection.compare(DN2, attr);
                        break;
                    }
                }
                connection.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                ++i;
            }
        }
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException e, LDAPSearchConstraints cons, LDAPExtendedOperation op) throws LDAPException {
        if (cons.getHopLimit() < 0) {
            throw new LDAPReferralException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            throw e;
        }
        LDAPUrl[] u = e.getURLs();
        if (u == null) {
            return null;
        }
        int i = 0;
        while (i < u.length) {
            try {
                LDAPConnection connection = this.prepareReferral(u[i], cons);
                LDAPExtendedOperation results = connection.extendedOperation(op);
                connection.disconnect();
                return results;
            }
            catch (LDAPException lDAPException) {
                ++i;
            }
        }
        return null;
    }

    public synchronized Object clone() {
        try {
            LDAPConnection c = (LDAPConnection)super.clone();
            c.defaultConstraints = (LDAPSearchConstraints)this.defaultConstraints.clone();
            c.responseListeners = null;
            c.searchListeners = null;
            c.bound = this.bound;
            c.host = this.host;
            c.port = this.port;
            c.boundDN = this.boundDN;
            c.boundPasswd = this.boundPasswd;
            c.m_factory = this.m_factory;
            c.th = this.th;
            Hashtable hashtable = m_threadConnTable;
            synchronized (hashtable) {
                Vector v = (Vector)m_threadConnTable.get(this.th);
                if (v == null) {
                    LDAPConnection.printDebug("Failed to clone");
                    Object var2_4 = null;
                    Object var4_5 = null;
                    return var2_4;
                }
                v.addElement(c);
            }
            c.th.register(c);
            return c;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean checkCommunicator() {
        try {
            Method m = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (m == null) {
                LDAPConnection.printDebug("Method is null");
                return false;
            }
            Object[] args = new Object[]{new String("UniversalConnect")};
            m.invoke(null, args);
            LDAPConnection.printDebug("UniversalConnect enabled");
            return true;
        }
        catch (LDAPException e) {
            LDAPConnection.printDebug("Exception: " + e.toString());
        }
        catch (Exception ie) {
            LDAPConnection.printDebug("Exception on invoking enablePrivilege: " + ie.toString());
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    private static void printDebug(String msg) {
    }

    public static void main(String[] args) {
        System.out.println("LDAP SDK Version is " + SdkVersion);
        System.out.println("LDAP Protocol Version is " + ProtocolVersion);
    }
}

