# The contents of this file are subject to the Mozilla Public License
# Version 1.0 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License
# at http://www.mozilla.org/MPL/
# 
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and 
# limitations under the License.
# 
# The Original Code is this file as it was released upon August 6, 1998.
#
# The Initial Developer of this code under the MPL is Christopher
# Seawood, <cls@seawood.org>.  Portions created by Christopher Seawood 
# are Copyright (C) 1998 Christopher Seawood.  All Rights Reserved.

# A netscape style .mk file for autoconf builds

USE_AUTOCONF 	= 1
MOZILLA_CLIENT	= 1
NO_MDUPDATE	= 1

MOZ_LIB_UTIL_PREFIX = moz
MOZ_LIB_JS_PREFIX   = moz
MOZ_LIB_DBM_PREFIX  = moz

MOZ_GFX_TOOLKIT	= beos
MOZ_WIDGET_TOOLKIT	= beos

MOZ_XLIBRGB_LDFLAGS = 
MOZ_USING_XLIBRGB = 

MOZ_GFX_TOOLKIT_LDFLAGS     = -lgfx$(MOZ_GFX_TOOLKIT) $(MOZ_XLIBRGB_LDFLAGS)
MOZ_WIDGET_TOOLKIT_LDFLAGS	= -lwidget$(MOZ_WIDGET_TOOLKIT)

MOZ_SECURITY 	= 
MOZ_JAVA	= 
MOZ_OJI		= 
MOZ_DEBUG	= 
MOZ_DEBUG_MODULES = 
MOZILLA_GPROF	= 
BUILD_PROFILE	= 
MOZ_MAIL_NEWS	= 1
MOZ_EDITOR	= 1
MOZ_BRPROF      = 
UNIX_CRASH_ON_ASSERT = 
NO_UNIX_ASYNC_DNS = 
NO_SHARED_LIB	= 
NO_NETSCAPE_SHARED = 
NO_STATIC_LIB	= 
NO_NETSCAPE_STATIC = 
MOZ_STRIP_NOT_EXPORTED = 
ENABLE_TESTS	= 1
ENABLE_PICS     = 
DOM		= 
MOZ_MAIL_COMPOSE = 
NO_UNIX_LDAP	= 
BUILD_IDLC = 
MODULAR_NETLIB  = 1
STANDALONE_IMAGE_LIB = 1

ClientWallet=1
CookieManagement=1
SingleSignon=1

MOZ_POST_DSO_LIB_COMMAND = strip
MOZ_POST_PROGRAM_COMMAND = strip

MOZ_ENABLE_GTK_MOZILLA     = 
MOZ_BUILD_ROOT             = 

MOZ_NATIVE_ZLIB	= 
MOZ_NATIVE_JPEG	= 
MOZ_NATIVE_PNG	= 

MOZ_UPDATE_XTERM = 

MOZ_INSURE = 
MOZ_INSURIFYING = 
MOZ_INSURE_DIRS = 
MOZ_INSURE_EXCLUDE_DIRS = 

MOZ_BUILD_XPFE = 1
MOZ_NATIVE_NSPR = 

NECKO = 
TOOLBAR_DD = 

# Should the extra CFLAGS only be added in Makefile.ins that need them? 
OS_CFLAGS	= -Wall -Wconversion -Wshadow -Wpointer-arith -Wbad-function-cast -Wcast-align $(filter-out %/.pp,-Wp,-MD,$(MDDEPDIR)/$(*F).pp) -include $(DEPTH)/config-defs.h
OS_CXXFLAGS	= -frtti -fexceptions -Wall -Wconversion -Wshadow -Wpointer-arith -Wbad-function-cast -Wcast-align -Woverloaded-virtual -Wsynth $(filter-out %/.pp,-Wp,-MD,$(MDDEPDIR)/$(*F).pp) -include $(DEPTH)/config-defs.h

OS_CFLAGS	+= $(DSO_CFLAGS) $(DSO_PIC_CFLAGS)
OS_CXXFLAGS	+= $(DSO_CFLAGS) $(DSO_PIC_CFLAGS)

OS_LDFLAGS      = -Wall -Wconversion -Wshadow -Wpointer-arith -Wbad-function-cast -Wcast-align

OS_INCLUDES	= $(NSPR_CFLAGS) $(JPEG_CFLAGS) $(PNG_CFLAGS) $(ZLIB_CFLAGS)
OS_LIBS		= 
ACDEFINES	=  -DUSE_AUTOCONF=1 -DMOZILLA_CLIENT=1 -DX_DISPLAY_MISSING=1 -DSTDC_HEADERS=1 -DHAVE_ST_BLKSIZE=1 -DHAVE_ST_RDEV=1 -DHAVE_TM_ZONE=1 -DHAVE_UINT=1 -DHAVE_UINT_T=1 -DHAVE_DIRENT_H=1 -DHAVE_SYS_WAIT_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_FCNTL_H=1 -DHAVE_LIMITS_H=1 -DHAVE_MALLOC_H=1 -DHAVE_MEMORY_H=1 -DHAVE_STRINGS_H=1 -DHAVE_SYS_FILE_H=1 -DHAVE_SYS_IOCTL_H=1 -DHAVE_SYS_TIME_H=1 -DHAVE_GETOPT_H=1 -DHAVE_SYS_STATVFS_H=1 -DHAVE_ALLOCA_H=1 -DHAVE_ALLOCA=1 -DHAVE_UNISTD_H=1 -DRETSIGTYPE=void -DHAVE_STRCOLL=1 -DHAVE_STRFTIME=1 -DHAVE_UTIME_NULL=1 -Dvfork=fork -DHAVE_VPRINTF=1 -DHAVE_FTIME=1 -DHAVE_GETCWD=1 -DHAVE_GETHOSTNAME=1 -DHAVE_LOCALTIME_R=1 -DHAVE_MKDIR=1 -DHAVE_MKTIME=1 -DHAVE_PUTENV=1 -DHAVE_QSORT=1 -DHAVE_RANDOM=1 -DHAVE_REMAINDER=1 -DHAVE_RMDIR=1 -DHAVE_SELECT=1 -DHAVE_SETVBUF=1 -DHAVE_SNPRINTF=1 -DHAVE_SOCKET=1 -DHAVE_STATVFS=1 -DHAVE_STRCSPN=1 -DHAVE_STRDUP=1 -DHAVE_STRERROR=1 -DHAVE_STRSPN=1 -DHAVE_STRSTR=1 -DHAVE_STRTOL=1 -DHAVE_STRTOUL=1 -DHAVE_UNAME=1 -DHAVE_GETTIMEOFDAY=1 -DGETTIMEOFDAY_TWO_ARGS=1 -DHAVE_IOS_BINARY=1 -DHAVE_IOS_BIN=1 -DHAVE_CPP_NAMESPACES=1 -DHAVE_OSTREAM=1 -DHAVE_CPP_EXPLICIT=1 -DHAVE_CPP_SPECIALIZATION=1 -DHAVE_CPP_USING=1 -DHAVE_CPP_NEW_CASTS=1 -DHAVE_I18N_LC_MESSAGES=1 -DENABLE_PICS=1 -DClientWallet=1 -DCookieManagement=1 -DSingleSignon=1 -DMOZ_USER_DIR=\".mozilla\" -DMOZ_DLL_SUFFIX=\".so\" -DMODULAR_NETLIB=1 -DSTANDALONE_IMAGE_LIB=1 -DXP_BEOS=1 -DJS_THREADSAFE=1 -DLAYERS=1 -DNETSCAPE=1 -DNGEDITOR=1 

XCFLAGS		= 
XLDFLAGS	= 
XLIBS		= 

AIX_SHLIB_BIN	= 
AR		= ar cr $@
AS		= 
ASFLAGS		= 
AS_DASH_C_FLAG	= -c

# Temp hack.  It is not my intention to leave this crap in here for ever.
# Im talking to fur right now to solve the problem without introducing 
# NS_USE_NATIVE to the build system -ramiro.
NS_USE_NATIVE = 

CC		    = gcc
CXX		    = c++

GNU_CC		= 1
GNU_CXX		= 1

ifdef MOZ_INSURIFYING
include $(topsrcdir)/config/insure.mk
endif # MOZ_INSURIFYING

ACEMACS		= :
ACPERL		= /boot/home/config/bin/perl
ACRANLIB	= ranlib
ACWHOAMI	= :
ACUNZIP		= /bin/unzip
ACZIP		= /bin/zip

OBJDIR_TAG	= _AC
OBJDIR_NAME	= .

ifdef MOZ_NATIVE_JPEG
JPEG_CFLAGS	= 
JPEG_LIBS	= 
JPEG_REQUIRES	=
else
JPEG_CFLAGS	= -I$(DIST)/public/jpeg
JPEG_LIBS	= $(DIST)/lib/libjpeg.a
JPEG_REQUIRES	= jpeg
endif

ifdef MOZ_NATIVE_ZLIB
ZLIB_CFLAGS	= 
ZLIB_LIBS	= 
ZLIB_REQUIRES	=
else
ZLIB_CFLAGS	= -I$(DIST)/public/zlib
ZLIB_LIBS	= $(DIST)/lib/libzlib.a
ZLIB_REQUIRES	= zlib
endif

ifdef MOZ_NATIVE_PNG
PNG_CFLAGS	= 
PNG_LIBS	= 
PNG_REQUIRES	=
else
PNG_CFLAGS	= -I$(DIST)/public/png
PNG_LIBS	= $(DIST)/lib/libpng.a
PNG_REQUIRES	= png
endif

NSPR_CFLAGS	= 
NSPR_LIBS	= -lplds3 -lplc3 -lnspr3 
NSPR_INCLUDE_DIR= 

# MKSHLIB_FORCE_ALL is used to force the linker to include all object
# files present in an archive. MKSHLIB_UNFORCE_ALL reverts the linker
# to normal behavior. Makefile's that create shared libraries out of
# archives use these flags to force in all of the .o files in the
# archives into the shared library.
ifndef NO_SHARED_LIB
WRAP_MALLOC_LIB         = 
WRAP_MALLOC_CFLAGS      = 
BUILD_UNIX_PLUGINS      = 1
DSO_CFLAGS              = 
DSO_PIC_CFLAGS          = -fPIC
MKSHLIB                 = $(CXX) $(DSO_LDOPTS)
MKCSHLIB                = $(CC) $(DSO_LDOPTS)
MKSHLIB_FORCE_ALL       = -Wl,--whole-archive
MKSHLIB_UNFORCE_ALL     = -Wl,--no-whole-archive
DSO_LDOPTS              = -nostart -Xlinker --ignore-undefined
DLL_SUFFIX              = so
NO_LD_ARCHIVE_FLAGS     = 
endif

GTK_CONFIG	= 
TK_CFLAGS	= 
TK_LIBS		= 

MOZ_TOOLKIT_REGISTRY_CFLAGS = \
		-DWIDGET_DLL=\"libwidget$(MOZ_WIDGET_TOOLKIT).$(DLL_SUFFIX)\" \
		-DGFXWIN_DLL=\"libgfx$(MOZ_GFX_TOOLKIT).$(DLL_SUFFIX)\" \
		$(TK_CFLAGS)

LIBIDL_CFLAGS = -I/boot/home/mozilla/libs/glib/lib/glib/include -I/boot/home/mozilla/libs/glib/include -I/boot/home/mozilla/libs/libIDL/include -I/boot/home/mozilla/libs/glib/lib/glib/include -I/boot/home/mozilla/libs/glib/include
LIBIDL_LIBS = -L/boot/home/mozilla/libs/glib/lib -lglib -L/boot/home/mozilla/libs/libIDL/lib -L/boot/home/mozilla/libs/glib/lib -lIDL -lglib

MOZ_NATIVE_MAKEDEPEND	= 

# Used for LD_LIBRARY_PATH
LIBS_PATH       = 

COMPILER_DEPEND = 1
MDDEPDIR        := .deps

MOZ_DISABLE_DTD_DEBUG = 

# Pulled these out of configure.in,
# so undefine them now instead of subst
MOZ_NETCAST	=
MOZ_LDAP	=
SMART_MAIL	=

# XXX - these need to be cleaned up and have real checks added -cls
NGLAYOUT_PLUGINS=1 
CM_BLDTYPE=dbg 
AWT_11=1 
MOZ_BITS=32 
OS_TARGET=BeOS
