/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is Netscape Communications
 * Corporation.  Portions created by Netscape are Copyright (C) 1998
 * Netscape Communications Corporation.  All Rights Reserved.
 */

#ifndef ns1ByteToUnicodeBase_h__
#define ns1ByteToUnicodeBase_h__

#include "nsIComponentManager.h"
#include "nsIUnicodeDecoder.h"
#include "nsIUnicodeDecodeUtil.h"

class ns1ByteToUnicodeBase : public nsIUnicodeDecoder
{

public:

  /**
   * Class constructor.
   */
  ns1ByteToUnicodeBase();

  /**
   * Class destructor.
   */
  virtual ~ns1ByteToUnicodeBase();

  //--------------------------------------------------------------------
  // Interface nsIUnicodeDecoder [declaration]

  NS_IMETHOD Convert(PRUnichar * aDest, PRInt32 aDestOffset, 
      PRInt32 * aDestLength,const char * aSrc, PRInt32 aSrcOffset, 
      PRInt32 * aSrcLength);
  NS_IMETHOD Finish(PRUnichar * aDest, PRInt32 aDestOffset, 
      PRInt32 * aDestLength);
  NS_IMETHOD Length(const char * aSrc, PRInt32 aSrcOffset, PRInt32 aSrcLength, 
      PRInt32 * aDestLength);
  NS_IMETHOD Reset();
  NS_IMETHOD SetInputErrorBehavior(PRInt32 aBehavior);

private:
  nsIUnicodeDecodeUtil *mUtil;

protected:
  virtual uMappingTable* GetMappingTable() = 0;
  virtual PRUnichar* GetFastTable() = 0;
  virtual PRBool GetFastTableInitState() = 0;
  virtual void SetFastTableInit() = 0;
};

#endif
