//@line 42 "/builds/buildbot/comm-central-linux-nightly/build/mail/base/content/contentAreaClick.js"

  /**
   * Extract the href from the link click event.
   * We look for HTMLAnchorElement, HTMLAreaElement, HTMLLinkElement,
   * HTMLInputElement.form.action, and nested anchor tags.
   *
   * @return href for the url being clicked
   */
  function hRefForClickEvent(aEvent)
  {
    var target = aEvent.target;
    var href;
    var isKeyPress = (aEvent.type == "keypress");

    if (target instanceof HTMLAnchorElement ||
        target instanceof HTMLAreaElement   ||
        target instanceof HTMLLinkElement)
    {
      if (target.hasAttribute("href"))
        href = target.href;
    }
    else if (target instanceof HTMLInputElement)
    {
      if (target.form && target.form.action)
        href = target.form.action;
    }
    else
    {
      // we may be nested inside of a link node
      var linkNode = aEvent.originalTarget;
      while (linkNode && !(linkNode instanceof HTMLAnchorElement))
        linkNode = linkNode.parentNode;

      if (linkNode)
        href = linkNode.href;
    }

    return href;
  }

  function messagePaneOnResize(aEvent)
  {
    // scale any overflowing images
    var messagepane = document.getElementById("messagepane");
    var doc = messagepane.contentDocument;
    var imgs = doc.images;
    for each (var img in imgs)
    {
      if (img.className == "moz-attached-image")
      {
        if (img.naturalWidth <= doc.width)
        {
          img.removeAttribute("isshrunk");
          img.removeAttribute("overflowing");
        }
        else if (img.hasAttribute("shrinktofit")) 
        {
          img.setAttribute("isshrunk", "true");
          img.removeAttribute("overflowing");
        }
        else
        {
          img.setAttribute("overflowing", "true");
          img.removeAttribute("isshrunk");
        }
      }
    }
  }

  // Called whenever the user clicks in the content area,
  // should always return true for click to go through
  function contentAreaClick(aEvent)
  {
    var href = hRefForClickEvent(aEvent);
    if (href && !aEvent.button) // left click on link only
    {
      // let the phishing detector check the link
      return gPhishingDetector.warnOnSuspiciousLinkClick(href);
    }
    if (!aEvent.button)
    {
      var target = aEvent.target;
      // is this an image that we might want to scale?
      const Ci = Components.interfaces;
      if (target instanceof Ci.nsIImageLoadingContent)
      {
        // make sure it loaded successfully
        var req = target.getRequest(Ci.nsIImageLoadingContent.CURRENT_REQUEST);
        if (!req || req.imageStatus & Ci.imgIRequest.STATUS_ERROR)
          return true;
        // is it an inline attachment?
        if (/^moz-attached-image/.test(target.className))
        {
          if (target.hasAttribute("isshrunk"))
          {
            // currently shrunk to fit, so unshrink it
            target.removeAttribute("isshrunk");
            target.removeAttribute("shrinktofit");
            target.setAttribute("overflowing", "true");
          }
          else if (target.hasAttribute("overflowing"))
          {
            // user wants to shrink now
            target.setAttribute("isshrunk", "true");
            target.setAttribute("shrinktofit", "true");
            target.removeAttribute("overflowing");
          }
        }
      }
    }

    return true;
  }
