#!/bin/ksh

#
# The contents of this file are subject to the Netscape Public License
# Version 1.1 (the "NPL"); you may not use this file except in
# compliance with the NPL.  You may obtain a copy of the NPL at
# http://www.mozilla.org/NPL/
# 
# Software distributed under the NPL is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
# for the specific language governing rights and limitations under the
# NPL.
# 
# The Initial Developer of this code under the NPL is Netscape
# Communications Corporation.  Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation.  All Rights
# Reserved.
#

#
# tests.ksh
#	korn shell script for nspr tests
#

SYSTEM_INFO=`uname -a`
OS_ARCH=`uname -s`
if [ $OS_ARCH = "Windows_NT" ]
then
	NULL_DEVICE=nul
else
	NULL_DEVICE=/dev/null
fi

#
# Irrevelant tests
#
#bug1test 	- used to demonstrate a bug on NT
#dbmalloc	- obsolete; originally for testing debug version of nspr's malloc
#dbmalloc1	- obsolete; originally for testing debug version of nspr's malloc
#depend		- obsolete; used to test a initial spec for library dependencies
#dceemu		- used to tests special functions in NSPR for DCE emulation
#ipv6		- IPV6 not in use by NSPR clients
#sproc_ch	- obsolete; sproc-based tests for Irix
#sproc_p	- obsolete; sproc-based tests for Irix
#io_timeoutk - obsolete; subsumed in io_timeout
#io_timeoutu - obsolete; subsumed in io_timeout
#prftest1	- obsolete; subsumed by prftest
#prftest2	- obsolete; subsumed by prftest
#prselect	- obsolete; PR_Select is obsolete
#select2	- obsolete; PR_Select is obsolete
#sem		- obsolete; PRSemaphore is obsolete
#stat		- for OS2?
#suspend	- private interfaces PR_SuspendAll, PR_ResumeAll, etc..
#thruput	- needs to be run manually as client/server
#time		- used to measure time with native calls and nspr calls
#tmoacc		- should be run with tmocon
#tmocon		- should be run with tmoacc
#op_noacc	- limited use
#yield		- limited use for PR_Yield

#
# Tests not run (but should)
#

#forktest (failed on IRIX)
#nbconn - fails on some platforms 
#poll_er - fails on some platforms? limited use?
#prpoll -  the bad-FD test needs to be moved to a different test
#sleep	-  specific to OS/2

LOGFILE=${NSPR_TEST_LOGFILE:-$NULL_DEVICE}

#
# Tests run on all platforms
#

TESTS="
acceptread
accept
affinity
alarm
anonfm
atomic
attach
bigfile
cleanup
cltsrv
concur
cvar
cvar2
dlltest
dtoa
errcodes
exit
fdcach
fileio
foreign
fsync
gethost
getproto
i2l
initclk
inrval
instrumt
intrupt
io_timeout
ioconthr
join
joinkk
joinku
joinuk
joinuu
layer
lazyinit
lltest
lock
lockfile
logger
many_cv
multiwait
nameshm1
nblayer
nonblock
ntioto
op_2long
op_excl
op_filnf
op_filok
op_nofil
parent
perf
pipeping
pipeself
poll_nm
poll_to
pollable
prftest
priotest
provider
ranfile
randseed
rwlocktest
sel_spd
selct_er
selct_nm
selct_to
sema
semaerr
semaping
sendzlf
server_test
servr_kk
servr_uk
servr_ku
servr_uu
short_thread
sigpipe
socket
sockopt
sockping
sprintf
stack
stdio
str2addr
strod
switch
system
testbit
testfile
threads
timemac
timetest
tpd
udpsrv
vercheck
version
writev
xnotify
zerolen"

rval=0


#
# When set, value of the environment variable TEST_TIMEOUT is the maximum
# time (secs) allowed for a test program beyond which it is terminated.
# If TEST_TIMEOUT is not set or if it's value is 0, then test programs
# don't timeout.
#

OBJDIR=`basename $PWD`
echo "\nNSPR Test Results - $OBJDIR\n"
echo "BEGIN\t\t\t`date`"
echo "NSPR_TEST_LOGFILE\t${LOGFILE}\n"
echo "Test\t\t\tResult\n"
for prog in $TESTS
do
echo "$prog\c"
echo "\nBEGIN TEST: $prog\n" >> ${LOGFILE} 2>&1
export test_rval
./$prog >> ${LOGFILE} 2>&1 &
test_pid=$!
sleep_pid=0
if [ "$TEST_TIMEOUT" -gt 0 ]
then
(sleep  $TEST_TIMEOUT; kill $test_pid >/dev/null 2>&1 ) &
sleep_pid=$!
fi
wait $test_pid
test_rval=$?
[ sleep_pid -eq 0 ] || kill $sleep_pid >/dev/null 2>&1
if [ 0 = $test_rval ] ; then
	echo "\t\t\tPassed";
else
	echo "\t\t\tFAILED";
	rval=1
fi;
echo "\nEND TEST: $prog\n" >> ${LOGFILE} 2>&1
done
echo "END\t\t\t`date`"

exit $rval
