/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 */
#ifndef nsITimer_h___
#define nsITimer_h___

#include "nscore.h"
#include "nsISupports.h"

class nsITimer;
class nsITimerCallback;

// Implementations of nsITimer should be written such that there are no limitations
// on what can be called by the TimerCallbackFunc. On platforms like the Macintosh this
// means that callback functions must be called from the main event loop NOT from
// an interrupt.

/// Signature of timer callback function
typedef void
(*nsTimerCallbackFunc) (nsITimer *aTimer, void *aClosure);

/// Interface IID for nsITimer
#define NS_ITIMER_IID         \
{ 0x497eed20, 0xb740, 0x11d1,  \
{ 0x9b, 0xc3, 0x00, 0x60, 0x08, 0x8c, 0xa6, 0xb3 } }

/**
 * Timer class, used to invoke a function or method after a fixed
 * millisecond interval. <B>Note that this interface is subject to
 * change!</B>
 */
class nsITimer : public nsISupports {
public:  
  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ITIMER_IID)
  
  /**
   * Initialize a timer to fire after the given millisecond interval.
   * This version takes a function to call and a closure to pass to
   * that function.
   *
   * @param aFunc - The function to invoke
   * @param aClosure - an opaque pointer to pass to that function
   * @param aRepeat - (Not yet implemented) One-shot or repeating
   * @param aDelay - The millisecond interval
   * @result - NS_OK if this operation was successful
   */
  virtual nsresult Init(nsTimerCallbackFunc aFunc,
                        void *aClosure,
//                      PRBool aRepeat, 
                        PRUint32 aDelay)=0;

  /**
   * Initialize a timer to fire after the given millisecond interval.
   * This version takes an interface of type <code>nsITimerCallback</code>. 
   * The <code>Notify</code> method of this method is invoked.
   *
   * @param aCallback - The interface to notify
   * @param aRepeat - (Not yet implemented) One-shot or repeating
   * @param aDelay - The millisecond interval
   * @result - NS_OK if this operation was successful
   */
  virtual nsresult Init(nsITimerCallback *aCallback,
//                      PRBool aRepeat, 
                        PRUint32 aDelay)=0;

  /// Cancels the timeout
  virtual void Cancel()=0;

  /// @return the millisecond delay of the timeout
  virtual PRUint32 GetDelay()=0;

  /// Change the millisecond interval for the timeout
  virtual void SetDelay(PRUint32 aDelay)=0;

  /// @return the opaque pointer
  virtual void* GetClosure()=0;
};

//
// Factory method for creating an nsITimer
//
// Warning: This function should NOT be defined with NS_TIMER because
// the intention is that it be linked statically with the library/DLL
// or app that uses it.

extern
nsresult NS_NewTimer(nsITimer** aInstancePtrResult);

#endif // nsITimer_h___

