
/*********** PREVIEW CONTROL CLASS *******************/

function PreviewControl(){ this.init(); }

PreviewControl.prototype  = {

doc       :   document,

curState  :   null,

curObj    :   'current-object',

objPre    :   'object-preview',

objId     :   'source-id',

bgImage   : null,

fgImage   : null,

src       :   null,

elementAtts :   new Array(
              'att-element',
              'att-id',
              'att-class',
              'att-value',
              'att-current-element-value',
              'att-current-id-value',
              'att-current-class-value',
              'att-current-value-value'),


/******** INIT **************/
init    : function (){


  this.curState = frames[0][this.mode()];
  this.src      = frames[0].document;

},
/******** INIT **************/


/******** MODE **************/
mode    : function (){

  var mode        = this.doc.getElementById('selected-state-text').getAttribute('value'); 
  return mode;
},
/******** MODE **************/


/******** EXISTS ************/
exists    : function (){

  var objExists     = this.doc.getElementById(this.curObj);
  return objExists;
},
/******** EXISTS ************/


/******** SET CHECKS ********/
setChecks : function (){

  this.doc.getElementById('display-bgimage').setAttribute('checked',true);
  this.doc.getElementById('display-fgimage').setAttribute('checked',true);
},
/******** SET CHECKS ********/


/******** CLEAR *************/
clear   : function (){

	gc.clearControls(null);

  if(!this.exists())
  return;

    var preview           = this.doc.getElementById(this.objPre);
    var child           	= preview.firstChild;
  
  if(!child)
  return;
  
  var targetElement   = this.doc.getElementById(this.curObj);
  preview.removeChild(targetElement);
  this.setChecks();

  var len         = this.elementAtts.length;

  for(i=0;i<len;i++)
  this.doc.getElementById(this.elementAtts[i]).setAttribute('value','');

},
/******** CLEAR *************/

/******** SET IMAGE *********/
setImage  : function (inRule){

  if(inRule=="background-image:") 
  var bg=true;

  for(i=0;i<this.curState.curRule.length;i++){
    if(inRule==this.curState.curRule[i]){ 
      if(bg)
      this.bgImage=this.curState.curSetting[i];

      else
      this.fgImage=this.curState.curSetting[i];
    }
  }
},
/******** SET IMAGE *********/

/******** GET IMAGE *********/
getImage  : function (inRule){

  if(inRule=="background-image:") 
  return this.bgImage;

  return this.fgImage;

},
/******** GET IMAGE *********/

/******** NEW IMAGE *********/

newImage  : function (imgRule, url) {

  if(!this.exists())
  return;

  if(gc.match(imgRule))
  gc.replace(imgRule, url);

  else
  dump(imgRule+"  "+url);

  this.update();
  cc.setControl();
  
},
/******** NEW IMAGE *********/

/******** LAYERS ************/
layers    : function (ID, imgRule){

  if(!this.exists())
  return;

  if(!gc.match(imgRule))
  return;

  var caller        = this.doc.getElementById(ID).getAttribute('checked');
  if(!caller){
  gc.replace(imgRule,this.getImage(imgRule));
  this.update();
  cc.setControl();
  return;
  }

  this.setImage(imgRule);
  gc.replace(imgRule," none;\n");
  this.update();
  cc.setControl();

},
/******** LAYERS ************/

/******** UPDATE ***********/
update  : function () {

  if(!this.exists())
  return;

  eval(this.exists()).setAttribute('style', gc.getCurrentAsString());
},
/******** UPDATE ***********/

/******** RESET *************/
reset : function() {

  this.setChecks();

  if(!this.exists())
  return;

  var defaultStyle    = gc.getDefaultAsString();

  eval(this.exists()).setAttribute('style', defaultStyle);
  this.curState.init(this.exists().getAttribute(this.objId));
  gc.setControls(null);

},
/******** RESET *************/


/******** PREVIEW ***********/
preview : function(ID, TAG, VALUE, TYPE){

  var obj           = this.src.getElementById(ID);
  
  this.curState.init(ID);

  if(obj.getAttribute('curRule')){

  var inRule              = "new Array(" + obj.getAttribute('curRule') + ")"; 
  var inSetting           = "new Array(" + obj.getAttribute('curSetting') + ")";

  pc.curState.curRule     = eval(inRule); 
  pc.curState.curSetting  = eval(inSetting);

  }

  var style;
  obj.getAttribute('curRule') ? style=gc.getCurrentAsString() : style=gc.getDefaultAsString();


  var newElement  = this.doc.createElement(TAG);

  newElement.setAttribute("id", "current-object");
  newElement.setAttribute("source-id", ID);
  newElement.setAttribute("style", style);

  if(VALUE)
  newElement.setAttribute("value", VALUE);

  if(TYPE)
  newElement.setAttribute("type", TYPE);

  var target      = this.doc.getElementById('object-preview');
  target.appendChild(newElement);

  gc.setControls(null);

},
/******** PREVIEW ***********/

/******** POSTATTS***********/

postAtts  : function(inName, inValue){

  switch(inName){

  case "tagName":
  this.doc.getElementById('att-element').setAttribute('value','element:');
  this.doc.getElementById('att-current-element-value').setAttribute('value',inValue);
  break;

  case "id":
  this.doc.getElementById('att-id').setAttribute('value','id:');
  this.doc.getElementById('att-current-id-value').setAttribute('value',inValue);
  break;

  case "class":
  this.doc.getElementById('att-class').setAttribute('value','class:');
  this.doc.getElementById('att-current-class-value').setAttribute('value',inValue);
  break;

  case "value":
  this.doc.getElementById('att-value').setAttribute('value','value:');
  this.doc.getElementById('att-current-value-value').setAttribute('value',inValue);
  break;

  }


}

/******** POSTATTS***********/

} //END


/*********** PREVIEW CONTROL CLASS *******************/

/*********** STYLE CONTROL CLASSES *******************/

/*********** GENERAL CONTROL *************************/
function General(){

this.SysBeep  = new Components.Constructor('component://netscape/sound', 'nsISound');
this.beep     = new this.SysBeep;

}

General.prototype   = {

  component : null,

  outString : null,

  SysBeep   : null,

  beep      : null,

  pat       : /px/,

  pat0      : / /,

  pat1      : /;/,

  pat2      : /\n/,

  pat3      : /pt/,
  
  pat4      : /\s/,

  pat5      : /:/,

	regId			: new Array(),

	URL				: 'chrome://theme_builder/content/',


initCurrent : function (){

  pc.curState.curRule         = new Array();  
  pc.curState.curSetting      = new Array();

  for(i=0;i<pc.curState.rule.length;i++){
  pc.curState.curRule[i]      = pc.curState.rule[i]; 
  pc.curState.curSetting[i]   = pc.curState.setting[i]; 
  }

},

match : function (inRule){

  if(!pc.exists())
  return;

  for(i=0;i<pc.curState.curRule.length;i++){
    if(pc.curState.curRule[i]==inRule){ 
    return true;
    }
  }

  //dump('no matching rule found\n');
  return false;

},

replace : function (inRule, newSetting){

  if(!pc.exists())
  return;

  for(i=0;i<pc.curState.curRule.length;i++){
  if(inRule==pc.curState.curRule[i])  
  pc.curState.curSetting[i]=newSetting;
  }
},

remove : function (inRule) {

  if(!pc.exists())
  return;

  var tmpRule     = new Array();
  var tmpSetting    = new Array();
  var nc        = 0;

  for(i=0;i<pc.curState.curRule.length;i++){
  if(inRule==pc.curState.curRule[i])  
  pc.curState.curRule[i]="";

    if(pc.curState.curRule[i] != ""){
    tmpRule[nc]   = pc.curState.curRule[i];
    tmpSetting[nc]  = pc.curState.curSetting[i];
    nc++;
    }
    
  }

  pc.curState.curRule     = tmpRule;  
  pc.curState.curSetting  = tmpSetting; 
  
},

append  : function (newRule, newSetting){

  if(!pc.exists())
  return;

  var len           = pc.curState.curRule.length; 

  pc.curState.curRule[len]    = newRule;
  pc.curState.curSetting[len] = newSetting;

},

getDefaultAsString : function (){

    this.outString   = "";
    for(i=0; i<pc.curState.rule.length; i++)
    this.outString  += pc.curState.rule[i]+pc.curState.setting[i]; 

  return this.outString;

},

getCurrentAsString : function (){


    this.outString   = "";
    for(i=0; i<pc.curState.curRule.length; i++)
    this.outString  += pc.curState.curRule[i]+pc.curState.curSetting[i]; 

  return this.outString;
},

apply : function (rule, inSetting) {

  if(!pc.exists())
  return;

  inSetting = " "+inSetting+";\n";

  if(this.match(rule)){
  this.replace(rule, inSetting);
  pc.update();
  //dump(this.getCurrentAsString());  // DEBUG
  return;
  }
  
  this.append(rule, inSetting);
  pc.update();
  
  //dump(this.getCurrentAsString());  // DEBUG 

},

timeStamp			: function () {

	var t			= new Date();
	var stamp	= t.getMonth()+ "-" +t.getDay()+ "-" +t.getFullYear()+ " " +t.getHours()+ ":" +t.getMinutes();

	return stamp;

},


setModified	: function (set) {

	d=document;
	
	if(set)
	d.getElementById('modified-text').setAttribute('value', this.timeStamp());

	else
	d.getElementById('modified-text').setAttribute('value', 'unmodified');


},

applyChanges  : function () {


  if(!pc.exists())
  return;

	d=document;
  var obj     = d.getElementById('current-object');

  var srcId   = obj.getAttribute('source-id');
  var style   = obj.getAttribute('style');

  var src     = frames[0].document.getElementById(srcId);

  var outRule     = new Array();
  var outSetting  = new Array();

  for(i=0;i<pc.curState.curRule.length;i++){
  outRule[i]    = "'"+pc.curState.curRule[i].replace("\n","\\n")+"'";
  outSetting[i] = "'"+pc.curState.curSetting[i].replace("\n","\\n")+"'";
  } 


  //dump(outRule+'\n\n'+outSetting+'\n\n');

  src.setAttribute('style',style);
  src.setAttribute('curRule',outRule );
  src.setAttribute('curSetting',outSetting);

	this.registerId(srcId);
	this.setModified(true);
},

registerId	: function (id) {

	for(i=0;i<this.regId.length;i++){
	if(id==this.regId[i])
	return;
	}

	this.regId.push(id);

},

setControls   : function (tab) {

  if(!pc.exists()){
	this.clearControls(tab);
  return;
	}

  if(!tab)
  tab       = this.getSelectedTab();

  /*** This exists for better performance ****/

  switch(tab){

  
    case "size-tab":
    sc.setControl();
    break;

    case "fonts-tab":
    fc.setControl();
    break;

    case "colors-tab":
    cc.setControl();
    break;

    case "padding-tab":
    padc.setControl();mc.setControl();
    break;

    case "border-tab":
    bc.setControl();
    break;

    case "misc-tab":
    dump('not implemented yet\n\n');
    break;

  }

},

clearControls   : function (tab) {

  if(!tab)
  tab       = this.getSelectedTab();

  /*** This exists for better performance ****/

  switch(tab){

    case "size-tab":
    sc.clearControl();
    break;

    case "fonts-tab":
    fc.clearControl();
    break;

    case "colors-tab":
    cc.clearControl();
    break;

    case "padding-tab":
    padc.clearControl(); mc.clearControl();
    break;

    case "border-tab":
    bc.clearControl();
    break;

    case "misc-tab":
    dump('not implemented yet\n\n');
    break;

  }

},

getSelectedTab  : function () {

d=document;
var tabCtl  = d.getElementById('style-rules').firstChild;

  for(i=0;i<tabCtl.childNodes.length-1;i++){
    if(tabCtl.childNodes[i].getAttribute('selected')=="true"){
    return tabCtl.childNodes[i].id;
    }
  }
  
  return false;

},


forceInteger  : function (elementID) {

	d=document;
  var textField = d.getElementById( elementID );

  if ( !textField )
  return;

  var stringIn = textField.value;

  if (stringIn) {
    pat=/\D+/g;
    if(pat.test(stringIn)){
      this.beep.beep(); 
      stringIn=stringIn.replace(pat,"");
    }
    textField.value = stringIn;
  }
},

setDisplay	: function (themeName){

	d=document;
	d.getElementById('component-display-theme').setAttribute('value', themeName);
	d.getElementById('component-display-type').setAttribute('value', this.component);

},

getProjects	: function (refresh){


		dump("Calling getProjects ****\n\n");

    var RDF = new Components.Constructor("component://netscape/rdf/rdf-service", "nsIRDFService");
    var rdf = new RDF();

    var project_file = "file://"+io.getProjectDir()+"/projects.rdf";

    var ds 		= rdf.GetDataSource(project_file);

		if(refresh){
		var remote = ds.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
		remote.Refresh(true);
		}

    var menu 	= document.getElementById('projects');
    menu.database.AddDataSource(ds);
    menu.builder.rebuild();

    menu 	= document.getElementById('projects-toolbar');
    menu.database.AddDataSource(ds);
    menu.builder.rebuild();


},

newTheme	: function () {

window.openDialog(this.URL, "_blank", "chrome,dialog=no");

}

} // END

/*********** GENERAL CONTROL *************************/

/*********** SIZE ************************************/

function Size(){ this.init(); }

Size.prototype  = {


  width       : 'width:',

  height      : 'height:',

  minWidth    : 'min-width:',

  minHeight   : 'min-height:',

  maxWidth    : 'max-width:',

  maxHeight   : 'max-height:',

  element     : null,

  rules       : null,

init    : function () {

this.rules  =   new Array(
                [this.width, 'width-number','width-pixel-name'],
                [this.height, 'height-number','height-pixel-name'],
                [this.minWidth, 'min-width-number', 'min-width-pixel-name'],
                [this.minHeight, 'min-height-number', 'min-height-pixel-name'],
                [this.maxWidth, 'max-width-number', 'max-width-pixel-name'],
                [this.maxHeight, 'max-height-number', 'max-height-pixel-name']);

},

apply : function (rule, inSetting) { 

  gc.remove(this[rule]); 
  gc.apply(this[rule],inSetting); 

},

initArray : function (type) {

  this.element    = new Array();

  switch(type){

  case "width":

  this.element[0]   = this.rules[0][1];
  this.element[1]   = this.rules[0][2];

  break;

  case "height":

  this.element[0]   = this.rules[1][1];
  this.element[1]   = this.rules[1][2];

  break;

  case "minWidth":

  this.element[0]   = this.rules[2][1];
  this.element[1]   = this.rules[2][2];

  break;

  case "minHeight":

  this.element[0]   = this.rules[3][1];
  this.element[1]   = this.rules[3][2];

  break;

  case "maxWidth":

  this.element[0]   = this.rules[4][1];
  this.element[1]   = this.rules[4][2];

  break;

  case "maxHeight":

  this.element[0]   = this.rules[5][1];
  this.element[1]   = this.rules[5][2];

  break;


  }


},

setControl  : function () {

	d=document;
  var r;
  var type;
  var num;

  for(r=0;r<this.rules.length;r++){

    if(gc.match(this.rules[r][0])){ 
    type  = gc.pat.test(pc.curState.curSetting[i]) ? type="px" : type="em";
    num   = parseInt(pc.curState.curSetting[i]); 
    	d.getElementById(this.rules[r][1]).setAttribute('value',num);
    	d.getElementById(this.rules[r][2]).setAttribute('value',type);
    }
	
		else{
    	d.getElementById(this.rules[r][1]).setAttribute('value',0);
    	d.getElementById(this.rules[r][2]).setAttribute('value',"px");
		}
	
  }

},

clearControl	: function () {

	d=document;
  var r;

  for(r=0;r<this.rules.length;r++){

    d.getElementById(this.rules[r][1]).setAttribute('value',0);
    d.getElementById(this.rules[r][2]).setAttribute('value',"px");

  }

}

} // END

/*********** SIZE ************************************/

/*********** FONTS ***********************************/
function Font(){ this.init(); }

Font.prototype  = {

  color         : 'color:',

  face          : 'font:',

  size          : 'font-size:',

  style         : 'font-style:',

  weight        : 'font-weight:',

  variant       : 'font-variant:',

  decoration    : 'text-decoration:',

  rules         : null,

apply : function (rule, inSetting) { gc.apply(this[rule],inSetting); },

init    : function () {

this.rules  =   new Array(
                [this.color, 'font-color','font-type-in-color'],
                [this.face, 'font-face-name'],
                [this.size, 'font-size-number', 'font-size-name'],
                [this.style, 'font-style-name'],
                [this.weight, 'font-weight-name'],
                [this.variant, 'font-variant-name'],
                [this.decoration,'decoration-underline','decoration-overline',
                'decoration-line-through', 'decoration-none']);

},

setControl  : function () {

	d=document;
  var r;
  var retval;
  var num;
  var type;

  for(r=0;r<this.rules.length;r++){

    if(gc.match(this.rules[r][0])){ 

      retval  = pc.curState.curSetting[i].replace(gc.pat0,"");
      retval  = retval.replace(gc.pat1,"");
      retval  = retval.replace(gc.pat2,"");

      switch(r){
  
      case 0:
      d.getElementById(this.rules[r][1]).setColor(retval);
      d.getElementById(this.rules[r][2]).value=retval;
      break;

      case 2:
      num     = parseInt(pc.curState.curSetting[i]); 
      type    = gc.pat3.test(pc.curState.curSetting[i]) ? type="pt" : type="px"; 
      d.getElementById(this.rules[r][1]).setAttribute('value',num);
      d.getElementById(this.rules[r][2]).setAttribute('value',type);
      break;
      
      case 6:
      retval  = pc.curState.curSetting[i].replace(gc.pat0,"");
      retval  = retval.replace(gc.pat1,"");
      retval  = retval.replace(gc.pat2,"");

      var child=d.getElementById('font-decoration').childNodes;
      for(n=0;n<child.length;n++)
      child[n].removeAttribute('checked');

        switch(retval){

        case "underline":
        d.getElementById(this.rules[6][1]).checked=true;
        break;
  
        case "overline":
        d.getElementById(this.rules[6][2]).checked=true;
        break;
  
        case "line-through":
        d.getElementById(this.rules[6][3]).checked=true;
        break;
  
        default:
        d.getElementById(this.rules[6][4]).checked=true;
        
        } 

      break;

      default:
      d.getElementById(this.rules[r][1]).setAttribute('value',retval);

      }


    }

		else {

    	switch(r){
  
    	case 0:
    		d.getElementById(this.rules[r][1]).setColor('#000000');
    		d.getElementById(this.rules[r][2]).value="#000000";
    	break;

    	case 2:
      	d.getElementById(this.rules[r][1]).setAttribute('value',0);
      	d.getElementById(this.rules[r][2]).setAttribute('value',"px");
    	break;
      
			case 6:
    	var child=d.getElementById('font-decoration').childNodes;
    	for(n=0;n<child.length;n++)
    	child[n].removeAttribute('checked');
    	d.getElementById(this.rules[6][4]).checked=true;
			break;

    	default:
    	d.getElementById(this.rules[r][1]).setAttribute('value','none');

			}

		}


  }

},

clearControl	: function () {

	d=document;
	var r;

  for(r=0;r<this.rules.length;r++){

    switch(r){
  
    case 0:
    	d.getElementById(this.rules[r][1]).setColor('#000000');
    	d.getElementById(this.rules[r][2]).value="#000000";
    break;

    case 2:
      d.getElementById(this.rules[r][1]).setAttribute('value',0);
      d.getElementById(this.rules[r][2]).setAttribute('value',"px");
    break;
      
		case 6:
    var child=d.getElementById('font-decoration').childNodes;
    for(n=0;n<child.length;n++)
    child[n].removeAttribute('checked');
    d.getElementById(this.rules[6][4]).checked=true;
		break;

    default:
    d.getElementById(this.rules[r][1]).setAttribute('value','none');

		}

	}

}

} //END
/*********** FONTS ***********************************/

/*********** COLORS **********************************/


function Color(){ this.init(); }

Color.prototype   = {

  color         : 'background-color:',

  bgimage       : 'background-image:',

  bgrepeat      : 'background-repeat:',

  bgposition    : 'background-position:',

  fgimage       : 'list-style-image:',


apply : function (rule, inSetting) { gc.apply(this[rule],inSetting); },


init    : function () {

this.rules  =   new Array(
                [this.color,'background-color','bg-type-in-color','bg-color-none'],
                [this.bgimage,'bg-type','bg-image-url'],
                [this.bgrepeat,'bg-repeat-name'],
                [this.bgposition,'bg-h-position-name','bg-hpos-pixel-name','bg-v-position-name','bg-vpos-pixel-name'],
                [this.fgimage,'fg-type','fg-image-url']
                );

},


setControl  : function () {

  var r;
  var retval;
	d=document;

for(r=0;r<this.rules.length;r++){

    if(gc.match(this.rules[r][0])){ 

      retval  = pc.curState.curSetting[i].replace(gc.pat0,"");
      retval  = retval.replace(gc.pat1,"");
      retval  = retval.replace(gc.pat2,"");

      switch(r){

      case 0:
      if(retval=='none'){
      d.getElementById(this.rules[r][3]).setAttribute('checked',true);
      break;
      }

      d.getElementById(this.rules[r][1]).setColor(retval);
      d.getElementById(this.rules[r][2]).value=retval;
      d.getElementById(this.rules[r][3]).removeAttribute('checked');
      break;

      case 2:
      d.getElementById(this.rules[r][1]).setAttribute('value',retval);
      break;

      case 3:

      retval = pc.curState.curSetting[i];

			eval(retval.replace(/(\d+)(px|%) (\d+)(px|%);/, "var int1=$1; var type1='$2'; var int2=$3; var type2='$4';"));
		
      d.getElementById(this.rules[r][1]).setAttribute('value', int1);
      d.getElementById(this.rules[r][2]).setAttribute('value', type1);
      d.getElementById(this.rules[r][3]).setAttribute('value', int2);
      d.getElementById(this.rules[r][4]).setAttribute('value', type2);
      break;

      default:
      if(retval=='none'){
      	d.getElementById(this.rules[r][1]).setAttribute('value',retval);
      	d.getElementById(this.rules[r][2]).value="";
      break;
      }
      
      d.getElementById(this.rules[r][1]).setAttribute('value','url');
      d.getElementById(this.rules[r][2]).value=retval;
      break;

      }
  
      
    }

		else {

      switch(r){

      case 0:
      	d.getElementById(this.rules[r][3]).setAttribute('checked',true);
      	d.getElementById(this.rules[r][1]).setColor('#000000');
      	d.getElementById(this.rules[r][2]).value='#000000';
      break;

  		case 1:
  		d.getElementById(this.rules[r][1]).setAttribute('value','none');
  		d.getElementById(this.rules[r][2]).value="";
  		break;

  		case 2:
  		d.getElementById(this.rules[r][1]).setAttribute('value','no-repeat');
  		break;

			case 3:
    	d.getElementById(this.rules[r][1]).setAttribute('value',0);
    	d.getElementById(this.rules[r][2]).setAttribute('value',"px");
    	d.getElementById(this.rules[r][3]).setAttribute('value',0);
    	d.getElementById(this.rules[r][4]).setAttribute('value',"px");
  		break;

			default:
    	d.getElementById(this.rules[r][1]).setAttribute('value','none');
    	d.getElementById(this.rules[r][2]).value="";

			}

	}

}

},

clearControl	: function () {

d=document;
var r;
var retval;

for(r=0;r<this.rules.length;r++){

	switch(r){

  case 0:
    d.getElementById(this.rules[r][3]).setAttribute('checked',true);
    d.getElementById(this.rules[r][1]).setColor('#000000');
    d.getElementById(this.rules[r][2]).value='#000000';
  break;

  case 1:
  	d.getElementById(this.rules[r][1]).setAttribute('value','none');
  	d.getElementById(this.rules[r][2]).value="";
  break;

  case 2:
  	d.getElementById(this.rules[r][1]).setAttribute('value','no-repeat');
  break;

	case 3:
    d.getElementById(this.rules[r][1]).setAttribute('value',0);
    d.getElementById(this.rules[r][2]).setAttribute('value',"px");
    d.getElementById(this.rules[r][3]).setAttribute('value',0);
    d.getElementById(this.rules[r][4]).setAttribute('value',"px");
  break;

	default:
    d.getElementById(this.rules[r][1]).setAttribute('value','none');
    d.getElementById(this.rules[r][2]).value="";

	}

}

}

} // END

/*********** COLORS **********************************/

/*********** PADDING *********************************/

function Padding(){ this.init(); }

Padding.prototype   = {


  padding     : 'padding:',

  top         : 'padding-top:',

  right       : 'padding-right:',

  bottom      : 'padding-bottom:',

  left        : 'padding-left:',

  element     : null,

apply : function (rule, inSetting) { 

  gc.remove(this[rule]); 
  gc.apply(this[rule],inSetting); 

},

init    : function () {

this.rules  =   new Array(
            [this.padding, 'padding-number', 'padding-pixel-name'],
            [this.top, 'padding-top-number', 'padding-top-pixel-name'],
            [this.right, 'padding-right-number', 'padding-right-pixel-name'],
            [this.bottom, 'padding-bottom-number', 'padding-bottom-pixel-name'],
            [this.left, 'padding-left-number', 'padding-left-pixel-name']);

},

initArray : function (type) {

  this.element    = new Array();

  switch(type){

  case "padding":

  this.element[0]   = 'padding-number';
  this.element[1]   = 'padding-pixel-name';

  break;

  case "top":

  this.element[0]   = 'padding-top-number';
  this.element[1]   = 'padding-top-pixel-name';

  break;

  case "right":

  this.element[0]   = 'padding-right-number';
  this.element[1]   = 'padding-right-pixel-name';

  break;

  case "bottom":

  this.element[0]   = 'padding-bottom-number';
  this.element[1]   = 'padding-bottom-pixel-name';

  break;

  case "left":

  this.element[0]   = 'padding-left-number';
  this.element[1]   = 'padding-left-pixel-name';

  break;


  }


},

setControl  : function () {

	d=document;
  var r;
  var type;
  var num;

  for(r=0;r<this.rules.length;r++){

    if(gc.match(this.rules[r][0])){ 
    type  = gc.pat.test(pc.curState.curSetting[i]) ? type="px" : type="em"; 
    num   = parseInt(pc.curState.curSetting[i]); 
  
    	d.getElementById(this.rules[r][1]).setAttribute('value',num);
    	d.getElementById(this.rules[r][2]).setAttribute('value',type);
    }

		else{
    	d.getElementById(this.rules[r][1]).setAttribute('value',0);
    	d.getElementById(this.rules[r][2]).setAttribute('value',"px");
    }
		

  }

},

clearControl	: function () {

	d=document;
  for(r=0;r<this.rules.length;r++){
   	d.getElementById(this.rules[r][1]).setAttribute('value', 0);
   	d.getElementById(this.rules[r][2]).setAttribute('value', "px");
  }

}


} // END

/*********** PADDING *********************************/

/*********** MARGIN **********************************/

function Margin(){ this.init(); }

Margin.prototype  = {


  margin      : 'margin:',

  top         : 'margin-top:',

  right       : 'margin-right:',

  bottom      : 'margin-bottom:',

  left        : 'margin-left:',

  element     : null,

apply : function (rule, inSetting) { 

  gc.remove(this[rule]); 
  gc.apply(this[rule],inSetting); 

},

init    : function () {

this.rules  =   new Array(
                [this.margin, 'margin-number','margin-pixel-name'],
                [this.top, 'margin-top-number','margin-top-pixel-name'],
                [this.right, 'margin-right-number', 'margin-right-pixel-name'],
                [this.bottom, 'margin-bottom-number', 'margin-bottom-pixel-name'],
                [this.left, 'margin-left-number', 'margin-left-pixel-name']
                );

},

initArray : function (type) {

  this.element      = new Array();

  switch(type){

  case "margin":

  this.element[0]   = 'margin-number';
  this.element[1]   = 'margin-pixel-name';

  break;

  case "top":

  this.element[0]   = 'margin-top-number';
  this.element[1]   = 'margin-top-pixel-name';

  break;

  case "right":

  this.element[0]   = 'margin-right-number';
  this.element[1]   = 'margin-right-pixel-name';

  break;

  case "bottom":

  this.element[0]   = 'margin-bottom-number';
  this.element[1]   = 'margin-bottom-pixel-name';

  break;

  case "left":

  this.element[0]   = 'margin-left-number';
  this.element[1]   = 'margin-left-pixel-name';

  break;


  }


},

setControl  : function () {

	d=document;
  var r;
  var type;
  var num;

  for(r=0;r<this.rules.length;r++){

    if(gc.match(this.rules[r][0])){ 
    type  = gc.pat.test(pc.curState.curSetting[i]) ? type="px" : type="em"; 
    num   = parseInt(pc.curState.curSetting[i]); 
  
    	d.getElementById(this.rules[r][1]).setAttribute('value',num);
    	d.getElementById(this.rules[r][2]).setAttribute('value',type);
    }

		else{
    	d.getElementById(this.rules[r][1]).setAttribute('value',0);
    	d.getElementById(this.rules[r][2]).setAttribute('value',"px");
    }
		
  }

},

clearControl	: function () {

	d=document;
  for(r=0;r<this.rules.length;r++){
   	d.getElementById(this.rules[r][1]).setAttribute('value',0);
   	d.getElementById(this.rules[r][2]).setAttribute('value',"px");
  }
}

} // END

/*********** MARGIN **********************************/

/*********** BORDER **********************************/

function Border(){ this.init(); }

Border.prototype  = {


  border      : 'border:',

  top         : 'border-top:',

  right       : 'border-right:',

  bottom      : 'border-bottom:',

  left        : 'border-left:',

  element     : null,


apply : function (rule, inSetting) { 

  gc.remove(this[rule]); 
  gc.apply(this[rule],inSetting); 

},

init    : function () {

this.rules  =   new Array(

              [this.border,'border-number','border-pixel-name',
              'border-style-name','border-color','border-type-in-color'],

              [this.top,'border-top-number','border-top-pixel-name',
              'border-top-style-name','border-top-color','border-top-type-in-color'],

              [this.right,'border-right-number','border-right-pixel-name',
              'border-right-style-name','border-right-color','border-right-type-in-color'] ,         

              [this.bottom,'border-bottom-number','border-bottom-pixel-name',
              'border-bottom-style-name','border-bottom-color','border-bottom-type-in-color'], 

              [this.left,'border-left-number','border-left-pixel-name',
              'border-left-style-name','border-left-color','border-left-type-in-color']

              );

},

initArray : function (type) {

  this.element      = new Array();

  switch(type){

  case "border":

  this.element[0]   = 'border-number';
  this.element[1]   = 'border-pixel-name';
  this.element[2]   = 'border-style-name';
  this.element[3]   = 'border-color';

  break;

  case "top":

  this.element[0]   = 'border-top-number';
  this.element[1]   = 'border-top-pixel-name';
  this.element[2]   = 'border-top-style-name';
  this.element[3]   = 'border-top-color';

  break;

  case "right":

  this.element[0]   = 'border-right-number';
  this.element[1]   = 'border-right-pixel-name';
  this.element[2]   = 'border-right-style-name';
  this.element[3]   = 'border-right-color';

  break;

  case "bottom":

  this.element[0]   = 'border-bottom-number';
  this.element[1]   = 'border-bottom-pixel-name';
  this.element[2]   = 'border-bottom-style-name';
  this.element[3]   = 'border-bottom-color';

  break;

  case "left":

  this.element[0]   = 'border-left-number';
  this.element[1]   = 'border-left-pixel-name';
  this.element[2]   = 'border-left-style-name';
  this.element[3]   = 'border-left-color';

  break;


  }


},

setControl  : function () {

	d=document;
  var r;
  var retval;

  for(r=0;r<this.rules.length;r++){

    if(gc.match(this.rules[r][0])){ 
    retval  = pc.curState.curSetting[i].split(gc.pat4);
	
		if(/none/.test(retval)){
      d.getElementById(this.rules[r][1]).setAttribute('value',0);
      d.getElementById(this.rules[r][2]).setAttribute('value',"px");
      d.getElementById(this.rules[r][3]).setAttribute('value'," none ");
      d.getElementById(this.rules[r][4]).setColor('#000000');
      d.getElementById(this.rules[r][5]).setAttribute('value',"#000000");
		break;
		}

    var type    = gc.pat.test(retval[1]) ? type="px" : type="em"; 
    var num     = parseInt(retval[1]); 
    var color   = retval[3].replace(gc.pat1,"");

      d.getElementById(this.rules[r][1]).setAttribute('value',num);
      d.getElementById(this.rules[r][2]).setAttribute('value',type);
      d.getElementById(this.rules[r][3]).setAttribute('value',' '+retval[2]+' ');
      d.getElementById(this.rules[r][4]).setColor(color);
      d.getElementById(this.rules[r][5]).setAttribute('value',color);

    }

		else{
      d.getElementById(this.rules[r][1]).setAttribute('value',0);
      d.getElementById(this.rules[r][2]).setAttribute('value',"px");
      d.getElementById(this.rules[r][3]).setAttribute('value'," none ");
      d.getElementById(this.rules[r][4]).setColor('#000000');
      d.getElementById(this.rules[r][5]).setAttribute('value',"#000000");
		}

  }

},

clearControl	: function () {

	d=document;
  for(r=0;r<this.rules.length;r++){

      d.getElementById(this.rules[r][1]).setAttribute('value',0);
      d.getElementById(this.rules[r][2]).setAttribute('value',"px");
      d.getElementById(this.rules[r][3]).setAttribute('value',' none ');
      d.getElementById(this.rules[r][4]).setColor('#000000');
      d.getElementById(this.rules[r][5]).setAttribute('value','#000000');
	}

}



} // END

/*********** BORDER **********************************/

/*********** STYLE CONTROL CLASSES *******************/


/*********** I/O CLASS *******************************/

function IO () {}

IO.prototype = {

	themeName		: null,

	displayName	: null,

	email				: null,

	author			: null,

	webSite			: null,

	version			: null,

	themePath		: null,

	nestedPath	: null,

	skinDir			: null,

	oldTheme		: null,


getHomeDir	: function (){

    var DIR 		= new Components.Constructor("component://netscape/file/directory_service", "nsIProperties");
    var uh      = new DIR();

    try{
        var prop = "app.prefs.directory.5";
        var file = uh.get(prop, Components.interfaces.nsIFile);
        return file.path;
    }

    catch (err) { dump('error '+err+'\n'); }
},

getProjectDir	: function () {

	var file	=	new File(); 
	var pd		= file.append(this.getHomeDir(),'theme_projects');

	if(!file.exists(pd))
	file.mkdir(pd);

	return pd;

},

newTheme	: function (inName) {

	var file	=	new File(); 
	var td		= file.append(this.getProjectDir(),inName);

	file.mkdir(td);
	this.themePath=td;

	var sd		= file.append(td, 'source');
	file.mkdir(sd);

	td				= file.append(sd,inName);
	file.mkdir(td);

	this.nestedPath=td;

	var navDir		= file.append(this.nestedPath,'navigator');
	file.mkdir(navDir);

	this.skinDir	= file.append(navDir,'skin');
	file.mkdir(this.skinDir);

	file.mkdir(file.append(this.skinDir, 'images'));

},


getUserInfo	: function () {

	if(this.themeName)
	return true;

	else
	return false;

},

getManifest	: function () {

if(!this.getUserInfo())
return;

var manifest="";

	manifest	+= "<?xml version=\"1.0\"?>\n\n";
	manifest	+= "<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
  manifest	+= "xmlns:chrome=\"http://www.mozilla.org/rdf/chrome#\">\n\n";
  manifest	+= "<RDF:Seq about=\"urn:mozilla:skin:root\">\n";
  manifest	+= " <RDF:li resource=\"urn:mozilla:skin:"+ this.themeName +"/"+ this.version +"\" />\n";
  manifest	+= "</RDF:Seq>\n";
  manifest	+= "<RDF:Description about=\"urn:mozilla:skin:"+ this.themeName +"/"+ this.version +"\"\n";
  manifest	+= "\tchrome:displayName=\""+ this.displayName +"\"\n";
  manifest	+= "\tchrome:email=\""+ this.email +"\"\n";
  manifest	+= "\tchrome:website=\""+ this.webSite +"\"\n";
  manifest	+= "\tchrome:author=\""+ this.author +"\"\n";
  manifest	+= "\tchrome:name=\""+ this.themeName +"/"+ this.version +"\">\n";
  manifest	+= " <chrome:packages>\n";
  manifest	+= "  <RDF:Seq about=\"urn:mozilla:skin:"+ this.themeName +"/"+ this.version +":packages\">\n";
  manifest	+= "   <RDF:li resource=\"urn:mozilla:skin:"+ this.themeName +"/"+ this.version +":navigator\"/>\n";
  manifest	+= "  </RDF:Seq>\n";
  manifest	+= " </chrome:packages>\n";
  manifest	+= "</RDF:Description>\n";
	manifest	+= "</RDF:RDF>\n";


	return manifest;

},

// This is here until i can figure out how to retreive data from rdf w/o going through the UI . . .
// My plan is to get Waterson real drunk and then make him talk.
getRawData	: function () {

if(!this.getUserInfo())
return;

var rawData="";

	var file			= new File();
	var data			= file.append(this.getProjectDir(), 'user.dat');

	if(file.exists(data)){
	file.open(data, 'r')
	var load			= eval("new Array("+ file.read() +")");
	file.close();
	var comma;

		for(var i=0;i<load.length;i++){

		comma			= ",";

		if(load[i][0]!=this.themeName && load[i][0]!=this.oldTheme){

			rawData	+= "['"+ load[i][0] +"',([";

			for(d=0;d<load[i][1].length;d++){
			
			if(d==load[i][1].length-1)
			comma="";

			rawData	+= "'"+ load[i][1][d].replace("'", "\\'") +"'"+ comma;

			}

			rawData	+= "])],\n";

		}

		}

	}

	rawData	+= "['"+ this.themeName +"',(['"+ this.displayName.replace("'", "\\'") +"','";
	rawData	+= this.author.replace("'", "\\'") +"' ,'";
	rawData	+= this.email.replace("'", "\\'") +"', '";
	rawData	+= this.webSite.replace("'", "\\'") +"', '";
	rawData	+= this.version.replace("'", "\\'") +"'])]\n";

	return rawData;

},

getProjects	: function () {

if(!this.getUserInfo())
return;

var projects="";

	projects	+= "<?xml version=\"1.0\"?>\n";
	projects	+= "<rdf:RDF\n";	
	projects	+= "\txmlns:rdf       = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
	projects	+= "\txmlns:nc        = \"http://home.netscape.com/NC-rdf#\">\n";
	projects	+= "\t <rdf:Description about=\"urn:root\">\n";
	projects	+= "\t  <nc:project>\n";
	projects	+= "\t\t<rdf:Seq ID=\"root\">\n";

	var file			= new File();
	var data			= file.append(this.getProjectDir(), 'user.dat');

	if(file.exists(data)){
	file.open(data, 'r')
	var load			= eval("new Array("+ file.read() +")");

		for(var i=0;i<load.length;i++){

			if(load[i][0]!=this.themeName && load[i][0]!=this.oldTheme){

			projects	+= "\t<rdf:li>\n";
			projects	+= "\t <rdf:Description>\n";
			projects	+= "\t  <nc:themename><![CDATA["+ load[i][1][0] +"]]></nc:themename>\n";
			projects	+= "\t\t<nc:dir>"+ load[i][0] +"</nc:dir>\n";
			projects	+= "\t\t <nc:author>"+ load[i][1][1] +"</nc:author>\n";
			projects	+= "\t\t\t<nc:email><![CDATA["+ load[i][1][2] +"]]></nc:email>\n";
			projects	+= "\t\t <nc:website><![CDATA["+ load[i][1][3] +"]]></nc:website>\n";
			projects	+= "\t\t<nc:version>"+ load[i][1][4] +"</nc:version>\n";
			projects	+= "\t </rdf:Description>\n";
			projects	+= "\t</rdf:li>\n";

			}

		}

	}

	projects	+= "\t<rdf:li>\n";
	projects	+= "\t <rdf:Description>\n";
	projects	+= "\t  <nc:themename><![CDATA["+ this.displayName +"]]></nc:themename>\n";
	projects	+= "\t\t<nc:dir>"+ this.themeName +"</nc:dir>\n";
	projects	+= "\t\t <nc:author>"+ this.author +"</nc:author>\n";
	projects	+= "\t\t\t<nc:email><![CDATA["+ this.email +"]]></nc:email>\n";
	projects	+= "\t\t <nc:website><![CDATA["+ this.webSite +"]]></nc:website>\n";
	projects	+= "\t\t<nc:version>"+ this.version +"</nc:version>\n";
	projects	+= "\t </rdf:Description>\n";
	projects	+= "\t</rdf:li>\n";

	projects	+= "\t\t</rdf:Seq>\n";
	projects	+= "\t </nc:project>\n";
	projects	+= "\t</rdf:Description>\n";
	projects	+= "</rdf:RDF>";


	return projects;

},

getJs		: function () {

if(!this.getUserInfo())
return;

var instF="";

	instF	+= "\n\nvar err = initInstall(\""+ this.displayName +" v"+ this.version +"\"";
	instF	+= ", \""+ this.displayName +"\", \""+ this.version +"\");\n";
	instF	+= "logComment(\"initInstall: \" + err);\n";
	instF	+= "addFile(\""+ this.displayName +"\", \"installed-chrome.txt\", getFolder(\"Chrome\"), \"\");\n";
	instF += "var instDirectory = getFolder(\"Chrome\", \"source\");\n";
	instF	+= "addDirectory(\"\",  \"source\",\t\t\t// jar source folder\n";
	instF += "\t\tinstDirectory,              // target folder\n";
	instF += "\t\t\"\");                        // target subdir\n";
	instF += "registerChrome( PACKAGE | DELAYED_CHROME, instDirectory );\n";
	instF	+= "err = getLastError();\n";
	instF	+= "if (err==SUCCESS)\n";
	instF	+= "performInstall();\n";
	instF	+= "else\n";
	instF	+= "cancelInstall(err);\n";

	return instF;

},


getChrome		: function () {

if(!this.getUserInfo())
return;

	var instF = "skin,install,url,resource:/chrome/skins/"+ this.themeName +"/\n";
	return instF;

},

deleteTheme	: function (old){

	var file = new File();

	var dir = file.append(this.getProjectDir(), old);
	file.rmdir(dir);
	
},

editTheme	: function (old){

	this.oldTheme=null;

	if(old!=this.themeName){
	this.deleteTheme(old);
	this.oldTheme=old;
	}

	this.saveTheme();

	if(this.oldTheme)
	gc.getProjects(true);

},


saveTheme	: function () {

	this.newTheme(this.themeName);

	var file = new File();

	file.open(file.append(this.getProjectDir(),'projects.rdf'),'w');
	file.write(this.getProjects());
	file.close();

	var data	=this.getRawData();
	file.open(file.append(this.getProjectDir(),'user.dat'),'w');
	file.write(data);
	file.close();

	file.open(file.append(this.themePath,'install.js'),'w');
	file.write(this.getJs());
	file.close();

	file.open(file.append(this.themePath,'installed-chrome.txt'),'w');
	file.write(this.getChrome());
	file.close();

	file.open(file.append(this.themePath,this.themeName+'.tb'),'w');
	file.write(this.getSession());
	file.close();

	var manifest	= file.append(this.nestedPath, 'manifest.rdf');
	file.open(manifest, 'w');
	file.write(this.getManifest());
	file.close();

	file.open(file.append(this.skinDir,'navigator.css'),'w');
	file.write(this.getCss());
	file.close();

	gc.setModified(false);
	io.setToolbar();

},

getSession	: function (){

	var style		= "";
	var comma		= ",";
	var fd			= frames[0].document;

	for(i=0;i<gc.regId.length;i++){
	
	if(i==gc.regId.length-1)
	comma="";

	style	+= "['"+gc.regId[i]+"', ([";
	style	+= fd.getElementById(gc.regId[i]).getAttribute('curRule')+"]), ([";
	style	+= fd.getElementById(gc.regId[i]).getAttribute('curSetting')+"])]";
	style	+= comma+"\n";
	}

	return style;

},

getStyle	: function () {

	var style="";

	for(i=0;i<gc.regId.length;i++){
	
	style	+= "#"+gc.regId[i]+" {\n";
	style	+= frames[0].document.getElementById(gc.regId[i]).getAttribute('style');
	style	+= "}\n\n";
	}

	return style;

},

getCss	: function () {

	var css="";

	css	+= "@namespace url(\"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul\");\n";
	css += "@namespace html url(\"http://www.w3.org/TR/REC-html40\");\n\n";
	css += this.getStyle();

	return css;
	
},

setToolbar	: function (){

	document.getElementById('component-display-theme').setAttribute('value',this.displayName);
	document.getElementById('theme-name-text').setAttribute('value',this.displayName);

},

setUserInfo	: function (inObj) {

	this.themeName			= inObj.getAttribute('dir');
	this.displayName		= inObj.getAttribute('value');
	this.email					= inObj.getAttribute('email');
	this.author					= inObj.getAttribute('author');
	this.webSite				= inObj.getAttribute('website');
	this.version				= inObj.getAttribute('version');

	this.setToolbar();

},

loadSession	: function (inObj) {

	this.setUserInfo(inObj);

	if(!this.getUserInfo())
	return;

	frames[0].reset();
	pc.clear();

	var projDir		= this.getProjectDir();
	var file			= new File();
	var themeDir	= file.append(projDir, this.themeName);
	file.open(file.append(themeDir, this.themeName+'.tb'), 'r');
	var load			= eval("new Array("+ file.read() +")");
	var retval;
	var fd				= frames[0].document;
	var obj;
	var str="";

	for(i=0;i<load.length;i++){
	obj=fd.getElementById(load[i][0]);
	str="";

		for(r=0;r<load[i][1].length;r++){
		str += load[i][1][r]+load[i][2][r];
		load[i][1][r]="'"+load[i][1][r]+"'";
		load[i][2][r]="'"+load[i][2][r].replace("\n","\\n")+"'";
		}
		
	obj.setAttribute('style', str);
	obj.setAttribute('curRule',load[i][1]);
	obj.setAttribute('curSetting',load[i][2]);
	gc.registerId(load[i][0]);
	}

gc.setModified();

}
        
} // END I/O

/*********** I/O CLASS *******************************/


/*********** INSTANCE NAMES **************************/
var gc    = null; // general control
var pc    = null; // preview control
var sc    = null; // size control
var fc    = null; // font control
var cc    = null; // color control
var padc  = null; // padding control
var mc    = null; // margin control
var bc    = null; // border control
var io    = null; // border control
/*********** INSTANCE NAMES **************************/


/*********** TL FUNCTIONS ************/ 


/*********** SET RULE ****************/
function setRule(target,ruleName){

	d=document;
  var v       = 'value';
  var c       = 'color';
  var setting = "";
  var el;

  eval(ruleName+'.initArray(target)');
  for(i=0;i<eval(ruleName+'.element.length');i++){
    el      = d.getElementById(eval(ruleName+'.element[i]'));
    el.getAttribute(v) ? setting+=el.getAttribute(v) : setting+=el.getAttribute(c);
      if(el.getAttribute(v)==" none "){
      setting=el.getAttribute(v);
      break;
    	} 
  }

  eval(ruleName+'.apply(target,setting)');

}
/*********** SET RULE ****************/

/*********** IMG DIALOG **************/

function imgDialog(ID){

try {

	d=document;
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["component://mozilla/filepicker"].createInstance(nsIFilePicker);

  fp.init(window, "Get Image", nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterImages);

  if (fp.show() == nsIFilePicker.returnOK) {
    d.getElementById(ID).setAttribute('value',fp.fileURL.spec);

    if(ID=='fg-image-url')
    var rule  = "list-style-image:";      

    else
    rule      = "background-image:";

    var url   = " url("+fp.fileURL.spec+");\n";
  
    pc.newImage(rule, url);

  }

}

catch (error) { dump(error); }

}

/*********** IMG DIALOG **************/

/*********** SAVE THEME **************/

function saveTheme(){

	if(!io.getUserInfo())
	newTheme();

	else
	io.saveTheme();

}

/*********** SAVE THEME **************/

/*********** NEW THEME ***************/

function newTheme(edit){

	var x 	= window.outerWidth/2;
	var y 	= window.outerHeight/2;

	x				= (x+screenX)-175;
	y				= (y+screenY)-92;

	window.openDialog("chrome://theme_builder/content/dialogs/new_theme.xul", 
				"New_Theme", 
				"chrome,dialog,modal,screenX="+x+",screenY="+y, edit);
}
/*********** NEW THEME ***************/

/*********** EDIT THEME **************/

function editTheme(){

	if(!io.getUserInfo()){
	alert("Sorry, there is currently no theme info available.");
	return;
	}

	var edit=true;
	newTheme(edit);

}

/*********** EDIT THEME **************/



/*********** INIT ********************/ 
  
function init(component){

  dump("initializing control panels . . . \n\n");

    pc        = new PreviewControl();
    gc        = new General();
    sc        = new Size();
    fc        = new Font();
    cc        = new Color();
    padc      = new Padding();
    mc        = new Margin();
    bc        = new Border();
    io        = new IO();

    gc.component=component;
		gc.getProjects();
		d=document;
}

/*********** INIT ********************/ 

/*********** QUIT ********************/

function quit(){

  var windowManager = Components.classes['component://netscape/rdf/datasource?name=window-mediator'].getService();
  var windowManagerInterface = windowManager.QueryInterface( Components.interfaces.nsIWindowMediator);
  var enumerator = windowManagerInterface.getEnumerator( null );

  while ( enumerator.hasMoreElements()  ){

    var  windowToClose = enumerator.getNext();
    var domWindow = windowManagerInterface.convertISupportsToDOMWindow( windowToClose );
    domWindow.focus();

    if ( domWindow.tryToClose == null )
    domWindow.close();
    
    	else{

      	if ( !domWindow.tryToClose() )
      	return false;
    	}
	}
}

/*********** QUIT ********************/

/*********** INFO WINDOW *************/

function infoWindow(url){

	window.open(url, "_blank", "width=640,height=480");

}
/*********** INFO WINDOW *************/

/*********** PREVIEW *****************/

function preview(){

	var startpage		= "http://www.mozilla.org";
	window.openDialog("chrome://theme_builder/content/templates/navigator.xul", 
				"_blank", "chrome,all,dialog=no", startpage);
}

/*********** PREVIEW *****************/




/*********** TL FUNCTIONS ************/ 
