/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.ContainerView;
import netscape.application.Font;
import netscape.application.FontItem;
import netscape.application.InternalWindow;
import netscape.application.ListView;
import netscape.application.Popup;
import netscape.application.Rect;
import netscape.application.ScrollGroup;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.TargetChain;
import netscape.application.TextField;
import netscape.application.View;
import netscape.application.Window;

public class FontChooser
implements Target {
    ListView _nameList;
    Popup _sizePopup;
    Popup _stylePopup;
    TextField _sizeTextField;
    TextField _messageTextField;
    Button _setButton;
    Font _currentFont;
    private ContainerView contentView;
    private Window window;

    public FontChooser() {
        FontItem newItem;
        String[] styleArray = new String[4];
        int[] styleTagArray = new int[4];
        int[] sizeArray = new int[6];
        this.contentView = new ContainerView(0, 0, 178, 120);
        this.contentView.setBackgroundColor(Color.lightGray);
        this.contentView.setBorder(null);
        this.contentView.setHorizResizeInstruction(2);
        this.contentView.setVertResizeInstruction(16);
        ScrollGroup scrollGroup = new ScrollGroup(4, 19, 90, 61);
        scrollGroup.setHasVertScrollBar(true);
        scrollGroup.setBorder(BezelBorder.loweredBezel());
        scrollGroup.setHorizResizeInstruction(2);
        scrollGroup.setVertResizeInstruction(16);
        Rect listRect = scrollGroup.scrollView().bounds;
        this._nameList = new ListView(0, 0, listRect.width, listRect.width);
        this._nameList.setHorizResizeInstruction(2);
        this._nameList.setPrototypeItem(new FontItem());
        this._nameList.prototypeItem().setFont(Font.fontNamed("Default"));
        this._loadNameList();
        scrollGroup.setContentView(this._nameList);
        this.contentView.addSubview(scrollGroup);
        TextField textField = new TextField(28, 1, 70, 18);
        textField.setEditable(false);
        textField.setTextColor(Color.black);
        textField.setFont(Font.fontNamed("Helvetica", 1, 12));
        textField.setBackgroundColor(Color.lightGray);
        textField.setStringValue("Name");
        textField.setJustification(0);
        textField.setBorder(null);
        textField.setHorizResizeInstruction(0);
        textField.setVertResizeInstruction(4);
        this.contentView.addSubview(textField);
        this._sizePopup = new Popup(99, 19, 45, 20);
        FontItem proto = new FontItem();
        proto.setPopup(this._sizePopup);
        proto.setFont(Font.fontNamed("Default"));
        this._sizePopup.setPrototypeItem(proto);
        sizeArray[0] = 8;
        sizeArray[1] = 10;
        sizeArray[2] = 12;
        sizeArray[3] = 14;
        sizeArray[4] = 24;
        sizeArray[5] = 36;
        int count = sizeArray.length;
        ListView tmpList = this._sizePopup.popupList();
        int i = 0;
        while (i < count) {
            newItem = (FontItem)tmpList.addItem();
            newItem.setTitle(Integer.toString(sizeArray[i]));
            newItem.setTag(sizeArray[i]);
            ++i;
        }
        newItem = (FontItem)tmpList.addItem();
        newItem.setTitle("Other");
        newItem.setTag(-1);
        this._sizePopup.setTarget(this);
        this._sizePopup.setHorizResizeInstruction(1);
        this._sizePopup.setVertResizeInstruction(4);
        this.contentView.addSubview(this._sizePopup);
        this._sizeTextField = new TextField(146, 19, 25, 20);
        this._sizeTextField.setEditable(true);
        this._sizeTextField.setContentsChangedCommandAndTarget("", this);
        this._sizeTextField.setHorizResizeInstruction(1);
        this._sizeTextField.setVertResizeInstruction(4);
        this.contentView.addSubview(this._sizeTextField);
        textField = new TextField(100, 1, 30, 18);
        textField.setEditable(false);
        textField.setTextColor(Color.black);
        textField.setBackgroundColor(Color.lightGray);
        textField.setFont(Font.fontNamed("Helvetica", 1, 12));
        textField.setStringValue("Size");
        textField.setJustification(0);
        textField.setBorder(null);
        textField.setHorizResizeInstruction(1);
        textField.setVertResizeInstruction(4);
        this.contentView.addSubview(textField);
        this._stylePopup = new Popup(99, 61, 75, 21);
        proto = new FontItem();
        proto.setPopup(this._stylePopup);
        proto.setFont(Font.fontNamed("Default"));
        this._stylePopup.setPrototypeItem(proto);
        styleArray[0] = "Plain";
        styleArray[1] = "Bold";
        styleArray[2] = "Italic";
        styleArray[3] = "Bold Italic";
        styleTagArray[0] = 0;
        styleTagArray[1] = 1;
        styleTagArray[2] = 2;
        styleTagArray[3] = 3;
        count = styleArray.length;
        tmpList = this._stylePopup.popupList();
        i = 0;
        while (i < count) {
            newItem = (FontItem)tmpList.addItem();
            newItem.setTitle(styleArray[i]);
            newItem.setTag(styleTagArray[i]);
            ++i;
        }
        this._stylePopup.setHorizResizeInstruction(1);
        this._stylePopup.setVertResizeInstruction(4);
        this.contentView.addSubview(this._stylePopup);
        textField = new TextField(100, 43, 30, 18);
        textField.setEditable(false);
        textField.setTextColor(Color.black);
        textField.setBackgroundColor(Color.lightGray);
        textField.setFont(Font.fontNamed("Helvetica", 1, 12));
        textField.setStringValue("Style");
        textField.setJustification(0);
        textField.setBorder(null);
        textField.setHorizResizeInstruction(1);
        textField.setVertResizeInstruction(4);
        this.contentView.addSubview(textField);
        ContainerView ruleView = new ContainerView(-2, 87, 184, 2);
        ruleView.setHorizResizeInstruction(2);
        ruleView.setVertResizeInstruction(8);
        this.contentView.addSubview(ruleView);
        this._setButton = new Button(124, 95, 50, 21);
        this._setButton.setTitle("Set");
        this._setButton.setHorizResizeInstruction(1);
        this._setButton.setVertResizeInstruction(8);
        this._setButton.setCommand("setFont");
        this._setButton.setTarget(this);
        this.contentView.addSubview(this._setButton);
        this._messageTextField = new TextField(4, 95, 100, 21);
        this._messageTextField.setEditable(false);
        this._messageTextField.setBorder(null);
        this._messageTextField.setTextColor(Color.gray);
        this._messageTextField.setBackgroundColor(Color.lightGray);
        this._messageTextField.setFont(Font.fontNamed("Helvetica", 0, 10));
        this._messageTextField.setHorizResizeInstruction(0);
        this._messageTextField.setVertResizeInstruction(8);
        this.contentView.addSubview(this._messageTextField);
        this.setFont(Font.defaultFont());
    }

    private void _loadNameList() {
        String[] nameArray = new String[6];
        String[] fontNameArray = new String[6];
        nameArray[0] = "Courier";
        nameArray[1] = "Dialog";
        nameArray[2] = "Dialog Input";
        nameArray[3] = "Helvetica";
        nameArray[4] = "Times Roman";
        nameArray[5] = "Zapf Dingbats";
        fontNameArray[0] = "Courier";
        fontNameArray[1] = "Dialog";
        fontNameArray[2] = "DialogInput";
        fontNameArray[3] = "Helvetica";
        fontNameArray[4] = "TimesRoman";
        fontNameArray[5] = "ZapfDingbats";
        int count = nameArray.length;
        int i = 0;
        while (i < count) {
            FontItem newItem = (FontItem)this._nameList.addItem();
            newItem.setTitle(nameArray[i]);
            newItem.setFontName(fontNameArray[i]);
            ++i;
        }
        this._nameList.setRowHeight(this._nameList.minItemHeight());
        this._nameList.sizeToMinSize();
    }

    public void show() {
        if (this.window != null) {
            this.window.show();
        }
    }

    public void hide() {
        if (this.window != null) {
            this.window.hide();
        }
    }

    private void _setSizePopupToSize(int aSize) {
        int i = this._sizePopup.count();
        while (i-- > 0) {
            FontItem nextItem = (FontItem)this._sizePopup.popupList().itemAt(i);
            if (nextItem.tag() != aSize) continue;
            this._sizePopup.selectItemAt(i);
            return;
        }
        if (i == -1) {
            this._sizePopup.selectItemAt(this._sizePopup.count() - 1);
        }
    }

    public void setFont(Font aFont) {
        if (aFont == null) {
            return;
        }
        this._currentFont = aFont;
        int i = this._nameList.count();
        while (i-- > 0) {
            FontItem nextFontItem = (FontItem)this._nameList.itemAt(i);
            if (!nextFontItem.hasFontName(aFont.family())) continue;
            this._nameList.selectItemAt(i);
            this._nameList.scrollItemAtToVisible(i);
            break;
        }
        if (i == -1) {
            this._nameList.selectItemAt(0);
        }
        if (aFont.isBold()) {
            if (aFont.isItalic()) {
                this._stylePopup.selectItemAt(3);
            } else {
                this._stylePopup.selectItemAt(1);
            }
        } else if (aFont.isItalic()) {
            this._stylePopup.selectItemAt(2);
        } else {
            this._stylePopup.selectItemAt(0);
        }
        this._setSizePopupToSize(aFont.size());
        this._sizeTextField.setIntValue(aFont.size());
    }

    public Font font() {
        String name;
        if (this._nameList.selectedItem() == null) {
            name = "";
        } else {
            FontItem Item = (FontItem)this._nameList.selectedItem();
            name = Item.fontName();
        }
        Font newFont = Font.fontNamed(name, ((FontItem)this._stylePopup.selectedItem()).tag(), this._sizeTextField.intValue());
        return newFont;
    }

    public void performCommand(String command, Object data) {
        if (data == this._sizeTextField) {
            int fontSize = this._sizeTextField.intValue();
            if (fontSize > 0) {
                this._setSizePopupToSize(fontSize);
                return;
            }
            this._setSizePopupToSize(8);
            this._sizeTextField.setIntValue(8);
            return;
        }
        if (data == this._sizePopup) {
            int fontSize = ((FontItem)this._sizePopup.selectedItem()).tag();
            if (fontSize > 0) {
                this._sizeTextField.setIntValue(fontSize);
                return;
            }
        } else if (data == this._setButton) {
            TargetChain target = TargetChain.applicationChain();
            target.performCommand(command, this.font());
        }
    }

    public void setWindow(Window aWindow) {
        this.window = aWindow;
        Size windowSize = this.window.windowSizeForContentSize(this.contentView.width(), this.contentView.height());
        this.window.sizeTo(windowSize.width, windowSize.height);
        this.window.addSubview(this.contentView);
        this.window.setTitle("Font Chooser");
        Rect bounds = this.window.bounds();
        this.window.setMinSize(bounds.width, bounds.width);
        if (this.window instanceof InternalWindow) {
            InternalWindow iWindow = (InternalWindow)this.window;
            iWindow.setCloseable(true);
            iWindow.setBuffered(true);
        }
        this.window.setContainsDocument(false);
    }

    public Window window() {
        return this.window;
    }

    public View contentView() {
        return this.contentView;
    }
}

