/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import netscape.application.Application;
import netscape.application.ApplicationEvent;
import netscape.application.Event;
import netscape.application.Graphics;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.RootView;

public class FoundationPanel
extends Panel {
    RootView rootView;

    public FoundationPanel() {
        this.setRootView(new RootView());
    }

    public FoundationPanel(int width, int height) {
        this.setRootView(new RootView(0, 0, width, height));
        this.resize(width, height);
    }

    public RootView rootView() {
        return this.rootView;
    }

    public void setRootView(RootView rootView) {
        Application application = Application.application();
        if (this.rootView != null) {
            application.removeRootView(this.rootView);
        }
        this.rootView = rootView;
        rootView.setPanel(this);
        rootView.setVisible(!application.isPaused);
        application.addRootView(rootView);
    }

    public void resize(int width, int height) {
        Application app = Application.application();
        super.resize(width, height);
        if (app != null && app.eventLoop.shouldProcessSynchronously()) {
            this.rootView.processEvent(ApplicationEvent.newResizeEvent(width, height));
            return;
        }
        this.addEvent(ApplicationEvent.newResizeEvent(width, height));
    }

    public void reshape(int x, int y, int width, int height) {
        Application app = Application.application();
        super.reshape(x, y, width, height);
        if (app != null && app.eventLoop.shouldProcessSynchronously()) {
            this.rootView.processEvent(ApplicationEvent.newResizeEvent(width, height));
            return;
        }
        this.addEvent(ApplicationEvent.newResizeEvent(width, height));
    }

    public void update(java.awt.Graphics g) {
        this.paint(g);
    }

    public void paint(java.awt.Graphics g) {
        if (JDK11AirLock.isPrintGraphics(g)) {
            Application app = Application.application();
            if (app != null) {
                if (app.eventLoop.shouldProcessSynchronously()) {
                    Rect rect = new Rect(0, 0, this.rootView.width(), this.rootView.height());
                    Graphics ifcGraphics = new Graphics(rect, g);
                    this.rootView.redraw(ifcGraphics, rect);
                    this.rootView.redrawTransparentWindows(ifcGraphics, rect, null);
                    return;
                }
                ApplicationEvent event = ApplicationEvent.newPrintEvent(g);
                event.processor = this.rootView;
                app.eventLoop().addEventAndWait(event);
                return;
            }
            System.err.println("Can't print with no application");
            return;
        }
        this.addEvent(ApplicationEvent.newUpdateEvent(g));
        super.paint(g);
    }

    public boolean mouseDown(java.awt.Event evt, int x, int y) {
        this.requestFocus();
        this.addEvent(new MouseEvent(evt.when, -1, x, y, evt.modifiers));
        return true;
    }

    public boolean mouseDrag(java.awt.Event evt, int x, int y) {
        this.addEvent(new MouseEvent(evt.when, -2, x, y, evt.modifiers));
        return true;
    }

    public boolean mouseUp(java.awt.Event evt, int x, int y) {
        this.addEvent(new MouseEvent(evt.when, -3, x, y, evt.modifiers));
        return true;
    }

    public boolean mouseEnter(java.awt.Event evt, int x, int y) {
        this.addEvent(new MouseEvent(evt.when, -4, x, y, evt.modifiers));
        return true;
    }

    public boolean mouseMove(java.awt.Event evt, int x, int y) {
        this.addEvent(new MouseEvent(evt.when, -5, x, y, evt.modifiers));
        return true;
    }

    public boolean mouseExit(java.awt.Event evt, int x, int y) {
        this.addEvent(new MouseEvent(evt.when, -6, x, y, evt.modifiers));
        return true;
    }

    public boolean keyDown(java.awt.Event evt, int key) {
        if (evt.target == this) {
            this.addEvent(new KeyEvent(evt.when, key, evt.modifiers, true));
            return true;
        }
        return super.keyDown(evt, key);
    }

    public boolean keyUp(java.awt.Event evt, int key) {
        if (evt.target == this) {
            this.addEvent(new KeyEvent(evt.when, key, evt.modifiers, false));
            return true;
        }
        return super.keyUp(evt, key);
    }

    public synchronized boolean lostFocus(java.awt.Event evt, Object what) {
        this.addEvent(ApplicationEvent.newFocusEvent(false));
        return true;
    }

    public boolean gotFocus(java.awt.Event evt, Object what) {
        this.addEvent(ApplicationEvent.newFocusEvent(true));
        return true;
    }

    private synchronized void addEvent(Event anEvent) {
        if (anEvent.processor() == null) {
            anEvent.setProcessor(this.rootView);
        }
        if (this.rootView != null && this.rootView.application() != null) {
            this.rootView.application().eventLoop().addEvent(anEvent);
        }
    }

    Frame frame() {
        Container parent = this.getParent();
        while (parent != null && !(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    public void setCursor(int cursor) {
        Frame frame = this.frame();
        if (frame != null) {
            frame.setCursor(cursor);
        }
    }

    public void layout() {
    }

    public void printAll(java.awt.Graphics g) {
        this.paint(g);
    }
}

