/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.DrawingSequence;
import netscape.application.DrawingSequenceOwner;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ImageSequence
extends DrawingSequence {
    Vector imageVector;
    Image imageStrip;
    int frameWidth;
    int frameHeight;
    static final String VECTOR_KEY = "imageVector";
    static final String IMAGESTRIP_KEY = "imageStrip";
    static final String FRAMEWIDTH_KEY = "frameWidth";
    static final String FRAMEHEIGHT_KEY = "frameHeight";

    public ImageSequence() {
    }

    public ImageSequence(DrawingSequenceOwner owner) {
        super(owner);
    }

    public Vector images() {
        return this.imageVector;
    }

    public void addImage(Image anImage) {
        if (this.imageVector == null) {
            this.imageVector = new Vector();
        }
        this.imageVector.addElement(anImage);
        this.frameCount = this.imageVector.count();
    }

    public void addImagesFromName(String firstImageName, int count) {
        if (firstImageName == null || count < 0) {
            return;
        }
        Application application = Application.application();
        int periodIndex = firstImageName.lastIndexOf(46);
        if (periodIndex == -1) {
            this.addImage(Bitmap.bitmapNamed(firstImageName));
            return;
        }
        String fileType = firstImageName.substring(periodIndex);
        int nextDigitIndex = periodIndex - 1;
        int startingNumber = 0;
        int columnOffset = 1;
        while (nextDigitIndex > 0 && Character.isDigit(firstImageName.charAt(nextDigitIndex))) {
            startingNumber += columnOffset * Character.digit(firstImageName.charAt(nextDigitIndex), 10);
            columnOffset *= 10;
            --nextDigitIndex;
        }
        String namePrefix = firstImageName.substring(0, nextDigitIndex + 1);
        if (this.imageVector == null) {
            this.imageVector = new Vector();
        }
        count += startingNumber;
        int i = startingNumber;
        while (i < count) {
            this.imageVector.addElement(Bitmap.bitmapNamed(String.valueOf(namePrefix) + i + fileType));
            ++i;
        }
        this.frameCount = this.imageVector.count();
    }

    public void removeImage(Image anImage) {
        if (this.imageVector != null) {
            this.imageVector.removeElement(anImage);
            this.frameCount = this.imageVector.count();
        }
    }

    public void removeAllImages() {
        if (this.imageVector != null) {
            this.imageVector.removeAllElements();
        }
        this.imageStrip = null;
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public void setImageStrip(Image anImage) {
        this.imageStrip = anImage;
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public Image imageStrip() {
        return this.imageStrip;
    }

    public void setFrameWidth(int pixels) {
        if (pixels < 0) {
            pixels = 0;
        }
        this.frameWidth = pixels;
        if (this.frameWidth > 0 && this.imageStrip != null) {
            this.frameCount = this.imageStrip.width() / this.frameWidth;
            return;
        }
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public int frameWidth() {
        return this.frameWidth;
    }

    public void setFrameHeight(int pixels) {
        if (pixels < 0) {
            pixels = 0;
        }
        this.frameHeight = pixels;
        if (this.frameHeight > 0 && this.imageStrip != null) {
            this.frameCount = this.imageStrip.height() / this.frameHeight;
            return;
        }
        this.frameCount = 0;
        this.currentFrameNumber = 0;
    }

    public int frameHeight() {
        return this.frameHeight;
    }

    public int imageCount() {
        return this.frameCount();
    }

    public void setCurrentImageNumber(int imageNumber) {
        if (imageNumber < 0) {
            imageNumber = 0;
        } else if (imageNumber >= this.frameCount) {
            imageNumber = this.frameCount - 1;
        }
        this.currentFrameNumber = imageNumber;
    }

    public Image currentImage() {
        if (this.imageVector != null) {
            return (Image)this.imageVector.elementAt(this.currentFrameNumber);
        }
        return this.imageStrip;
    }

    public Size maxSize() {
        if (this.imageStrip != null) {
            if (this.frameWidth > 0) {
                return new Size(this.frameWidth, this.imageStrip.height());
            }
            if (this.frameHeight > 0) {
                return new Size(this.imageStrip.width(), this.frameHeight);
            }
        } else if (this.imageVector != null && !this.imageVector.isEmpty()) {
            int maxHeight = 0;
            int maxWidth = 0;
            int i = this.imageVector.count();
            while (i-- > 0) {
                Image nextImage = (Image)this.imageVector.elementAt(i);
                if (nextImage.width() > maxWidth) {
                    maxWidth = nextImage.width();
                }
                if (nextImage.height() <= maxHeight) continue;
                maxHeight = nextImage.height();
            }
            return new Size(maxWidth, maxHeight);
        }
        return new Size(0, 0);
    }

    public int width() {
        int maxWidth = 0;
        if (this.imageStrip != null) {
            if (this.frameWidth > 0) {
                return this.frameWidth;
            }
            return this.imageStrip.width();
        }
        if (this.imageVector == null) {
            return 0;
        }
        int i = this.imageVector.count();
        while (i-- > 0) {
            Image nextImage = (Image)this.imageVector.elementAt(i);
            if (nextImage.width() <= maxWidth) continue;
            maxWidth = nextImage.width();
        }
        return maxWidth;
    }

    public int height() {
        int maxHeight = 0;
        if (this.imageStrip != null) {
            if (this.frameHeight > 0) {
                return this.frameHeight;
            }
            return this.imageStrip.height();
        }
        if (this.imageVector == null) {
            return 0;
        }
        int i = this.imageVector.count();
        while (i-- > 0) {
            Image nextImage = (Image)this.imageVector.elementAt(i);
            if (nextImage.height() <= maxHeight) continue;
            maxHeight = nextImage.height();
        }
        return maxHeight;
    }

    public void drawAt(Graphics g, int x, int y) {
        if (this.imageVector != null) {
            Image nextImage = (Image)this.imageVector.elementAt(this.currentFrameNumber);
            if (nextImage != null) {
                nextImage.drawAt(g, x, y);
                return;
            }
        } else {
            if (this.frameWidth > 0) {
                Rect tmpRect = Rect.newRect(x, y, this.frameWidth, this.imageStrip.height());
                g.pushState();
                g.setClipRect(tmpRect);
                this.imageStrip.drawAt(g, x - this.frameWidth * this.currentFrameNumber, y);
                g.popState();
                Rect.returnRect(tmpRect);
                return;
            }
            if (this.frameHeight > 0) {
                Rect tmpRect = Rect.newRect(x, y, this.imageStrip.width(), this.frameHeight);
                g.pushState();
                g.setClipRect(tmpRect);
                this.imageStrip.drawAt(g, x, y - this.frameHeight * this.currentFrameNumber);
                g.popState();
                Rect.returnRect(tmpRect);
            }
        }
    }

    public void drawScaled(Graphics g, int x, int y, int width, int height) {
        if (this.imageVector != null) {
            Image nextImage = (Image)this.imageVector.elementAt(this.currentFrameNumber);
            if (nextImage != null) {
                nextImage.drawCentered(g, x, y, width, height);
                return;
            }
        } else {
            if (this.frameWidth > 0) {
                Rect tmpRect = Rect.newRect(x += (width - this.frameWidth) / 2, y += (height - this.imageStrip.height()) / 2, this.frameWidth, this.imageStrip.height());
                g.pushState();
                g.setClipRect(tmpRect);
                this.imageStrip.drawAt(g, x - this.frameWidth * this.currentFrameNumber, y);
                g.popState();
                Rect.returnRect(tmpRect);
                return;
            }
            if (this.frameHeight > 0) {
                Rect tmpRect = Rect.newRect(x += (width - this.imageStrip.width()) / 2, y += (height - this.frameHeight) / 2, this.imageStrip.width(), this.frameHeight);
                g.pushState();
                g.setClipRect(tmpRect);
                this.imageStrip.drawAt(g, x, y - this.frameHeight * this.currentFrameNumber);
                g.popState();
                Rect.returnRect(tmpRect);
            }
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ImageSequence", 1);
        info.addField(VECTOR_KEY, (byte)18);
        info.addField(IMAGESTRIP_KEY, (byte)18);
        info.addField(FRAMEWIDTH_KEY, (byte)8);
        info.addField(FRAMEHEIGHT_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(VECTOR_KEY, this.imageVector);
        encoder.encodeObject(IMAGESTRIP_KEY, this.imageStrip);
        encoder.encodeInt(FRAMEWIDTH_KEY, this.frameWidth);
        encoder.encodeInt(FRAMEHEIGHT_KEY, this.frameHeight);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.imageVector = (Vector)decoder.decodeObject(VECTOR_KEY);
        this.imageStrip = (Image)decoder.decodeObject(IMAGESTRIP_KEY);
        this.frameWidth = decoder.decodeInt(FRAMEWIDTH_KEY);
        this.frameHeight = decoder.decodeInt(FRAMEHEIGHT_KEY);
    }
}

