/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.MenuView;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class InternalWindowBorder
extends Border {
    Image indentLeftImage;
    Image indentRightImage;
    Image leftResizeImage;
    Image rightResizeImage;
    InternalWindow window;
    static final int TITLE_BAR_INDENT_OFFSET = 1;
    static final String WINDOW_KEY = "window";

    public InternalWindowBorder() {
        this(null);
    }

    public InternalWindowBorder(InternalWindow aWindow) {
        this.window = aWindow;
        this.indentLeftImage = Bitmap.bitmapNamed("netscape/application/TitleBarLeft.gif");
        this.indentRightImage = Bitmap.bitmapNamed("netscape/application/TitleBarRight.gif");
        this.leftResizeImage = Bitmap.bitmapNamed("netscape/application/ResizeLeft.gif");
        this.rightResizeImage = Bitmap.bitmapNamed("netscape/application/ResizeRight.gif");
    }

    public void setWindow(InternalWindow aWindow) {
        this.window = aWindow;
    }

    public InternalWindow window() {
        return this.window;
    }

    public int leftMargin() {
        return 3;
    }

    public int rightMargin() {
        return 2;
    }

    public int topMargin() {
        return 22;
    }

    public int bottomMargin() {
        if (this.window.isResizable()) {
            return 11;
        }
        return 2;
    }

    public int resizePartWidth() {
        if (!this.window.isResizable()) {
            return 0;
        }
        return this.leftResizeImage.width();
    }

    public void drawTitleBar(Graphics g, int x, int y, int width, int height) {
        Rect tmpRect;
        int topMargin = this.topMargin();
        Rect titleBarRect = Rect.newRect(x, y, width, topMargin);
        if (!g.clipRect().intersects(titleBarRect)) {
            Rect.returnRect(titleBarRect);
            return;
        }
        Rect.returnRect(titleBarRect);
        int maxX = width - 1;
        int maxY = topMargin - 1;
        g.setColor(Color.lightGray);
        g.fillRect(x + 1, y + 1, maxX - 1, maxY - 1);
        g.setColor(Color.gray153);
        g.drawPoint(x, y);
        g.drawLine(x + 1, y, maxX, y);
        g.drawPoint(x + 1, maxY);
        g.drawLine(x, y + 1, x, maxY);
        g.setColor(Color.white);
        g.drawLine(x + 2, y + 1, maxX - 2, y + 1);
        g.drawPoint(x + 2, y + 2);
        g.drawLine(x + 1, y + 2, x + 1, maxY - 2);
        g.setColor(Color.gray153);
        g.drawLine(x + 2, maxY - 1, maxX - 2, maxY - 1);
        g.drawPoint(maxX - 2, maxY - 2);
        g.drawLine(maxX - 1, y + 2, maxX - 1, maxY - 2);
        g.setColor(Color.gray102);
        g.drawLine(x + 2, maxY, maxX, maxY);
        g.drawLine(maxX, y + 1, maxX, maxY);
        g.drawPoint(maxX - 1, maxY - 1);
        int imageX = 25 + this.indentLeftImage.width();
        int imageWidth = width - 25 - this.indentRightImage.width() - imageX;
        boolean isMain = this.window.isMain();
        if (isMain) {
            this.indentLeftImage.drawAt(g, 25, 1);
            this.indentRightImage.drawAt(g, width - this.indentRightImage.width() - 24, 1);
            tmpRect = Rect.newRect(imageX, 3, imageWidth, this.indentLeftImage.height() - 4);
            g.setColor(Color.gray153);
            g.drawLine(tmpRect.x, tmpRect.y + 1, tmpRect.maxX(), tmpRect.y + 1);
            g.setColor(Color.white);
            g.drawLine(tmpRect.x + 1, tmpRect.maxY() - 2, tmpRect.maxX(), tmpRect.maxY() - 2);
            Rect.returnRect(tmpRect);
        }
        tmpRect = Rect.newRect(imageX, 0, imageWidth, this.indentLeftImage.height() - 2);
        g.pushState();
        g.setClipRect(tmpRect);
        g.setColor(Color.darkGray);
        g.setFont(this.window.font());
        g.drawStringInRect(this.window.title(), tmpRect, 1);
        g.popState();
        Rect.returnRect(tmpRect);
    }

    public void drawLeftBorder(Graphics g, int x, int y, int width, int height) {
        Rect borderRect = Rect.newRect(0, 0, this.leftMargin(), height);
        if (!g.clipRect().intersects(borderRect)) {
            Rect.returnRect(borderRect);
            return;
        }
        Rect.returnRect(borderRect);
        int startY = this.topMargin();
        g.setColor(Color.gray153);
        g.drawLine(0, startY, 0, height - 1);
        g.setColor(Color.white);
        g.drawLine(1, startY, 1, height - 2);
        g.setColor(Color.lightGray);
        g.drawLine(2, startY, 2, height - 3);
        MenuView menuView = this.window.menuView();
        if (menuView != null) {
            g.setColor(Color.gray102);
            g.drawLine(1, startY + menuView.height() - 1, 2, startY + menuView.height() - 1);
        }
    }

    public void drawRightBorder(Graphics g, int x, int y, int width, int height) {
        Rect borderRect = Rect.newRect(width - this.rightMargin(), 0, this.rightMargin(), height);
        if (!g.clipRect().intersects(borderRect)) {
            Rect.returnRect(borderRect);
            return;
        }
        Rect.returnRect(borderRect);
        int startY = this.topMargin();
        int bottomY = height - this.bottomMargin();
        g.setColor(Color.gray102);
        g.drawLine(width - 1, startY, width - 1, bottomY);
        g.setColor(Color.gray153);
        g.drawLine(width - 2, startY, width - 2, bottomY - 1);
        MenuView menuView = this.window.menuView();
        if (menuView != null) {
            g.setColor(Color.gray102);
            g.drawPoint(x + width - 2, startY + menuView.height() - 1);
        }
    }

    public void drawBottomBorder(Graphics g, int x, int y, int width, int height) {
        Rect borderRect = Rect.newRect(0, height - this.bottomMargin(), width, this.bottomMargin());
        if (!g.clipRect().intersects(borderRect)) {
            Rect.returnRect(borderRect);
            return;
        }
        Rect.returnRect(borderRect);
        int marginHeight = this.bottomMargin();
        int startY = height - marginHeight;
        g.setColor(Color.gray102);
        g.drawLine(1, height - 1, width - 1, height - 1);
        g.setColor(Color.gray153);
        g.drawLine(2, height - 2, width - 2, height - 2);
        g.setColor(Color.lightGray);
        g.fillRect(2, startY, width - 3, marginHeight - 2);
        g.setColor(Color.gray102);
        g.drawLine(width - 1, startY, width - 1, height - 1);
        g.setColor(Color.gray153);
        g.drawLine(width - 2, startY, width - 2, height - 2);
        if (this.window.isResizable() && this.leftResizeImage != null && this.rightResizeImage != null) {
            this.leftResizeImage.drawAt(g, 0, height - this.leftResizeImage.height());
            this.rightResizeImage.drawAt(g, width - this.rightResizeImage.width(), height - this.rightResizeImage.height());
        }
    }

    public void drawInRect(Graphics g, int x, int y, int width, int height) {
        this.drawTitleBar(g, x, y, width, height);
        this.drawLeftBorder(g, x, y, width, height);
        this.drawRightBorder(g, x, y, width, height);
        this.drawBottomBorder(g, x, y, width, height);
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.InternalWindowBorder", 1);
        info.addField(WINDOW_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(WINDOW_KEY, this.window);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.window = (InternalWindow)decoder.decodeObject(WINDOW_KEY);
    }
}

