/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.ListView;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class ListItem
implements Cloneable,
Codable {
    ListView listView;
    String command;
    String title;
    Font font;
    Color selectedColor = Color.white;
    Color textColor = Color.black;
    Image image;
    Image selectedImage;
    boolean selected;
    boolean enabled = true;
    Object data;
    static final String LISTVIEW_KEY = "listView";
    static final String COMMAND_KEY = "command";
    static final String TITLE_KEY = "title";
    static final String FONT_KEY = "font";
    static final String SELECTEDCOLOR_KEY = "selectedColor";
    static final String TEXTCOLOR_KEY = "textColor";
    static final String IMAGE_KEY = "image";
    static final String SELECTEDIMAGE_KEY = "selectedImage";
    static final String SELECTED_KEY = "selected";
    static final String ENABLED_KEY = "enabled";
    static final String DATA_KEY = "data";
    static final String VER_2_TEXTCOLOR_KEY = "foregroundColor";

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InconsistencyException(String.valueOf(this) + ": clone() not supported :" + e);
        }
    }

    void setListView(ListView aListView) {
        this.listView = aListView;
    }

    public ListView listView() {
        return this.listView;
    }

    public boolean isTransparent() {
        return !this.selected;
    }

    public void setCommand(String newCommand) {
        this.command = newCommand;
    }

    public String command() {
        return this.command;
    }

    public void setTitle(String aString) {
        this.title = aString;
    }

    public String title() {
        return this.title;
    }

    public void setSelected(boolean flag) {
        if (!this.enabled) {
            flag = false;
        }
        this.selected = flag;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        if (!this.enabled) {
            this.selected = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setImage(Image anImage) {
        this.image = anImage;
    }

    public Image image() {
        return this.image;
    }

    public void setSelectedImage(Image anImage) {
        this.selectedImage = anImage;
    }

    public Image selectedImage() {
        return this.selectedImage;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
    }

    public Font font() {
        if (this.font == null) {
            this.font = Font.defaultFont();
        }
        return this.font;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public Color selectedColor() {
        return this.selectedColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color textColor() {
        return this.textColor;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object data() {
        return this.data;
    }

    public int minWidth() {
        Font font;
        int width = 0;
        if (this.image != null) {
            width = this.image.width();
        }
        if (this.selectedImage != null && this.selectedImage.width() > width) {
            width = this.selectedImage.width();
        }
        if ((font = this.font()) != null) {
            width += font.fontMetrics().stringWidth(this.title);
        }
        if (width > 0) {
            width += 3;
        }
        return width;
    }

    public int minHeight() {
        Font font;
        int height = 0;
        int titleHeight = 0;
        if (this.image != null) {
            height = this.image.height();
        }
        if (this.selectedImage != null && this.selectedImage.height() > height) {
            height = this.selectedImage.height();
        }
        if ((font = this.font()) != null) {
            titleHeight = font.fontMetrics().stringHeight();
        }
        if (titleHeight > height) {
            height = titleHeight;
        }
        return height;
    }

    protected void drawBackground(Graphics g, Rect boundsRect) {
        if (this.selected) {
            g.setColor(this.selectedColor);
            g.fillRect(boundsRect);
        }
    }

    protected void drawStringInRect(Graphics g, String title, Font titleFont, Rect textBounds, int justification) {
        if (this.listView().isEnabled() && this.enabled) {
            g.setColor(this.textColor);
        } else {
            g.setColor(Color.gray);
        }
        g.setFont(titleFont);
        g.drawStringInRect(title, textBounds, justification);
    }

    public void drawInRect(Graphics g, Rect boundsRect) {
        this.drawBackground(g, boundsRect);
        Image theImage = this.selected ? this.selectedImage : this.image;
        int height = 0;
        int width = 0;
        if (this.image != null) {
            width = this.image.width();
            height = this.image.height();
        }
        if (this.selectedImage != null) {
            if (this.selectedImage.width() > width) {
                width = this.selectedImage.width();
            }
            if (this.selectedImage.height() > height) {
                height = this.selectedImage.height();
            }
        }
        if (theImage != null) {
            theImage.drawAt(g, boundsRect.x, boundsRect.y + (boundsRect.height - height) / 2);
        }
        if (this.title != null && this.title.length() > 0) {
            Rect tmpRect = Rect.newRect(boundsRect.x + 2 + width, boundsRect.y, boundsRect.width - 2 - width, boundsRect.height);
            this.drawStringInRect(g, this.title, this.font(), tmpRect, 0);
            Rect.returnRect(tmpRect);
        }
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.ListItem", 3);
        info.addField(LISTVIEW_KEY, (byte)18);
        info.addField(COMMAND_KEY, (byte)16);
        info.addField(TITLE_KEY, (byte)16);
        info.addField(FONT_KEY, (byte)18);
        info.addField(SELECTEDCOLOR_KEY, (byte)18);
        info.addField(IMAGE_KEY, (byte)18);
        info.addField(SELECTEDIMAGE_KEY, (byte)18);
        info.addField(SELECTED_KEY, (byte)0);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(DATA_KEY, (byte)18);
        info.addField(TEXTCOLOR_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(LISTVIEW_KEY, this.listView);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeString(TITLE_KEY, this.title);
        encoder.encodeObject(FONT_KEY, this.font);
        encoder.encodeObject(SELECTEDCOLOR_KEY, this.selectedColor);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeObject(SELECTEDIMAGE_KEY, this.selectedImage);
        encoder.encodeBoolean(SELECTED_KEY, this.selected);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        if (this.data != null && this.data instanceof Codable) {
            encoder.encodeObject(DATA_KEY, this.data);
        } else {
            encoder.encodeObject(DATA_KEY, null);
        }
        encoder.encodeObject(TEXTCOLOR_KEY, this.textColor);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.listView = (ListView)decoder.decodeObject(LISTVIEW_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.title = decoder.decodeString(TITLE_KEY);
        this.font = (Font)decoder.decodeObject(FONT_KEY);
        this.selectedColor = (Color)decoder.decodeObject(SELECTEDCOLOR_KEY);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.selectedImage = (Image)decoder.decodeObject(SELECTEDIMAGE_KEY);
        this.selected = decoder.decodeBoolean(SELECTED_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.data = decoder.decodeObject(DATA_KEY);
        if (decoder.versionForClassName("netscape.application.ListItem") == 2) {
            this.textColor = (Color)decoder.decodeObject(VER_2_TEXTCOLOR_KEY);
            return;
        }
        if (decoder.versionForClassName("netscape.application.ListItem") > 2) {
            this.textColor = (Color)decoder.decodeObject(TEXTCOLOR_KEY);
        }
    }

    public void finishDecoding() throws CodingException {
    }
}

