/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.ExtendedTarget;
import netscape.application.ExternalWindow;
import netscape.application.InternalWindow;
import netscape.application.RootView;
import netscape.application.Target;
import netscape.application.View;
import netscape.application.Window;
import netscape.application.WindowOwner;
import netscape.util.Vector;

public class TargetChain
implements ExtendedTarget {
    private Vector preTargets = new Vector();
    private Vector postTargets = new Vector();
    private static TargetChain applicationChain;

    private TargetChain() {
    }

    public static TargetChain applicationChain() {
        if (applicationChain == null) {
            applicationChain = new TargetChain();
        }
        return applicationChain;
    }

    public synchronized void addTarget(ExtendedTarget target, boolean atFront) {
        if (atFront) {
            this.preTargets.insertElementAt(target, 0);
            return;
        }
        this.postTargets.addElement(target);
    }

    public synchronized void removeTarget(ExtendedTarget target) {
        this.preTargets.removeElement(target);
        this.postTargets.removeElement(target);
    }

    public synchronized Target targetForCommand(String command) {
        WindowOwner firstOwner;
        Window firstWindow;
        View focusedView;
        RootView firstRootView;
        ExtendedTarget target;
        int size = this.preTargets.size();
        int i = 0;
        while (i < size) {
            target = (ExtendedTarget)this.preTargets.elementAt(i);
            if (target.canPerformCommand(command)) {
                return target;
            }
            ++i;
        }
        Application app = Application.application();
        View modalView = app.modalView();
        if (modalView == null) {
            firstRootView = app.firstRootView();
            if (firstRootView != null && this.objectCanPerformCommand(focusedView = firstRootView.focusedView(), command)) {
                return (Target)((Object)focusedView);
            }
            Window documentWindow = app.currentDocumentWindow();
            if (documentWindow != null) {
                focusedView = documentWindow instanceof InternalWindow ? ((InternalWindow)documentWindow).focusedView() : ((ExternalWindow)documentWindow).rootView().focusedView();
                if (this.objectCanPerformCommand(focusedView, command)) {
                    return (Target)((Object)focusedView);
                }
                WindowOwner documentOwner = documentWindow.owner();
                if (this.objectCanPerformCommand(documentOwner, command)) {
                    return (Target)((Object)documentOwner);
                }
                if (this.objectCanPerformCommand(documentWindow, command)) {
                    return documentWindow;
                }
            } else {
                RootView mainRootView = app.mainRootView();
                if (mainRootView != null && this.objectCanPerformCommand(focusedView = mainRootView.mainWindow() == null ? mainRootView.focusedView() : mainRootView.rootViewFocusedView(), command)) {
                    return (Target)((Object)focusedView);
                }
            }
            if (firstRootView != null) {
                firstWindow = firstRootView.externalWindow();
                if (firstWindow != null) {
                    firstOwner = firstWindow.owner();
                    if (this.objectCanPerformCommand(firstOwner, command)) {
                        return (Target)((Object)firstOwner);
                    }
                    if (this.objectCanPerformCommand(firstWindow, command)) {
                        return firstWindow;
                    }
                }
                if (this.objectCanPerformCommand(firstRootView, command)) {
                    return firstRootView;
                }
            }
            if (this.objectCanPerformCommand(app, command)) {
                return (Target)((Object)app);
            }
        } else {
            if (modalView instanceof RootView) {
                firstRootView = (RootView)modalView;
                focusedView = firstRootView.focusedView();
                firstWindow = firstRootView.externalWindow();
            } else if (modalView instanceof InternalWindow) {
                firstRootView = null;
                focusedView = ((InternalWindow)modalView).focusedView();
                firstWindow = (Window)((Object)modalView);
            } else {
                firstRootView = null;
                focusedView = modalView;
                firstWindow = null;
            }
            if (this.objectCanPerformCommand(focusedView, command)) {
                return (Target)((Object)focusedView);
            }
            if (firstWindow != null) {
                firstOwner = firstWindow.owner();
                if (this.objectCanPerformCommand(firstOwner, command)) {
                    return (Target)((Object)firstOwner);
                }
                if (this.objectCanPerformCommand(firstWindow, command)) {
                    return firstWindow;
                }
            }
            if (firstRootView != null && this.objectCanPerformCommand(firstRootView, command)) {
                return firstRootView;
            }
        }
        size = this.postTargets.size();
        i = 0;
        while (i < size) {
            target = (ExtendedTarget)this.postTargets.elementAt(i);
            if (target.canPerformCommand(command)) {
                return target;
            }
            ++i;
        }
        return null;
    }

    public boolean canPerformCommand(String command) {
        return this.targetForCommand(command) != null;
    }

    public void performCommand(String command, Object data) {
        Target target = this.targetForCommand(command);
        if (target != null) {
            target.performCommand(command, data);
        }
    }

    private boolean objectCanPerformCommand(Object anObject, String command) {
        return anObject != null && anObject instanceof ExtendedTarget && ((ExtendedTarget)anObject).canPerformCommand(command);
    }
}

