/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.TextParagraphFormat;
import netscape.application.TextView;
import netscape.application.TextViewHTMLContainer;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class TextViewHTMLContainerImp
extends TextViewHTMLContainer {
    static String[] markersStartingWithDoubleCarriageReturn = new String[]{"H1", "H2", "H3", "H4", "H5", "H6", "BLOCKQUOTE", "DL"};
    static String[] markersEndingWithDoubleCarriageReturn = new String[]{"H1", "H2", "H3", "H4", "H5", "H6", "BLOCKQUOTE", "DL"};
    static String[] markersStartingWithCarriageReturn = new String[]{"CENTER", "PRE", "OL", "UL", "MENU", "DIR", "ADDRESS", "P"};
    static String[] markersEndingWithCarriageReturn = new String[]{"CENTER", "PRE", "ADDRESS", "LI", "P"};
    static String[] markersStartingWithCarriageReturnOptionaly = new String[]{"DT", "DD"};
    static final String LIST_CONTEXT = "listctxt";

    private String currentListMarker(Hashtable context) {
        Vector v = (Vector)context.get(LIST_CONTEXT);
        if (v == null) {
            return null;
        }
        Vector m = (Vector)v.lastElement();
        if (m == null || m.count() != 2) {
            return null;
        }
        return (String)m.elementAt(0);
    }

    private int levelOfCurrentListMarker(Hashtable context) {
        Vector v = (Vector)context.get(LIST_CONTEXT);
        if (v == null) {
            return 1;
        }
        return v.count();
    }

    private void addListInContext(String aMarker, Hashtable context) {
        Vector v = (Vector)context.get(LIST_CONTEXT);
        Vector m = new Vector();
        m.addElement(aMarker);
        m.addElement("0");
        if (v != null) {
            v.addElement(m);
            return;
        }
        v = new Vector();
        v.addElement(m);
        context.put(LIST_CONTEXT, v);
    }

    private void removeLastListFromContext(Hashtable context) {
        Vector m;
        Vector v = (Vector)context.get(LIST_CONTEXT);
        if (v != null && (m = (Vector)v.lastElement()) != null) {
            v.removeLastElement();
        }
    }

    private void bumpNumberOfListItemProcessed(Hashtable context) {
        Vector m;
        Vector v = (Vector)context.get(LIST_CONTEXT);
        if (v != null && (m = (Vector)v.lastElement()) != null) {
            String n = (String)m.elementAt(1);
            n = String.valueOf(Integer.parseInt((String)m.elementAt(1)) + 1);
            m.removeLastElement();
            m.addElement(n);
        }
    }

    private int numberOfListItemProcessed(Hashtable context) {
        Vector m;
        Vector v = (Vector)context.get(LIST_CONTEXT);
        if (v != null && (m = (Vector)v.lastElement()) != null) {
            return Integer.parseInt((String)m.elementAt(1));
        }
        return 0;
    }

    public String prefix(Hashtable context, char lastChar) {
        if (this.marker.equals("LI")) {
            String markerType = this.currentListMarker(context);
            if (markerType == null) {
                return null;
            }
            FastStringBuffer lfb = new FastStringBuffer();
            int level = this.levelOfCurrentListMarker(context);
            int i = 0;
            while (i < level) {
                lfb.append("\t");
                ++i;
            }
            if (markerType.equals("OL")) {
                return String.valueOf(lfb.toString()) + (this.numberOfListItemProcessed(context) + 1) + ". ";
            }
            return String.valueOf(lfb.toString()) + "\u00b7 ";
        }
        int i = 0;
        int c = markersStartingWithDoubleCarriageReturn.length;
        while (i < c) {
            if (markersStartingWithDoubleCarriageReturn[i].equals(this.marker)) {
                if (lastChar != '\n') {
                    return "\n\n";
                }
                return "\n";
            }
            ++i;
        }
        i = 0;
        c = markersStartingWithCarriageReturn.length;
        while (i < c) {
            if (markersStartingWithCarriageReturn[i].equals(this.marker)) {
                return "\n";
            }
            ++i;
        }
        if (lastChar != '\n') {
            i = 0;
            c = markersStartingWithCarriageReturnOptionaly.length;
            while (i < c) {
                if (markersStartingWithCarriageReturnOptionaly[i].equals(this.marker)) {
                    return "\n";
                }
                ++i;
            }
        }
        return "";
    }

    public String suffix(Hashtable context, char lastChar) {
        int i = 0;
        int c = markersEndingWithDoubleCarriageReturn.length;
        while (i < c) {
            if (markersEndingWithDoubleCarriageReturn[i].equals(this.marker)) {
                if (lastChar != '\n') {
                    return "\n\n";
                }
                return "\n";
            }
            ++i;
        }
        i = 0;
        c = markersEndingWithCarriageReturn.length;
        while (i < c) {
            if (markersEndingWithCarriageReturn[i].equals(this.marker)) {
                return "\n";
            }
            ++i;
        }
        return "";
    }

    public void setupContext(Hashtable context) {
        if (this.marker.equals("OL") || this.marker.equals("UL") || this.marker.equals("DIR") || this.marker.equals("MENU")) {
            this.addListInContext(this.marker, context);
            return;
        }
        if (this.marker.equals("LI") && this.currentListMarker(context) != null) {
            this.bumpNumberOfListItemProcessed(context);
        }
    }

    public void cleanupContext(Hashtable context) {
        if (this.marker.equals("OL") || this.marker.equals("UL") || this.marker.equals("DIR") || this.marker.equals("MENU")) {
            this.removeLastListFromContext(context);
        }
    }

    public String string(Hashtable context) {
        if (this.marker.equals("TITLE")) {
            return "";
        }
        return super.string(context);
    }

    public Hashtable attributesForContents(Hashtable context, Hashtable initialAttributes, TextView textView) {
        String v;
        Hashtable attr;
        TextParagraphFormat pf;
        Font f;
        Hashtable newAttr;
        Font defaultFont = Font.defaultFont();
        if (initialAttributes != null && initialAttributes.count() > 0) {
            newAttr = (Hashtable)TextView.hashtablePool.allocateObject();
            Enumeration enumeration = initialAttributes.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                newAttr.put(key, initialAttributes.get(key));
            }
        } else {
            newAttr = (Hashtable)TextView.hashtablePool.allocateObject();
        }
        if (this.marker.equals("H1")) {
            newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, 24));
        } else if (this.marker.equals("H2")) {
            newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, 18));
        } else if (this.marker.equals("H3")) {
            newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, 16));
        } else if (this.marker.equals("H4")) {
            newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, 12));
        } else if (this.marker.equals("H5")) {
            newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, 10));
        } else if (this.marker.equals("H6")) {
            newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, 8));
        } else if (this.marker.equals("B") || this.marker.equals("STRONG")) {
            f = (Font)newAttr.get("FontKey");
            if (f != null) {
                if (!f.isBold()) {
                    newAttr.put("FontKey", Font.fontNamed(f.name(), f.style() | 1, f.size()));
                }
            } else {
                newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 1, defaultFont.size()));
            }
        } else if (this.marker.equals("CENTER")) {
            pf = (TextParagraphFormat)newAttr.get("ParagraphFormatKey");
            TextParagraphFormat centerFormat = pf != null ? (TextParagraphFormat)pf.clone() : (TextParagraphFormat)((TextParagraphFormat)initialAttributes.get("ParagraphFormatKey")).clone();
            centerFormat.setJustification(1);
            newAttr.put("ParagraphFormatKey", centerFormat);
        } else if (this.marker.equals("BLOCKQUOTE") || this.marker.equals("DD")) {
            pf = (TextParagraphFormat)newAttr.get("ParagraphFormatKey");
            TextParagraphFormat indentFormat = pf != null ? (TextParagraphFormat)pf.clone() : (TextParagraphFormat)((TextParagraphFormat)initialAttributes.get("ParagraphFormatKey")).clone();
            indentFormat.setLeftMargin(50);
            newAttr.put("ParagraphFormatKey", indentFormat);
        } else if (this.marker.equals("EM") || this.marker.equals("I") || this.marker.equals("ADDRESS") || this.marker.equals("VAR") || this.marker.equals("CITE")) {
            f = (Font)newAttr.get("FontKey");
            if (f != null) {
                if (!f.isItalic()) {
                    newAttr.put("FontKey", Font.fontNamed(f.name(), f.style() | 2, f.size()));
                }
            } else {
                newAttr.put("FontKey", Font.fontNamed(defaultFont.name(), 2, defaultFont.size()));
            }
        } else if (this.marker.equals("PRE")) {
            f = (Font)newAttr.get("FontKey");
            TextParagraphFormat defaultFormat = (TextParagraphFormat)((TextParagraphFormat)initialAttributes.get("ParagraphFormatKey")).clone();
            if (f == null) {
                f = Font.defaultFont();
            }
            newAttr.put("FontKey", Font.fontNamed("Courier", f.style(), f.size()));
            newAttr.put("ParagraphFormatKey", defaultFormat);
        } else if (this.marker.equals("TT") || this.marker.equals("CODE") || this.marker.equals("SAMP") || this.marker.equals("KBD")) {
            f = (Font)newAttr.get("FontKey");
            if (f == null) {
                f = Font.defaultFont();
            }
            newAttr.put("FontKey", Font.fontNamed("Courier", f.style(), f.size()));
        } else if (this.marker.equals("A")) {
            attr = this.hashtableForHTMLAttributes(this.attributes);
            if (attr != null) {
                String name;
                String url = (String)attr.get("HREF");
                if (url != null) {
                    newAttr.put("LinkKey", url);
                }
                if ((name = (String)attr.get("NAME")) != null) {
                    newAttr.put("LinkDestinationKey", name);
                }
            }
        } else if (this.marker.equals("LI")) {
            pf = (TextParagraphFormat)newAttr.get("ParagraphFormatKey");
            if (pf == null) {
                pf = (TextParagraphFormat)((TextParagraphFormat)initialAttributes.get("ParagraphFormatKey")).clone();
            }
            pf.setWrapsUnderFirstCharacter(true);
            newAttr.put("ParagraphFormatKey", pf);
        } else if (this.marker.equals("P") && (v = (String)(attr = this.hashtableForHTMLAttributes(this.attributes)).get("ALIGN")) != null) {
            TextParagraphFormat f2 = (TextParagraphFormat)initialAttributes.get("ParagraphFormatKey");
            f2 = (TextParagraphFormat)f2.clone();
            if ((v = v.toUpperCase()).equals("LEFT")) {
                f2.setJustification(0);
            } else if (v.equals("CENTER")) {
                f2.setJustification(1);
            } else if (v.equals("RIGHT")) {
                f2.setJustification(2);
            }
            newAttr.put("ParagraphFormatKey", f2);
        }
        return newAttr;
    }
}

