/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.ApplicationObserver;
import netscape.application.Timer;
import netscape.application.View;
import netscape.application.Window;
import netscape.util.InconsistencyException;

class TimerQueue
implements Runnable,
ApplicationObserver {
    Timer firstTimer;
    boolean running;

    public TimerQueue() {
        Application application = Application.application();
        application.addObserver(this);
        if (application.isRunning()) {
            this.start();
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new InconsistencyException("Can't start a TimerQueue that is already running");
        }
        Thread timerThread = new Thread((Runnable)this, "TimerQueue");
        try {
            if (timerThread.getPriority() > 1) {
                timerThread.setPriority(timerThread.getPriority() - 1);
            }
            timerThread.setDaemon(true);
        }
        catch (SecurityException securityException) {}
        timerThread.start();
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long expirationTime) {
        if (timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            if (nextTimer.expirationTime > expirationTime) break;
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            previousTimer.nextTimer = timer;
        }
        timer.expirationTime = expirationTime;
        timer.nextTimer = nextTimer;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        boolean found = false;
        while (nextTimer != null) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            previousTimer.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.expirationTime - currentTime;
            if (timeToWait > 0L) continue;
            timer.post(currentTime);
            this.removeTimer(timer);
            if (timer.repeats()) {
                this.addTimer(timer, currentTime + (long)timer.delay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    public synchronized void run() {
        while (this.running) {
            long timeToWait = this.postExpiredTimers();
            try {
                this.wait(timeToWait);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TimerQueue (");
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            buf.append(nextTimer.toString());
            nextTimer = nextTimer.nextTimer;
            if (nextTimer == null) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public void focusDidChange(Application application, View focusedView) {
    }

    public void currentDocumentDidChange(Application application, Window document) {
    }

    public void applicationDidPause(Application app) {
    }

    public void applicationDidResume(Application app) {
    }

    public synchronized void applicationDidStart(Application app) {
        this.start();
    }

    public synchronized void applicationDidStop(Application app) {
        this.stop();
    }
}

