/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.util.Archive;
import netscape.util.ClassInfo;
import netscape.util.CompactInputStream;
import netscape.util.CompactOutputStream;
import netscape.util.IdHashtable;
import netscape.util.InconsistencyException;

public class ClassTable {
    Archive archive;
    String className;
    int classCount;
    String[] classNames;
    int[] classVersions;
    int fieldCount;
    byte[] fieldTypes;
    String[] fieldNames;
    IdHashtable columnForField;
    int rowCapacity;
    int rowCount;
    Object[] fieldColumns;
    int tableId;
    boolean uniqueStrings;

    public ClassTable(Archive archive) {
        this.archive = archive;
    }

    public ClassTable(Archive archive, ClassInfo classInfo) {
        this(archive);
        this.className = classInfo.className();
        this.classCount = classInfo.classCount();
        this.classNames = classInfo.classNames();
        this.classVersions = classInfo.classVersions();
        this.fieldCount = classInfo.fieldCount();
        this.fieldTypes = classInfo.fieldTypes();
        this.fieldNames = classInfo.fieldNames();
        this.fieldColumns = new Object[this.fieldCount];
    }

    public Archive archive() {
        return this.archive;
    }

    public String className() {
        return this.className;
    }

    public String[] classNames() {
        return this.classNames;
    }

    public int versionForClassName(String className) {
        int count = this.classCount;
        int i = 0;
        while (i < count) {
            if (this.classNames[i].equals(className)) {
                return this.classVersions[i];
            }
            ++i;
        }
        return 0;
    }

    public int rowCount() {
        return this.rowCount;
    }

    private Object newColumn(int fieldType, int length) {
        switch (fieldType) {
            case 0: {
                return new boolean[length];
            }
            case 1: {
                return new boolean[length][];
            }
            case 2: {
                return new char[length];
            }
            case 3: {
                return new char[length][];
            }
            case 4: {
                return new byte[length];
            }
            case 5: {
                return new byte[length][];
            }
            case 6: {
                return new short[length];
            }
            case 7: {
                return new short[length][];
            }
            case 8: {
                return new int[length];
            }
            case 9: {
                return new int[length][];
            }
            case 10: {
                return new long[length];
            }
            case 11: {
                return new long[length][];
            }
            case 12: {
                return new float[length];
            }
            case 13: {
                return new float[length][];
            }
            case 14: {
                return new double[length];
            }
            case 15: {
                return new double[length][];
            }
            case 16: {
                return new String[length];
            }
            case 17: {
                return new String[length][];
            }
            case 18: {
                return new int[length];
            }
            case 19: {
                return new int[length][];
            }
        }
        throw new InconsistencyException("Unknown field type: " + fieldType);
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.rowCapacity) {
            return;
        }
        int i = 0;
        while (i < this.fieldCount) {
            Object newColumn = this.newColumn(this.fieldTypes[i], newCapacity);
            if (this.rowCapacity > 0) {
                System.arraycopy(this.fieldColumns[i], 0, newColumn, 0, this.rowCapacity);
            }
            this.fieldColumns[i] = newColumn;
            ++i;
        }
        this.rowCapacity = newCapacity;
    }

    private void growCapacity() {
        int newCapacity = this.rowCapacity == 0 ? 8 : 2 * this.rowCapacity;
        this.ensureCapacity(newCapacity);
    }

    public int newIdentifier() {
        if (this.rowCount >= this.rowCapacity) {
            this.growCapacity();
        }
        int id = this.archive.mapIdentifier(this, this.rowCount);
        ++this.rowCount;
        return id;
    }

    public int rowForIdentifier(int id) {
        return this.archive.rowForIdentifier(id);
    }

    public int columnForField(String key) {
        int i;
        if (this.archive.performanceDebug) {
            System.err.println("*** Field " + key + " of class " + this.className + " was accessed out of order.");
        }
        if (this.columnForField == null) {
            this.columnForField = new IdHashtable(true);
            i = 0;
            while (i < this.fieldCount) {
                this.columnForField.putKnownAbsent(this.fieldNames[i], i + 1);
                ++i;
            }
        }
        i = this.columnForField.get(key);
        return i - 1;
    }

    void uniqueStrings(ClassInfo info) {
        this.setUniqueStrings(true);
        if (info.fieldCount != this.fieldCount) {
            if (this.archive.performanceDebug) {
                System.err.println("Failed to unique Strings in class " + info.className());
            }
            return;
        }
        this.columnForField = null;
        String[] src = info.fieldNames;
        String[] dst = this.fieldNames;
        int count = this.fieldCount;
        int i = 0;
        while (i < count) {
            if (!dst[i].equals(src[i])) {
                if (this.archive.performanceDebug) {
                    System.err.println("Failed to unique Strings in class " + info.className());
                }
                return;
            }
            dst[i] = src[i];
            ++i;
        }
        if (info.classCount != this.classCount) {
            return;
        }
        src = info.classNames;
        dst = this.classNames;
        count = this.classCount;
        i = 0;
        while (i < count) {
            if (!dst[i].equals(src[i])) {
                return;
            }
            dst[i] = src[i];
            ++i;
        }
    }

    void setUniqueStrings(boolean flag) {
        this.uniqueStrings = flag;
    }

    boolean hasUniqueStrings() {
        return this.uniqueStrings;
    }

    public boolean booleanAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((boolean[])this.fieldColumns[column])[row];
    }

    public void setBooleanAt(int row, int column, boolean value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((boolean[])this.fieldColumns[column])[row] = value;
    }

    public boolean[] booleanArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((boolean[][])this.fieldColumns[column])[row];
    }

    public void setBooleanArrayAt(int row, int column, boolean[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((boolean[][])this.fieldColumns[column])[row] = value;
    }

    public char charAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((char[])this.fieldColumns[column])[row];
    }

    public void setCharAt(int row, int column, char value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((char[])this.fieldColumns[column])[row] = value;
    }

    public char[] charArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((char[][])this.fieldColumns[column])[row];
    }

    public void setCharArrayAt(int row, int column, char[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((char[][])this.fieldColumns[column])[row] = value;
    }

    public byte byteAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((byte[])this.fieldColumns[column])[row];
    }

    public void setByteAt(int row, int column, byte value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((byte[])this.fieldColumns[column])[row] = value;
    }

    public byte[] byteArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((byte[][])this.fieldColumns[column])[row];
    }

    public void setByteArrayAt(int row, int column, byte[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((byte[][])this.fieldColumns[column])[row] = value;
    }

    public short shortAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((short[])this.fieldColumns[column])[row];
    }

    public void setShortAt(int row, int column, short value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((short[])this.fieldColumns[column])[row] = value;
    }

    public short[] shortArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((short[][])this.fieldColumns[column])[row];
    }

    public void setShortArrayAt(int row, int column, short[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((short[][])this.fieldColumns[column])[row] = value;
    }

    public int intAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((int[])this.fieldColumns[column])[row];
    }

    public void setIntAt(int row, int column, int value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((int[])this.fieldColumns[column])[row] = value;
    }

    public int[] intArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((int[][])this.fieldColumns[column])[row];
    }

    public void setIntArrayAt(int row, int column, int[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((int[][])this.fieldColumns[column])[row] = value;
    }

    public long longAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((long[])this.fieldColumns[column])[row];
    }

    public void setLongAt(int row, int column, long value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((long[])this.fieldColumns[column])[row] = value;
    }

    public long[] longArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((long[][])this.fieldColumns[column])[row];
    }

    public void setLongArrayAt(int row, int column, long[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((long[][])this.fieldColumns[column])[row] = value;
    }

    public float floatAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((float[])this.fieldColumns[column])[row];
    }

    public void setFloatAt(int row, int column, float value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((float[])this.fieldColumns[column])[row] = value;
    }

    public float[] floatArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((float[][])this.fieldColumns[column])[row];
    }

    public void setFloatArrayAt(int row, int column, float[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((float[][])this.fieldColumns[column])[row] = value;
    }

    public double doubleAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((double[])this.fieldColumns[column])[row];
    }

    public void setDoubleAt(int row, int column, double value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((double[])this.fieldColumns[column])[row] = value;
    }

    public double[] doubleArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((double[][])this.fieldColumns[column])[row];
    }

    public void setDoubleArrayAt(int row, int column, double[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((double[][])this.fieldColumns[column])[row] = value;
    }

    public String stringAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((String[])this.fieldColumns[column])[row];
    }

    public void setStringAt(int row, int column, String value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((String[])this.fieldColumns[column])[row] = value;
    }

    public String[] stringArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((String[][])this.fieldColumns[column])[row];
    }

    public void setStringArrayAt(int row, int column, String[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((String[][])this.fieldColumns[column])[row] = value;
    }

    public int identifierAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((int[])this.fieldColumns[column])[row];
    }

    public void setIdentifierAt(int row, int column, int value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((int[])this.fieldColumns[column])[row] = value;
    }

    public int[] identifierArrayAt(int row, int column) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return ((int[][])this.fieldColumns[column])[row];
    }

    public void setIdentifierArrayAt(int row, int column, int[] value) {
        if (row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        ((int[][])this.fieldColumns[column])[row] = value;
    }

    public void writeInfo(OutputStream outputStream) throws IOException {
        CompactOutputStream out = outputStream instanceof CompactOutputStream ? (CompactOutputStream)outputStream : new CompactOutputStream(outputStream);
        out.writeCompactUTF(this.className);
        int count = this.fieldCount;
        out.writeCompactInt(count);
        int i = 0;
        while (i < count) {
            out.writeCompactUTF(this.fieldNames[i]);
            out.writeByte(this.fieldTypes[i]);
            ++i;
        }
        count = this.classCount;
        out.writeCompactInt(count);
        i = 0;
        while (i < count) {
            out.writeCompactUTF(this.classNames[i]);
            out.writeCompactInt(this.classVersions[i]);
            ++i;
        }
        out.writeCompactInt(0);
    }

    public void writeData(OutputStream outputStream) throws IOException {
        CompactOutputStream out = outputStream instanceof CompactOutputStream ? (CompactOutputStream)outputStream : new CompactOutputStream(outputStream);
        out.writeCompactInt(this.rowCount);
        int count = this.fieldCount;
        int i = 0;
        while (i < count) {
            if (this.fieldTypes[i] == 0) {
                this.writeBooleanColumn(out, (boolean[])this.fieldColumns[i], this.rowCount);
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            Object column = this.fieldColumns[i];
            switch (this.fieldTypes[i]) {
                case 1: {
                    this.writeBooleanArrayColumn(out, (boolean[][])column, this.rowCount);
                    break;
                }
                case 2: {
                    this.writeCharColumn(out, (char[])column, this.rowCount);
                    break;
                }
                case 3: {
                    this.writeCharArrayColumn(out, (char[][])column, this.rowCount);
                    break;
                }
                case 4: {
                    this.writeByteColumn(out, (byte[])column, this.rowCount);
                    break;
                }
                case 5: {
                    this.writeByteArrayColumn(out, (byte[][])column, this.rowCount);
                    break;
                }
                case 6: {
                    this.writeShortColumn(out, (short[])column, this.rowCount);
                    break;
                }
                case 7: {
                    this.writeShortArrayColumn(out, (short[][])column, this.rowCount);
                    break;
                }
                case 8: {
                    this.writeIntColumn(out, (int[])column, this.rowCount);
                    break;
                }
                case 9: {
                    this.writeIntArrayColumn(out, (int[][])column, this.rowCount);
                    break;
                }
                case 10: {
                    this.writeLongColumn(out, (long[])column, this.rowCount);
                    break;
                }
                case 11: {
                    this.writeLongArrayColumn(out, (long[][])column, this.rowCount);
                    break;
                }
                case 12: {
                    this.writeFloatColumn(out, (float[])column, this.rowCount);
                    break;
                }
                case 13: {
                    this.writeFloatArrayColumn(out, (float[][])column, this.rowCount);
                    break;
                }
                case 14: {
                    this.writeDoubleColumn(out, (double[])column, this.rowCount);
                    break;
                }
                case 15: {
                    this.writeDoubleArrayColumn(out, (double[][])column, this.rowCount);
                    break;
                }
                case 16: {
                    this.writeStringColumn(out, (String[])column, this.rowCount);
                    break;
                }
                case 17: {
                    this.writeStringArrayColumn(out, (String[][])column, this.rowCount);
                    break;
                }
                case 18: {
                    this.writeIntColumn(out, (int[])column, this.rowCount);
                    break;
                }
                case 19: {
                    this.writeIntArrayColumn(out, (int[][])column, this.rowCount);
                    break;
                }
                default: {
                    throw new InconsistencyException("Unknown field type: " + this.fieldTypes[i]);
                }
                case 0: 
            }
            ++i;
        }
        out.writeCompactInt(0);
    }

    private void writeBooleanColumn(CompactOutputStream out, boolean[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeCompactBoolean(column[i]);
            ++i;
        }
    }

    private void writeBooleanArrayColumn(CompactOutputStream out, boolean[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            boolean[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeBooleanColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeCharColumn(CompactOutputStream out, char[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeChar(column[i]);
            ++i;
        }
    }

    private void writeCharArrayColumn(CompactOutputStream out, char[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            char[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeCharColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeByteColumn(CompactOutputStream out, byte[] column, int count) throws IOException {
        out.write(column, 0, count);
    }

    private void writeByteArrayColumn(CompactOutputStream out, byte[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            byte[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeByteColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeShortColumn(CompactOutputStream out, short[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeShort(column[i]);
            ++i;
        }
    }

    private void writeShortArrayColumn(CompactOutputStream out, short[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            short[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeShortColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeIntColumn(CompactOutputStream out, int[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeCompactInt(column[i]);
            ++i;
        }
    }

    private void writeIntArrayColumn(CompactOutputStream out, int[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                int length = array.length;
                out.writeCompactInt(length);
                int j = 0;
                while (j < length) {
                    out.writeInt(array[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void writeLongColumn(CompactOutputStream out, long[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeLong(column[i]);
            ++i;
        }
    }

    private void writeLongArrayColumn(CompactOutputStream out, long[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            long[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeLongColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeFloatColumn(CompactOutputStream out, float[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeFloat(column[i]);
            ++i;
        }
    }

    private void writeFloatArrayColumn(CompactOutputStream out, float[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            float[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeFloatColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeDoubleColumn(CompactOutputStream out, double[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeDouble(column[i]);
            ++i;
        }
    }

    private void writeDoubleArrayColumn(CompactOutputStream out, double[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            double[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeDoubleColumn(out, array, array.length);
            }
            ++i;
        }
    }

    private void writeStringColumn(CompactOutputStream out, String[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            out.writeCompactUTF(column[i]);
            ++i;
        }
    }

    private void writeStringArrayColumn(CompactOutputStream out, String[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            String[] array = column[i];
            if (array == null) {
                out.writeCompactInt(-1);
            } else {
                out.writeCompactInt(array.length);
                this.writeStringColumn(out, array, array.length);
            }
            ++i;
        }
    }

    public void readInfo(InputStream inputStream) throws IOException {
        int count;
        CompactInputStream in = inputStream instanceof CompactInputStream ? (CompactInputStream)inputStream : new CompactInputStream(inputStream);
        this.className = in.readCompactUTF();
        this.fieldCount = count = in.readCompactInt();
        this.fieldNames = new String[count];
        this.fieldTypes = new byte[count];
        this.fieldColumns = new Object[count];
        int i = 0;
        while (i < count) {
            this.fieldNames[i] = in.readCompactUTF();
            this.fieldTypes[i] = in.readByte();
            ++i;
        }
        this.classCount = count = in.readCompactInt();
        this.classNames = new String[count];
        this.classVersions = new int[count];
        i = 0;
        while (i < count) {
            this.classNames[i] = in.readCompactUTF();
            this.classVersions[i] = in.readCompactInt();
            ++i;
        }
        count = in.readCompactInt();
        if (count > 0) {
            in.skipBytes(count);
        }
    }

    public void readData(InputStream inputStream) throws IOException {
        CompactInputStream in = inputStream instanceof CompactInputStream ? (CompactInputStream)inputStream : new CompactInputStream(inputStream);
        this.rowCount = in.readCompactInt();
        this.ensureCapacity(this.rowCount);
        int count = this.fieldCount;
        int i = 0;
        while (i < count) {
            if (this.fieldTypes[i] == 0) {
                this.readBooleanColumn(in, (boolean[])this.fieldColumns[i], this.rowCount);
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            Object column = this.fieldColumns[i];
            switch (this.fieldTypes[i]) {
                case 1: {
                    this.readBooleanArrayColumn(in, (boolean[][])column, this.rowCount);
                    break;
                }
                case 2: {
                    this.readCharColumn(in, (char[])column, this.rowCount);
                    break;
                }
                case 3: {
                    this.readCharArrayColumn(in, (char[][])column, this.rowCount);
                    break;
                }
                case 4: {
                    this.readByteColumn(in, (byte[])column, this.rowCount);
                    break;
                }
                case 5: {
                    this.readByteArrayColumn(in, (byte[][])column, this.rowCount);
                    break;
                }
                case 6: {
                    this.readShortColumn(in, (short[])column, this.rowCount);
                    break;
                }
                case 7: {
                    this.readShortArrayColumn(in, (short[][])column, this.rowCount);
                    break;
                }
                case 8: {
                    this.readIntColumn(in, (int[])column, this.rowCount);
                    break;
                }
                case 9: {
                    this.readIntArrayColumn(in, (int[][])column, this.rowCount);
                    break;
                }
                case 10: {
                    this.readLongColumn(in, (long[])column, this.rowCount);
                    break;
                }
                case 11: {
                    this.readLongArrayColumn(in, (long[][])column, this.rowCount);
                    break;
                }
                case 12: {
                    this.readFloatColumn(in, (float[])column, this.rowCount);
                    break;
                }
                case 13: {
                    this.readFloatArrayColumn(in, (float[][])column, this.rowCount);
                    break;
                }
                case 14: {
                    this.readDoubleColumn(in, (double[])column, this.rowCount);
                    break;
                }
                case 15: {
                    this.readDoubleArrayColumn(in, (double[][])column, this.rowCount);
                    break;
                }
                case 16: {
                    this.readStringColumn(in, (String[])column, this.rowCount);
                    break;
                }
                case 17: {
                    this.readStringArrayColumn(in, (String[][])column, this.rowCount);
                    break;
                }
                case 18: {
                    this.readIntColumn(in, (int[])column, this.rowCount);
                    break;
                }
                case 19: {
                    this.readIntArrayColumn(in, (int[][])column, this.rowCount);
                    break;
                }
                default: {
                    throw new InconsistencyException("Unknown field type: " + this.fieldTypes[i]);
                }
                case 0: 
            }
            ++i;
        }
        count = in.readCompactInt();
        if (count > 0) {
            in.skipBytes(count);
        }
    }

    private void readBooleanColumn(CompactInputStream in, boolean[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readCompactBoolean();
            ++i;
        }
    }

    private void readBooleanArrayColumn(CompactInputStream in, boolean[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                boolean[] array = new boolean[length];
                column[i] = array;
                this.readBooleanColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readCharColumn(CompactInputStream in, char[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readChar();
            ++i;
        }
    }

    private void readCharArrayColumn(CompactInputStream in, char[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                char[] array = new char[length];
                column[i] = array;
                this.readCharColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readByteColumn(CompactInputStream in, byte[] column, int count) throws IOException {
        in.readFully(column, 0, count);
    }

    private void readByteArrayColumn(CompactInputStream in, byte[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                byte[] array = new byte[length];
                column[i] = array;
                this.readByteColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readShortColumn(CompactInputStream in, short[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readShort();
            ++i;
        }
    }

    private void readShortArrayColumn(CompactInputStream in, short[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                short[] array = new short[length];
                column[i] = array;
                this.readShortColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readIntColumn(CompactInputStream in, int[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readCompactInt();
            ++i;
        }
    }

    private void readIntArrayColumn(CompactInputStream in, int[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                int[] array = new int[length];
                column[i] = array;
                int j = 0;
                while (j < length) {
                    array[j] = in.readInt();
                    ++j;
                }
            }
            ++i;
        }
    }

    private void readLongColumn(CompactInputStream in, long[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readLong();
            ++i;
        }
    }

    private void readLongArrayColumn(CompactInputStream in, long[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                long[] array = new long[length];
                column[i] = array;
                this.readLongColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readFloatColumn(CompactInputStream in, float[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readFloat();
            ++i;
        }
    }

    private void readFloatArrayColumn(CompactInputStream in, float[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                float[] array = new float[length];
                column[i] = array;
                this.readFloatColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readDoubleColumn(CompactInputStream in, double[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readDouble();
            ++i;
        }
    }

    private void readDoubleArrayColumn(CompactInputStream in, double[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                double[] array = new double[length];
                column[i] = array;
                this.readDoubleColumn(in, array, length);
            }
            ++i;
        }
    }

    private void readStringColumn(CompactInputStream in, String[] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            column[i] = in.readCompactUTF();
            ++i;
        }
    }

    private void readStringArrayColumn(CompactInputStream in, String[][] column, int count) throws IOException {
        int i = 0;
        while (i < count) {
            int length = in.readCompactInt();
            if (length >= 0) {
                String[] array = new String[length];
                column[i] = array;
                this.readStringColumn(in, array, length);
            }
            ++i;
        }
    }
}

