/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.Timer;
import netscape.ldap.TimerEvent;
import netscape.ldap.TimerEventListener;
import netscape.ldap.util.DN;

public class LDAPCache
implements TimerEventListener {
    private Hashtable m_cache;
    private long m_timeToLive;
    private long m_maxSize;
    private String[] m_dns;
    private Vector m_orderedStruct;
    private long m_remainingSize;
    public static final String DELIM = "#";
    private Timer m_timer;
    private static long TIMEOUT = 60000L;
    private long m_totalOpers;
    private static final boolean m_debug = false;
    private long m_hits;
    private long m_flushes;

    public LDAPCache(long ttl, long size) {
        this.init(ttl, size);
    }

    public LDAPCache(long ttl, long size, String[] dns) {
        this.init(ttl, size);
        this.m_dns = new String[dns.length];
        if (dns != null && dns.length > 0) {
            int i = 0;
            while (i < dns.length) {
                this.m_dns[i] = new DN(dns[i]).toString();
                ++i;
            }
        }
    }

    public long getSize() {
        return this.m_maxSize;
    }

    public long getTimeToLive() {
        return this.m_timeToLive / 1000L;
    }

    public String[] getBaseDNs() {
        return this.m_dns;
    }

    public synchronized boolean flushEntries(String dn, int scope) {
        if (dn == null) {
            this.m_remainingSize = this.m_maxSize;
            this.m_cache.clear();
            this.m_orderedStruct.removeAllElements();
            return true;
        }
        DN dn2 = new DN(dn);
        Enumeration e = this.m_cache.keys();
        while (e.hasMoreElements()) {
            Long key = (Long)e.nextElement();
            Vector val = (Vector)this.m_cache.get(key);
            int j = 1;
            int size2 = val.size();
            while (j < size2) {
                DN parentDN1;
                String d = ((LDAPEntry)val.elementAt(j)).getDN();
                DN dn1 = new DN(d);
                if (dn1.equals(dn2) || scope == 1 && (parentDN1 = dn1.getParent()).equals(dn2) || scope == 2 && dn1.contains(dn2)) break;
                ++j;
            }
            if (j >= size2) continue;
            int k = 0;
            while (k < this.m_orderedStruct.size()) {
                Vector v = (Vector)this.m_orderedStruct.elementAt(k);
                if (key.equals((Long)v.elementAt(0))) {
                    this.m_orderedStruct.removeElementAt(k);
                    break;
                }
                ++k;
            }
            this.m_cache.remove(key);
            return true;
        }
        return false;
    }

    public void timerExpired(TimerEvent e) {
        this.flushEntries();
        Timer t = (Timer)e.getSource();
        t.start();
    }

    public long getAvailableSize() {
        return this.m_remainingSize;
    }

    public long getTotalOperations() {
        return this.m_totalOpers;
    }

    public long getNumMisses() {
        return this.m_totalOpers - this.m_hits;
    }

    public long getNumHits() {
        return this.m_hits;
    }

    public long getNumFlushes() {
        return this.m_flushes;
    }

    Long createKey(String host, int port, String baseDN, String filter, int scope, String[] attrs, String bindDN, LDAPSearchConstraints cons) throws LDAPException {
        long val;
        int i;
        String[] objID;
        DN dn = new DN(baseDN);
        baseDN = dn.toString();
        if (this.m_dns != null) {
            int i2 = 0;
            while (i2 < this.m_dns.length) {
                if (baseDN.equals(this.m_dns[i2])) break;
                ++i2;
            }
            if (i2 >= this.m_dns.length) {
                throw new LDAPException("Failed to create key due to the wrong base DN", 80);
            }
        }
        String key = null;
        key = this.appendString(baseDN);
        key = String.valueOf(key) + this.appendString(scope);
        key = String.valueOf(key) + this.appendString(host);
        key = String.valueOf(key) + this.appendString(port);
        key = String.valueOf(key) + this.appendString(filter);
        key = String.valueOf(key) + this.appendString(attrs);
        key = String.valueOf(key) + this.appendString(bindDN);
        LDAPControl[] serverControls = null;
        LDAPControl[] clientControls = null;
        if (cons != null) {
            serverControls = cons.getServerControls();
            clientControls = cons.getClientControls();
        }
        if (serverControls != null && serverControls.length > 0) {
            objID = new String[serverControls.length];
            i = 0;
            while (i < serverControls.length) {
                val = this.getCRC32(serverControls[i].getValue());
                objID[i] = new Long(val).toString();
                ++i;
            }
            key = String.valueOf(key) + this.appendString(objID);
        } else {
            key = String.valueOf(key) + this.appendString(0);
        }
        if (clientControls != null && clientControls.length > 0) {
            objID = new String[clientControls.length];
            i = 0;
            while (i < clientControls.length) {
                val = this.getCRC32(clientControls[i].getValue());
                objID[i] = new Long(val).toString();
                ++i;
            }
            key = String.valueOf(key) + this.appendString(objID);
        } else {
            key = String.valueOf(key) + this.appendString(0);
        }
        long val2 = this.getCRC32(key.getBytes());
        return new Long(val2);
    }

    synchronized Object getEntry(Long key) {
        Object obj = null;
        obj = this.m_cache.get(key);
        ++this.m_totalOpers;
        if (obj != null) {
            ++this.m_hits;
        }
        return obj;
    }

    synchronized void flushEntries() {
        long diff;
        Vector v = null;
        Date date = new Date();
        long currTime = date.getTime();
        this.m_flushes = 0L;
        while (this.m_orderedStruct.size() > 0 && (diff = currTime - (Long)(v = (Vector)this.m_orderedStruct.firstElement()).elementAt(1)) >= this.m_timeToLive) {
            Long key = (Long)v.elementAt(0);
            Vector entry = (Vector)this.m_cache.remove(key);
            this.m_remainingSize += ((Long)entry.firstElement()).longValue();
            this.m_orderedStruct.removeElementAt(0);
            ++this.m_flushes;
        }
    }

    synchronized void addEntry(Long key, Object value) throws LDAPException {
        Vector<Long> element;
        if (this.m_cache.get(key) != null) {
            return;
        }
        Vector v = (Vector)value;
        long size = (Long)v.elementAt(0) + 4L;
        if (size > this.m_maxSize) {
            throw new LDAPException("Failed to add an entry to the cache since the new entry exceeds the cache size", 80);
        }
        v.setElementAt(new Long(size), 0);
        if (size > this.m_remainingSize) {
            do {
                element = (Vector<Long>)this.m_orderedStruct.firstElement();
                Long str = (Long)element.elementAt(0);
                Vector val = (Vector)this.m_cache.remove(str);
                this.m_orderedStruct.removeElementAt(0);
                this.m_remainingSize += ((Long)val.elementAt(0)).longValue();
            } while (this.m_remainingSize < size);
        }
        this.m_remainingSize -= size;
        this.m_cache.put(key, v);
        element = new Vector<Long>();
        element.addElement(key);
        Date date = new Date();
        element.addElement(new Long(date.getTime()));
        this.m_orderedStruct.addElement(element);
    }

    int size() {
        return this.m_cache.size();
    }

    void cleanup() {
        this.m_timer.stop();
    }

    private void init(long ttl, long size) {
        this.m_cache = new Hashtable();
        this.m_timeToLive = ttl * 1000L;
        this.m_maxSize = size;
        this.m_remainingSize = size;
        this.m_dns = null;
        this.m_orderedStruct = new Vector();
        this.m_timer = new Timer(TIMEOUT);
        this.m_timer.addTimerExpiredEventListener(this);
        this.m_timer.start();
    }

    private String appendString(String str) {
        if (str == null) {
            return "null#";
        }
        return String.valueOf(str.trim()) + DELIM;
    }

    private String appendString(int num) {
        return String.valueOf(num) + DELIM;
    }

    private String appendString(String[] str) {
        if (str == null || str.length < 1) {
            return "0#";
        }
        this.sortStrings(str);
        String s = String.valueOf(str.length) + DELIM;
        int i = 0;
        while (i < str.length) {
            s = String.valueOf(s) + str[i].trim() + DELIM;
            ++i;
        }
        return s;
    }

    private void sortStrings(String[] str) {
        int i = 0;
        while (i < str.length) {
            str[i] = str[i].trim();
            ++i;
        }
        int i2 = 0;
        while (i2 < str.length - 1) {
            int j = i2 + 1;
            while (j < str.length) {
                if (str[i2].compareTo(str[j]) > 0) {
                    String t = str[i2];
                    str[i2] = str[j];
                    str[j] = t;
                }
                ++j;
            }
            ++i2;
        }
    }

    private long getCRC32(byte[] barray) {
        CRC32 crcVal = new CRC32();
        crcVal.update(barray);
        return crcVal.getValue();
    }
}

