/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;

public class LDAPCompareAttrNames
implements LDAPEntryComparator {
    String[] m_attrs;
    boolean[] m_ascending;

    public LDAPCompareAttrNames(String attribute) {
        this.m_attrs = new String[1];
        this.m_attrs[0] = attribute;
        this.m_ascending = new boolean[1];
        this.m_ascending[0] = true;
    }

    public LDAPCompareAttrNames(String attribute, boolean ascendingFlag) {
        this.m_attrs = new String[1];
        this.m_attrs[0] = attribute;
        this.m_ascending = new boolean[1];
        this.m_ascending[0] = ascendingFlag;
    }

    public LDAPCompareAttrNames(String[] attributes) {
        this.m_attrs = attributes;
        this.m_ascending = new boolean[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            this.m_ascending[i] = true;
            ++i;
        }
    }

    public LDAPCompareAttrNames(String[] attributes, boolean[] ascendingFlags) {
        this.m_attrs = attributes;
        this.m_ascending = ascendingFlags;
        if (this.m_ascending == null) {
            this.m_ascending = new boolean[attributes.length];
            int i = 0;
            while (i < attributes.length) {
                this.m_ascending[i] = true;
                ++i;
            }
        }
    }

    public boolean isGreater(LDAPEntry greater, LDAPEntry less) {
        if (greater.equals(less)) {
            return false;
        }
        return this.attrGreater(greater, less, 0);
    }

    boolean attrGreater(LDAPEntry greater, LDAPEntry less, int attrPos) {
        Enumeration greaterAttrSet = greater.getAttributeSet().getAttributes();
        Enumeration lessAttrSet = less.getAttributeSet().getAttributes();
        String greaterValue = null;
        String lessValue = null;
        String attrName = this.m_attrs[attrPos];
        boolean ascending = this.m_ascending[attrPos];
        try {
            LDAPAttribute currAttr;
            while (lessAttrSet.hasMoreElements()) {
                currAttr = (LDAPAttribute)lessAttrSet.nextElement();
                if (!attrName.equalsIgnoreCase(currAttr.getName())) continue;
                lessValue = (String)currAttr.getStringValues().nextElement();
                break;
            }
            while (greaterAttrSet.hasMoreElements()) {
                currAttr = (LDAPAttribute)greaterAttrSet.nextElement();
                if (!attrName.equalsIgnoreCase(currAttr.getName())) continue;
                greaterValue = (String)currAttr.getStringValues().nextElement();
                break;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        if (lessValue == null ^ greaterValue == null) {
            return greaterValue != null;
        }
        if (lessValue == null || lessValue.equalsIgnoreCase(greaterValue)) {
            if (attrPos == this.m_attrs.length - 1) {
                return false;
            }
            return this.attrGreater(greater, less, attrPos + 1);
        }
        if (ascending) {
            return greaterValue.compareTo(lessValue) > 0;
        }
        return greaterValue.compareTo(lessValue) < 0;
    }
}

