/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;

public class LDAPEntry {
    private String dn;
    private LDAPAttributeSet attrSet;

    public LDAPEntry() {
        this.dn = null;
        this.attrSet = null;
    }

    public LDAPEntry(String distinguishedName) {
        this.dn = distinguishedName;
        this.attrSet = null;
    }

    public LDAPEntry(String distinguishedName, LDAPAttributeSet attrs) {
        this.dn = distinguishedName;
        this.attrSet = attrs;
    }

    public String getDN() {
        return this.dn;
    }

    public LDAPAttributeSet getAttributeSet() {
        return this.attrSet;
    }

    public LDAPAttributeSet getAttributeSet(String subtype) {
        return this.attrSet.getSubset(subtype);
    }

    public LDAPAttribute getAttribute(String attrName) {
        return this.attrSet.getAttribute(attrName);
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        return this.attrSet.getAttribute(attrName, lang);
    }

    public String toString() {
        String s = "LDAPEntry: ";
        if (this.dn != null) {
            s = String.valueOf(s) + this.dn + "; ";
        }
        if (this.attrSet != null) {
            s = String.valueOf(s) + this.attrSet.toString();
        }
        return s;
    }
}

