/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public abstract class BERConstruct
extends BERElement {
    private Vector m_elements = new Vector();

    public BERConstruct() {
    }

    public BERConstruct(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        int[] component_length = new int[1];
        if (contents_length == -1) {
            BERElement element = null;
            component_length[0] = 0;
            element = BERElement.getElement(decoder, stream, component_length);
            if (element != null) {
                this.addElement(element);
            }
            while (element != null) {
            }
            return;
        }
        bytes_read[0] = bytes_read[0] + contents_length;
        while (contents_length > 0) {
            component_length[0] = 0;
            this.addElement(BERElement.getElement(decoder, stream, component_length));
            contents_length -= component_length[0];
        }
    }

    public void addElement(BERElement element) {
        this.m_elements.addElement(element);
    }

    public int size() {
        return this.m_elements.size();
    }

    public BERElement elementAt(int index) {
        return (BERElement)this.m_elements.elementAt(index);
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.getType());
        ByteArrayOutputStream contents_stream = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.m_elements.size()) {
            BERElement e = this.elementAt(i);
            e.write(contents_stream);
            ++i;
        }
        byte[] contents_buffer = contents_stream.toByteArray();
        BERElement.sendDefiniteLength(stream, contents_buffer.length);
        stream.write(contents_buffer);
    }

    public abstract int getType();

    public abstract String toString();
}

