/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeEncoder;

public final class MimeBase64Encoder
extends MimeEncoder {
    private int buf;
    private int buf_bytes;
    private byte[] line = new byte[74];
    private int line_length;
    private static final byte[] crlf = "\r\n".getBytes();
    private static final byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    private final void encode_token() {
        int i = this.line_length;
        this.line[i] = map[0x3F & this.buf >> 18];
        this.line[i + 1] = map[0x3F & this.buf >> 12];
        this.line[i + 2] = map[0x3F & this.buf >> 6];
        this.line[i + 3] = map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private final void encode_partial_token() {
        int i = this.line_length;
        this.line[i] = map[0x3F & this.buf >> 18];
        this.line[i + 1] = map[0x3F & this.buf >> 12];
        this.line[i + 2] = this.buf_bytes == 1 ? 61 : map[0x3F & this.buf >> 6];
        this.line[i + 3] = this.buf_bytes <= 2 ? 61 : map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private final void flush_line(ByteBuf out) {
        out.append(this.line, 0, this.line_length);
        this.line_length = 0;
    }

    public final void translate(ByteBuf in, ByteBuf out) {
        byte[] inb = in.toBytes();
        int in_length = in.length();
        int i = 0;
        while (i < in_length) {
            this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | inb[i] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | inb[i] << 8 : this.buf & 0xFFFF00 | inb[i]);
            if (++this.buf_bytes == 3) {
                this.encode_token();
                if (this.line_length >= 72) {
                    this.flush_line(out);
                }
            }
            ++i;
        }
    }

    public final void eof(ByteBuf out) {
        if (this.buf_bytes != 0) {
            this.encode_partial_token();
        }
        this.flush_line(out);
        this.line = null;
    }
}

