/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.util.Enumeration;
import netscape.plugin.composer.io.EntityEnumeration;
import netscape.plugin.composer.io.FooStringBuffer;
import netscape.plugin.composer.io.Token;

public class Entity
extends Token {
    private String name;
    private int ch;
    private static Entity[] knownEntities = new Entity[107];

    public Entity(StringBuffer s) {
        this.name = s.toString();
        this.ch = -1;
    }

    public static Enumeration entities() {
        return new EntityEnumeration(knownEntities);
    }

    Entity(FooStringBuffer s) {
        this.name = s.toString();
        this.ch = -1;
    }

    public Entity(String s, char c) {
        this.name = s;
        this.ch = c;
    }

    public int getValue() {
        if (this.ch == -1) {
            this.ch = this.evaluate();
        }
        return this.ch;
    }

    protected int evaluate() {
        try {
            if (this.name.charAt(0) == '#') {
                int value = 0;
                int n = this.name.length();
                int i = 1;
                while (i < n) {
                    char c = this.name.charAt(i);
                    if (c < '0' || c > '9') break;
                    value = value * 10 + (c - 48);
                    ++i;
                }
                return value;
            }
            int i = 0;
            while (i < knownEntities.length) {
                if (Entity.knownEntities[i].name.equals(this.name)) {
                    return Entity.knownEntities[i].ch;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return -1;
    }

    public String toString() {
        return "&" + this.name + ";";
    }

    public int hashCode() {
        if (this.ch == -1) {
            this.ch = this.evaluate();
        }
        return this.name.hashCode() ^ this.ch;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Entity) {
            Entity o = (Entity)other;
            return this.name.equals(o.name);
        }
        return false;
    }

    static {
        int i = 0;
        Entity.knownEntities[i++] = new Entity("lt", '<');
        Entity.knownEntities[i++] = new Entity("LT", '<');
        Entity.knownEntities[i++] = new Entity("gt", '>');
        Entity.knownEntities[i++] = new Entity("GT", '>');
        Entity.knownEntities[i++] = new Entity("amp", '&');
        Entity.knownEntities[i++] = new Entity("AMP", '&');
        Entity.knownEntities[i++] = new Entity("quot", '\"');
        Entity.knownEntities[i++] = new Entity("QUOT", '\"');
        Entity.knownEntities[i++] = new Entity("nbsp", '\u00a0');
        Entity.knownEntities[i++] = new Entity("reg", '\u00ae');
        Entity.knownEntities[i++] = new Entity("REG", '\u00ae');
        Entity.knownEntities[i++] = new Entity("copy", '\u00a9');
        Entity.knownEntities[i++] = new Entity("COPY", '\u00a9');
        Entity.knownEntities[i++] = new Entity("iexcl", '\u00a1');
        Entity.knownEntities[i++] = new Entity("cent", '\u00a2');
        Entity.knownEntities[i++] = new Entity("pound", '\u00a3');
        Entity.knownEntities[i++] = new Entity("curren", '\u00a4');
        Entity.knownEntities[i++] = new Entity("yen", '\u00a5');
        Entity.knownEntities[i++] = new Entity("brvbar", '\u00a6');
        Entity.knownEntities[i++] = new Entity("sect", '\u00a7');
        Entity.knownEntities[i++] = new Entity("uml", '\u00a8');
        Entity.knownEntities[i++] = new Entity("ordf", '\u00aa');
        Entity.knownEntities[i++] = new Entity("laquo", '\u00ab');
        Entity.knownEntities[i++] = new Entity("not", '\u00ac');
        Entity.knownEntities[i++] = new Entity("shy", '\u00ad');
        Entity.knownEntities[i++] = new Entity("macr", '\u00af');
        Entity.knownEntities[i++] = new Entity("deg", '\u00b0');
        Entity.knownEntities[i++] = new Entity("plusmn", '\u00b1');
        Entity.knownEntities[i++] = new Entity("sup2", '\u00b2');
        Entity.knownEntities[i++] = new Entity("sup3", '\u00b3');
        Entity.knownEntities[i++] = new Entity("acute", '\u00b4');
        Entity.knownEntities[i++] = new Entity("micro", '\u00b5');
        Entity.knownEntities[i++] = new Entity("para", '\u00b6');
        Entity.knownEntities[i++] = new Entity("middot", '\u00b7');
        Entity.knownEntities[i++] = new Entity("cedil", '\u00b8');
        Entity.knownEntities[i++] = new Entity("sup1", '\u00b9');
        Entity.knownEntities[i++] = new Entity("ordm", '\u00ba');
        Entity.knownEntities[i++] = new Entity("raquo", '\u00bb');
        Entity.knownEntities[i++] = new Entity("frac14", '\u00bc');
        Entity.knownEntities[i++] = new Entity("frac12", '\u00bd');
        Entity.knownEntities[i++] = new Entity("frac34", '\u00be');
        Entity.knownEntities[i++] = new Entity("iquest", '\u00bf');
        Entity.knownEntities[i++] = new Entity("Agrave", '\u00c0');
        Entity.knownEntities[i++] = new Entity("Aacute", '\u00c1');
        Entity.knownEntities[i++] = new Entity("Acirc", '\u00c2');
        Entity.knownEntities[i++] = new Entity("Atilde", '\u00c3');
        Entity.knownEntities[i++] = new Entity("Auml", '\u00c4');
        Entity.knownEntities[i++] = new Entity("Aring", '\u00c5');
        Entity.knownEntities[i++] = new Entity("AElig", '\u00c6');
        Entity.knownEntities[i++] = new Entity("Ccedil", '\u00c7');
        Entity.knownEntities[i++] = new Entity("Egrave", '\u00c8');
        Entity.knownEntities[i++] = new Entity("Eacute", '\u00c9');
        Entity.knownEntities[i++] = new Entity("Ecirc", '\u00ca');
        Entity.knownEntities[i++] = new Entity("Euml", '\u00cb');
        Entity.knownEntities[i++] = new Entity("Igrave", '\u00cc');
        Entity.knownEntities[i++] = new Entity("Iacute", '\u00cd');
        Entity.knownEntities[i++] = new Entity("Icirc", '\u00ce');
        Entity.knownEntities[i++] = new Entity("Iuml", '\u00cf');
        Entity.knownEntities[i++] = new Entity("ETH", '\u00d0');
        Entity.knownEntities[i++] = new Entity("Ntilde", '\u00d1');
        Entity.knownEntities[i++] = new Entity("Ograve", '\u00d2');
        Entity.knownEntities[i++] = new Entity("Oacute", '\u00d3');
        Entity.knownEntities[i++] = new Entity("Ocirc", '\u00d4');
        Entity.knownEntities[i++] = new Entity("Otilde", '\u00d5');
        Entity.knownEntities[i++] = new Entity("Ouml", '\u00d6');
        Entity.knownEntities[i++] = new Entity("times", '\u00d7');
        Entity.knownEntities[i++] = new Entity("Oslash", '\u00d8');
        Entity.knownEntities[i++] = new Entity("Ugrave", '\u00d9');
        Entity.knownEntities[i++] = new Entity("Uacute", '\u00da');
        Entity.knownEntities[i++] = new Entity("Ucirc", '\u00db');
        Entity.knownEntities[i++] = new Entity("Uuml", '\u00dc');
        Entity.knownEntities[i++] = new Entity("Yacute", '\u00dd');
        Entity.knownEntities[i++] = new Entity("THORN", '\u00de');
        Entity.knownEntities[i++] = new Entity("szlig", '\u00df');
        Entity.knownEntities[i++] = new Entity("agrave", '\u00e0');
        Entity.knownEntities[i++] = new Entity("aacute", '\u00e1');
        Entity.knownEntities[i++] = new Entity("acirc", '\u00e2');
        Entity.knownEntities[i++] = new Entity("atilde", '\u00e3');
        Entity.knownEntities[i++] = new Entity("auml", '\u00e4');
        Entity.knownEntities[i++] = new Entity("aring", '\u00e5');
        Entity.knownEntities[i++] = new Entity("aelig", '\u00e6');
        Entity.knownEntities[i++] = new Entity("ccedil", '\u00e7');
        Entity.knownEntities[i++] = new Entity("egrave", '\u00e8');
        Entity.knownEntities[i++] = new Entity("eacute", '\u00e9');
        Entity.knownEntities[i++] = new Entity("ecirc", '\u00ea');
        Entity.knownEntities[i++] = new Entity("euml", '\u00eb');
        Entity.knownEntities[i++] = new Entity("igrave", '\u00ec');
        Entity.knownEntities[i++] = new Entity("iacute", '\u00ed');
        Entity.knownEntities[i++] = new Entity("icirc", '\u00ee');
        Entity.knownEntities[i++] = new Entity("iuml", '\u00ef');
        Entity.knownEntities[i++] = new Entity("eth", '\u00f0');
        Entity.knownEntities[i++] = new Entity("ntilde", '\u00f1');
        Entity.knownEntities[i++] = new Entity("ograve", '\u00f2');
        Entity.knownEntities[i++] = new Entity("oacute", '\u00f3');
        Entity.knownEntities[i++] = new Entity("ocirc", '\u00f4');
        Entity.knownEntities[i++] = new Entity("otilde", '\u00f5');
        Entity.knownEntities[i++] = new Entity("ouml", '\u00f6');
        Entity.knownEntities[i++] = new Entity("divide", '\u00f7');
        Entity.knownEntities[i++] = new Entity("oslash", '\u00f8');
        Entity.knownEntities[i++] = new Entity("ugrave", '\u00f9');
        Entity.knownEntities[i++] = new Entity("uacute", '\u00fa');
        Entity.knownEntities[i++] = new Entity("ucirc", '\u00fb');
        Entity.knownEntities[i++] = new Entity("uuml", '\u00fc');
        Entity.knownEntities[i++] = new Entity("yacute", '\u00fd');
        Entity.knownEntities[i++] = new Entity("thorn", '\u00fe');
        Entity.knownEntities[i++] = new Entity("yuml", '\u00ff');
        Entity.knownEntities[i++] = new Entity("euro", '\u20ac');
    }
}

