import {actionCreators as ac} from "common/Actions.jsm";
import {clampTotalLines} from "content-src/lib/clamp-total-lines";
import {DSImage} from "../DSImage/DSImage.jsx";
import {DSLinkMenu} from "../DSLinkMenu/DSLinkMenu";
import {ImpressionStats} from "../../DiscoveryStreamImpressionStats/ImpressionStats";
import React from "react";
import {SafeAnchor} from "../SafeAnchor/SafeAnchor";

export class DSCard extends React.PureComponent {
  constructor(props) {
    super(props);

    this.onLinkClick = this.onLinkClick.bind(this);
  }

  onLinkClick(event) {
    if (this.props.dispatch) {
      this.props.dispatch(ac.UserEvent({
        event: "CLICK",
        source: this.props.type.toUpperCase(),
        action_position: this.props.pos,
      }));

      this.props.dispatch(ac.ImpressionStats({
        source: this.props.type.toUpperCase(),
        click: 0,
        tiles: [{id: this.props.id, pos: this.props.pos}],
      }));
    }
  }

  render() {
    return (
      <div className={`ds-card${this.props.placeholder ? " placeholder" : ""}`}>
        <SafeAnchor
          className="ds-card-link"
          dispatch={this.props.dispatch}
          onLinkClick={!this.props.placeholder ? this.onLinkClick : undefined}
          url={this.props.url}>
          <div className="img-wrapper">
            <DSImage extraClassNames="img" source={this.props.image_src} rawSource={this.props.raw_image_src} />
          </div>
          <div className="meta">
            <div className="info-wrap"
              data-total-lines="7"
              ref={clampTotalLines}>
              <p className="source clamp" data-clamp="1">{this.props.source}</p>
              <header className="title clamp" data-clamp="4">{this.props.title}</header>
              {this.props.excerpt && <p className="excerpt clamp">{this.props.excerpt}</p>}
            </div>
            {this.props.context && (
              <p className="context">{this.props.context}</p>
            )}
          </div>
          <ImpressionStats
            campaignId={this.props.campaignId}
            rows={[{id: this.props.id, pos: this.props.pos}]}
            dispatch={this.props.dispatch}
            source={this.props.type} />
        </SafeAnchor>
        {!this.props.placeholder && <DSLinkMenu
          id={this.props.id}
          index={this.props.pos}
          dispatch={this.props.dispatch}
          intl={this.props.intl}
          url={this.props.url}
          title={this.props.title}
          source={this.props.source}
          type={this.props.type}
          pocket_id={this.props.pocket_id}
          bookmarkGuid={this.props.bookmarkGuid} />}
      </div>
    );
  }
}
export const PlaceholderDSCard = props => <DSCard placeholder={true} />;
