// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_push_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_push_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_PANIC: Int8 = 2

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_PANIC:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

// Public interface members begin here.

private struct FfiConverterInt8: FfiConverterPrimitive {
    typealias FfiType = Int8
    typealias SwiftType = Int8

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int8 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int8, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterUInt64: FfiConverterPrimitive {
    typealias FfiType = UInt64
    typealias SwiftType = UInt64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol PushManagerProtocol {
    func subscribe(scope: String, appServerSey: String?) throws -> SubscriptionResponse
    func getSubscription(scope: String) throws -> SubscriptionResponse?
    func unsubscribe(scope: String) throws -> Bool
    func unsubscribeAll() throws
    func update(registrationToken: String) throws
    func verifyConnection(forceVerify: Bool) throws -> [PushSubscriptionChanged]
    func decrypt(payload: [String: String]) throws -> DecryptResponse
}

public class PushManager: PushManagerProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    public convenience init(config: PushConfiguration) throws {
        try self.init(unsafeFromRawPointer: rustCallWithError(FfiConverterTypePushApiError.lift) {
            uniffi_push_fn_constructor_pushmanager_new(
                FfiConverterTypePushConfiguration.lower(config), $0
            )
        })
    }

    deinit {
        try! rustCall { uniffi_push_fn_free_pushmanager(pointer, $0) }
    }

    public func subscribe(scope: String, appServerSey: String? = nil) throws -> SubscriptionResponse {
        return try FfiConverterTypeSubscriptionResponse.lift(
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_subscribe(self.pointer,
                                                            FfiConverterString.lower(scope),
                                                            FfiConverterOptionString.lower(appServerSey), $0)
            }
        )
    }

    public func getSubscription(scope: String) throws -> SubscriptionResponse? {
        return try FfiConverterOptionTypeSubscriptionResponse.lift(
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_get_subscription(self.pointer,
                                                                   FfiConverterString.lower(scope), $0)
            }
        )
    }

    public func unsubscribe(scope: String) throws -> Bool {
        return try FfiConverterBool.lift(
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_unsubscribe(self.pointer,
                                                              FfiConverterString.lower(scope), $0)
            }
        )
    }

    public func unsubscribeAll() throws {
        try
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_unsubscribe_all(self.pointer, $0)
            }
    }

    public func update(registrationToken: String) throws {
        try
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_update(self.pointer,
                                                         FfiConverterString.lower(registrationToken), $0)
            }
    }

    public func verifyConnection(forceVerify: Bool = false) throws -> [PushSubscriptionChanged] {
        return try FfiConverterSequenceTypePushSubscriptionChanged.lift(
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_verify_connection(self.pointer,
                                                                    FfiConverterBool.lower(forceVerify), $0)
            }
        )
    }

    public func decrypt(payload: [String: String]) throws -> DecryptResponse {
        return try FfiConverterTypeDecryptResponse.lift(
            rustCallWithError(FfiConverterTypePushApiError.lift) {
                uniffi_push_fn_method_pushmanager_decrypt(self.pointer,
                                                          FfiConverterDictionaryStringString.lower(payload), $0)
            }
        )
    }
}

public struct FfiConverterTypePushManager: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = PushManager

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PushManager {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: PushManager, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> PushManager {
        return PushManager(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: PushManager) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypePushManager_lift(_ pointer: UnsafeMutableRawPointer) throws -> PushManager {
    return try FfiConverterTypePushManager.lift(pointer)
}

public func FfiConverterTypePushManager_lower(_ value: PushManager) -> UnsafeMutableRawPointer {
    return FfiConverterTypePushManager.lower(value)
}

public struct DecryptResponse {
    public var result: [Int8]
    public var scope: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(result: [Int8], scope: String) {
        self.result = result
        self.scope = scope
    }
}

extension DecryptResponse: Equatable, Hashable {
    public static func == (lhs: DecryptResponse, rhs: DecryptResponse) -> Bool {
        if lhs.result != rhs.result {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(result)
        hasher.combine(scope)
    }
}

public struct FfiConverterTypeDecryptResponse: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DecryptResponse {
        return try DecryptResponse(
            result: FfiConverterSequenceInt8.read(from: &buf),
            scope: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: DecryptResponse, into buf: inout [UInt8]) {
        FfiConverterSequenceInt8.write(value.result, into: &buf)
        FfiConverterString.write(value.scope, into: &buf)
    }
}

public func FfiConverterTypeDecryptResponse_lift(_ buf: RustBuffer) throws -> DecryptResponse {
    return try FfiConverterTypeDecryptResponse.lift(buf)
}

public func FfiConverterTypeDecryptResponse_lower(_ value: DecryptResponse) -> RustBuffer {
    return FfiConverterTypeDecryptResponse.lower(value)
}

public struct KeyInfo {
    public var auth: String
    public var p256dh: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(auth: String, p256dh: String) {
        self.auth = auth
        self.p256dh = p256dh
    }
}

extension KeyInfo: Equatable, Hashable {
    public static func == (lhs: KeyInfo, rhs: KeyInfo) -> Bool {
        if lhs.auth != rhs.auth {
            return false
        }
        if lhs.p256dh != rhs.p256dh {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(auth)
        hasher.combine(p256dh)
    }
}

public struct FfiConverterTypeKeyInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> KeyInfo {
        return try KeyInfo(
            auth: FfiConverterString.read(from: &buf),
            p256dh: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: KeyInfo, into buf: inout [UInt8]) {
        FfiConverterString.write(value.auth, into: &buf)
        FfiConverterString.write(value.p256dh, into: &buf)
    }
}

public func FfiConverterTypeKeyInfo_lift(_ buf: RustBuffer) throws -> KeyInfo {
    return try FfiConverterTypeKeyInfo.lift(buf)
}

public func FfiConverterTypeKeyInfo_lower(_ value: KeyInfo) -> RustBuffer {
    return FfiConverterTypeKeyInfo.lower(value)
}

public struct PushConfiguration {
    public var serverHost: String
    public var httpProtocol: PushHttpProtocol
    public var bridgeType: BridgeType
    public var senderId: String
    public var databasePath: String
    public var verifyConnectionRateLimiter: UInt64?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(serverHost: String, httpProtocol: PushHttpProtocol, bridgeType: BridgeType, senderId: String, databasePath: String, verifyConnectionRateLimiter: UInt64?) {
        self.serverHost = serverHost
        self.httpProtocol = httpProtocol
        self.bridgeType = bridgeType
        self.senderId = senderId
        self.databasePath = databasePath
        self.verifyConnectionRateLimiter = verifyConnectionRateLimiter
    }
}

extension PushConfiguration: Equatable, Hashable {
    public static func == (lhs: PushConfiguration, rhs: PushConfiguration) -> Bool {
        if lhs.serverHost != rhs.serverHost {
            return false
        }
        if lhs.httpProtocol != rhs.httpProtocol {
            return false
        }
        if lhs.bridgeType != rhs.bridgeType {
            return false
        }
        if lhs.senderId != rhs.senderId {
            return false
        }
        if lhs.databasePath != rhs.databasePath {
            return false
        }
        if lhs.verifyConnectionRateLimiter != rhs.verifyConnectionRateLimiter {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(serverHost)
        hasher.combine(httpProtocol)
        hasher.combine(bridgeType)
        hasher.combine(senderId)
        hasher.combine(databasePath)
        hasher.combine(verifyConnectionRateLimiter)
    }
}

public struct FfiConverterTypePushConfiguration: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PushConfiguration {
        return try PushConfiguration(
            serverHost: FfiConverterString.read(from: &buf),
            httpProtocol: FfiConverterTypePushHttpProtocol.read(from: &buf),
            bridgeType: FfiConverterTypeBridgeType.read(from: &buf),
            senderId: FfiConverterString.read(from: &buf),
            databasePath: FfiConverterString.read(from: &buf),
            verifyConnectionRateLimiter: FfiConverterOptionUInt64.read(from: &buf)
        )
    }

    public static func write(_ value: PushConfiguration, into buf: inout [UInt8]) {
        FfiConverterString.write(value.serverHost, into: &buf)
        FfiConverterTypePushHttpProtocol.write(value.httpProtocol, into: &buf)
        FfiConverterTypeBridgeType.write(value.bridgeType, into: &buf)
        FfiConverterString.write(value.senderId, into: &buf)
        FfiConverterString.write(value.databasePath, into: &buf)
        FfiConverterOptionUInt64.write(value.verifyConnectionRateLimiter, into: &buf)
    }
}

public func FfiConverterTypePushConfiguration_lift(_ buf: RustBuffer) throws -> PushConfiguration {
    return try FfiConverterTypePushConfiguration.lift(buf)
}

public func FfiConverterTypePushConfiguration_lower(_ value: PushConfiguration) -> RustBuffer {
    return FfiConverterTypePushConfiguration.lower(value)
}

public struct PushSubscriptionChanged {
    public var channelId: String
    public var scope: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(channelId: String, scope: String) {
        self.channelId = channelId
        self.scope = scope
    }
}

extension PushSubscriptionChanged: Equatable, Hashable {
    public static func == (lhs: PushSubscriptionChanged, rhs: PushSubscriptionChanged) -> Bool {
        if lhs.channelId != rhs.channelId {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(channelId)
        hasher.combine(scope)
    }
}

public struct FfiConverterTypePushSubscriptionChanged: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PushSubscriptionChanged {
        return try PushSubscriptionChanged(
            channelId: FfiConverterString.read(from: &buf),
            scope: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: PushSubscriptionChanged, into buf: inout [UInt8]) {
        FfiConverterString.write(value.channelId, into: &buf)
        FfiConverterString.write(value.scope, into: &buf)
    }
}

public func FfiConverterTypePushSubscriptionChanged_lift(_ buf: RustBuffer) throws -> PushSubscriptionChanged {
    return try FfiConverterTypePushSubscriptionChanged.lift(buf)
}

public func FfiConverterTypePushSubscriptionChanged_lower(_ value: PushSubscriptionChanged) -> RustBuffer {
    return FfiConverterTypePushSubscriptionChanged.lower(value)
}

public struct SubscriptionInfo {
    public var endpoint: String
    public var keys: KeyInfo

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(endpoint: String, keys: KeyInfo) {
        self.endpoint = endpoint
        self.keys = keys
    }
}

extension SubscriptionInfo: Equatable, Hashable {
    public static func == (lhs: SubscriptionInfo, rhs: SubscriptionInfo) -> Bool {
        if lhs.endpoint != rhs.endpoint {
            return false
        }
        if lhs.keys != rhs.keys {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(endpoint)
        hasher.combine(keys)
    }
}

public struct FfiConverterTypeSubscriptionInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SubscriptionInfo {
        return try SubscriptionInfo(
            endpoint: FfiConverterString.read(from: &buf),
            keys: FfiConverterTypeKeyInfo.read(from: &buf)
        )
    }

    public static func write(_ value: SubscriptionInfo, into buf: inout [UInt8]) {
        FfiConverterString.write(value.endpoint, into: &buf)
        FfiConverterTypeKeyInfo.write(value.keys, into: &buf)
    }
}

public func FfiConverterTypeSubscriptionInfo_lift(_ buf: RustBuffer) throws -> SubscriptionInfo {
    return try FfiConverterTypeSubscriptionInfo.lift(buf)
}

public func FfiConverterTypeSubscriptionInfo_lower(_ value: SubscriptionInfo) -> RustBuffer {
    return FfiConverterTypeSubscriptionInfo.lower(value)
}

public struct SubscriptionResponse {
    public var channelId: String
    public var subscriptionInfo: SubscriptionInfo

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(channelId: String, subscriptionInfo: SubscriptionInfo) {
        self.channelId = channelId
        self.subscriptionInfo = subscriptionInfo
    }
}

extension SubscriptionResponse: Equatable, Hashable {
    public static func == (lhs: SubscriptionResponse, rhs: SubscriptionResponse) -> Bool {
        if lhs.channelId != rhs.channelId {
            return false
        }
        if lhs.subscriptionInfo != rhs.subscriptionInfo {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(channelId)
        hasher.combine(subscriptionInfo)
    }
}

public struct FfiConverterTypeSubscriptionResponse: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SubscriptionResponse {
        return try SubscriptionResponse(
            channelId: FfiConverterString.read(from: &buf),
            subscriptionInfo: FfiConverterTypeSubscriptionInfo.read(from: &buf)
        )
    }

    public static func write(_ value: SubscriptionResponse, into buf: inout [UInt8]) {
        FfiConverterString.write(value.channelId, into: &buf)
        FfiConverterTypeSubscriptionInfo.write(value.subscriptionInfo, into: &buf)
    }
}

public func FfiConverterTypeSubscriptionResponse_lift(_ buf: RustBuffer) throws -> SubscriptionResponse {
    return try FfiConverterTypeSubscriptionResponse.lift(buf)
}

public func FfiConverterTypeSubscriptionResponse_lower(_ value: SubscriptionResponse) -> RustBuffer {
    return FfiConverterTypeSubscriptionResponse.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum BridgeType {
    case fcm
    case adm
    case apns
}

public struct FfiConverterTypeBridgeType: FfiConverterRustBuffer {
    typealias SwiftType = BridgeType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BridgeType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .fcm

        case 2: return .adm

        case 3: return .apns

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: BridgeType, into buf: inout [UInt8]) {
        switch value {
        case .fcm:
            writeInt(&buf, Int32(1))

        case .adm:
            writeInt(&buf, Int32(2))

        case .apns:
            writeInt(&buf, Int32(3))
        }
    }
}

public func FfiConverterTypeBridgeType_lift(_ buf: RustBuffer) throws -> BridgeType {
    return try FfiConverterTypeBridgeType.lift(buf)
}

public func FfiConverterTypeBridgeType_lower(_ value: BridgeType) -> RustBuffer {
    return FfiConverterTypeBridgeType.lower(value)
}

extension BridgeType: Equatable, Hashable {}

public enum PushApiError {
    // Simple error enums only carry a message
    case UaidNotRecognizedError(message: String)

    // Simple error enums only carry a message
    case RecordNotFoundError(message: String)

    // Simple error enums only carry a message
    case InternalError(message: String)

    fileprivate static func uniffiErrorHandler(_ error: RustBuffer) throws -> Error {
        return try FfiConverterTypePushApiError.lift(error)
    }
}

public struct FfiConverterTypePushApiError: FfiConverterRustBuffer {
    typealias SwiftType = PushApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PushApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .UaidNotRecognizedError(
                message: FfiConverterString.read(from: &buf)
            )

        case 2: return try .RecordNotFoundError(
                message: FfiConverterString.read(from: &buf)
            )

        case 3: return try .InternalError(
                message: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: PushApiError, into buf: inout [UInt8]) {
        switch value {
        case let .UaidNotRecognizedError(message):
            writeInt(&buf, Int32(1))
        case let .RecordNotFoundError(message):
            writeInt(&buf, Int32(2))
        case let .InternalError(message):
            writeInt(&buf, Int32(3))
        }
    }
}

extension PushApiError: Equatable, Hashable {}

extension PushApiError: Error {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum PushHttpProtocol {
    case https
    case http
}

public struct FfiConverterTypePushHttpProtocol: FfiConverterRustBuffer {
    typealias SwiftType = PushHttpProtocol

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PushHttpProtocol {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .https

        case 2: return .http

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: PushHttpProtocol, into buf: inout [UInt8]) {
        switch value {
        case .https:
            writeInt(&buf, Int32(1))

        case .http:
            writeInt(&buf, Int32(2))
        }
    }
}

public func FfiConverterTypePushHttpProtocol_lift(_ buf: RustBuffer) throws -> PushHttpProtocol {
    return try FfiConverterTypePushHttpProtocol.lift(buf)
}

public func FfiConverterTypePushHttpProtocol_lower(_ value: PushHttpProtocol) -> RustBuffer {
    return FfiConverterTypePushHttpProtocol.lower(value)
}

extension PushHttpProtocol: Equatable, Hashable {}

private struct FfiConverterOptionUInt64: FfiConverterRustBuffer {
    typealias SwiftType = UInt64?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterUInt64.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterUInt64.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeSubscriptionResponse: FfiConverterRustBuffer {
    typealias SwiftType = SubscriptionResponse?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeSubscriptionResponse.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeSubscriptionResponse.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceInt8: FfiConverterRustBuffer {
    typealias SwiftType = [Int8]

    public static func write(_ value: [Int8], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterInt8.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Int8] {
        let len: Int32 = try readInt(&buf)
        var seq = [Int8]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterInt8.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypePushSubscriptionChanged: FfiConverterRustBuffer {
    typealias SwiftType = [PushSubscriptionChanged]

    public static func write(_ value: [PushSubscriptionChanged], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypePushSubscriptionChanged.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [PushSubscriptionChanged] {
        let len: Int32 = try readInt(&buf)
        var seq = [PushSubscriptionChanged]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypePushSubscriptionChanged.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterDictionaryStringString: FfiConverterRustBuffer {
    public static func write(_ value: [String: String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for (key, value) in value {
            FfiConverterString.write(key, into: &buf)
            FfiConverterString.write(value, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String: String] {
        let len: Int32 = try readInt(&buf)
        var dict = [String: String]()
        dict.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            let key = try FfiConverterString.read(from: &buf)
            let value = try FfiConverterString.read(from: &buf)
            dict[key] = value
        }
        return dict
    }
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 22
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_push_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_push_checksum_method_pushmanager_subscribe() != 14735 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_method_pushmanager_get_subscription() != 56522 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_method_pushmanager_unsubscribe() != 51690 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_method_pushmanager_unsubscribe_all() != 3459 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_method_pushmanager_update() != 1735 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_method_pushmanager_verify_connection() != 42522 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_method_pushmanager_decrypt() != 7991 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_push_checksum_constructor_pushmanager_new() != 55042 {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}
