// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_fxa_client_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_fxa_client_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_PANIC: Int8 = 2
private let CALL_CANCELLED: Int8 = 3

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_PANIC:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    case CALL_CANCELLED:
        throw CancellationError()

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

// Public interface members begin here.

private struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol FirefoxAccountProtocol {
    func authorizeCodeUsingSessionToken(params: AuthorizationParameters) throws -> String
    func beginOauthFlow(scopes: [String], entrypoint: String) throws -> String
    func beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String) throws -> String
    func checkAuthorizationStatus() throws -> AuthorizationInfo
    func clearAccessTokenCache()
    func clearDeviceName() throws
    func completeOauthFlow(code: String, state: String) throws
    func disconnect()
    func ensureCapabilities(supportedCapabilities: [DeviceCapability]) throws -> LocalDevice
    func gatherTelemetry() throws -> String
    func getAccessToken(scope: String, ttl: Int64?) throws -> AccessTokenInfo
    func getAttachedClients() throws -> [AttachedClient]
    func getAuthState() -> FxaRustAuthState
    func getConnectionSuccessUrl() throws -> String
    func getCurrentDeviceId() throws -> String
    func getDevices(ignoreCache: Bool) throws -> [Device]
    func getManageAccountUrl(entrypoint: String) throws -> String
    func getManageDevicesUrl(entrypoint: String) throws -> String
    func getPairingAuthorityUrl() throws -> String
    func getProfile(ignoreCache: Bool) throws -> Profile
    func getSessionToken() throws -> String
    func getState() -> FxaState
    func getTokenServerEndpointUrl() throws -> String
    func handlePushMessage(payload: String) throws -> AccountEvent
    func handleSessionTokenChange(sessionToken: String) throws
    func initializeDevice(name: String, deviceType: DeviceType, supportedCapabilities: [DeviceCapability]) throws -> LocalDevice
    func onAuthIssues()
    func pollDeviceCommands() throws -> [IncomingDeviceCommand]
    func processEvent(event: FxaEvent) throws -> FxaState
    func sendSingleTab(targetDeviceId: String, title: String, url: String) throws
    func setDeviceName(displayName: String) throws -> LocalDevice
    func setPushSubscription(subscription: DevicePushSubscription) throws -> LocalDevice
    func simulateNetworkError()
    func simulatePermanentAuthTokenIssue()
    func simulateTemporaryAuthTokenIssue()
    func toJson() throws -> String
}

public class FirefoxAccount: FirefoxAccountProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    public convenience init(config: FxaConfig) {
        self.init(unsafeFromRawPointer: try! rustCall {
            uniffi_fxa_client_fn_constructor_firefoxaccount_new(
                FfiConverterTypeFxaConfig.lower(config), $0
            )
        })
    }

    deinit {
        try! rustCall { uniffi_fxa_client_fn_free_firefoxaccount(pointer, $0) }
    }

    public static func fromJson(data: String) throws -> FirefoxAccount {
        return try FirefoxAccount(unsafeFromRawPointer: rustCallWithError(FfiConverterTypeFxaError.lift) {
            uniffi_fxa_client_fn_constructor_firefoxaccount_from_json(
                FfiConverterString.lower(data), $0
            )
        })
    }

    public func authorizeCodeUsingSessionToken(params: AuthorizationParameters) throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_authorize_code_using_session_token(self.pointer,
                                                                                              FfiConverterTypeAuthorizationParameters.lower(params), $0)
            }
        )
    }

    public func beginOauthFlow(scopes: [String], entrypoint: String) throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_begin_oauth_flow(self.pointer,
                                                                            FfiConverterSequenceString.lower(scopes),
                                                                            FfiConverterString.lower(entrypoint), $0)
            }
        )
    }

    public func beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String) throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_begin_pairing_flow(self.pointer,
                                                                              FfiConverterString.lower(pairingUrl),
                                                                              FfiConverterSequenceString.lower(scopes),
                                                                              FfiConverterString.lower(entrypoint), $0)
            }
        )
    }

    public func checkAuthorizationStatus() throws -> AuthorizationInfo {
        return try FfiConverterTypeAuthorizationInfo.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_check_authorization_status(self.pointer, $0)
            }
        )
    }

    public func clearAccessTokenCache() {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_firefoxaccount_clear_access_token_cache(self.pointer, $0)
            }
    }

    public func clearDeviceName() throws {
        try
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_clear_device_name(self.pointer, $0)
            }
    }

    public func completeOauthFlow(code: String, state: String) throws {
        try
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_complete_oauth_flow(self.pointer,
                                                                               FfiConverterString.lower(code),
                                                                               FfiConverterString.lower(state), $0)
            }
    }

    public func disconnect() {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_firefoxaccount_disconnect(self.pointer, $0)
            }
    }

    public func ensureCapabilities(supportedCapabilities: [DeviceCapability]) throws -> LocalDevice {
        return try FfiConverterTypeLocalDevice.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_ensure_capabilities(self.pointer,
                                                                               FfiConverterSequenceTypeDeviceCapability.lower(supportedCapabilities), $0)
            }
        )
    }

    public func gatherTelemetry() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_gather_telemetry(self.pointer, $0)
            }
        )
    }

    public func getAccessToken(scope: String, ttl: Int64? = nil) throws -> AccessTokenInfo {
        return try FfiConverterTypeAccessTokenInfo.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_access_token(self.pointer,
                                                                            FfiConverterString.lower(scope),
                                                                            FfiConverterOptionInt64.lower(ttl), $0)
            }
        )
    }

    public func getAttachedClients() throws -> [AttachedClient] {
        return try FfiConverterSequenceTypeAttachedClient.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_attached_clients(self.pointer, $0)
            }
        )
    }

    public func getAuthState() -> FxaRustAuthState {
        return try! FfiConverterTypeFxaRustAuthState.lift(
            try!
                rustCall {
                    uniffi_fxa_client_fn_method_firefoxaccount_get_auth_state(self.pointer, $0)
                }
        )
    }

    public func getConnectionSuccessUrl() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_connection_success_url(self.pointer, $0)
            }
        )
    }

    public func getCurrentDeviceId() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_current_device_id(self.pointer, $0)
            }
        )
    }

    public func getDevices(ignoreCache: Bool) throws -> [Device] {
        return try FfiConverterSequenceTypeDevice.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_devices(self.pointer,
                                                                       FfiConverterBool.lower(ignoreCache), $0)
            }
        )
    }

    public func getManageAccountUrl(entrypoint: String) throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_manage_account_url(self.pointer,
                                                                                  FfiConverterString.lower(entrypoint), $0)
            }
        )
    }

    public func getManageDevicesUrl(entrypoint: String) throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_manage_devices_url(self.pointer,
                                                                                  FfiConverterString.lower(entrypoint), $0)
            }
        )
    }

    public func getPairingAuthorityUrl() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_pairing_authority_url(self.pointer, $0)
            }
        )
    }

    public func getProfile(ignoreCache: Bool) throws -> Profile {
        return try FfiConverterTypeProfile.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_profile(self.pointer,
                                                                       FfiConverterBool.lower(ignoreCache), $0)
            }
        )
    }

    public func getSessionToken() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_session_token(self.pointer, $0)
            }
        )
    }

    public func getState() -> FxaState {
        return try! FfiConverterTypeFxaState.lift(
            try!
                rustCall {
                    uniffi_fxa_client_fn_method_firefoxaccount_get_state(self.pointer, $0)
                }
        )
    }

    public func getTokenServerEndpointUrl() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_get_token_server_endpoint_url(self.pointer, $0)
            }
        )
    }

    public func handlePushMessage(payload: String) throws -> AccountEvent {
        return try FfiConverterTypeAccountEvent.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_handle_push_message(self.pointer,
                                                                               FfiConverterString.lower(payload), $0)
            }
        )
    }

    public func handleSessionTokenChange(sessionToken: String) throws {
        try
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_handle_session_token_change(self.pointer,
                                                                                       FfiConverterString.lower(sessionToken), $0)
            }
    }

    public func initializeDevice(name: String, deviceType: DeviceType, supportedCapabilities: [DeviceCapability]) throws -> LocalDevice {
        return try FfiConverterTypeLocalDevice.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_initialize_device(self.pointer,
                                                                             FfiConverterString.lower(name),
                                                                             FfiConverterTypeDeviceType_lower(deviceType),
                                                                             FfiConverterSequenceTypeDeviceCapability.lower(supportedCapabilities), $0)
            }
        )
    }

    public func onAuthIssues() {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_firefoxaccount_on_auth_issues(self.pointer, $0)
            }
    }

    public func pollDeviceCommands() throws -> [IncomingDeviceCommand] {
        return try FfiConverterSequenceTypeIncomingDeviceCommand.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_poll_device_commands(self.pointer, $0)
            }
        )
    }

    public func processEvent(event: FxaEvent) throws -> FxaState {
        return try FfiConverterTypeFxaState.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_process_event(self.pointer,
                                                                         FfiConverterTypeFxaEvent.lower(event), $0)
            }
        )
    }

    public func sendSingleTab(targetDeviceId: String, title: String, url: String) throws {
        try
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_send_single_tab(self.pointer,
                                                                           FfiConverterString.lower(targetDeviceId),
                                                                           FfiConverterString.lower(title),
                                                                           FfiConverterString.lower(url), $0)
            }
    }

    public func setDeviceName(displayName: String) throws -> LocalDevice {
        return try FfiConverterTypeLocalDevice.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_set_device_name(self.pointer,
                                                                           FfiConverterString.lower(displayName), $0)
            }
        )
    }

    public func setPushSubscription(subscription: DevicePushSubscription) throws -> LocalDevice {
        return try FfiConverterTypeLocalDevice.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_set_push_subscription(self.pointer,
                                                                                 FfiConverterTypeDevicePushSubscription.lower(subscription), $0)
            }
        )
    }

    public func simulateNetworkError() {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_firefoxaccount_simulate_network_error(self.pointer, $0)
            }
    }

    public func simulatePermanentAuthTokenIssue() {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_firefoxaccount_simulate_permanent_auth_token_issue(self.pointer, $0)
            }
    }

    public func simulateTemporaryAuthTokenIssue() {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_firefoxaccount_simulate_temporary_auth_token_issue(self.pointer, $0)
            }
    }

    public func toJson() throws -> String {
        return try FfiConverterString.lift(
            rustCallWithError(FfiConverterTypeFxaError.lift) {
                uniffi_fxa_client_fn_method_firefoxaccount_to_json(self.pointer, $0)
            }
        )
    }
}

public struct FfiConverterTypeFirefoxAccount: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = FirefoxAccount

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FirefoxAccount {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: FirefoxAccount, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> FirefoxAccount {
        return FirefoxAccount(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: FirefoxAccount) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypeFirefoxAccount_lift(_ pointer: UnsafeMutableRawPointer) throws -> FirefoxAccount {
    return try FfiConverterTypeFirefoxAccount.lift(pointer)
}

public func FfiConverterTypeFirefoxAccount_lower(_ value: FirefoxAccount) -> UnsafeMutableRawPointer {
    return FfiConverterTypeFirefoxAccount.lower(value)
}

public protocol FxaStateMachineCheckerProtocol {
    func checkInternalState(state: FxaStateCheckerState)
    func checkPublicState(state: FxaState)
    func handleInternalEvent(event: FxaStateCheckerEvent)
    func handlePublicEvent(event: FxaEvent)
}

public class FxaStateMachineChecker: FxaStateMachineCheckerProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    public convenience init() {
        self.init(unsafeFromRawPointer: try! rustCall {
            uniffi_fxa_client_fn_constructor_fxastatemachinechecker_new($0)
        })
    }

    deinit {
        try! rustCall { uniffi_fxa_client_fn_free_fxastatemachinechecker(pointer, $0) }
    }

    public func checkInternalState(state: FxaStateCheckerState) {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_fxastatemachinechecker_check_internal_state(self.pointer,
                                                                                        FfiConverterTypeFxaStateCheckerState.lower(state), $0)
            }
    }

    public func checkPublicState(state: FxaState) {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_fxastatemachinechecker_check_public_state(self.pointer,
                                                                                      FfiConverterTypeFxaState.lower(state), $0)
            }
    }

    public func handleInternalEvent(event: FxaStateCheckerEvent) {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_fxastatemachinechecker_handle_internal_event(self.pointer,
                                                                                         FfiConverterTypeFxaStateCheckerEvent.lower(event), $0)
            }
    }

    public func handlePublicEvent(event: FxaEvent) {
        try!
            rustCall {
                uniffi_fxa_client_fn_method_fxastatemachinechecker_handle_public_event(self.pointer,
                                                                                       FfiConverterTypeFxaEvent.lower(event), $0)
            }
    }
}

public struct FfiConverterTypeFxaStateMachineChecker: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = FxaStateMachineChecker

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaStateMachineChecker {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: FxaStateMachineChecker, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> FxaStateMachineChecker {
        return FxaStateMachineChecker(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: FxaStateMachineChecker) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypeFxaStateMachineChecker_lift(_ pointer: UnsafeMutableRawPointer) throws -> FxaStateMachineChecker {
    return try FfiConverterTypeFxaStateMachineChecker.lift(pointer)
}

public func FfiConverterTypeFxaStateMachineChecker_lower(_ value: FxaStateMachineChecker) -> UnsafeMutableRawPointer {
    return FfiConverterTypeFxaStateMachineChecker.lower(value)
}

public struct AccessTokenInfo {
    public var scope: String
    public var token: String
    public var key: ScopedKey?
    public var expiresAt: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(scope: String, token: String, key: ScopedKey?, expiresAt: Int64) {
        self.scope = scope
        self.token = token
        self.key = key
        self.expiresAt = expiresAt
    }
}

extension AccessTokenInfo: Equatable, Hashable {
    public static func == (lhs: AccessTokenInfo, rhs: AccessTokenInfo) -> Bool {
        if lhs.scope != rhs.scope {
            return false
        }
        if lhs.token != rhs.token {
            return false
        }
        if lhs.key != rhs.key {
            return false
        }
        if lhs.expiresAt != rhs.expiresAt {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(scope)
        hasher.combine(token)
        hasher.combine(key)
        hasher.combine(expiresAt)
    }
}

public struct FfiConverterTypeAccessTokenInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AccessTokenInfo {
        return try AccessTokenInfo(
            scope: FfiConverterString.read(from: &buf),
            token: FfiConverterString.read(from: &buf),
            key: FfiConverterOptionTypeScopedKey.read(from: &buf),
            expiresAt: FfiConverterInt64.read(from: &buf)
        )
    }

    public static func write(_ value: AccessTokenInfo, into buf: inout [UInt8]) {
        FfiConverterString.write(value.scope, into: &buf)
        FfiConverterString.write(value.token, into: &buf)
        FfiConverterOptionTypeScopedKey.write(value.key, into: &buf)
        FfiConverterInt64.write(value.expiresAt, into: &buf)
    }
}

public func FfiConverterTypeAccessTokenInfo_lift(_ buf: RustBuffer) throws -> AccessTokenInfo {
    return try FfiConverterTypeAccessTokenInfo.lift(buf)
}

public func FfiConverterTypeAccessTokenInfo_lower(_ value: AccessTokenInfo) -> RustBuffer {
    return FfiConverterTypeAccessTokenInfo.lower(value)
}

public struct AttachedClient {
    public var clientId: String?
    public var deviceId: String?
    public var deviceType: DeviceType
    public var isCurrentSession: Bool
    public var name: String?
    public var createdTime: Int64?
    public var lastAccessTime: Int64?
    public var scope: [String]?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(clientId: String?, deviceId: String?, deviceType: DeviceType, isCurrentSession: Bool, name: String?, createdTime: Int64?, lastAccessTime: Int64?, scope: [String]?) {
        self.clientId = clientId
        self.deviceId = deviceId
        self.deviceType = deviceType
        self.isCurrentSession = isCurrentSession
        self.name = name
        self.createdTime = createdTime
        self.lastAccessTime = lastAccessTime
        self.scope = scope
    }
}

extension AttachedClient: Equatable, Hashable {
    public static func == (lhs: AttachedClient, rhs: AttachedClient) -> Bool {
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.deviceId != rhs.deviceId {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.isCurrentSession != rhs.isCurrentSession {
            return false
        }
        if lhs.name != rhs.name {
            return false
        }
        if lhs.createdTime != rhs.createdTime {
            return false
        }
        if lhs.lastAccessTime != rhs.lastAccessTime {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(clientId)
        hasher.combine(deviceId)
        hasher.combine(deviceType)
        hasher.combine(isCurrentSession)
        hasher.combine(name)
        hasher.combine(createdTime)
        hasher.combine(lastAccessTime)
        hasher.combine(scope)
    }
}

public struct FfiConverterTypeAttachedClient: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AttachedClient {
        return try AttachedClient(
            clientId: FfiConverterOptionString.read(from: &buf),
            deviceId: FfiConverterOptionString.read(from: &buf),
            deviceType: FfiConverterTypeDeviceType.read(from: &buf),
            isCurrentSession: FfiConverterBool.read(from: &buf),
            name: FfiConverterOptionString.read(from: &buf),
            createdTime: FfiConverterOptionInt64.read(from: &buf),
            lastAccessTime: FfiConverterOptionInt64.read(from: &buf),
            scope: FfiConverterOptionSequenceString.read(from: &buf)
        )
    }

    public static func write(_ value: AttachedClient, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.clientId, into: &buf)
        FfiConverterOptionString.write(value.deviceId, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterBool.write(value.isCurrentSession, into: &buf)
        FfiConverterOptionString.write(value.name, into: &buf)
        FfiConverterOptionInt64.write(value.createdTime, into: &buf)
        FfiConverterOptionInt64.write(value.lastAccessTime, into: &buf)
        FfiConverterOptionSequenceString.write(value.scope, into: &buf)
    }
}

public func FfiConverterTypeAttachedClient_lift(_ buf: RustBuffer) throws -> AttachedClient {
    return try FfiConverterTypeAttachedClient.lift(buf)
}

public func FfiConverterTypeAttachedClient_lower(_ value: AttachedClient) -> RustBuffer {
    return FfiConverterTypeAttachedClient.lower(value)
}

public struct AuthorizationInfo {
    public var active: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(active: Bool) {
        self.active = active
    }
}

extension AuthorizationInfo: Equatable, Hashable {
    public static func == (lhs: AuthorizationInfo, rhs: AuthorizationInfo) -> Bool {
        if lhs.active != rhs.active {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(active)
    }
}

public struct FfiConverterTypeAuthorizationInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AuthorizationInfo {
        return try AuthorizationInfo(
            active: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: AuthorizationInfo, into buf: inout [UInt8]) {
        FfiConverterBool.write(value.active, into: &buf)
    }
}

public func FfiConverterTypeAuthorizationInfo_lift(_ buf: RustBuffer) throws -> AuthorizationInfo {
    return try FfiConverterTypeAuthorizationInfo.lift(buf)
}

public func FfiConverterTypeAuthorizationInfo_lower(_ value: AuthorizationInfo) -> RustBuffer {
    return FfiConverterTypeAuthorizationInfo.lower(value)
}

public struct AuthorizationParameters {
    public var clientId: String
    public var scope: [String]
    public var state: String
    public var accessType: String
    public var codeChallenge: String?
    public var codeChallengeMethod: String?
    public var keysJwk: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(clientId: String, scope: [String], state: String, accessType: String, codeChallenge: String?, codeChallengeMethod: String?, keysJwk: String?) {
        self.clientId = clientId
        self.scope = scope
        self.state = state
        self.accessType = accessType
        self.codeChallenge = codeChallenge
        self.codeChallengeMethod = codeChallengeMethod
        self.keysJwk = keysJwk
    }
}

extension AuthorizationParameters: Equatable, Hashable {
    public static func == (lhs: AuthorizationParameters, rhs: AuthorizationParameters) -> Bool {
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        if lhs.state != rhs.state {
            return false
        }
        if lhs.accessType != rhs.accessType {
            return false
        }
        if lhs.codeChallenge != rhs.codeChallenge {
            return false
        }
        if lhs.codeChallengeMethod != rhs.codeChallengeMethod {
            return false
        }
        if lhs.keysJwk != rhs.keysJwk {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(clientId)
        hasher.combine(scope)
        hasher.combine(state)
        hasher.combine(accessType)
        hasher.combine(codeChallenge)
        hasher.combine(codeChallengeMethod)
        hasher.combine(keysJwk)
    }
}

public struct FfiConverterTypeAuthorizationParameters: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AuthorizationParameters {
        return try AuthorizationParameters(
            clientId: FfiConverterString.read(from: &buf),
            scope: FfiConverterSequenceString.read(from: &buf),
            state: FfiConverterString.read(from: &buf),
            accessType: FfiConverterString.read(from: &buf),
            codeChallenge: FfiConverterOptionString.read(from: &buf),
            codeChallengeMethod: FfiConverterOptionString.read(from: &buf),
            keysJwk: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: AuthorizationParameters, into buf: inout [UInt8]) {
        FfiConverterString.write(value.clientId, into: &buf)
        FfiConverterSequenceString.write(value.scope, into: &buf)
        FfiConverterString.write(value.state, into: &buf)
        FfiConverterString.write(value.accessType, into: &buf)
        FfiConverterOptionString.write(value.codeChallenge, into: &buf)
        FfiConverterOptionString.write(value.codeChallengeMethod, into: &buf)
        FfiConverterOptionString.write(value.keysJwk, into: &buf)
    }
}

public func FfiConverterTypeAuthorizationParameters_lift(_ buf: RustBuffer) throws -> AuthorizationParameters {
    return try FfiConverterTypeAuthorizationParameters.lift(buf)
}

public func FfiConverterTypeAuthorizationParameters_lower(_ value: AuthorizationParameters) -> RustBuffer {
    return FfiConverterTypeAuthorizationParameters.lower(value)
}

public struct Device {
    public var id: String
    public var displayName: String
    public var deviceType: DeviceType
    public var capabilities: [DeviceCapability]
    public var pushSubscription: DevicePushSubscription?
    public var pushEndpointExpired: Bool
    public var isCurrentDevice: Bool
    public var lastAccessTime: Int64?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, displayName: String, deviceType: DeviceType, capabilities: [DeviceCapability], pushSubscription: DevicePushSubscription?, pushEndpointExpired: Bool, isCurrentDevice: Bool, lastAccessTime: Int64?) {
        self.id = id
        self.displayName = displayName
        self.deviceType = deviceType
        self.capabilities = capabilities
        self.pushSubscription = pushSubscription
        self.pushEndpointExpired = pushEndpointExpired
        self.isCurrentDevice = isCurrentDevice
        self.lastAccessTime = lastAccessTime
    }
}

extension Device: Equatable, Hashable {
    public static func == (lhs: Device, rhs: Device) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.displayName != rhs.displayName {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.capabilities != rhs.capabilities {
            return false
        }
        if lhs.pushSubscription != rhs.pushSubscription {
            return false
        }
        if lhs.pushEndpointExpired != rhs.pushEndpointExpired {
            return false
        }
        if lhs.isCurrentDevice != rhs.isCurrentDevice {
            return false
        }
        if lhs.lastAccessTime != rhs.lastAccessTime {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(displayName)
        hasher.combine(deviceType)
        hasher.combine(capabilities)
        hasher.combine(pushSubscription)
        hasher.combine(pushEndpointExpired)
        hasher.combine(isCurrentDevice)
        hasher.combine(lastAccessTime)
    }
}

public struct FfiConverterTypeDevice: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Device {
        return try Device(
            id: FfiConverterString.read(from: &buf),
            displayName: FfiConverterString.read(from: &buf),
            deviceType: FfiConverterTypeDeviceType.read(from: &buf),
            capabilities: FfiConverterSequenceTypeDeviceCapability.read(from: &buf),
            pushSubscription: FfiConverterOptionTypeDevicePushSubscription.read(from: &buf),
            pushEndpointExpired: FfiConverterBool.read(from: &buf),
            isCurrentDevice: FfiConverterBool.read(from: &buf),
            lastAccessTime: FfiConverterOptionInt64.read(from: &buf)
        )
    }

    public static func write(_ value: Device, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterString.write(value.displayName, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterSequenceTypeDeviceCapability.write(value.capabilities, into: &buf)
        FfiConverterOptionTypeDevicePushSubscription.write(value.pushSubscription, into: &buf)
        FfiConverterBool.write(value.pushEndpointExpired, into: &buf)
        FfiConverterBool.write(value.isCurrentDevice, into: &buf)
        FfiConverterOptionInt64.write(value.lastAccessTime, into: &buf)
    }
}

public func FfiConverterTypeDevice_lift(_ buf: RustBuffer) throws -> Device {
    return try FfiConverterTypeDevice.lift(buf)
}

public func FfiConverterTypeDevice_lower(_ value: Device) -> RustBuffer {
    return FfiConverterTypeDevice.lower(value)
}

public struct DeviceConfig {
    public var name: String
    public var deviceType: DeviceType
    public var capabilities: [DeviceCapability]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(name: String, deviceType: DeviceType, capabilities: [DeviceCapability]) {
        self.name = name
        self.deviceType = deviceType
        self.capabilities = capabilities
    }
}

extension DeviceConfig: Equatable, Hashable {
    public static func == (lhs: DeviceConfig, rhs: DeviceConfig) -> Bool {
        if lhs.name != rhs.name {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.capabilities != rhs.capabilities {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(name)
        hasher.combine(deviceType)
        hasher.combine(capabilities)
    }
}

public struct FfiConverterTypeDeviceConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DeviceConfig {
        return try DeviceConfig(
            name: FfiConverterString.read(from: &buf),
            deviceType: FfiConverterTypeDeviceType.read(from: &buf),
            capabilities: FfiConverterSequenceTypeDeviceCapability.read(from: &buf)
        )
    }

    public static func write(_ value: DeviceConfig, into buf: inout [UInt8]) {
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterSequenceTypeDeviceCapability.write(value.capabilities, into: &buf)
    }
}

public func FfiConverterTypeDeviceConfig_lift(_ buf: RustBuffer) throws -> DeviceConfig {
    return try FfiConverterTypeDeviceConfig.lift(buf)
}

public func FfiConverterTypeDeviceConfig_lower(_ value: DeviceConfig) -> RustBuffer {
    return FfiConverterTypeDeviceConfig.lower(value)
}

public struct DevicePushSubscription {
    public var endpoint: String
    public var publicKey: String
    public var authKey: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(endpoint: String, publicKey: String, authKey: String) {
        self.endpoint = endpoint
        self.publicKey = publicKey
        self.authKey = authKey
    }
}

extension DevicePushSubscription: Equatable, Hashable {
    public static func == (lhs: DevicePushSubscription, rhs: DevicePushSubscription) -> Bool {
        if lhs.endpoint != rhs.endpoint {
            return false
        }
        if lhs.publicKey != rhs.publicKey {
            return false
        }
        if lhs.authKey != rhs.authKey {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(endpoint)
        hasher.combine(publicKey)
        hasher.combine(authKey)
    }
}

public struct FfiConverterTypeDevicePushSubscription: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DevicePushSubscription {
        return try DevicePushSubscription(
            endpoint: FfiConverterString.read(from: &buf),
            publicKey: FfiConverterString.read(from: &buf),
            authKey: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: DevicePushSubscription, into buf: inout [UInt8]) {
        FfiConverterString.write(value.endpoint, into: &buf)
        FfiConverterString.write(value.publicKey, into: &buf)
        FfiConverterString.write(value.authKey, into: &buf)
    }
}

public func FfiConverterTypeDevicePushSubscription_lift(_ buf: RustBuffer) throws -> DevicePushSubscription {
    return try FfiConverterTypeDevicePushSubscription.lift(buf)
}

public func FfiConverterTypeDevicePushSubscription_lower(_ value: DevicePushSubscription) -> RustBuffer {
    return FfiConverterTypeDevicePushSubscription.lower(value)
}

public struct FxaConfig {
    public var server: FxaServer
    public var clientId: String
    public var redirectUri: String
    public var tokenServerUrlOverride: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(server: FxaServer, clientId: String, redirectUri: String, tokenServerUrlOverride: String? = nil) {
        self.server = server
        self.clientId = clientId
        self.redirectUri = redirectUri
        self.tokenServerUrlOverride = tokenServerUrlOverride
    }
}

extension FxaConfig: Equatable, Hashable {
    public static func == (lhs: FxaConfig, rhs: FxaConfig) -> Bool {
        if lhs.server != rhs.server {
            return false
        }
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.redirectUri != rhs.redirectUri {
            return false
        }
        if lhs.tokenServerUrlOverride != rhs.tokenServerUrlOverride {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(server)
        hasher.combine(clientId)
        hasher.combine(redirectUri)
        hasher.combine(tokenServerUrlOverride)
    }
}

public struct FfiConverterTypeFxaConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaConfig {
        return try FxaConfig(
            server: FfiConverterTypeFxaServer.read(from: &buf),
            clientId: FfiConverterString.read(from: &buf),
            redirectUri: FfiConverterString.read(from: &buf),
            tokenServerUrlOverride: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: FxaConfig, into buf: inout [UInt8]) {
        FfiConverterTypeFxaServer.write(value.server, into: &buf)
        FfiConverterString.write(value.clientId, into: &buf)
        FfiConverterString.write(value.redirectUri, into: &buf)
        FfiConverterOptionString.write(value.tokenServerUrlOverride, into: &buf)
    }
}

public func FfiConverterTypeFxaConfig_lift(_ buf: RustBuffer) throws -> FxaConfig {
    return try FfiConverterTypeFxaConfig.lift(buf)
}

public func FfiConverterTypeFxaConfig_lower(_ value: FxaConfig) -> RustBuffer {
    return FfiConverterTypeFxaConfig.lower(value)
}

public struct LocalDevice {
    public var id: String
    public var displayName: String
    public var deviceType: DeviceType
    public var capabilities: [DeviceCapability]
    public var pushSubscription: DevicePushSubscription?
    public var pushEndpointExpired: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, displayName: String, deviceType: DeviceType, capabilities: [DeviceCapability], pushSubscription: DevicePushSubscription?, pushEndpointExpired: Bool) {
        self.id = id
        self.displayName = displayName
        self.deviceType = deviceType
        self.capabilities = capabilities
        self.pushSubscription = pushSubscription
        self.pushEndpointExpired = pushEndpointExpired
    }
}

extension LocalDevice: Equatable, Hashable {
    public static func == (lhs: LocalDevice, rhs: LocalDevice) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.displayName != rhs.displayName {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.capabilities != rhs.capabilities {
            return false
        }
        if lhs.pushSubscription != rhs.pushSubscription {
            return false
        }
        if lhs.pushEndpointExpired != rhs.pushEndpointExpired {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(displayName)
        hasher.combine(deviceType)
        hasher.combine(capabilities)
        hasher.combine(pushSubscription)
        hasher.combine(pushEndpointExpired)
    }
}

public struct FfiConverterTypeLocalDevice: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LocalDevice {
        return try LocalDevice(
            id: FfiConverterString.read(from: &buf),
            displayName: FfiConverterString.read(from: &buf),
            deviceType: FfiConverterTypeDeviceType.read(from: &buf),
            capabilities: FfiConverterSequenceTypeDeviceCapability.read(from: &buf),
            pushSubscription: FfiConverterOptionTypeDevicePushSubscription.read(from: &buf),
            pushEndpointExpired: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: LocalDevice, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterString.write(value.displayName, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterSequenceTypeDeviceCapability.write(value.capabilities, into: &buf)
        FfiConverterOptionTypeDevicePushSubscription.write(value.pushSubscription, into: &buf)
        FfiConverterBool.write(value.pushEndpointExpired, into: &buf)
    }
}

public func FfiConverterTypeLocalDevice_lift(_ buf: RustBuffer) throws -> LocalDevice {
    return try FfiConverterTypeLocalDevice.lift(buf)
}

public func FfiConverterTypeLocalDevice_lower(_ value: LocalDevice) -> RustBuffer {
    return FfiConverterTypeLocalDevice.lower(value)
}

public struct Profile {
    public var uid: String
    public var email: String
    public var displayName: String?
    public var avatar: String
    public var isDefaultAvatar: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(uid: String, email: String, displayName: String?, avatar: String, isDefaultAvatar: Bool) {
        self.uid = uid
        self.email = email
        self.displayName = displayName
        self.avatar = avatar
        self.isDefaultAvatar = isDefaultAvatar
    }
}

extension Profile: Equatable, Hashable {
    public static func == (lhs: Profile, rhs: Profile) -> Bool {
        if lhs.uid != rhs.uid {
            return false
        }
        if lhs.email != rhs.email {
            return false
        }
        if lhs.displayName != rhs.displayName {
            return false
        }
        if lhs.avatar != rhs.avatar {
            return false
        }
        if lhs.isDefaultAvatar != rhs.isDefaultAvatar {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(uid)
        hasher.combine(email)
        hasher.combine(displayName)
        hasher.combine(avatar)
        hasher.combine(isDefaultAvatar)
    }
}

public struct FfiConverterTypeProfile: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Profile {
        return try Profile(
            uid: FfiConverterString.read(from: &buf),
            email: FfiConverterString.read(from: &buf),
            displayName: FfiConverterOptionString.read(from: &buf),
            avatar: FfiConverterString.read(from: &buf),
            isDefaultAvatar: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: Profile, into buf: inout [UInt8]) {
        FfiConverterString.write(value.uid, into: &buf)
        FfiConverterString.write(value.email, into: &buf)
        FfiConverterOptionString.write(value.displayName, into: &buf)
        FfiConverterString.write(value.avatar, into: &buf)
        FfiConverterBool.write(value.isDefaultAvatar, into: &buf)
    }
}

public func FfiConverterTypeProfile_lift(_ buf: RustBuffer) throws -> Profile {
    return try FfiConverterTypeProfile.lift(buf)
}

public func FfiConverterTypeProfile_lower(_ value: Profile) -> RustBuffer {
    return FfiConverterTypeProfile.lower(value)
}

public struct ScopedKey {
    public var kty: String
    public var scope: String
    public var k: String
    public var kid: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(kty: String, scope: String, k: String, kid: String) {
        self.kty = kty
        self.scope = scope
        self.k = k
        self.kid = kid
    }
}

extension ScopedKey: Equatable, Hashable {
    public static func == (lhs: ScopedKey, rhs: ScopedKey) -> Bool {
        if lhs.kty != rhs.kty {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        if lhs.k != rhs.k {
            return false
        }
        if lhs.kid != rhs.kid {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(kty)
        hasher.combine(scope)
        hasher.combine(k)
        hasher.combine(kid)
    }
}

public struct FfiConverterTypeScopedKey: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ScopedKey {
        return try ScopedKey(
            kty: FfiConverterString.read(from: &buf),
            scope: FfiConverterString.read(from: &buf),
            k: FfiConverterString.read(from: &buf),
            kid: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: ScopedKey, into buf: inout [UInt8]) {
        FfiConverterString.write(value.kty, into: &buf)
        FfiConverterString.write(value.scope, into: &buf)
        FfiConverterString.write(value.k, into: &buf)
        FfiConverterString.write(value.kid, into: &buf)
    }
}

public func FfiConverterTypeScopedKey_lift(_ buf: RustBuffer) throws -> ScopedKey {
    return try FfiConverterTypeScopedKey.lift(buf)
}

public func FfiConverterTypeScopedKey_lower(_ value: ScopedKey) -> RustBuffer {
    return FfiConverterTypeScopedKey.lower(value)
}

public struct SendTabPayload {
    public var entries: [TabHistoryEntry]
    public var flowId: String
    public var streamId: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(entries: [TabHistoryEntry], flowId: String, streamId: String) {
        self.entries = entries
        self.flowId = flowId
        self.streamId = streamId
    }
}

extension SendTabPayload: Equatable, Hashable {
    public static func == (lhs: SendTabPayload, rhs: SendTabPayload) -> Bool {
        if lhs.entries != rhs.entries {
            return false
        }
        if lhs.flowId != rhs.flowId {
            return false
        }
        if lhs.streamId != rhs.streamId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(entries)
        hasher.combine(flowId)
        hasher.combine(streamId)
    }
}

public struct FfiConverterTypeSendTabPayload: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SendTabPayload {
        return try SendTabPayload(
            entries: FfiConverterSequenceTypeTabHistoryEntry.read(from: &buf),
            flowId: FfiConverterString.read(from: &buf),
            streamId: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: SendTabPayload, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeTabHistoryEntry.write(value.entries, into: &buf)
        FfiConverterString.write(value.flowId, into: &buf)
        FfiConverterString.write(value.streamId, into: &buf)
    }
}

public func FfiConverterTypeSendTabPayload_lift(_ buf: RustBuffer) throws -> SendTabPayload {
    return try FfiConverterTypeSendTabPayload.lift(buf)
}

public func FfiConverterTypeSendTabPayload_lower(_ value: SendTabPayload) -> RustBuffer {
    return FfiConverterTypeSendTabPayload.lower(value)
}

public struct TabHistoryEntry {
    public var title: String
    public var url: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(title: String, url: String) {
        self.title = title
        self.url = url
    }
}

extension TabHistoryEntry: Equatable, Hashable {
    public static func == (lhs: TabHistoryEntry, rhs: TabHistoryEntry) -> Bool {
        if lhs.title != rhs.title {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(title)
        hasher.combine(url)
    }
}

public struct FfiConverterTypeTabHistoryEntry: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> TabHistoryEntry {
        return try TabHistoryEntry(
            title: FfiConverterString.read(from: &buf),
            url: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: TabHistoryEntry, into buf: inout [UInt8]) {
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterString.write(value.url, into: &buf)
    }
}

public func FfiConverterTypeTabHistoryEntry_lift(_ buf: RustBuffer) throws -> TabHistoryEntry {
    return try FfiConverterTypeTabHistoryEntry.lift(buf)
}

public func FfiConverterTypeTabHistoryEntry_lower(_ value: TabHistoryEntry) -> RustBuffer {
    return FfiConverterTypeTabHistoryEntry.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum AccountEvent {
    case commandReceived(command: IncomingDeviceCommand)
    case profileUpdated
    case accountAuthStateChanged
    case accountDestroyed
    case deviceConnected(deviceName: String)
    case deviceDisconnected(deviceId: String, isLocalDevice: Bool)
    case unknown
}

public struct FfiConverterTypeAccountEvent: FfiConverterRustBuffer {
    typealias SwiftType = AccountEvent

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AccountEvent {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .commandReceived(
                command: FfiConverterTypeIncomingDeviceCommand.read(from: &buf)
            )

        case 2: return .profileUpdated

        case 3: return .accountAuthStateChanged

        case 4: return .accountDestroyed

        case 5: return try .deviceConnected(
                deviceName: FfiConverterString.read(from: &buf)
            )

        case 6: return try .deviceDisconnected(
                deviceId: FfiConverterString.read(from: &buf),
                isLocalDevice: FfiConverterBool.read(from: &buf)
            )

        case 7: return .unknown

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: AccountEvent, into buf: inout [UInt8]) {
        switch value {
        case let .commandReceived(command):
            writeInt(&buf, Int32(1))
            FfiConverterTypeIncomingDeviceCommand.write(command, into: &buf)

        case .profileUpdated:
            writeInt(&buf, Int32(2))

        case .accountAuthStateChanged:
            writeInt(&buf, Int32(3))

        case .accountDestroyed:
            writeInt(&buf, Int32(4))

        case let .deviceConnected(deviceName):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(deviceName, into: &buf)

        case let .deviceDisconnected(deviceId, isLocalDevice):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(deviceId, into: &buf)
            FfiConverterBool.write(isLocalDevice, into: &buf)

        case .unknown:
            writeInt(&buf, Int32(7))
        }
    }
}

public func FfiConverterTypeAccountEvent_lift(_ buf: RustBuffer) throws -> AccountEvent {
    return try FfiConverterTypeAccountEvent.lift(buf)
}

public func FfiConverterTypeAccountEvent_lower(_ value: AccountEvent) -> RustBuffer {
    return FfiConverterTypeAccountEvent.lower(value)
}

extension AccountEvent: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum DeviceCapability {
    case sendTab
}

public struct FfiConverterTypeDeviceCapability: FfiConverterRustBuffer {
    typealias SwiftType = DeviceCapability

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DeviceCapability {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .sendTab

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: DeviceCapability, into buf: inout [UInt8]) {
        switch value {
        case .sendTab:
            writeInt(&buf, Int32(1))
        }
    }
}

public func FfiConverterTypeDeviceCapability_lift(_ buf: RustBuffer) throws -> DeviceCapability {
    return try FfiConverterTypeDeviceCapability.lift(buf)
}

public func FfiConverterTypeDeviceCapability_lower(_ value: DeviceCapability) -> RustBuffer {
    return FfiConverterTypeDeviceCapability.lower(value)
}

extension DeviceCapability: Equatable, Hashable {}

public enum FxaError {
    // Simple error enums only carry a message
    case Authentication(message: String)

    // Simple error enums only carry a message
    case Network(message: String)

    // Simple error enums only carry a message
    case NoExistingAuthFlow(message: String)

    // Simple error enums only carry a message
    case WrongAuthFlow(message: String)

    // Simple error enums only carry a message
    case OriginMismatch(message: String)

    // Simple error enums only carry a message
    case SyncScopedKeyMissingInServerResponse(message: String)

    // Simple error enums only carry a message
    case Panic(message: String)

    // Simple error enums only carry a message
    case Other(message: String)

    fileprivate static func uniffiErrorHandler(_ error: RustBuffer) throws -> Error {
        return try FfiConverterTypeFxaError.lift(error)
    }
}

public struct FfiConverterTypeFxaError: FfiConverterRustBuffer {
    typealias SwiftType = FxaError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .Authentication(
                message: FfiConverterString.read(from: &buf)
            )

        case 2: return try .Network(
                message: FfiConverterString.read(from: &buf)
            )

        case 3: return try .NoExistingAuthFlow(
                message: FfiConverterString.read(from: &buf)
            )

        case 4: return try .WrongAuthFlow(
                message: FfiConverterString.read(from: &buf)
            )

        case 5: return try .OriginMismatch(
                message: FfiConverterString.read(from: &buf)
            )

        case 6: return try .SyncScopedKeyMissingInServerResponse(
                message: FfiConverterString.read(from: &buf)
            )

        case 7: return try .Panic(
                message: FfiConverterString.read(from: &buf)
            )

        case 8: return try .Other(
                message: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaError, into buf: inout [UInt8]) {
        switch value {
        case .Authentication(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(1))
        case .Network(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(2))
        case .NoExistingAuthFlow(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(3))
        case .WrongAuthFlow(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(4))
        case .OriginMismatch(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(5))
        case .SyncScopedKeyMissingInServerResponse(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(6))
        case .Panic(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(7))
        case .Other(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(8))
        }
    }
}

extension FxaError: Equatable, Hashable {}

extension FxaError: Error {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum FxaEvent {
    case initialize(deviceConfig: DeviceConfig)
    case beginOAuthFlow(scopes: [String], entrypoint: String)
    case beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String)
    case completeOAuthFlow(code: String, state: String)
    case cancelOAuthFlow
    case checkAuthorizationStatus
    case disconnect
    case callGetProfile
}

public struct FfiConverterTypeFxaEvent: FfiConverterRustBuffer {
    typealias SwiftType = FxaEvent

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaEvent {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .initialize(
                deviceConfig: FfiConverterTypeDeviceConfig.read(from: &buf)
            )

        case 2: return try .beginOAuthFlow(
                scopes: FfiConverterSequenceString.read(from: &buf),
                entrypoint: FfiConverterString.read(from: &buf)
            )

        case 3: return try .beginPairingFlow(
                pairingUrl: FfiConverterString.read(from: &buf),
                scopes: FfiConverterSequenceString.read(from: &buf),
                entrypoint: FfiConverterString.read(from: &buf)
            )

        case 4: return try .completeOAuthFlow(
                code: FfiConverterString.read(from: &buf),
                state: FfiConverterString.read(from: &buf)
            )

        case 5: return .cancelOAuthFlow

        case 6: return .checkAuthorizationStatus

        case 7: return .disconnect

        case 8: return .callGetProfile

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaEvent, into buf: inout [UInt8]) {
        switch value {
        case let .initialize(deviceConfig):
            writeInt(&buf, Int32(1))
            FfiConverterTypeDeviceConfig.write(deviceConfig, into: &buf)

        case let .beginOAuthFlow(scopes, entrypoint):
            writeInt(&buf, Int32(2))
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)

        case let .beginPairingFlow(pairingUrl, scopes, entrypoint):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(pairingUrl, into: &buf)
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)

        case let .completeOAuthFlow(code, state):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(code, into: &buf)
            FfiConverterString.write(state, into: &buf)

        case .cancelOAuthFlow:
            writeInt(&buf, Int32(5))

        case .checkAuthorizationStatus:
            writeInt(&buf, Int32(6))

        case .disconnect:
            writeInt(&buf, Int32(7))

        case .callGetProfile:
            writeInt(&buf, Int32(8))
        }
    }
}

public func FfiConverterTypeFxaEvent_lift(_ buf: RustBuffer) throws -> FxaEvent {
    return try FfiConverterTypeFxaEvent.lift(buf)
}

public func FfiConverterTypeFxaEvent_lower(_ value: FxaEvent) -> RustBuffer {
    return FfiConverterTypeFxaEvent.lower(value)
}

extension FxaEvent: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum FxaRustAuthState {
    case disconnected
    case connected
    case authIssues
}

public struct FfiConverterTypeFxaRustAuthState: FfiConverterRustBuffer {
    typealias SwiftType = FxaRustAuthState

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaRustAuthState {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .disconnected

        case 2: return .connected

        case 3: return .authIssues

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaRustAuthState, into buf: inout [UInt8]) {
        switch value {
        case .disconnected:
            writeInt(&buf, Int32(1))

        case .connected:
            writeInt(&buf, Int32(2))

        case .authIssues:
            writeInt(&buf, Int32(3))
        }
    }
}

public func FfiConverterTypeFxaRustAuthState_lift(_ buf: RustBuffer) throws -> FxaRustAuthState {
    return try FfiConverterTypeFxaRustAuthState.lift(buf)
}

public func FfiConverterTypeFxaRustAuthState_lower(_ value: FxaRustAuthState) -> RustBuffer {
    return FfiConverterTypeFxaRustAuthState.lower(value)
}

extension FxaRustAuthState: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum FxaServer {
    case release
    case stable
    case stage
    case china
    case localDev
    case custom(url: String)
}

public struct FfiConverterTypeFxaServer: FfiConverterRustBuffer {
    typealias SwiftType = FxaServer

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaServer {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .release

        case 2: return .stable

        case 3: return .stage

        case 4: return .china

        case 5: return .localDev

        case 6: return try .custom(
                url: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaServer, into buf: inout [UInt8]) {
        switch value {
        case .release:
            writeInt(&buf, Int32(1))

        case .stable:
            writeInt(&buf, Int32(2))

        case .stage:
            writeInt(&buf, Int32(3))

        case .china:
            writeInt(&buf, Int32(4))

        case .localDev:
            writeInt(&buf, Int32(5))

        case let .custom(url):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(url, into: &buf)
        }
    }
}

public func FfiConverterTypeFxaServer_lift(_ buf: RustBuffer) throws -> FxaServer {
    return try FfiConverterTypeFxaServer.lift(buf)
}

public func FfiConverterTypeFxaServer_lower(_ value: FxaServer) -> RustBuffer {
    return FfiConverterTypeFxaServer.lower(value)
}

extension FxaServer: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum FxaState {
    case uninitialized
    case disconnected
    case authenticating(oauthUrl: String)
    case connected
    case authIssues
}

public struct FfiConverterTypeFxaState: FfiConverterRustBuffer {
    typealias SwiftType = FxaState

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaState {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .uninitialized

        case 2: return .disconnected

        case 3: return try .authenticating(
                oauthUrl: FfiConverterString.read(from: &buf)
            )

        case 4: return .connected

        case 5: return .authIssues

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaState, into buf: inout [UInt8]) {
        switch value {
        case .uninitialized:
            writeInt(&buf, Int32(1))

        case .disconnected:
            writeInt(&buf, Int32(2))

        case let .authenticating(oauthUrl):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(oauthUrl, into: &buf)

        case .connected:
            writeInt(&buf, Int32(4))

        case .authIssues:
            writeInt(&buf, Int32(5))
        }
    }
}

public func FfiConverterTypeFxaState_lift(_ buf: RustBuffer) throws -> FxaState {
    return try FfiConverterTypeFxaState.lift(buf)
}

public func FfiConverterTypeFxaState_lower(_ value: FxaState) -> RustBuffer {
    return FfiConverterTypeFxaState.lower(value)
}

extension FxaState: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum FxaStateCheckerEvent {
    case getAuthStateSuccess(authState: FxaRustAuthState)
    case beginOAuthFlowSuccess(oauthUrl: String)
    case beginPairingFlowSuccess(oauthUrl: String)
    case completeOAuthFlowSuccess
    case initializeDeviceSuccess
    case ensureDeviceCapabilitiesSuccess
    case checkAuthorizationStatusSuccess(active: Bool)
    case disconnectSuccess
    case getProfileSuccess
    case callError
    case ensureCapabilitiesAuthError
}

public struct FfiConverterTypeFxaStateCheckerEvent: FfiConverterRustBuffer {
    typealias SwiftType = FxaStateCheckerEvent

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaStateCheckerEvent {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .getAuthStateSuccess(
                authState: FfiConverterTypeFxaRustAuthState.read(from: &buf)
            )

        case 2: return try .beginOAuthFlowSuccess(
                oauthUrl: FfiConverterString.read(from: &buf)
            )

        case 3: return try .beginPairingFlowSuccess(
                oauthUrl: FfiConverterString.read(from: &buf)
            )

        case 4: return .completeOAuthFlowSuccess

        case 5: return .initializeDeviceSuccess

        case 6: return .ensureDeviceCapabilitiesSuccess

        case 7: return try .checkAuthorizationStatusSuccess(
                active: FfiConverterBool.read(from: &buf)
            )

        case 8: return .disconnectSuccess

        case 9: return .getProfileSuccess

        case 10: return .callError

        case 11: return .ensureCapabilitiesAuthError

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaStateCheckerEvent, into buf: inout [UInt8]) {
        switch value {
        case let .getAuthStateSuccess(authState):
            writeInt(&buf, Int32(1))
            FfiConverterTypeFxaRustAuthState.write(authState, into: &buf)

        case let .beginOAuthFlowSuccess(oauthUrl):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(oauthUrl, into: &buf)

        case let .beginPairingFlowSuccess(oauthUrl):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(oauthUrl, into: &buf)

        case .completeOAuthFlowSuccess:
            writeInt(&buf, Int32(4))

        case .initializeDeviceSuccess:
            writeInt(&buf, Int32(5))

        case .ensureDeviceCapabilitiesSuccess:
            writeInt(&buf, Int32(6))

        case let .checkAuthorizationStatusSuccess(active):
            writeInt(&buf, Int32(7))
            FfiConverterBool.write(active, into: &buf)

        case .disconnectSuccess:
            writeInt(&buf, Int32(8))

        case .getProfileSuccess:
            writeInt(&buf, Int32(9))

        case .callError:
            writeInt(&buf, Int32(10))

        case .ensureCapabilitiesAuthError:
            writeInt(&buf, Int32(11))
        }
    }
}

public func FfiConverterTypeFxaStateCheckerEvent_lift(_ buf: RustBuffer) throws -> FxaStateCheckerEvent {
    return try FfiConverterTypeFxaStateCheckerEvent.lift(buf)
}

public func FfiConverterTypeFxaStateCheckerEvent_lower(_ value: FxaStateCheckerEvent) -> RustBuffer {
    return FfiConverterTypeFxaStateCheckerEvent.lower(value)
}

extension FxaStateCheckerEvent: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum FxaStateCheckerState {
    case getAuthState
    case beginOAuthFlow(scopes: [String], entrypoint: String)
    case beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String)
    case completeOAuthFlow(code: String, state: String)
    case initializeDevice
    case ensureDeviceCapabilities
    case checkAuthorizationStatus
    case disconnect
    case getProfile
    case complete(newState: FxaState)
    case cancel
}

public struct FfiConverterTypeFxaStateCheckerState: FfiConverterRustBuffer {
    typealias SwiftType = FxaStateCheckerState

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaStateCheckerState {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .getAuthState

        case 2: return try .beginOAuthFlow(
                scopes: FfiConverterSequenceString.read(from: &buf),
                entrypoint: FfiConverterString.read(from: &buf)
            )

        case 3: return try .beginPairingFlow(
                pairingUrl: FfiConverterString.read(from: &buf),
                scopes: FfiConverterSequenceString.read(from: &buf),
                entrypoint: FfiConverterString.read(from: &buf)
            )

        case 4: return try .completeOAuthFlow(
                code: FfiConverterString.read(from: &buf),
                state: FfiConverterString.read(from: &buf)
            )

        case 5: return .initializeDevice

        case 6: return .ensureDeviceCapabilities

        case 7: return .checkAuthorizationStatus

        case 8: return .disconnect

        case 9: return .getProfile

        case 10: return try .complete(
                newState: FfiConverterTypeFxaState.read(from: &buf)
            )

        case 11: return .cancel

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaStateCheckerState, into buf: inout [UInt8]) {
        switch value {
        case .getAuthState:
            writeInt(&buf, Int32(1))

        case let .beginOAuthFlow(scopes, entrypoint):
            writeInt(&buf, Int32(2))
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)

        case let .beginPairingFlow(pairingUrl, scopes, entrypoint):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(pairingUrl, into: &buf)
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)

        case let .completeOAuthFlow(code, state):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(code, into: &buf)
            FfiConverterString.write(state, into: &buf)

        case .initializeDevice:
            writeInt(&buf, Int32(5))

        case .ensureDeviceCapabilities:
            writeInt(&buf, Int32(6))

        case .checkAuthorizationStatus:
            writeInt(&buf, Int32(7))

        case .disconnect:
            writeInt(&buf, Int32(8))

        case .getProfile:
            writeInt(&buf, Int32(9))

        case let .complete(newState):
            writeInt(&buf, Int32(10))
            FfiConverterTypeFxaState.write(newState, into: &buf)

        case .cancel:
            writeInt(&buf, Int32(11))
        }
    }
}

public func FfiConverterTypeFxaStateCheckerState_lift(_ buf: RustBuffer) throws -> FxaStateCheckerState {
    return try FfiConverterTypeFxaStateCheckerState.lift(buf)
}

public func FfiConverterTypeFxaStateCheckerState_lower(_ value: FxaStateCheckerState) -> RustBuffer {
    return FfiConverterTypeFxaStateCheckerState.lower(value)
}

extension FxaStateCheckerState: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum IncomingDeviceCommand {
    case tabReceived(sender: Device?, payload: SendTabPayload)
}

public struct FfiConverterTypeIncomingDeviceCommand: FfiConverterRustBuffer {
    typealias SwiftType = IncomingDeviceCommand

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> IncomingDeviceCommand {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .tabReceived(
                sender: FfiConverterOptionTypeDevice.read(from: &buf),
                payload: FfiConverterTypeSendTabPayload.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: IncomingDeviceCommand, into buf: inout [UInt8]) {
        switch value {
        case let .tabReceived(sender, payload):
            writeInt(&buf, Int32(1))
            FfiConverterOptionTypeDevice.write(sender, into: &buf)
            FfiConverterTypeSendTabPayload.write(payload, into: &buf)
        }
    }
}

public func FfiConverterTypeIncomingDeviceCommand_lift(_ buf: RustBuffer) throws -> IncomingDeviceCommand {
    return try FfiConverterTypeIncomingDeviceCommand.lift(buf)
}

public func FfiConverterTypeIncomingDeviceCommand_lower(_ value: IncomingDeviceCommand) -> RustBuffer {
    return FfiConverterTypeIncomingDeviceCommand.lower(value)
}

extension IncomingDeviceCommand: Equatable, Hashable {}

private struct FfiConverterOptionInt64: FfiConverterRustBuffer {
    typealias SwiftType = Int64?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt64.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt64.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeDevice: FfiConverterRustBuffer {
    typealias SwiftType = Device?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeDevice.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeDevice.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeDevicePushSubscription: FfiConverterRustBuffer {
    typealias SwiftType = DevicePushSubscription?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeDevicePushSubscription.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeDevicePushSubscription.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeScopedKey: FfiConverterRustBuffer {
    typealias SwiftType = ScopedKey?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeScopedKey.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeScopedKey.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeAttachedClient: FfiConverterRustBuffer {
    typealias SwiftType = [AttachedClient]

    public static func write(_ value: [AttachedClient], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeAttachedClient.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [AttachedClient] {
        let len: Int32 = try readInt(&buf)
        var seq = [AttachedClient]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeAttachedClient.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeDevice: FfiConverterRustBuffer {
    typealias SwiftType = [Device]

    public static func write(_ value: [Device], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeDevice.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Device] {
        let len: Int32 = try readInt(&buf)
        var seq = [Device]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeDevice.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeTabHistoryEntry: FfiConverterRustBuffer {
    typealias SwiftType = [TabHistoryEntry]

    public static func write(_ value: [TabHistoryEntry], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeTabHistoryEntry.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [TabHistoryEntry] {
        let len: Int32 = try readInt(&buf)
        var seq = [TabHistoryEntry]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeTabHistoryEntry.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeDeviceCapability: FfiConverterRustBuffer {
    typealias SwiftType = [DeviceCapability]

    public static func write(_ value: [DeviceCapability], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeDeviceCapability.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [DeviceCapability] {
        let len: Int32 = try readInt(&buf)
        var seq = [DeviceCapability]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeDeviceCapability.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeIncomingDeviceCommand: FfiConverterRustBuffer {
    typealias SwiftType = [IncomingDeviceCommand]

    public static func write(_ value: [IncomingDeviceCommand], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeIncomingDeviceCommand.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [IncomingDeviceCommand] {
        let len: Int32 = try readInt(&buf)
        var seq = [IncomingDeviceCommand]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeIncomingDeviceCommand.read(from: &buf))
        }
        return seq
    }
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 24
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_fxa_client_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_authorize_code_using_session_token() != 50739 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_begin_oauth_flow() != 27599 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_begin_pairing_flow() != 37272 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_check_authorization_status() != 16819 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_clear_access_token_cache() != 36203 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_clear_device_name() != 33526 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_complete_oauth_flow() != 14791 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_disconnect() != 807 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_ensure_capabilities() != 48600 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_gather_telemetry() != 54566 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_access_token() != 31059 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_attached_clients() != 6902 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_auth_state() != 3633 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_connection_success_url() != 19760 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_current_device_id() != 41398 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_devices() != 13946 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_manage_account_url() != 32409 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_manage_devices_url() != 43410 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_pairing_authority_url() != 63021 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_profile() != 31295 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_session_token() != 7049 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_state() != 54458 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_get_token_server_endpoint_url() != 6685 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_handle_push_message() != 44724 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_handle_session_token_change() != 5868 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_initialize_device() != 17512 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_on_auth_issues() != 21675 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_poll_device_commands() != 11580 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_process_event() != 40475 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_send_single_tab() != 57016 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_set_device_name() != 60311 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_set_push_subscription() != 47048 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_simulate_network_error() != 61828 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_simulate_permanent_auth_token_issue() != 25986 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_simulate_temporary_auth_token_issue() != 32382 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_firefoxaccount_to_json() != 26070 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_fxastatemachinechecker_check_internal_state() != 3796 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_fxastatemachinechecker_check_public_state() != 27970 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_fxastatemachinechecker_handle_internal_event() != 19183 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_method_fxastatemachinechecker_handle_public_event() != 27457 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_constructor_firefoxaccount_from_json() != 32440 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_constructor_firefoxaccount_new() != 27451 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_fxa_client_checksum_constructor_fxastatemachinechecker_new() != 51074 {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}
