// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_logins_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_logins_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_PANIC: Int8 = 2
private let CALL_CANCELLED: Int8 = 3

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_PANIC:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    case CALL_CANCELLED:
        throw CancellationError()

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

// Public interface members begin here.

private struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol LoginStoreProtocol {
    func add(login: LoginEntry, encryptionKey: String) throws -> EncryptedLogin
    func addOrUpdate(login: LoginEntry, encryptionKey: String) throws -> EncryptedLogin
    func delete(id: String) throws -> Bool
    func findLoginToUpdate(look: LoginEntry, encryptionKey: String) throws -> Login?
    func get(id: String) throws -> EncryptedLogin?
    func getByBaseDomain(baseDomain: String) throws -> [EncryptedLogin]
    func list() throws -> [EncryptedLogin]
    func registerWithSyncManager()
    func reset() throws
    func touch(id: String) throws
    func update(id: String, login: LoginEntry, encryptionKey: String) throws -> EncryptedLogin
    func wipeLocal() throws
}

public class LoginStore: LoginStoreProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    public convenience init(path: String) throws {
        try self.init(unsafeFromRawPointer: rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_constructor_loginstore_new(
                FfiConverterString.lower(path), $0
            )
        })
    }

    deinit {
        try! rustCall { uniffi_logins_fn_free_loginstore(pointer, $0) }
    }

    public func add(login: LoginEntry, encryptionKey: String) throws -> EncryptedLogin {
        return try FfiConverterTypeEncryptedLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_add(self.pointer,
                                                       FfiConverterTypeLoginEntry.lower(login),
                                                       FfiConverterString.lower(encryptionKey), $0)
            }
        )
    }

    public func addOrUpdate(login: LoginEntry, encryptionKey: String) throws -> EncryptedLogin {
        return try FfiConverterTypeEncryptedLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_add_or_update(self.pointer,
                                                                 FfiConverterTypeLoginEntry.lower(login),
                                                                 FfiConverterString.lower(encryptionKey), $0)
            }
        )
    }

    public func delete(id: String) throws -> Bool {
        return try FfiConverterBool.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_delete(self.pointer,
                                                          FfiConverterString.lower(id), $0)
            }
        )
    }

    public func findLoginToUpdate(look: LoginEntry, encryptionKey: String) throws -> Login? {
        return try FfiConverterOptionTypeLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_find_login_to_update(self.pointer,
                                                                        FfiConverterTypeLoginEntry.lower(look),
                                                                        FfiConverterString.lower(encryptionKey), $0)
            }
        )
    }

    public func get(id: String) throws -> EncryptedLogin? {
        return try FfiConverterOptionTypeEncryptedLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_get(self.pointer,
                                                       FfiConverterString.lower(id), $0)
            }
        )
    }

    public func getByBaseDomain(baseDomain: String) throws -> [EncryptedLogin] {
        return try FfiConverterSequenceTypeEncryptedLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_get_by_base_domain(self.pointer,
                                                                      FfiConverterString.lower(baseDomain), $0)
            }
        )
    }

    public func list() throws -> [EncryptedLogin] {
        return try FfiConverterSequenceTypeEncryptedLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_list(self.pointer, $0)
            }
        )
    }

    public func registerWithSyncManager() {
        try!
            rustCall {
                uniffi_logins_fn_method_loginstore_register_with_sync_manager(self.pointer, $0)
            }
    }

    public func reset() throws {
        try
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_reset(self.pointer, $0)
            }
    }

    public func touch(id: String) throws {
        try
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_touch(self.pointer,
                                                         FfiConverterString.lower(id), $0)
            }
    }

    public func update(id: String, login: LoginEntry, encryptionKey: String) throws -> EncryptedLogin {
        return try FfiConverterTypeEncryptedLogin.lift(
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_update(self.pointer,
                                                          FfiConverterString.lower(id),
                                                          FfiConverterTypeLoginEntry.lower(login),
                                                          FfiConverterString.lower(encryptionKey), $0)
            }
        )
    }

    public func wipeLocal() throws {
        try
            rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
                uniffi_logins_fn_method_loginstore_wipe_local(self.pointer, $0)
            }
    }
}

public struct FfiConverterTypeLoginStore: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = LoginStore

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginStore {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: LoginStore, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> LoginStore {
        return LoginStore(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: LoginStore) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypeLoginStore_lift(_ pointer: UnsafeMutableRawPointer) throws -> LoginStore {
    return try FfiConverterTypeLoginStore.lift(pointer)
}

public func FfiConverterTypeLoginStore_lower(_ value: LoginStore) -> UnsafeMutableRawPointer {
    return FfiConverterTypeLoginStore.lower(value)
}

public struct EncryptedLogin {
    public var record: RecordFields
    public var fields: LoginFields
    public var secFields: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(record: RecordFields, fields: LoginFields, secFields: String) {
        self.record = record
        self.fields = fields
        self.secFields = secFields
    }
}

extension EncryptedLogin: Equatable, Hashable {
    public static func == (lhs: EncryptedLogin, rhs: EncryptedLogin) -> Bool {
        if lhs.record != rhs.record {
            return false
        }
        if lhs.fields != rhs.fields {
            return false
        }
        if lhs.secFields != rhs.secFields {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(record)
        hasher.combine(fields)
        hasher.combine(secFields)
    }
}

public struct FfiConverterTypeEncryptedLogin: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EncryptedLogin {
        return try EncryptedLogin(
            record: FfiConverterTypeRecordFields.read(from: &buf),
            fields: FfiConverterTypeLoginFields.read(from: &buf),
            secFields: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: EncryptedLogin, into buf: inout [UInt8]) {
        FfiConverterTypeRecordFields.write(value.record, into: &buf)
        FfiConverterTypeLoginFields.write(value.fields, into: &buf)
        FfiConverterString.write(value.secFields, into: &buf)
    }
}

public func FfiConverterTypeEncryptedLogin_lift(_ buf: RustBuffer) throws -> EncryptedLogin {
    return try FfiConverterTypeEncryptedLogin.lift(buf)
}

public func FfiConverterTypeEncryptedLogin_lower(_ value: EncryptedLogin) -> RustBuffer {
    return FfiConverterTypeEncryptedLogin.lower(value)
}

public struct Login {
    public var record: RecordFields
    public var fields: LoginFields
    public var secFields: SecureLoginFields

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(record: RecordFields, fields: LoginFields, secFields: SecureLoginFields) {
        self.record = record
        self.fields = fields
        self.secFields = secFields
    }
}

extension Login: Equatable, Hashable {
    public static func == (lhs: Login, rhs: Login) -> Bool {
        if lhs.record != rhs.record {
            return false
        }
        if lhs.fields != rhs.fields {
            return false
        }
        if lhs.secFields != rhs.secFields {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(record)
        hasher.combine(fields)
        hasher.combine(secFields)
    }
}

public struct FfiConverterTypeLogin: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Login {
        return try Login(
            record: FfiConverterTypeRecordFields.read(from: &buf),
            fields: FfiConverterTypeLoginFields.read(from: &buf),
            secFields: FfiConverterTypeSecureLoginFields.read(from: &buf)
        )
    }

    public static func write(_ value: Login, into buf: inout [UInt8]) {
        FfiConverterTypeRecordFields.write(value.record, into: &buf)
        FfiConverterTypeLoginFields.write(value.fields, into: &buf)
        FfiConverterTypeSecureLoginFields.write(value.secFields, into: &buf)
    }
}

public func FfiConverterTypeLogin_lift(_ buf: RustBuffer) throws -> Login {
    return try FfiConverterTypeLogin.lift(buf)
}

public func FfiConverterTypeLogin_lower(_ value: Login) -> RustBuffer {
    return FfiConverterTypeLogin.lower(value)
}

public struct LoginEntry {
    public var fields: LoginFields
    public var secFields: SecureLoginFields

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(fields: LoginFields, secFields: SecureLoginFields) {
        self.fields = fields
        self.secFields = secFields
    }
}

extension LoginEntry: Equatable, Hashable {
    public static func == (lhs: LoginEntry, rhs: LoginEntry) -> Bool {
        if lhs.fields != rhs.fields {
            return false
        }
        if lhs.secFields != rhs.secFields {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(fields)
        hasher.combine(secFields)
    }
}

public struct FfiConverterTypeLoginEntry: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginEntry {
        return try LoginEntry(
            fields: FfiConverterTypeLoginFields.read(from: &buf),
            secFields: FfiConverterTypeSecureLoginFields.read(from: &buf)
        )
    }

    public static func write(_ value: LoginEntry, into buf: inout [UInt8]) {
        FfiConverterTypeLoginFields.write(value.fields, into: &buf)
        FfiConverterTypeSecureLoginFields.write(value.secFields, into: &buf)
    }
}

public func FfiConverterTypeLoginEntry_lift(_ buf: RustBuffer) throws -> LoginEntry {
    return try FfiConverterTypeLoginEntry.lift(buf)
}

public func FfiConverterTypeLoginEntry_lower(_ value: LoginEntry) -> RustBuffer {
    return FfiConverterTypeLoginEntry.lower(value)
}

public struct LoginFields {
    public var origin: String
    public var httpRealm: String?
    public var formActionOrigin: String?
    public var usernameField: String
    public var passwordField: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(origin: String, httpRealm: String?, formActionOrigin: String?, usernameField: String, passwordField: String) {
        self.origin = origin
        self.httpRealm = httpRealm
        self.formActionOrigin = formActionOrigin
        self.usernameField = usernameField
        self.passwordField = passwordField
    }
}

extension LoginFields: Equatable, Hashable {
    public static func == (lhs: LoginFields, rhs: LoginFields) -> Bool {
        if lhs.origin != rhs.origin {
            return false
        }
        if lhs.httpRealm != rhs.httpRealm {
            return false
        }
        if lhs.formActionOrigin != rhs.formActionOrigin {
            return false
        }
        if lhs.usernameField != rhs.usernameField {
            return false
        }
        if lhs.passwordField != rhs.passwordField {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(origin)
        hasher.combine(httpRealm)
        hasher.combine(formActionOrigin)
        hasher.combine(usernameField)
        hasher.combine(passwordField)
    }
}

public struct FfiConverterTypeLoginFields: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginFields {
        return try LoginFields(
            origin: FfiConverterString.read(from: &buf),
            httpRealm: FfiConverterOptionString.read(from: &buf),
            formActionOrigin: FfiConverterOptionString.read(from: &buf),
            usernameField: FfiConverterString.read(from: &buf),
            passwordField: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: LoginFields, into buf: inout [UInt8]) {
        FfiConverterString.write(value.origin, into: &buf)
        FfiConverterOptionString.write(value.httpRealm, into: &buf)
        FfiConverterOptionString.write(value.formActionOrigin, into: &buf)
        FfiConverterString.write(value.usernameField, into: &buf)
        FfiConverterString.write(value.passwordField, into: &buf)
    }
}

public func FfiConverterTypeLoginFields_lift(_ buf: RustBuffer) throws -> LoginFields {
    return try FfiConverterTypeLoginFields.lift(buf)
}

public func FfiConverterTypeLoginFields_lower(_ value: LoginFields) -> RustBuffer {
    return FfiConverterTypeLoginFields.lower(value)
}

public struct RecordFields {
    public var id: String
    public var timesUsed: Int64
    public var timeCreated: Int64
    public var timeLastUsed: Int64
    public var timePasswordChanged: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, timesUsed: Int64, timeCreated: Int64, timeLastUsed: Int64, timePasswordChanged: Int64) {
        self.id = id
        self.timesUsed = timesUsed
        self.timeCreated = timeCreated
        self.timeLastUsed = timeLastUsed
        self.timePasswordChanged = timePasswordChanged
    }
}

extension RecordFields: Equatable, Hashable {
    public static func == (lhs: RecordFields, rhs: RecordFields) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.timesUsed != rhs.timesUsed {
            return false
        }
        if lhs.timeCreated != rhs.timeCreated {
            return false
        }
        if lhs.timeLastUsed != rhs.timeLastUsed {
            return false
        }
        if lhs.timePasswordChanged != rhs.timePasswordChanged {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(timesUsed)
        hasher.combine(timeCreated)
        hasher.combine(timeLastUsed)
        hasher.combine(timePasswordChanged)
    }
}

public struct FfiConverterTypeRecordFields: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> RecordFields {
        return try RecordFields(
            id: FfiConverterString.read(from: &buf),
            timesUsed: FfiConverterInt64.read(from: &buf),
            timeCreated: FfiConverterInt64.read(from: &buf),
            timeLastUsed: FfiConverterInt64.read(from: &buf),
            timePasswordChanged: FfiConverterInt64.read(from: &buf)
        )
    }

    public static func write(_ value: RecordFields, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterInt64.write(value.timesUsed, into: &buf)
        FfiConverterInt64.write(value.timeCreated, into: &buf)
        FfiConverterInt64.write(value.timeLastUsed, into: &buf)
        FfiConverterInt64.write(value.timePasswordChanged, into: &buf)
    }
}

public func FfiConverterTypeRecordFields_lift(_ buf: RustBuffer) throws -> RecordFields {
    return try FfiConverterTypeRecordFields.lift(buf)
}

public func FfiConverterTypeRecordFields_lower(_ value: RecordFields) -> RustBuffer {
    return FfiConverterTypeRecordFields.lower(value)
}

public struct SecureLoginFields {
    public var password: String
    public var username: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(password: String, username: String) {
        self.password = password
        self.username = username
    }
}

extension SecureLoginFields: Equatable, Hashable {
    public static func == (lhs: SecureLoginFields, rhs: SecureLoginFields) -> Bool {
        if lhs.password != rhs.password {
            return false
        }
        if lhs.username != rhs.username {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(password)
        hasher.combine(username)
    }
}

public struct FfiConverterTypeSecureLoginFields: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SecureLoginFields {
        return try SecureLoginFields(
            password: FfiConverterString.read(from: &buf),
            username: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: SecureLoginFields, into buf: inout [UInt8]) {
        FfiConverterString.write(value.password, into: &buf)
        FfiConverterString.write(value.username, into: &buf)
    }
}

public func FfiConverterTypeSecureLoginFields_lift(_ buf: RustBuffer) throws -> SecureLoginFields {
    return try FfiConverterTypeSecureLoginFields.lift(buf)
}

public func FfiConverterTypeSecureLoginFields_lower(_ value: SecureLoginFields) -> RustBuffer {
    return FfiConverterTypeSecureLoginFields.lower(value)
}

public enum LoginsApiError {
    case InvalidRecord(reason: String)
    case NoSuchRecord(reason: String)
    case IncorrectKey
    case Interrupted(reason: String)
    case SyncAuthInvalid(reason: String)
    case UnexpectedLoginsApiError(reason: String)

    fileprivate static func uniffiErrorHandler(_ error: RustBuffer) throws -> Error {
        return try FfiConverterTypeLoginsApiError.lift(error)
    }
}

public struct FfiConverterTypeLoginsApiError: FfiConverterRustBuffer {
    typealias SwiftType = LoginsApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginsApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .InvalidRecord(
                reason: FfiConverterString.read(from: &buf)
            )
        case 2: return try .NoSuchRecord(
                reason: FfiConverterString.read(from: &buf)
            )
        case 3: return .IncorrectKey
        case 4: return try .Interrupted(
                reason: FfiConverterString.read(from: &buf)
            )
        case 5: return try .SyncAuthInvalid(
                reason: FfiConverterString.read(from: &buf)
            )
        case 6: return try .UnexpectedLoginsApiError(
                reason: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: LoginsApiError, into buf: inout [UInt8]) {
        switch value {
        case let .InvalidRecord(reason):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(reason, into: &buf)

        case let .NoSuchRecord(reason):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(reason, into: &buf)

        case .IncorrectKey:
            writeInt(&buf, Int32(3))

        case let .Interrupted(reason):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(reason, into: &buf)

        case let .SyncAuthInvalid(reason):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(reason, into: &buf)

        case let .UnexpectedLoginsApiError(reason):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(reason, into: &buf)
        }
    }
}

extension LoginsApiError: Equatable, Hashable {}

extension LoginsApiError: Error {}

private struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeEncryptedLogin: FfiConverterRustBuffer {
    typealias SwiftType = EncryptedLogin?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeEncryptedLogin.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeEncryptedLogin.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeLogin: FfiConverterRustBuffer {
    typealias SwiftType = Login?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeLogin.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeLogin.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceTypeEncryptedLogin: FfiConverterRustBuffer {
    typealias SwiftType = [EncryptedLogin]

    public static func write(_ value: [EncryptedLogin], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeEncryptedLogin.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [EncryptedLogin] {
        let len: Int32 = try readInt(&buf)
        var seq = [EncryptedLogin]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeEncryptedLogin.read(from: &buf))
        }
        return seq
    }
}

public func checkCanary(canary: String, text: String, encryptionKey: String) throws -> Bool {
    return try FfiConverterBool.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_check_canary(
                FfiConverterString.lower(canary),
                FfiConverterString.lower(text),
                FfiConverterString.lower(encryptionKey), $0
            )
        }
    )
}

public func createCanary(text: String, encryptionKey: String) throws -> String {
    return try FfiConverterString.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_create_canary(
                FfiConverterString.lower(text),
                FfiConverterString.lower(encryptionKey), $0
            )
        }
    )
}

public func createKey() throws -> String {
    return try FfiConverterString.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_create_key($0)
        }
    )
}

public func decryptFields(secFields: String, encryptionKey: String) throws -> SecureLoginFields {
    return try FfiConverterTypeSecureLoginFields.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_decrypt_fields(
                FfiConverterString.lower(secFields),
                FfiConverterString.lower(encryptionKey), $0
            )
        }
    )
}

public func decryptLogin(login: EncryptedLogin, encryptionKey: String) throws -> Login {
    return try FfiConverterTypeLogin.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_decrypt_login(
                FfiConverterTypeEncryptedLogin.lower(login),
                FfiConverterString.lower(encryptionKey), $0
            )
        }
    )
}

public func encryptFields(secFields: SecureLoginFields, encryptionKey: String) throws -> String {
    return try FfiConverterString.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_encrypt_fields(
                FfiConverterTypeSecureLoginFields.lower(secFields),
                FfiConverterString.lower(encryptionKey), $0
            )
        }
    )
}

public func encryptLogin(login: Login, encryptionKey: String) throws -> EncryptedLogin {
    return try FfiConverterTypeEncryptedLogin.lift(
        rustCallWithError(FfiConverterTypeLoginsApiError.lift) {
            uniffi_logins_fn_func_encrypt_login(
                FfiConverterTypeLogin.lower(login),
                FfiConverterString.lower(encryptionKey), $0
            )
        }
    )
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 24
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_logins_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_logins_checksum_func_check_canary() != 17215 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_func_create_canary() != 46989 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_func_create_key() != 10815 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_func_decrypt_fields() != 39468 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_func_decrypt_login() != 39595 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_func_encrypt_fields() != 2525 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_func_encrypt_login() != 29619 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_add() != 22331 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_add_or_update() != 18521 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_delete() != 14069 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_find_login_to_update() != 61404 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_get() != 4781 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_get_by_base_domain() != 39125 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_list() != 6857 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_register_with_sync_manager() != 7518 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_reset() != 17108 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_touch() != 36472 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_update() != 1940 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_method_loginstore_wipe_local() != 48413 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_logins_checksum_constructor_loginstore_new() != 46824 {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}
