// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len: 0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_autofill_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_autofill_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        lock()
        defer { self.unlock() }
        return try f()
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_UNEXPECTED_ERROR: Int8 = 2
private let CALL_CANCELLED: Int8 = 3

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_UNEXPECTED_ERROR:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    case CALL_CANCELLED:
        fatalError("Cancellation not supported yet")

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> Void
) {
    do {
        try writeReturn(makeCall())
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> Void,
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private class UniffiHandleMap<T> {
    private var map: [UInt64: T] = [:]
    private let lock = NSLock()
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

    func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        map.count
    }
}

// Public interface members begin here.

private struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol StoreProtocol: AnyObject {
    func addAddress(a: UpdatableAddressFields) throws -> Address

    func addCreditCard(cc: UpdatableCreditCardFields) throws -> CreditCard

    func deleteAddress(guid: String) throws -> Bool

    func deleteCreditCard(guid: String) throws -> Bool

    func getAddress(guid: String) throws -> Address

    func getAllAddresses() throws -> [Address]

    func getAllCreditCards() throws -> [CreditCard]

    func getCreditCard(guid: String) throws -> CreditCard

    func registerWithSyncManager()

    func scrubEncryptedData() throws

    func touchAddress(guid: String) throws

    func touchCreditCard(guid: String) throws

    func updateAddress(guid: String, a: UpdatableAddressFields) throws

    func updateCreditCard(guid: String, cc: UpdatableCreditCardFields) throws
}

open class Store:
    StoreProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_autofill_fn_clone_store(self.pointer, $0) }
    }

    public convenience init(dbpath: String) throws {
        let pointer =
            try rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
                uniffi_autofill_fn_constructor_store_new(
                    FfiConverterString.lower(dbpath), $0
                )
            }
        self.init(unsafeFromRawPointer: pointer)
    }

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_autofill_fn_free_store(pointer, $0) }
    }

    open func addAddress(a: UpdatableAddressFields) throws -> Address {
        return try FfiConverterTypeAddress.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_add_address(self.uniffiClonePointer(),
                                                        FfiConverterTypeUpdatableAddressFields.lower(a), $0)
        })
    }

    open func addCreditCard(cc: UpdatableCreditCardFields) throws -> CreditCard {
        return try FfiConverterTypeCreditCard.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_add_credit_card(self.uniffiClonePointer(),
                                                            FfiConverterTypeUpdatableCreditCardFields.lower(cc), $0)
        })
    }

    open func deleteAddress(guid: String) throws -> Bool {
        return try FfiConverterBool.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_delete_address(self.uniffiClonePointer(),
                                                           FfiConverterString.lower(guid), $0)
        })
    }

    open func deleteCreditCard(guid: String) throws -> Bool {
        return try FfiConverterBool.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_delete_credit_card(self.uniffiClonePointer(),
                                                               FfiConverterString.lower(guid), $0)
        })
    }

    open func getAddress(guid: String) throws -> Address {
        return try FfiConverterTypeAddress.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_get_address(self.uniffiClonePointer(),
                                                        FfiConverterString.lower(guid), $0)
        })
    }

    open func getAllAddresses() throws -> [Address] {
        return try FfiConverterSequenceTypeAddress.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_get_all_addresses(self.uniffiClonePointer(), $0)
        })
    }

    open func getAllCreditCards() throws -> [CreditCard] {
        return try FfiConverterSequenceTypeCreditCard.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_get_all_credit_cards(self.uniffiClonePointer(), $0)
        })
    }

    open func getCreditCard(guid: String) throws -> CreditCard {
        return try FfiConverterTypeCreditCard.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
            uniffi_autofill_fn_method_store_get_credit_card(self.uniffiClonePointer(),
                                                            FfiConverterString.lower(guid), $0)
        })
    }

    open func registerWithSyncManager() { try! rustCall {
        uniffi_autofill_fn_method_store_register_with_sync_manager(self.uniffiClonePointer(), $0)
    }
    }

    open func scrubEncryptedData() throws { try rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_method_store_scrub_encrypted_data(self.uniffiClonePointer(), $0)
    }
    }

    open func touchAddress(guid: String) throws { try rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_method_store_touch_address(self.uniffiClonePointer(),
                                                      FfiConverterString.lower(guid), $0)
    }
    }

    open func touchCreditCard(guid: String) throws { try rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_method_store_touch_credit_card(self.uniffiClonePointer(),
                                                          FfiConverterString.lower(guid), $0)
    }
    }

    open func updateAddress(guid: String, a: UpdatableAddressFields) throws { try rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_method_store_update_address(self.uniffiClonePointer(),
                                                       FfiConverterString.lower(guid),
                                                       FfiConverterTypeUpdatableAddressFields.lower(a), $0)
    }
    }

    open func updateCreditCard(guid: String, cc: UpdatableCreditCardFields) throws { try rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_method_store_update_credit_card(self.uniffiClonePointer(),
                                                           FfiConverterString.lower(guid),
                                                           FfiConverterTypeUpdatableCreditCardFields.lower(cc), $0)
    }
    }
}

public struct FfiConverterTypeStore: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = Store

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> Store {
        return Store(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: Store) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Store {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: Store, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypeStore_lift(_ pointer: UnsafeMutableRawPointer) throws -> Store {
    return try FfiConverterTypeStore.lift(pointer)
}

public func FfiConverterTypeStore_lower(_ value: Store) -> UnsafeMutableRawPointer {
    return FfiConverterTypeStore.lower(value)
}

public struct Address {
    public var guid: String
    public var name: String
    public var organization: String
    public var streetAddress: String
    public var addressLevel3: String
    public var addressLevel2: String
    public var addressLevel1: String
    public var postalCode: String
    public var country: String
    public var tel: String
    public var email: String
    public var timeCreated: Int64
    public var timeLastUsed: Int64?
    public var timeLastModified: Int64
    public var timesUsed: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: String, name: String, organization: String, streetAddress: String, addressLevel3: String, addressLevel2: String, addressLevel1: String, postalCode: String, country: String, tel: String, email: String, timeCreated: Int64, timeLastUsed: Int64?, timeLastModified: Int64, timesUsed: Int64) {
        self.guid = guid
        self.name = name
        self.organization = organization
        self.streetAddress = streetAddress
        self.addressLevel3 = addressLevel3
        self.addressLevel2 = addressLevel2
        self.addressLevel1 = addressLevel1
        self.postalCode = postalCode
        self.country = country
        self.tel = tel
        self.email = email
        self.timeCreated = timeCreated
        self.timeLastUsed = timeLastUsed
        self.timeLastModified = timeLastModified
        self.timesUsed = timesUsed
    }
}

extension Address: Equatable, Hashable {
    public static func == (lhs: Address, rhs: Address) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.name != rhs.name {
            return false
        }
        if lhs.organization != rhs.organization {
            return false
        }
        if lhs.streetAddress != rhs.streetAddress {
            return false
        }
        if lhs.addressLevel3 != rhs.addressLevel3 {
            return false
        }
        if lhs.addressLevel2 != rhs.addressLevel2 {
            return false
        }
        if lhs.addressLevel1 != rhs.addressLevel1 {
            return false
        }
        if lhs.postalCode != rhs.postalCode {
            return false
        }
        if lhs.country != rhs.country {
            return false
        }
        if lhs.tel != rhs.tel {
            return false
        }
        if lhs.email != rhs.email {
            return false
        }
        if lhs.timeCreated != rhs.timeCreated {
            return false
        }
        if lhs.timeLastUsed != rhs.timeLastUsed {
            return false
        }
        if lhs.timeLastModified != rhs.timeLastModified {
            return false
        }
        if lhs.timesUsed != rhs.timesUsed {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(name)
        hasher.combine(organization)
        hasher.combine(streetAddress)
        hasher.combine(addressLevel3)
        hasher.combine(addressLevel2)
        hasher.combine(addressLevel1)
        hasher.combine(postalCode)
        hasher.combine(country)
        hasher.combine(tel)
        hasher.combine(email)
        hasher.combine(timeCreated)
        hasher.combine(timeLastUsed)
        hasher.combine(timeLastModified)
        hasher.combine(timesUsed)
    }
}

public struct FfiConverterTypeAddress: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Address {
        return
            try Address(
                guid: FfiConverterString.read(from: &buf),
                name: FfiConverterString.read(from: &buf),
                organization: FfiConverterString.read(from: &buf),
                streetAddress: FfiConverterString.read(from: &buf),
                addressLevel3: FfiConverterString.read(from: &buf),
                addressLevel2: FfiConverterString.read(from: &buf),
                addressLevel1: FfiConverterString.read(from: &buf),
                postalCode: FfiConverterString.read(from: &buf),
                country: FfiConverterString.read(from: &buf),
                tel: FfiConverterString.read(from: &buf),
                email: FfiConverterString.read(from: &buf),
                timeCreated: FfiConverterInt64.read(from: &buf),
                timeLastUsed: FfiConverterOptionInt64.read(from: &buf),
                timeLastModified: FfiConverterInt64.read(from: &buf),
                timesUsed: FfiConverterInt64.read(from: &buf)
            )
    }

    public static func write(_ value: Address, into buf: inout [UInt8]) {
        FfiConverterString.write(value.guid, into: &buf)
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterString.write(value.organization, into: &buf)
        FfiConverterString.write(value.streetAddress, into: &buf)
        FfiConverterString.write(value.addressLevel3, into: &buf)
        FfiConverterString.write(value.addressLevel2, into: &buf)
        FfiConverterString.write(value.addressLevel1, into: &buf)
        FfiConverterString.write(value.postalCode, into: &buf)
        FfiConverterString.write(value.country, into: &buf)
        FfiConverterString.write(value.tel, into: &buf)
        FfiConverterString.write(value.email, into: &buf)
        FfiConverterInt64.write(value.timeCreated, into: &buf)
        FfiConverterOptionInt64.write(value.timeLastUsed, into: &buf)
        FfiConverterInt64.write(value.timeLastModified, into: &buf)
        FfiConverterInt64.write(value.timesUsed, into: &buf)
    }
}

public func FfiConverterTypeAddress_lift(_ buf: RustBuffer) throws -> Address {
    return try FfiConverterTypeAddress.lift(buf)
}

public func FfiConverterTypeAddress_lower(_ value: Address) -> RustBuffer {
    return FfiConverterTypeAddress.lower(value)
}

public struct CreditCard {
    public var guid: String
    public var ccName: String
    public var ccNumberEnc: String
    public var ccNumberLast4: String
    public var ccExpMonth: Int64
    public var ccExpYear: Int64
    public var ccType: String
    public var timeCreated: Int64
    public var timeLastUsed: Int64?
    public var timeLastModified: Int64
    public var timesUsed: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: String, ccName: String, ccNumberEnc: String, ccNumberLast4: String, ccExpMonth: Int64, ccExpYear: Int64, ccType: String, timeCreated: Int64, timeLastUsed: Int64?, timeLastModified: Int64, timesUsed: Int64) {
        self.guid = guid
        self.ccName = ccName
        self.ccNumberEnc = ccNumberEnc
        self.ccNumberLast4 = ccNumberLast4
        self.ccExpMonth = ccExpMonth
        self.ccExpYear = ccExpYear
        self.ccType = ccType
        self.timeCreated = timeCreated
        self.timeLastUsed = timeLastUsed
        self.timeLastModified = timeLastModified
        self.timesUsed = timesUsed
    }
}

extension CreditCard: Equatable, Hashable {
    public static func == (lhs: CreditCard, rhs: CreditCard) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.ccName != rhs.ccName {
            return false
        }
        if lhs.ccNumberEnc != rhs.ccNumberEnc {
            return false
        }
        if lhs.ccNumberLast4 != rhs.ccNumberLast4 {
            return false
        }
        if lhs.ccExpMonth != rhs.ccExpMonth {
            return false
        }
        if lhs.ccExpYear != rhs.ccExpYear {
            return false
        }
        if lhs.ccType != rhs.ccType {
            return false
        }
        if lhs.timeCreated != rhs.timeCreated {
            return false
        }
        if lhs.timeLastUsed != rhs.timeLastUsed {
            return false
        }
        if lhs.timeLastModified != rhs.timeLastModified {
            return false
        }
        if lhs.timesUsed != rhs.timesUsed {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(ccName)
        hasher.combine(ccNumberEnc)
        hasher.combine(ccNumberLast4)
        hasher.combine(ccExpMonth)
        hasher.combine(ccExpYear)
        hasher.combine(ccType)
        hasher.combine(timeCreated)
        hasher.combine(timeLastUsed)
        hasher.combine(timeLastModified)
        hasher.combine(timesUsed)
    }
}

public struct FfiConverterTypeCreditCard: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CreditCard {
        return
            try CreditCard(
                guid: FfiConverterString.read(from: &buf),
                ccName: FfiConverterString.read(from: &buf),
                ccNumberEnc: FfiConverterString.read(from: &buf),
                ccNumberLast4: FfiConverterString.read(from: &buf),
                ccExpMonth: FfiConverterInt64.read(from: &buf),
                ccExpYear: FfiConverterInt64.read(from: &buf),
                ccType: FfiConverterString.read(from: &buf),
                timeCreated: FfiConverterInt64.read(from: &buf),
                timeLastUsed: FfiConverterOptionInt64.read(from: &buf),
                timeLastModified: FfiConverterInt64.read(from: &buf),
                timesUsed: FfiConverterInt64.read(from: &buf)
            )
    }

    public static func write(_ value: CreditCard, into buf: inout [UInt8]) {
        FfiConverterString.write(value.guid, into: &buf)
        FfiConverterString.write(value.ccName, into: &buf)
        FfiConverterString.write(value.ccNumberEnc, into: &buf)
        FfiConverterString.write(value.ccNumberLast4, into: &buf)
        FfiConverterInt64.write(value.ccExpMonth, into: &buf)
        FfiConverterInt64.write(value.ccExpYear, into: &buf)
        FfiConverterString.write(value.ccType, into: &buf)
        FfiConverterInt64.write(value.timeCreated, into: &buf)
        FfiConverterOptionInt64.write(value.timeLastUsed, into: &buf)
        FfiConverterInt64.write(value.timeLastModified, into: &buf)
        FfiConverterInt64.write(value.timesUsed, into: &buf)
    }
}

public func FfiConverterTypeCreditCard_lift(_ buf: RustBuffer) throws -> CreditCard {
    return try FfiConverterTypeCreditCard.lift(buf)
}

public func FfiConverterTypeCreditCard_lower(_ value: CreditCard) -> RustBuffer {
    return FfiConverterTypeCreditCard.lower(value)
}

public struct UpdatableAddressFields {
    public var name: String
    public var organization: String
    public var streetAddress: String
    public var addressLevel3: String
    public var addressLevel2: String
    public var addressLevel1: String
    public var postalCode: String
    public var country: String
    public var tel: String
    public var email: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(name: String, organization: String, streetAddress: String, addressLevel3: String, addressLevel2: String, addressLevel1: String, postalCode: String, country: String, tel: String, email: String) {
        self.name = name
        self.organization = organization
        self.streetAddress = streetAddress
        self.addressLevel3 = addressLevel3
        self.addressLevel2 = addressLevel2
        self.addressLevel1 = addressLevel1
        self.postalCode = postalCode
        self.country = country
        self.tel = tel
        self.email = email
    }
}

extension UpdatableAddressFields: Equatable, Hashable {
    public static func == (lhs: UpdatableAddressFields, rhs: UpdatableAddressFields) -> Bool {
        if lhs.name != rhs.name {
            return false
        }
        if lhs.organization != rhs.organization {
            return false
        }
        if lhs.streetAddress != rhs.streetAddress {
            return false
        }
        if lhs.addressLevel3 != rhs.addressLevel3 {
            return false
        }
        if lhs.addressLevel2 != rhs.addressLevel2 {
            return false
        }
        if lhs.addressLevel1 != rhs.addressLevel1 {
            return false
        }
        if lhs.postalCode != rhs.postalCode {
            return false
        }
        if lhs.country != rhs.country {
            return false
        }
        if lhs.tel != rhs.tel {
            return false
        }
        if lhs.email != rhs.email {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(name)
        hasher.combine(organization)
        hasher.combine(streetAddress)
        hasher.combine(addressLevel3)
        hasher.combine(addressLevel2)
        hasher.combine(addressLevel1)
        hasher.combine(postalCode)
        hasher.combine(country)
        hasher.combine(tel)
        hasher.combine(email)
    }
}

public struct FfiConverterTypeUpdatableAddressFields: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UpdatableAddressFields {
        return
            try UpdatableAddressFields(
                name: FfiConverterString.read(from: &buf),
                organization: FfiConverterString.read(from: &buf),
                streetAddress: FfiConverterString.read(from: &buf),
                addressLevel3: FfiConverterString.read(from: &buf),
                addressLevel2: FfiConverterString.read(from: &buf),
                addressLevel1: FfiConverterString.read(from: &buf),
                postalCode: FfiConverterString.read(from: &buf),
                country: FfiConverterString.read(from: &buf),
                tel: FfiConverterString.read(from: &buf),
                email: FfiConverterString.read(from: &buf)
            )
    }

    public static func write(_ value: UpdatableAddressFields, into buf: inout [UInt8]) {
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterString.write(value.organization, into: &buf)
        FfiConverterString.write(value.streetAddress, into: &buf)
        FfiConverterString.write(value.addressLevel3, into: &buf)
        FfiConverterString.write(value.addressLevel2, into: &buf)
        FfiConverterString.write(value.addressLevel1, into: &buf)
        FfiConverterString.write(value.postalCode, into: &buf)
        FfiConverterString.write(value.country, into: &buf)
        FfiConverterString.write(value.tel, into: &buf)
        FfiConverterString.write(value.email, into: &buf)
    }
}

public func FfiConverterTypeUpdatableAddressFields_lift(_ buf: RustBuffer) throws -> UpdatableAddressFields {
    return try FfiConverterTypeUpdatableAddressFields.lift(buf)
}

public func FfiConverterTypeUpdatableAddressFields_lower(_ value: UpdatableAddressFields) -> RustBuffer {
    return FfiConverterTypeUpdatableAddressFields.lower(value)
}

public struct UpdatableCreditCardFields {
    public var ccName: String
    public var ccNumberEnc: String
    public var ccNumberLast4: String
    public var ccExpMonth: Int64
    public var ccExpYear: Int64
    public var ccType: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(ccName: String, ccNumberEnc: String, ccNumberLast4: String, ccExpMonth: Int64, ccExpYear: Int64, ccType: String) {
        self.ccName = ccName
        self.ccNumberEnc = ccNumberEnc
        self.ccNumberLast4 = ccNumberLast4
        self.ccExpMonth = ccExpMonth
        self.ccExpYear = ccExpYear
        self.ccType = ccType
    }
}

extension UpdatableCreditCardFields: Equatable, Hashable {
    public static func == (lhs: UpdatableCreditCardFields, rhs: UpdatableCreditCardFields) -> Bool {
        if lhs.ccName != rhs.ccName {
            return false
        }
        if lhs.ccNumberEnc != rhs.ccNumberEnc {
            return false
        }
        if lhs.ccNumberLast4 != rhs.ccNumberLast4 {
            return false
        }
        if lhs.ccExpMonth != rhs.ccExpMonth {
            return false
        }
        if lhs.ccExpYear != rhs.ccExpYear {
            return false
        }
        if lhs.ccType != rhs.ccType {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(ccName)
        hasher.combine(ccNumberEnc)
        hasher.combine(ccNumberLast4)
        hasher.combine(ccExpMonth)
        hasher.combine(ccExpYear)
        hasher.combine(ccType)
    }
}

public struct FfiConverterTypeUpdatableCreditCardFields: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UpdatableCreditCardFields {
        return
            try UpdatableCreditCardFields(
                ccName: FfiConverterString.read(from: &buf),
                ccNumberEnc: FfiConverterString.read(from: &buf),
                ccNumberLast4: FfiConverterString.read(from: &buf),
                ccExpMonth: FfiConverterInt64.read(from: &buf),
                ccExpYear: FfiConverterInt64.read(from: &buf),
                ccType: FfiConverterString.read(from: &buf)
            )
    }

    public static func write(_ value: UpdatableCreditCardFields, into buf: inout [UInt8]) {
        FfiConverterString.write(value.ccName, into: &buf)
        FfiConverterString.write(value.ccNumberEnc, into: &buf)
        FfiConverterString.write(value.ccNumberLast4, into: &buf)
        FfiConverterInt64.write(value.ccExpMonth, into: &buf)
        FfiConverterInt64.write(value.ccExpYear, into: &buf)
        FfiConverterString.write(value.ccType, into: &buf)
    }
}

public func FfiConverterTypeUpdatableCreditCardFields_lift(_ buf: RustBuffer) throws -> UpdatableCreditCardFields {
    return try FfiConverterTypeUpdatableCreditCardFields.lift(buf)
}

public func FfiConverterTypeUpdatableCreditCardFields_lower(_ value: UpdatableCreditCardFields) -> RustBuffer {
    return FfiConverterTypeUpdatableCreditCardFields.lower(value)
}

public enum AutofillApiError {
    case SqlError(reason: String
    )
    case InterruptedError
    case CryptoError(reason: String
    )
    case NoSuchRecord(guid: String
    )
    case UnexpectedAutofillApiError(reason: String
    )
}

public struct FfiConverterTypeAutofillApiError: FfiConverterRustBuffer {
    typealias SwiftType = AutofillApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AutofillApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .SqlError(
                reason: FfiConverterString.read(from: &buf)
            )
        case 2: return .InterruptedError
        case 3: return try .CryptoError(
                reason: FfiConverterString.read(from: &buf)
            )
        case 4: return try .NoSuchRecord(
                guid: FfiConverterString.read(from: &buf)
            )
        case 5: return try .UnexpectedAutofillApiError(
                reason: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: AutofillApiError, into buf: inout [UInt8]) {
        switch value {
        case let .SqlError(reason):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(reason, into: &buf)

        case .InterruptedError:
            writeInt(&buf, Int32(2))

        case let .CryptoError(reason):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(reason, into: &buf)

        case let .NoSuchRecord(guid):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(guid, into: &buf)

        case let .UnexpectedAutofillApiError(reason):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(reason, into: &buf)
        }
    }
}

extension AutofillApiError: Equatable, Hashable {}

extension AutofillApiError: Error {}

private struct FfiConverterOptionInt64: FfiConverterRustBuffer {
    typealias SwiftType = Int64?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt64.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt64.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceTypeAddress: FfiConverterRustBuffer {
    typealias SwiftType = [Address]

    public static func write(_ value: [Address], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeAddress.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Address] {
        let len: Int32 = try readInt(&buf)
        var seq = [Address]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeAddress.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeCreditCard: FfiConverterRustBuffer {
    typealias SwiftType = [CreditCard]

    public static func write(_ value: [CreditCard], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeCreditCard.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [CreditCard] {
        let len: Int32 = try readInt(&buf)
        var seq = [CreditCard]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeCreditCard.read(from: &buf))
        }
        return seq
    }
}

public func createAutofillKey() throws -> String {
    return try FfiConverterString.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_func_create_autofill_key($0
        )
    })
}

public func decryptString(key: String, ciphertext: String) throws -> String {
    return try FfiConverterString.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_func_decrypt_string(
            FfiConverterString.lower(key),
            FfiConverterString.lower(ciphertext), $0
        )
    })
}

public func encryptString(key: String, cleartext: String) throws -> String {
    return try FfiConverterString.lift(rustCallWithError(FfiConverterTypeAutofillApiError.lift) {
        uniffi_autofill_fn_func_encrypt_string(
            FfiConverterString.lower(key),
            FfiConverterString.lower(cleartext), $0
        )
    })
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_autofill_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_autofill_checksum_func_create_autofill_key() != 38716 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_func_decrypt_string() != 40907 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_func_encrypt_string() != 64714 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_add_address() != 34214 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_add_credit_card() != 46430 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_delete_address() != 23936 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_delete_credit_card() != 31085 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_get_address() != 50527 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_get_all_addresses() != 8878 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_get_all_credit_cards() != 38961 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_get_credit_card() != 36642 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_register_with_sync_manager() != 24273 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_scrub_encrypted_data() != 8431 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_touch_address() != 22966 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_touch_credit_card() != 3986 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_update_address() != 64691 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_method_store_update_credit_card() != 33521 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_autofill_checksum_constructor_store_new() != 48850 {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all
