// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len: 0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_nimbus_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_nimbus_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        lock()
        defer { self.unlock() }
        return try f()
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_UNEXPECTED_ERROR: Int8 = 2
private let CALL_CANCELLED: Int8 = 3

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_UNEXPECTED_ERROR:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    case CALL_CANCELLED:
        fatalError("Cancellation not supported yet")

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> Void
) {
    do {
        try writeReturn(makeCall())
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> Void,
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private class UniffiHandleMap<T> {
    private var map: [UInt64: T] = [:]
    private let lock = NSLock()
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

    func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        map.count
    }
}

// Public interface members begin here.

private struct FfiConverterInt32: FfiConverterPrimitive {
    typealias FfiType = Int32
    typealias SwiftType = Int32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int32, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol NimbusClientProtocol: AnyObject {
    func advanceEventTime(bySeconds: Int64) throws

    func applyPendingExperiments() throws -> [EnrollmentChangeEvent]

    func clearEvents() throws

    func createStringHelper(additionalContext: JsonObject?) throws -> NimbusStringHelper

    func createTargetingHelper(additionalContext: JsonObject?) throws -> NimbusTargetingHelper

    func dumpStateToLog() throws

    func fetchExperiments() throws

    func getActiveExperiments() throws -> [EnrolledExperiment]

    func getAvailableExperiments() throws -> [AvailableExperiment]

    func getExperimentBranch(id: String) throws -> String?

    func getExperimentBranches(experimentSlug: String) throws -> [ExperimentBranch]

    func getFeatureConfigVariables(featureId: String) throws -> String?

    func getGlobalUserParticipation() throws -> Bool

    func initialize() throws

    func isFetchEnabled() throws -> Bool

    func optInWithBranch(experimentSlug: String, branch: String) throws -> [EnrollmentChangeEvent]

    func optOut(experimentSlug: String) throws -> [EnrollmentChangeEvent]

    func recordEvent(eventId: String, count: Int64) throws

    func recordFeatureExposure(featureId: String, slug: String?)

    func recordMalformedFeatureConfig(featureId: String, partId: String)

    func recordPastEvent(eventId: String, secondsAgo: Int64, count: Int64) throws

    func resetEnrollments() throws

    func resetTelemetryIdentifiers() throws -> [EnrollmentChangeEvent]

    func setExperimentsLocally(experimentsJson: String) throws

    func setFetchEnabled(flag: Bool) throws

    func setGlobalUserParticipation(optIn: Bool) throws -> [EnrollmentChangeEvent]
}

open class NimbusClient:
    NimbusClientProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_nimbus_fn_clone_nimbusclient(self.pointer, $0) }
    }

    public convenience init(appCtx: AppContext, recordedContext: RecordedContext?, coenrollingFeatureIds: [String], dbpath: String, remoteSettingsConfig: RemoteSettingsConfig?, metricsHandler: MetricsHandler) throws {
        let pointer =
            try rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_constructor_nimbusclient_new(
                    FfiConverterTypeAppContext.lower(appCtx),
                    FfiConverterOptionTypeRecordedContext.lower(recordedContext),
                    FfiConverterSequenceString.lower(coenrollingFeatureIds),
                    FfiConverterString.lower(dbpath),
                    FfiConverterOptionTypeRemoteSettingsConfig.lower(remoteSettingsConfig),
                    FfiConverterCallbackInterfaceMetricsHandler.lower(metricsHandler), $0
                )
            }
        self.init(unsafeFromRawPointer: pointer)
    }

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_nimbus_fn_free_nimbusclient(pointer, $0) }
    }

    open func advanceEventTime(bySeconds: Int64) throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_advance_event_time(self.uniffiClonePointer(),
                                                                FfiConverterInt64.lower(bySeconds), $0)
    }
    }

    open func applyPendingExperiments() throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_apply_pending_experiments(self.uniffiClonePointer(), $0)
        })
    }

    open func clearEvents() throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_clear_events(self.uniffiClonePointer(), $0)
    }
    }

    open func createStringHelper(additionalContext: JsonObject? = nil) throws -> NimbusStringHelper {
        return try FfiConverterTypeNimbusStringHelper.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_create_string_helper(self.uniffiClonePointer(),
                                                                      FfiConverterOptionTypeJsonObject.lower(additionalContext), $0)
        })
    }

    open func createTargetingHelper(additionalContext: JsonObject? = nil) throws -> NimbusTargetingHelper {
        return try FfiConverterTypeNimbusTargetingHelper.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_create_targeting_helper(self.uniffiClonePointer(),
                                                                         FfiConverterOptionTypeJsonObject.lower(additionalContext), $0)
        })
    }

    open func dumpStateToLog() throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_dump_state_to_log(self.uniffiClonePointer(), $0)
    }
    }

    open func fetchExperiments() throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_fetch_experiments(self.uniffiClonePointer(), $0)
    }
    }

    open func getActiveExperiments() throws -> [EnrolledExperiment] {
        return try FfiConverterSequenceTypeEnrolledExperiment.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_get_active_experiments(self.uniffiClonePointer(), $0)
        })
    }

    open func getAvailableExperiments() throws -> [AvailableExperiment] {
        return try FfiConverterSequenceTypeAvailableExperiment.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_get_available_experiments(self.uniffiClonePointer(), $0)
        })
    }

    open func getExperimentBranch(id: String) throws -> String? {
        return try FfiConverterOptionString.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_get_experiment_branch(self.uniffiClonePointer(),
                                                                       FfiConverterString.lower(id), $0)
        })
    }

    open func getExperimentBranches(experimentSlug: String) throws -> [ExperimentBranch] {
        return try FfiConverterSequenceTypeExperimentBranch.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_get_experiment_branches(self.uniffiClonePointer(),
                                                                         FfiConverterString.lower(experimentSlug), $0)
        })
    }

    open func getFeatureConfigVariables(featureId: String) throws -> String? {
        return try FfiConverterOptionString.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_get_feature_config_variables(self.uniffiClonePointer(),
                                                                              FfiConverterString.lower(featureId), $0)
        })
    }

    open func getGlobalUserParticipation() throws -> Bool {
        return try FfiConverterBool.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_get_global_user_participation(self.uniffiClonePointer(), $0)
        })
    }

    open func initialize() throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_initialize(self.uniffiClonePointer(), $0)
    }
    }

    open func isFetchEnabled() throws -> Bool {
        return try FfiConverterBool.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_is_fetch_enabled(self.uniffiClonePointer(), $0)
        })
    }

    open func optInWithBranch(experimentSlug: String, branch: String) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_opt_in_with_branch(self.uniffiClonePointer(),
                                                                    FfiConverterString.lower(experimentSlug),
                                                                    FfiConverterString.lower(branch), $0)
        })
    }

    open func optOut(experimentSlug: String) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_opt_out(self.uniffiClonePointer(),
                                                         FfiConverterString.lower(experimentSlug), $0)
        })
    }

    open func recordEvent(eventId: String, count: Int64 = Int64(1)) throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_record_event(self.uniffiClonePointer(),
                                                          FfiConverterString.lower(eventId),
                                                          FfiConverterInt64.lower(count), $0)
    }
    }

    open func recordFeatureExposure(featureId: String, slug: String?) { try! rustCall {
        uniffi_nimbus_fn_method_nimbusclient_record_feature_exposure(self.uniffiClonePointer(),
                                                                     FfiConverterString.lower(featureId),
                                                                     FfiConverterOptionString.lower(slug), $0)
    }
    }

    open func recordMalformedFeatureConfig(featureId: String, partId: String) { try! rustCall {
        uniffi_nimbus_fn_method_nimbusclient_record_malformed_feature_config(self.uniffiClonePointer(),
                                                                             FfiConverterString.lower(featureId),
                                                                             FfiConverterString.lower(partId), $0)
    }
    }

    open func recordPastEvent(eventId: String, secondsAgo: Int64, count: Int64 = Int64(1)) throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_record_past_event(self.uniffiClonePointer(),
                                                               FfiConverterString.lower(eventId),
                                                               FfiConverterInt64.lower(secondsAgo),
                                                               FfiConverterInt64.lower(count), $0)
    }
    }

    open func resetEnrollments() throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_reset_enrollments(self.uniffiClonePointer(), $0)
    }
    }

    open func resetTelemetryIdentifiers() throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_reset_telemetry_identifiers(self.uniffiClonePointer(), $0)
        })
    }

    open func setExperimentsLocally(experimentsJson: String) throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_set_experiments_locally(self.uniffiClonePointer(),
                                                                     FfiConverterString.lower(experimentsJson), $0)
    }
    }

    open func setFetchEnabled(flag: Bool) throws { try rustCallWithError(FfiConverterTypeNimbusError.lift) {
        uniffi_nimbus_fn_method_nimbusclient_set_fetch_enabled(self.uniffiClonePointer(),
                                                               FfiConverterBool.lower(flag), $0)
    }
    }

    open func setGlobalUserParticipation(optIn: Bool) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbusclient_set_global_user_participation(self.uniffiClonePointer(),
                                                                               FfiConverterBool.lower(optIn), $0)
        })
    }
}

public struct FfiConverterTypeNimbusClient: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = NimbusClient

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusClient {
        return NimbusClient(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: NimbusClient) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusClient {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: NimbusClient, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypeNimbusClient_lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusClient {
    return try FfiConverterTypeNimbusClient.lift(pointer)
}

public func FfiConverterTypeNimbusClient_lower(_ value: NimbusClient) -> UnsafeMutableRawPointer {
    return FfiConverterTypeNimbusClient.lower(value)
}

public protocol NimbusStringHelperProtocol: AnyObject {
    func getUuid(template: String) -> String?

    func stringFormat(template: String, uuid: String?) -> String
}

open class NimbusStringHelper:
    NimbusStringHelperProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_nimbus_fn_clone_nimbusstringhelper(self.pointer, $0) }
    }

    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_nimbus_fn_free_nimbusstringhelper(pointer, $0) }
    }

    open func getUuid(template: String) -> String? {
        return try! FfiConverterOptionString.lift(try! rustCall {
            uniffi_nimbus_fn_method_nimbusstringhelper_get_uuid(self.uniffiClonePointer(),
                                                                FfiConverterString.lower(template), $0)
        })
    }

    open func stringFormat(template: String, uuid: String? = nil) -> String {
        return try! FfiConverterString.lift(try! rustCall {
            uniffi_nimbus_fn_method_nimbusstringhelper_string_format(self.uniffiClonePointer(),
                                                                     FfiConverterString.lower(template),
                                                                     FfiConverterOptionString.lower(uuid), $0)
        })
    }
}

public struct FfiConverterTypeNimbusStringHelper: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = NimbusStringHelper

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusStringHelper {
        return NimbusStringHelper(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: NimbusStringHelper) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusStringHelper {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: NimbusStringHelper, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypeNimbusStringHelper_lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusStringHelper {
    return try FfiConverterTypeNimbusStringHelper.lift(pointer)
}

public func FfiConverterTypeNimbusStringHelper_lower(_ value: NimbusStringHelper) -> UnsafeMutableRawPointer {
    return FfiConverterTypeNimbusStringHelper.lower(value)
}

public protocol NimbusTargetingHelperProtocol: AnyObject {
    func evalJexl(expression: String) throws -> Bool
}

open class NimbusTargetingHelper:
    NimbusTargetingHelperProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_nimbus_fn_clone_nimbustargetinghelper(self.pointer, $0) }
    }

    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_nimbus_fn_free_nimbustargetinghelper(pointer, $0) }
    }

    open func evalJexl(expression: String) throws -> Bool {
        return try FfiConverterBool.lift(rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_method_nimbustargetinghelper_eval_jexl(self.uniffiClonePointer(),
                                                                    FfiConverterString.lower(expression), $0)
        })
    }
}

public struct FfiConverterTypeNimbusTargetingHelper: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = NimbusTargetingHelper

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusTargetingHelper {
        return NimbusTargetingHelper(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: NimbusTargetingHelper) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusTargetingHelper {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: NimbusTargetingHelper, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypeNimbusTargetingHelper_lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusTargetingHelper {
    return try FfiConverterTypeNimbusTargetingHelper.lift(pointer)
}

public func FfiConverterTypeNimbusTargetingHelper_lower(_ value: NimbusTargetingHelper) -> UnsafeMutableRawPointer {
    return FfiConverterTypeNimbusTargetingHelper.lower(value)
}

public protocol RecordedContext: AnyObject {
    func record()

    func toJson() -> JsonObject
}

open class RecordedContextImpl:
    RecordedContext
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_nimbus_fn_clone_recordedcontext(self.pointer, $0) }
    }

    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_nimbus_fn_free_recordedcontext(pointer, $0) }
    }

    open func record() { try! rustCall {
        uniffi_nimbus_fn_method_recordedcontext_record(self.uniffiClonePointer(), $0)
    }
    }

    open func toJson() -> JsonObject {
        return try! FfiConverterTypeJsonObject.lift(try! rustCall {
            uniffi_nimbus_fn_method_recordedcontext_to_json(self.uniffiClonePointer(), $0)
        })
    }
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
private let IDX_CALLBACK_FREE: Int32 = 0
// Callback return codes
private let UNIFFI_CALLBACK_SUCCESS: Int32 = 0
private let UNIFFI_CALLBACK_ERROR: Int32 = 1
private let UNIFFI_CALLBACK_UNEXPECTED_ERROR: Int32 = 2

// Put the implementation in a struct so we don't pollute the top-level namespace
private enum UniffiCallbackInterfaceRecordedContext {
    // Create the VTable using a series of closures.
    // Swift automatically converts these into C callback functions.
    static var vtable: UniffiVTableCallbackInterfaceRecordedContext = .init(
        record: { (
            uniffiHandle: UInt64,
            _: UnsafeMutableRawPointer,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws in
                guard let uniffiObj = try? FfiConverterTypeRecordedContext.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return uniffiObj.record(
                )
            }

            let writeReturn = { () }
            uniffiTraitInterfaceCall(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn
            )
        },
        toJson: { (
            uniffiHandle: UInt64,
            uniffiOutReturn: UnsafeMutablePointer<RustBuffer>,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws -> JsonObject in
                guard let uniffiObj = try? FfiConverterTypeRecordedContext.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return uniffiObj.toJson(
                )
            }

            let writeReturn = { uniffiOutReturn.pointee = FfiConverterTypeJsonObject.lower($0) }
            uniffiTraitInterfaceCall(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn
            )
        },
        uniffiFree: { (uniffiHandle: UInt64) in
            let result = try? FfiConverterTypeRecordedContext.handleMap.remove(handle: uniffiHandle)
            if result == nil {
                print("Uniffi callback interface RecordedContext: handle missing in uniffiFree")
            }
        }
    )
}

private func uniffiCallbackInitRecordedContext() {
    uniffi_nimbus_fn_init_callback_vtable_recordedcontext(&UniffiCallbackInterfaceRecordedContext.vtable)
}

public struct FfiConverterTypeRecordedContext: FfiConverter {
    fileprivate static var handleMap = UniffiHandleMap<RecordedContext>()

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = RecordedContext

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> RecordedContext {
        return RecordedContextImpl(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: RecordedContext) -> UnsafeMutableRawPointer {
        guard let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: handleMap.insert(obj: value))) else {
            fatalError("Cast to UnsafeMutableRawPointer failed")
        }
        return ptr
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> RecordedContext {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: RecordedContext, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypeRecordedContext_lift(_ pointer: UnsafeMutableRawPointer) throws -> RecordedContext {
    return try FfiConverterTypeRecordedContext.lift(pointer)
}

public func FfiConverterTypeRecordedContext_lower(_ value: RecordedContext) -> UnsafeMutableRawPointer {
    return FfiConverterTypeRecordedContext.lower(value)
}

public struct AppContext {
    public var appName: String
    public var appId: String
    public var channel: String
    public var appVersion: String?
    public var appBuild: String?
    public var architecture: String?
    public var deviceManufacturer: String?
    public var deviceModel: String?
    public var locale: String?
    public var os: String?
    public var osVersion: String?
    public var androidSdkVersion: String?
    public var debugTag: String?
    public var installationDate: Int64?
    public var homeDirectory: String?
    public var customTargetingAttributes: JsonObject?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(appName: String, appId: String, channel: String, appVersion: String?, appBuild: String?, architecture: String?, deviceManufacturer: String?, deviceModel: String?, locale: String?, os: String?, osVersion: String?, androidSdkVersion: String?, debugTag: String?, installationDate: Int64?, homeDirectory: String?, customTargetingAttributes: JsonObject?) {
        self.appName = appName
        self.appId = appId
        self.channel = channel
        self.appVersion = appVersion
        self.appBuild = appBuild
        self.architecture = architecture
        self.deviceManufacturer = deviceManufacturer
        self.deviceModel = deviceModel
        self.locale = locale
        self.os = os
        self.osVersion = osVersion
        self.androidSdkVersion = androidSdkVersion
        self.debugTag = debugTag
        self.installationDate = installationDate
        self.homeDirectory = homeDirectory
        self.customTargetingAttributes = customTargetingAttributes
    }
}

extension AppContext: Equatable, Hashable {
    public static func == (lhs: AppContext, rhs: AppContext) -> Bool {
        if lhs.appName != rhs.appName {
            return false
        }
        if lhs.appId != rhs.appId {
            return false
        }
        if lhs.channel != rhs.channel {
            return false
        }
        if lhs.appVersion != rhs.appVersion {
            return false
        }
        if lhs.appBuild != rhs.appBuild {
            return false
        }
        if lhs.architecture != rhs.architecture {
            return false
        }
        if lhs.deviceManufacturer != rhs.deviceManufacturer {
            return false
        }
        if lhs.deviceModel != rhs.deviceModel {
            return false
        }
        if lhs.locale != rhs.locale {
            return false
        }
        if lhs.os != rhs.os {
            return false
        }
        if lhs.osVersion != rhs.osVersion {
            return false
        }
        if lhs.androidSdkVersion != rhs.androidSdkVersion {
            return false
        }
        if lhs.debugTag != rhs.debugTag {
            return false
        }
        if lhs.installationDate != rhs.installationDate {
            return false
        }
        if lhs.homeDirectory != rhs.homeDirectory {
            return false
        }
        if lhs.customTargetingAttributes != rhs.customTargetingAttributes {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(appName)
        hasher.combine(appId)
        hasher.combine(channel)
        hasher.combine(appVersion)
        hasher.combine(appBuild)
        hasher.combine(architecture)
        hasher.combine(deviceManufacturer)
        hasher.combine(deviceModel)
        hasher.combine(locale)
        hasher.combine(os)
        hasher.combine(osVersion)
        hasher.combine(androidSdkVersion)
        hasher.combine(debugTag)
        hasher.combine(installationDate)
        hasher.combine(homeDirectory)
        hasher.combine(customTargetingAttributes)
    }
}

public struct FfiConverterTypeAppContext: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AppContext {
        return
            try AppContext(
                appName: FfiConverterString.read(from: &buf),
                appId: FfiConverterString.read(from: &buf),
                channel: FfiConverterString.read(from: &buf),
                appVersion: FfiConverterOptionString.read(from: &buf),
                appBuild: FfiConverterOptionString.read(from: &buf),
                architecture: FfiConverterOptionString.read(from: &buf),
                deviceManufacturer: FfiConverterOptionString.read(from: &buf),
                deviceModel: FfiConverterOptionString.read(from: &buf),
                locale: FfiConverterOptionString.read(from: &buf),
                os: FfiConverterOptionString.read(from: &buf),
                osVersion: FfiConverterOptionString.read(from: &buf),
                androidSdkVersion: FfiConverterOptionString.read(from: &buf),
                debugTag: FfiConverterOptionString.read(from: &buf),
                installationDate: FfiConverterOptionInt64.read(from: &buf),
                homeDirectory: FfiConverterOptionString.read(from: &buf),
                customTargetingAttributes: FfiConverterOptionTypeJsonObject.read(from: &buf)
            )
    }

    public static func write(_ value: AppContext, into buf: inout [UInt8]) {
        FfiConverterString.write(value.appName, into: &buf)
        FfiConverterString.write(value.appId, into: &buf)
        FfiConverterString.write(value.channel, into: &buf)
        FfiConverterOptionString.write(value.appVersion, into: &buf)
        FfiConverterOptionString.write(value.appBuild, into: &buf)
        FfiConverterOptionString.write(value.architecture, into: &buf)
        FfiConverterOptionString.write(value.deviceManufacturer, into: &buf)
        FfiConverterOptionString.write(value.deviceModel, into: &buf)
        FfiConverterOptionString.write(value.locale, into: &buf)
        FfiConverterOptionString.write(value.os, into: &buf)
        FfiConverterOptionString.write(value.osVersion, into: &buf)
        FfiConverterOptionString.write(value.androidSdkVersion, into: &buf)
        FfiConverterOptionString.write(value.debugTag, into: &buf)
        FfiConverterOptionInt64.write(value.installationDate, into: &buf)
        FfiConverterOptionString.write(value.homeDirectory, into: &buf)
        FfiConverterOptionTypeJsonObject.write(value.customTargetingAttributes, into: &buf)
    }
}

public func FfiConverterTypeAppContext_lift(_ buf: RustBuffer) throws -> AppContext {
    return try FfiConverterTypeAppContext.lift(buf)
}

public func FfiConverterTypeAppContext_lower(_ value: AppContext) -> RustBuffer {
    return FfiConverterTypeAppContext.lower(value)
}

public struct AvailableExperiment {
    public var slug: String
    public var userFacingName: String
    public var userFacingDescription: String
    public var branches: [ExperimentBranch]
    public var referenceBranch: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(slug: String, userFacingName: String, userFacingDescription: String, branches: [ExperimentBranch], referenceBranch: String?) {
        self.slug = slug
        self.userFacingName = userFacingName
        self.userFacingDescription = userFacingDescription
        self.branches = branches
        self.referenceBranch = referenceBranch
    }
}

extension AvailableExperiment: Equatable, Hashable {
    public static func == (lhs: AvailableExperiment, rhs: AvailableExperiment) -> Bool {
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.userFacingName != rhs.userFacingName {
            return false
        }
        if lhs.userFacingDescription != rhs.userFacingDescription {
            return false
        }
        if lhs.branches != rhs.branches {
            return false
        }
        if lhs.referenceBranch != rhs.referenceBranch {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(slug)
        hasher.combine(userFacingName)
        hasher.combine(userFacingDescription)
        hasher.combine(branches)
        hasher.combine(referenceBranch)
    }
}

public struct FfiConverterTypeAvailableExperiment: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AvailableExperiment {
        return
            try AvailableExperiment(
                slug: FfiConverterString.read(from: &buf),
                userFacingName: FfiConverterString.read(from: &buf),
                userFacingDescription: FfiConverterString.read(from: &buf),
                branches: FfiConverterSequenceTypeExperimentBranch.read(from: &buf),
                referenceBranch: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: AvailableExperiment, into buf: inout [UInt8]) {
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterString.write(value.userFacingName, into: &buf)
        FfiConverterString.write(value.userFacingDescription, into: &buf)
        FfiConverterSequenceTypeExperimentBranch.write(value.branches, into: &buf)
        FfiConverterOptionString.write(value.referenceBranch, into: &buf)
    }
}

public func FfiConverterTypeAvailableExperiment_lift(_ buf: RustBuffer) throws -> AvailableExperiment {
    return try FfiConverterTypeAvailableExperiment.lift(buf)
}

public func FfiConverterTypeAvailableExperiment_lower(_ value: AvailableExperiment) -> RustBuffer {
    return FfiConverterTypeAvailableExperiment.lower(value)
}

public struct EnrolledExperiment {
    public var featureIds: [String]
    public var slug: String
    public var userFacingName: String
    public var userFacingDescription: String
    public var branchSlug: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(featureIds: [String], slug: String, userFacingName: String, userFacingDescription: String, branchSlug: String) {
        self.featureIds = featureIds
        self.slug = slug
        self.userFacingName = userFacingName
        self.userFacingDescription = userFacingDescription
        self.branchSlug = branchSlug
    }
}

extension EnrolledExperiment: Equatable, Hashable {
    public static func == (lhs: EnrolledExperiment, rhs: EnrolledExperiment) -> Bool {
        if lhs.featureIds != rhs.featureIds {
            return false
        }
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.userFacingName != rhs.userFacingName {
            return false
        }
        if lhs.userFacingDescription != rhs.userFacingDescription {
            return false
        }
        if lhs.branchSlug != rhs.branchSlug {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(featureIds)
        hasher.combine(slug)
        hasher.combine(userFacingName)
        hasher.combine(userFacingDescription)
        hasher.combine(branchSlug)
    }
}

public struct FfiConverterTypeEnrolledExperiment: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrolledExperiment {
        return
            try EnrolledExperiment(
                featureIds: FfiConverterSequenceString.read(from: &buf),
                slug: FfiConverterString.read(from: &buf),
                userFacingName: FfiConverterString.read(from: &buf),
                userFacingDescription: FfiConverterString.read(from: &buf),
                branchSlug: FfiConverterString.read(from: &buf)
            )
    }

    public static func write(_ value: EnrolledExperiment, into buf: inout [UInt8]) {
        FfiConverterSequenceString.write(value.featureIds, into: &buf)
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterString.write(value.userFacingName, into: &buf)
        FfiConverterString.write(value.userFacingDescription, into: &buf)
        FfiConverterString.write(value.branchSlug, into: &buf)
    }
}

public func FfiConverterTypeEnrolledExperiment_lift(_ buf: RustBuffer) throws -> EnrolledExperiment {
    return try FfiConverterTypeEnrolledExperiment.lift(buf)
}

public func FfiConverterTypeEnrolledExperiment_lower(_ value: EnrolledExperiment) -> RustBuffer {
    return FfiConverterTypeEnrolledExperiment.lower(value)
}

public struct EnrollmentChangeEvent {
    public var experimentSlug: String
    public var branchSlug: String
    public var reason: String?
    public var change: EnrollmentChangeEventType

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(experimentSlug: String, branchSlug: String, reason: String?, change: EnrollmentChangeEventType) {
        self.experimentSlug = experimentSlug
        self.branchSlug = branchSlug
        self.reason = reason
        self.change = change
    }
}

extension EnrollmentChangeEvent: Equatable, Hashable {
    public static func == (lhs: EnrollmentChangeEvent, rhs: EnrollmentChangeEvent) -> Bool {
        if lhs.experimentSlug != rhs.experimentSlug {
            return false
        }
        if lhs.branchSlug != rhs.branchSlug {
            return false
        }
        if lhs.reason != rhs.reason {
            return false
        }
        if lhs.change != rhs.change {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(experimentSlug)
        hasher.combine(branchSlug)
        hasher.combine(reason)
        hasher.combine(change)
    }
}

public struct FfiConverterTypeEnrollmentChangeEvent: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrollmentChangeEvent {
        return
            try EnrollmentChangeEvent(
                experimentSlug: FfiConverterString.read(from: &buf),
                branchSlug: FfiConverterString.read(from: &buf),
                reason: FfiConverterOptionString.read(from: &buf),
                change: FfiConverterTypeEnrollmentChangeEventType.read(from: &buf)
            )
    }

    public static func write(_ value: EnrollmentChangeEvent, into buf: inout [UInt8]) {
        FfiConverterString.write(value.experimentSlug, into: &buf)
        FfiConverterString.write(value.branchSlug, into: &buf)
        FfiConverterOptionString.write(value.reason, into: &buf)
        FfiConverterTypeEnrollmentChangeEventType.write(value.change, into: &buf)
    }
}

public func FfiConverterTypeEnrollmentChangeEvent_lift(_ buf: RustBuffer) throws -> EnrollmentChangeEvent {
    return try FfiConverterTypeEnrollmentChangeEvent.lift(buf)
}

public func FfiConverterTypeEnrollmentChangeEvent_lower(_ value: EnrollmentChangeEvent) -> RustBuffer {
    return FfiConverterTypeEnrollmentChangeEvent.lower(value)
}

public struct EnrollmentStatusExtraDef {
    public var branch: String?
    public var conflictSlug: String?
    public var errorString: String?
    public var reason: String?
    public var slug: String?
    public var status: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(branch: String?, conflictSlug: String?, errorString: String?, reason: String?, slug: String?, status: String?) {
        self.branch = branch
        self.conflictSlug = conflictSlug
        self.errorString = errorString
        self.reason = reason
        self.slug = slug
        self.status = status
    }
}

extension EnrollmentStatusExtraDef: Equatable, Hashable {
    public static func == (lhs: EnrollmentStatusExtraDef, rhs: EnrollmentStatusExtraDef) -> Bool {
        if lhs.branch != rhs.branch {
            return false
        }
        if lhs.conflictSlug != rhs.conflictSlug {
            return false
        }
        if lhs.errorString != rhs.errorString {
            return false
        }
        if lhs.reason != rhs.reason {
            return false
        }
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.status != rhs.status {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(branch)
        hasher.combine(conflictSlug)
        hasher.combine(errorString)
        hasher.combine(reason)
        hasher.combine(slug)
        hasher.combine(status)
    }
}

public struct FfiConverterTypeEnrollmentStatusExtraDef: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrollmentStatusExtraDef {
        return
            try EnrollmentStatusExtraDef(
                branch: FfiConverterOptionString.read(from: &buf),
                conflictSlug: FfiConverterOptionString.read(from: &buf),
                errorString: FfiConverterOptionString.read(from: &buf),
                reason: FfiConverterOptionString.read(from: &buf),
                slug: FfiConverterOptionString.read(from: &buf),
                status: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: EnrollmentStatusExtraDef, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.branch, into: &buf)
        FfiConverterOptionString.write(value.conflictSlug, into: &buf)
        FfiConverterOptionString.write(value.errorString, into: &buf)
        FfiConverterOptionString.write(value.reason, into: &buf)
        FfiConverterOptionString.write(value.slug, into: &buf)
        FfiConverterOptionString.write(value.status, into: &buf)
    }
}

public func FfiConverterTypeEnrollmentStatusExtraDef_lift(_ buf: RustBuffer) throws -> EnrollmentStatusExtraDef {
    return try FfiConverterTypeEnrollmentStatusExtraDef.lift(buf)
}

public func FfiConverterTypeEnrollmentStatusExtraDef_lower(_ value: EnrollmentStatusExtraDef) -> RustBuffer {
    return FfiConverterTypeEnrollmentStatusExtraDef.lower(value)
}

public struct ExperimentBranch {
    public var slug: String
    public var ratio: Int32

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(slug: String, ratio: Int32) {
        self.slug = slug
        self.ratio = ratio
    }
}

extension ExperimentBranch: Equatable, Hashable {
    public static func == (lhs: ExperimentBranch, rhs: ExperimentBranch) -> Bool {
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.ratio != rhs.ratio {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(slug)
        hasher.combine(ratio)
    }
}

public struct FfiConverterTypeExperimentBranch: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ExperimentBranch {
        return
            try ExperimentBranch(
                slug: FfiConverterString.read(from: &buf),
                ratio: FfiConverterInt32.read(from: &buf)
            )
    }

    public static func write(_ value: ExperimentBranch, into buf: inout [UInt8]) {
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterInt32.write(value.ratio, into: &buf)
    }
}

public func FfiConverterTypeExperimentBranch_lift(_ buf: RustBuffer) throws -> ExperimentBranch {
    return try FfiConverterTypeExperimentBranch.lift(buf)
}

public func FfiConverterTypeExperimentBranch_lower(_ value: ExperimentBranch) -> RustBuffer {
    return FfiConverterTypeExperimentBranch.lower(value)
}

public struct FeatureExposureExtraDef {
    public var branch: String?
    public var slug: String
    public var featureId: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(branch: String?, slug: String, featureId: String) {
        self.branch = branch
        self.slug = slug
        self.featureId = featureId
    }
}

extension FeatureExposureExtraDef: Equatable, Hashable {
    public static func == (lhs: FeatureExposureExtraDef, rhs: FeatureExposureExtraDef) -> Bool {
        if lhs.branch != rhs.branch {
            return false
        }
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.featureId != rhs.featureId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(branch)
        hasher.combine(slug)
        hasher.combine(featureId)
    }
}

public struct FfiConverterTypeFeatureExposureExtraDef: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FeatureExposureExtraDef {
        return
            try FeatureExposureExtraDef(
                branch: FfiConverterOptionString.read(from: &buf),
                slug: FfiConverterString.read(from: &buf),
                featureId: FfiConverterString.read(from: &buf)
            )
    }

    public static func write(_ value: FeatureExposureExtraDef, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.branch, into: &buf)
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterString.write(value.featureId, into: &buf)
    }
}

public func FfiConverterTypeFeatureExposureExtraDef_lift(_ buf: RustBuffer) throws -> FeatureExposureExtraDef {
    return try FfiConverterTypeFeatureExposureExtraDef.lift(buf)
}

public func FfiConverterTypeFeatureExposureExtraDef_lower(_ value: FeatureExposureExtraDef) -> RustBuffer {
    return FfiConverterTypeFeatureExposureExtraDef.lower(value)
}

public struct MalformedFeatureConfigExtraDef {
    public var branch: String?
    public var slug: String?
    public var featureId: String
    public var part: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(branch: String?, slug: String?, featureId: String, part: String) {
        self.branch = branch
        self.slug = slug
        self.featureId = featureId
        self.part = part
    }
}

extension MalformedFeatureConfigExtraDef: Equatable, Hashable {
    public static func == (lhs: MalformedFeatureConfigExtraDef, rhs: MalformedFeatureConfigExtraDef) -> Bool {
        if lhs.branch != rhs.branch {
            return false
        }
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.featureId != rhs.featureId {
            return false
        }
        if lhs.part != rhs.part {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(branch)
        hasher.combine(slug)
        hasher.combine(featureId)
        hasher.combine(part)
    }
}

public struct FfiConverterTypeMalformedFeatureConfigExtraDef: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> MalformedFeatureConfigExtraDef {
        return
            try MalformedFeatureConfigExtraDef(
                branch: FfiConverterOptionString.read(from: &buf),
                slug: FfiConverterOptionString.read(from: &buf),
                featureId: FfiConverterString.read(from: &buf),
                part: FfiConverterString.read(from: &buf)
            )
    }

    public static func write(_ value: MalformedFeatureConfigExtraDef, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.branch, into: &buf)
        FfiConverterOptionString.write(value.slug, into: &buf)
        FfiConverterString.write(value.featureId, into: &buf)
        FfiConverterString.write(value.part, into: &buf)
    }
}

public func FfiConverterTypeMalformedFeatureConfigExtraDef_lift(_ buf: RustBuffer) throws -> MalformedFeatureConfigExtraDef {
    return try FfiConverterTypeMalformedFeatureConfigExtraDef.lift(buf)
}

public func FfiConverterTypeMalformedFeatureConfigExtraDef_lower(_ value: MalformedFeatureConfigExtraDef) -> RustBuffer {
    return FfiConverterTypeMalformedFeatureConfigExtraDef.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum EnrollmentChangeEventType {
    case enrollment
    case enrollFailed
    case disqualification
    case unenrollment
    case unenrollFailed
}

public struct FfiConverterTypeEnrollmentChangeEventType: FfiConverterRustBuffer {
    typealias SwiftType = EnrollmentChangeEventType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrollmentChangeEventType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .enrollment

        case 2: return .enrollFailed

        case 3: return .disqualification

        case 4: return .unenrollment

        case 5: return .unenrollFailed

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: EnrollmentChangeEventType, into buf: inout [UInt8]) {
        switch value {
        case .enrollment:
            writeInt(&buf, Int32(1))

        case .enrollFailed:
            writeInt(&buf, Int32(2))

        case .disqualification:
            writeInt(&buf, Int32(3))

        case .unenrollment:
            writeInt(&buf, Int32(4))

        case .unenrollFailed:
            writeInt(&buf, Int32(5))
        }
    }
}

public func FfiConverterTypeEnrollmentChangeEventType_lift(_ buf: RustBuffer) throws -> EnrollmentChangeEventType {
    return try FfiConverterTypeEnrollmentChangeEventType.lift(buf)
}

public func FfiConverterTypeEnrollmentChangeEventType_lower(_ value: EnrollmentChangeEventType) -> RustBuffer {
    return FfiConverterTypeEnrollmentChangeEventType.lower(value)
}

extension EnrollmentChangeEventType: Equatable, Hashable {}

public enum NimbusError {
    case InvalidPersistedData(message: String)

    case RkvError(message: String)

    case IoError(message: String)

    case JsonError(message: String)

    case EvaluationError(message: String)

    case InvalidExpression(message: String)

    case InvalidFraction(message: String)

    case TryFromSliceError(message: String)

    case EmptyRatiosError(message: String)

    case OutOfBoundsError(message: String)

    case UrlParsingError(message: String)

    case UuidError(message: String)

    case InvalidExperimentFormat(message: String)

    case InvalidPath(message: String)

    case InternalError(message: String)

    case NoSuchExperiment(message: String)

    case NoSuchBranch(message: String)

    case DatabaseNotReady(message: String)

    case VersionParsingError(message: String)

    case BehaviorError(message: String)

    case TryFromIntError(message: String)

    case ParseIntError(message: String)

    case TransformParameterError(message: String)

    case ClientError(message: String)

    case UniFfiCallbackError(message: String)
}

public struct FfiConverterTypeNimbusError: FfiConverterRustBuffer {
    typealias SwiftType = NimbusError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .InvalidPersistedData(
                message: FfiConverterString.read(from: &buf)
            )

        case 2: return try .RkvError(
                message: FfiConverterString.read(from: &buf)
            )

        case 3: return try .IoError(
                message: FfiConverterString.read(from: &buf)
            )

        case 4: return try .JsonError(
                message: FfiConverterString.read(from: &buf)
            )

        case 5: return try .EvaluationError(
                message: FfiConverterString.read(from: &buf)
            )

        case 6: return try .InvalidExpression(
                message: FfiConverterString.read(from: &buf)
            )

        case 7: return try .InvalidFraction(
                message: FfiConverterString.read(from: &buf)
            )

        case 8: return try .TryFromSliceError(
                message: FfiConverterString.read(from: &buf)
            )

        case 9: return try .EmptyRatiosError(
                message: FfiConverterString.read(from: &buf)
            )

        case 10: return try .OutOfBoundsError(
                message: FfiConverterString.read(from: &buf)
            )

        case 11: return try .UrlParsingError(
                message: FfiConverterString.read(from: &buf)
            )

        case 12: return try .UuidError(
                message: FfiConverterString.read(from: &buf)
            )

        case 13: return try .InvalidExperimentFormat(
                message: FfiConverterString.read(from: &buf)
            )

        case 14: return try .InvalidPath(
                message: FfiConverterString.read(from: &buf)
            )

        case 15: return try .InternalError(
                message: FfiConverterString.read(from: &buf)
            )

        case 16: return try .NoSuchExperiment(
                message: FfiConverterString.read(from: &buf)
            )

        case 17: return try .NoSuchBranch(
                message: FfiConverterString.read(from: &buf)
            )

        case 18: return try .DatabaseNotReady(
                message: FfiConverterString.read(from: &buf)
            )

        case 19: return try .VersionParsingError(
                message: FfiConverterString.read(from: &buf)
            )

        case 20: return try .BehaviorError(
                message: FfiConverterString.read(from: &buf)
            )

        case 21: return try .TryFromIntError(
                message: FfiConverterString.read(from: &buf)
            )

        case 22: return try .ParseIntError(
                message: FfiConverterString.read(from: &buf)
            )

        case 23: return try .TransformParameterError(
                message: FfiConverterString.read(from: &buf)
            )

        case 24: return try .ClientError(
                message: FfiConverterString.read(from: &buf)
            )

        case 25: return try .UniFfiCallbackError(
                message: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: NimbusError, into buf: inout [UInt8]) {
        switch value {
        case .InvalidPersistedData(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(1))
        case .RkvError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(2))
        case .IoError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(3))
        case .JsonError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(4))
        case .EvaluationError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(5))
        case .InvalidExpression(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(6))
        case .InvalidFraction(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(7))
        case .TryFromSliceError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(8))
        case .EmptyRatiosError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(9))
        case .OutOfBoundsError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(10))
        case .UrlParsingError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(11))
        case .UuidError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(12))
        case .InvalidExperimentFormat(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(13))
        case .InvalidPath(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(14))
        case .InternalError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(15))
        case .NoSuchExperiment(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(16))
        case .NoSuchBranch(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(17))
        case .DatabaseNotReady(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(18))
        case .VersionParsingError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(19))
        case .BehaviorError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(20))
        case .TryFromIntError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(21))
        case .ParseIntError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(22))
        case .TransformParameterError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(23))
        case .ClientError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(24))
        case .UniFfiCallbackError(_ /* message is ignored*/ ):
            writeInt(&buf, Int32(25))
        }
    }
}

extension NimbusError: Equatable, Hashable {}

extension NimbusError: Error {}

public protocol MetricsHandler: AnyObject {
    func recordEnrollmentStatuses(enrollmentStatusExtras: [EnrollmentStatusExtraDef])

    func recordFeatureActivation(event: FeatureExposureExtraDef)

    func recordFeatureExposure(event: FeatureExposureExtraDef)

    func recordMalformedFeatureConfig(event: MalformedFeatureConfigExtraDef)
}

// Put the implementation in a struct so we don't pollute the top-level namespace
private enum UniffiCallbackInterfaceMetricsHandler {
    // Create the VTable using a series of closures.
    // Swift automatically converts these into C callback functions.
    static var vtable: UniffiVTableCallbackInterfaceMetricsHandler = .init(
        recordEnrollmentStatuses: { (
            uniffiHandle: UInt64,
            enrollmentStatusExtras: RustBuffer,
            _: UnsafeMutableRawPointer,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws in
                guard let uniffiObj = try? FfiConverterCallbackInterfaceMetricsHandler.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.recordEnrollmentStatuses(
                    enrollmentStatusExtras: FfiConverterSequenceTypeEnrollmentStatusExtraDef.lift(enrollmentStatusExtras)
                )
            }

            let writeReturn = { () }
            uniffiTraitInterfaceCall(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn
            )
        },
        recordFeatureActivation: { (
            uniffiHandle: UInt64,
            event: RustBuffer,
            _: UnsafeMutableRawPointer,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws in
                guard let uniffiObj = try? FfiConverterCallbackInterfaceMetricsHandler.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.recordFeatureActivation(
                    event: FfiConverterTypeFeatureExposureExtraDef.lift(event)
                )
            }

            let writeReturn = { () }
            uniffiTraitInterfaceCall(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn
            )
        },
        recordFeatureExposure: { (
            uniffiHandle: UInt64,
            event: RustBuffer,
            _: UnsafeMutableRawPointer,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws in
                guard let uniffiObj = try? FfiConverterCallbackInterfaceMetricsHandler.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.recordFeatureExposure(
                    event: FfiConverterTypeFeatureExposureExtraDef.lift(event)
                )
            }

            let writeReturn = { () }
            uniffiTraitInterfaceCall(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn
            )
        },
        recordMalformedFeatureConfig: { (
            uniffiHandle: UInt64,
            event: RustBuffer,
            _: UnsafeMutableRawPointer,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws in
                guard let uniffiObj = try? FfiConverterCallbackInterfaceMetricsHandler.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.recordMalformedFeatureConfig(
                    event: FfiConverterTypeMalformedFeatureConfigExtraDef.lift(event)
                )
            }

            let writeReturn = { () }
            uniffiTraitInterfaceCall(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn
            )
        },
        uniffiFree: { (uniffiHandle: UInt64) in
            let result = try? FfiConverterCallbackInterfaceMetricsHandler.handleMap.remove(handle: uniffiHandle)
            if result == nil {
                print("Uniffi callback interface MetricsHandler: handle missing in uniffiFree")
            }
        }
    )
}

private func uniffiCallbackInitMetricsHandler() {
    uniffi_nimbus_fn_init_callback_vtable_metricshandler(&UniffiCallbackInterfaceMetricsHandler.vtable)
}

// FfiConverter protocol for callback interfaces
private enum FfiConverterCallbackInterfaceMetricsHandler {
    fileprivate static var handleMap = UniffiHandleMap<MetricsHandler>()
}

extension FfiConverterCallbackInterfaceMetricsHandler: FfiConverter {
    typealias SwiftType = MetricsHandler
    typealias FfiType = UInt64

    public static func lift(_ handle: UInt64) throws -> SwiftType {
        try handleMap.get(handle: handle)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        let handle: UInt64 = try readInt(&buf)
        return try lift(handle)
    }

    public static func lower(_ v: SwiftType) -> UInt64 {
        return handleMap.insert(obj: v)
    }

    public static func write(_ v: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(v))
    }
}

private struct FfiConverterOptionInt64: FfiConverterRustBuffer {
    typealias SwiftType = Int64?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt64.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt64.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeRecordedContext: FfiConverterRustBuffer {
    typealias SwiftType = RecordedContext?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeRecordedContext.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeRecordedContext.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeRemoteSettingsConfig: FfiConverterRustBuffer {
    typealias SwiftType = RemoteSettingsConfig?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeRemoteSettingsConfig.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeRemoteSettingsConfig.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeJsonObject: FfiConverterRustBuffer {
    typealias SwiftType = JsonObject?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeJsonObject.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeJsonObject.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeAvailableExperiment: FfiConverterRustBuffer {
    typealias SwiftType = [AvailableExperiment]

    public static func write(_ value: [AvailableExperiment], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeAvailableExperiment.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [AvailableExperiment] {
        let len: Int32 = try readInt(&buf)
        var seq = [AvailableExperiment]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeAvailableExperiment.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeEnrolledExperiment: FfiConverterRustBuffer {
    typealias SwiftType = [EnrolledExperiment]

    public static func write(_ value: [EnrolledExperiment], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeEnrolledExperiment.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [EnrolledExperiment] {
        let len: Int32 = try readInt(&buf)
        var seq = [EnrolledExperiment]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeEnrolledExperiment.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeEnrollmentChangeEvent: FfiConverterRustBuffer {
    typealias SwiftType = [EnrollmentChangeEvent]

    public static func write(_ value: [EnrollmentChangeEvent], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeEnrollmentChangeEvent.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [EnrollmentChangeEvent] {
        let len: Int32 = try readInt(&buf)
        var seq = [EnrollmentChangeEvent]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeEnrollmentChangeEvent.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeEnrollmentStatusExtraDef: FfiConverterRustBuffer {
    typealias SwiftType = [EnrollmentStatusExtraDef]

    public static func write(_ value: [EnrollmentStatusExtraDef], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeEnrollmentStatusExtraDef.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [EnrollmentStatusExtraDef] {
        let len: Int32 = try readInt(&buf)
        var seq = [EnrollmentStatusExtraDef]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeEnrollmentStatusExtraDef.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeExperimentBranch: FfiConverterRustBuffer {
    typealias SwiftType = [ExperimentBranch]

    public static func write(_ value: [ExperimentBranch], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeExperimentBranch.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [ExperimentBranch] {
        let len: Int32 = try readInt(&buf)
        var seq = [ExperimentBranch]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeExperimentBranch.read(from: &buf))
        }
        return seq
    }
}

/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias JsonObject = String
public struct FfiConverterTypeJsonObject: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> JsonObject {
        return try FfiConverterString.read(from: &buf)
    }

    public static func write(_ value: JsonObject, into buf: inout [UInt8]) {
        return FfiConverterString.write(value, into: &buf)
    }

    public static func lift(_ value: RustBuffer) throws -> JsonObject {
        return try FfiConverterString.lift(value)
    }

    public static func lower(_ value: JsonObject) -> RustBuffer {
        return FfiConverterString.lower(value)
    }
}

public func FfiConverterTypeJsonObject_lift(_ value: RustBuffer) throws -> JsonObject {
    return try FfiConverterTypeJsonObject.lift(value)
}

public func FfiConverterTypeJsonObject_lower(_ value: JsonObject) -> RustBuffer {
    return FfiConverterTypeJsonObject.lower(value)
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_nimbus_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_advance_event_time() != 40755 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_apply_pending_experiments() != 21020 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_clear_events() != 38691 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_create_string_helper() != 33335 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_create_targeting_helper() != 15785 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_dump_state_to_log() != 43374 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_fetch_experiments() != 7325 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_active_experiments() != 63303 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_available_experiments() != 53590 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_experiment_branch() != 35089 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_experiment_branches() != 60563 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_feature_config_variables() != 7354 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_global_user_participation() != 53001 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_initialize() != 500 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_is_fetch_enabled() != 9890 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_opt_in_with_branch() != 54676 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_opt_out() != 19195 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_record_event() != 60856 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_record_feature_exposure() != 19276 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_record_malformed_feature_config() != 52482 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_record_past_event() != 4442 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_reset_enrollments() != 39284 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_reset_telemetry_identifiers() != 44528 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_set_experiments_locally() != 29563 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_set_fetch_enabled() != 64996 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_set_global_user_participation() != 42180 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusstringhelper_get_uuid() != 24293 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusstringhelper_string_format() != 12685 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbustargetinghelper_eval_jexl() != 42395 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_recordedcontext_record() != 5916 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_recordedcontext_to_json() != 530 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_constructor_nimbusclient_new() != 54745 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_metricshandler_record_enrollment_statuses() != 22229 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_metricshandler_record_feature_activation() != 6186 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_metricshandler_record_feature_exposure() != 14029 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_metricshandler_record_malformed_feature_config() != 29240 {
        return InitializationResult.apiChecksumMismatch
    }

    uniffiCallbackInitRecordedContext()
    uniffiCallbackInitMetricsHandler()
    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all
