// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len: 0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_places_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_places_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        lock()
        defer { self.unlock() }
        return try f()
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_UNEXPECTED_ERROR: Int8 = 2
private let CALL_CANCELLED: Int8 = 3

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_UNEXPECTED_ERROR:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    case CALL_CANCELLED:
        fatalError("Cancellation not supported yet")

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> Void
) {
    do {
        try writeReturn(makeCall())
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> Void,
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private class UniffiHandleMap<T> {
    private var map: [UInt64: T] = [:]
    private let lock = NSLock()
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

    func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        map.count
    }
}

// Public interface members begin here.

private struct FfiConverterUInt32: FfiConverterPrimitive {
    typealias FfiType = UInt32
    typealias SwiftType = UInt32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterInt32: FfiConverterPrimitive {
    typealias FfiType = Int32
    typealias SwiftType = Int32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int32, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterUInt64: FfiConverterPrimitive {
    typealias FfiType = UInt64
    typealias SwiftType = UInt64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterDouble: FfiConverterPrimitive {
    typealias FfiType = Double
    typealias SwiftType = Double

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Double {
        return try lift(readDouble(&buf))
    }

    public static func write(_ value: Double, into buf: inout [UInt8]) {
        writeDouble(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol PlacesApiProtocol: AnyObject {
    func bookmarksReset() throws

    func bookmarksSync(keyId: String, accessToken: String, syncKey: String, tokenserverUrl: Url) throws -> String

    func historySync(keyId: String, accessToken: String, syncKey: String, tokenserverUrl: Url) throws -> String

    func newConnection(connType: ConnectionType) throws -> PlacesConnection

    func registerWithSyncManager()

    func resetHistory() throws
}

open class PlacesApi:
    PlacesApiProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_places_fn_clone_placesapi(self.pointer, $0) }
    }

    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_places_fn_free_placesapi(pointer, $0) }
    }

    open func bookmarksReset() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesapi_bookmarks_reset(self.uniffiClonePointer(), $0)
    }
    }

    open func bookmarksSync(keyId: String, accessToken: String, syncKey: String, tokenserverUrl: Url) throws -> String {
        return try FfiConverterString.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesapi_bookmarks_sync(self.uniffiClonePointer(),
                                                             FfiConverterString.lower(keyId),
                                                             FfiConverterString.lower(accessToken),
                                                             FfiConverterString.lower(syncKey),
                                                             FfiConverterTypeUrl.lower(tokenserverUrl), $0)
        })
    }

    open func historySync(keyId: String, accessToken: String, syncKey: String, tokenserverUrl: Url) throws -> String {
        return try FfiConverterString.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesapi_history_sync(self.uniffiClonePointer(),
                                                           FfiConverterString.lower(keyId),
                                                           FfiConverterString.lower(accessToken),
                                                           FfiConverterString.lower(syncKey),
                                                           FfiConverterTypeUrl.lower(tokenserverUrl), $0)
        })
    }

    open func newConnection(connType: ConnectionType) throws -> PlacesConnection {
        return try FfiConverterTypePlacesConnection.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesapi_new_connection(self.uniffiClonePointer(),
                                                             FfiConverterTypeConnectionType.lower(connType), $0)
        })
    }

    open func registerWithSyncManager() { try! rustCall {
        uniffi_places_fn_method_placesapi_register_with_sync_manager(self.uniffiClonePointer(), $0)
    }
    }

    open func resetHistory() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesapi_reset_history(self.uniffiClonePointer(), $0)
    }
    }
}

public struct FfiConverterTypePlacesApi: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = PlacesApi

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> PlacesApi {
        return PlacesApi(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: PlacesApi) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PlacesApi {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: PlacesApi, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypePlacesApi_lift(_ pointer: UnsafeMutableRawPointer) throws -> PlacesApi {
    return try FfiConverterTypePlacesApi.lift(pointer)
}

public func FfiConverterTypePlacesApi_lower(_ value: PlacesApi) -> UnsafeMutableRawPointer {
    return FfiConverterTypePlacesApi.lower(value)
}

public protocol PlacesConnectionProtocol: AnyObject {
    func acceptResult(searchString: String, url: String) throws

    func applyObservation(visit: VisitObservation) throws

    func bookmarksCountBookmarksInTrees(folderGuids: [Guid]) throws -> UInt32

    func bookmarksDelete(id: Guid) throws -> Bool

    func bookmarksDeleteEverything() throws

    func bookmarksGetAllWithUrl(url: String) throws -> [BookmarkItem]

    func bookmarksGetByGuid(guid: Guid, getDirectChildren: Bool) throws -> BookmarkItem?

    func bookmarksGetRecent(limit: Int32) throws -> [BookmarkItem]

    func bookmarksGetTree(itemGuid: Guid) throws -> BookmarkItem?

    func bookmarksGetUrlForKeyword(keyword: String) throws -> Url?

    func bookmarksInsert(bookmark: InsertableBookmarkItem) throws -> Guid

    func bookmarksSearch(query: String, limit: Int32) throws -> [BookmarkItem]

    func bookmarksUpdate(data: BookmarkUpdateInfo) throws

    func deleteEverythingHistory() throws

    func deleteVisit(url: String, timestamp: PlacesTimestamp) throws

    func deleteVisitsBetween(start: PlacesTimestamp, end: PlacesTimestamp) throws

    func deleteVisitsFor(url: String) throws

    func getHistoryHighlights(weights: HistoryHighlightWeights, limit: Int32) throws -> [HistoryHighlight]

    func getHistoryMetadataBetween(start: PlacesTimestamp, end: PlacesTimestamp) throws -> [HistoryMetadata]

    func getHistoryMetadataSince(since: PlacesTimestamp) throws -> [HistoryMetadata]

    func getLatestHistoryMetadataForUrl(url: Url) throws -> HistoryMetadata?

    func getTopFrecentSiteInfos(numItems: Int32, thresholdOption: FrecencyThresholdOption) throws -> [TopFrecentSiteInfo]

    func getVisitCount(excludeTypes: VisitTransitionSet) throws -> Int64

    func getVisitInfos(startDate: PlacesTimestamp, endDate: PlacesTimestamp, excludeTypes: VisitTransitionSet) throws -> [HistoryVisitInfo]

    func getVisitPage(offset: Int64, count: Int64, excludeTypes: VisitTransitionSet) throws -> [HistoryVisitInfo]

    func getVisitPageWithBound(bound: Int64, offset: Int64, count: Int64, excludeTypes: VisitTransitionSet) throws -> HistoryVisitInfosWithBound

    func getVisited(urls: [String]) throws -> [Bool]

    func getVisitedUrlsInRange(start: PlacesTimestamp, end: PlacesTimestamp, includeRemote: Bool) throws -> [Url]

    func matchUrl(query: String) throws -> Url?

    func metadataDelete(url: Url, referrerUrl: Url?, searchTerm: String?) throws

    func metadataDeleteOlderThan(olderThan: PlacesTimestamp) throws

    func newInterruptHandle() -> SqlInterruptHandle

    func noteHistoryMetadataObservation(data: HistoryMetadataObservation) throws

    func placesHistoryImportFromIos(dbPath: String, lastSyncTimestamp: Int64) throws -> HistoryMigrationResult

    func queryAutocomplete(search: String, limit: Int32) throws -> [SearchResult]

    func queryHistoryMetadata(query: String, limit: Int32) throws -> [HistoryMetadata]

    /**
     * Run maintenance on the places DB (checkpoint step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    func runMaintenanceCheckpoint() throws

    /**
     * Run maintenance on the places DB (optimize step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    func runMaintenanceOptimize() throws

    /**
     * Run maintenance on the places DB (prune step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     *
     * db_size_limit is the approximate storage limit in bytes.  If the database is using more space
     * than this, some older visits will be deleted to free up space.  Pass in a 0 to skip this.
     *
     * prune_limit is the maximum number of visits to prune if the database is over db_size_limit
     */
    func runMaintenancePrune(dbSizeLimit: UInt32, pruneLimit: UInt32) throws -> RunMaintenanceMetrics

    /**
     * Run maintenance on the places DB (vacuum step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    func runMaintenanceVacuum() throws
}

open class PlacesConnection:
    PlacesConnectionProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_places_fn_clone_placesconnection(self.pointer, $0) }
    }

    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_places_fn_free_placesconnection(pointer, $0) }
    }

    open func acceptResult(searchString: String, url: String) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_accept_result(self.uniffiClonePointer(),
                                                               FfiConverterString.lower(searchString),
                                                               FfiConverterString.lower(url), $0)
    }
    }

    open func applyObservation(visit: VisitObservation) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_apply_observation(self.uniffiClonePointer(),
                                                                   FfiConverterTypeVisitObservation.lower(visit), $0)
    }
    }

    open func bookmarksCountBookmarksInTrees(folderGuids: [Guid]) throws -> UInt32 {
        return try FfiConverterUInt32.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_count_bookmarks_in_trees(self.uniffiClonePointer(),
                                                                                        FfiConverterSequenceTypeGuid.lower(folderGuids), $0)
        })
    }

    open func bookmarksDelete(id: Guid) throws -> Bool {
        return try FfiConverterBool.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_delete(self.uniffiClonePointer(),
                                                                      FfiConverterTypeGuid.lower(id), $0)
        })
    }

    open func bookmarksDeleteEverything() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_bookmarks_delete_everything(self.uniffiClonePointer(), $0)
    }
    }

    open func bookmarksGetAllWithUrl(url: String) throws -> [BookmarkItem] {
        return try FfiConverterSequenceTypeBookmarkItem.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_get_all_with_url(self.uniffiClonePointer(),
                                                                                FfiConverterString.lower(url), $0)
        })
    }

    open func bookmarksGetByGuid(guid: Guid, getDirectChildren: Bool) throws -> BookmarkItem? {
        return try FfiConverterOptionTypeBookmarkItem.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_get_by_guid(self.uniffiClonePointer(),
                                                                           FfiConverterTypeGuid.lower(guid),
                                                                           FfiConverterBool.lower(getDirectChildren), $0)
        })
    }

    open func bookmarksGetRecent(limit: Int32) throws -> [BookmarkItem] {
        return try FfiConverterSequenceTypeBookmarkItem.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_get_recent(self.uniffiClonePointer(),
                                                                          FfiConverterInt32.lower(limit), $0)
        })
    }

    open func bookmarksGetTree(itemGuid: Guid) throws -> BookmarkItem? {
        return try FfiConverterOptionTypeBookmarkItem.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_get_tree(self.uniffiClonePointer(),
                                                                        FfiConverterTypeGuid.lower(itemGuid), $0)
        })
    }

    open func bookmarksGetUrlForKeyword(keyword: String) throws -> Url? {
        return try FfiConverterOptionTypeUrl.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_get_url_for_keyword(self.uniffiClonePointer(),
                                                                                   FfiConverterString.lower(keyword), $0)
        })
    }

    open func bookmarksInsert(bookmark: InsertableBookmarkItem) throws -> Guid {
        return try FfiConverterTypeGuid.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_insert(self.uniffiClonePointer(),
                                                                      FfiConverterTypeInsertableBookmarkItem.lower(bookmark), $0)
        })
    }

    open func bookmarksSearch(query: String, limit: Int32) throws -> [BookmarkItem] {
        return try FfiConverterSequenceTypeBookmarkItem.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_bookmarks_search(self.uniffiClonePointer(),
                                                                      FfiConverterString.lower(query),
                                                                      FfiConverterInt32.lower(limit), $0)
        })
    }

    open func bookmarksUpdate(data: BookmarkUpdateInfo) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_bookmarks_update(self.uniffiClonePointer(),
                                                                  FfiConverterTypeBookmarkUpdateInfo.lower(data), $0)
    }
    }

    open func deleteEverythingHistory() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_delete_everything_history(self.uniffiClonePointer(), $0)
    }
    }

    open func deleteVisit(url: String, timestamp: PlacesTimestamp) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_delete_visit(self.uniffiClonePointer(),
                                                              FfiConverterString.lower(url),
                                                              FfiConverterTypePlacesTimestamp.lower(timestamp), $0)
    }
    }

    open func deleteVisitsBetween(start: PlacesTimestamp, end: PlacesTimestamp) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_delete_visits_between(self.uniffiClonePointer(),
                                                                       FfiConverterTypePlacesTimestamp.lower(start),
                                                                       FfiConverterTypePlacesTimestamp.lower(end), $0)
    }
    }

    open func deleteVisitsFor(url: String) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_delete_visits_for(self.uniffiClonePointer(),
                                                                   FfiConverterString.lower(url), $0)
    }
    }

    open func getHistoryHighlights(weights: HistoryHighlightWeights, limit: Int32) throws -> [HistoryHighlight] {
        return try FfiConverterSequenceTypeHistoryHighlight.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_history_highlights(self.uniffiClonePointer(),
                                                                            FfiConverterTypeHistoryHighlightWeights.lower(weights),
                                                                            FfiConverterInt32.lower(limit), $0)
        })
    }

    open func getHistoryMetadataBetween(start: PlacesTimestamp, end: PlacesTimestamp) throws -> [HistoryMetadata] {
        return try FfiConverterSequenceTypeHistoryMetadata.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_history_metadata_between(self.uniffiClonePointer(),
                                                                                  FfiConverterTypePlacesTimestamp.lower(start),
                                                                                  FfiConverterTypePlacesTimestamp.lower(end), $0)
        })
    }

    open func getHistoryMetadataSince(since: PlacesTimestamp) throws -> [HistoryMetadata] {
        return try FfiConverterSequenceTypeHistoryMetadata.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_history_metadata_since(self.uniffiClonePointer(),
                                                                                FfiConverterTypePlacesTimestamp.lower(since), $0)
        })
    }

    open func getLatestHistoryMetadataForUrl(url: Url) throws -> HistoryMetadata? {
        return try FfiConverterOptionTypeHistoryMetadata.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_latest_history_metadata_for_url(self.uniffiClonePointer(),
                                                                                         FfiConverterTypeUrl.lower(url), $0)
        })
    }

    open func getTopFrecentSiteInfos(numItems: Int32, thresholdOption: FrecencyThresholdOption) throws -> [TopFrecentSiteInfo] {
        return try FfiConverterSequenceTypeTopFrecentSiteInfo.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_top_frecent_site_infos(self.uniffiClonePointer(),
                                                                                FfiConverterInt32.lower(numItems),
                                                                                FfiConverterTypeFrecencyThresholdOption.lower(thresholdOption), $0)
        })
    }

    open func getVisitCount(excludeTypes: VisitTransitionSet) throws -> Int64 {
        return try FfiConverterInt64.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_visit_count(self.uniffiClonePointer(),
                                                                     FfiConverterTypeVisitTransitionSet.lower(excludeTypes), $0)
        })
    }

    open func getVisitInfos(startDate: PlacesTimestamp, endDate: PlacesTimestamp, excludeTypes: VisitTransitionSet) throws -> [HistoryVisitInfo] {
        return try FfiConverterSequenceTypeHistoryVisitInfo.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_visit_infos(self.uniffiClonePointer(),
                                                                     FfiConverterTypePlacesTimestamp.lower(startDate),
                                                                     FfiConverterTypePlacesTimestamp.lower(endDate),
                                                                     FfiConverterTypeVisitTransitionSet.lower(excludeTypes), $0)
        })
    }

    open func getVisitPage(offset: Int64, count: Int64, excludeTypes: VisitTransitionSet) throws -> [HistoryVisitInfo] {
        return try FfiConverterSequenceTypeHistoryVisitInfo.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_visit_page(self.uniffiClonePointer(),
                                                                    FfiConverterInt64.lower(offset),
                                                                    FfiConverterInt64.lower(count),
                                                                    FfiConverterTypeVisitTransitionSet.lower(excludeTypes), $0)
        })
    }

    open func getVisitPageWithBound(bound: Int64, offset: Int64, count: Int64, excludeTypes: VisitTransitionSet) throws -> HistoryVisitInfosWithBound {
        return try FfiConverterTypeHistoryVisitInfosWithBound.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_visit_page_with_bound(self.uniffiClonePointer(),
                                                                               FfiConverterInt64.lower(bound),
                                                                               FfiConverterInt64.lower(offset),
                                                                               FfiConverterInt64.lower(count),
                                                                               FfiConverterTypeVisitTransitionSet.lower(excludeTypes), $0)
        })
    }

    open func getVisited(urls: [String]) throws -> [Bool] {
        return try FfiConverterSequenceBool.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_visited(self.uniffiClonePointer(),
                                                                 FfiConverterSequenceString.lower(urls), $0)
        })
    }

    open func getVisitedUrlsInRange(start: PlacesTimestamp, end: PlacesTimestamp, includeRemote: Bool) throws -> [Url] {
        return try FfiConverterSequenceTypeUrl.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_get_visited_urls_in_range(self.uniffiClonePointer(),
                                                                               FfiConverterTypePlacesTimestamp.lower(start),
                                                                               FfiConverterTypePlacesTimestamp.lower(end),
                                                                               FfiConverterBool.lower(includeRemote), $0)
        })
    }

    open func matchUrl(query: String) throws -> Url? {
        return try FfiConverterOptionTypeUrl.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_match_url(self.uniffiClonePointer(),
                                                               FfiConverterString.lower(query), $0)
        })
    }

    open func metadataDelete(url: Url, referrerUrl: Url?, searchTerm: String?) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_metadata_delete(self.uniffiClonePointer(),
                                                                 FfiConverterTypeUrl.lower(url),
                                                                 FfiConverterOptionTypeUrl.lower(referrerUrl),
                                                                 FfiConverterOptionString.lower(searchTerm), $0)
    }
    }

    open func metadataDeleteOlderThan(olderThan: PlacesTimestamp) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_metadata_delete_older_than(self.uniffiClonePointer(),
                                                                            FfiConverterTypePlacesTimestamp.lower(olderThan), $0)
    }
    }

    open func newInterruptHandle() -> SqlInterruptHandle {
        return try! FfiConverterTypeSqlInterruptHandle.lift(try! rustCall {
            uniffi_places_fn_method_placesconnection_new_interrupt_handle(self.uniffiClonePointer(), $0)
        })
    }

    open func noteHistoryMetadataObservation(data: HistoryMetadataObservation) throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_note_history_metadata_observation(self.uniffiClonePointer(),
                                                                                   FfiConverterTypeHistoryMetadataObservation.lower(data), $0)
    }
    }

    open func placesHistoryImportFromIos(dbPath: String, lastSyncTimestamp: Int64) throws -> HistoryMigrationResult {
        return try FfiConverterTypeHistoryMigrationResult.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_places_history_import_from_ios(self.uniffiClonePointer(),
                                                                                    FfiConverterString.lower(dbPath),
                                                                                    FfiConverterInt64.lower(lastSyncTimestamp), $0)
        })
    }

    open func queryAutocomplete(search: String, limit: Int32) throws -> [SearchResult] {
        return try FfiConverterSequenceTypeSearchResult.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_query_autocomplete(self.uniffiClonePointer(),
                                                                        FfiConverterString.lower(search),
                                                                        FfiConverterInt32.lower(limit), $0)
        })
    }

    open func queryHistoryMetadata(query: String, limit: Int32) throws -> [HistoryMetadata] {
        return try FfiConverterSequenceTypeHistoryMetadata.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_query_history_metadata(self.uniffiClonePointer(),
                                                                            FfiConverterString.lower(query),
                                                                            FfiConverterInt32.lower(limit), $0)
        })
    }

    /**
     * Run maintenance on the places DB (checkpoint step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    open func runMaintenanceCheckpoint() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_run_maintenance_checkpoint(self.uniffiClonePointer(), $0)
    }
    }

    /**
     * Run maintenance on the places DB (optimize step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    open func runMaintenanceOptimize() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_run_maintenance_optimize(self.uniffiClonePointer(), $0)
    }
    }

    /**
     * Run maintenance on the places DB (prune step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     *
     * db_size_limit is the approximate storage limit in bytes.  If the database is using more space
     * than this, some older visits will be deleted to free up space.  Pass in a 0 to skip this.
     *
     * prune_limit is the maximum number of visits to prune if the database is over db_size_limit
     */
    open func runMaintenancePrune(dbSizeLimit: UInt32, pruneLimit: UInt32) throws -> RunMaintenanceMetrics {
        return try FfiConverterTypeRunMaintenanceMetrics.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
            uniffi_places_fn_method_placesconnection_run_maintenance_prune(self.uniffiClonePointer(),
                                                                           FfiConverterUInt32.lower(dbSizeLimit),
                                                                           FfiConverterUInt32.lower(pruneLimit), $0)
        })
    }

    /**
     * Run maintenance on the places DB (vacuum step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    open func runMaintenanceVacuum() throws { try rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_method_placesconnection_run_maintenance_vacuum(self.uniffiClonePointer(), $0)
    }
    }
}

public struct FfiConverterTypePlacesConnection: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = PlacesConnection

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> PlacesConnection {
        return PlacesConnection(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: PlacesConnection) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PlacesConnection {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: PlacesConnection, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypePlacesConnection_lift(_ pointer: UnsafeMutableRawPointer) throws -> PlacesConnection {
    return try FfiConverterTypePlacesConnection.lift(pointer)
}

public func FfiConverterTypePlacesConnection_lower(_ value: PlacesConnection) -> UnsafeMutableRawPointer {
    return FfiConverterTypePlacesConnection.lower(value)
}

public protocol SqlInterruptHandleProtocol: AnyObject {
    func interrupt()
}

open class SqlInterruptHandle:
    SqlInterruptHandleProtocol
{
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    public required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    /// This constructor can be used to instantiate a fake object.
    /// - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    ///
    /// - Warning:
    ///     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
    public init(noPointer _: NoPointer) {
        pointer = nil
    }

    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_places_fn_clone_sqlinterrupthandle(self.pointer, $0) }
    }

    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_places_fn_free_sqlinterrupthandle(pointer, $0) }
    }

    open func interrupt() { try! rustCall {
        uniffi_places_fn_method_sqlinterrupthandle_interrupt(self.uniffiClonePointer(), $0)
    }
    }
}

public struct FfiConverterTypeSqlInterruptHandle: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = SqlInterruptHandle

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> SqlInterruptHandle {
        return SqlInterruptHandle(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: SqlInterruptHandle) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SqlInterruptHandle {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: SqlInterruptHandle, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}

public func FfiConverterTypeSqlInterruptHandle_lift(_ pointer: UnsafeMutableRawPointer) throws -> SqlInterruptHandle {
    return try FfiConverterTypeSqlInterruptHandle.lift(pointer)
}

public func FfiConverterTypeSqlInterruptHandle_lower(_ value: SqlInterruptHandle) -> UnsafeMutableRawPointer {
    return FfiConverterTypeSqlInterruptHandle.lower(value)
}

public struct BookmarkData {
    public var guid: Guid
    public var parentGuid: Guid
    public var position: UInt32
    public var dateAdded: PlacesTimestamp
    public var lastModified: PlacesTimestamp
    public var url: Url
    public var title: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid, parentGuid: Guid, position: UInt32, dateAdded: PlacesTimestamp, lastModified: PlacesTimestamp, url: Url, title: String?) {
        self.guid = guid
        self.parentGuid = parentGuid
        self.position = position
        self.dateAdded = dateAdded
        self.lastModified = lastModified
        self.url = url
        self.title = title
    }
}

extension BookmarkData: Equatable, Hashable {
    public static func == (lhs: BookmarkData, rhs: BookmarkData) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        if lhs.dateAdded != rhs.dateAdded {
            return false
        }
        if lhs.lastModified != rhs.lastModified {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(parentGuid)
        hasher.combine(position)
        hasher.combine(dateAdded)
        hasher.combine(lastModified)
        hasher.combine(url)
        hasher.combine(title)
    }
}

public struct FfiConverterTypeBookmarkData: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BookmarkData {
        return
            try BookmarkData(
                guid: FfiConverterTypeGuid.read(from: &buf),
                parentGuid: FfiConverterTypeGuid.read(from: &buf),
                position: FfiConverterUInt32.read(from: &buf),
                dateAdded: FfiConverterTypePlacesTimestamp.read(from: &buf),
                lastModified: FfiConverterTypePlacesTimestamp.read(from: &buf),
                url: FfiConverterTypeUrl.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: BookmarkData, into buf: inout [UInt8]) {
        FfiConverterTypeGuid.write(value.guid, into: &buf)
        FfiConverterTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterUInt32.write(value.position, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.dateAdded, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.lastModified, into: &buf)
        FfiConverterTypeUrl.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
    }
}

public func FfiConverterTypeBookmarkData_lift(_ buf: RustBuffer) throws -> BookmarkData {
    return try FfiConverterTypeBookmarkData.lift(buf)
}

public func FfiConverterTypeBookmarkData_lower(_ value: BookmarkData) -> RustBuffer {
    return FfiConverterTypeBookmarkData.lower(value)
}

public struct BookmarkFolder {
    public var guid: Guid
    public var dateAdded: PlacesTimestamp
    public var lastModified: PlacesTimestamp
    public var parentGuid: Guid?
    public var position: UInt32
    public var title: String?
    public var childGuids: [Guid]?
    public var childNodes: [BookmarkItem]?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid, dateAdded: PlacesTimestamp, lastModified: PlacesTimestamp, parentGuid: Guid?, position: UInt32, title: String?, childGuids: [Guid]?, childNodes: [BookmarkItem]?) {
        self.guid = guid
        self.dateAdded = dateAdded
        self.lastModified = lastModified
        self.parentGuid = parentGuid
        self.position = position
        self.title = title
        self.childGuids = childGuids
        self.childNodes = childNodes
    }
}

extension BookmarkFolder: Equatable, Hashable {
    public static func == (lhs: BookmarkFolder, rhs: BookmarkFolder) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.dateAdded != rhs.dateAdded {
            return false
        }
        if lhs.lastModified != rhs.lastModified {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.childGuids != rhs.childGuids {
            return false
        }
        if lhs.childNodes != rhs.childNodes {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(dateAdded)
        hasher.combine(lastModified)
        hasher.combine(parentGuid)
        hasher.combine(position)
        hasher.combine(title)
        hasher.combine(childGuids)
        hasher.combine(childNodes)
    }
}

public struct FfiConverterTypeBookmarkFolder: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BookmarkFolder {
        return
            try BookmarkFolder(
                guid: FfiConverterTypeGuid.read(from: &buf),
                dateAdded: FfiConverterTypePlacesTimestamp.read(from: &buf),
                lastModified: FfiConverterTypePlacesTimestamp.read(from: &buf),
                parentGuid: FfiConverterOptionTypeGuid.read(from: &buf),
                position: FfiConverterUInt32.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                childGuids: FfiConverterOptionSequenceTypeGuid.read(from: &buf),
                childNodes: FfiConverterOptionSequenceTypeBookmarkItem.read(from: &buf)
            )
    }

    public static func write(_ value: BookmarkFolder, into buf: inout [UInt8]) {
        FfiConverterTypeGuid.write(value.guid, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.dateAdded, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.lastModified, into: &buf)
        FfiConverterOptionTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterUInt32.write(value.position, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterOptionSequenceTypeGuid.write(value.childGuids, into: &buf)
        FfiConverterOptionSequenceTypeBookmarkItem.write(value.childNodes, into: &buf)
    }
}

public func FfiConverterTypeBookmarkFolder_lift(_ buf: RustBuffer) throws -> BookmarkFolder {
    return try FfiConverterTypeBookmarkFolder.lift(buf)
}

public func FfiConverterTypeBookmarkFolder_lower(_ value: BookmarkFolder) -> RustBuffer {
    return FfiConverterTypeBookmarkFolder.lower(value)
}

public struct BookmarkSeparator {
    public var guid: Guid
    public var dateAdded: PlacesTimestamp
    public var lastModified: PlacesTimestamp
    public var parentGuid: Guid
    public var position: UInt32

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid, dateAdded: PlacesTimestamp, lastModified: PlacesTimestamp, parentGuid: Guid, position: UInt32) {
        self.guid = guid
        self.dateAdded = dateAdded
        self.lastModified = lastModified
        self.parentGuid = parentGuid
        self.position = position
    }
}

extension BookmarkSeparator: Equatable, Hashable {
    public static func == (lhs: BookmarkSeparator, rhs: BookmarkSeparator) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.dateAdded != rhs.dateAdded {
            return false
        }
        if lhs.lastModified != rhs.lastModified {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(dateAdded)
        hasher.combine(lastModified)
        hasher.combine(parentGuid)
        hasher.combine(position)
    }
}

public struct FfiConverterTypeBookmarkSeparator: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BookmarkSeparator {
        return
            try BookmarkSeparator(
                guid: FfiConverterTypeGuid.read(from: &buf),
                dateAdded: FfiConverterTypePlacesTimestamp.read(from: &buf),
                lastModified: FfiConverterTypePlacesTimestamp.read(from: &buf),
                parentGuid: FfiConverterTypeGuid.read(from: &buf),
                position: FfiConverterUInt32.read(from: &buf)
            )
    }

    public static func write(_ value: BookmarkSeparator, into buf: inout [UInt8]) {
        FfiConverterTypeGuid.write(value.guid, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.dateAdded, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.lastModified, into: &buf)
        FfiConverterTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterUInt32.write(value.position, into: &buf)
    }
}

public func FfiConverterTypeBookmarkSeparator_lift(_ buf: RustBuffer) throws -> BookmarkSeparator {
    return try FfiConverterTypeBookmarkSeparator.lift(buf)
}

public func FfiConverterTypeBookmarkSeparator_lower(_ value: BookmarkSeparator) -> RustBuffer {
    return FfiConverterTypeBookmarkSeparator.lower(value)
}

public struct BookmarkUpdateInfo {
    public var guid: Guid
    public var title: String?
    public var url: String?
    public var parentGuid: Guid?
    public var position: UInt32?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid, title: String?, url: String?, parentGuid: Guid?, position: UInt32?) {
        self.guid = guid
        self.title = title
        self.url = url
        self.parentGuid = parentGuid
        self.position = position
    }
}

extension BookmarkUpdateInfo: Equatable, Hashable {
    public static func == (lhs: BookmarkUpdateInfo, rhs: BookmarkUpdateInfo) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(title)
        hasher.combine(url)
        hasher.combine(parentGuid)
        hasher.combine(position)
    }
}

public struct FfiConverterTypeBookmarkUpdateInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BookmarkUpdateInfo {
        return
            try BookmarkUpdateInfo(
                guid: FfiConverterTypeGuid.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                url: FfiConverterOptionString.read(from: &buf),
                parentGuid: FfiConverterOptionTypeGuid.read(from: &buf),
                position: FfiConverterOptionUInt32.read(from: &buf)
            )
    }

    public static func write(_ value: BookmarkUpdateInfo, into buf: inout [UInt8]) {
        FfiConverterTypeGuid.write(value.guid, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterOptionString.write(value.url, into: &buf)
        FfiConverterOptionTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterOptionUInt32.write(value.position, into: &buf)
    }
}

public func FfiConverterTypeBookmarkUpdateInfo_lift(_ buf: RustBuffer) throws -> BookmarkUpdateInfo {
    return try FfiConverterTypeBookmarkUpdateInfo.lift(buf)
}

public func FfiConverterTypeBookmarkUpdateInfo_lower(_ value: BookmarkUpdateInfo) -> RustBuffer {
    return FfiConverterTypeBookmarkUpdateInfo.lower(value)
}

public struct Dummy {
    public var md: [HistoryMetadata]?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(md: [HistoryMetadata]?) {
        self.md = md
    }
}

extension Dummy: Equatable, Hashable {
    public static func == (lhs: Dummy, rhs: Dummy) -> Bool {
        if lhs.md != rhs.md {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(md)
    }
}

public struct FfiConverterTypeDummy: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Dummy {
        return
            try Dummy(
                md: FfiConverterOptionSequenceTypeHistoryMetadata.read(from: &buf)
            )
    }

    public static func write(_ value: Dummy, into buf: inout [UInt8]) {
        FfiConverterOptionSequenceTypeHistoryMetadata.write(value.md, into: &buf)
    }
}

public func FfiConverterTypeDummy_lift(_ buf: RustBuffer) throws -> Dummy {
    return try FfiConverterTypeDummy.lift(buf)
}

public func FfiConverterTypeDummy_lower(_ value: Dummy) -> RustBuffer {
    return FfiConverterTypeDummy.lower(value)
}

public struct HistoryHighlight {
    public var score: Double
    public var placeId: Int32
    public var url: String
    public var title: String?
    public var previewImageUrl: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(score: Double, placeId: Int32, url: String, title: String?, previewImageUrl: String?) {
        self.score = score
        self.placeId = placeId
        self.url = url
        self.title = title
        self.previewImageUrl = previewImageUrl
    }
}

extension HistoryHighlight: Equatable, Hashable {
    public static func == (lhs: HistoryHighlight, rhs: HistoryHighlight) -> Bool {
        if lhs.score != rhs.score {
            return false
        }
        if lhs.placeId != rhs.placeId {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.previewImageUrl != rhs.previewImageUrl {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(score)
        hasher.combine(placeId)
        hasher.combine(url)
        hasher.combine(title)
        hasher.combine(previewImageUrl)
    }
}

public struct FfiConverterTypeHistoryHighlight: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryHighlight {
        return
            try HistoryHighlight(
                score: FfiConverterDouble.read(from: &buf),
                placeId: FfiConverterInt32.read(from: &buf),
                url: FfiConverterString.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                previewImageUrl: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryHighlight, into buf: inout [UInt8]) {
        FfiConverterDouble.write(value.score, into: &buf)
        FfiConverterInt32.write(value.placeId, into: &buf)
        FfiConverterString.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterOptionString.write(value.previewImageUrl, into: &buf)
    }
}

public func FfiConverterTypeHistoryHighlight_lift(_ buf: RustBuffer) throws -> HistoryHighlight {
    return try FfiConverterTypeHistoryHighlight.lift(buf)
}

public func FfiConverterTypeHistoryHighlight_lower(_ value: HistoryHighlight) -> RustBuffer {
    return FfiConverterTypeHistoryHighlight.lower(value)
}

public struct HistoryHighlightWeights {
    public var viewTime: Double
    public var frequency: Double

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(viewTime: Double, frequency: Double) {
        self.viewTime = viewTime
        self.frequency = frequency
    }
}

extension HistoryHighlightWeights: Equatable, Hashable {
    public static func == (lhs: HistoryHighlightWeights, rhs: HistoryHighlightWeights) -> Bool {
        if lhs.viewTime != rhs.viewTime {
            return false
        }
        if lhs.frequency != rhs.frequency {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(viewTime)
        hasher.combine(frequency)
    }
}

public struct FfiConverterTypeHistoryHighlightWeights: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryHighlightWeights {
        return
            try HistoryHighlightWeights(
                viewTime: FfiConverterDouble.read(from: &buf),
                frequency: FfiConverterDouble.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryHighlightWeights, into buf: inout [UInt8]) {
        FfiConverterDouble.write(value.viewTime, into: &buf)
        FfiConverterDouble.write(value.frequency, into: &buf)
    }
}

public func FfiConverterTypeHistoryHighlightWeights_lift(_ buf: RustBuffer) throws -> HistoryHighlightWeights {
    return try FfiConverterTypeHistoryHighlightWeights.lift(buf)
}

public func FfiConverterTypeHistoryHighlightWeights_lower(_ value: HistoryHighlightWeights) -> RustBuffer {
    return FfiConverterTypeHistoryHighlightWeights.lower(value)
}

public struct HistoryMetadata {
    public var url: String
    public var title: String?
    public var previewImageUrl: String?
    public var createdAt: Int64
    public var updatedAt: Int64
    public var totalViewTime: Int32
    public var searchTerm: String?
    public var documentType: DocumentType
    public var referrerUrl: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(url: String, title: String?, previewImageUrl: String?, createdAt: Int64, updatedAt: Int64, totalViewTime: Int32, searchTerm: String?, documentType: DocumentType, referrerUrl: String?) {
        self.url = url
        self.title = title
        self.previewImageUrl = previewImageUrl
        self.createdAt = createdAt
        self.updatedAt = updatedAt
        self.totalViewTime = totalViewTime
        self.searchTerm = searchTerm
        self.documentType = documentType
        self.referrerUrl = referrerUrl
    }
}

extension HistoryMetadata: Equatable, Hashable {
    public static func == (lhs: HistoryMetadata, rhs: HistoryMetadata) -> Bool {
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.previewImageUrl != rhs.previewImageUrl {
            return false
        }
        if lhs.createdAt != rhs.createdAt {
            return false
        }
        if lhs.updatedAt != rhs.updatedAt {
            return false
        }
        if lhs.totalViewTime != rhs.totalViewTime {
            return false
        }
        if lhs.searchTerm != rhs.searchTerm {
            return false
        }
        if lhs.documentType != rhs.documentType {
            return false
        }
        if lhs.referrerUrl != rhs.referrerUrl {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(url)
        hasher.combine(title)
        hasher.combine(previewImageUrl)
        hasher.combine(createdAt)
        hasher.combine(updatedAt)
        hasher.combine(totalViewTime)
        hasher.combine(searchTerm)
        hasher.combine(documentType)
        hasher.combine(referrerUrl)
    }
}

public struct FfiConverterTypeHistoryMetadata: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryMetadata {
        return
            try HistoryMetadata(
                url: FfiConverterString.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                previewImageUrl: FfiConverterOptionString.read(from: &buf),
                createdAt: FfiConverterInt64.read(from: &buf),
                updatedAt: FfiConverterInt64.read(from: &buf),
                totalViewTime: FfiConverterInt32.read(from: &buf),
                searchTerm: FfiConverterOptionString.read(from: &buf),
                documentType: FfiConverterTypeDocumentType.read(from: &buf),
                referrerUrl: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryMetadata, into buf: inout [UInt8]) {
        FfiConverterString.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterOptionString.write(value.previewImageUrl, into: &buf)
        FfiConverterInt64.write(value.createdAt, into: &buf)
        FfiConverterInt64.write(value.updatedAt, into: &buf)
        FfiConverterInt32.write(value.totalViewTime, into: &buf)
        FfiConverterOptionString.write(value.searchTerm, into: &buf)
        FfiConverterTypeDocumentType.write(value.documentType, into: &buf)
        FfiConverterOptionString.write(value.referrerUrl, into: &buf)
    }
}

public func FfiConverterTypeHistoryMetadata_lift(_ buf: RustBuffer) throws -> HistoryMetadata {
    return try FfiConverterTypeHistoryMetadata.lift(buf)
}

public func FfiConverterTypeHistoryMetadata_lower(_ value: HistoryMetadata) -> RustBuffer {
    return FfiConverterTypeHistoryMetadata.lower(value)
}

public struct HistoryMetadataObservation {
    public var url: String
    public var referrerUrl: String?
    public var searchTerm: String?
    public var viewTime: Int32?
    public var documentType: DocumentType?
    public var title: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(url: String, referrerUrl: String? = nil, searchTerm: String? = nil, viewTime: Int32? = nil, documentType: DocumentType? = nil, title: String? = nil) {
        self.url = url
        self.referrerUrl = referrerUrl
        self.searchTerm = searchTerm
        self.viewTime = viewTime
        self.documentType = documentType
        self.title = title
    }
}

extension HistoryMetadataObservation: Equatable, Hashable {
    public static func == (lhs: HistoryMetadataObservation, rhs: HistoryMetadataObservation) -> Bool {
        if lhs.url != rhs.url {
            return false
        }
        if lhs.referrerUrl != rhs.referrerUrl {
            return false
        }
        if lhs.searchTerm != rhs.searchTerm {
            return false
        }
        if lhs.viewTime != rhs.viewTime {
            return false
        }
        if lhs.documentType != rhs.documentType {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(url)
        hasher.combine(referrerUrl)
        hasher.combine(searchTerm)
        hasher.combine(viewTime)
        hasher.combine(documentType)
        hasher.combine(title)
    }
}

public struct FfiConverterTypeHistoryMetadataObservation: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryMetadataObservation {
        return
            try HistoryMetadataObservation(
                url: FfiConverterString.read(from: &buf),
                referrerUrl: FfiConverterOptionString.read(from: &buf),
                searchTerm: FfiConverterOptionString.read(from: &buf),
                viewTime: FfiConverterOptionInt32.read(from: &buf),
                documentType: FfiConverterOptionTypeDocumentType.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryMetadataObservation, into buf: inout [UInt8]) {
        FfiConverterString.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.referrerUrl, into: &buf)
        FfiConverterOptionString.write(value.searchTerm, into: &buf)
        FfiConverterOptionInt32.write(value.viewTime, into: &buf)
        FfiConverterOptionTypeDocumentType.write(value.documentType, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
    }
}

public func FfiConverterTypeHistoryMetadataObservation_lift(_ buf: RustBuffer) throws -> HistoryMetadataObservation {
    return try FfiConverterTypeHistoryMetadataObservation.lift(buf)
}

public func FfiConverterTypeHistoryMetadataObservation_lower(_ value: HistoryMetadataObservation) -> RustBuffer {
    return FfiConverterTypeHistoryMetadataObservation.lower(value)
}

public struct HistoryMigrationResult {
    public var numTotal: UInt32
    public var numSucceeded: UInt32
    public var numFailed: UInt32
    public var totalDuration: UInt64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(numTotal: UInt32, numSucceeded: UInt32, numFailed: UInt32, totalDuration: UInt64) {
        self.numTotal = numTotal
        self.numSucceeded = numSucceeded
        self.numFailed = numFailed
        self.totalDuration = totalDuration
    }
}

extension HistoryMigrationResult: Equatable, Hashable {
    public static func == (lhs: HistoryMigrationResult, rhs: HistoryMigrationResult) -> Bool {
        if lhs.numTotal != rhs.numTotal {
            return false
        }
        if lhs.numSucceeded != rhs.numSucceeded {
            return false
        }
        if lhs.numFailed != rhs.numFailed {
            return false
        }
        if lhs.totalDuration != rhs.totalDuration {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(numTotal)
        hasher.combine(numSucceeded)
        hasher.combine(numFailed)
        hasher.combine(totalDuration)
    }
}

public struct FfiConverterTypeHistoryMigrationResult: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryMigrationResult {
        return
            try HistoryMigrationResult(
                numTotal: FfiConverterUInt32.read(from: &buf),
                numSucceeded: FfiConverterUInt32.read(from: &buf),
                numFailed: FfiConverterUInt32.read(from: &buf),
                totalDuration: FfiConverterUInt64.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryMigrationResult, into buf: inout [UInt8]) {
        FfiConverterUInt32.write(value.numTotal, into: &buf)
        FfiConverterUInt32.write(value.numSucceeded, into: &buf)
        FfiConverterUInt32.write(value.numFailed, into: &buf)
        FfiConverterUInt64.write(value.totalDuration, into: &buf)
    }
}

public func FfiConverterTypeHistoryMigrationResult_lift(_ buf: RustBuffer) throws -> HistoryMigrationResult {
    return try FfiConverterTypeHistoryMigrationResult.lift(buf)
}

public func FfiConverterTypeHistoryMigrationResult_lower(_ value: HistoryMigrationResult) -> RustBuffer {
    return FfiConverterTypeHistoryMigrationResult.lower(value)
}

public struct HistoryVisitInfo {
    public var url: Url
    public var title: String?
    public var timestamp: PlacesTimestamp
    public var visitType: VisitType
    public var isHidden: Bool
    public var previewImageUrl: Url?
    public var isRemote: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(url: Url, title: String?, timestamp: PlacesTimestamp, visitType: VisitType, isHidden: Bool, previewImageUrl: Url?, isRemote: Bool) {
        self.url = url
        self.title = title
        self.timestamp = timestamp
        self.visitType = visitType
        self.isHidden = isHidden
        self.previewImageUrl = previewImageUrl
        self.isRemote = isRemote
    }
}

extension HistoryVisitInfo: Equatable, Hashable {
    public static func == (lhs: HistoryVisitInfo, rhs: HistoryVisitInfo) -> Bool {
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.timestamp != rhs.timestamp {
            return false
        }
        if lhs.visitType != rhs.visitType {
            return false
        }
        if lhs.isHidden != rhs.isHidden {
            return false
        }
        if lhs.previewImageUrl != rhs.previewImageUrl {
            return false
        }
        if lhs.isRemote != rhs.isRemote {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(url)
        hasher.combine(title)
        hasher.combine(timestamp)
        hasher.combine(visitType)
        hasher.combine(isHidden)
        hasher.combine(previewImageUrl)
        hasher.combine(isRemote)
    }
}

public struct FfiConverterTypeHistoryVisitInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryVisitInfo {
        return
            try HistoryVisitInfo(
                url: FfiConverterTypeUrl.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                timestamp: FfiConverterTypePlacesTimestamp.read(from: &buf),
                visitType: FfiConverterTypeVisitType.read(from: &buf),
                isHidden: FfiConverterBool.read(from: &buf),
                previewImageUrl: FfiConverterOptionTypeUrl.read(from: &buf),
                isRemote: FfiConverterBool.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryVisitInfo, into buf: inout [UInt8]) {
        FfiConverterTypeUrl.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterTypePlacesTimestamp.write(value.timestamp, into: &buf)
        FfiConverterTypeVisitType.write(value.visitType, into: &buf)
        FfiConverterBool.write(value.isHidden, into: &buf)
        FfiConverterOptionTypeUrl.write(value.previewImageUrl, into: &buf)
        FfiConverterBool.write(value.isRemote, into: &buf)
    }
}

public func FfiConverterTypeHistoryVisitInfo_lift(_ buf: RustBuffer) throws -> HistoryVisitInfo {
    return try FfiConverterTypeHistoryVisitInfo.lift(buf)
}

public func FfiConverterTypeHistoryVisitInfo_lower(_ value: HistoryVisitInfo) -> RustBuffer {
    return FfiConverterTypeHistoryVisitInfo.lower(value)
}

public struct HistoryVisitInfosWithBound {
    public var infos: [HistoryVisitInfo]
    public var bound: Int64
    public var offset: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(infos: [HistoryVisitInfo], bound: Int64, offset: Int64) {
        self.infos = infos
        self.bound = bound
        self.offset = offset
    }
}

extension HistoryVisitInfosWithBound: Equatable, Hashable {
    public static func == (lhs: HistoryVisitInfosWithBound, rhs: HistoryVisitInfosWithBound) -> Bool {
        if lhs.infos != rhs.infos {
            return false
        }
        if lhs.bound != rhs.bound {
            return false
        }
        if lhs.offset != rhs.offset {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(infos)
        hasher.combine(bound)
        hasher.combine(offset)
    }
}

public struct FfiConverterTypeHistoryVisitInfosWithBound: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> HistoryVisitInfosWithBound {
        return
            try HistoryVisitInfosWithBound(
                infos: FfiConverterSequenceTypeHistoryVisitInfo.read(from: &buf),
                bound: FfiConverterInt64.read(from: &buf),
                offset: FfiConverterInt64.read(from: &buf)
            )
    }

    public static func write(_ value: HistoryVisitInfosWithBound, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeHistoryVisitInfo.write(value.infos, into: &buf)
        FfiConverterInt64.write(value.bound, into: &buf)
        FfiConverterInt64.write(value.offset, into: &buf)
    }
}

public func FfiConverterTypeHistoryVisitInfosWithBound_lift(_ buf: RustBuffer) throws -> HistoryVisitInfosWithBound {
    return try FfiConverterTypeHistoryVisitInfosWithBound.lift(buf)
}

public func FfiConverterTypeHistoryVisitInfosWithBound_lower(_ value: HistoryVisitInfosWithBound) -> RustBuffer {
    return FfiConverterTypeHistoryVisitInfosWithBound.lower(value)
}

public struct InsertableBookmark {
    public var guid: Guid?
    public var parentGuid: Guid
    public var position: BookmarkPosition
    public var dateAdded: PlacesTimestamp?
    public var lastModified: PlacesTimestamp?
    public var url: Url
    public var title: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid? = nil, parentGuid: Guid, position: BookmarkPosition, dateAdded: PlacesTimestamp? = nil, lastModified: PlacesTimestamp? = nil, url: Url, title: String? = nil) {
        self.guid = guid
        self.parentGuid = parentGuid
        self.position = position
        self.dateAdded = dateAdded
        self.lastModified = lastModified
        self.url = url
        self.title = title
    }
}

extension InsertableBookmark: Equatable, Hashable {
    public static func == (lhs: InsertableBookmark, rhs: InsertableBookmark) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        if lhs.dateAdded != rhs.dateAdded {
            return false
        }
        if lhs.lastModified != rhs.lastModified {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(parentGuid)
        hasher.combine(position)
        hasher.combine(dateAdded)
        hasher.combine(lastModified)
        hasher.combine(url)
        hasher.combine(title)
    }
}

public struct FfiConverterTypeInsertableBookmark: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InsertableBookmark {
        return
            try InsertableBookmark(
                guid: FfiConverterOptionTypeGuid.read(from: &buf),
                parentGuid: FfiConverterTypeGuid.read(from: &buf),
                position: FfiConverterTypeBookmarkPosition.read(from: &buf),
                dateAdded: FfiConverterOptionTypePlacesTimestamp.read(from: &buf),
                lastModified: FfiConverterOptionTypePlacesTimestamp.read(from: &buf),
                url: FfiConverterTypeUrl.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: InsertableBookmark, into buf: inout [UInt8]) {
        FfiConverterOptionTypeGuid.write(value.guid, into: &buf)
        FfiConverterTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterTypeBookmarkPosition.write(value.position, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.dateAdded, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.lastModified, into: &buf)
        FfiConverterTypeUrl.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
    }
}

public func FfiConverterTypeInsertableBookmark_lift(_ buf: RustBuffer) throws -> InsertableBookmark {
    return try FfiConverterTypeInsertableBookmark.lift(buf)
}

public func FfiConverterTypeInsertableBookmark_lower(_ value: InsertableBookmark) -> RustBuffer {
    return FfiConverterTypeInsertableBookmark.lower(value)
}

public struct InsertableBookmarkFolder {
    public var guid: Guid?
    public var parentGuid: Guid
    public var position: BookmarkPosition
    public var dateAdded: PlacesTimestamp?
    public var lastModified: PlacesTimestamp?
    public var title: String?
    public var children: [InsertableBookmarkItem]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid? = nil, parentGuid: Guid, position: BookmarkPosition, dateAdded: PlacesTimestamp? = nil, lastModified: PlacesTimestamp? = nil, title: String? = nil, children: [InsertableBookmarkItem]) {
        self.guid = guid
        self.parentGuid = parentGuid
        self.position = position
        self.dateAdded = dateAdded
        self.lastModified = lastModified
        self.title = title
        self.children = children
    }
}

extension InsertableBookmarkFolder: Equatable, Hashable {
    public static func == (lhs: InsertableBookmarkFolder, rhs: InsertableBookmarkFolder) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        if lhs.dateAdded != rhs.dateAdded {
            return false
        }
        if lhs.lastModified != rhs.lastModified {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.children != rhs.children {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(parentGuid)
        hasher.combine(position)
        hasher.combine(dateAdded)
        hasher.combine(lastModified)
        hasher.combine(title)
        hasher.combine(children)
    }
}

public struct FfiConverterTypeInsertableBookmarkFolder: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InsertableBookmarkFolder {
        return
            try InsertableBookmarkFolder(
                guid: FfiConverterOptionTypeGuid.read(from: &buf),
                parentGuid: FfiConverterTypeGuid.read(from: &buf),
                position: FfiConverterTypeBookmarkPosition.read(from: &buf),
                dateAdded: FfiConverterOptionTypePlacesTimestamp.read(from: &buf),
                lastModified: FfiConverterOptionTypePlacesTimestamp.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                children: FfiConverterSequenceTypeInsertableBookmarkItem.read(from: &buf)
            )
    }

    public static func write(_ value: InsertableBookmarkFolder, into buf: inout [UInt8]) {
        FfiConverterOptionTypeGuid.write(value.guid, into: &buf)
        FfiConverterTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterTypeBookmarkPosition.write(value.position, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.dateAdded, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.lastModified, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterSequenceTypeInsertableBookmarkItem.write(value.children, into: &buf)
    }
}

public func FfiConverterTypeInsertableBookmarkFolder_lift(_ buf: RustBuffer) throws -> InsertableBookmarkFolder {
    return try FfiConverterTypeInsertableBookmarkFolder.lift(buf)
}

public func FfiConverterTypeInsertableBookmarkFolder_lower(_ value: InsertableBookmarkFolder) -> RustBuffer {
    return FfiConverterTypeInsertableBookmarkFolder.lower(value)
}

public struct InsertableBookmarkSeparator {
    public var guid: Guid?
    public var parentGuid: Guid
    public var position: BookmarkPosition
    public var dateAdded: PlacesTimestamp?
    public var lastModified: PlacesTimestamp?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(guid: Guid? = nil, parentGuid: Guid, position: BookmarkPosition, dateAdded: PlacesTimestamp? = nil, lastModified: PlacesTimestamp? = nil) {
        self.guid = guid
        self.parentGuid = parentGuid
        self.position = position
        self.dateAdded = dateAdded
        self.lastModified = lastModified
    }
}

extension InsertableBookmarkSeparator: Equatable, Hashable {
    public static func == (lhs: InsertableBookmarkSeparator, rhs: InsertableBookmarkSeparator) -> Bool {
        if lhs.guid != rhs.guid {
            return false
        }
        if lhs.parentGuid != rhs.parentGuid {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        if lhs.dateAdded != rhs.dateAdded {
            return false
        }
        if lhs.lastModified != rhs.lastModified {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(guid)
        hasher.combine(parentGuid)
        hasher.combine(position)
        hasher.combine(dateAdded)
        hasher.combine(lastModified)
    }
}

public struct FfiConverterTypeInsertableBookmarkSeparator: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InsertableBookmarkSeparator {
        return
            try InsertableBookmarkSeparator(
                guid: FfiConverterOptionTypeGuid.read(from: &buf),
                parentGuid: FfiConverterTypeGuid.read(from: &buf),
                position: FfiConverterTypeBookmarkPosition.read(from: &buf),
                dateAdded: FfiConverterOptionTypePlacesTimestamp.read(from: &buf),
                lastModified: FfiConverterOptionTypePlacesTimestamp.read(from: &buf)
            )
    }

    public static func write(_ value: InsertableBookmarkSeparator, into buf: inout [UInt8]) {
        FfiConverterOptionTypeGuid.write(value.guid, into: &buf)
        FfiConverterTypeGuid.write(value.parentGuid, into: &buf)
        FfiConverterTypeBookmarkPosition.write(value.position, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.dateAdded, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.lastModified, into: &buf)
    }
}

public func FfiConverterTypeInsertableBookmarkSeparator_lift(_ buf: RustBuffer) throws -> InsertableBookmarkSeparator {
    return try FfiConverterTypeInsertableBookmarkSeparator.lift(buf)
}

public func FfiConverterTypeInsertableBookmarkSeparator_lower(_ value: InsertableBookmarkSeparator) -> RustBuffer {
    return FfiConverterTypeInsertableBookmarkSeparator.lower(value)
}

public struct RunMaintenanceMetrics {
    public var prunedVisits: Bool
    public var dbSizeBefore: UInt32
    public var dbSizeAfter: UInt32

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(prunedVisits: Bool, dbSizeBefore: UInt32, dbSizeAfter: UInt32) {
        self.prunedVisits = prunedVisits
        self.dbSizeBefore = dbSizeBefore
        self.dbSizeAfter = dbSizeAfter
    }
}

extension RunMaintenanceMetrics: Equatable, Hashable {
    public static func == (lhs: RunMaintenanceMetrics, rhs: RunMaintenanceMetrics) -> Bool {
        if lhs.prunedVisits != rhs.prunedVisits {
            return false
        }
        if lhs.dbSizeBefore != rhs.dbSizeBefore {
            return false
        }
        if lhs.dbSizeAfter != rhs.dbSizeAfter {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(prunedVisits)
        hasher.combine(dbSizeBefore)
        hasher.combine(dbSizeAfter)
    }
}

public struct FfiConverterTypeRunMaintenanceMetrics: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> RunMaintenanceMetrics {
        return
            try RunMaintenanceMetrics(
                prunedVisits: FfiConverterBool.read(from: &buf),
                dbSizeBefore: FfiConverterUInt32.read(from: &buf),
                dbSizeAfter: FfiConverterUInt32.read(from: &buf)
            )
    }

    public static func write(_ value: RunMaintenanceMetrics, into buf: inout [UInt8]) {
        FfiConverterBool.write(value.prunedVisits, into: &buf)
        FfiConverterUInt32.write(value.dbSizeBefore, into: &buf)
        FfiConverterUInt32.write(value.dbSizeAfter, into: &buf)
    }
}

public func FfiConverterTypeRunMaintenanceMetrics_lift(_ buf: RustBuffer) throws -> RunMaintenanceMetrics {
    return try FfiConverterTypeRunMaintenanceMetrics.lift(buf)
}

public func FfiConverterTypeRunMaintenanceMetrics_lower(_ value: RunMaintenanceMetrics) -> RustBuffer {
    return FfiConverterTypeRunMaintenanceMetrics.lower(value)
}

public struct SearchResult {
    public var url: Url
    public var title: String
    public var frecency: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(url: Url, title: String, frecency: Int64) {
        self.url = url
        self.title = title
        self.frecency = frecency
    }
}

extension SearchResult: Equatable, Hashable {
    public static func == (lhs: SearchResult, rhs: SearchResult) -> Bool {
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.frecency != rhs.frecency {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(url)
        hasher.combine(title)
        hasher.combine(frecency)
    }
}

public struct FfiConverterTypeSearchResult: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchResult {
        return
            try SearchResult(
                url: FfiConverterTypeUrl.read(from: &buf),
                title: FfiConverterString.read(from: &buf),
                frecency: FfiConverterInt64.read(from: &buf)
            )
    }

    public static func write(_ value: SearchResult, into buf: inout [UInt8]) {
        FfiConverterTypeUrl.write(value.url, into: &buf)
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterInt64.write(value.frecency, into: &buf)
    }
}

public func FfiConverterTypeSearchResult_lift(_ buf: RustBuffer) throws -> SearchResult {
    return try FfiConverterTypeSearchResult.lift(buf)
}

public func FfiConverterTypeSearchResult_lower(_ value: SearchResult) -> RustBuffer {
    return FfiConverterTypeSearchResult.lower(value)
}

public struct TopFrecentSiteInfo {
    public var url: Url
    public var title: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(url: Url, title: String?) {
        self.url = url
        self.title = title
    }
}

extension TopFrecentSiteInfo: Equatable, Hashable {
    public static func == (lhs: TopFrecentSiteInfo, rhs: TopFrecentSiteInfo) -> Bool {
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(url)
        hasher.combine(title)
    }
}

public struct FfiConverterTypeTopFrecentSiteInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> TopFrecentSiteInfo {
        return
            try TopFrecentSiteInfo(
                url: FfiConverterTypeUrl.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf)
            )
    }

    public static func write(_ value: TopFrecentSiteInfo, into buf: inout [UInt8]) {
        FfiConverterTypeUrl.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
    }
}

public func FfiConverterTypeTopFrecentSiteInfo_lift(_ buf: RustBuffer) throws -> TopFrecentSiteInfo {
    return try FfiConverterTypeTopFrecentSiteInfo.lift(buf)
}

public func FfiConverterTypeTopFrecentSiteInfo_lower(_ value: TopFrecentSiteInfo) -> RustBuffer {
    return FfiConverterTypeTopFrecentSiteInfo.lower(value)
}

public struct VisitObservation {
    public var url: Url
    public var title: String?
    public var visitType: VisitType?
    public var isError: Bool?
    public var isRedirectSource: Bool?
    public var isPermanentRedirectSource: Bool?
    public var at: PlacesTimestamp?
    public var referrer: Url?
    public var isRemote: Bool?
    public var previewImageUrl: Url?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(url: Url, title: String? = nil, visitType: VisitType?, isError: Bool? = nil, isRedirectSource: Bool? = nil, isPermanentRedirectSource: Bool? = nil, at: PlacesTimestamp? = nil, referrer: Url? = nil, isRemote: Bool? = nil, previewImageUrl: Url? = nil) {
        self.url = url
        self.title = title
        self.visitType = visitType
        self.isError = isError
        self.isRedirectSource = isRedirectSource
        self.isPermanentRedirectSource = isPermanentRedirectSource
        self.at = at
        self.referrer = referrer
        self.isRemote = isRemote
        self.previewImageUrl = previewImageUrl
    }
}

extension VisitObservation: Equatable, Hashable {
    public static func == (lhs: VisitObservation, rhs: VisitObservation) -> Bool {
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.visitType != rhs.visitType {
            return false
        }
        if lhs.isError != rhs.isError {
            return false
        }
        if lhs.isRedirectSource != rhs.isRedirectSource {
            return false
        }
        if lhs.isPermanentRedirectSource != rhs.isPermanentRedirectSource {
            return false
        }
        if lhs.at != rhs.at {
            return false
        }
        if lhs.referrer != rhs.referrer {
            return false
        }
        if lhs.isRemote != rhs.isRemote {
            return false
        }
        if lhs.previewImageUrl != rhs.previewImageUrl {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(url)
        hasher.combine(title)
        hasher.combine(visitType)
        hasher.combine(isError)
        hasher.combine(isRedirectSource)
        hasher.combine(isPermanentRedirectSource)
        hasher.combine(at)
        hasher.combine(referrer)
        hasher.combine(isRemote)
        hasher.combine(previewImageUrl)
    }
}

public struct FfiConverterTypeVisitObservation: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> VisitObservation {
        return
            try VisitObservation(
                url: FfiConverterTypeUrl.read(from: &buf),
                title: FfiConverterOptionString.read(from: &buf),
                visitType: FfiConverterOptionTypeVisitType.read(from: &buf),
                isError: FfiConverterOptionBool.read(from: &buf),
                isRedirectSource: FfiConverterOptionBool.read(from: &buf),
                isPermanentRedirectSource: FfiConverterOptionBool.read(from: &buf),
                at: FfiConverterOptionTypePlacesTimestamp.read(from: &buf),
                referrer: FfiConverterOptionTypeUrl.read(from: &buf),
                isRemote: FfiConverterOptionBool.read(from: &buf),
                previewImageUrl: FfiConverterOptionTypeUrl.read(from: &buf)
            )
    }

    public static func write(_ value: VisitObservation, into buf: inout [UInt8]) {
        FfiConverterTypeUrl.write(value.url, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
        FfiConverterOptionTypeVisitType.write(value.visitType, into: &buf)
        FfiConverterOptionBool.write(value.isError, into: &buf)
        FfiConverterOptionBool.write(value.isRedirectSource, into: &buf)
        FfiConverterOptionBool.write(value.isPermanentRedirectSource, into: &buf)
        FfiConverterOptionTypePlacesTimestamp.write(value.at, into: &buf)
        FfiConverterOptionTypeUrl.write(value.referrer, into: &buf)
        FfiConverterOptionBool.write(value.isRemote, into: &buf)
        FfiConverterOptionTypeUrl.write(value.previewImageUrl, into: &buf)
    }
}

public func FfiConverterTypeVisitObservation_lift(_ buf: RustBuffer) throws -> VisitObservation {
    return try FfiConverterTypeVisitObservation.lift(buf)
}

public func FfiConverterTypeVisitObservation_lower(_ value: VisitObservation) -> RustBuffer {
    return FfiConverterTypeVisitObservation.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum BookmarkItem {
    case bookmark(b: BookmarkData
    )
    case separator(s: BookmarkSeparator
    )
    case folder(f: BookmarkFolder
    )
}

public struct FfiConverterTypeBookmarkItem: FfiConverterRustBuffer {
    typealias SwiftType = BookmarkItem

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BookmarkItem {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .bookmark(b: FfiConverterTypeBookmarkData.read(from: &buf)
            )

        case 2: return try .separator(s: FfiConverterTypeBookmarkSeparator.read(from: &buf)
            )

        case 3: return try .folder(f: FfiConverterTypeBookmarkFolder.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: BookmarkItem, into buf: inout [UInt8]) {
        switch value {
        case let .bookmark(b):
            writeInt(&buf, Int32(1))
            FfiConverterTypeBookmarkData.write(b, into: &buf)

        case let .separator(s):
            writeInt(&buf, Int32(2))
            FfiConverterTypeBookmarkSeparator.write(s, into: &buf)

        case let .folder(f):
            writeInt(&buf, Int32(3))
            FfiConverterTypeBookmarkFolder.write(f, into: &buf)
        }
    }
}

public func FfiConverterTypeBookmarkItem_lift(_ buf: RustBuffer) throws -> BookmarkItem {
    return try FfiConverterTypeBookmarkItem.lift(buf)
}

public func FfiConverterTypeBookmarkItem_lower(_ value: BookmarkItem) -> RustBuffer {
    return FfiConverterTypeBookmarkItem.lower(value)
}

extension BookmarkItem: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum BookmarkPosition {
    case specific(pos: UInt32
    )
    case append
}

public struct FfiConverterTypeBookmarkPosition: FfiConverterRustBuffer {
    typealias SwiftType = BookmarkPosition

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BookmarkPosition {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .specific(pos: FfiConverterUInt32.read(from: &buf)
            )

        case 2: return .append

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: BookmarkPosition, into buf: inout [UInt8]) {
        switch value {
        case let .specific(pos):
            writeInt(&buf, Int32(1))
            FfiConverterUInt32.write(pos, into: &buf)

        case .append:
            writeInt(&buf, Int32(2))
        }
    }
}

public func FfiConverterTypeBookmarkPosition_lift(_ buf: RustBuffer) throws -> BookmarkPosition {
    return try FfiConverterTypeBookmarkPosition.lift(buf)
}

public func FfiConverterTypeBookmarkPosition_lower(_ value: BookmarkPosition) -> RustBuffer {
    return FfiConverterTypeBookmarkPosition.lower(value)
}

extension BookmarkPosition: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum ConnectionType {
    case readOnly
    case readWrite
    case sync
}

public struct FfiConverterTypeConnectionType: FfiConverterRustBuffer {
    typealias SwiftType = ConnectionType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ConnectionType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .readOnly

        case 2: return .readWrite

        case 3: return .sync

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: ConnectionType, into buf: inout [UInt8]) {
        switch value {
        case .readOnly:
            writeInt(&buf, Int32(1))

        case .readWrite:
            writeInt(&buf, Int32(2))

        case .sync:
            writeInt(&buf, Int32(3))
        }
    }
}

public func FfiConverterTypeConnectionType_lift(_ buf: RustBuffer) throws -> ConnectionType {
    return try FfiConverterTypeConnectionType.lift(buf)
}

public func FfiConverterTypeConnectionType_lower(_ value: ConnectionType) -> RustBuffer {
    return FfiConverterTypeConnectionType.lower(value)
}

extension ConnectionType: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum DocumentType {
    case regular
    case media
}

public struct FfiConverterTypeDocumentType: FfiConverterRustBuffer {
    typealias SwiftType = DocumentType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DocumentType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .regular

        case 2: return .media

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: DocumentType, into buf: inout [UInt8]) {
        switch value {
        case .regular:
            writeInt(&buf, Int32(1))

        case .media:
            writeInt(&buf, Int32(2))
        }
    }
}

public func FfiConverterTypeDocumentType_lift(_ buf: RustBuffer) throws -> DocumentType {
    return try FfiConverterTypeDocumentType.lift(buf)
}

public func FfiConverterTypeDocumentType_lower(_ value: DocumentType) -> RustBuffer {
    return FfiConverterTypeDocumentType.lower(value)
}

extension DocumentType: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum FrecencyThresholdOption {
    case none
    case skipOneTimePages
}

public struct FfiConverterTypeFrecencyThresholdOption: FfiConverterRustBuffer {
    typealias SwiftType = FrecencyThresholdOption

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FrecencyThresholdOption {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .none

        case 2: return .skipOneTimePages

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FrecencyThresholdOption, into buf: inout [UInt8]) {
        switch value {
        case .none:
            writeInt(&buf, Int32(1))

        case .skipOneTimePages:
            writeInt(&buf, Int32(2))
        }
    }
}

public func FfiConverterTypeFrecencyThresholdOption_lift(_ buf: RustBuffer) throws -> FrecencyThresholdOption {
    return try FfiConverterTypeFrecencyThresholdOption.lift(buf)
}

public func FfiConverterTypeFrecencyThresholdOption_lower(_ value: FrecencyThresholdOption) -> RustBuffer {
    return FfiConverterTypeFrecencyThresholdOption.lower(value)
}

extension FrecencyThresholdOption: Equatable, Hashable {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum InsertableBookmarkItem {
    case bookmark(b: InsertableBookmark
    )
    case folder(f: InsertableBookmarkFolder
    )
    case separator(s: InsertableBookmarkSeparator
    )
}

public struct FfiConverterTypeInsertableBookmarkItem: FfiConverterRustBuffer {
    typealias SwiftType = InsertableBookmarkItem

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InsertableBookmarkItem {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .bookmark(b: FfiConverterTypeInsertableBookmark.read(from: &buf)
            )

        case 2: return try .folder(f: FfiConverterTypeInsertableBookmarkFolder.read(from: &buf)
            )

        case 3: return try .separator(s: FfiConverterTypeInsertableBookmarkSeparator.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: InsertableBookmarkItem, into buf: inout [UInt8]) {
        switch value {
        case let .bookmark(b):
            writeInt(&buf, Int32(1))
            FfiConverterTypeInsertableBookmark.write(b, into: &buf)

        case let .folder(f):
            writeInt(&buf, Int32(2))
            FfiConverterTypeInsertableBookmarkFolder.write(f, into: &buf)

        case let .separator(s):
            writeInt(&buf, Int32(3))
            FfiConverterTypeInsertableBookmarkSeparator.write(s, into: &buf)
        }
    }
}

public func FfiConverterTypeInsertableBookmarkItem_lift(_ buf: RustBuffer) throws -> InsertableBookmarkItem {
    return try FfiConverterTypeInsertableBookmarkItem.lift(buf)
}

public func FfiConverterTypeInsertableBookmarkItem_lower(_ value: InsertableBookmarkItem) -> RustBuffer {
    return FfiConverterTypeInsertableBookmarkItem.lower(value)
}

extension InsertableBookmarkItem: Equatable, Hashable {}

public enum PlacesApiError {
    case UnexpectedPlacesException(reason: String
    )
    case UrlParseFailed(reason: String
    )
    case PlacesConnectionBusy(reason: String
    )
    case OperationInterrupted(reason: String
    )
    case UnknownBookmarkItem(reason: String
    )
    case InvalidBookmarkOperation(reason: String
    )
}

public struct FfiConverterTypePlacesApiError: FfiConverterRustBuffer {
    typealias SwiftType = PlacesApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PlacesApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .UnexpectedPlacesException(
                reason: FfiConverterString.read(from: &buf)
            )
        case 2: return try .UrlParseFailed(
                reason: FfiConverterString.read(from: &buf)
            )
        case 3: return try .PlacesConnectionBusy(
                reason: FfiConverterString.read(from: &buf)
            )
        case 4: return try .OperationInterrupted(
                reason: FfiConverterString.read(from: &buf)
            )
        case 5: return try .UnknownBookmarkItem(
                reason: FfiConverterString.read(from: &buf)
            )
        case 6: return try .InvalidBookmarkOperation(
                reason: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: PlacesApiError, into buf: inout [UInt8]) {
        switch value {
        case let .UnexpectedPlacesException(reason):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(reason, into: &buf)

        case let .UrlParseFailed(reason):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(reason, into: &buf)

        case let .PlacesConnectionBusy(reason):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(reason, into: &buf)

        case let .OperationInterrupted(reason):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(reason, into: &buf)

        case let .UnknownBookmarkItem(reason):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(reason, into: &buf)

        case let .InvalidBookmarkOperation(reason):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(reason, into: &buf)
        }
    }
}

extension PlacesApiError: Equatable, Hashable {}

extension PlacesApiError: Error {}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum VisitType {
    case link
    case typed
    case bookmark
    case embed
    case redirectPermanent
    case redirectTemporary
    case download
    case framedLink
    case reload
    case updatePlace
}

public struct FfiConverterTypeVisitType: FfiConverterRustBuffer {
    typealias SwiftType = VisitType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> VisitType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .link

        case 2: return .typed

        case 3: return .bookmark

        case 4: return .embed

        case 5: return .redirectPermanent

        case 6: return .redirectTemporary

        case 7: return .download

        case 8: return .framedLink

        case 9: return .reload

        case 10: return .updatePlace

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: VisitType, into buf: inout [UInt8]) {
        switch value {
        case .link:
            writeInt(&buf, Int32(1))

        case .typed:
            writeInt(&buf, Int32(2))

        case .bookmark:
            writeInt(&buf, Int32(3))

        case .embed:
            writeInt(&buf, Int32(4))

        case .redirectPermanent:
            writeInt(&buf, Int32(5))

        case .redirectTemporary:
            writeInt(&buf, Int32(6))

        case .download:
            writeInt(&buf, Int32(7))

        case .framedLink:
            writeInt(&buf, Int32(8))

        case .reload:
            writeInt(&buf, Int32(9))

        case .updatePlace:
            writeInt(&buf, Int32(10))
        }
    }
}

public func FfiConverterTypeVisitType_lift(_ buf: RustBuffer) throws -> VisitType {
    return try FfiConverterTypeVisitType.lift(buf)
}

public func FfiConverterTypeVisitType_lower(_ value: VisitType) -> RustBuffer {
    return FfiConverterTypeVisitType.lower(value)
}

extension VisitType: Equatable, Hashable {}

private struct FfiConverterOptionUInt32: FfiConverterRustBuffer {
    typealias SwiftType = UInt32?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterUInt32.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterUInt32.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionInt32: FfiConverterRustBuffer {
    typealias SwiftType = Int32?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt32.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt32.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionBool: FfiConverterRustBuffer {
    typealias SwiftType = Bool?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterBool.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterBool.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeHistoryMetadata: FfiConverterRustBuffer {
    typealias SwiftType = HistoryMetadata?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeHistoryMetadata.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeHistoryMetadata.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeBookmarkItem: FfiConverterRustBuffer {
    typealias SwiftType = BookmarkItem?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeBookmarkItem.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeBookmarkItem.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeDocumentType: FfiConverterRustBuffer {
    typealias SwiftType = DocumentType?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeDocumentType.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeDocumentType.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeVisitType: FfiConverterRustBuffer {
    typealias SwiftType = VisitType?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeVisitType.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeVisitType.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionSequenceTypeHistoryMetadata: FfiConverterRustBuffer {
    typealias SwiftType = [HistoryMetadata]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeHistoryMetadata.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeHistoryMetadata.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionSequenceTypeBookmarkItem: FfiConverterRustBuffer {
    typealias SwiftType = [BookmarkItem]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeBookmarkItem.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeBookmarkItem.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionSequenceTypeGuid: FfiConverterRustBuffer {
    typealias SwiftType = [Guid]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeGuid.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeGuid.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeGuid: FfiConverterRustBuffer {
    typealias SwiftType = Guid?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeGuid.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeGuid.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypePlacesTimestamp: FfiConverterRustBuffer {
    typealias SwiftType = PlacesTimestamp?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypePlacesTimestamp.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypePlacesTimestamp.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeUrl: FfiConverterRustBuffer {
    typealias SwiftType = Url?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeUrl.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeUrl.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceBool: FfiConverterRustBuffer {
    typealias SwiftType = [Bool]

    public static func write(_ value: [Bool], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterBool.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Bool] {
        let len: Int32 = try readInt(&buf)
        var seq = [Bool]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterBool.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeHistoryHighlight: FfiConverterRustBuffer {
    typealias SwiftType = [HistoryHighlight]

    public static func write(_ value: [HistoryHighlight], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeHistoryHighlight.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [HistoryHighlight] {
        let len: Int32 = try readInt(&buf)
        var seq = [HistoryHighlight]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeHistoryHighlight.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeHistoryMetadata: FfiConverterRustBuffer {
    typealias SwiftType = [HistoryMetadata]

    public static func write(_ value: [HistoryMetadata], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeHistoryMetadata.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [HistoryMetadata] {
        let len: Int32 = try readInt(&buf)
        var seq = [HistoryMetadata]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeHistoryMetadata.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeHistoryVisitInfo: FfiConverterRustBuffer {
    typealias SwiftType = [HistoryVisitInfo]

    public static func write(_ value: [HistoryVisitInfo], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeHistoryVisitInfo.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [HistoryVisitInfo] {
        let len: Int32 = try readInt(&buf)
        var seq = [HistoryVisitInfo]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeHistoryVisitInfo.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeSearchResult: FfiConverterRustBuffer {
    typealias SwiftType = [SearchResult]

    public static func write(_ value: [SearchResult], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeSearchResult.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [SearchResult] {
        let len: Int32 = try readInt(&buf)
        var seq = [SearchResult]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeSearchResult.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeTopFrecentSiteInfo: FfiConverterRustBuffer {
    typealias SwiftType = [TopFrecentSiteInfo]

    public static func write(_ value: [TopFrecentSiteInfo], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeTopFrecentSiteInfo.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [TopFrecentSiteInfo] {
        let len: Int32 = try readInt(&buf)
        var seq = [TopFrecentSiteInfo]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeTopFrecentSiteInfo.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeBookmarkItem: FfiConverterRustBuffer {
    typealias SwiftType = [BookmarkItem]

    public static func write(_ value: [BookmarkItem], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeBookmarkItem.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [BookmarkItem] {
        let len: Int32 = try readInt(&buf)
        var seq = [BookmarkItem]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeBookmarkItem.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeInsertableBookmarkItem: FfiConverterRustBuffer {
    typealias SwiftType = [InsertableBookmarkItem]

    public static func write(_ value: [InsertableBookmarkItem], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeInsertableBookmarkItem.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [InsertableBookmarkItem] {
        let len: Int32 = try readInt(&buf)
        var seq = [InsertableBookmarkItem]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeInsertableBookmarkItem.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeGuid: FfiConverterRustBuffer {
    typealias SwiftType = [Guid]

    public static func write(_ value: [Guid], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeGuid.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Guid] {
        let len: Int32 = try readInt(&buf)
        var seq = [Guid]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeGuid.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeUrl: FfiConverterRustBuffer {
    typealias SwiftType = [Url]

    public static func write(_ value: [Url], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeUrl.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Url] {
        let len: Int32 = try readInt(&buf)
        var seq = [Url]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeUrl.read(from: &buf))
        }
        return seq
    }
}

/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias Guid = String
public struct FfiConverterTypeGuid: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Guid {
        return try FfiConverterString.read(from: &buf)
    }

    public static func write(_ value: Guid, into buf: inout [UInt8]) {
        return FfiConverterString.write(value, into: &buf)
    }

    public static func lift(_ value: RustBuffer) throws -> Guid {
        return try FfiConverterString.lift(value)
    }

    public static func lower(_ value: Guid) -> RustBuffer {
        return FfiConverterString.lower(value)
    }
}

public func FfiConverterTypeGuid_lift(_ value: RustBuffer) throws -> Guid {
    return try FfiConverterTypeGuid.lift(value)
}

public func FfiConverterTypeGuid_lower(_ value: Guid) -> RustBuffer {
    return FfiConverterTypeGuid.lower(value)
}

/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias PlacesTimestamp = Int64
public struct FfiConverterTypePlacesTimestamp: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> PlacesTimestamp {
        return try FfiConverterInt64.read(from: &buf)
    }

    public static func write(_ value: PlacesTimestamp, into buf: inout [UInt8]) {
        return FfiConverterInt64.write(value, into: &buf)
    }

    public static func lift(_ value: Int64) throws -> PlacesTimestamp {
        return try FfiConverterInt64.lift(value)
    }

    public static func lower(_ value: PlacesTimestamp) -> Int64 {
        return FfiConverterInt64.lower(value)
    }
}

public func FfiConverterTypePlacesTimestamp_lift(_ value: Int64) throws -> PlacesTimestamp {
    return try FfiConverterTypePlacesTimestamp.lift(value)
}

public func FfiConverterTypePlacesTimestamp_lower(_ value: PlacesTimestamp) -> Int64 {
    return FfiConverterTypePlacesTimestamp.lower(value)
}

/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias Url = String
public struct FfiConverterTypeUrl: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Url {
        return try FfiConverterString.read(from: &buf)
    }

    public static func write(_ value: Url, into buf: inout [UInt8]) {
        return FfiConverterString.write(value, into: &buf)
    }

    public static func lift(_ value: RustBuffer) throws -> Url {
        return try FfiConverterString.lift(value)
    }

    public static func lower(_ value: Url) -> RustBuffer {
        return FfiConverterString.lower(value)
    }
}

public func FfiConverterTypeUrl_lift(_ value: RustBuffer) throws -> Url {
    return try FfiConverterTypeUrl.lift(value)
}

public func FfiConverterTypeUrl_lower(_ value: Url) -> RustBuffer {
    return FfiConverterTypeUrl.lower(value)
}

/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias VisitTransitionSet = Int32
public struct FfiConverterTypeVisitTransitionSet: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> VisitTransitionSet {
        return try FfiConverterInt32.read(from: &buf)
    }

    public static func write(_ value: VisitTransitionSet, into buf: inout [UInt8]) {
        return FfiConverterInt32.write(value, into: &buf)
    }

    public static func lift(_ value: Int32) throws -> VisitTransitionSet {
        return try FfiConverterInt32.lift(value)
    }

    public static func lower(_ value: VisitTransitionSet) -> Int32 {
        return FfiConverterInt32.lower(value)
    }
}

public func FfiConverterTypeVisitTransitionSet_lift(_ value: Int32) throws -> VisitTransitionSet {
    return try FfiConverterTypeVisitTransitionSet.lift(value)
}

public func FfiConverterTypeVisitTransitionSet_lower(_ value: VisitTransitionSet) -> Int32 {
    return FfiConverterTypeVisitTransitionSet.lower(value)
}

public func placesApiNew(dbPath: String) throws -> PlacesApi {
    return try FfiConverterTypePlacesApi.lift(rustCallWithError(FfiConverterTypePlacesApiError.lift) {
        uniffi_places_fn_func_places_api_new(
            FfiConverterString.lower(dbPath), $0
        )
    })
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_places_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_places_checksum_func_places_api_new() != 61152 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesapi_bookmarks_reset() != 55149 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesapi_bookmarks_sync() != 30727 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesapi_history_sync() != 34252 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesapi_new_connection() != 52100 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesapi_register_with_sync_manager() != 51829 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesapi_reset_history() != 6106 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_accept_result() != 37823 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_apply_observation() != 21237 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_count_bookmarks_in_trees() != 15723 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_delete() != 36364 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_delete_everything() != 63220 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_get_all_with_url() != 14617 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_get_by_guid() != 14370 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_get_recent() != 42501 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_get_tree() != 19881 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_get_url_for_keyword() != 57235 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_insert() != 30432 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_search() != 33699 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_bookmarks_update() != 21797 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_delete_everything_history() != 49787 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_delete_visit() != 21359 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_delete_visits_between() != 11612 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_delete_visits_for() != 29015 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_history_highlights() != 47165 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_history_metadata_between() != 42219 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_history_metadata_since() != 42564 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_latest_history_metadata_for_url() != 31105 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_top_frecent_site_infos() != 4671 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_visit_count() != 21703 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_visit_infos() != 14475 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_visit_page() != 44701 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_visit_page_with_bound() != 32992 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_visited() != 7835 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_get_visited_urls_in_range() != 36149 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_match_url() != 29961 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_metadata_delete() != 57924 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_metadata_delete_older_than() != 9091 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_new_interrupt_handle() != 5418 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_note_history_metadata_observation() != 12555 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_places_history_import_from_ios() != 596 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_query_autocomplete() != 35323 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_query_history_metadata() != 21791 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_run_maintenance_checkpoint() != 3524 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_run_maintenance_optimize() != 56373 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_run_maintenance_prune() != 54740 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_placesconnection_run_maintenance_vacuum() != 17497 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_places_checksum_method_sqlinterrupthandle_interrupt() != 10423 {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all
