// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
/**
 * # Firefox Accounts Client
 *
 * The fxa-client component lets applications integrate with the
 * [Firefox Accounts](https://mozilla.github.io/ecosystem-platform/docs/features/firefox-accounts/fxa-overview)
 * identity service. The shape of a typical integration would look
 * something like:
 *
 * * Out-of-band, register your application with the Firefox Accounts service,
 *   providing an OAuth `redirect_uri` controlled by your application and
 *   obtaining an OAuth `client_id`.
 *
 * * On application startup, create a [`FirefoxAccount`] object to represent the
 *   signed-in state of the application.
 *     * On first startup, a new [`FirefoxAccount`] can be created by calling
 *       [`FirefoxAccount::new`] and passing the application's `client_id`.
 *     * For subsequent startups the object can be persisted using the
 *       [`to_json`](FirefoxAccount::to_json) method and re-created by
 *       calling [`FirefoxAccount::from_json`].
 *
 * * When the user wants to sign in to your application, direct them through
 *   a web-based OAuth flow using [`begin_oauth_flow`](FirefoxAccount::begin_oauth_flow)
 *   or [`begin_pairing_flow`](FirefoxAccount::begin_pairing_flow); when they return
 *   to your registered `redirect_uri`, pass the resulting authorization state back to
 *   [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) to sign them in.
 *
 * * Display information about the signed-in user by using the data from
 *   [`get_profile`](FirefoxAccount::get_profile).
 *
 * * Access account-related services on behalf of the user by obtaining OAuth
 *   access tokens via [`get_access_token`](FirefoxAccount::get_access_token).
 *
 * * If the user opts to sign out of the application, calling [`disconnect`](FirefoxAccount::disconnect)
 *   and then discarding any persisted account data.
 */
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
import MozillaRustComponents
#endif

fileprivate extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len:0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_fxa_client_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_fxa_client_rustbuffer_free(self, $0) }
    }
}

fileprivate extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

fileprivate extension Data {
    init(rustBuffer: RustBuffer) {
        self.init(
            bytesNoCopy: rustBuffer.data!,
            count: Int(rustBuffer.len),
            deallocator: .none
        )
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

fileprivate func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
fileprivate func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset..<reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value, { reader.data.copyBytes(to: $0, from: range)})
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
fileprivate func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> Array<UInt8> {
    let range = reader.offset..<(reader.offset+count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer({ buffer in
        reader.data.copyBytes(to: buffer, from: range)
    })
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
fileprivate func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return Float(bitPattern: try readInt(&reader))
}

// Reads a float at the current offset.
fileprivate func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return Double(bitPattern: try readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
fileprivate func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

fileprivate func createWriter() -> [UInt8] {
    return []
}

fileprivate func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
fileprivate func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

fileprivate func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

fileprivate func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous to the Rust trait of the same name.
fileprivate protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
fileprivate protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType { }

extension FfiConverterPrimitive {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
fileprivate protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> RustBuffer {
          var writer = createWriter()
          write(value, into: &writer)
          return RustBuffer(bytes: writer)
    }
}
// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
fileprivate enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

fileprivate extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        self.lock()
        defer { self.unlock() }
        return try f()
    }
}

fileprivate let CALL_SUCCESS: Int8 = 0
fileprivate let CALL_ERROR: Int8 = 1
fileprivate let CALL_UNEXPECTED_ERROR: Int8 = 2
fileprivate let CALL_CANCELLED: Int8 = 3

fileprivate extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer.init(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    let neverThrow: ((RustBuffer) throws -> Never)? = nil
    return try makeRustCall(callback, errorHandler: neverThrow)
}

private func rustCallWithError<T, E: Swift.Error>(
    _ errorHandler: @escaping (RustBuffer) throws -> E,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T, E: Swift.Error>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> E)?
) throws -> T {
    uniffiEnsureFxaClientInitialized()
    var callStatus = RustCallStatus.init()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus<E: Swift.Error>(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> E)?
) throws {
    switch callStatus.code {
        case CALL_SUCCESS:
            return

        case CALL_ERROR:
            if let errorHandler = errorHandler {
                throw try errorHandler(callStatus.errorBuf)
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.unexpectedRustCallError
            }

        case CALL_UNEXPECTED_ERROR:
            // When the rust code sees a panic, it tries to construct a RustBuffer
            // with the message.  But if that code panics, then it just sends back
            // an empty buffer.
            if callStatus.errorBuf.len > 0 {
                throw UniffiInternalError.rustPanic(try FfiConverterString.lift(callStatus.errorBuf))
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.rustPanic("Rust panic")
            }

        case CALL_CANCELLED:
            fatalError("Cancellation not supported yet")

        default:
            throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> ()
) {
    do {
        try writeReturn(makeCall())
    } catch let error {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> (),
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}
fileprivate final class UniffiHandleMap<T>: @unchecked Sendable {
    // All mutation happens with this lock held, which is why we implement @unchecked Sendable.
    private let lock = NSLock()
    private var map: [UInt64: T] = [:]
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

     func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        get {
            map.count
        }
    }
}


// Public interface members begin here.


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterBool : FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return String(bytes: try readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}




/**
 * Object representing the signed-in state of an application.
 *
 * The `FirefoxAccount` object is the main interface provided by this crate.
 * It represents the signed-in state of an application that may be connected to
 * user's Firefox Account, and provides methods for inspecting the state of the
 * account and accessing other services on behalf of the user.

 */
public protocol FirefoxAccountProtocol: AnyObject {
    
    /**
     * Create a new OAuth authorization code using the stored session token.
     *
     * When a signed-in application receives an incoming device pairing request, it can
     * use this method to grant the request and generate a corresponding OAuth authorization
     * code. This code would then be passed back to the connecting device over the
     * pairing channel (a process which is not currently supported by any code in this
     * component).
     *
     * # Arguments
     *
     *    - `params` - the OAuth parameters from the incoming authorization request

     */
    func authorizeCodeUsingSessionToken(params: AuthorizationParameters) throws  -> String
    
    /**
     * Initiate a web-based OAuth sign-in flow.
     *
     * This method initializes some internal state and then returns a URL at which the
     * user may perform a web-based authorization flow to connect the application to
     * their account. The application should direct the user to the provided URL.
     *
     * When the resulting OAuth flow redirects back to the configured `redirect_uri`,
     * the query parameters should be extracting from the URL and passed to the
     * [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) method to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
    func beginOauthFlow(scopes: [String], entrypoint: String) throws  -> String
    
    /**
     * Initiate a device-pairing sign-in flow.
     *
     * Once the user has scanned a pairing QR code, pass the scanned value to this
     * method. It will return a URL to which the application should redirect the user
     * in order to continue the sign-in flow.
     *
     * When the resulting flow redirects back to the configured `redirect_uri`,
     * the resulting OAuth parameters should be extracting from the URL and passed
     * to [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `pairing_url` - the URL scanned from a QR code on another device.
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
    func beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String) throws  -> String
    
    /**
     * Check authorization status for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications may call this method to check with the FxA server about the status
     * of their authentication tokens. It returns an [`AuthorizationInfo`] struct
     * with details about whether the tokens are still active.

     */
    func checkAuthorizationStatus() throws  -> AuthorizationInfo
    
    /**
     * Clear the access token cache in response to an auth failure.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that receive an authentication error when trying to use an access token,
     * should call this method before creating a new token and retrying the failed operation.
     * It ensures that the expired token is removed and a fresh one generated.

     */
    func clearAccessTokenCache() 
    
    /**
     * Clear any custom display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method clears the name of the current application's device record, causing other
     * applications or the user's account management pages to have to fill in some sort of
     * default name when displaying this device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func clearDeviceName() throws 
    
    /**
     * Use device commands to close one or more tabs on another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`CloseTabs`](DeviceCapability::CloseTabs)
     * capability, this method can be used to close its tabs.
     */
    func closeTabs(targetDeviceId: String, urls: [String]) throws  -> CloseTabsResult
    
    /**
     * Complete an OAuth flow.
     *
     * **💾 This method alters the persisted account state.**
     *
     * At the conclusion of an OAuth flow, the user will be redirect to the
     * application's registered `redirect_uri`. It should extract the `code`
     * and `state` parameters from the resulting URL and pass them to this
     * method in order to complete the sign-in.
     *
     * # Arguments
     *
     *   - `code` - the OAuth authorization code obtained from the redirect URI.
     *   - `state` - the OAuth state parameter obtained from the redirect URI.

     */
    func completeOauthFlow(code: String, state: String) throws 
    
    /**
     * Disconnect from the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method destroys any tokens held by the client, effectively disconnecting
     * from the user's account. Applications should call this when the user opts to
     * sign out.
     *
     * The persisted account state after calling this method will contain only the
     * user's last-seen profile information, if any. This may be useful in helping
     * the user to reconnnect to their account. If reconnecting to the same account
     * is not desired then the application should discard the persisted account state.

     */
    func disconnect() 
    
    /**
     * Ensure that the device record has a specific set of capabilities.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method checks that the currently-registered device record is advertising the
     * given set of capabilities in the FxA "device commands" ecosystem. If not, then it
     * updates the device record to do so.
     *
     * Applications should call this method on each startup as a way to ensure that their
     * expected set of capabilities is being accurately reflected on the FxA server, and
     * to handle the rollout of new capabilities over time.
     *
     * # Arguments
     *
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func ensureCapabilities(supportedCapabilities: [DeviceCapability]) throws  -> LocalDevice
    
    /**
     * Collect and return telemetry about incoming and outgoing device commands.
     *
     * Applications that have registered one or more [`DeviceCapability`]s
     * should also arrange to submit "sync ping" telemetry. Calling this method will
     * return a JSON string of telemetry data that can be incorporated into that ping.
     *
     * Sorry, this is not particularly carefully documented because it is intended
     * as a stop-gap until we get native Glean support. If you know how to submit
     * a sync ping, you'll know what to do with the contents of the JSON string.

     */
    func gatherTelemetry() throws  -> String
    
    /**
     * Get a short-lived OAuth access token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that need to access resources on behalf of the user must obtain an
     * `access_token` in order to do so. For example, an access token is required when
     * fetching the user's profile data, or when accessing their data stored in Firefox Sync.
     *
     * This method will obtain and return an access token bearing the requested scopes, either
     * from a local cache of previously-issued tokens, or by creating a new one from the server.
     *
     * # Arguments
     *
     *    - `scope` - the OAuth scope to be granted by the token.
     *        - This must be one of the scopes requested during the signin flow.
     *        - Only a single scope is supported; for multiple scopes request multiple tokens.
     *    - `ttl` - optionally, the time for which the token should be valid, in seconds.
     *
     * # Notes
     *
     *    - If the application receives an authorization error when trying to use the resulting
     *      token, it should call [`clear_access_token_cache`](FirefoxAccount::clear_access_token_cache)
     *      before requesting a fresh token.

     */
    func getAccessToken(scope: String, ttl: Int64?) throws  -> AccessTokenInfo
    
    /**
     * Get the list of all client applications attached to the user's account.
     *
     * This method returns a list of [`AttachedClient`] structs representing all the applications
     * connected to the user's account. This includes applications that are registered as a device
     * as well as server-side services that the user has connected.
     *
     * This information is really only useful for targeted messaging or marketing purposes,
     * e.g. if the application wants to advertize a related product, but first wants to check
     * whether the user is already using that product.
     *
     * # Notes
     *
     *    - Attached client metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func getAttachedClients() throws  -> [AttachedClient]
    
    /**
     * Get the high-level authentication state of the client
     *
     * Deprecated: Use get_state() instead
     */
    func getAuthState()  -> FxaRustAuthState
    
    /**
     * Get a URL which shows a "successfully connceted!" message.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications can use this method after a successful signin, to redirect the
     * user to a success message displayed in web content rather than having to
     * implement their own native success UI.

     */
    func getConnectionSuccessUrl() throws  -> String
    
    /**
     * Get the device id registered for this application.
     *
     * # Notes
     *
     *    - If the application has not registered a device record, this method will
     *      throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func getCurrentDeviceId() throws  -> String
    
    /**
     * Get the list of devices registered on the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method returns a list of [`Device`] structs representing all the devices
     * currently attached to the user's account (including the current device).
     * The application might use this information to e.g. display a list of appropriate
     * send-tab targets.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func getDevices(ignoreCache: Bool) throws  -> [Device]
    
    /**
     * Get a URL at which the user can manage their account and profile data.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
    func getManageAccountUrl(entrypoint: String) throws  -> String
    
    /**
     * Get a URL at which the user can manage the devices connected to their account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI. For example, "Manage your devices..." may be
     * a useful link to place somewhere near the device list in the send-tab UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
    func getManageDevicesUrl(entrypoint: String) throws  -> String
    
    /**
     * Get the URL at which to begin a device-pairing signin flow.
     *
     * If the user wants to sign in using device pairing, call this method and then
     * direct them to visit the resulting URL on an already-signed-in device. Doing
     * so will trigger the other device to show a QR code to be scanned, and the result
     * from said QR code can be passed to [`begin_pairing_flow`](FirefoxAccount::begin_pairing_flow).

     */
    func getPairingAuthorityUrl() throws  -> String
    
    /**
     * Get profile information for the signed-in user, if any.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method fetches a [`Profile`] struct with information about the currently-signed-in
     * user, either by using locally-cached profile information or by fetching fresh data from
     * the server.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Profile information is only available to applications that have been
     *      granted the `profile` scope.
     *    - There is currently no API for fetching cached profile information without
     *      potentially hitting the server.
     *    - If there is no signed-in user, this method will throw an
     *      [`Authentication`](FxaError::Authentication) error.

     */
    func getProfile(ignoreCache: Bool) throws  -> Profile
    
    /**
     * Get the session token for the user's account, if one is available.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that they can retrieve
     * it an pass it back to said web content when required.
     *
     * # Notes
     *
     *    - Please do not attempt to use the resulting token to directly make calls to the
     *      Firefox Accounts servers! All account management functionality should be performed
     *      in web content.
     *    - A session token is only available to applications that have requested the
     *      `https:///identity.mozilla.com/tokens/session` scope.

     */
    func getSessionToken() throws  -> String
    
    /**
     * Get the current state
     */
    func getState()  -> FxaState
    
    /**
     * Get the URL at which to access the user's sync data.
     *
     * **💾 This method alters the persisted account state.**

     */
    func getTokenServerEndpointUrl() throws  -> String
    
    /**
     * Process and respond to a server-delivered account update message
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should call this method whenever they receive a push notification from the Firefox Accounts server.
     * Such messages typically indicate a noteworthy change of state on the user's account, such as an update to their profile information
     * or the disconnection of a client. The [`FirefoxAccount`] struct will update its internal state
     * accordingly and return an individual [`AccountEvent`] struct describing the event, which the application
     * may use for further processing.
     *
     * It's important to note if the event is [`AccountEvent::CommandReceived`], the caller should call
     * [`FirefoxAccount::poll_device_commands`]

     */
    func handlePushMessage(payload: String) throws  -> AccountEvent
    
    /**
     * Update the stored session token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that said web content
     * signals that it has generated a new session token, the stored value can be updated
     * to match.
     *
     * # Arguments
     *
     *    - `session_token` - the new session token value provided from web content.

     */
    func handleSessionTokenChange(sessionToken: String) throws 
    
    /**
     * Create a new device record for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registered a device record for the application, providing basic metadata for
     * the device along with a list of supported [Device Capabilities](DeviceCapability) for
     * participating in the "device commands" ecosystem.
     *
     * Applications should call this method soon after a successful sign-in, to ensure
     * they they appear correctly in the user's account-management pages and when discovered
     * by other devices connected to the account.
     *
     * # Arguments
     *
     *    - `name` - human-readable display name to use for this application
     *    - `device_type` - the [type](DeviceType) of device the application is installed on
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func initializeDevice(name: String, deviceType: DeviceType, supportedCapabilities: [DeviceCapability]) throws  -> LocalDevice
    
    /**
     * Update the state based on authentication issues.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Call this if you know there's an authentication / authorization issue that requires the
     * user to re-authenticated.  It transitions the user to the [FxaRustAuthState.AuthIssues] state.
     */
    func onAuthIssues() 
    
    /**
     * Poll the server for any pending device commands.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that have registered one or more [`DeviceCapability`]s with the server can use
     * this method to check whether other devices on the account have sent them any commands.
     * It will return a list of [`IncomingDeviceCommand`] structs for the application to process.
     *
     * # Notes
     *
     *    - Device commands are typically delivered via push message and the [`CommandReceived`](
     *      AccountEvent::CommandReceived) event. Polling should only be used as a backup delivery
     *      mechanism, f the application has reason to believe that push messages may have been missed.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func pollDeviceCommands() throws  -> [IncomingDeviceCommand]
    
    /**
     * Process an event (login, logout, etc).
     *
     * On success, update the current state and return it.
     * On error, the current state will remain the same.
     */
    func processEvent(event: FxaEvent) throws  -> FxaState
    
    /**
     * Use device commands to send a single tab to another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`SendTab`](DeviceCapability::SendTab)
     * capability, this method can be used to send it a tab.
     *
     * # Notes
     *
     *    - If the given device id does not existing or is not capable of receiving tabs,
     *      this method will throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - It is not currently possible to send a full [`SendTabPayload`] to another device,
     *      but that's purely an API limitation that should go away in future.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func sendSingleTab(targetDeviceId: String, title: String, url: String) throws 
    
    /**
     * Update the display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method modifies the name of the current application's device record, as seen by
     * other applications and in the user's account management pages.
     *
     * # Arguments
     *
     *    - `display_name` - the new name for the current device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func setDeviceName(displayName: String) throws  -> LocalDevice
    
    /**
     * Set or update a push subscription endpoint for this device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registers the given webpush subscription with the FxA server, requesting
     * that is send notifications in the event of any significant changes to the user's
     * account. When the application receives a push message at the registered subscription
     * endpoint, it should decrypt the payload and pass it to the [`handle_push_message`](
     * FirefoxAccount::handle_push_message) method for processing.
     *
     * # Arguments
     *
     *    - `subscription` - the [`DevicePushSubscription`] details to register with the server.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    func setPushSubscription(subscription: DevicePushSubscription) throws  -> LocalDevice
    
    /**
     * Sets the users information based on the web content's login information
     * This is intended to only be used by user agents (eg: Firefox) to set the users
     * session token and tie it to the refresh token that will be issued at the end of the
     * oauth flow.
     */
    func setUserData(userData: UserData) 
    
    /**
     * Used by the application to test auth token issues
     */
    func simulateNetworkError() 
    
    /**
     * Used by the application to test auth token issues
     */
    func simulatePermanentAuthTokenIssue() 
    
    /**
     * Used by the application to test auth token issues
     */
    func simulateTemporaryAuthTokenIssue() 
    
    /**
     * Save current state to a JSON string.
     *
     * This method serializes the current account state into a JSON string, which
     * the application can use to persist the user's signed-in state across restarts.
     * The application should call this method and update its persisted state after
     * any potentially-state-changing operation.
     *
     * **⚠️ Warning:** the serialized state may contain encryption keys and access
     * tokens that let anyone holding them access the user's data in Firefox Sync
     * and/or other FxA services. Applications should take care to store the resulting
     * data in a secure fashion, as appropriate for their target platform.

     */
    func toJson() throws  -> String
    
}
/**
 * Object representing the signed-in state of an application.
 *
 * The `FirefoxAccount` object is the main interface provided by this crate.
 * It represents the signed-in state of an application that may be connected to
 * user's Firefox Account, and provides methods for inspecting the state of the
 * account and accessing other services on behalf of the user.

 */
open class FirefoxAccount: FirefoxAccountProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_fxa_client_fn_clone_firefoxaccount(self.pointer, $0) }
    }
    /**
     * Create a new [`FirefoxAccount`] instance, not connected to any account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method constructs as new [`FirefoxAccount`] instance configured to connect
     * the application to a user's account.
     */
public convenience init(config: FxaConfig) {
    let pointer =
        try! rustCall() {
    uniffi_fxa_client_fn_constructor_firefoxaccount_new(
        FfiConverterTypeFxaConfig_lower(config),$0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_fxa_client_fn_free_firefoxaccount(pointer, $0) }
    }

    
    /**
     * Restore a [`FirefoxAccount`] instance from serialized state.
     *
     * Given a JSON string previously obtained from [`FirefoxAccount::to_json`], this
     * method will deserialize it and return a live [`FirefoxAccount`] instance.
     *
     * **⚠️ Warning:** since the serialized state contains access tokens, you should
     * not call `from_json` multiple times on the same data. This would result
     * in multiple live objects sharing the same access tokens and is likely to
     * produce unexpected behaviour.

     */
public static func fromJson(data: String)throws  -> FirefoxAccount  {
    return try  FfiConverterTypeFirefoxAccount_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_constructor_firefoxaccount_from_json(
        FfiConverterString.lower(data),$0
    )
})
}
    

    
    /**
     * Create a new OAuth authorization code using the stored session token.
     *
     * When a signed-in application receives an incoming device pairing request, it can
     * use this method to grant the request and generate a corresponding OAuth authorization
     * code. This code would then be passed back to the connecting device over the
     * pairing channel (a process which is not currently supported by any code in this
     * component).
     *
     * # Arguments
     *
     *    - `params` - the OAuth parameters from the incoming authorization request

     */
open func authorizeCodeUsingSessionToken(params: AuthorizationParameters)throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_authorize_code_using_session_token(self.uniffiClonePointer(),
        FfiConverterTypeAuthorizationParameters_lower(params),$0
    )
})
}
    
    /**
     * Initiate a web-based OAuth sign-in flow.
     *
     * This method initializes some internal state and then returns a URL at which the
     * user may perform a web-based authorization flow to connect the application to
     * their account. The application should direct the user to the provided URL.
     *
     * When the resulting OAuth flow redirects back to the configured `redirect_uri`,
     * the query parameters should be extracting from the URL and passed to the
     * [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) method to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
open func beginOauthFlow(scopes: [String], entrypoint: String)throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_begin_oauth_flow(self.uniffiClonePointer(),
        FfiConverterSequenceString.lower(scopes),
        FfiConverterString.lower(entrypoint),$0
    )
})
}
    
    /**
     * Initiate a device-pairing sign-in flow.
     *
     * Once the user has scanned a pairing QR code, pass the scanned value to this
     * method. It will return a URL to which the application should redirect the user
     * in order to continue the sign-in flow.
     *
     * When the resulting flow redirects back to the configured `redirect_uri`,
     * the resulting OAuth parameters should be extracting from the URL and passed
     * to [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `pairing_url` - the URL scanned from a QR code on another device.
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
open func beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String)throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_begin_pairing_flow(self.uniffiClonePointer(),
        FfiConverterString.lower(pairingUrl),
        FfiConverterSequenceString.lower(scopes),
        FfiConverterString.lower(entrypoint),$0
    )
})
}
    
    /**
     * Check authorization status for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications may call this method to check with the FxA server about the status
     * of their authentication tokens. It returns an [`AuthorizationInfo`] struct
     * with details about whether the tokens are still active.

     */
open func checkAuthorizationStatus()throws  -> AuthorizationInfo  {
    return try  FfiConverterTypeAuthorizationInfo_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_check_authorization_status(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Clear the access token cache in response to an auth failure.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that receive an authentication error when trying to use an access token,
     * should call this method before creating a new token and retrying the failed operation.
     * It ensures that the expired token is removed and a fresh one generated.

     */
open func clearAccessTokenCache()  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_clear_access_token_cache(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Clear any custom display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method clears the name of the current application's device record, causing other
     * applications or the user's account management pages to have to fill in some sort of
     * default name when displaying this device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func clearDeviceName()throws   {try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_clear_device_name(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Use device commands to close one or more tabs on another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`CloseTabs`](DeviceCapability::CloseTabs)
     * capability, this method can be used to close its tabs.
     */
open func closeTabs(targetDeviceId: String, urls: [String])throws  -> CloseTabsResult  {
    return try  FfiConverterTypeCloseTabsResult_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_close_tabs(self.uniffiClonePointer(),
        FfiConverterString.lower(targetDeviceId),
        FfiConverterSequenceString.lower(urls),$0
    )
})
}
    
    /**
     * Complete an OAuth flow.
     *
     * **💾 This method alters the persisted account state.**
     *
     * At the conclusion of an OAuth flow, the user will be redirect to the
     * application's registered `redirect_uri`. It should extract the `code`
     * and `state` parameters from the resulting URL and pass them to this
     * method in order to complete the sign-in.
     *
     * # Arguments
     *
     *   - `code` - the OAuth authorization code obtained from the redirect URI.
     *   - `state` - the OAuth state parameter obtained from the redirect URI.

     */
open func completeOauthFlow(code: String, state: String)throws   {try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_complete_oauth_flow(self.uniffiClonePointer(),
        FfiConverterString.lower(code),
        FfiConverterString.lower(state),$0
    )
}
}
    
    /**
     * Disconnect from the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method destroys any tokens held by the client, effectively disconnecting
     * from the user's account. Applications should call this when the user opts to
     * sign out.
     *
     * The persisted account state after calling this method will contain only the
     * user's last-seen profile information, if any. This may be useful in helping
     * the user to reconnnect to their account. If reconnecting to the same account
     * is not desired then the application should discard the persisted account state.

     */
open func disconnect()  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_disconnect(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Ensure that the device record has a specific set of capabilities.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method checks that the currently-registered device record is advertising the
     * given set of capabilities in the FxA "device commands" ecosystem. If not, then it
     * updates the device record to do so.
     *
     * Applications should call this method on each startup as a way to ensure that their
     * expected set of capabilities is being accurately reflected on the FxA server, and
     * to handle the rollout of new capabilities over time.
     *
     * # Arguments
     *
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func ensureCapabilities(supportedCapabilities: [DeviceCapability])throws  -> LocalDevice  {
    return try  FfiConverterTypeLocalDevice_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_ensure_capabilities(self.uniffiClonePointer(),
        FfiConverterSequenceTypeDeviceCapability.lower(supportedCapabilities),$0
    )
})
}
    
    /**
     * Collect and return telemetry about incoming and outgoing device commands.
     *
     * Applications that have registered one or more [`DeviceCapability`]s
     * should also arrange to submit "sync ping" telemetry. Calling this method will
     * return a JSON string of telemetry data that can be incorporated into that ping.
     *
     * Sorry, this is not particularly carefully documented because it is intended
     * as a stop-gap until we get native Glean support. If you know how to submit
     * a sync ping, you'll know what to do with the contents of the JSON string.

     */
open func gatherTelemetry()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_gather_telemetry(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get a short-lived OAuth access token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that need to access resources on behalf of the user must obtain an
     * `access_token` in order to do so. For example, an access token is required when
     * fetching the user's profile data, or when accessing their data stored in Firefox Sync.
     *
     * This method will obtain and return an access token bearing the requested scopes, either
     * from a local cache of previously-issued tokens, or by creating a new one from the server.
     *
     * # Arguments
     *
     *    - `scope` - the OAuth scope to be granted by the token.
     *        - This must be one of the scopes requested during the signin flow.
     *        - Only a single scope is supported; for multiple scopes request multiple tokens.
     *    - `ttl` - optionally, the time for which the token should be valid, in seconds.
     *
     * # Notes
     *
     *    - If the application receives an authorization error when trying to use the resulting
     *      token, it should call [`clear_access_token_cache`](FirefoxAccount::clear_access_token_cache)
     *      before requesting a fresh token.

     */
open func getAccessToken(scope: String, ttl: Int64? = nil)throws  -> AccessTokenInfo  {
    return try  FfiConverterTypeAccessTokenInfo_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_access_token(self.uniffiClonePointer(),
        FfiConverterString.lower(scope),
        FfiConverterOptionInt64.lower(ttl),$0
    )
})
}
    
    /**
     * Get the list of all client applications attached to the user's account.
     *
     * This method returns a list of [`AttachedClient`] structs representing all the applications
     * connected to the user's account. This includes applications that are registered as a device
     * as well as server-side services that the user has connected.
     *
     * This information is really only useful for targeted messaging or marketing purposes,
     * e.g. if the application wants to advertize a related product, but first wants to check
     * whether the user is already using that product.
     *
     * # Notes
     *
     *    - Attached client metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func getAttachedClients()throws  -> [AttachedClient]  {
    return try  FfiConverterSequenceTypeAttachedClient.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_attached_clients(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get the high-level authentication state of the client
     *
     * Deprecated: Use get_state() instead
     */
open func getAuthState() -> FxaRustAuthState  {
    return try!  FfiConverterTypeFxaRustAuthState_lift(try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_get_auth_state(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get a URL which shows a "successfully connceted!" message.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications can use this method after a successful signin, to redirect the
     * user to a success message displayed in web content rather than having to
     * implement their own native success UI.

     */
open func getConnectionSuccessUrl()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_connection_success_url(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get the device id registered for this application.
     *
     * # Notes
     *
     *    - If the application has not registered a device record, this method will
     *      throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func getCurrentDeviceId()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_current_device_id(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get the list of devices registered on the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method returns a list of [`Device`] structs representing all the devices
     * currently attached to the user's account (including the current device).
     * The application might use this information to e.g. display a list of appropriate
     * send-tab targets.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func getDevices(ignoreCache: Bool)throws  -> [Device]  {
    return try  FfiConverterSequenceTypeDevice.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_devices(self.uniffiClonePointer(),
        FfiConverterBool.lower(ignoreCache),$0
    )
})
}
    
    /**
     * Get a URL at which the user can manage their account and profile data.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
open func getManageAccountUrl(entrypoint: String)throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_manage_account_url(self.uniffiClonePointer(),
        FfiConverterString.lower(entrypoint),$0
    )
})
}
    
    /**
     * Get a URL at which the user can manage the devices connected to their account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI. For example, "Manage your devices..." may be
     * a useful link to place somewhere near the device list in the send-tab UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
open func getManageDevicesUrl(entrypoint: String)throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_manage_devices_url(self.uniffiClonePointer(),
        FfiConverterString.lower(entrypoint),$0
    )
})
}
    
    /**
     * Get the URL at which to begin a device-pairing signin flow.
     *
     * If the user wants to sign in using device pairing, call this method and then
     * direct them to visit the resulting URL on an already-signed-in device. Doing
     * so will trigger the other device to show a QR code to be scanned, and the result
     * from said QR code can be passed to [`begin_pairing_flow`](FirefoxAccount::begin_pairing_flow).

     */
open func getPairingAuthorityUrl()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_pairing_authority_url(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get profile information for the signed-in user, if any.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method fetches a [`Profile`] struct with information about the currently-signed-in
     * user, either by using locally-cached profile information or by fetching fresh data from
     * the server.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Profile information is only available to applications that have been
     *      granted the `profile` scope.
     *    - There is currently no API for fetching cached profile information without
     *      potentially hitting the server.
     *    - If there is no signed-in user, this method will throw an
     *      [`Authentication`](FxaError::Authentication) error.

     */
open func getProfile(ignoreCache: Bool)throws  -> Profile  {
    return try  FfiConverterTypeProfile_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_profile(self.uniffiClonePointer(),
        FfiConverterBool.lower(ignoreCache),$0
    )
})
}
    
    /**
     * Get the session token for the user's account, if one is available.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that they can retrieve
     * it an pass it back to said web content when required.
     *
     * # Notes
     *
     *    - Please do not attempt to use the resulting token to directly make calls to the
     *      Firefox Accounts servers! All account management functionality should be performed
     *      in web content.
     *    - A session token is only available to applications that have requested the
     *      `https:///identity.mozilla.com/tokens/session` scope.

     */
open func getSessionToken()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_session_token(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get the current state
     */
open func getState() -> FxaState  {
    return try!  FfiConverterTypeFxaState_lift(try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_get_state(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Get the URL at which to access the user's sync data.
     *
     * **💾 This method alters the persisted account state.**

     */
open func getTokenServerEndpointUrl()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_get_token_server_endpoint_url(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Process and respond to a server-delivered account update message
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should call this method whenever they receive a push notification from the Firefox Accounts server.
     * Such messages typically indicate a noteworthy change of state on the user's account, such as an update to their profile information
     * or the disconnection of a client. The [`FirefoxAccount`] struct will update its internal state
     * accordingly and return an individual [`AccountEvent`] struct describing the event, which the application
     * may use for further processing.
     *
     * It's important to note if the event is [`AccountEvent::CommandReceived`], the caller should call
     * [`FirefoxAccount::poll_device_commands`]

     */
open func handlePushMessage(payload: String)throws  -> AccountEvent  {
    return try  FfiConverterTypeAccountEvent_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_handle_push_message(self.uniffiClonePointer(),
        FfiConverterString.lower(payload),$0
    )
})
}
    
    /**
     * Update the stored session token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that said web content
     * signals that it has generated a new session token, the stored value can be updated
     * to match.
     *
     * # Arguments
     *
     *    - `session_token` - the new session token value provided from web content.

     */
open func handleSessionTokenChange(sessionToken: String)throws   {try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_handle_session_token_change(self.uniffiClonePointer(),
        FfiConverterString.lower(sessionToken),$0
    )
}
}
    
    /**
     * Create a new device record for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registered a device record for the application, providing basic metadata for
     * the device along with a list of supported [Device Capabilities](DeviceCapability) for
     * participating in the "device commands" ecosystem.
     *
     * Applications should call this method soon after a successful sign-in, to ensure
     * they they appear correctly in the user's account-management pages and when discovered
     * by other devices connected to the account.
     *
     * # Arguments
     *
     *    - `name` - human-readable display name to use for this application
     *    - `device_type` - the [type](DeviceType) of device the application is installed on
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func initializeDevice(name: String, deviceType: DeviceType, supportedCapabilities: [DeviceCapability])throws  -> LocalDevice  {
    return try  FfiConverterTypeLocalDevice_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_initialize_device(self.uniffiClonePointer(),
        FfiConverterString.lower(name),
        FfiConverterTypeDeviceType_lower(deviceType),
        FfiConverterSequenceTypeDeviceCapability.lower(supportedCapabilities),$0
    )
})
}
    
    /**
     * Update the state based on authentication issues.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Call this if you know there's an authentication / authorization issue that requires the
     * user to re-authenticated.  It transitions the user to the [FxaRustAuthState.AuthIssues] state.
     */
open func onAuthIssues()  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_on_auth_issues(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Poll the server for any pending device commands.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that have registered one or more [`DeviceCapability`]s with the server can use
     * this method to check whether other devices on the account have sent them any commands.
     * It will return a list of [`IncomingDeviceCommand`] structs for the application to process.
     *
     * # Notes
     *
     *    - Device commands are typically delivered via push message and the [`CommandReceived`](
     *      AccountEvent::CommandReceived) event. Polling should only be used as a backup delivery
     *      mechanism, f the application has reason to believe that push messages may have been missed.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func pollDeviceCommands()throws  -> [IncomingDeviceCommand]  {
    return try  FfiConverterSequenceTypeIncomingDeviceCommand.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_poll_device_commands(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Process an event (login, logout, etc).
     *
     * On success, update the current state and return it.
     * On error, the current state will remain the same.
     */
open func processEvent(event: FxaEvent)throws  -> FxaState  {
    return try  FfiConverterTypeFxaState_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_process_event(self.uniffiClonePointer(),
        FfiConverterTypeFxaEvent_lower(event),$0
    )
})
}
    
    /**
     * Use device commands to send a single tab to another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`SendTab`](DeviceCapability::SendTab)
     * capability, this method can be used to send it a tab.
     *
     * # Notes
     *
     *    - If the given device id does not existing or is not capable of receiving tabs,
     *      this method will throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - It is not currently possible to send a full [`SendTabPayload`] to another device,
     *      but that's purely an API limitation that should go away in future.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func sendSingleTab(targetDeviceId: String, title: String, url: String)throws   {try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_send_single_tab(self.uniffiClonePointer(),
        FfiConverterString.lower(targetDeviceId),
        FfiConverterString.lower(title),
        FfiConverterString.lower(url),$0
    )
}
}
    
    /**
     * Update the display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method modifies the name of the current application's device record, as seen by
     * other applications and in the user's account management pages.
     *
     * # Arguments
     *
     *    - `display_name` - the new name for the current device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func setDeviceName(displayName: String)throws  -> LocalDevice  {
    return try  FfiConverterTypeLocalDevice_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_set_device_name(self.uniffiClonePointer(),
        FfiConverterString.lower(displayName),$0
    )
})
}
    
    /**
     * Set or update a push subscription endpoint for this device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registers the given webpush subscription with the FxA server, requesting
     * that is send notifications in the event of any significant changes to the user's
     * account. When the application receives a push message at the registered subscription
     * endpoint, it should decrypt the payload and pass it to the [`handle_push_message`](
     * FirefoxAccount::handle_push_message) method for processing.
     *
     * # Arguments
     *
     *    - `subscription` - the [`DevicePushSubscription`] details to register with the server.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
open func setPushSubscription(subscription: DevicePushSubscription)throws  -> LocalDevice  {
    return try  FfiConverterTypeLocalDevice_lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_set_push_subscription(self.uniffiClonePointer(),
        FfiConverterTypeDevicePushSubscription_lower(subscription),$0
    )
})
}
    
    /**
     * Sets the users information based on the web content's login information
     * This is intended to only be used by user agents (eg: Firefox) to set the users
     * session token and tie it to the refresh token that will be issued at the end of the
     * oauth flow.
     */
open func setUserData(userData: UserData)  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_set_user_data(self.uniffiClonePointer(),
        FfiConverterTypeUserData_lower(userData),$0
    )
}
}
    
    /**
     * Used by the application to test auth token issues
     */
open func simulateNetworkError()  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_simulate_network_error(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Used by the application to test auth token issues
     */
open func simulatePermanentAuthTokenIssue()  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_simulate_permanent_auth_token_issue(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Used by the application to test auth token issues
     */
open func simulateTemporaryAuthTokenIssue()  {try! rustCall() {
    uniffi_fxa_client_fn_method_firefoxaccount_simulate_temporary_auth_token_issue(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Save current state to a JSON string.
     *
     * This method serializes the current account state into a JSON string, which
     * the application can use to persist the user's signed-in state across restarts.
     * The application should call this method and update its persisted state after
     * any potentially-state-changing operation.
     *
     * **⚠️ Warning:** the serialized state may contain encryption keys and access
     * tokens that let anyone holding them access the user's data in Firefox Sync
     * and/or other FxA services. Applications should take care to store the resulting
     * data in a secure fashion, as appropriate for their target platform.

     */
open func toJson()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeFxaError_lift) {
    uniffi_fxa_client_fn_method_firefoxaccount_to_json(self.uniffiClonePointer(),$0
    )
})
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFirefoxAccount: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = FirefoxAccount

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> FirefoxAccount {
        return FirefoxAccount(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: FirefoxAccount) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FirefoxAccount {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: FirefoxAccount, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFirefoxAccount_lift(_ pointer: UnsafeMutableRawPointer) throws -> FirefoxAccount {
    return try FfiConverterTypeFirefoxAccount.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFirefoxAccount_lower(_ value: FirefoxAccount) -> UnsafeMutableRawPointer {
    return FfiConverterTypeFirefoxAccount.lower(value)
}






/**
 * Machinery for dry-run testing of FxaAuthStateMachine
 *
 * Remove this once we've migrated the firefox-android and firefox-ios code to using FxaAuthStateMachine
 * https:///bugzilla.mozilla.org/show_bug.cgi?id=1867793
 */
public protocol FxaStateMachineCheckerProtocol: AnyObject {
    
    func checkInternalState(state: FxaStateCheckerState) 
    
    func checkPublicState(state: FxaState) 
    
    func handleInternalEvent(event: FxaStateCheckerEvent) 
    
    func handlePublicEvent(event: FxaEvent) 
    
}
/**
 * Machinery for dry-run testing of FxaAuthStateMachine
 *
 * Remove this once we've migrated the firefox-android and firefox-ios code to using FxaAuthStateMachine
 * https:///bugzilla.mozilla.org/show_bug.cgi?id=1867793
 */
open class FxaStateMachineChecker: FxaStateMachineCheckerProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_fxa_client_fn_clone_fxastatemachinechecker(self.pointer, $0) }
    }
public convenience init() {
    let pointer =
        try! rustCall() {
    uniffi_fxa_client_fn_constructor_fxastatemachinechecker_new($0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_fxa_client_fn_free_fxastatemachinechecker(pointer, $0) }
    }

    

    
open func checkInternalState(state: FxaStateCheckerState)  {try! rustCall() {
    uniffi_fxa_client_fn_method_fxastatemachinechecker_check_internal_state(self.uniffiClonePointer(),
        FfiConverterTypeFxaStateCheckerState_lower(state),$0
    )
}
}
    
open func checkPublicState(state: FxaState)  {try! rustCall() {
    uniffi_fxa_client_fn_method_fxastatemachinechecker_check_public_state(self.uniffiClonePointer(),
        FfiConverterTypeFxaState_lower(state),$0
    )
}
}
    
open func handleInternalEvent(event: FxaStateCheckerEvent)  {try! rustCall() {
    uniffi_fxa_client_fn_method_fxastatemachinechecker_handle_internal_event(self.uniffiClonePointer(),
        FfiConverterTypeFxaStateCheckerEvent_lower(event),$0
    )
}
}
    
open func handlePublicEvent(event: FxaEvent)  {try! rustCall() {
    uniffi_fxa_client_fn_method_fxastatemachinechecker_handle_public_event(self.uniffiClonePointer(),
        FfiConverterTypeFxaEvent_lower(event),$0
    )
}
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaStateMachineChecker: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = FxaStateMachineChecker

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> FxaStateMachineChecker {
        return FxaStateMachineChecker(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: FxaStateMachineChecker) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaStateMachineChecker {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: FxaStateMachineChecker, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaStateMachineChecker_lift(_ pointer: UnsafeMutableRawPointer) throws -> FxaStateMachineChecker {
    return try FfiConverterTypeFxaStateMachineChecker.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaStateMachineChecker_lower(_ value: FxaStateMachineChecker) -> UnsafeMutableRawPointer {
    return FfiConverterTypeFxaStateMachineChecker.lower(value)
}




/**
 * An OAuth access token, with its associated keys and metadata.
 *
 * This struct represents an FxA OAuth access token, which can be used to access a resource
 * or service on behalf of the user. For example, accessing the user's data in Firefox Sync
 * an access token for the scope `https:///identity.mozilla.com/apps/sync` along with the
 * associated encryption key.

 */
public struct AccessTokenInfo {
    /**
     * The scope of access granted by token.
     */
    public var scope: String
    /**
     * The access token itself.
     *
     * This is the value that should be included in the `Authorization` header when
     * accessing an OAuth protected resource on behalf of the user.
     */
    public var token: String
    /**
     * The client-side encryption key associated with this scope.
     *
     * **⚠️ Warning:** the value of this field should never be revealed outside of the
     * application. For example, it should never to sent to a server or logged in a log file.
     */
    public var key: ScopedKey?
    /**
     * The expiry time of the token, in seconds.
     *
     * This is the timestamp at which the token is set to expire, in seconds since
     * unix epoch. Note that it is a signed integer, for compatibility with languages
     * that do not have an unsigned integer type.
     *
     * This timestamp is for guidance only. Access tokens are not guaranteed to remain
     * value for any particular lengthof time, and consumers should be prepared to handle
     * auth failures even if the token has not yet expired.
     */
    public var expiresAt: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The scope of access granted by token.
         */scope: String, 
        /**
         * The access token itself.
         *
         * This is the value that should be included in the `Authorization` header when
         * accessing an OAuth protected resource on behalf of the user.
         */token: String, 
        /**
         * The client-side encryption key associated with this scope.
         *
         * **⚠️ Warning:** the value of this field should never be revealed outside of the
         * application. For example, it should never to sent to a server or logged in a log file.
         */key: ScopedKey?, 
        /**
         * The expiry time of the token, in seconds.
         *
         * This is the timestamp at which the token is set to expire, in seconds since
         * unix epoch. Note that it is a signed integer, for compatibility with languages
         * that do not have an unsigned integer type.
         *
         * This timestamp is for guidance only. Access tokens are not guaranteed to remain
         * value for any particular lengthof time, and consumers should be prepared to handle
         * auth failures even if the token has not yet expired.
         */expiresAt: Int64) {
        self.scope = scope
        self.token = token
        self.key = key
        self.expiresAt = expiresAt
    }
}

#if compiler(>=6)
extension AccessTokenInfo: Sendable {}
#endif


extension AccessTokenInfo: Equatable, Hashable {
    public static func ==(lhs: AccessTokenInfo, rhs: AccessTokenInfo) -> Bool {
        if lhs.scope != rhs.scope {
            return false
        }
        if lhs.token != rhs.token {
            return false
        }
        if lhs.key != rhs.key {
            return false
        }
        if lhs.expiresAt != rhs.expiresAt {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(scope)
        hasher.combine(token)
        hasher.combine(key)
        hasher.combine(expiresAt)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAccessTokenInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AccessTokenInfo {
        return
            try AccessTokenInfo(
                scope: FfiConverterString.read(from: &buf), 
                token: FfiConverterString.read(from: &buf), 
                key: FfiConverterOptionTypeScopedKey.read(from: &buf), 
                expiresAt: FfiConverterInt64.read(from: &buf)
        )
    }

    public static func write(_ value: AccessTokenInfo, into buf: inout [UInt8]) {
        FfiConverterString.write(value.scope, into: &buf)
        FfiConverterString.write(value.token, into: &buf)
        FfiConverterOptionTypeScopedKey.write(value.key, into: &buf)
        FfiConverterInt64.write(value.expiresAt, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAccessTokenInfo_lift(_ buf: RustBuffer) throws -> AccessTokenInfo {
    return try FfiConverterTypeAccessTokenInfo.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAccessTokenInfo_lower(_ value: AccessTokenInfo) -> RustBuffer {
    return FfiConverterTypeAccessTokenInfo.lower(value)
}


/**
 * A client connected to the user's account.
 *
 * This struct provides metadata about a client connected to the user's account.
 * Unlike the [`Device`] struct, "clients" encompasses both client-side and server-side
 * applications - basically anything where the user is able to sign in with their
 * Firefox Account.
 *
 *
 * This data would typically be used for targeted messaging purposes, catering the
 * contents of the message to what other applications the user has on their account.

 */
public struct AttachedClient {
    public var clientId: String?
    public var deviceId: String?
    public var deviceType: DeviceType
    public var isCurrentSession: Bool
    public var name: String?
    public var createdTime: Int64?
    public var lastAccessTime: Int64?
    public var scope: [String]?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(clientId: String?, deviceId: String?, deviceType: DeviceType, isCurrentSession: Bool, name: String?, createdTime: Int64?, lastAccessTime: Int64?, scope: [String]?) {
        self.clientId = clientId
        self.deviceId = deviceId
        self.deviceType = deviceType
        self.isCurrentSession = isCurrentSession
        self.name = name
        self.createdTime = createdTime
        self.lastAccessTime = lastAccessTime
        self.scope = scope
    }
}

#if compiler(>=6)
extension AttachedClient: Sendable {}
#endif


extension AttachedClient: Equatable, Hashable {
    public static func ==(lhs: AttachedClient, rhs: AttachedClient) -> Bool {
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.deviceId != rhs.deviceId {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.isCurrentSession != rhs.isCurrentSession {
            return false
        }
        if lhs.name != rhs.name {
            return false
        }
        if lhs.createdTime != rhs.createdTime {
            return false
        }
        if lhs.lastAccessTime != rhs.lastAccessTime {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(clientId)
        hasher.combine(deviceId)
        hasher.combine(deviceType)
        hasher.combine(isCurrentSession)
        hasher.combine(name)
        hasher.combine(createdTime)
        hasher.combine(lastAccessTime)
        hasher.combine(scope)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAttachedClient: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AttachedClient {
        return
            try AttachedClient(
                clientId: FfiConverterOptionString.read(from: &buf), 
                deviceId: FfiConverterOptionString.read(from: &buf), 
                deviceType: FfiConverterTypeDeviceType.read(from: &buf), 
                isCurrentSession: FfiConverterBool.read(from: &buf), 
                name: FfiConverterOptionString.read(from: &buf), 
                createdTime: FfiConverterOptionInt64.read(from: &buf), 
                lastAccessTime: FfiConverterOptionInt64.read(from: &buf), 
                scope: FfiConverterOptionSequenceString.read(from: &buf)
        )
    }

    public static func write(_ value: AttachedClient, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.clientId, into: &buf)
        FfiConverterOptionString.write(value.deviceId, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterBool.write(value.isCurrentSession, into: &buf)
        FfiConverterOptionString.write(value.name, into: &buf)
        FfiConverterOptionInt64.write(value.createdTime, into: &buf)
        FfiConverterOptionInt64.write(value.lastAccessTime, into: &buf)
        FfiConverterOptionSequenceString.write(value.scope, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAttachedClient_lift(_ buf: RustBuffer) throws -> AttachedClient {
    return try FfiConverterTypeAttachedClient.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAttachedClient_lower(_ value: AttachedClient) -> RustBuffer {
    return FfiConverterTypeAttachedClient.lower(value)
}


/**
 * Information about the authorization state of the application.
 *
 * This struct represents metadata about whether the application is currently
 * connected to the user's account.

 */
public struct AuthorizationInfo {
    public var active: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(active: Bool) {
        self.active = active
    }
}

#if compiler(>=6)
extension AuthorizationInfo: Sendable {}
#endif


extension AuthorizationInfo: Equatable, Hashable {
    public static func ==(lhs: AuthorizationInfo, rhs: AuthorizationInfo) -> Bool {
        if lhs.active != rhs.active {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(active)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAuthorizationInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AuthorizationInfo {
        return
            try AuthorizationInfo(
                active: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: AuthorizationInfo, into buf: inout [UInt8]) {
        FfiConverterBool.write(value.active, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAuthorizationInfo_lift(_ buf: RustBuffer) throws -> AuthorizationInfo {
    return try FfiConverterTypeAuthorizationInfo.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAuthorizationInfo_lower(_ value: AuthorizationInfo) -> RustBuffer {
    return FfiConverterTypeAuthorizationInfo.lower(value)
}


/**
 * Parameters provided in an incoming OAuth request.
 *
 * This struct represents parameters obtained from an incoming OAuth request - that is,
 * the values that an OAuth client would append to the authorization URL when initiating
 * an OAuth sign-in flow.

 */
public struct AuthorizationParameters {
    public var clientId: String
    public var scope: [String]
    public var state: String
    public var accessType: String
    public var codeChallenge: String?
    public var codeChallengeMethod: String?
    public var keysJwk: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(clientId: String, scope: [String], state: String, accessType: String, codeChallenge: String?, codeChallengeMethod: String?, keysJwk: String?) {
        self.clientId = clientId
        self.scope = scope
        self.state = state
        self.accessType = accessType
        self.codeChallenge = codeChallenge
        self.codeChallengeMethod = codeChallengeMethod
        self.keysJwk = keysJwk
    }
}

#if compiler(>=6)
extension AuthorizationParameters: Sendable {}
#endif


extension AuthorizationParameters: Equatable, Hashable {
    public static func ==(lhs: AuthorizationParameters, rhs: AuthorizationParameters) -> Bool {
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        if lhs.state != rhs.state {
            return false
        }
        if lhs.accessType != rhs.accessType {
            return false
        }
        if lhs.codeChallenge != rhs.codeChallenge {
            return false
        }
        if lhs.codeChallengeMethod != rhs.codeChallengeMethod {
            return false
        }
        if lhs.keysJwk != rhs.keysJwk {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(clientId)
        hasher.combine(scope)
        hasher.combine(state)
        hasher.combine(accessType)
        hasher.combine(codeChallenge)
        hasher.combine(codeChallengeMethod)
        hasher.combine(keysJwk)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAuthorizationParameters: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AuthorizationParameters {
        return
            try AuthorizationParameters(
                clientId: FfiConverterString.read(from: &buf), 
                scope: FfiConverterSequenceString.read(from: &buf), 
                state: FfiConverterString.read(from: &buf), 
                accessType: FfiConverterString.read(from: &buf), 
                codeChallenge: FfiConverterOptionString.read(from: &buf), 
                codeChallengeMethod: FfiConverterOptionString.read(from: &buf), 
                keysJwk: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: AuthorizationParameters, into buf: inout [UInt8]) {
        FfiConverterString.write(value.clientId, into: &buf)
        FfiConverterSequenceString.write(value.scope, into: &buf)
        FfiConverterString.write(value.state, into: &buf)
        FfiConverterString.write(value.accessType, into: &buf)
        FfiConverterOptionString.write(value.codeChallenge, into: &buf)
        FfiConverterOptionString.write(value.codeChallengeMethod, into: &buf)
        FfiConverterOptionString.write(value.keysJwk, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAuthorizationParameters_lift(_ buf: RustBuffer) throws -> AuthorizationParameters {
    return try FfiConverterTypeAuthorizationParameters.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAuthorizationParameters_lower(_ value: AuthorizationParameters) -> RustBuffer {
    return FfiConverterTypeAuthorizationParameters.lower(value)
}


/**
 * The payload sent when invoking a "close tabs" command.

 */
public struct CloseTabsPayload {
    /**
     * The URLs of the tabs to close.
     */
    public var urls: [String]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The URLs of the tabs to close.
         */urls: [String]) {
        self.urls = urls
    }
}

#if compiler(>=6)
extension CloseTabsPayload: Sendable {}
#endif


extension CloseTabsPayload: Equatable, Hashable {
    public static func ==(lhs: CloseTabsPayload, rhs: CloseTabsPayload) -> Bool {
        if lhs.urls != rhs.urls {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(urls)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCloseTabsPayload: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CloseTabsPayload {
        return
            try CloseTabsPayload(
                urls: FfiConverterSequenceString.read(from: &buf)
        )
    }

    public static func write(_ value: CloseTabsPayload, into buf: inout [UInt8]) {
        FfiConverterSequenceString.write(value.urls, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCloseTabsPayload_lift(_ buf: RustBuffer) throws -> CloseTabsPayload {
    return try FfiConverterTypeCloseTabsPayload.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCloseTabsPayload_lower(_ value: CloseTabsPayload) -> RustBuffer {
    return FfiConverterTypeCloseTabsPayload.lower(value)
}


/**
 * A device connected to the user's account.
 *
 * This struct provides metadata about a device connected to the user's account.
 * This data would typically be used to display e.g. the list of candidate devices
 * in a "send tab" menu.

 */
public struct Device {
    public var id: String
    public var displayName: String
    public var deviceType: DeviceType
    public var capabilities: [DeviceCapability]
    public var pushSubscription: DevicePushSubscription?
    public var pushEndpointExpired: Bool
    public var isCurrentDevice: Bool
    public var lastAccessTime: Int64?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, displayName: String, deviceType: DeviceType, capabilities: [DeviceCapability], pushSubscription: DevicePushSubscription?, pushEndpointExpired: Bool, isCurrentDevice: Bool, lastAccessTime: Int64?) {
        self.id = id
        self.displayName = displayName
        self.deviceType = deviceType
        self.capabilities = capabilities
        self.pushSubscription = pushSubscription
        self.pushEndpointExpired = pushEndpointExpired
        self.isCurrentDevice = isCurrentDevice
        self.lastAccessTime = lastAccessTime
    }
}

#if compiler(>=6)
extension Device: Sendable {}
#endif


extension Device: Equatable, Hashable {
    public static func ==(lhs: Device, rhs: Device) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.displayName != rhs.displayName {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.capabilities != rhs.capabilities {
            return false
        }
        if lhs.pushSubscription != rhs.pushSubscription {
            return false
        }
        if lhs.pushEndpointExpired != rhs.pushEndpointExpired {
            return false
        }
        if lhs.isCurrentDevice != rhs.isCurrentDevice {
            return false
        }
        if lhs.lastAccessTime != rhs.lastAccessTime {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(displayName)
        hasher.combine(deviceType)
        hasher.combine(capabilities)
        hasher.combine(pushSubscription)
        hasher.combine(pushEndpointExpired)
        hasher.combine(isCurrentDevice)
        hasher.combine(lastAccessTime)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeDevice: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Device {
        return
            try Device(
                id: FfiConverterString.read(from: &buf), 
                displayName: FfiConverterString.read(from: &buf), 
                deviceType: FfiConverterTypeDeviceType.read(from: &buf), 
                capabilities: FfiConverterSequenceTypeDeviceCapability.read(from: &buf), 
                pushSubscription: FfiConverterOptionTypeDevicePushSubscription.read(from: &buf), 
                pushEndpointExpired: FfiConverterBool.read(from: &buf), 
                isCurrentDevice: FfiConverterBool.read(from: &buf), 
                lastAccessTime: FfiConverterOptionInt64.read(from: &buf)
        )
    }

    public static func write(_ value: Device, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterString.write(value.displayName, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterSequenceTypeDeviceCapability.write(value.capabilities, into: &buf)
        FfiConverterOptionTypeDevicePushSubscription.write(value.pushSubscription, into: &buf)
        FfiConverterBool.write(value.pushEndpointExpired, into: &buf)
        FfiConverterBool.write(value.isCurrentDevice, into: &buf)
        FfiConverterOptionInt64.write(value.lastAccessTime, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDevice_lift(_ buf: RustBuffer) throws -> Device {
    return try FfiConverterTypeDevice.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDevice_lower(_ value: Device) -> RustBuffer {
    return FfiConverterTypeDevice.lower(value)
}


/**
 * Device configuration
 */
public struct DeviceConfig {
    public var name: String
    public var deviceType: DeviceType
    public var capabilities: [DeviceCapability]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(name: String, deviceType: DeviceType, capabilities: [DeviceCapability]) {
        self.name = name
        self.deviceType = deviceType
        self.capabilities = capabilities
    }
}

#if compiler(>=6)
extension DeviceConfig: Sendable {}
#endif


extension DeviceConfig: Equatable, Hashable {
    public static func ==(lhs: DeviceConfig, rhs: DeviceConfig) -> Bool {
        if lhs.name != rhs.name {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.capabilities != rhs.capabilities {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(name)
        hasher.combine(deviceType)
        hasher.combine(capabilities)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeDeviceConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DeviceConfig {
        return
            try DeviceConfig(
                name: FfiConverterString.read(from: &buf), 
                deviceType: FfiConverterTypeDeviceType.read(from: &buf), 
                capabilities: FfiConverterSequenceTypeDeviceCapability.read(from: &buf)
        )
    }

    public static func write(_ value: DeviceConfig, into buf: inout [UInt8]) {
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterSequenceTypeDeviceCapability.write(value.capabilities, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDeviceConfig_lift(_ buf: RustBuffer) throws -> DeviceConfig {
    return try FfiConverterTypeDeviceConfig.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDeviceConfig_lower(_ value: DeviceConfig) -> RustBuffer {
    return FfiConverterTypeDeviceConfig.lower(value)
}


/**
 * Details of a web-push subscription endpoint.
 *
 * This struct encapsulates the details of a web-push subscription endpoint,
 * including all the information necessary to send a notification to its owner.
 * Devices attached to the user's account may register one of these in order
 * to receive timely updates about account-related events.
 *
 * Managing a web-push subscription is outside of the scope of this component.

 */
public struct DevicePushSubscription {
    public var endpoint: String
    public var publicKey: String
    public var authKey: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(endpoint: String, publicKey: String, authKey: String) {
        self.endpoint = endpoint
        self.publicKey = publicKey
        self.authKey = authKey
    }
}

#if compiler(>=6)
extension DevicePushSubscription: Sendable {}
#endif


extension DevicePushSubscription: Equatable, Hashable {
    public static func ==(lhs: DevicePushSubscription, rhs: DevicePushSubscription) -> Bool {
        if lhs.endpoint != rhs.endpoint {
            return false
        }
        if lhs.publicKey != rhs.publicKey {
            return false
        }
        if lhs.authKey != rhs.authKey {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(endpoint)
        hasher.combine(publicKey)
        hasher.combine(authKey)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeDevicePushSubscription: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DevicePushSubscription {
        return
            try DevicePushSubscription(
                endpoint: FfiConverterString.read(from: &buf), 
                publicKey: FfiConverterString.read(from: &buf), 
                authKey: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: DevicePushSubscription, into buf: inout [UInt8]) {
        FfiConverterString.write(value.endpoint, into: &buf)
        FfiConverterString.write(value.publicKey, into: &buf)
        FfiConverterString.write(value.authKey, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDevicePushSubscription_lift(_ buf: RustBuffer) throws -> DevicePushSubscription {
    return try FfiConverterTypeDevicePushSubscription.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDevicePushSubscription_lower(_ value: DevicePushSubscription) -> RustBuffer {
    return FfiConverterTypeDevicePushSubscription.lower(value)
}


public struct FxaConfig {
    /**
     * FxaServer to connect with
     */
    public var server: FxaServer
    /**
     * Registered OAuth client id of the application.
     */
    public var clientId: String
    /**
     * `redirect_uri` - the registered OAuth redirect URI of the application.
     */
    public var redirectUri: String
    /**
     * URL for the user's Sync Tokenserver. This can be used to support users who self-host their
     * sync data. If `None` then it will default to the Mozilla-hosted Sync server.
     */
    public var tokenServerUrlOverride: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * FxaServer to connect with
         */server: FxaServer, 
        /**
         * Registered OAuth client id of the application.
         */clientId: String, 
        /**
         * `redirect_uri` - the registered OAuth redirect URI of the application.
         */redirectUri: String, 
        /**
         * URL for the user's Sync Tokenserver. This can be used to support users who self-host their
         * sync data. If `None` then it will default to the Mozilla-hosted Sync server.
         */tokenServerUrlOverride: String? = nil) {
        self.server = server
        self.clientId = clientId
        self.redirectUri = redirectUri
        self.tokenServerUrlOverride = tokenServerUrlOverride
    }
}

#if compiler(>=6)
extension FxaConfig: Sendable {}
#endif


extension FxaConfig: Equatable, Hashable {
    public static func ==(lhs: FxaConfig, rhs: FxaConfig) -> Bool {
        if lhs.server != rhs.server {
            return false
        }
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.redirectUri != rhs.redirectUri {
            return false
        }
        if lhs.tokenServerUrlOverride != rhs.tokenServerUrlOverride {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(server)
        hasher.combine(clientId)
        hasher.combine(redirectUri)
        hasher.combine(tokenServerUrlOverride)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaConfig {
        return
            try FxaConfig(
                server: FfiConverterTypeFxaServer.read(from: &buf), 
                clientId: FfiConverterString.read(from: &buf), 
                redirectUri: FfiConverterString.read(from: &buf), 
                tokenServerUrlOverride: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: FxaConfig, into buf: inout [UInt8]) {
        FfiConverterTypeFxaServer.write(value.server, into: &buf)
        FfiConverterString.write(value.clientId, into: &buf)
        FfiConverterString.write(value.redirectUri, into: &buf)
        FfiConverterOptionString.write(value.tokenServerUrlOverride, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaConfig_lift(_ buf: RustBuffer) throws -> FxaConfig {
    return try FfiConverterTypeFxaConfig.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaConfig_lower(_ value: FxaConfig) -> RustBuffer {
    return FfiConverterTypeFxaConfig.lower(value)
}


/**
 * Local device that's connecting to FxA
 *
 * This is returned by the device update methods and represents the server's view of the local
 * device.
 */
public struct LocalDevice {
    public var id: String
    public var displayName: String
    public var deviceType: DeviceType
    public var capabilities: [DeviceCapability]
    public var pushSubscription: DevicePushSubscription?
    public var pushEndpointExpired: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, displayName: String, deviceType: DeviceType, capabilities: [DeviceCapability], pushSubscription: DevicePushSubscription?, pushEndpointExpired: Bool) {
        self.id = id
        self.displayName = displayName
        self.deviceType = deviceType
        self.capabilities = capabilities
        self.pushSubscription = pushSubscription
        self.pushEndpointExpired = pushEndpointExpired
    }
}

#if compiler(>=6)
extension LocalDevice: Sendable {}
#endif


extension LocalDevice: Equatable, Hashable {
    public static func ==(lhs: LocalDevice, rhs: LocalDevice) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.displayName != rhs.displayName {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        if lhs.capabilities != rhs.capabilities {
            return false
        }
        if lhs.pushSubscription != rhs.pushSubscription {
            return false
        }
        if lhs.pushEndpointExpired != rhs.pushEndpointExpired {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(displayName)
        hasher.combine(deviceType)
        hasher.combine(capabilities)
        hasher.combine(pushSubscription)
        hasher.combine(pushEndpointExpired)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLocalDevice: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LocalDevice {
        return
            try LocalDevice(
                id: FfiConverterString.read(from: &buf), 
                displayName: FfiConverterString.read(from: &buf), 
                deviceType: FfiConverterTypeDeviceType.read(from: &buf), 
                capabilities: FfiConverterSequenceTypeDeviceCapability.read(from: &buf), 
                pushSubscription: FfiConverterOptionTypeDevicePushSubscription.read(from: &buf), 
                pushEndpointExpired: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: LocalDevice, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterString.write(value.displayName, into: &buf)
        FfiConverterTypeDeviceType.write(value.deviceType, into: &buf)
        FfiConverterSequenceTypeDeviceCapability.write(value.capabilities, into: &buf)
        FfiConverterOptionTypeDevicePushSubscription.write(value.pushSubscription, into: &buf)
        FfiConverterBool.write(value.pushEndpointExpired, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLocalDevice_lift(_ buf: RustBuffer) throws -> LocalDevice {
    return try FfiConverterTypeLocalDevice.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLocalDevice_lower(_ value: LocalDevice) -> RustBuffer {
    return FfiConverterTypeLocalDevice.lower(value)
}


/**
 * Information about the user that controls a Firefox Account.
 *
 * This struct represents details about the user themselves, and would typically be
 * used to customize account-related UI in the browser so that it is personalize
 * for the current user.

 */
public struct Profile {
    /**
     * The user's account uid
     *
     * This is an opaque immutable unique identifier for their account.
     */
    public var uid: String
    /**
     * The user's current primary email address.
     *
     * Note that unlike the `uid` field, the email address may change over time.
     */
    public var email: String
    /**
     * The user's preferred textual display name.
     */
    public var displayName: String?
    /**
     * The URL of a profile picture representing the user.
     *
     * All accounts have a corresponding profile picture. If the user has not
     * provided one then a default image is used.
     */
    public var avatar: String
    /**
     * Whether the `avatar` URL represents the default avatar image.
     */
    public var isDefaultAvatar: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The user's account uid
         *
         * This is an opaque immutable unique identifier for their account.
         */uid: String, 
        /**
         * The user's current primary email address.
         *
         * Note that unlike the `uid` field, the email address may change over time.
         */email: String, 
        /**
         * The user's preferred textual display name.
         */displayName: String?, 
        /**
         * The URL of a profile picture representing the user.
         *
         * All accounts have a corresponding profile picture. If the user has not
         * provided one then a default image is used.
         */avatar: String, 
        /**
         * Whether the `avatar` URL represents the default avatar image.
         */isDefaultAvatar: Bool) {
        self.uid = uid
        self.email = email
        self.displayName = displayName
        self.avatar = avatar
        self.isDefaultAvatar = isDefaultAvatar
    }
}

#if compiler(>=6)
extension Profile: Sendable {}
#endif


extension Profile: Equatable, Hashable {
    public static func ==(lhs: Profile, rhs: Profile) -> Bool {
        if lhs.uid != rhs.uid {
            return false
        }
        if lhs.email != rhs.email {
            return false
        }
        if lhs.displayName != rhs.displayName {
            return false
        }
        if lhs.avatar != rhs.avatar {
            return false
        }
        if lhs.isDefaultAvatar != rhs.isDefaultAvatar {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(uid)
        hasher.combine(email)
        hasher.combine(displayName)
        hasher.combine(avatar)
        hasher.combine(isDefaultAvatar)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeProfile: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Profile {
        return
            try Profile(
                uid: FfiConverterString.read(from: &buf), 
                email: FfiConverterString.read(from: &buf), 
                displayName: FfiConverterOptionString.read(from: &buf), 
                avatar: FfiConverterString.read(from: &buf), 
                isDefaultAvatar: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: Profile, into buf: inout [UInt8]) {
        FfiConverterString.write(value.uid, into: &buf)
        FfiConverterString.write(value.email, into: &buf)
        FfiConverterOptionString.write(value.displayName, into: &buf)
        FfiConverterString.write(value.avatar, into: &buf)
        FfiConverterBool.write(value.isDefaultAvatar, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeProfile_lift(_ buf: RustBuffer) throws -> Profile {
    return try FfiConverterTypeProfile.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeProfile_lower(_ value: Profile) -> RustBuffer {
    return FfiConverterTypeProfile.lower(value)
}


/**
 * A cryptographic key associated with an OAuth scope.
 *
 * Some OAuth scopes have a corresponding client-side encryption key that is required
 * in order to access protected data. This struct represents such key material in a
 * format compatible with the common "JWK" standard.

 */
public struct ScopedKey {
    /**
     * The type of key.
     *
     * In practice for FxA, this will always be string string "oct" (short for "octal")
     * to represent a raw symmetric key.
     */
    public var kty: String
    /**
     * The OAuth scope with which this key is associated.
     */
    public var scope: String
    /**
     * The key material, as base64-url-encoded bytes.
     *
     * **⚠️ Warning:** the value of this field should never be revealed outside of the
     * application. For example, it should never to sent to a server or logged in a log file.
     */
    public var k: String
    /**
     * An opaque unique identifier for this key.
     *
     * Unlike the `k` field, this value is not secret and may be revealed to the server.
     */
    public var kid: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The type of key.
         *
         * In practice for FxA, this will always be string string "oct" (short for "octal")
         * to represent a raw symmetric key.
         */kty: String, 
        /**
         * The OAuth scope with which this key is associated.
         */scope: String, 
        /**
         * The key material, as base64-url-encoded bytes.
         *
         * **⚠️ Warning:** the value of this field should never be revealed outside of the
         * application. For example, it should never to sent to a server or logged in a log file.
         */k: String, 
        /**
         * An opaque unique identifier for this key.
         *
         * Unlike the `k` field, this value is not secret and may be revealed to the server.
         */kid: String) {
        self.kty = kty
        self.scope = scope
        self.k = k
        self.kid = kid
    }
}

#if compiler(>=6)
extension ScopedKey: Sendable {}
#endif


extension ScopedKey: Equatable, Hashable {
    public static func ==(lhs: ScopedKey, rhs: ScopedKey) -> Bool {
        if lhs.kty != rhs.kty {
            return false
        }
        if lhs.scope != rhs.scope {
            return false
        }
        if lhs.k != rhs.k {
            return false
        }
        if lhs.kid != rhs.kid {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(kty)
        hasher.combine(scope)
        hasher.combine(k)
        hasher.combine(kid)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeScopedKey: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ScopedKey {
        return
            try ScopedKey(
                kty: FfiConverterString.read(from: &buf), 
                scope: FfiConverterString.read(from: &buf), 
                k: FfiConverterString.read(from: &buf), 
                kid: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: ScopedKey, into buf: inout [UInt8]) {
        FfiConverterString.write(value.kty, into: &buf)
        FfiConverterString.write(value.scope, into: &buf)
        FfiConverterString.write(value.k, into: &buf)
        FfiConverterString.write(value.kid, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeScopedKey_lift(_ buf: RustBuffer) throws -> ScopedKey {
    return try FfiConverterTypeScopedKey.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeScopedKey_lower(_ value: ScopedKey) -> RustBuffer {
    return FfiConverterTypeScopedKey.lower(value)
}


/**
 * The payload sent when invoking a "send tab" command.

 */
public struct SendTabPayload {
    /**
     * The navigation history of the sent tab.
     *
     * The last item in this list represents the page to be displayed,
     * while earlier items may be included in the navigation history
     * as a convenience to the user.
     */
    public var entries: [TabHistoryEntry]
    /**
     * A unique identifier to be included in send-tab metrics.
     *
     * The application should treat this as opaque.
     */
    public var flowId: String
    /**
     * A unique identifier to be included in send-tab metrics.
     *
     * The application should treat this as opaque.
     */
    public var streamId: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The navigation history of the sent tab.
         *
         * The last item in this list represents the page to be displayed,
         * while earlier items may be included in the navigation history
         * as a convenience to the user.
         */entries: [TabHistoryEntry], 
        /**
         * A unique identifier to be included in send-tab metrics.
         *
         * The application should treat this as opaque.
         */flowId: String = "", 
        /**
         * A unique identifier to be included in send-tab metrics.
         *
         * The application should treat this as opaque.
         */streamId: String = "") {
        self.entries = entries
        self.flowId = flowId
        self.streamId = streamId
    }
}

#if compiler(>=6)
extension SendTabPayload: Sendable {}
#endif


extension SendTabPayload: Equatable, Hashable {
    public static func ==(lhs: SendTabPayload, rhs: SendTabPayload) -> Bool {
        if lhs.entries != rhs.entries {
            return false
        }
        if lhs.flowId != rhs.flowId {
            return false
        }
        if lhs.streamId != rhs.streamId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(entries)
        hasher.combine(flowId)
        hasher.combine(streamId)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSendTabPayload: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SendTabPayload {
        return
            try SendTabPayload(
                entries: FfiConverterSequenceTypeTabHistoryEntry.read(from: &buf), 
                flowId: FfiConverterString.read(from: &buf), 
                streamId: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: SendTabPayload, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeTabHistoryEntry.write(value.entries, into: &buf)
        FfiConverterString.write(value.flowId, into: &buf)
        FfiConverterString.write(value.streamId, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSendTabPayload_lift(_ buf: RustBuffer) throws -> SendTabPayload {
    return try FfiConverterTypeSendTabPayload.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSendTabPayload_lower(_ value: SendTabPayload) -> RustBuffer {
    return FfiConverterTypeSendTabPayload.lower(value)
}


/**
 * An individual entry in the navigation history of a sent tab.

 */
public struct TabHistoryEntry {
    public var title: String
    public var url: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(title: String, url: String) {
        self.title = title
        self.url = url
    }
}

#if compiler(>=6)
extension TabHistoryEntry: Sendable {}
#endif


extension TabHistoryEntry: Equatable, Hashable {
    public static func ==(lhs: TabHistoryEntry, rhs: TabHistoryEntry) -> Bool {
        if lhs.title != rhs.title {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(title)
        hasher.combine(url)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeTabHistoryEntry: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> TabHistoryEntry {
        return
            try TabHistoryEntry(
                title: FfiConverterString.read(from: &buf), 
                url: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: TabHistoryEntry, into buf: inout [UInt8]) {
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterString.write(value.url, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeTabHistoryEntry_lift(_ buf: RustBuffer) throws -> TabHistoryEntry {
    return try FfiConverterTypeTabHistoryEntry.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeTabHistoryEntry_lower(_ value: TabHistoryEntry) -> RustBuffer {
    return FfiConverterTypeTabHistoryEntry.lower(value)
}


public struct UserData {
    public var sessionToken: String
    public var uid: String
    public var email: String
    public var verified: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(sessionToken: String, uid: String, email: String, verified: Bool) {
        self.sessionToken = sessionToken
        self.uid = uid
        self.email = email
        self.verified = verified
    }
}

#if compiler(>=6)
extension UserData: Sendable {}
#endif


extension UserData: Equatable, Hashable {
    public static func ==(lhs: UserData, rhs: UserData) -> Bool {
        if lhs.sessionToken != rhs.sessionToken {
            return false
        }
        if lhs.uid != rhs.uid {
            return false
        }
        if lhs.email != rhs.email {
            return false
        }
        if lhs.verified != rhs.verified {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(sessionToken)
        hasher.combine(uid)
        hasher.combine(email)
        hasher.combine(verified)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeUserData: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UserData {
        return
            try UserData(
                sessionToken: FfiConverterString.read(from: &buf), 
                uid: FfiConverterString.read(from: &buf), 
                email: FfiConverterString.read(from: &buf), 
                verified: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: UserData, into buf: inout [UInt8]) {
        FfiConverterString.write(value.sessionToken, into: &buf)
        FfiConverterString.write(value.uid, into: &buf)
        FfiConverterString.write(value.email, into: &buf)
        FfiConverterBool.write(value.verified, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeUserData_lift(_ buf: RustBuffer) throws -> UserData {
    return try FfiConverterTypeUserData.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeUserData_lower(_ value: UserData) -> RustBuffer {
    return FfiConverterTypeUserData.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * An event that happened on the user's account.
 *
 * If the application has registered a [`DevicePushSubscription`] as part of its
 * device record, then the Firefox Accounts server can send push notifications
 * about important events that happen on the user's account. This enum represents
 * the different kinds of event that can occur.

 */

public enum AccountEvent {
    
    /**
     * Sent when another device has invoked a command for this device to execute.
     *
     * When receiving this event, the application should inspect the contained
     * command and react appropriately.
     */
    case commandReceived(command: IncomingDeviceCommand
    )
    /**
     * Sent when the user has modified their account profile information.
     *
     * When receiving this event, the application should request fresh profile
     * information by calling [`get_profile`](FirefoxAccount::get_profile) with
     * `ignore_cache` set to true, and update any profile information displayed
     * in its UI.

     */
    case profileUpdated
    /**
     * Sent when when there has been a change in authorization status.
     *
     * When receiving this event, the application should check whether it is
     * still connected to the user's account by calling [`check_authorization_status`](
     * FirefoxAccount::check_authorization_status), and updating its UI as appropriate.

     */
    case accountAuthStateChanged
    /**
     * Sent when the user deletes their Firefox Account.
     *
     * When receiving this event, the application should act as though the user had
     * signed out, discarding any persisted account state.
     */
    case accountDestroyed
    /**
     * Sent when a new device connects to the user's account.
     *
     * When receiving this event, the application may use it to trigger an update
     * of any UI that shows the list of connected devices. It may also show the
     * user an informational notice about the new device, as a security measure.
     */
    case deviceConnected(deviceName: String
    )
    /**
     * Sent when a device disconnects from the user's account.
     *
     * When receiving this event, the application may use it to trigger an update
     * of any UI that shows the list of connected devices.
     */
    case deviceDisconnected(deviceId: String, isLocalDevice: Bool
    )
    /**
     * An unknown event, most likely an event the client doesn't support yet.
     *
     * When receiving this event, the application should gracefully ignore it.
     */
    case unknown
}


#if compiler(>=6)
extension AccountEvent: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAccountEvent: FfiConverterRustBuffer {
    typealias SwiftType = AccountEvent

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AccountEvent {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .commandReceived(command: try FfiConverterTypeIncomingDeviceCommand.read(from: &buf)
        )
        
        case 2: return .profileUpdated
        
        case 3: return .accountAuthStateChanged
        
        case 4: return .accountDestroyed
        
        case 5: return .deviceConnected(deviceName: try FfiConverterString.read(from: &buf)
        )
        
        case 6: return .deviceDisconnected(deviceId: try FfiConverterString.read(from: &buf), isLocalDevice: try FfiConverterBool.read(from: &buf)
        )
        
        case 7: return .unknown
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: AccountEvent, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .commandReceived(command):
            writeInt(&buf, Int32(1))
            FfiConverterTypeIncomingDeviceCommand.write(command, into: &buf)
            
        
        case .profileUpdated:
            writeInt(&buf, Int32(2))
        
        
        case .accountAuthStateChanged:
            writeInt(&buf, Int32(3))
        
        
        case .accountDestroyed:
            writeInt(&buf, Int32(4))
        
        
        case let .deviceConnected(deviceName):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(deviceName, into: &buf)
            
        
        case let .deviceDisconnected(deviceId,isLocalDevice):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(deviceId, into: &buf)
            FfiConverterBool.write(isLocalDevice, into: &buf)
            
        
        case .unknown:
            writeInt(&buf, Int32(7))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAccountEvent_lift(_ buf: RustBuffer) throws -> AccountEvent {
    return try FfiConverterTypeAccountEvent.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAccountEvent_lower(_ value: AccountEvent) -> RustBuffer {
    return FfiConverterTypeAccountEvent.lower(value)
}


extension AccountEvent: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * The result of invoking a "close tabs" command.
 *
 * If [`FirefoxAccount::close_tabs`] is called with more URLs than can fit
 * into a single command payload, the URLs will be chunked and sent in
 * multiple commands.
 *
 * Chunking breaks the atomicity of a "close tabs" command, but
 * reduces the number of these commands that FxA sends to other devices.
 * This is critical for platforms like iOS, where every command triggers a
 * push message that must show a user-visible notification.
 */

public enum CloseTabsResult {
    
    /**
     * All URLs passed to [`FirefoxAccount::close_tabs`] were chunked and sent
     * in one or more device commands.
     */
    case ok
    /**
     * One or more URLs passed to [`FirefoxAccount::close_tabs`] couldn't be sent
     * in a device command. The caller can assume that:
     *
     * 1. Any URL in the returned list of `urls` was not sent, and
     *    should be retried.
     * 2. All other URLs that were passed to [`FirefoxAccount::close_tabs`], and
     *    that are _not_ in the list of `urls`, were chunked and sent.
     */
    case tabsNotClosed(urls: [String]
    )
}


#if compiler(>=6)
extension CloseTabsResult: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCloseTabsResult: FfiConverterRustBuffer {
    typealias SwiftType = CloseTabsResult

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CloseTabsResult {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .ok
        
        case 2: return .tabsNotClosed(urls: try FfiConverterSequenceString.read(from: &buf)
        )
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: CloseTabsResult, into buf: inout [UInt8]) {
        switch value {
        
        
        case .ok:
            writeInt(&buf, Int32(1))
        
        
        case let .tabsNotClosed(urls):
            writeInt(&buf, Int32(2))
            FfiConverterSequenceString.write(urls, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCloseTabsResult_lift(_ buf: RustBuffer) throws -> CloseTabsResult {
    return try FfiConverterTypeCloseTabsResult.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCloseTabsResult_lower(_ value: CloseTabsResult) -> RustBuffer {
    return FfiConverterTypeCloseTabsResult.lower(value)
}


extension CloseTabsResult: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * A "capability" offered by a device.
 *
 * In the FxA ecosystem, connected devices may advertize their ability to respond
 * to various "commands" that can be invoked by other devices. The details of
 * executing these commands are encapsulated as part of the FxA Client component,
 * so consumers simply need to select which ones they want to support, and can
 * use the variants of this enum to do so.

 */

public enum DeviceCapability {
    
    case sendTab
    case closeTabs
}


#if compiler(>=6)
extension DeviceCapability: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeDeviceCapability: FfiConverterRustBuffer {
    typealias SwiftType = DeviceCapability

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> DeviceCapability {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .sendTab
        
        case 2: return .closeTabs
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: DeviceCapability, into buf: inout [UInt8]) {
        switch value {
        
        
        case .sendTab:
            writeInt(&buf, Int32(1))
        
        
        case .closeTabs:
            writeInt(&buf, Int32(2))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDeviceCapability_lift(_ buf: RustBuffer) throws -> DeviceCapability {
    return try FfiConverterTypeDeviceCapability.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeDeviceCapability_lower(_ value: DeviceCapability) -> RustBuffer {
    return FfiConverterTypeDeviceCapability.lower(value)
}


extension DeviceCapability: Equatable, Hashable {}




/**
 * Generic error type thrown by many [`FirefoxAccount`] operations.
 *
 * Precise details of the error are hidden from consumers, mostly due to limitations of
 * how we expose this API to other languages. The type of the error indicates how the
 * calling code should respond.

 */
public enum FxaError {

    
    
    /**
     * Thrown when there was a problem with the authentication status of the account,
     * such as an expired token. The application should [check its authorization status](
     * FirefoxAccount::check_authorization_status) to see whether it has been disconnected,
     * or retry the operation with a freshly-generated token.
     */
    case Authentication(message: String)
    
    /**
     * Thrown if an operation fails due to network access problems.
     * The application may retry at a later time once connectivity is restored.
     */
    case Network(message: String)
    
    /**
     * Thrown if the application attempts to complete an OAuth flow when no OAuth flow has been initiated for that state.
     * This may indicate a user who navigated directly to the OAuth `redirect_uri` for the application.
     */
    case NoExistingAuthFlow(message: String)
    
    /**
     * Thrown if the application attempts to complete an OAuth flow, but the state
     * tokens returned from the Firefox Account server do not match with the ones
     * expected by the client.
     * This may indicate a stale OAuth flow, or potentially an attempted hijacking
     * of the flow by an attacker. The signin attempt cannot be completed.
     *
     * **Note:** This error is currently only thrown in the Swift language bindings.
     */
    case WrongAuthFlow(message: String)
    
    /**
     * Origin mismatch when handling a pairing flow
     *
     * The most likely cause of this is that a user tried to pair together two firefox instances
     * that are configured to use different servers.
     */
    case OriginMismatch(message: String)
    
    /**
     * The sync scoped key was missing in the server response
     */
    case SyncScopedKeyMissingInServerResponse(message: String)
    
    /**
     * Thrown if there is a panic in the underlying Rust code.
     *
     * **Note:** This error is currently only thrown in the Kotlin language bindings.
     */
    case Panic(message: String)
    
    /**
     * A catch-all for other unspecified errors.
     */
    case Other(message: String)
    
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaError: FfiConverterRustBuffer {
    typealias SwiftType = FxaError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaError {
        let variant: Int32 = try readInt(&buf)
        switch variant {

        

        
        case 1: return .Authentication(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 2: return .Network(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 3: return .NoExistingAuthFlow(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 4: return .WrongAuthFlow(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 5: return .OriginMismatch(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 6: return .SyncScopedKeyMissingInServerResponse(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 7: return .Panic(
            message: try FfiConverterString.read(from: &buf)
        )
        
        case 8: return .Other(
            message: try FfiConverterString.read(from: &buf)
        )
        

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaError, into buf: inout [UInt8]) {
        switch value {

        

        
        case .Authentication(_ /* message is ignored*/):
            writeInt(&buf, Int32(1))
        case .Network(_ /* message is ignored*/):
            writeInt(&buf, Int32(2))
        case .NoExistingAuthFlow(_ /* message is ignored*/):
            writeInt(&buf, Int32(3))
        case .WrongAuthFlow(_ /* message is ignored*/):
            writeInt(&buf, Int32(4))
        case .OriginMismatch(_ /* message is ignored*/):
            writeInt(&buf, Int32(5))
        case .SyncScopedKeyMissingInServerResponse(_ /* message is ignored*/):
            writeInt(&buf, Int32(6))
        case .Panic(_ /* message is ignored*/):
            writeInt(&buf, Int32(7))
        case .Other(_ /* message is ignored*/):
            writeInt(&buf, Int32(8))

        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaError_lift(_ buf: RustBuffer) throws -> FxaError {
    return try FfiConverterTypeFxaError.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaError_lower(_ value: FxaError) -> RustBuffer {
    return FfiConverterTypeFxaError.lower(value)
}


extension FxaError: Equatable, Hashable {}



extension FxaError: Foundation.LocalizedError {
    public var errorDescription: String? {
        String(reflecting: self)
    }
}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum FxaEvent {
    
    case initialize(deviceConfig: DeviceConfig
    )
    case beginOAuthFlow(scopes: [String], entrypoint: String
    )
    case beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String
    )
    case completeOAuthFlow(code: String, state: String
    )
    case cancelOAuthFlow
    case checkAuthorizationStatus
    case disconnect
    case callGetProfile
}


#if compiler(>=6)
extension FxaEvent: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaEvent: FfiConverterRustBuffer {
    typealias SwiftType = FxaEvent

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaEvent {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .initialize(deviceConfig: try FfiConverterTypeDeviceConfig.read(from: &buf)
        )
        
        case 2: return .beginOAuthFlow(scopes: try FfiConverterSequenceString.read(from: &buf), entrypoint: try FfiConverterString.read(from: &buf)
        )
        
        case 3: return .beginPairingFlow(pairingUrl: try FfiConverterString.read(from: &buf), scopes: try FfiConverterSequenceString.read(from: &buf), entrypoint: try FfiConverterString.read(from: &buf)
        )
        
        case 4: return .completeOAuthFlow(code: try FfiConverterString.read(from: &buf), state: try FfiConverterString.read(from: &buf)
        )
        
        case 5: return .cancelOAuthFlow
        
        case 6: return .checkAuthorizationStatus
        
        case 7: return .disconnect
        
        case 8: return .callGetProfile
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaEvent, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .initialize(deviceConfig):
            writeInt(&buf, Int32(1))
            FfiConverterTypeDeviceConfig.write(deviceConfig, into: &buf)
            
        
        case let .beginOAuthFlow(scopes,entrypoint):
            writeInt(&buf, Int32(2))
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)
            
        
        case let .beginPairingFlow(pairingUrl,scopes,entrypoint):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(pairingUrl, into: &buf)
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)
            
        
        case let .completeOAuthFlow(code,state):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(code, into: &buf)
            FfiConverterString.write(state, into: &buf)
            
        
        case .cancelOAuthFlow:
            writeInt(&buf, Int32(5))
        
        
        case .checkAuthorizationStatus:
            writeInt(&buf, Int32(6))
        
        
        case .disconnect:
            writeInt(&buf, Int32(7))
        
        
        case .callGetProfile:
            writeInt(&buf, Int32(8))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaEvent_lift(_ buf: RustBuffer) throws -> FxaEvent {
    return try FfiConverterTypeFxaEvent.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaEvent_lower(_ value: FxaEvent) -> RustBuffer {
    return FfiConverterTypeFxaEvent.lower(value)
}


extension FxaEvent: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum FxaRustAuthState {
    
    case disconnected
    case connected
    case authIssues
}


#if compiler(>=6)
extension FxaRustAuthState: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaRustAuthState: FfiConverterRustBuffer {
    typealias SwiftType = FxaRustAuthState

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaRustAuthState {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .disconnected
        
        case 2: return .connected
        
        case 3: return .authIssues
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaRustAuthState, into buf: inout [UInt8]) {
        switch value {
        
        
        case .disconnected:
            writeInt(&buf, Int32(1))
        
        
        case .connected:
            writeInt(&buf, Int32(2))
        
        
        case .authIssues:
            writeInt(&buf, Int32(3))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaRustAuthState_lift(_ buf: RustBuffer) throws -> FxaRustAuthState {
    return try FfiConverterTypeFxaRustAuthState.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaRustAuthState_lower(_ value: FxaRustAuthState) -> RustBuffer {
    return FfiConverterTypeFxaRustAuthState.lower(value)
}


extension FxaRustAuthState: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * FxA server to connect to
 */

public enum FxaServer {
    
    case release
    case stable
    case stage
    case china
    case localDev
    case custom(url: String
    )
}


#if compiler(>=6)
extension FxaServer: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaServer: FfiConverterRustBuffer {
    typealias SwiftType = FxaServer

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaServer {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .release
        
        case 2: return .stable
        
        case 3: return .stage
        
        case 4: return .china
        
        case 5: return .localDev
        
        case 6: return .custom(url: try FfiConverterString.read(from: &buf)
        )
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaServer, into buf: inout [UInt8]) {
        switch value {
        
        
        case .release:
            writeInt(&buf, Int32(1))
        
        
        case .stable:
            writeInt(&buf, Int32(2))
        
        
        case .stage:
            writeInt(&buf, Int32(3))
        
        
        case .china:
            writeInt(&buf, Int32(4))
        
        
        case .localDev:
            writeInt(&buf, Int32(5))
        
        
        case let .custom(url):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(url, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaServer_lift(_ buf: RustBuffer) throws -> FxaServer {
    return try FfiConverterTypeFxaServer.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaServer_lower(_ value: FxaServer) -> RustBuffer {
    return FfiConverterTypeFxaServer.lower(value)
}


extension FxaServer: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum FxaState {
    
    case uninitialized
    case disconnected
    case authenticating(oauthUrl: String
    )
    case connected
    case authIssues
}


#if compiler(>=6)
extension FxaState: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaState: FfiConverterRustBuffer {
    typealias SwiftType = FxaState

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaState {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .uninitialized
        
        case 2: return .disconnected
        
        case 3: return .authenticating(oauthUrl: try FfiConverterString.read(from: &buf)
        )
        
        case 4: return .connected
        
        case 5: return .authIssues
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaState, into buf: inout [UInt8]) {
        switch value {
        
        
        case .uninitialized:
            writeInt(&buf, Int32(1))
        
        
        case .disconnected:
            writeInt(&buf, Int32(2))
        
        
        case let .authenticating(oauthUrl):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(oauthUrl, into: &buf)
            
        
        case .connected:
            writeInt(&buf, Int32(4))
        
        
        case .authIssues:
            writeInt(&buf, Int32(5))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaState_lift(_ buf: RustBuffer) throws -> FxaState {
    return try FfiConverterTypeFxaState.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaState_lower(_ value: FxaState) -> RustBuffer {
    return FfiConverterTypeFxaState.lower(value)
}


extension FxaState: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum FxaStateCheckerEvent {
    
    case getAuthStateSuccess(authState: FxaRustAuthState
    )
    case beginOAuthFlowSuccess(oauthUrl: String
    )
    case beginPairingFlowSuccess(oauthUrl: String
    )
    case completeOAuthFlowSuccess
    case initializeDeviceSuccess
    case ensureDeviceCapabilitiesSuccess
    case checkAuthorizationStatusSuccess(active: Bool
    )
    case disconnectSuccess
    case getProfileSuccess
    case callError
    case ensureCapabilitiesAuthError
}


#if compiler(>=6)
extension FxaStateCheckerEvent: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaStateCheckerEvent: FfiConverterRustBuffer {
    typealias SwiftType = FxaStateCheckerEvent

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaStateCheckerEvent {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .getAuthStateSuccess(authState: try FfiConverterTypeFxaRustAuthState.read(from: &buf)
        )
        
        case 2: return .beginOAuthFlowSuccess(oauthUrl: try FfiConverterString.read(from: &buf)
        )
        
        case 3: return .beginPairingFlowSuccess(oauthUrl: try FfiConverterString.read(from: &buf)
        )
        
        case 4: return .completeOAuthFlowSuccess
        
        case 5: return .initializeDeviceSuccess
        
        case 6: return .ensureDeviceCapabilitiesSuccess
        
        case 7: return .checkAuthorizationStatusSuccess(active: try FfiConverterBool.read(from: &buf)
        )
        
        case 8: return .disconnectSuccess
        
        case 9: return .getProfileSuccess
        
        case 10: return .callError
        
        case 11: return .ensureCapabilitiesAuthError
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaStateCheckerEvent, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .getAuthStateSuccess(authState):
            writeInt(&buf, Int32(1))
            FfiConverterTypeFxaRustAuthState.write(authState, into: &buf)
            
        
        case let .beginOAuthFlowSuccess(oauthUrl):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(oauthUrl, into: &buf)
            
        
        case let .beginPairingFlowSuccess(oauthUrl):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(oauthUrl, into: &buf)
            
        
        case .completeOAuthFlowSuccess:
            writeInt(&buf, Int32(4))
        
        
        case .initializeDeviceSuccess:
            writeInt(&buf, Int32(5))
        
        
        case .ensureDeviceCapabilitiesSuccess:
            writeInt(&buf, Int32(6))
        
        
        case let .checkAuthorizationStatusSuccess(active):
            writeInt(&buf, Int32(7))
            FfiConverterBool.write(active, into: &buf)
            
        
        case .disconnectSuccess:
            writeInt(&buf, Int32(8))
        
        
        case .getProfileSuccess:
            writeInt(&buf, Int32(9))
        
        
        case .callError:
            writeInt(&buf, Int32(10))
        
        
        case .ensureCapabilitiesAuthError:
            writeInt(&buf, Int32(11))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaStateCheckerEvent_lift(_ buf: RustBuffer) throws -> FxaStateCheckerEvent {
    return try FfiConverterTypeFxaStateCheckerEvent.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaStateCheckerEvent_lower(_ value: FxaStateCheckerEvent) -> RustBuffer {
    return FfiConverterTypeFxaStateCheckerEvent.lower(value)
}


extension FxaStateCheckerEvent: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum FxaStateCheckerState {
    
    case getAuthState
    case beginOAuthFlow(scopes: [String], entrypoint: String
    )
    case beginPairingFlow(pairingUrl: String, scopes: [String], entrypoint: String
    )
    case completeOAuthFlow(code: String, state: String
    )
    case initializeDevice
    case ensureDeviceCapabilities
    case checkAuthorizationStatus
    case disconnect
    case getProfile
    case complete(newState: FxaState
    )
    case cancel
}


#if compiler(>=6)
extension FxaStateCheckerState: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFxaStateCheckerState: FfiConverterRustBuffer {
    typealias SwiftType = FxaStateCheckerState

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FxaStateCheckerState {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .getAuthState
        
        case 2: return .beginOAuthFlow(scopes: try FfiConverterSequenceString.read(from: &buf), entrypoint: try FfiConverterString.read(from: &buf)
        )
        
        case 3: return .beginPairingFlow(pairingUrl: try FfiConverterString.read(from: &buf), scopes: try FfiConverterSequenceString.read(from: &buf), entrypoint: try FfiConverterString.read(from: &buf)
        )
        
        case 4: return .completeOAuthFlow(code: try FfiConverterString.read(from: &buf), state: try FfiConverterString.read(from: &buf)
        )
        
        case 5: return .initializeDevice
        
        case 6: return .ensureDeviceCapabilities
        
        case 7: return .checkAuthorizationStatus
        
        case 8: return .disconnect
        
        case 9: return .getProfile
        
        case 10: return .complete(newState: try FfiConverterTypeFxaState.read(from: &buf)
        )
        
        case 11: return .cancel
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: FxaStateCheckerState, into buf: inout [UInt8]) {
        switch value {
        
        
        case .getAuthState:
            writeInt(&buf, Int32(1))
        
        
        case let .beginOAuthFlow(scopes,entrypoint):
            writeInt(&buf, Int32(2))
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)
            
        
        case let .beginPairingFlow(pairingUrl,scopes,entrypoint):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(pairingUrl, into: &buf)
            FfiConverterSequenceString.write(scopes, into: &buf)
            FfiConverterString.write(entrypoint, into: &buf)
            
        
        case let .completeOAuthFlow(code,state):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(code, into: &buf)
            FfiConverterString.write(state, into: &buf)
            
        
        case .initializeDevice:
            writeInt(&buf, Int32(5))
        
        
        case .ensureDeviceCapabilities:
            writeInt(&buf, Int32(6))
        
        
        case .checkAuthorizationStatus:
            writeInt(&buf, Int32(7))
        
        
        case .disconnect:
            writeInt(&buf, Int32(8))
        
        
        case .getProfile:
            writeInt(&buf, Int32(9))
        
        
        case let .complete(newState):
            writeInt(&buf, Int32(10))
            FfiConverterTypeFxaState.write(newState, into: &buf)
            
        
        case .cancel:
            writeInt(&buf, Int32(11))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaStateCheckerState_lift(_ buf: RustBuffer) throws -> FxaStateCheckerState {
    return try FfiConverterTypeFxaStateCheckerState.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFxaStateCheckerState_lower(_ value: FxaStateCheckerState) -> RustBuffer {
    return FfiConverterTypeFxaStateCheckerState.lower(value)
}


extension FxaStateCheckerState: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * A command invoked by another device.
 *
 * This enum represents all possible commands that can be invoked on
 * the device. It is the responsibility of the application to interpret
 * each command.

 */

public enum IncomingDeviceCommand {
    
    /**
     * Indicates that a tab has been sent to this device.
     */
    case tabReceived(sender: Device?, payload: SendTabPayload
    )
    /**
     * Indicates that the sender wants to close one or more tabs on this device.
     */
    case tabsClosed(sender: Device?, payload: CloseTabsPayload
    )
}


#if compiler(>=6)
extension IncomingDeviceCommand: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeIncomingDeviceCommand: FfiConverterRustBuffer {
    typealias SwiftType = IncomingDeviceCommand

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> IncomingDeviceCommand {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .tabReceived(sender: try FfiConverterOptionTypeDevice.read(from: &buf), payload: try FfiConverterTypeSendTabPayload.read(from: &buf)
        )
        
        case 2: return .tabsClosed(sender: try FfiConverterOptionTypeDevice.read(from: &buf), payload: try FfiConverterTypeCloseTabsPayload.read(from: &buf)
        )
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: IncomingDeviceCommand, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .tabReceived(sender,payload):
            writeInt(&buf, Int32(1))
            FfiConverterOptionTypeDevice.write(sender, into: &buf)
            FfiConverterTypeSendTabPayload.write(payload, into: &buf)
            
        
        case let .tabsClosed(sender,payload):
            writeInt(&buf, Int32(2))
            FfiConverterOptionTypeDevice.write(sender, into: &buf)
            FfiConverterTypeCloseTabsPayload.write(payload, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeIncomingDeviceCommand_lift(_ buf: RustBuffer) throws -> IncomingDeviceCommand {
    return try FfiConverterTypeIncomingDeviceCommand.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeIncomingDeviceCommand_lower(_ value: IncomingDeviceCommand) -> RustBuffer {
    return FfiConverterTypeIncomingDeviceCommand.lower(value)
}


extension IncomingDeviceCommand: Equatable, Hashable {}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionInt64: FfiConverterRustBuffer {
    typealias SwiftType = Int64?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt64.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt64.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeDevice: FfiConverterRustBuffer {
    typealias SwiftType = Device?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeDevice.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeDevice.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeDevicePushSubscription: FfiConverterRustBuffer {
    typealias SwiftType = DevicePushSubscription?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeDevicePushSubscription.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeDevicePushSubscription.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeScopedKey: FfiConverterRustBuffer {
    typealias SwiftType = ScopedKey?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeScopedKey.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeScopedKey.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeAttachedClient: FfiConverterRustBuffer {
    typealias SwiftType = [AttachedClient]

    public static func write(_ value: [AttachedClient], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeAttachedClient.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [AttachedClient] {
        let len: Int32 = try readInt(&buf)
        var seq = [AttachedClient]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeAttachedClient.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeDevice: FfiConverterRustBuffer {
    typealias SwiftType = [Device]

    public static func write(_ value: [Device], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeDevice.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Device] {
        let len: Int32 = try readInt(&buf)
        var seq = [Device]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeDevice.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeTabHistoryEntry: FfiConverterRustBuffer {
    typealias SwiftType = [TabHistoryEntry]

    public static func write(_ value: [TabHistoryEntry], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeTabHistoryEntry.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [TabHistoryEntry] {
        let len: Int32 = try readInt(&buf)
        var seq = [TabHistoryEntry]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeTabHistoryEntry.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeDeviceCapability: FfiConverterRustBuffer {
    typealias SwiftType = [DeviceCapability]

    public static func write(_ value: [DeviceCapability], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeDeviceCapability.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [DeviceCapability] {
        let len: Int32 = try readInt(&buf)
        var seq = [DeviceCapability]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeDeviceCapability.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeIncomingDeviceCommand: FfiConverterRustBuffer {
    typealias SwiftType = [IncomingDeviceCommand]

    public static func write(_ value: [IncomingDeviceCommand], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeIncomingDeviceCommand.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [IncomingDeviceCommand] {
        let len: Int32 = try readInt(&buf)
        var seq = [IncomingDeviceCommand]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeIncomingDeviceCommand.read(from: &buf))
        }
        return seq
    }
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}
// Use a global variable to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private let initializationResult: InitializationResult = {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_fxa_client_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_authorize_code_using_session_token() != 17083) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_begin_oauth_flow() != 2998) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_begin_pairing_flow() != 21843) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_check_authorization_status() != 52519) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_clear_access_token_cache() != 36203) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_clear_device_name() != 42324) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_close_tabs() != 55044) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_complete_oauth_flow() != 41338) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_disconnect() != 807) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_ensure_capabilities() != 807) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_gather_telemetry() != 61296) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_access_token() != 23448) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_attached_clients() != 14470) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_auth_state() != 38375) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_connection_success_url() != 7413) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_current_device_id() != 45188) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_devices() != 41982) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_manage_account_url() != 29173) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_manage_devices_url() != 42582) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_pairing_authority_url() != 50743) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_profile() != 26069) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_session_token() != 45648) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_state() != 37802) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_get_token_server_endpoint_url() != 42568) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_handle_push_message() != 41561) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_handle_session_token_change() != 23593) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_initialize_device() != 37216) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_on_auth_issues() != 21675) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_poll_device_commands() != 37725) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_process_event() != 31348) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_send_single_tab() != 46148) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_set_device_name() != 49257) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_set_push_subscription() != 65018) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_set_user_data() != 1025) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_simulate_network_error() != 61828) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_simulate_permanent_auth_token_issue() != 25986) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_simulate_temporary_auth_token_issue() != 32382) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_firefoxaccount_to_json() != 27972) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_fxastatemachinechecker_check_internal_state() != 47586) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_fxastatemachinechecker_check_public_state() != 35267) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_fxastatemachinechecker_handle_internal_event() != 54231) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_method_fxastatemachinechecker_handle_public_event() != 63696) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_constructor_firefoxaccount_from_json() != 17872) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_constructor_firefoxaccount_new() != 56529) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_fxa_client_checksum_constructor_fxastatemachinechecker_new() != 33739) {
        return InitializationResult.apiChecksumMismatch
    }

    uniffiEnsureSync15Initialized()
    return InitializationResult.ok
}()

// Make the ensure init function public so that other modules which have external type references to
// our types can call it.
public func uniffiEnsureFxaClientInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all