// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
import MozillaRustComponents
#endif

fileprivate extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len:0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_logins_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_logins_rustbuffer_free(self, $0) }
    }
}

fileprivate extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

fileprivate extension Data {
    init(rustBuffer: RustBuffer) {
        self.init(
            bytesNoCopy: rustBuffer.data!,
            count: Int(rustBuffer.len),
            deallocator: .none
        )
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

fileprivate func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
fileprivate func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset..<reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value, { reader.data.copyBytes(to: $0, from: range)})
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
fileprivate func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> Array<UInt8> {
    let range = reader.offset..<(reader.offset+count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer({ buffer in
        reader.data.copyBytes(to: buffer, from: range)
    })
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
fileprivate func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return Float(bitPattern: try readInt(&reader))
}

// Reads a float at the current offset.
fileprivate func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return Double(bitPattern: try readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
fileprivate func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

fileprivate func createWriter() -> [UInt8] {
    return []
}

fileprivate func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
fileprivate func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

fileprivate func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

fileprivate func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous to the Rust trait of the same name.
fileprivate protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
fileprivate protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType { }

extension FfiConverterPrimitive {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
fileprivate protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> RustBuffer {
          var writer = createWriter()
          write(value, into: &writer)
          return RustBuffer(bytes: writer)
    }
}
// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
fileprivate enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

fileprivate extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        self.lock()
        defer { self.unlock() }
        return try f()
    }
}

fileprivate let CALL_SUCCESS: Int8 = 0
fileprivate let CALL_ERROR: Int8 = 1
fileprivate let CALL_UNEXPECTED_ERROR: Int8 = 2
fileprivate let CALL_CANCELLED: Int8 = 3

fileprivate extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer.init(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    let neverThrow: ((RustBuffer) throws -> Never)? = nil
    return try makeRustCall(callback, errorHandler: neverThrow)
}

private func rustCallWithError<T, E: Swift.Error>(
    _ errorHandler: @escaping (RustBuffer) throws -> E,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T, E: Swift.Error>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> E)?
) throws -> T {
    uniffiEnsureLoginsInitialized()
    var callStatus = RustCallStatus.init()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus<E: Swift.Error>(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> E)?
) throws {
    switch callStatus.code {
        case CALL_SUCCESS:
            return

        case CALL_ERROR:
            if let errorHandler = errorHandler {
                throw try errorHandler(callStatus.errorBuf)
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.unexpectedRustCallError
            }

        case CALL_UNEXPECTED_ERROR:
            // When the rust code sees a panic, it tries to construct a RustBuffer
            // with the message.  But if that code panics, then it just sends back
            // an empty buffer.
            if callStatus.errorBuf.len > 0 {
                throw UniffiInternalError.rustPanic(try FfiConverterString.lift(callStatus.errorBuf))
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.rustPanic("Rust panic")
            }

        case CALL_CANCELLED:
            fatalError("Cancellation not supported yet")

        default:
            throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> ()
) {
    do {
        try writeReturn(makeCall())
    } catch let error {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> (),
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}
fileprivate final class UniffiHandleMap<T>: @unchecked Sendable {
    // All mutation happens with this lock held, which is why we implement @unchecked Sendable.
    private let lock = NSLock()
    private var map: [UInt64: T] = [:]
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

     func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        get {
            map.count
        }
    }
}


// Public interface members begin here.


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterBool : FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return String(bytes: try readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterData: FfiConverterRustBuffer {
    typealias SwiftType = Data

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Data {
        let len: Int32 = try readInt(&buf)
        return Data(try readBytes(&buf, count: Int(len)))
    }

    public static func write(_ value: Data, into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        writeBytes(&buf, value)
    }
}




public protocol EncryptorDecryptor: AnyObject {
    
    func decrypt(ciphertext: Data) throws  -> Data
    
    func encrypt(cleartext: Data) throws  -> Data
    
}
open class EncryptorDecryptorImpl: EncryptorDecryptor, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_logins_fn_clone_encryptordecryptor(self.pointer, $0) }
    }
    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_logins_fn_free_encryptordecryptor(pointer, $0) }
    }

    

    
open func decrypt(ciphertext: Data)throws  -> Data  {
    return try  FfiConverterData.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_encryptordecryptor_decrypt(self.uniffiClonePointer(),
        FfiConverterData.lower(ciphertext),$0
    )
})
}
    
open func encrypt(cleartext: Data)throws  -> Data  {
    return try  FfiConverterData.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_encryptordecryptor_encrypt(self.uniffiClonePointer(),
        FfiConverterData.lower(cleartext),$0
    )
})
}
    

}
// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
private let IDX_CALLBACK_FREE: Int32 = 0
// Callback return codes
private let UNIFFI_CALLBACK_SUCCESS: Int32 = 0
private let UNIFFI_CALLBACK_ERROR: Int32 = 1
private let UNIFFI_CALLBACK_UNEXPECTED_ERROR: Int32 = 2

// Put the implementation in a struct so we don't pollute the top-level namespace
fileprivate struct UniffiCallbackInterfaceEncryptorDecryptor {

    // Create the VTable using a series of closures.
    // Swift automatically converts these into C callback functions.
    //
    // This creates 1-element array, since this seems to be the only way to construct a const
    // pointer that we can pass to the Rust code.
    static let vtable: [UniffiVTableCallbackInterfaceEncryptorDecryptor] = [UniffiVTableCallbackInterfaceEncryptorDecryptor(
        decrypt: { (
            uniffiHandle: UInt64,
            ciphertext: RustBuffer,
            uniffiOutReturn: UnsafeMutablePointer<RustBuffer>,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws -> Data in
                guard let uniffiObj = try? FfiConverterTypeEncryptorDecryptor.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.decrypt(
                     ciphertext: try FfiConverterData.lift(ciphertext)
                )
            }

            
            let writeReturn = { uniffiOutReturn.pointee = FfiConverterData.lower($0) }
            uniffiTraitInterfaceCallWithError(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn,
                lowerError: FfiConverterTypeLoginsApiError_lower
            )
        },
        encrypt: { (
            uniffiHandle: UInt64,
            cleartext: RustBuffer,
            uniffiOutReturn: UnsafeMutablePointer<RustBuffer>,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws -> Data in
                guard let uniffiObj = try? FfiConverterTypeEncryptorDecryptor.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.encrypt(
                     cleartext: try FfiConverterData.lift(cleartext)
                )
            }

            
            let writeReturn = { uniffiOutReturn.pointee = FfiConverterData.lower($0) }
            uniffiTraitInterfaceCallWithError(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn,
                lowerError: FfiConverterTypeLoginsApiError_lower
            )
        },
        uniffiFree: { (uniffiHandle: UInt64) -> () in
            let result = try? FfiConverterTypeEncryptorDecryptor.handleMap.remove(handle: uniffiHandle)
            if result == nil {
                print("Uniffi callback interface EncryptorDecryptor: handle missing in uniffiFree")
            }
        }
    )]
}

private func uniffiCallbackInitEncryptorDecryptor() {
    uniffi_logins_fn_init_callback_vtable_encryptordecryptor(UniffiCallbackInterfaceEncryptorDecryptor.vtable)
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeEncryptorDecryptor: FfiConverter {
    fileprivate static let handleMap = UniffiHandleMap<EncryptorDecryptor>()

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = EncryptorDecryptor

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> EncryptorDecryptor {
        return EncryptorDecryptorImpl(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: EncryptorDecryptor) -> UnsafeMutableRawPointer {
        guard let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: handleMap.insert(obj: value))) else {
            fatalError("Cast to UnsafeMutableRawPointer failed")
        }
        return ptr
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EncryptorDecryptor {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: EncryptorDecryptor, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeEncryptorDecryptor_lift(_ pointer: UnsafeMutableRawPointer) throws -> EncryptorDecryptor {
    return try FfiConverterTypeEncryptorDecryptor.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeEncryptorDecryptor_lower(_ value: EncryptorDecryptor) -> UnsafeMutableRawPointer {
    return FfiConverterTypeEncryptorDecryptor.lower(value)
}






public protocol KeyManager: AnyObject {
    
    func getKey() throws  -> Data
    
}
open class KeyManagerImpl: KeyManager, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_logins_fn_clone_keymanager(self.pointer, $0) }
    }
    // No primary constructor declared for this class.

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_logins_fn_free_keymanager(pointer, $0) }
    }

    

    
open func getKey()throws  -> Data  {
    return try  FfiConverterData.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_keymanager_get_key(self.uniffiClonePointer(),$0
    )
})
}
    

}


// Put the implementation in a struct so we don't pollute the top-level namespace
fileprivate struct UniffiCallbackInterfaceKeyManager {

    // Create the VTable using a series of closures.
    // Swift automatically converts these into C callback functions.
    //
    // This creates 1-element array, since this seems to be the only way to construct a const
    // pointer that we can pass to the Rust code.
    static let vtable: [UniffiVTableCallbackInterfaceKeyManager] = [UniffiVTableCallbackInterfaceKeyManager(
        getKey: { (
            uniffiHandle: UInt64,
            uniffiOutReturn: UnsafeMutablePointer<RustBuffer>,
            uniffiCallStatus: UnsafeMutablePointer<RustCallStatus>
        ) in
            let makeCall = {
                () throws -> Data in
                guard let uniffiObj = try? FfiConverterTypeKeyManager.handleMap.get(handle: uniffiHandle) else {
                    throw UniffiInternalError.unexpectedStaleHandle
                }
                return try uniffiObj.getKey(
                )
            }

            
            let writeReturn = { uniffiOutReturn.pointee = FfiConverterData.lower($0) }
            uniffiTraitInterfaceCallWithError(
                callStatus: uniffiCallStatus,
                makeCall: makeCall,
                writeReturn: writeReturn,
                lowerError: FfiConverterTypeLoginsApiError_lower
            )
        },
        uniffiFree: { (uniffiHandle: UInt64) -> () in
            let result = try? FfiConverterTypeKeyManager.handleMap.remove(handle: uniffiHandle)
            if result == nil {
                print("Uniffi callback interface KeyManager: handle missing in uniffiFree")
            }
        }
    )]
}

private func uniffiCallbackInitKeyManager() {
    uniffi_logins_fn_init_callback_vtable_keymanager(UniffiCallbackInterfaceKeyManager.vtable)
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeKeyManager: FfiConverter {
    fileprivate static let handleMap = UniffiHandleMap<KeyManager>()

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = KeyManager

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> KeyManager {
        return KeyManagerImpl(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: KeyManager) -> UnsafeMutableRawPointer {
        guard let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: handleMap.insert(obj: value))) else {
            fatalError("Cast to UnsafeMutableRawPointer failed")
        }
        return ptr
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> KeyManager {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: KeyManager, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeKeyManager_lift(_ pointer: UnsafeMutableRawPointer) throws -> KeyManager {
    return try FfiConverterTypeKeyManager.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeKeyManager_lower(_ value: KeyManager) -> UnsafeMutableRawPointer {
    return FfiConverterTypeKeyManager.lower(value)
}






public protocol LoginStoreProtocol: AnyObject {
    
    func add(login: LoginEntry) throws  -> Login
    
    func addMany(logins: [LoginEntry]) throws  -> [BulkResultEntry]
    
    func addManyWithMeta(entriesWithMeta: [LoginEntryWithMeta]) throws  -> [BulkResultEntry]
    
    func addOrUpdate(login: LoginEntry) throws  -> Login
    
    func addWithMeta(entryWithMeta: LoginEntryWithMeta) throws  -> Login
    
    func count() throws  -> Int64
    
    func countByFormActionOrigin(formActionOrigin: String) throws  -> Int64
    
    func countByOrigin(origin: String) throws  -> Int64
    
    func delete(id: String) throws  -> Bool
    
    func deleteMany(ids: [String]) throws  -> [Bool]
    
    /**
     * The `delete_undecryptable_records_for_remote_replacement` function locally deletes stored logins
     * that cannot be decrypted and sets the last sync time to 0 so any existing server records can be downloaded
     * and overwrite the locally deleted records.
     *
     * NB: This function was created to unblock iOS logins users who are unable to sync logins and should not be used
     * outside of this use case.
     */
    func deleteUndecryptableRecordsForRemoteReplacement() throws 
    
    func findLoginToUpdate(look: LoginEntry) throws  -> Login?
    
    func get(id: String) throws  -> Login?
    
    func getByBaseDomain(baseDomain: String) throws  -> [Login]
    
    func getCheckpoint() throws  -> String?
    
    func hasLoginsByBaseDomain(baseDomain: String) throws  -> Bool
    
    func isEmpty() throws  -> Bool
    
    func list() throws  -> [Login]
    
    func registerWithSyncManager() 
    
    func reset() throws 
    
    /**
     * Run maintenance on the DB
     *
     * This is intended to be run during idle time and will take steps / to clean up / shrink the
     * database.
     */
    func runMaintenance() throws 
    
    func setCheckpoint(checkpoint: String) throws 
    
    func touch(id: String) throws 
    
    func update(id: String, login: LoginEntry) throws  -> Login
    
    /**
     * Clear out locally stored logins data
     *
     * If sync is enabled, then we will try to recover the data on the next sync.
     *
     * The main reason to call this is when regenerating a new encryption key.
     * In that case, there's no reason to keep around the local data since it can't be decrypted.
     * Calling `wipe_local` is better than keeping around these un-decryptable logins, since we
     * might be able to recover the data via sync.
     *
     * This is a no-op for freshly created databases, so it's safe to call this whenever a key is
     * generated.
     */
    func wipeLocal() throws 
    
}
open class LoginStore: LoginStoreProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_logins_fn_clone_loginstore(self.pointer, $0) }
    }
public convenience init(path: String, encdec: EncryptorDecryptor)throws  {
    let pointer =
        try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_constructor_loginstore_new(
        FfiConverterString.lower(path),
        FfiConverterTypeEncryptorDecryptor_lower(encdec),$0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_logins_fn_free_loginstore(pointer, $0) }
    }

    

    
open func add(login: LoginEntry)throws  -> Login  {
    return try  FfiConverterTypeLogin_lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_add(self.uniffiClonePointer(),
        FfiConverterTypeLoginEntry_lower(login),$0
    )
})
}
    
open func addMany(logins: [LoginEntry])throws  -> [BulkResultEntry]  {
    return try  FfiConverterSequenceTypeBulkResultEntry.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_add_many(self.uniffiClonePointer(),
        FfiConverterSequenceTypeLoginEntry.lower(logins),$0
    )
})
}
    
open func addManyWithMeta(entriesWithMeta: [LoginEntryWithMeta])throws  -> [BulkResultEntry]  {
    return try  FfiConverterSequenceTypeBulkResultEntry.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_add_many_with_meta(self.uniffiClonePointer(),
        FfiConverterSequenceTypeLoginEntryWithMeta.lower(entriesWithMeta),$0
    )
})
}
    
open func addOrUpdate(login: LoginEntry)throws  -> Login  {
    return try  FfiConverterTypeLogin_lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_add_or_update(self.uniffiClonePointer(),
        FfiConverterTypeLoginEntry_lower(login),$0
    )
})
}
    
open func addWithMeta(entryWithMeta: LoginEntryWithMeta)throws  -> Login  {
    return try  FfiConverterTypeLogin_lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_add_with_meta(self.uniffiClonePointer(),
        FfiConverterTypeLoginEntryWithMeta_lower(entryWithMeta),$0
    )
})
}
    
open func count()throws  -> Int64  {
    return try  FfiConverterInt64.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_count(self.uniffiClonePointer(),$0
    )
})
}
    
open func countByFormActionOrigin(formActionOrigin: String)throws  -> Int64  {
    return try  FfiConverterInt64.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_count_by_form_action_origin(self.uniffiClonePointer(),
        FfiConverterString.lower(formActionOrigin),$0
    )
})
}
    
open func countByOrigin(origin: String)throws  -> Int64  {
    return try  FfiConverterInt64.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_count_by_origin(self.uniffiClonePointer(),
        FfiConverterString.lower(origin),$0
    )
})
}
    
open func delete(id: String)throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_delete(self.uniffiClonePointer(),
        FfiConverterString.lower(id),$0
    )
})
}
    
open func deleteMany(ids: [String])throws  -> [Bool]  {
    return try  FfiConverterSequenceBool.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_delete_many(self.uniffiClonePointer(),
        FfiConverterSequenceString.lower(ids),$0
    )
})
}
    
    /**
     * The `delete_undecryptable_records_for_remote_replacement` function locally deletes stored logins
     * that cannot be decrypted and sets the last sync time to 0 so any existing server records can be downloaded
     * and overwrite the locally deleted records.
     *
     * NB: This function was created to unblock iOS logins users who are unable to sync logins and should not be used
     * outside of this use case.
     */
open func deleteUndecryptableRecordsForRemoteReplacement()throws   {try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_delete_undecryptable_records_for_remote_replacement(self.uniffiClonePointer(),$0
    )
}
}
    
open func findLoginToUpdate(look: LoginEntry)throws  -> Login?  {
    return try  FfiConverterOptionTypeLogin.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_find_login_to_update(self.uniffiClonePointer(),
        FfiConverterTypeLoginEntry_lower(look),$0
    )
})
}
    
open func get(id: String)throws  -> Login?  {
    return try  FfiConverterOptionTypeLogin.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_get(self.uniffiClonePointer(),
        FfiConverterString.lower(id),$0
    )
})
}
    
open func getByBaseDomain(baseDomain: String)throws  -> [Login]  {
    return try  FfiConverterSequenceTypeLogin.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_get_by_base_domain(self.uniffiClonePointer(),
        FfiConverterString.lower(baseDomain),$0
    )
})
}
    
open func getCheckpoint()throws  -> String?  {
    return try  FfiConverterOptionString.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_get_checkpoint(self.uniffiClonePointer(),$0
    )
})
}
    
open func hasLoginsByBaseDomain(baseDomain: String)throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_has_logins_by_base_domain(self.uniffiClonePointer(),
        FfiConverterString.lower(baseDomain),$0
    )
})
}
    
open func isEmpty()throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_is_empty(self.uniffiClonePointer(),$0
    )
})
}
    
open func list()throws  -> [Login]  {
    return try  FfiConverterSequenceTypeLogin.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_list(self.uniffiClonePointer(),$0
    )
})
}
    
open func registerWithSyncManager()  {try! rustCall() {
    uniffi_logins_fn_method_loginstore_register_with_sync_manager(self.uniffiClonePointer(),$0
    )
}
}
    
open func reset()throws   {try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_reset(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Run maintenance on the DB
     *
     * This is intended to be run during idle time and will take steps / to clean up / shrink the
     * database.
     */
open func runMaintenance()throws   {try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_run_maintenance(self.uniffiClonePointer(),$0
    )
}
}
    
open func setCheckpoint(checkpoint: String)throws   {try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_set_checkpoint(self.uniffiClonePointer(),
        FfiConverterString.lower(checkpoint),$0
    )
}
}
    
open func touch(id: String)throws   {try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_touch(self.uniffiClonePointer(),
        FfiConverterString.lower(id),$0
    )
}
}
    
open func update(id: String, login: LoginEntry)throws  -> Login  {
    return try  FfiConverterTypeLogin_lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_update(self.uniffiClonePointer(),
        FfiConverterString.lower(id),
        FfiConverterTypeLoginEntry_lower(login),$0
    )
})
}
    
    /**
     * Clear out locally stored logins data
     *
     * If sync is enabled, then we will try to recover the data on the next sync.
     *
     * The main reason to call this is when regenerating a new encryption key.
     * In that case, there's no reason to keep around the local data since it can't be decrypted.
     * Calling `wipe_local` is better than keeping around these un-decryptable logins, since we
     * might be able to recover the data via sync.
     *
     * This is a no-op for freshly created databases, so it's safe to call this whenever a key is
     * generated.
     */
open func wipeLocal()throws   {try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_method_loginstore_wipe_local(self.uniffiClonePointer(),$0
    )
}
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLoginStore: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = LoginStore

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> LoginStore {
        return LoginStore(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: LoginStore) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginStore {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: LoginStore, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginStore_lift(_ pointer: UnsafeMutableRawPointer) throws -> LoginStore {
    return try FfiConverterTypeLoginStore.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginStore_lower(_ value: LoginStore) -> UnsafeMutableRawPointer {
    return FfiConverterTypeLoginStore.lower(value)
}






public protocol ManagedEncryptorDecryptorProtocol: AnyObject {
    
}
open class ManagedEncryptorDecryptor: ManagedEncryptorDecryptorProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_logins_fn_clone_managedencryptordecryptor(self.pointer, $0) }
    }
public convenience init(keyManager: KeyManager) {
    let pointer =
        try! rustCall() {
    uniffi_logins_fn_constructor_managedencryptordecryptor_new(
        FfiConverterTypeKeyManager_lower(keyManager),$0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_logins_fn_free_managedencryptordecryptor(pointer, $0) }
    }

    

    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeManagedEncryptorDecryptor: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = ManagedEncryptorDecryptor

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> ManagedEncryptorDecryptor {
        return ManagedEncryptorDecryptor(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: ManagedEncryptorDecryptor) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ManagedEncryptorDecryptor {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: ManagedEncryptorDecryptor, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeManagedEncryptorDecryptor_lift(_ pointer: UnsafeMutableRawPointer) throws -> ManagedEncryptorDecryptor {
    return try FfiConverterTypeManagedEncryptorDecryptor.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeManagedEncryptorDecryptor_lower(_ value: ManagedEncryptorDecryptor) -> UnsafeMutableRawPointer {
    return FfiConverterTypeManagedEncryptorDecryptor.lower(value)
}






public protocol StaticKeyManagerProtocol: AnyObject {
    
}
open class StaticKeyManager: StaticKeyManagerProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_logins_fn_clone_statickeymanager(self.pointer, $0) }
    }
public convenience init(key: String) {
    let pointer =
        try! rustCall() {
    uniffi_logins_fn_constructor_statickeymanager_new(
        FfiConverterString.lower(key),$0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_logins_fn_free_statickeymanager(pointer, $0) }
    }

    

    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeStaticKeyManager: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = StaticKeyManager

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> StaticKeyManager {
        return StaticKeyManager(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: StaticKeyManager) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> StaticKeyManager {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: StaticKeyManager, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeStaticKeyManager_lift(_ pointer: UnsafeMutableRawPointer) throws -> StaticKeyManager {
    return try FfiConverterTypeStaticKeyManager.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeStaticKeyManager_lower(_ value: StaticKeyManager) -> UnsafeMutableRawPointer {
    return FfiConverterTypeStaticKeyManager.lower(value)
}




/**
 * A login stored in the database
 */
public struct Login {
    public var id: String
    public var timesUsed: Int64
    public var timeCreated: Int64
    public var timeLastUsed: Int64
    public var timePasswordChanged: Int64
    public var origin: String
    public var httpRealm: String?
    public var formActionOrigin: String?
    public var usernameField: String
    public var passwordField: String
    public var password: String
    public var username: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, timesUsed: Int64, timeCreated: Int64, timeLastUsed: Int64, timePasswordChanged: Int64, origin: String, httpRealm: String?, formActionOrigin: String?, usernameField: String, passwordField: String, password: String, username: String) {
        self.id = id
        self.timesUsed = timesUsed
        self.timeCreated = timeCreated
        self.timeLastUsed = timeLastUsed
        self.timePasswordChanged = timePasswordChanged
        self.origin = origin
        self.httpRealm = httpRealm
        self.formActionOrigin = formActionOrigin
        self.usernameField = usernameField
        self.passwordField = passwordField
        self.password = password
        self.username = username
    }
}

#if compiler(>=6)
extension Login: Sendable {}
#endif


extension Login: Equatable, Hashable {
    public static func ==(lhs: Login, rhs: Login) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.timesUsed != rhs.timesUsed {
            return false
        }
        if lhs.timeCreated != rhs.timeCreated {
            return false
        }
        if lhs.timeLastUsed != rhs.timeLastUsed {
            return false
        }
        if lhs.timePasswordChanged != rhs.timePasswordChanged {
            return false
        }
        if lhs.origin != rhs.origin {
            return false
        }
        if lhs.httpRealm != rhs.httpRealm {
            return false
        }
        if lhs.formActionOrigin != rhs.formActionOrigin {
            return false
        }
        if lhs.usernameField != rhs.usernameField {
            return false
        }
        if lhs.passwordField != rhs.passwordField {
            return false
        }
        if lhs.password != rhs.password {
            return false
        }
        if lhs.username != rhs.username {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(timesUsed)
        hasher.combine(timeCreated)
        hasher.combine(timeLastUsed)
        hasher.combine(timePasswordChanged)
        hasher.combine(origin)
        hasher.combine(httpRealm)
        hasher.combine(formActionOrigin)
        hasher.combine(usernameField)
        hasher.combine(passwordField)
        hasher.combine(password)
        hasher.combine(username)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLogin: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Login {
        return
            try Login(
                id: FfiConverterString.read(from: &buf), 
                timesUsed: FfiConverterInt64.read(from: &buf), 
                timeCreated: FfiConverterInt64.read(from: &buf), 
                timeLastUsed: FfiConverterInt64.read(from: &buf), 
                timePasswordChanged: FfiConverterInt64.read(from: &buf), 
                origin: FfiConverterString.read(from: &buf), 
                httpRealm: FfiConverterOptionString.read(from: &buf), 
                formActionOrigin: FfiConverterOptionString.read(from: &buf), 
                usernameField: FfiConverterString.read(from: &buf), 
                passwordField: FfiConverterString.read(from: &buf), 
                password: FfiConverterString.read(from: &buf), 
                username: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: Login, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterInt64.write(value.timesUsed, into: &buf)
        FfiConverterInt64.write(value.timeCreated, into: &buf)
        FfiConverterInt64.write(value.timeLastUsed, into: &buf)
        FfiConverterInt64.write(value.timePasswordChanged, into: &buf)
        FfiConverterString.write(value.origin, into: &buf)
        FfiConverterOptionString.write(value.httpRealm, into: &buf)
        FfiConverterOptionString.write(value.formActionOrigin, into: &buf)
        FfiConverterString.write(value.usernameField, into: &buf)
        FfiConverterString.write(value.passwordField, into: &buf)
        FfiConverterString.write(value.password, into: &buf)
        FfiConverterString.write(value.username, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLogin_lift(_ buf: RustBuffer) throws -> Login {
    return try FfiConverterTypeLogin.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLogin_lower(_ value: Login) -> RustBuffer {
    return FfiConverterTypeLogin.lower(value)
}


/**
 * A login entry from the user, not linked to any database record.
 * The add/update APIs input these.
 */
public struct LoginEntry {
    public var origin: String
    public var httpRealm: String?
    public var formActionOrigin: String?
    public var usernameField: String
    public var passwordField: String
    public var password: String
    public var username: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(origin: String, httpRealm: String?, formActionOrigin: String?, usernameField: String, passwordField: String, password: String, username: String) {
        self.origin = origin
        self.httpRealm = httpRealm
        self.formActionOrigin = formActionOrigin
        self.usernameField = usernameField
        self.passwordField = passwordField
        self.password = password
        self.username = username
    }
}

#if compiler(>=6)
extension LoginEntry: Sendable {}
#endif


extension LoginEntry: Equatable, Hashable {
    public static func ==(lhs: LoginEntry, rhs: LoginEntry) -> Bool {
        if lhs.origin != rhs.origin {
            return false
        }
        if lhs.httpRealm != rhs.httpRealm {
            return false
        }
        if lhs.formActionOrigin != rhs.formActionOrigin {
            return false
        }
        if lhs.usernameField != rhs.usernameField {
            return false
        }
        if lhs.passwordField != rhs.passwordField {
            return false
        }
        if lhs.password != rhs.password {
            return false
        }
        if lhs.username != rhs.username {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(origin)
        hasher.combine(httpRealm)
        hasher.combine(formActionOrigin)
        hasher.combine(usernameField)
        hasher.combine(passwordField)
        hasher.combine(password)
        hasher.combine(username)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLoginEntry: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginEntry {
        return
            try LoginEntry(
                origin: FfiConverterString.read(from: &buf), 
                httpRealm: FfiConverterOptionString.read(from: &buf), 
                formActionOrigin: FfiConverterOptionString.read(from: &buf), 
                usernameField: FfiConverterString.read(from: &buf), 
                passwordField: FfiConverterString.read(from: &buf), 
                password: FfiConverterString.read(from: &buf), 
                username: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: LoginEntry, into buf: inout [UInt8]) {
        FfiConverterString.write(value.origin, into: &buf)
        FfiConverterOptionString.write(value.httpRealm, into: &buf)
        FfiConverterOptionString.write(value.formActionOrigin, into: &buf)
        FfiConverterString.write(value.usernameField, into: &buf)
        FfiConverterString.write(value.passwordField, into: &buf)
        FfiConverterString.write(value.password, into: &buf)
        FfiConverterString.write(value.username, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginEntry_lift(_ buf: RustBuffer) throws -> LoginEntry {
    return try FfiConverterTypeLoginEntry.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginEntry_lower(_ value: LoginEntry) -> RustBuffer {
    return FfiConverterTypeLoginEntry.lower(value)
}


/**
 * A login together with record fields, handed over to the store API; ie a login persisted
 * elsewhere, useful for migrations
 */
public struct LoginEntryWithMeta {
    public var entry: LoginEntry
    public var meta: LoginMeta

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(entry: LoginEntry, meta: LoginMeta) {
        self.entry = entry
        self.meta = meta
    }
}

#if compiler(>=6)
extension LoginEntryWithMeta: Sendable {}
#endif


extension LoginEntryWithMeta: Equatable, Hashable {
    public static func ==(lhs: LoginEntryWithMeta, rhs: LoginEntryWithMeta) -> Bool {
        if lhs.entry != rhs.entry {
            return false
        }
        if lhs.meta != rhs.meta {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(entry)
        hasher.combine(meta)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLoginEntryWithMeta: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginEntryWithMeta {
        return
            try LoginEntryWithMeta(
                entry: FfiConverterTypeLoginEntry.read(from: &buf), 
                meta: FfiConverterTypeLoginMeta.read(from: &buf)
        )
    }

    public static func write(_ value: LoginEntryWithMeta, into buf: inout [UInt8]) {
        FfiConverterTypeLoginEntry.write(value.entry, into: &buf)
        FfiConverterTypeLoginMeta.write(value.meta, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginEntryWithMeta_lift(_ buf: RustBuffer) throws -> LoginEntryWithMeta {
    return try FfiConverterTypeLoginEntryWithMeta.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginEntryWithMeta_lower(_ value: LoginEntryWithMeta) -> RustBuffer {
    return FfiConverterTypeLoginEntryWithMeta.lower(value)
}


/**
 * Login data specific to database records.
 * The add_with_record API inputs this.
 */
public struct LoginMeta {
    public var id: String
    public var timesUsed: Int64
    public var timeCreated: Int64
    public var timeLastUsed: Int64
    public var timePasswordChanged: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, timesUsed: Int64, timeCreated: Int64, timeLastUsed: Int64, timePasswordChanged: Int64) {
        self.id = id
        self.timesUsed = timesUsed
        self.timeCreated = timeCreated
        self.timeLastUsed = timeLastUsed
        self.timePasswordChanged = timePasswordChanged
    }
}

#if compiler(>=6)
extension LoginMeta: Sendable {}
#endif


extension LoginMeta: Equatable, Hashable {
    public static func ==(lhs: LoginMeta, rhs: LoginMeta) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.timesUsed != rhs.timesUsed {
            return false
        }
        if lhs.timeCreated != rhs.timeCreated {
            return false
        }
        if lhs.timeLastUsed != rhs.timeLastUsed {
            return false
        }
        if lhs.timePasswordChanged != rhs.timePasswordChanged {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(timesUsed)
        hasher.combine(timeCreated)
        hasher.combine(timeLastUsed)
        hasher.combine(timePasswordChanged)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLoginMeta: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginMeta {
        return
            try LoginMeta(
                id: FfiConverterString.read(from: &buf), 
                timesUsed: FfiConverterInt64.read(from: &buf), 
                timeCreated: FfiConverterInt64.read(from: &buf), 
                timeLastUsed: FfiConverterInt64.read(from: &buf), 
                timePasswordChanged: FfiConverterInt64.read(from: &buf)
        )
    }

    public static func write(_ value: LoginMeta, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterInt64.write(value.timesUsed, into: &buf)
        FfiConverterInt64.write(value.timeCreated, into: &buf)
        FfiConverterInt64.write(value.timeLastUsed, into: &buf)
        FfiConverterInt64.write(value.timePasswordChanged, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginMeta_lift(_ buf: RustBuffer) throws -> LoginMeta {
    return try FfiConverterTypeLoginMeta.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginMeta_lower(_ value: LoginMeta) -> RustBuffer {
    return FfiConverterTypeLoginMeta.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * A bulk insert result entry, returned by `add_many` and `add_many_with_meta`
 */

public enum BulkResultEntry {
    
    case success(login: Login
    )
    case error(message: String
    )
}


#if compiler(>=6)
extension BulkResultEntry: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeBulkResultEntry: FfiConverterRustBuffer {
    typealias SwiftType = BulkResultEntry

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> BulkResultEntry {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .success(login: try FfiConverterTypeLogin.read(from: &buf)
        )
        
        case 2: return .error(message: try FfiConverterString.read(from: &buf)
        )
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: BulkResultEntry, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .success(login):
            writeInt(&buf, Int32(1))
            FfiConverterTypeLogin.write(login, into: &buf)
            
        
        case let .error(message):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(message, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeBulkResultEntry_lift(_ buf: RustBuffer) throws -> BulkResultEntry {
    return try FfiConverterTypeBulkResultEntry.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeBulkResultEntry_lower(_ value: BulkResultEntry) -> RustBuffer {
    return FfiConverterTypeBulkResultEntry.lower(value)
}


extension BulkResultEntry: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum LoginOrErrorMessage {
    
    case login
    case string
}


#if compiler(>=6)
extension LoginOrErrorMessage: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLoginOrErrorMessage: FfiConverterRustBuffer {
    typealias SwiftType = LoginOrErrorMessage

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginOrErrorMessage {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .login
        
        case 2: return .string
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: LoginOrErrorMessage, into buf: inout [UInt8]) {
        switch value {
        
        
        case .login:
            writeInt(&buf, Int32(1))
        
        
        case .string:
            writeInt(&buf, Int32(2))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginOrErrorMessage_lift(_ buf: RustBuffer) throws -> LoginOrErrorMessage {
    return try FfiConverterTypeLoginOrErrorMessage.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginOrErrorMessage_lower(_ value: LoginOrErrorMessage) -> RustBuffer {
    return FfiConverterTypeLoginOrErrorMessage.lower(value)
}


extension LoginOrErrorMessage: Equatable, Hashable {}




/**
 * These are the errors returned by our public API.
 */
public enum LoginsApiError {

    
    
    /**
     * NSS not initialized.
     */
    case NssUninitialized
    /**
     * NSS error during authentication
     */
    case NssAuthenticationError(reason: String
    )
    /**
     * error during authentication (in PrimaryPasswordAuthenticator)
     */
    case AuthenticationError(reason: String
    )
    /**
     * authentication has been cancelled.
     */
    case AuthenticationCanceled
    /**
     * The login data supplied is invalid. The reason will indicate what's wrong with it.
     */
    case InvalidRecord(reason: String
    )
    /**
     * Asking to do something with a guid which doesn't exist.
     */
    case NoSuchRecord(reason: String
    )
    /**
     * Encryption key is missing.
     */
    case MissingKey
    /**
     * Encryption key is not valid.
     */
    case InvalidKey
    /**
     * encryption failed
     */
    case EncryptionFailed(reason: String
    )
    /**
     * decryption failed
     */
    case DecryptionFailed(reason: String
    )
    /**
     * An operation was interrupted at the request of the consuming app.
     */
    case Interrupted(reason: String
    )
    /**
     * Sync reported that authentication failed and the user should re-enter their FxA password.
     */
    case SyncAuthInvalid(reason: String
    )
    /**
     * something internal went wrong which doesn't have a public error value
     * because the consuming app can not reasonably take any action to resolve it.
     * The underlying error will have been logged and reported.
     * (ideally would just be `Unexpected`, but that would be a breaking change)
     */
    case UnexpectedLoginsApiError(reason: String
    )
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLoginsApiError: FfiConverterRustBuffer {
    typealias SwiftType = LoginsApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LoginsApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {

        

        
        case 1: return .NssUninitialized
        case 2: return .NssAuthenticationError(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 3: return .AuthenticationError(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 4: return .AuthenticationCanceled
        case 5: return .InvalidRecord(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 6: return .NoSuchRecord(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 7: return .MissingKey
        case 8: return .InvalidKey
        case 9: return .EncryptionFailed(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 10: return .DecryptionFailed(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 11: return .Interrupted(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 12: return .SyncAuthInvalid(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 13: return .UnexpectedLoginsApiError(
            reason: try FfiConverterString.read(from: &buf)
            )

         default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: LoginsApiError, into buf: inout [UInt8]) {
        switch value {

        

        
        
        case .NssUninitialized:
            writeInt(&buf, Int32(1))
        
        
        case let .NssAuthenticationError(reason):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .AuthenticationError(reason):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(reason, into: &buf)
            
        
        case .AuthenticationCanceled:
            writeInt(&buf, Int32(4))
        
        
        case let .InvalidRecord(reason):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .NoSuchRecord(reason):
            writeInt(&buf, Int32(6))
            FfiConverterString.write(reason, into: &buf)
            
        
        case .MissingKey:
            writeInt(&buf, Int32(7))
        
        
        case .InvalidKey:
            writeInt(&buf, Int32(8))
        
        
        case let .EncryptionFailed(reason):
            writeInt(&buf, Int32(9))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .DecryptionFailed(reason):
            writeInt(&buf, Int32(10))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .Interrupted(reason):
            writeInt(&buf, Int32(11))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .SyncAuthInvalid(reason):
            writeInt(&buf, Int32(12))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .UnexpectedLoginsApiError(reason):
            writeInt(&buf, Int32(13))
            FfiConverterString.write(reason, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginsApiError_lift(_ buf: RustBuffer) throws -> LoginsApiError {
    return try FfiConverterTypeLoginsApiError.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLoginsApiError_lower(_ value: LoginsApiError) -> RustBuffer {
    return FfiConverterTypeLoginsApiError.lower(value)
}


extension LoginsApiError: Equatable, Hashable {}



extension LoginsApiError: Foundation.LocalizedError {
    public var errorDescription: String? {
        String(reflecting: self)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeLogin: FfiConverterRustBuffer {
    typealias SwiftType = Login?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeLogin.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeLogin.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceBool: FfiConverterRustBuffer {
    typealias SwiftType = [Bool]

    public static func write(_ value: [Bool], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterBool.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Bool] {
        let len: Int32 = try readInt(&buf)
        var seq = [Bool]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterBool.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeLogin: FfiConverterRustBuffer {
    typealias SwiftType = [Login]

    public static func write(_ value: [Login], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeLogin.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Login] {
        let len: Int32 = try readInt(&buf)
        var seq = [Login]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeLogin.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeLoginEntry: FfiConverterRustBuffer {
    typealias SwiftType = [LoginEntry]

    public static func write(_ value: [LoginEntry], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeLoginEntry.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [LoginEntry] {
        let len: Int32 = try readInt(&buf)
        var seq = [LoginEntry]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeLoginEntry.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeLoginEntryWithMeta: FfiConverterRustBuffer {
    typealias SwiftType = [LoginEntryWithMeta]

    public static func write(_ value: [LoginEntryWithMeta], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeLoginEntryWithMeta.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [LoginEntryWithMeta] {
        let len: Int32 = try readInt(&buf)
        var seq = [LoginEntryWithMeta]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeLoginEntryWithMeta.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeBulkResultEntry: FfiConverterRustBuffer {
    typealias SwiftType = [BulkResultEntry]

    public static func write(_ value: [BulkResultEntry], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeBulkResultEntry.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [BulkResultEntry] {
        let len: Int32 = try readInt(&buf)
        var seq = [BulkResultEntry]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeBulkResultEntry.read(from: &buf))
        }
        return seq
    }
}
/**
 * Check that key is still valid using the output of `create_canary`.
 */
public func checkCanary(canary: String, text: String, encryptionKey: String)throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_func_check_canary(
        FfiConverterString.lower(canary),
        FfiConverterString.lower(text),
        FfiConverterString.lower(encryptionKey),$0
    )
})
}
/**
 * Create a "canary" string, which can be used to test if the encryption
 */
public func createCanary(text: String, encryptionKey: String)throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_func_create_canary(
        FfiConverterString.lower(text),
        FfiConverterString.lower(encryptionKey),$0
    )
})
}
/**
 * We expose the crypto primitives on the namespace
 * Create a new, random, encryption key.
 */
public func createKey()throws  -> String  {
    return try  FfiConverterString.lift(try rustCallWithError(FfiConverterTypeLoginsApiError_lift) {
    uniffi_logins_fn_func_create_key($0
    )
})
}
/**
 * Create a LoginStore by passing in a db path and a static key
 */
public func createLoginStoreWithStaticKeyManager(path: String, key: String) -> LoginStore  {
    return try!  FfiConverterTypeLoginStore_lift(try! rustCall() {
    uniffi_logins_fn_func_create_login_store_with_static_key_manager(
        FfiConverterString.lower(path),
        FfiConverterString.lower(key),$0
    )
})
}
/**
 * Similar to create_static_key_manager above, create a
 * ManagedEncryptorDecryptor by passing in a KeyManager
 */
public func createManagedEncdec(keyManager: KeyManager) -> EncryptorDecryptor  {
    return try!  FfiConverterTypeEncryptorDecryptor_lift(try! rustCall() {
    uniffi_logins_fn_func_create_managed_encdec(
        FfiConverterTypeKeyManager_lower(keyManager),$0
    )
})
}
/**
 * Utility function to create a StaticKeyManager to be used for the time
 * being until support lands for [trait implementation of an UniFFI
 * interface](https://mozilla.github.io/uniffi-rs/next/proc_macro/index.html#structs-implementing-traits)
 * in UniFFI. 
 */
public func createStaticKeyManager(key: String) -> KeyManager  {
    return try!  FfiConverterTypeKeyManager_lift(try! rustCall() {
    uniffi_logins_fn_func_create_static_key_manager(
        FfiConverterString.lower(key),$0
    )
})
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}
// Use a global variable to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private let initializationResult: InitializationResult = {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_logins_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if (uniffi_logins_checksum_func_check_canary() != 3611) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_func_create_canary() != 45063) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_func_create_key() != 22260) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_func_create_login_store_with_static_key_manager() != 36971) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_func_create_managed_encdec() != 15704) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_func_create_static_key_manager() != 65197) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_encryptordecryptor_decrypt() != 55882) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_encryptordecryptor_encrypt() != 43263) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_keymanager_get_key() != 62087) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_add() != 62811) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_add_many() != 3267) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_add_many_with_meta() != 37365) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_add_or_update() != 37950) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_add_with_meta() != 34738) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_count() != 59175) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_count_by_form_action_origin() != 11815) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_count_by_origin() != 37630) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_delete() != 44678) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_delete_many() != 14564) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_delete_undecryptable_records_for_remote_replacement() != 23503) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_find_login_to_update() != 62416) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_get() != 49975) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_get_by_base_domain() != 29790) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_get_checkpoint() != 4346) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_has_logins_by_base_domain() != 20011) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_is_empty() != 27766) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_list() != 58635) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_register_with_sync_manager() != 7518) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_reset() != 63814) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_run_maintenance() != 64480) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_set_checkpoint() != 62504) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_touch() != 37362) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_update() != 29794) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_method_loginstore_wipe_local() != 2650) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_constructor_loginstore_new() != 9176) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_constructor_managedencryptordecryptor_new() != 21280) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_logins_checksum_constructor_statickeymanager_new() != 3408) {
        return InitializationResult.apiChecksumMismatch
    }

    uniffiCallbackInitEncryptorDecryptor()
    uniffiCallbackInitKeyManager()
    return InitializationResult.ok
}()

// Make the ensure init function public so that other modules which have external type references to
// our types can call it.
public func uniffiEnsureLoginsInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all