// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
import MozillaRustComponents
#endif

fileprivate extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len:0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_merino_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_merino_rustbuffer_free(self, $0) }
    }
}

fileprivate extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

fileprivate extension Data {
    init(rustBuffer: RustBuffer) {
        self.init(
            bytesNoCopy: rustBuffer.data!,
            count: Int(rustBuffer.len),
            deallocator: .none
        )
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

fileprivate func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
fileprivate func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset..<reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value, { reader.data.copyBytes(to: $0, from: range)})
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
fileprivate func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> Array<UInt8> {
    let range = reader.offset..<(reader.offset+count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer({ buffer in
        reader.data.copyBytes(to: buffer, from: range)
    })
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
fileprivate func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return Float(bitPattern: try readInt(&reader))
}

// Reads a float at the current offset.
fileprivate func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return Double(bitPattern: try readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
fileprivate func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

fileprivate func createWriter() -> [UInt8] {
    return []
}

fileprivate func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
fileprivate func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

fileprivate func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

fileprivate func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous to the Rust trait of the same name.
fileprivate protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
fileprivate protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType { }

extension FfiConverterPrimitive {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
fileprivate protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> RustBuffer {
          var writer = createWriter()
          write(value, into: &writer)
          return RustBuffer(bytes: writer)
    }
}
// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
fileprivate enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

fileprivate extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        self.lock()
        defer { self.unlock() }
        return try f()
    }
}

fileprivate let CALL_SUCCESS: Int8 = 0
fileprivate let CALL_ERROR: Int8 = 1
fileprivate let CALL_UNEXPECTED_ERROR: Int8 = 2
fileprivate let CALL_CANCELLED: Int8 = 3

fileprivate extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer.init(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    let neverThrow: ((RustBuffer) throws -> Never)? = nil
    return try makeRustCall(callback, errorHandler: neverThrow)
}

private func rustCallWithError<T, E: Swift.Error>(
    _ errorHandler: @escaping (RustBuffer) throws -> E,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T, E: Swift.Error>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> E)?
) throws -> T {
    uniffiEnsureMerinoInitialized()
    var callStatus = RustCallStatus.init()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus<E: Swift.Error>(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> E)?
) throws {
    switch callStatus.code {
        case CALL_SUCCESS:
            return

        case CALL_ERROR:
            if let errorHandler = errorHandler {
                throw try errorHandler(callStatus.errorBuf)
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.unexpectedRustCallError
            }

        case CALL_UNEXPECTED_ERROR:
            // When the rust code sees a panic, it tries to construct a RustBuffer
            // with the message.  But if that code panics, then it just sends back
            // an empty buffer.
            if callStatus.errorBuf.len > 0 {
                throw UniffiInternalError.rustPanic(try FfiConverterString.lift(callStatus.errorBuf))
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.rustPanic("Rust panic")
            }

        case CALL_CANCELLED:
            fatalError("Cancellation not supported yet")

        default:
            throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> ()
) {
    do {
        try writeReturn(makeCall())
    } catch let error {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> (),
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}
fileprivate final class UniffiHandleMap<T>: @unchecked Sendable {
    // All mutation happens with this lock held, which is why we implement @unchecked Sendable.
    private let lock = NSLock()
    private var map: [UInt64: T] = [:]
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

     func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        get {
            map.count
        }
    }
}


// Public interface members begin here.


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterUInt16: FfiConverterPrimitive {
    typealias FfiType = UInt16
    typealias SwiftType = UInt16

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt16 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterInt32: FfiConverterPrimitive {
    typealias FfiType = Int32
    typealias SwiftType = Int32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int32, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterBool : FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return String(bytes: try readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}




public protocol CuratedRecommendationsClientProtocol: AnyObject {
    
    func getCuratedRecommendations(request: CuratedRecommendationsRequest) throws  -> CuratedRecommendationsResponse
    
}
open class CuratedRecommendationsClient: CuratedRecommendationsClientProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_merino_fn_clone_curatedrecommendationsclient(self.pointer, $0) }
    }
public convenience init(config: CuratedRecommendationsConfig)throws  {
    let pointer =
        try rustCallWithError(FfiConverterTypeCuratedRecommendationsApiError_lift) {
    uniffi_merino_fn_constructor_curatedrecommendationsclient_new(
        FfiConverterTypeCuratedRecommendationsConfig_lower(config),$0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_merino_fn_free_curatedrecommendationsclient(pointer, $0) }
    }

    

    
open func getCuratedRecommendations(request: CuratedRecommendationsRequest)throws  -> CuratedRecommendationsResponse  {
    return try  FfiConverterTypeCuratedRecommendationsResponse_lift(try rustCallWithError(FfiConverterTypeCuratedRecommendationsApiError_lift) {
    uniffi_merino_fn_method_curatedrecommendationsclient_get_curated_recommendations(self.uniffiClonePointer(),
        FfiConverterTypeCuratedRecommendationsRequest_lower(request),$0
    )
})
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationsClient: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = CuratedRecommendationsClient

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> CuratedRecommendationsClient {
        return CuratedRecommendationsClient(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: CuratedRecommendationsClient) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationsClient {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: CuratedRecommendationsClient, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsClient_lift(_ pointer: UnsafeMutableRawPointer) throws -> CuratedRecommendationsClient {
    return try FfiConverterTypeCuratedRecommendationsClient.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsClient_lower(_ value: CuratedRecommendationsClient) -> UnsafeMutableRawPointer {
    return FfiConverterTypeCuratedRecommendationsClient.lower(value)
}




public struct CuratedRecommendationsBucket {
    public var recommendations: [RecommendationDataItem]
    public var title: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(recommendations: [RecommendationDataItem], title: String? = nil) {
        self.recommendations = recommendations
        self.title = title
    }
}

#if compiler(>=6)
extension CuratedRecommendationsBucket: Sendable {}
#endif


extension CuratedRecommendationsBucket: Equatable, Hashable {
    public static func ==(lhs: CuratedRecommendationsBucket, rhs: CuratedRecommendationsBucket) -> Bool {
        if lhs.recommendations != rhs.recommendations {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(recommendations)
        hasher.combine(title)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationsBucket: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationsBucket {
        return
            try CuratedRecommendationsBucket(
                recommendations: FfiConverterSequenceTypeRecommendationDataItem.read(from: &buf), 
                title: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: CuratedRecommendationsBucket, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeRecommendationDataItem.write(value.recommendations, into: &buf)
        FfiConverterOptionString.write(value.title, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsBucket_lift(_ buf: RustBuffer) throws -> CuratedRecommendationsBucket {
    return try FfiConverterTypeCuratedRecommendationsBucket.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsBucket_lower(_ value: CuratedRecommendationsBucket) -> RustBuffer {
    return FfiConverterTypeCuratedRecommendationsBucket.lower(value)
}


public struct CuratedRecommendationsConfig {
    public var baseHost: String?
    public var userAgentHeader: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(baseHost: String?, userAgentHeader: String) {
        self.baseHost = baseHost
        self.userAgentHeader = userAgentHeader
    }
}

#if compiler(>=6)
extension CuratedRecommendationsConfig: Sendable {}
#endif


extension CuratedRecommendationsConfig: Equatable, Hashable {
    public static func ==(lhs: CuratedRecommendationsConfig, rhs: CuratedRecommendationsConfig) -> Bool {
        if lhs.baseHost != rhs.baseHost {
            return false
        }
        if lhs.userAgentHeader != rhs.userAgentHeader {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(baseHost)
        hasher.combine(userAgentHeader)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationsConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationsConfig {
        return
            try CuratedRecommendationsConfig(
                baseHost: FfiConverterOptionString.read(from: &buf), 
                userAgentHeader: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: CuratedRecommendationsConfig, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.baseHost, into: &buf)
        FfiConverterString.write(value.userAgentHeader, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsConfig_lift(_ buf: RustBuffer) throws -> CuratedRecommendationsConfig {
    return try FfiConverterTypeCuratedRecommendationsConfig.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsConfig_lower(_ value: CuratedRecommendationsConfig) -> RustBuffer {
    return FfiConverterTypeCuratedRecommendationsConfig.lower(value)
}


public struct CuratedRecommendationsRequest {
    public var locale: CuratedRecommendationLocale
    public var region: String?
    public var count: Int32?
    public var topics: [String]?
    public var feeds: [String]?
    public var sections: [SectionSettings]?
    public var experimentName: String?
    public var experimentBranch: String?
    public var enableInterestPicker: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(locale: CuratedRecommendationLocale, region: String? = nil, count: Int32? = 100, topics: [String]? = nil, feeds: [String]? = nil, sections: [SectionSettings]? = nil, experimentName: String? = nil, experimentBranch: String? = nil, enableInterestPicker: Bool = false) {
        self.locale = locale
        self.region = region
        self.count = count
        self.topics = topics
        self.feeds = feeds
        self.sections = sections
        self.experimentName = experimentName
        self.experimentBranch = experimentBranch
        self.enableInterestPicker = enableInterestPicker
    }
}

#if compiler(>=6)
extension CuratedRecommendationsRequest: Sendable {}
#endif


extension CuratedRecommendationsRequest: Equatable, Hashable {
    public static func ==(lhs: CuratedRecommendationsRequest, rhs: CuratedRecommendationsRequest) -> Bool {
        if lhs.locale != rhs.locale {
            return false
        }
        if lhs.region != rhs.region {
            return false
        }
        if lhs.count != rhs.count {
            return false
        }
        if lhs.topics != rhs.topics {
            return false
        }
        if lhs.feeds != rhs.feeds {
            return false
        }
        if lhs.sections != rhs.sections {
            return false
        }
        if lhs.experimentName != rhs.experimentName {
            return false
        }
        if lhs.experimentBranch != rhs.experimentBranch {
            return false
        }
        if lhs.enableInterestPicker != rhs.enableInterestPicker {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(locale)
        hasher.combine(region)
        hasher.combine(count)
        hasher.combine(topics)
        hasher.combine(feeds)
        hasher.combine(sections)
        hasher.combine(experimentName)
        hasher.combine(experimentBranch)
        hasher.combine(enableInterestPicker)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationsRequest: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationsRequest {
        return
            try CuratedRecommendationsRequest(
                locale: FfiConverterTypeCuratedRecommendationLocale.read(from: &buf), 
                region: FfiConverterOptionString.read(from: &buf), 
                count: FfiConverterOptionInt32.read(from: &buf), 
                topics: FfiConverterOptionSequenceString.read(from: &buf), 
                feeds: FfiConverterOptionSequenceString.read(from: &buf), 
                sections: FfiConverterOptionSequenceTypeSectionSettings.read(from: &buf), 
                experimentName: FfiConverterOptionString.read(from: &buf), 
                experimentBranch: FfiConverterOptionString.read(from: &buf), 
                enableInterestPicker: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: CuratedRecommendationsRequest, into buf: inout [UInt8]) {
        FfiConverterTypeCuratedRecommendationLocale.write(value.locale, into: &buf)
        FfiConverterOptionString.write(value.region, into: &buf)
        FfiConverterOptionInt32.write(value.count, into: &buf)
        FfiConverterOptionSequenceString.write(value.topics, into: &buf)
        FfiConverterOptionSequenceString.write(value.feeds, into: &buf)
        FfiConverterOptionSequenceTypeSectionSettings.write(value.sections, into: &buf)
        FfiConverterOptionString.write(value.experimentName, into: &buf)
        FfiConverterOptionString.write(value.experimentBranch, into: &buf)
        FfiConverterBool.write(value.enableInterestPicker, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsRequest_lift(_ buf: RustBuffer) throws -> CuratedRecommendationsRequest {
    return try FfiConverterTypeCuratedRecommendationsRequest.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsRequest_lower(_ value: CuratedRecommendationsRequest) -> RustBuffer {
    return FfiConverterTypeCuratedRecommendationsRequest.lower(value)
}


public struct CuratedRecommendationsResponse {
    public var recommendedAt: Int64
    public var data: [RecommendationDataItem]
    public var feeds: Feeds?
    public var interestPicker: InterestPicker?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(recommendedAt: Int64, data: [RecommendationDataItem], feeds: Feeds? = nil, interestPicker: InterestPicker? = nil) {
        self.recommendedAt = recommendedAt
        self.data = data
        self.feeds = feeds
        self.interestPicker = interestPicker
    }
}

#if compiler(>=6)
extension CuratedRecommendationsResponse: Sendable {}
#endif


extension CuratedRecommendationsResponse: Equatable, Hashable {
    public static func ==(lhs: CuratedRecommendationsResponse, rhs: CuratedRecommendationsResponse) -> Bool {
        if lhs.recommendedAt != rhs.recommendedAt {
            return false
        }
        if lhs.data != rhs.data {
            return false
        }
        if lhs.feeds != rhs.feeds {
            return false
        }
        if lhs.interestPicker != rhs.interestPicker {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(recommendedAt)
        hasher.combine(data)
        hasher.combine(feeds)
        hasher.combine(interestPicker)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationsResponse: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationsResponse {
        return
            try CuratedRecommendationsResponse(
                recommendedAt: FfiConverterInt64.read(from: &buf), 
                data: FfiConverterSequenceTypeRecommendationDataItem.read(from: &buf), 
                feeds: FfiConverterOptionTypeFeeds.read(from: &buf), 
                interestPicker: FfiConverterOptionTypeInterestPicker.read(from: &buf)
        )
    }

    public static func write(_ value: CuratedRecommendationsResponse, into buf: inout [UInt8]) {
        FfiConverterInt64.write(value.recommendedAt, into: &buf)
        FfiConverterSequenceTypeRecommendationDataItem.write(value.data, into: &buf)
        FfiConverterOptionTypeFeeds.write(value.feeds, into: &buf)
        FfiConverterOptionTypeInterestPicker.write(value.interestPicker, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsResponse_lift(_ buf: RustBuffer) throws -> CuratedRecommendationsResponse {
    return try FfiConverterTypeCuratedRecommendationsResponse.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsResponse_lower(_ value: CuratedRecommendationsResponse) -> RustBuffer {
    return FfiConverterTypeCuratedRecommendationsResponse.lower(value)
}


public struct FakespotCta {
    public var ctaCopy: String
    public var url: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(ctaCopy: String, url: String) {
        self.ctaCopy = ctaCopy
        self.url = url
    }
}

#if compiler(>=6)
extension FakespotCta: Sendable {}
#endif


extension FakespotCta: Equatable, Hashable {
    public static func ==(lhs: FakespotCta, rhs: FakespotCta) -> Bool {
        if lhs.ctaCopy != rhs.ctaCopy {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(ctaCopy)
        hasher.combine(url)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFakespotCta: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FakespotCta {
        return
            try FakespotCta(
                ctaCopy: FfiConverterString.read(from: &buf), 
                url: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: FakespotCta, into buf: inout [UInt8]) {
        FfiConverterString.write(value.ctaCopy, into: &buf)
        FfiConverterString.write(value.url, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFakespotCta_lift(_ buf: RustBuffer) throws -> FakespotCta {
    return try FfiConverterTypeFakespotCta.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFakespotCta_lower(_ value: FakespotCta) -> RustBuffer {
    return FfiConverterTypeFakespotCta.lower(value)
}


public struct FakespotFeed {
    public var products: [FakespotProduct]
    public var defaultCategoryName: String
    public var headerCopy: String
    public var footerCopy: String
    public var cta: FakespotCta

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(products: [FakespotProduct], defaultCategoryName: String, headerCopy: String, footerCopy: String, cta: FakespotCta) {
        self.products = products
        self.defaultCategoryName = defaultCategoryName
        self.headerCopy = headerCopy
        self.footerCopy = footerCopy
        self.cta = cta
    }
}

#if compiler(>=6)
extension FakespotFeed: Sendable {}
#endif


extension FakespotFeed: Equatable, Hashable {
    public static func ==(lhs: FakespotFeed, rhs: FakespotFeed) -> Bool {
        if lhs.products != rhs.products {
            return false
        }
        if lhs.defaultCategoryName != rhs.defaultCategoryName {
            return false
        }
        if lhs.headerCopy != rhs.headerCopy {
            return false
        }
        if lhs.footerCopy != rhs.footerCopy {
            return false
        }
        if lhs.cta != rhs.cta {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(products)
        hasher.combine(defaultCategoryName)
        hasher.combine(headerCopy)
        hasher.combine(footerCopy)
        hasher.combine(cta)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFakespotFeed: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FakespotFeed {
        return
            try FakespotFeed(
                products: FfiConverterSequenceTypeFakespotProduct.read(from: &buf), 
                defaultCategoryName: FfiConverterString.read(from: &buf), 
                headerCopy: FfiConverterString.read(from: &buf), 
                footerCopy: FfiConverterString.read(from: &buf), 
                cta: FfiConverterTypeFakespotCta.read(from: &buf)
        )
    }

    public static func write(_ value: FakespotFeed, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeFakespotProduct.write(value.products, into: &buf)
        FfiConverterString.write(value.defaultCategoryName, into: &buf)
        FfiConverterString.write(value.headerCopy, into: &buf)
        FfiConverterString.write(value.footerCopy, into: &buf)
        FfiConverterTypeFakespotCta.write(value.cta, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFakespotFeed_lift(_ buf: RustBuffer) throws -> FakespotFeed {
    return try FfiConverterTypeFakespotFeed.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFakespotFeed_lower(_ value: FakespotFeed) -> RustBuffer {
    return FfiConverterTypeFakespotFeed.lower(value)
}


public struct FakespotProduct {
    public var id: String
    public var title: String
    public var category: String
    public var imageUrl: String
    public var url: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(id: String, title: String, category: String, imageUrl: String, url: String) {
        self.id = id
        self.title = title
        self.category = category
        self.imageUrl = imageUrl
        self.url = url
    }
}

#if compiler(>=6)
extension FakespotProduct: Sendable {}
#endif


extension FakespotProduct: Equatable, Hashable {
    public static func ==(lhs: FakespotProduct, rhs: FakespotProduct) -> Bool {
        if lhs.id != rhs.id {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.category != rhs.category {
            return false
        }
        if lhs.imageUrl != rhs.imageUrl {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(id)
        hasher.combine(title)
        hasher.combine(category)
        hasher.combine(imageUrl)
        hasher.combine(url)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFakespotProduct: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FakespotProduct {
        return
            try FakespotProduct(
                id: FfiConverterString.read(from: &buf), 
                title: FfiConverterString.read(from: &buf), 
                category: FfiConverterString.read(from: &buf), 
                imageUrl: FfiConverterString.read(from: &buf), 
                url: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: FakespotProduct, into buf: inout [UInt8]) {
        FfiConverterString.write(value.id, into: &buf)
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterString.write(value.category, into: &buf)
        FfiConverterString.write(value.imageUrl, into: &buf)
        FfiConverterString.write(value.url, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFakespotProduct_lift(_ buf: RustBuffer) throws -> FakespotProduct {
    return try FfiConverterTypeFakespotProduct.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFakespotProduct_lower(_ value: FakespotProduct) -> RustBuffer {
    return FfiConverterTypeFakespotProduct.lower(value)
}


public struct FeedSection {
    public var receivedFeedRank: Int32
    public var recommendations: [RecommendationDataItem]
    public var title: String
    public var subtitle: String?
    public var layout: Layout
    public var isFollowed: Bool
    public var isBlocked: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(receivedFeedRank: Int32, recommendations: [RecommendationDataItem], title: String, subtitle: String? = nil, layout: Layout, isFollowed: Bool, isBlocked: Bool) {
        self.receivedFeedRank = receivedFeedRank
        self.recommendations = recommendations
        self.title = title
        self.subtitle = subtitle
        self.layout = layout
        self.isFollowed = isFollowed
        self.isBlocked = isBlocked
    }
}

#if compiler(>=6)
extension FeedSection: Sendable {}
#endif


extension FeedSection: Equatable, Hashable {
    public static func ==(lhs: FeedSection, rhs: FeedSection) -> Bool {
        if lhs.receivedFeedRank != rhs.receivedFeedRank {
            return false
        }
        if lhs.recommendations != rhs.recommendations {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.subtitle != rhs.subtitle {
            return false
        }
        if lhs.layout != rhs.layout {
            return false
        }
        if lhs.isFollowed != rhs.isFollowed {
            return false
        }
        if lhs.isBlocked != rhs.isBlocked {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(receivedFeedRank)
        hasher.combine(recommendations)
        hasher.combine(title)
        hasher.combine(subtitle)
        hasher.combine(layout)
        hasher.combine(isFollowed)
        hasher.combine(isBlocked)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFeedSection: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FeedSection {
        return
            try FeedSection(
                receivedFeedRank: FfiConverterInt32.read(from: &buf), 
                recommendations: FfiConverterSequenceTypeRecommendationDataItem.read(from: &buf), 
                title: FfiConverterString.read(from: &buf), 
                subtitle: FfiConverterOptionString.read(from: &buf), 
                layout: FfiConverterTypeLayout.read(from: &buf), 
                isFollowed: FfiConverterBool.read(from: &buf), 
                isBlocked: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: FeedSection, into buf: inout [UInt8]) {
        FfiConverterInt32.write(value.receivedFeedRank, into: &buf)
        FfiConverterSequenceTypeRecommendationDataItem.write(value.recommendations, into: &buf)
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterOptionString.write(value.subtitle, into: &buf)
        FfiConverterTypeLayout.write(value.layout, into: &buf)
        FfiConverterBool.write(value.isFollowed, into: &buf)
        FfiConverterBool.write(value.isBlocked, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFeedSection_lift(_ buf: RustBuffer) throws -> FeedSection {
    return try FfiConverterTypeFeedSection.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFeedSection_lower(_ value: FeedSection) -> RustBuffer {
    return FfiConverterTypeFeedSection.lower(value)
}


public struct Feeds {
    public var needToKnow: CuratedRecommendationsBucket?
    public var fakespot: FakespotFeed?
    public var topStoriesSection: FeedSection?
    public var business: FeedSection?
    public var career: FeedSection?
    public var arts: FeedSection?
    public var food: FeedSection?
    public var health: FeedSection?
    public var home: FeedSection?
    public var finance: FeedSection?
    public var government: FeedSection?
    public var sports: FeedSection?
    public var tech: FeedSection?
    public var travel: FeedSection?
    public var education: FeedSection?
    public var hobbies: FeedSection?
    public var societyParenting: FeedSection?
    public var educationScience: FeedSection?
    public var society: FeedSection?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(needToKnow: CuratedRecommendationsBucket? = nil, fakespot: FakespotFeed? = nil, topStoriesSection: FeedSection? = nil, business: FeedSection? = nil, career: FeedSection? = nil, arts: FeedSection? = nil, food: FeedSection? = nil, health: FeedSection? = nil, home: FeedSection? = nil, finance: FeedSection? = nil, government: FeedSection? = nil, sports: FeedSection? = nil, tech: FeedSection? = nil, travel: FeedSection? = nil, education: FeedSection? = nil, hobbies: FeedSection? = nil, societyParenting: FeedSection? = nil, educationScience: FeedSection? = nil, society: FeedSection? = nil) {
        self.needToKnow = needToKnow
        self.fakespot = fakespot
        self.topStoriesSection = topStoriesSection
        self.business = business
        self.career = career
        self.arts = arts
        self.food = food
        self.health = health
        self.home = home
        self.finance = finance
        self.government = government
        self.sports = sports
        self.tech = tech
        self.travel = travel
        self.education = education
        self.hobbies = hobbies
        self.societyParenting = societyParenting
        self.educationScience = educationScience
        self.society = society
    }
}

#if compiler(>=6)
extension Feeds: Sendable {}
#endif


extension Feeds: Equatable, Hashable {
    public static func ==(lhs: Feeds, rhs: Feeds) -> Bool {
        if lhs.needToKnow != rhs.needToKnow {
            return false
        }
        if lhs.fakespot != rhs.fakespot {
            return false
        }
        if lhs.topStoriesSection != rhs.topStoriesSection {
            return false
        }
        if lhs.business != rhs.business {
            return false
        }
        if lhs.career != rhs.career {
            return false
        }
        if lhs.arts != rhs.arts {
            return false
        }
        if lhs.food != rhs.food {
            return false
        }
        if lhs.health != rhs.health {
            return false
        }
        if lhs.home != rhs.home {
            return false
        }
        if lhs.finance != rhs.finance {
            return false
        }
        if lhs.government != rhs.government {
            return false
        }
        if lhs.sports != rhs.sports {
            return false
        }
        if lhs.tech != rhs.tech {
            return false
        }
        if lhs.travel != rhs.travel {
            return false
        }
        if lhs.education != rhs.education {
            return false
        }
        if lhs.hobbies != rhs.hobbies {
            return false
        }
        if lhs.societyParenting != rhs.societyParenting {
            return false
        }
        if lhs.educationScience != rhs.educationScience {
            return false
        }
        if lhs.society != rhs.society {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(needToKnow)
        hasher.combine(fakespot)
        hasher.combine(topStoriesSection)
        hasher.combine(business)
        hasher.combine(career)
        hasher.combine(arts)
        hasher.combine(food)
        hasher.combine(health)
        hasher.combine(home)
        hasher.combine(finance)
        hasher.combine(government)
        hasher.combine(sports)
        hasher.combine(tech)
        hasher.combine(travel)
        hasher.combine(education)
        hasher.combine(hobbies)
        hasher.combine(societyParenting)
        hasher.combine(educationScience)
        hasher.combine(society)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFeeds: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Feeds {
        return
            try Feeds(
                needToKnow: FfiConverterOptionTypeCuratedRecommendationsBucket.read(from: &buf), 
                fakespot: FfiConverterOptionTypeFakespotFeed.read(from: &buf), 
                topStoriesSection: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                business: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                career: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                arts: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                food: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                health: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                home: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                finance: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                government: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                sports: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                tech: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                travel: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                education: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                hobbies: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                societyParenting: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                educationScience: FfiConverterOptionTypeFeedSection.read(from: &buf), 
                society: FfiConverterOptionTypeFeedSection.read(from: &buf)
        )
    }

    public static func write(_ value: Feeds, into buf: inout [UInt8]) {
        FfiConverterOptionTypeCuratedRecommendationsBucket.write(value.needToKnow, into: &buf)
        FfiConverterOptionTypeFakespotFeed.write(value.fakespot, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.topStoriesSection, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.business, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.career, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.arts, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.food, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.health, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.home, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.finance, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.government, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.sports, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.tech, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.travel, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.education, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.hobbies, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.societyParenting, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.educationScience, into: &buf)
        FfiConverterOptionTypeFeedSection.write(value.society, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFeeds_lift(_ buf: RustBuffer) throws -> Feeds {
    return try FfiConverterTypeFeeds.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFeeds_lower(_ value: Feeds) -> RustBuffer {
    return FfiConverterTypeFeeds.lower(value)
}


public struct InterestPicker {
    public var receivedFeedRank: Int32
    public var title: String
    public var subtitle: String
    public var sections: [InterestPickerSection]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(receivedFeedRank: Int32, title: String, subtitle: String, sections: [InterestPickerSection]) {
        self.receivedFeedRank = receivedFeedRank
        self.title = title
        self.subtitle = subtitle
        self.sections = sections
    }
}

#if compiler(>=6)
extension InterestPicker: Sendable {}
#endif


extension InterestPicker: Equatable, Hashable {
    public static func ==(lhs: InterestPicker, rhs: InterestPicker) -> Bool {
        if lhs.receivedFeedRank != rhs.receivedFeedRank {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.subtitle != rhs.subtitle {
            return false
        }
        if lhs.sections != rhs.sections {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(receivedFeedRank)
        hasher.combine(title)
        hasher.combine(subtitle)
        hasher.combine(sections)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeInterestPicker: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InterestPicker {
        return
            try InterestPicker(
                receivedFeedRank: FfiConverterInt32.read(from: &buf), 
                title: FfiConverterString.read(from: &buf), 
                subtitle: FfiConverterString.read(from: &buf), 
                sections: FfiConverterSequenceTypeInterestPickerSection.read(from: &buf)
        )
    }

    public static func write(_ value: InterestPicker, into buf: inout [UInt8]) {
        FfiConverterInt32.write(value.receivedFeedRank, into: &buf)
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterString.write(value.subtitle, into: &buf)
        FfiConverterSequenceTypeInterestPickerSection.write(value.sections, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeInterestPicker_lift(_ buf: RustBuffer) throws -> InterestPicker {
    return try FfiConverterTypeInterestPicker.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeInterestPicker_lower(_ value: InterestPicker) -> RustBuffer {
    return FfiConverterTypeInterestPicker.lower(value)
}


public struct InterestPickerSection {
    public var sectionId: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(sectionId: String) {
        self.sectionId = sectionId
    }
}

#if compiler(>=6)
extension InterestPickerSection: Sendable {}
#endif


extension InterestPickerSection: Equatable, Hashable {
    public static func ==(lhs: InterestPickerSection, rhs: InterestPickerSection) -> Bool {
        if lhs.sectionId != rhs.sectionId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(sectionId)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeInterestPickerSection: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InterestPickerSection {
        return
            try InterestPickerSection(
                sectionId: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: InterestPickerSection, into buf: inout [UInt8]) {
        FfiConverterString.write(value.sectionId, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeInterestPickerSection_lift(_ buf: RustBuffer) throws -> InterestPickerSection {
    return try FfiConverterTypeInterestPickerSection.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeInterestPickerSection_lower(_ value: InterestPickerSection) -> RustBuffer {
    return FfiConverterTypeInterestPickerSection.lower(value)
}


public struct Layout {
    public var name: String
    public var responsiveLayouts: [ResponsiveLayout]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(name: String, responsiveLayouts: [ResponsiveLayout]) {
        self.name = name
        self.responsiveLayouts = responsiveLayouts
    }
}

#if compiler(>=6)
extension Layout: Sendable {}
#endif


extension Layout: Equatable, Hashable {
    public static func ==(lhs: Layout, rhs: Layout) -> Bool {
        if lhs.name != rhs.name {
            return false
        }
        if lhs.responsiveLayouts != rhs.responsiveLayouts {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(name)
        hasher.combine(responsiveLayouts)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLayout: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Layout {
        return
            try Layout(
                name: FfiConverterString.read(from: &buf), 
                responsiveLayouts: FfiConverterSequenceTypeResponsiveLayout.read(from: &buf)
        )
    }

    public static func write(_ value: Layout, into buf: inout [UInt8]) {
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterSequenceTypeResponsiveLayout.write(value.responsiveLayouts, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLayout_lift(_ buf: RustBuffer) throws -> Layout {
    return try FfiConverterTypeLayout.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLayout_lower(_ value: Layout) -> RustBuffer {
    return FfiConverterTypeLayout.lower(value)
}


public struct RecommendationDataItem {
    public var corpusItemId: String
    public var scheduledCorpusItemId: String
    public var url: String
    public var title: String
    public var excerpt: String
    public var topic: String?
    public var publisher: String
    public var isTimeSensitive: Bool
    public var imageUrl: String
    public var iconUrl: String?
    public var tileId: Int64
    public var receivedRank: Int64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(corpusItemId: String, scheduledCorpusItemId: String, url: String, title: String, excerpt: String, topic: String? = nil, publisher: String, isTimeSensitive: Bool, imageUrl: String, iconUrl: String?, tileId: Int64, receivedRank: Int64) {
        self.corpusItemId = corpusItemId
        self.scheduledCorpusItemId = scheduledCorpusItemId
        self.url = url
        self.title = title
        self.excerpt = excerpt
        self.topic = topic
        self.publisher = publisher
        self.isTimeSensitive = isTimeSensitive
        self.imageUrl = imageUrl
        self.iconUrl = iconUrl
        self.tileId = tileId
        self.receivedRank = receivedRank
    }
}

#if compiler(>=6)
extension RecommendationDataItem: Sendable {}
#endif


extension RecommendationDataItem: Equatable, Hashable {
    public static func ==(lhs: RecommendationDataItem, rhs: RecommendationDataItem) -> Bool {
        if lhs.corpusItemId != rhs.corpusItemId {
            return false
        }
        if lhs.scheduledCorpusItemId != rhs.scheduledCorpusItemId {
            return false
        }
        if lhs.url != rhs.url {
            return false
        }
        if lhs.title != rhs.title {
            return false
        }
        if lhs.excerpt != rhs.excerpt {
            return false
        }
        if lhs.topic != rhs.topic {
            return false
        }
        if lhs.publisher != rhs.publisher {
            return false
        }
        if lhs.isTimeSensitive != rhs.isTimeSensitive {
            return false
        }
        if lhs.imageUrl != rhs.imageUrl {
            return false
        }
        if lhs.iconUrl != rhs.iconUrl {
            return false
        }
        if lhs.tileId != rhs.tileId {
            return false
        }
        if lhs.receivedRank != rhs.receivedRank {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(corpusItemId)
        hasher.combine(scheduledCorpusItemId)
        hasher.combine(url)
        hasher.combine(title)
        hasher.combine(excerpt)
        hasher.combine(topic)
        hasher.combine(publisher)
        hasher.combine(isTimeSensitive)
        hasher.combine(imageUrl)
        hasher.combine(iconUrl)
        hasher.combine(tileId)
        hasher.combine(receivedRank)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeRecommendationDataItem: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> RecommendationDataItem {
        return
            try RecommendationDataItem(
                corpusItemId: FfiConverterString.read(from: &buf), 
                scheduledCorpusItemId: FfiConverterString.read(from: &buf), 
                url: FfiConverterString.read(from: &buf), 
                title: FfiConverterString.read(from: &buf), 
                excerpt: FfiConverterString.read(from: &buf), 
                topic: FfiConverterOptionString.read(from: &buf), 
                publisher: FfiConverterString.read(from: &buf), 
                isTimeSensitive: FfiConverterBool.read(from: &buf), 
                imageUrl: FfiConverterString.read(from: &buf), 
                iconUrl: FfiConverterOptionString.read(from: &buf), 
                tileId: FfiConverterInt64.read(from: &buf), 
                receivedRank: FfiConverterInt64.read(from: &buf)
        )
    }

    public static func write(_ value: RecommendationDataItem, into buf: inout [UInt8]) {
        FfiConverterString.write(value.corpusItemId, into: &buf)
        FfiConverterString.write(value.scheduledCorpusItemId, into: &buf)
        FfiConverterString.write(value.url, into: &buf)
        FfiConverterString.write(value.title, into: &buf)
        FfiConverterString.write(value.excerpt, into: &buf)
        FfiConverterOptionString.write(value.topic, into: &buf)
        FfiConverterString.write(value.publisher, into: &buf)
        FfiConverterBool.write(value.isTimeSensitive, into: &buf)
        FfiConverterString.write(value.imageUrl, into: &buf)
        FfiConverterOptionString.write(value.iconUrl, into: &buf)
        FfiConverterInt64.write(value.tileId, into: &buf)
        FfiConverterInt64.write(value.receivedRank, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeRecommendationDataItem_lift(_ buf: RustBuffer) throws -> RecommendationDataItem {
    return try FfiConverterTypeRecommendationDataItem.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeRecommendationDataItem_lower(_ value: RecommendationDataItem) -> RustBuffer {
    return FfiConverterTypeRecommendationDataItem.lower(value)
}


public struct ResponsiveLayout {
    public var columnCount: Int32
    public var tiles: [Tile]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(columnCount: Int32, tiles: [Tile]) {
        self.columnCount = columnCount
        self.tiles = tiles
    }
}

#if compiler(>=6)
extension ResponsiveLayout: Sendable {}
#endif


extension ResponsiveLayout: Equatable, Hashable {
    public static func ==(lhs: ResponsiveLayout, rhs: ResponsiveLayout) -> Bool {
        if lhs.columnCount != rhs.columnCount {
            return false
        }
        if lhs.tiles != rhs.tiles {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(columnCount)
        hasher.combine(tiles)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeResponsiveLayout: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ResponsiveLayout {
        return
            try ResponsiveLayout(
                columnCount: FfiConverterInt32.read(from: &buf), 
                tiles: FfiConverterSequenceTypeTile.read(from: &buf)
        )
    }

    public static func write(_ value: ResponsiveLayout, into buf: inout [UInt8]) {
        FfiConverterInt32.write(value.columnCount, into: &buf)
        FfiConverterSequenceTypeTile.write(value.tiles, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeResponsiveLayout_lift(_ buf: RustBuffer) throws -> ResponsiveLayout {
    return try FfiConverterTypeResponsiveLayout.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeResponsiveLayout_lower(_ value: ResponsiveLayout) -> RustBuffer {
    return FfiConverterTypeResponsiveLayout.lower(value)
}


public struct SectionSettings {
    public var sectionId: String
    public var isFollowed: Bool
    public var isBlocked: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(sectionId: String, isFollowed: Bool, isBlocked: Bool) {
        self.sectionId = sectionId
        self.isFollowed = isFollowed
        self.isBlocked = isBlocked
    }
}

#if compiler(>=6)
extension SectionSettings: Sendable {}
#endif


extension SectionSettings: Equatable, Hashable {
    public static func ==(lhs: SectionSettings, rhs: SectionSettings) -> Bool {
        if lhs.sectionId != rhs.sectionId {
            return false
        }
        if lhs.isFollowed != rhs.isFollowed {
            return false
        }
        if lhs.isBlocked != rhs.isBlocked {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(sectionId)
        hasher.combine(isFollowed)
        hasher.combine(isBlocked)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSectionSettings: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SectionSettings {
        return
            try SectionSettings(
                sectionId: FfiConverterString.read(from: &buf), 
                isFollowed: FfiConverterBool.read(from: &buf), 
                isBlocked: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: SectionSettings, into buf: inout [UInt8]) {
        FfiConverterString.write(value.sectionId, into: &buf)
        FfiConverterBool.write(value.isFollowed, into: &buf)
        FfiConverterBool.write(value.isBlocked, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSectionSettings_lift(_ buf: RustBuffer) throws -> SectionSettings {
    return try FfiConverterTypeSectionSettings.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSectionSettings_lower(_ value: SectionSettings) -> RustBuffer {
    return FfiConverterTypeSectionSettings.lower(value)
}


public struct Tile {
    public var size: String
    public var position: Int32
    public var hasAd: Bool
    public var hasExcerpt: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(size: String, position: Int32, hasAd: Bool, hasExcerpt: Bool) {
        self.size = size
        self.position = position
        self.hasAd = hasAd
        self.hasExcerpt = hasExcerpt
    }
}

#if compiler(>=6)
extension Tile: Sendable {}
#endif


extension Tile: Equatable, Hashable {
    public static func ==(lhs: Tile, rhs: Tile) -> Bool {
        if lhs.size != rhs.size {
            return false
        }
        if lhs.position != rhs.position {
            return false
        }
        if lhs.hasAd != rhs.hasAd {
            return false
        }
        if lhs.hasExcerpt != rhs.hasExcerpt {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(size)
        hasher.combine(position)
        hasher.combine(hasAd)
        hasher.combine(hasExcerpt)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeTile: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Tile {
        return
            try Tile(
                size: FfiConverterString.read(from: &buf), 
                position: FfiConverterInt32.read(from: &buf), 
                hasAd: FfiConverterBool.read(from: &buf), 
                hasExcerpt: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: Tile, into buf: inout [UInt8]) {
        FfiConverterString.write(value.size, into: &buf)
        FfiConverterInt32.write(value.position, into: &buf)
        FfiConverterBool.write(value.hasAd, into: &buf)
        FfiConverterBool.write(value.hasExcerpt, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeTile_lift(_ buf: RustBuffer) throws -> Tile {
    return try FfiConverterTypeTile.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeTile_lower(_ value: Tile) -> RustBuffer {
    return FfiConverterTypeTile.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum CuratedRecommendationLocale {
    
    case fr
    case frFr
    case es
    case esEs
    case it
    case itIt
    case en
    case enCa
    case enGb
    case enUs
    case de
    case deDe
    case deAt
    case deCh
}


#if compiler(>=6)
extension CuratedRecommendationLocale: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationLocale: FfiConverterRustBuffer {
    typealias SwiftType = CuratedRecommendationLocale

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationLocale {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .fr
        
        case 2: return .frFr
        
        case 3: return .es
        
        case 4: return .esEs
        
        case 5: return .it
        
        case 6: return .itIt
        
        case 7: return .en
        
        case 8: return .enCa
        
        case 9: return .enGb
        
        case 10: return .enUs
        
        case 11: return .de
        
        case 12: return .deDe
        
        case 13: return .deAt
        
        case 14: return .deCh
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: CuratedRecommendationLocale, into buf: inout [UInt8]) {
        switch value {
        
        
        case .fr:
            writeInt(&buf, Int32(1))
        
        
        case .frFr:
            writeInt(&buf, Int32(2))
        
        
        case .es:
            writeInt(&buf, Int32(3))
        
        
        case .esEs:
            writeInt(&buf, Int32(4))
        
        
        case .it:
            writeInt(&buf, Int32(5))
        
        
        case .itIt:
            writeInt(&buf, Int32(6))
        
        
        case .en:
            writeInt(&buf, Int32(7))
        
        
        case .enCa:
            writeInt(&buf, Int32(8))
        
        
        case .enGb:
            writeInt(&buf, Int32(9))
        
        
        case .enUs:
            writeInt(&buf, Int32(10))
        
        
        case .de:
            writeInt(&buf, Int32(11))
        
        
        case .deDe:
            writeInt(&buf, Int32(12))
        
        
        case .deAt:
            writeInt(&buf, Int32(13))
        
        
        case .deCh:
            writeInt(&buf, Int32(14))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationLocale_lift(_ buf: RustBuffer) throws -> CuratedRecommendationLocale {
    return try FfiConverterTypeCuratedRecommendationLocale.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationLocale_lower(_ value: CuratedRecommendationLocale) -> RustBuffer {
    return FfiConverterTypeCuratedRecommendationLocale.lower(value)
}


extension CuratedRecommendationLocale: Equatable, Hashable {}




public enum CuratedRecommendationsApiError {

    
    
    case Network(reason: String
    )
    case Other(code: UInt16?, reason: String
    )
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeCuratedRecommendationsApiError: FfiConverterRustBuffer {
    typealias SwiftType = CuratedRecommendationsApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> CuratedRecommendationsApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {

        

        
        case 1: return .Network(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 2: return .Other(
            code: try FfiConverterOptionUInt16.read(from: &buf), 
            reason: try FfiConverterString.read(from: &buf)
            )

         default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: CuratedRecommendationsApiError, into buf: inout [UInt8]) {
        switch value {

        

        
        
        case let .Network(reason):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .Other(code,reason):
            writeInt(&buf, Int32(2))
            FfiConverterOptionUInt16.write(code, into: &buf)
            FfiConverterString.write(reason, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsApiError_lift(_ buf: RustBuffer) throws -> CuratedRecommendationsApiError {
    return try FfiConverterTypeCuratedRecommendationsApiError.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeCuratedRecommendationsApiError_lower(_ value: CuratedRecommendationsApiError) -> RustBuffer {
    return FfiConverterTypeCuratedRecommendationsApiError.lower(value)
}


extension CuratedRecommendationsApiError: Equatable, Hashable {}



extension CuratedRecommendationsApiError: Foundation.LocalizedError {
    public var errorDescription: String? {
        String(reflecting: self)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionUInt16: FfiConverterRustBuffer {
    typealias SwiftType = UInt16?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterUInt16.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterUInt16.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionInt32: FfiConverterRustBuffer {
    typealias SwiftType = Int32?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt32.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt32.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeCuratedRecommendationsBucket: FfiConverterRustBuffer {
    typealias SwiftType = CuratedRecommendationsBucket?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeCuratedRecommendationsBucket.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeCuratedRecommendationsBucket.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeFakespotFeed: FfiConverterRustBuffer {
    typealias SwiftType = FakespotFeed?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeFakespotFeed.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeFakespotFeed.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeFeedSection: FfiConverterRustBuffer {
    typealias SwiftType = FeedSection?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeFeedSection.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeFeedSection.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeFeeds: FfiConverterRustBuffer {
    typealias SwiftType = Feeds?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeFeeds.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeFeeds.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeInterestPicker: FfiConverterRustBuffer {
    typealias SwiftType = InterestPicker?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeInterestPicker.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeInterestPicker.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceTypeSectionSettings: FfiConverterRustBuffer {
    typealias SwiftType = [SectionSettings]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeSectionSettings.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeSectionSettings.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeFakespotProduct: FfiConverterRustBuffer {
    typealias SwiftType = [FakespotProduct]

    public static func write(_ value: [FakespotProduct], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeFakespotProduct.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [FakespotProduct] {
        let len: Int32 = try readInt(&buf)
        var seq = [FakespotProduct]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeFakespotProduct.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeInterestPickerSection: FfiConverterRustBuffer {
    typealias SwiftType = [InterestPickerSection]

    public static func write(_ value: [InterestPickerSection], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeInterestPickerSection.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [InterestPickerSection] {
        let len: Int32 = try readInt(&buf)
        var seq = [InterestPickerSection]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeInterestPickerSection.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeRecommendationDataItem: FfiConverterRustBuffer {
    typealias SwiftType = [RecommendationDataItem]

    public static func write(_ value: [RecommendationDataItem], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeRecommendationDataItem.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [RecommendationDataItem] {
        let len: Int32 = try readInt(&buf)
        var seq = [RecommendationDataItem]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeRecommendationDataItem.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeResponsiveLayout: FfiConverterRustBuffer {
    typealias SwiftType = [ResponsiveLayout]

    public static func write(_ value: [ResponsiveLayout], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeResponsiveLayout.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [ResponsiveLayout] {
        let len: Int32 = try readInt(&buf)
        var seq = [ResponsiveLayout]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeResponsiveLayout.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeSectionSettings: FfiConverterRustBuffer {
    typealias SwiftType = [SectionSettings]

    public static func write(_ value: [SectionSettings], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeSectionSettings.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [SectionSettings] {
        let len: Int32 = try readInt(&buf)
        var seq = [SectionSettings]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeSectionSettings.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeTile: FfiConverterRustBuffer {
    typealias SwiftType = [Tile]

    public static func write(_ value: [Tile], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeTile.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Tile] {
        let len: Int32 = try readInt(&buf)
        var seq = [Tile]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeTile.read(from: &buf))
        }
        return seq
    }
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}
// Use a global variable to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private let initializationResult: InitializationResult = {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_merino_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if (uniffi_merino_checksum_method_curatedrecommendationsclient_get_curated_recommendations() != 49968) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_merino_checksum_constructor_curatedrecommendationsclient_new() != 14537) {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}()

// Make the ensure init function public so that other modules which have external type references to
// our types can call it.
public func uniffiEnsureMerinoInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all