// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
import MozillaRustComponents
#endif

fileprivate extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len:0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_search_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_search_rustbuffer_free(self, $0) }
    }
}

fileprivate extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

fileprivate extension Data {
    init(rustBuffer: RustBuffer) {
        self.init(
            bytesNoCopy: rustBuffer.data!,
            count: Int(rustBuffer.len),
            deallocator: .none
        )
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

fileprivate func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
fileprivate func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset..<reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value, { reader.data.copyBytes(to: $0, from: range)})
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
fileprivate func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> Array<UInt8> {
    let range = reader.offset..<(reader.offset+count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer({ buffer in
        reader.data.copyBytes(to: buffer, from: range)
    })
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
fileprivate func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return Float(bitPattern: try readInt(&reader))
}

// Reads a float at the current offset.
fileprivate func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return Double(bitPattern: try readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
fileprivate func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

fileprivate func createWriter() -> [UInt8] {
    return []
}

fileprivate func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
fileprivate func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

fileprivate func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

fileprivate func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous to the Rust trait of the same name.
fileprivate protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
fileprivate protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType { }

extension FfiConverterPrimitive {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
fileprivate protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> RustBuffer {
          var writer = createWriter()
          write(value, into: &writer)
          return RustBuffer(bytes: writer)
    }
}
// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
fileprivate enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

fileprivate extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        self.lock()
        defer { self.unlock() }
        return try f()
    }
}

fileprivate let CALL_SUCCESS: Int8 = 0
fileprivate let CALL_ERROR: Int8 = 1
fileprivate let CALL_UNEXPECTED_ERROR: Int8 = 2
fileprivate let CALL_CANCELLED: Int8 = 3

fileprivate extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer.init(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    let neverThrow: ((RustBuffer) throws -> Never)? = nil
    return try makeRustCall(callback, errorHandler: neverThrow)
}

private func rustCallWithError<T, E: Swift.Error>(
    _ errorHandler: @escaping (RustBuffer) throws -> E,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T, E: Swift.Error>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> E)?
) throws -> T {
    uniffiEnsureSearchInitialized()
    var callStatus = RustCallStatus.init()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus<E: Swift.Error>(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> E)?
) throws {
    switch callStatus.code {
        case CALL_SUCCESS:
            return

        case CALL_ERROR:
            if let errorHandler = errorHandler {
                throw try errorHandler(callStatus.errorBuf)
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.unexpectedRustCallError
            }

        case CALL_UNEXPECTED_ERROR:
            // When the rust code sees a panic, it tries to construct a RustBuffer
            // with the message.  But if that code panics, then it just sends back
            // an empty buffer.
            if callStatus.errorBuf.len > 0 {
                throw UniffiInternalError.rustPanic(try FfiConverterString.lift(callStatus.errorBuf))
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.rustPanic("Rust panic")
            }

        case CALL_CANCELLED:
            fatalError("Cancellation not supported yet")

        default:
            throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> ()
) {
    do {
        try writeReturn(makeCall())
    } catch let error {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> (),
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}
fileprivate final class UniffiHandleMap<T>: @unchecked Sendable {
    // All mutation happens with this lock held, which is why we implement @unchecked Sendable.
    private let lock = NSLock()
    private var map: [UInt64: T] = [:]
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

     func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        get {
            map.count
        }
    }
}


// Public interface members begin here.


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterUInt32: FfiConverterPrimitive {
    typealias FfiType = UInt32
    typealias SwiftType = UInt32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterBool : FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return String(bytes: try readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}




/**
 * SearchEngineSelector parses the JSON configuration for
 * search engines and returns the applicable engines depending
 * on their region + locale.
 */
public protocol SearchEngineSelectorProtocol: AnyObject {
    
    /**
     * Clears the search configuration from memory if it is known that it is
     * not required for a time, e.g. if the configuration will only be re-filtered
     * after an app/environment update.
     */
    func clearSearchConfig() 
    
    /**
     * Filters the search configuration with the user's given environment,
     * and returns the set of engines and parameters that should be presented
     * to the user.
     */
    func filterEngineConfiguration(userEnvironment: SearchUserEnvironment) throws  -> RefinedSearchConfig
    
    func setConfigOverrides(overrides: String) throws 
    
    /**
     * Sets the search configuration from the given string. If the configuration
     * string is unchanged since the last update, the cached configuration is
     * reused to avoid unnecessary reprocessing. This helps optimize performance,
     * particularly during test runs where the same configuration may be used
     * repeatedly.
     */
    func setSearchConfig(configuration: String) throws 
    
    /**
     * Sets the RemoteSettingsService to use. The selector will create the
     * relevant remote settings client(s) from the service.
     *
     * # Params:
     * - `service`: The remote settings service instance for the application.
     * - `options`: The remote settings options to be passed to the client(s).
     * - `apply_engine_overrides`: Whether or not to apply overrides from
     * `search-config-v2-overrides` to the selected engines. Should be false unless the
     * application supports the click URL feature.
     */
    func useRemoteSettingsServer(service: RemoteSettingsService, applyEngineOverrides: Bool) 
    
}
/**
 * SearchEngineSelector parses the JSON configuration for
 * search engines and returns the applicable engines depending
 * on their region + locale.
 */
open class SearchEngineSelector: SearchEngineSelectorProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_search_fn_clone_searchengineselector(self.pointer, $0) }
    }
public convenience init() {
    let pointer =
        try! rustCall() {
    uniffi_search_fn_constructor_searchengineselector_new($0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_search_fn_free_searchengineselector(pointer, $0) }
    }

    

    
    /**
     * Clears the search configuration from memory if it is known that it is
     * not required for a time, e.g. if the configuration will only be re-filtered
     * after an app/environment update.
     */
open func clearSearchConfig()  {try! rustCall() {
    uniffi_search_fn_method_searchengineselector_clear_search_config(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Filters the search configuration with the user's given environment,
     * and returns the set of engines and parameters that should be presented
     * to the user.
     */
open func filterEngineConfiguration(userEnvironment: SearchUserEnvironment)throws  -> RefinedSearchConfig  {
    return try  FfiConverterTypeRefinedSearchConfig_lift(try rustCallWithError(FfiConverterTypeSearchApiError_lift) {
    uniffi_search_fn_method_searchengineselector_filter_engine_configuration(self.uniffiClonePointer(),
        FfiConverterTypeSearchUserEnvironment_lower(userEnvironment),$0
    )
})
}
    
open func setConfigOverrides(overrides: String)throws   {try rustCallWithError(FfiConverterTypeSearchApiError_lift) {
    uniffi_search_fn_method_searchengineselector_set_config_overrides(self.uniffiClonePointer(),
        FfiConverterString.lower(overrides),$0
    )
}
}
    
    /**
     * Sets the search configuration from the given string. If the configuration
     * string is unchanged since the last update, the cached configuration is
     * reused to avoid unnecessary reprocessing. This helps optimize performance,
     * particularly during test runs where the same configuration may be used
     * repeatedly.
     */
open func setSearchConfig(configuration: String)throws   {try rustCallWithError(FfiConverterTypeSearchApiError_lift) {
    uniffi_search_fn_method_searchengineselector_set_search_config(self.uniffiClonePointer(),
        FfiConverterString.lower(configuration),$0
    )
}
}
    
    /**
     * Sets the RemoteSettingsService to use. The selector will create the
     * relevant remote settings client(s) from the service.
     *
     * # Params:
     * - `service`: The remote settings service instance for the application.
     * - `options`: The remote settings options to be passed to the client(s).
     * - `apply_engine_overrides`: Whether or not to apply overrides from
     * `search-config-v2-overrides` to the selected engines. Should be false unless the
     * application supports the click URL feature.
     */
open func useRemoteSettingsServer(service: RemoteSettingsService, applyEngineOverrides: Bool)  {try! rustCall() {
    uniffi_search_fn_method_searchengineselector_use_remote_settings_server(self.uniffiClonePointer(),
        FfiConverterTypeRemoteSettingsService_lower(service),
        FfiConverterBool.lower(applyEngineOverrides),$0
    )
}
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchEngineSelector: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = SearchEngineSelector

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> SearchEngineSelector {
        return SearchEngineSelector(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: SearchEngineSelector) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchEngineSelector {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: SearchEngineSelector, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineSelector_lift(_ pointer: UnsafeMutableRawPointer) throws -> SearchEngineSelector {
    return try FfiConverterTypeSearchEngineSelector.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineSelector_lower(_ value: SearchEngineSelector) -> UnsafeMutableRawPointer {
    return FfiConverterTypeSearchEngineSelector.lower(value)
}




/**
 * Defines an individual search engine URL. This is defined separately to
 * `types::SearchEngineUrl` as various fields may be optional in the supplied
 * configuration.
 */
public struct JsonEngineUrl {
    /**
     * The PrePath and FilePath of the URL. May include variables for engines
     * which have a variable FilePath, e.g. `{searchTerms}` for when a search
     * term is within the path of the url.
     */
    public var base: String?
    /**
     * The HTTP method to use to send the request (`GET` or `POST`).
     * If the engine definition has not specified the method, it defaults to GET.
     */
    public var method: JsonEngineMethod?
    /**
     * The parameters for this URL.
     */
    public var params: [SearchUrlParam]?
    /**
     * The name of the query parameter for the search term. Automatically
     * appended to the end of the query. This may be skipped if `{searchTerms}`
     * is included in the base.
     */
    public var searchTermParamName: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The PrePath and FilePath of the URL. May include variables for engines
         * which have a variable FilePath, e.g. `{searchTerms}` for when a search
         * term is within the path of the url.
         */base: String?, 
        /**
         * The HTTP method to use to send the request (`GET` or `POST`).
         * If the engine definition has not specified the method, it defaults to GET.
         */method: JsonEngineMethod?, 
        /**
         * The parameters for this URL.
         */params: [SearchUrlParam]?, 
        /**
         * The name of the query parameter for the search term. Automatically
         * appended to the end of the query. This may be skipped if `{searchTerms}`
         * is included in the base.
         */searchTermParamName: String?) {
        self.base = base
        self.method = method
        self.params = params
        self.searchTermParamName = searchTermParamName
    }
}

#if compiler(>=6)
extension JsonEngineUrl: Sendable {}
#endif


extension JsonEngineUrl: Equatable, Hashable {
    public static func ==(lhs: JsonEngineUrl, rhs: JsonEngineUrl) -> Bool {
        if lhs.base != rhs.base {
            return false
        }
        if lhs.method != rhs.method {
            return false
        }
        if lhs.params != rhs.params {
            return false
        }
        if lhs.searchTermParamName != rhs.searchTermParamName {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(base)
        hasher.combine(method)
        hasher.combine(params)
        hasher.combine(searchTermParamName)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeJSONEngineUrl: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> JsonEngineUrl {
        return
            try JsonEngineUrl(
                base: FfiConverterOptionString.read(from: &buf), 
                method: FfiConverterOptionTypeJSONEngineMethod.read(from: &buf), 
                params: FfiConverterOptionSequenceTypeSearchUrlParam.read(from: &buf), 
                searchTermParamName: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: JsonEngineUrl, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.base, into: &buf)
        FfiConverterOptionTypeJSONEngineMethod.write(value.method, into: &buf)
        FfiConverterOptionSequenceTypeSearchUrlParam.write(value.params, into: &buf)
        FfiConverterOptionString.write(value.searchTermParamName, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJSONEngineUrl_lift(_ buf: RustBuffer) throws -> JsonEngineUrl {
    return try FfiConverterTypeJSONEngineUrl.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJSONEngineUrl_lower(_ value: JsonEngineUrl) -> RustBuffer {
    return FfiConverterTypeJSONEngineUrl.lower(value)
}


/**
 * Reflects `types::SearchEngineUrls`, but using `EngineUrl`.
 */
public struct JsonEngineUrls {
    /**
     * The URL to use for searches.
     */
    public var search: JsonEngineUrl?
    /**
     * The URL to use for suggestions.
     */
    public var suggestions: JsonEngineUrl?
    /**
     * The URL to use for trending suggestions.
     */
    public var trending: JsonEngineUrl?
    /**
     * The URL of the search engine homepage.
     */
    public var searchForm: JsonEngineUrl?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The URL to use for searches.
         */search: JsonEngineUrl?, 
        /**
         * The URL to use for suggestions.
         */suggestions: JsonEngineUrl?, 
        /**
         * The URL to use for trending suggestions.
         */trending: JsonEngineUrl?, 
        /**
         * The URL of the search engine homepage.
         */searchForm: JsonEngineUrl?) {
        self.search = search
        self.suggestions = suggestions
        self.trending = trending
        self.searchForm = searchForm
    }
}

#if compiler(>=6)
extension JsonEngineUrls: Sendable {}
#endif


extension JsonEngineUrls: Equatable, Hashable {
    public static func ==(lhs: JsonEngineUrls, rhs: JsonEngineUrls) -> Bool {
        if lhs.search != rhs.search {
            return false
        }
        if lhs.suggestions != rhs.suggestions {
            return false
        }
        if lhs.trending != rhs.trending {
            return false
        }
        if lhs.searchForm != rhs.searchForm {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(search)
        hasher.combine(suggestions)
        hasher.combine(trending)
        hasher.combine(searchForm)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeJSONEngineUrls: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> JsonEngineUrls {
        return
            try JsonEngineUrls(
                search: FfiConverterOptionTypeJSONEngineUrl.read(from: &buf), 
                suggestions: FfiConverterOptionTypeJSONEngineUrl.read(from: &buf), 
                trending: FfiConverterOptionTypeJSONEngineUrl.read(from: &buf), 
                searchForm: FfiConverterOptionTypeJSONEngineUrl.read(from: &buf)
        )
    }

    public static func write(_ value: JsonEngineUrls, into buf: inout [UInt8]) {
        FfiConverterOptionTypeJSONEngineUrl.write(value.search, into: &buf)
        FfiConverterOptionTypeJSONEngineUrl.write(value.suggestions, into: &buf)
        FfiConverterOptionTypeJSONEngineUrl.write(value.trending, into: &buf)
        FfiConverterOptionTypeJSONEngineUrl.write(value.searchForm, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJSONEngineUrls_lift(_ buf: RustBuffer) throws -> JsonEngineUrls {
    return try FfiConverterTypeJSONEngineUrls.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJSONEngineUrls_lower(_ value: JsonEngineUrls) -> RustBuffer {
    return FfiConverterTypeJSONEngineUrls.lower(value)
}


/**
 * Details of the search engines to display to the user, generated as a result
 * of processing the search configuration.
 */
public struct RefinedSearchConfig {
    /**
     * A sorted list of engines. Clients may use the engine in the order that
     * this list is specified, or they may implement their own order if they
     * have other requirements.
     *
     * The application default engines should not be assumed from this order in
     * case of future changes.
     *
     * The sort order is:
     *
     * * Application Default Engine
     * * Application Default Engine for Private Mode (if specified & different)
     * * Engines sorted by descending `SearchEngineDefinition.orderHint`
     * * Any other engines in alphabetical order (locale based comparison)
     */
    public var engines: [SearchEngineDefinition]
    /**
     * The identifier of the engine that should be used for the application
     * default engine. If this is undefined, an error has occurred, and the
     * application should either default to the first engine in the engines
     * list or otherwise handle appropriately.
     */
    public var appDefaultEngineId: String?
    /**
     * If specified, the identifier of the engine that should be used for the
     * application default engine in private browsing mode.
     * Only desktop uses this currently.
     */
    public var appPrivateDefaultEngineId: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * A sorted list of engines. Clients may use the engine in the order that
         * this list is specified, or they may implement their own order if they
         * have other requirements.
         *
         * The application default engines should not be assumed from this order in
         * case of future changes.
         *
         * The sort order is:
         *
         * * Application Default Engine
         * * Application Default Engine for Private Mode (if specified & different)
         * * Engines sorted by descending `SearchEngineDefinition.orderHint`
         * * Any other engines in alphabetical order (locale based comparison)
         */engines: [SearchEngineDefinition], 
        /**
         * The identifier of the engine that should be used for the application
         * default engine. If this is undefined, an error has occurred, and the
         * application should either default to the first engine in the engines
         * list or otherwise handle appropriately.
         */appDefaultEngineId: String?, 
        /**
         * If specified, the identifier of the engine that should be used for the
         * application default engine in private browsing mode.
         * Only desktop uses this currently.
         */appPrivateDefaultEngineId: String?) {
        self.engines = engines
        self.appDefaultEngineId = appDefaultEngineId
        self.appPrivateDefaultEngineId = appPrivateDefaultEngineId
    }
}

#if compiler(>=6)
extension RefinedSearchConfig: Sendable {}
#endif


extension RefinedSearchConfig: Equatable, Hashable {
    public static func ==(lhs: RefinedSearchConfig, rhs: RefinedSearchConfig) -> Bool {
        if lhs.engines != rhs.engines {
            return false
        }
        if lhs.appDefaultEngineId != rhs.appDefaultEngineId {
            return false
        }
        if lhs.appPrivateDefaultEngineId != rhs.appPrivateDefaultEngineId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(engines)
        hasher.combine(appDefaultEngineId)
        hasher.combine(appPrivateDefaultEngineId)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeRefinedSearchConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> RefinedSearchConfig {
        return
            try RefinedSearchConfig(
                engines: FfiConverterSequenceTypeSearchEngineDefinition.read(from: &buf), 
                appDefaultEngineId: FfiConverterOptionString.read(from: &buf), 
                appPrivateDefaultEngineId: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: RefinedSearchConfig, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeSearchEngineDefinition.write(value.engines, into: &buf)
        FfiConverterOptionString.write(value.appDefaultEngineId, into: &buf)
        FfiConverterOptionString.write(value.appPrivateDefaultEngineId, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeRefinedSearchConfig_lift(_ buf: RustBuffer) throws -> RefinedSearchConfig {
    return try FfiConverterTypeRefinedSearchConfig.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeRefinedSearchConfig_lower(_ value: RefinedSearchConfig) -> RustBuffer {
    return FfiConverterTypeRefinedSearchConfig.lower(value)
}


/**
 * A definition for an individual search engine to be presented to the user.
 */
public struct SearchEngineDefinition {
    /**
     * A list of aliases for this engine.
     */
    public var aliases: [String]
    /**
     * The character set this engine uses for queries.
     */
    public var charset: String
    /**
     * The classification of search engine according to the main search types
     * (e.g. general, shopping, travel, dictionary). Currently, only marking as
     * a general search engine is supported.
     * On Android, only general search engines may be selected as "default"
     * search engines.
     */
    public var classification: SearchEngineClassification
    /**
     * The identifier of the search engine. This is used as an internal
     * identifier, e.g. for saving the user's settings for the engine. It is
     * also used to form the base telemetry id and may be extended by telemetrySuffix.
     */
    public var identifier: String
    /**
     * The user visible name of the search engine.
     */
    public var name: String
    /**
     * This search engine is presented as an option that the user may enable.
     * The application should not include these in the default list of the
     * user's engines. If not supported, it should filter them out.
     */
    public var optional: Bool
    /**
     * The partner code for the engine. This will be inserted into parameters
     * which include `{partnerCode}`. May be the empty string.
     */
    public var partnerCode: String
    /**
     * Optional suffix that is appended to the search engine identifier
     * following a dash, i.e. `<identifier>-<suffix>`. If it is an empty string
     * no dash should be appended.
     */
    public var telemetrySuffix: String
    /**
     * The URLs associated with the search engine.
     */
    public var urls: SearchEngineUrls
    /**
     * A hint to the order that this engine should be in the engine list. This
     * is derived from the `engineOrders` section of the search configuration.
     * The higher the number, the nearer to the front it should be.
     * If the number is not specified, other methods of sorting may be relied
     * upon (e.g. alphabetical).
     */
    public var orderHint: UInt32?
    /**
     * The url used for reporting clicks.
     */
    public var clickUrl: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * A list of aliases for this engine.
         */aliases: [String], 
        /**
         * The character set this engine uses for queries.
         */charset: String, 
        /**
         * The classification of search engine according to the main search types
         * (e.g. general, shopping, travel, dictionary). Currently, only marking as
         * a general search engine is supported.
         * On Android, only general search engines may be selected as "default"
         * search engines.
         */classification: SearchEngineClassification, 
        /**
         * The identifier of the search engine. This is used as an internal
         * identifier, e.g. for saving the user's settings for the engine. It is
         * also used to form the base telemetry id and may be extended by telemetrySuffix.
         */identifier: String, 
        /**
         * The user visible name of the search engine.
         */name: String, 
        /**
         * This search engine is presented as an option that the user may enable.
         * The application should not include these in the default list of the
         * user's engines. If not supported, it should filter them out.
         */optional: Bool, 
        /**
         * The partner code for the engine. This will be inserted into parameters
         * which include `{partnerCode}`. May be the empty string.
         */partnerCode: String, 
        /**
         * Optional suffix that is appended to the search engine identifier
         * following a dash, i.e. `<identifier>-<suffix>`. If it is an empty string
         * no dash should be appended.
         */telemetrySuffix: String, 
        /**
         * The URLs associated with the search engine.
         */urls: SearchEngineUrls, 
        /**
         * A hint to the order that this engine should be in the engine list. This
         * is derived from the `engineOrders` section of the search configuration.
         * The higher the number, the nearer to the front it should be.
         * If the number is not specified, other methods of sorting may be relied
         * upon (e.g. alphabetical).
         */orderHint: UInt32?, 
        /**
         * The url used for reporting clicks.
         */clickUrl: String?) {
        self.aliases = aliases
        self.charset = charset
        self.classification = classification
        self.identifier = identifier
        self.name = name
        self.optional = optional
        self.partnerCode = partnerCode
        self.telemetrySuffix = telemetrySuffix
        self.urls = urls
        self.orderHint = orderHint
        self.clickUrl = clickUrl
    }
}

#if compiler(>=6)
extension SearchEngineDefinition: Sendable {}
#endif


extension SearchEngineDefinition: Equatable, Hashable {
    public static func ==(lhs: SearchEngineDefinition, rhs: SearchEngineDefinition) -> Bool {
        if lhs.aliases != rhs.aliases {
            return false
        }
        if lhs.charset != rhs.charset {
            return false
        }
        if lhs.classification != rhs.classification {
            return false
        }
        if lhs.identifier != rhs.identifier {
            return false
        }
        if lhs.name != rhs.name {
            return false
        }
        if lhs.optional != rhs.optional {
            return false
        }
        if lhs.partnerCode != rhs.partnerCode {
            return false
        }
        if lhs.telemetrySuffix != rhs.telemetrySuffix {
            return false
        }
        if lhs.urls != rhs.urls {
            return false
        }
        if lhs.orderHint != rhs.orderHint {
            return false
        }
        if lhs.clickUrl != rhs.clickUrl {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(aliases)
        hasher.combine(charset)
        hasher.combine(classification)
        hasher.combine(identifier)
        hasher.combine(name)
        hasher.combine(optional)
        hasher.combine(partnerCode)
        hasher.combine(telemetrySuffix)
        hasher.combine(urls)
        hasher.combine(orderHint)
        hasher.combine(clickUrl)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchEngineDefinition: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchEngineDefinition {
        return
            try SearchEngineDefinition(
                aliases: FfiConverterSequenceString.read(from: &buf), 
                charset: FfiConverterString.read(from: &buf), 
                classification: FfiConverterTypeSearchEngineClassification.read(from: &buf), 
                identifier: FfiConverterString.read(from: &buf), 
                name: FfiConverterString.read(from: &buf), 
                optional: FfiConverterBool.read(from: &buf), 
                partnerCode: FfiConverterString.read(from: &buf), 
                telemetrySuffix: FfiConverterString.read(from: &buf), 
                urls: FfiConverterTypeSearchEngineUrls.read(from: &buf), 
                orderHint: FfiConverterOptionUInt32.read(from: &buf), 
                clickUrl: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: SearchEngineDefinition, into buf: inout [UInt8]) {
        FfiConverterSequenceString.write(value.aliases, into: &buf)
        FfiConverterString.write(value.charset, into: &buf)
        FfiConverterTypeSearchEngineClassification.write(value.classification, into: &buf)
        FfiConverterString.write(value.identifier, into: &buf)
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterBool.write(value.optional, into: &buf)
        FfiConverterString.write(value.partnerCode, into: &buf)
        FfiConverterString.write(value.telemetrySuffix, into: &buf)
        FfiConverterTypeSearchEngineUrls.write(value.urls, into: &buf)
        FfiConverterOptionUInt32.write(value.orderHint, into: &buf)
        FfiConverterOptionString.write(value.clickUrl, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineDefinition_lift(_ buf: RustBuffer) throws -> SearchEngineDefinition {
    return try FfiConverterTypeSearchEngineDefinition.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineDefinition_lower(_ value: SearchEngineDefinition) -> RustBuffer {
    return FfiConverterTypeSearchEngineDefinition.lower(value)
}


/**
 * Defines an individual search engine URL.
 */
public struct SearchEngineUrl {
    /**
     * The PrePath and FilePath of the URL. May include variables for engines
     * which have a variable FilePath, e.g. `{searchTerms}` for when a search
     * term is within the path of the url.
     */
    public var base: String
    /**
     * The HTTP method to use to send the request (`GET` or `POST`).
     * If the engine definition has not specified the method, it defaults to GET.
     */
    public var method: String
    /**
     * The parameters for this URL.
     */
    public var params: [SearchUrlParam]
    /**
     * The name of the query parameter for the search term. Automatically
     * appended to the end of the query. This may be skipped if `{searchTerms}`
     * is included in the base.
     */
    public var searchTermParamName: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The PrePath and FilePath of the URL. May include variables for engines
         * which have a variable FilePath, e.g. `{searchTerms}` for when a search
         * term is within the path of the url.
         */base: String, 
        /**
         * The HTTP method to use to send the request (`GET` or `POST`).
         * If the engine definition has not specified the method, it defaults to GET.
         */method: String, 
        /**
         * The parameters for this URL.
         */params: [SearchUrlParam], 
        /**
         * The name of the query parameter for the search term. Automatically
         * appended to the end of the query. This may be skipped if `{searchTerms}`
         * is included in the base.
         */searchTermParamName: String?) {
        self.base = base
        self.method = method
        self.params = params
        self.searchTermParamName = searchTermParamName
    }
}

#if compiler(>=6)
extension SearchEngineUrl: Sendable {}
#endif


extension SearchEngineUrl: Equatable, Hashable {
    public static func ==(lhs: SearchEngineUrl, rhs: SearchEngineUrl) -> Bool {
        if lhs.base != rhs.base {
            return false
        }
        if lhs.method != rhs.method {
            return false
        }
        if lhs.params != rhs.params {
            return false
        }
        if lhs.searchTermParamName != rhs.searchTermParamName {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(base)
        hasher.combine(method)
        hasher.combine(params)
        hasher.combine(searchTermParamName)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchEngineUrl: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchEngineUrl {
        return
            try SearchEngineUrl(
                base: FfiConverterString.read(from: &buf), 
                method: FfiConverterString.read(from: &buf), 
                params: FfiConverterSequenceTypeSearchUrlParam.read(from: &buf), 
                searchTermParamName: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: SearchEngineUrl, into buf: inout [UInt8]) {
        FfiConverterString.write(value.base, into: &buf)
        FfiConverterString.write(value.method, into: &buf)
        FfiConverterSequenceTypeSearchUrlParam.write(value.params, into: &buf)
        FfiConverterOptionString.write(value.searchTermParamName, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineUrl_lift(_ buf: RustBuffer) throws -> SearchEngineUrl {
    return try FfiConverterTypeSearchEngineUrl.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineUrl_lower(_ value: SearchEngineUrl) -> RustBuffer {
    return FfiConverterTypeSearchEngineUrl.lower(value)
}


/**
 * The URLs associated with the search engine.
 */
public struct SearchEngineUrls {
    /**
     * The URL to use for searches.
     */
    public var search: SearchEngineUrl
    /**
     * The URL to use for suggestions.
     */
    public var suggestions: SearchEngineUrl?
    /**
     * The URL to use for trending suggestions.
     */
    public var trending: SearchEngineUrl?
    /**
     * The URL of the search engine homepage.
     */
    public var searchForm: SearchEngineUrl?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The URL to use for searches.
         */search: SearchEngineUrl, 
        /**
         * The URL to use for suggestions.
         */suggestions: SearchEngineUrl?, 
        /**
         * The URL to use for trending suggestions.
         */trending: SearchEngineUrl?, 
        /**
         * The URL of the search engine homepage.
         */searchForm: SearchEngineUrl?) {
        self.search = search
        self.suggestions = suggestions
        self.trending = trending
        self.searchForm = searchForm
    }
}

#if compiler(>=6)
extension SearchEngineUrls: Sendable {}
#endif


extension SearchEngineUrls: Equatable, Hashable {
    public static func ==(lhs: SearchEngineUrls, rhs: SearchEngineUrls) -> Bool {
        if lhs.search != rhs.search {
            return false
        }
        if lhs.suggestions != rhs.suggestions {
            return false
        }
        if lhs.trending != rhs.trending {
            return false
        }
        if lhs.searchForm != rhs.searchForm {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(search)
        hasher.combine(suggestions)
        hasher.combine(trending)
        hasher.combine(searchForm)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchEngineUrls: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchEngineUrls {
        return
            try SearchEngineUrls(
                search: FfiConverterTypeSearchEngineUrl.read(from: &buf), 
                suggestions: FfiConverterOptionTypeSearchEngineUrl.read(from: &buf), 
                trending: FfiConverterOptionTypeSearchEngineUrl.read(from: &buf), 
                searchForm: FfiConverterOptionTypeSearchEngineUrl.read(from: &buf)
        )
    }

    public static func write(_ value: SearchEngineUrls, into buf: inout [UInt8]) {
        FfiConverterTypeSearchEngineUrl.write(value.search, into: &buf)
        FfiConverterOptionTypeSearchEngineUrl.write(value.suggestions, into: &buf)
        FfiConverterOptionTypeSearchEngineUrl.write(value.trending, into: &buf)
        FfiConverterOptionTypeSearchEngineUrl.write(value.searchForm, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineUrls_lift(_ buf: RustBuffer) throws -> SearchEngineUrls {
    return try FfiConverterTypeSearchEngineUrls.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineUrls_lower(_ value: SearchEngineUrls) -> RustBuffer {
    return FfiConverterTypeSearchEngineUrls.lower(value)
}


/**
 * Parameter definitions for search engine URLs. The name property is always
 * specified, along with one of value, experiment_config or search_access_point.
 */
public struct SearchUrlParam {
    /**
     * The name of the parameter in the url.
     */
    public var name: String
    /**
     * The parameter value, this may be a static value, or additionally contain
     * a parameter replacement, e.g. `{inputEncoding}`. For the partner code
     * parameter, this field should be `{partnerCode}`.
     */
    public var value: String?
    /**
     * Same as value but only used if Services.polices.isEnterprise is true. Overrides other parameters of the same name.
     */
    public var enterpriseValue: String?
    /**
     * The value for the parameter will be derived from the equivalent experiment
     * configuration value.
     * Only desktop uses this currently.
     */
    public var experimentConfig: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The name of the parameter in the url.
         */name: String, 
        /**
         * The parameter value, this may be a static value, or additionally contain
         * a parameter replacement, e.g. `{inputEncoding}`. For the partner code
         * parameter, this field should be `{partnerCode}`.
         */value: String?, 
        /**
         * Same as value but only used if Services.polices.isEnterprise is true. Overrides other parameters of the same name.
         */enterpriseValue: String?, 
        /**
         * The value for the parameter will be derived from the equivalent experiment
         * configuration value.
         * Only desktop uses this currently.
         */experimentConfig: String?) {
        self.name = name
        self.value = value
        self.enterpriseValue = enterpriseValue
        self.experimentConfig = experimentConfig
    }
}

#if compiler(>=6)
extension SearchUrlParam: Sendable {}
#endif


extension SearchUrlParam: Equatable, Hashable {
    public static func ==(lhs: SearchUrlParam, rhs: SearchUrlParam) -> Bool {
        if lhs.name != rhs.name {
            return false
        }
        if lhs.value != rhs.value {
            return false
        }
        if lhs.enterpriseValue != rhs.enterpriseValue {
            return false
        }
        if lhs.experimentConfig != rhs.experimentConfig {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(name)
        hasher.combine(value)
        hasher.combine(enterpriseValue)
        hasher.combine(experimentConfig)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchUrlParam: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchUrlParam {
        return
            try SearchUrlParam(
                name: FfiConverterString.read(from: &buf), 
                value: FfiConverterOptionString.read(from: &buf), 
                enterpriseValue: FfiConverterOptionString.read(from: &buf), 
                experimentConfig: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: SearchUrlParam, into buf: inout [UInt8]) {
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterOptionString.write(value.value, into: &buf)
        FfiConverterOptionString.write(value.enterpriseValue, into: &buf)
        FfiConverterOptionString.write(value.experimentConfig, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchUrlParam_lift(_ buf: RustBuffer) throws -> SearchUrlParam {
    return try FfiConverterTypeSearchUrlParam.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchUrlParam_lower(_ value: SearchUrlParam) -> RustBuffer {
    return FfiConverterTypeSearchUrlParam.lower(value)
}


/**
 * The user's environment that is used for filtering the search configuration.
 */
public struct SearchUserEnvironment {
    /**
     * The current locale of the application that the user is using.
     */
    public var locale: String
    /**
     * The home region that the user is currently identified as being within.
     * On desktop & android there is a 14 day lag after detecting a region
     * change before the home region changes. TBD: iOS?
     */
    public var region: String
    /**
     * The update channel of the user's build.
     */
    public var updateChannel: SearchUpdateChannel
    /**
     * The distribution id for the user's build.
     */
    public var distributionId: String
    /**
     * The search related experiment id that the user is included within. On
     * desktop this is the `searchConfiguration.experiment` variable.
     */
    public var experiment: String
    /**
     * The application name that the user is using.
     */
    public var appName: SearchApplicationName
    /**
     * The application version that the user is using.
     */
    public var version: String
    /**
     * The device type that the user is using.
     */
    public var deviceType: SearchDeviceType

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The current locale of the application that the user is using.
         */locale: String, 
        /**
         * The home region that the user is currently identified as being within.
         * On desktop & android there is a 14 day lag after detecting a region
         * change before the home region changes. TBD: iOS?
         */region: String, 
        /**
         * The update channel of the user's build.
         */updateChannel: SearchUpdateChannel, 
        /**
         * The distribution id for the user's build.
         */distributionId: String, 
        /**
         * The search related experiment id that the user is included within. On
         * desktop this is the `searchConfiguration.experiment` variable.
         */experiment: String, 
        /**
         * The application name that the user is using.
         */appName: SearchApplicationName, 
        /**
         * The application version that the user is using.
         */version: String, 
        /**
         * The device type that the user is using.
         */deviceType: SearchDeviceType) {
        self.locale = locale
        self.region = region
        self.updateChannel = updateChannel
        self.distributionId = distributionId
        self.experiment = experiment
        self.appName = appName
        self.version = version
        self.deviceType = deviceType
    }
}

#if compiler(>=6)
extension SearchUserEnvironment: Sendable {}
#endif


extension SearchUserEnvironment: Equatable, Hashable {
    public static func ==(lhs: SearchUserEnvironment, rhs: SearchUserEnvironment) -> Bool {
        if lhs.locale != rhs.locale {
            return false
        }
        if lhs.region != rhs.region {
            return false
        }
        if lhs.updateChannel != rhs.updateChannel {
            return false
        }
        if lhs.distributionId != rhs.distributionId {
            return false
        }
        if lhs.experiment != rhs.experiment {
            return false
        }
        if lhs.appName != rhs.appName {
            return false
        }
        if lhs.version != rhs.version {
            return false
        }
        if lhs.deviceType != rhs.deviceType {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(locale)
        hasher.combine(region)
        hasher.combine(updateChannel)
        hasher.combine(distributionId)
        hasher.combine(experiment)
        hasher.combine(appName)
        hasher.combine(version)
        hasher.combine(deviceType)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchUserEnvironment: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchUserEnvironment {
        return
            try SearchUserEnvironment(
                locale: FfiConverterString.read(from: &buf), 
                region: FfiConverterString.read(from: &buf), 
                updateChannel: FfiConverterTypeSearchUpdateChannel.read(from: &buf), 
                distributionId: FfiConverterString.read(from: &buf), 
                experiment: FfiConverterString.read(from: &buf), 
                appName: FfiConverterTypeSearchApplicationName.read(from: &buf), 
                version: FfiConverterString.read(from: &buf), 
                deviceType: FfiConverterTypeSearchDeviceType.read(from: &buf)
        )
    }

    public static func write(_ value: SearchUserEnvironment, into buf: inout [UInt8]) {
        FfiConverterString.write(value.locale, into: &buf)
        FfiConverterString.write(value.region, into: &buf)
        FfiConverterTypeSearchUpdateChannel.write(value.updateChannel, into: &buf)
        FfiConverterString.write(value.distributionId, into: &buf)
        FfiConverterString.write(value.experiment, into: &buf)
        FfiConverterTypeSearchApplicationName.write(value.appName, into: &buf)
        FfiConverterString.write(value.version, into: &buf)
        FfiConverterTypeSearchDeviceType.write(value.deviceType, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchUserEnvironment_lift(_ buf: RustBuffer) throws -> SearchUserEnvironment {
    return try FfiConverterTypeSearchUserEnvironment.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchUserEnvironment_lower(_ value: SearchUserEnvironment) -> RustBuffer {
    return FfiConverterTypeSearchUserEnvironment.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * The list of possible submission methods for search engine urls.
 */

public enum JsonEngineMethod {
    
    case post
    case get
}


#if compiler(>=6)
extension JsonEngineMethod: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeJSONEngineMethod: FfiConverterRustBuffer {
    typealias SwiftType = JsonEngineMethod

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> JsonEngineMethod {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .post
        
        case 2: return .get
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: JsonEngineMethod, into buf: inout [UInt8]) {
        switch value {
        
        
        case .post:
            writeInt(&buf, Int32(1))
        
        
        case .get:
            writeInt(&buf, Int32(2))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJSONEngineMethod_lift(_ buf: RustBuffer) throws -> JsonEngineMethod {
    return try FfiConverterTypeJSONEngineMethod.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJSONEngineMethod_lower(_ value: JsonEngineMethod) -> RustBuffer {
    return FfiConverterTypeJSONEngineMethod.lower(value)
}


extension JsonEngineMethod: Equatable, Hashable {}




public enum SearchApiError {

    
    
    case Other(reason: String
    )
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchApiError: FfiConverterRustBuffer {
    typealias SwiftType = SearchApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {

        

        
        case 1: return .Other(
            reason: try FfiConverterString.read(from: &buf)
            )

         default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SearchApiError, into buf: inout [UInt8]) {
        switch value {

        

        
        
        case let .Other(reason):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(reason, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchApiError_lift(_ buf: RustBuffer) throws -> SearchApiError {
    return try FfiConverterTypeSearchApiError.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchApiError_lower(_ value: SearchApiError) -> RustBuffer {
    return FfiConverterTypeSearchApiError.lower(value)
}


extension SearchApiError: Equatable, Hashable {}



extension SearchApiError: Foundation.LocalizedError {
    public var errorDescription: String? {
        String(reflecting: self)
    }
}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * The list of possible application names that are currently supported.
 */

public enum SearchApplicationName {
    
    case firefoxAndroid
    case firefoxIos
    case focusAndroid
    case focusIos
    case firefox
}


#if compiler(>=6)
extension SearchApplicationName: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchApplicationName: FfiConverterRustBuffer {
    typealias SwiftType = SearchApplicationName

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchApplicationName {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .firefoxAndroid
        
        case 2: return .firefoxIos
        
        case 3: return .focusAndroid
        
        case 4: return .focusIos
        
        case 5: return .firefox
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SearchApplicationName, into buf: inout [UInt8]) {
        switch value {
        
        
        case .firefoxAndroid:
            writeInt(&buf, Int32(1))
        
        
        case .firefoxIos:
            writeInt(&buf, Int32(2))
        
        
        case .focusAndroid:
            writeInt(&buf, Int32(3))
        
        
        case .focusIos:
            writeInt(&buf, Int32(4))
        
        
        case .firefox:
            writeInt(&buf, Int32(5))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchApplicationName_lift(_ buf: RustBuffer) throws -> SearchApplicationName {
    return try FfiConverterTypeSearchApplicationName.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchApplicationName_lower(_ value: SearchApplicationName) -> RustBuffer {
    return FfiConverterTypeSearchApplicationName.lower(value)
}


extension SearchApplicationName: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum SearchDeviceType {
    
    case smartphone
    case tablet
    case none
}


#if compiler(>=6)
extension SearchDeviceType: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchDeviceType: FfiConverterRustBuffer {
    typealias SwiftType = SearchDeviceType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchDeviceType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .smartphone
        
        case 2: return .tablet
        
        case 3: return .none
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SearchDeviceType, into buf: inout [UInt8]) {
        switch value {
        
        
        case .smartphone:
            writeInt(&buf, Int32(1))
        
        
        case .tablet:
            writeInt(&buf, Int32(2))
        
        
        case .none:
            writeInt(&buf, Int32(3))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchDeviceType_lift(_ buf: RustBuffer) throws -> SearchDeviceType {
    return try FfiConverterTypeSearchDeviceType.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchDeviceType_lower(_ value: SearchDeviceType) -> RustBuffer {
    return FfiConverterTypeSearchDeviceType.lower(value)
}


extension SearchDeviceType: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * The list of acceptable classifications for a search engine.
 */

public enum SearchEngineClassification {
    
    case general
    case unknown
}


#if compiler(>=6)
extension SearchEngineClassification: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchEngineClassification: FfiConverterRustBuffer {
    typealias SwiftType = SearchEngineClassification

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchEngineClassification {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .general
        
        case 2: return .unknown
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SearchEngineClassification, into buf: inout [UInt8]) {
        switch value {
        
        
        case .general:
            writeInt(&buf, Int32(1))
        
        
        case .unknown:
            writeInt(&buf, Int32(2))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineClassification_lift(_ buf: RustBuffer) throws -> SearchEngineClassification {
    return try FfiConverterTypeSearchEngineClassification.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchEngineClassification_lower(_ value: SearchEngineClassification) -> RustBuffer {
    return FfiConverterTypeSearchEngineClassification.lower(value)
}


extension SearchEngineClassification: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * The list of possible update channels for a user's build.
 * Use `default` for a self-build or an unknown channel.
 */

public enum SearchUpdateChannel {
    
    case nightly
    case aurora
    case beta
    case release
    case esr
    case `default`
}


#if compiler(>=6)
extension SearchUpdateChannel: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSearchUpdateChannel: FfiConverterRustBuffer {
    typealias SwiftType = SearchUpdateChannel

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SearchUpdateChannel {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .nightly
        
        case 2: return .aurora
        
        case 3: return .beta
        
        case 4: return .release
        
        case 5: return .esr
        
        case 6: return .`default`
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SearchUpdateChannel, into buf: inout [UInt8]) {
        switch value {
        
        
        case .nightly:
            writeInt(&buf, Int32(1))
        
        
        case .aurora:
            writeInt(&buf, Int32(2))
        
        
        case .beta:
            writeInt(&buf, Int32(3))
        
        
        case .release:
            writeInt(&buf, Int32(4))
        
        
        case .esr:
            writeInt(&buf, Int32(5))
        
        
        case .`default`:
            writeInt(&buf, Int32(6))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchUpdateChannel_lift(_ buf: RustBuffer) throws -> SearchUpdateChannel {
    return try FfiConverterTypeSearchUpdateChannel.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSearchUpdateChannel_lower(_ value: SearchUpdateChannel) -> RustBuffer {
    return FfiConverterTypeSearchUpdateChannel.lower(value)
}


extension SearchUpdateChannel: Equatable, Hashable {}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionUInt32: FfiConverterRustBuffer {
    typealias SwiftType = UInt32?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterUInt32.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterUInt32.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeJSONEngineUrl: FfiConverterRustBuffer {
    typealias SwiftType = JsonEngineUrl?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeJSONEngineUrl.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeJSONEngineUrl.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeSearchEngineUrl: FfiConverterRustBuffer {
    typealias SwiftType = SearchEngineUrl?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeSearchEngineUrl.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeSearchEngineUrl.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeJSONEngineMethod: FfiConverterRustBuffer {
    typealias SwiftType = JsonEngineMethod?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeJSONEngineMethod.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeJSONEngineMethod.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceTypeSearchUrlParam: FfiConverterRustBuffer {
    typealias SwiftType = [SearchUrlParam]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeSearchUrlParam.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeSearchUrlParam.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeSearchEngineDefinition: FfiConverterRustBuffer {
    typealias SwiftType = [SearchEngineDefinition]

    public static func write(_ value: [SearchEngineDefinition], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeSearchEngineDefinition.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [SearchEngineDefinition] {
        let len: Int32 = try readInt(&buf)
        var seq = [SearchEngineDefinition]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeSearchEngineDefinition.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeSearchUrlParam: FfiConverterRustBuffer {
    typealias SwiftType = [SearchUrlParam]

    public static func write(_ value: [SearchUrlParam], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeSearchUrlParam.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [SearchUrlParam] {
        let len: Int32 = try readInt(&buf)
        var seq = [SearchUrlParam]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeSearchUrlParam.read(from: &buf))
        }
        return seq
    }
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}
// Use a global variable to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private let initializationResult: InitializationResult = {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_search_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if (uniffi_search_checksum_method_searchengineselector_clear_search_config() != 2155) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_search_checksum_method_searchengineselector_filter_engine_configuration() != 58182) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_search_checksum_method_searchengineselector_set_config_overrides() != 22323) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_search_checksum_method_searchengineselector_set_search_config() != 35713) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_search_checksum_method_searchengineselector_use_remote_settings_server() != 47504) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_search_checksum_constructor_searchengineselector_new() != 2296) {
        return InitializationResult.apiChecksumMismatch
    }

    uniffiEnsureRemoteSettingsInitialized()
    return InitializationResult.ok
}()

// Make the ensure init function public so that other modules which have external type references to
// our types can call it.
public func uniffiEnsureSearchInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all