// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

// swiftlint:disable all
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
import MozillaRustComponents
#endif

fileprivate extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func empty() -> RustBuffer {
        RustBuffer(capacity: 0, len:0, data: nil)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_suggest_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_suggest_rustbuffer_free(self, $0) }
    }
}

fileprivate extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

fileprivate extension Data {
    init(rustBuffer: RustBuffer) {
        self.init(
            bytesNoCopy: rustBuffer.data!,
            count: Int(rustBuffer.len),
            deallocator: .none
        )
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

fileprivate func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
fileprivate func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset..<reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value, { reader.data.copyBytes(to: $0, from: range)})
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
fileprivate func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> Array<UInt8> {
    let range = reader.offset..<(reader.offset+count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer({ buffer in
        reader.data.copyBytes(to: buffer, from: range)
    })
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
fileprivate func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return Float(bitPattern: try readInt(&reader))
}

// Reads a float at the current offset.
fileprivate func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return Double(bitPattern: try readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
fileprivate func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

fileprivate func createWriter() -> [UInt8] {
    return []
}

fileprivate func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
fileprivate func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

fileprivate func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

fileprivate func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous to the Rust trait of the same name.
fileprivate protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
fileprivate protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType { }

extension FfiConverterPrimitive {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
fileprivate protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public static func lower(_ value: SwiftType) -> RustBuffer {
          var writer = createWriter()
          write(value, into: &writer)
          return RustBuffer(bytes: writer)
    }
}
// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
fileprivate enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

fileprivate extension NSLock {
    func withLock<T>(f: () throws -> T) rethrows -> T {
        self.lock()
        defer { self.unlock() }
        return try f()
    }
}

fileprivate let CALL_SUCCESS: Int8 = 0
fileprivate let CALL_ERROR: Int8 = 1
fileprivate let CALL_UNEXPECTED_ERROR: Int8 = 2
fileprivate let CALL_CANCELLED: Int8 = 3

fileprivate extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer.init(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    let neverThrow: ((RustBuffer) throws -> Never)? = nil
    return try makeRustCall(callback, errorHandler: neverThrow)
}

private func rustCallWithError<T, E: Swift.Error>(
    _ errorHandler: @escaping (RustBuffer) throws -> E,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T, E: Swift.Error>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> E)?
) throws -> T {
    uniffiEnsureSuggestInitialized()
    var callStatus = RustCallStatus.init()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus<E: Swift.Error>(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> E)?
) throws {
    switch callStatus.code {
        case CALL_SUCCESS:
            return

        case CALL_ERROR:
            if let errorHandler = errorHandler {
                throw try errorHandler(callStatus.errorBuf)
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.unexpectedRustCallError
            }

        case CALL_UNEXPECTED_ERROR:
            // When the rust code sees a panic, it tries to construct a RustBuffer
            // with the message.  But if that code panics, then it just sends back
            // an empty buffer.
            if callStatus.errorBuf.len > 0 {
                throw UniffiInternalError.rustPanic(try FfiConverterString.lift(callStatus.errorBuf))
            } else {
                callStatus.errorBuf.deallocate()
                throw UniffiInternalError.rustPanic("Rust panic")
            }

        case CALL_CANCELLED:
            fatalError("Cancellation not supported yet")

        default:
            throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

private func uniffiTraitInterfaceCall<T>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> ()
) {
    do {
        try writeReturn(makeCall())
    } catch let error {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}

private func uniffiTraitInterfaceCallWithError<T, E>(
    callStatus: UnsafeMutablePointer<RustCallStatus>,
    makeCall: () throws -> T,
    writeReturn: (T) -> (),
    lowerError: (E) -> RustBuffer
) {
    do {
        try writeReturn(makeCall())
    } catch let error as E {
        callStatus.pointee.code = CALL_ERROR
        callStatus.pointee.errorBuf = lowerError(error)
    } catch {
        callStatus.pointee.code = CALL_UNEXPECTED_ERROR
        callStatus.pointee.errorBuf = FfiConverterString.lower(String(describing: error))
    }
}
fileprivate final class UniffiHandleMap<T>: @unchecked Sendable {
    // All mutation happens with this lock held, which is why we implement @unchecked Sendable.
    private let lock = NSLock()
    private var map: [UInt64: T] = [:]
    private var currentHandle: UInt64 = 1

    func insert(obj: T) -> UInt64 {
        lock.withLock {
            let handle = currentHandle
            currentHandle += 1
            map[handle] = obj
            return handle
        }
    }

     func get(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map[handle] else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    @discardableResult
    func remove(handle: UInt64) throws -> T {
        try lock.withLock {
            guard let obj = map.removeValue(forKey: handle) else {
                throw UniffiInternalError.unexpectedStaleHandle
            }
            return obj
        }
    }

    var count: Int {
        get {
            map.count
        }
    }
}


// Public interface members begin here.


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterUInt8: FfiConverterPrimitive {
    typealias FfiType = UInt8
    typealias SwiftType = UInt8

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt8 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: UInt8, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterInt32: FfiConverterPrimitive {
    typealias FfiType = Int32
    typealias SwiftType = Int32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int32, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterUInt64: FfiConverterPrimitive {
    typealias FfiType = UInt64
    typealias SwiftType = UInt64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> UInt64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterDouble: FfiConverterPrimitive {
    typealias FfiType = Double
    typealias SwiftType = Double

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Double {
        return try lift(readDouble(&buf))
    }

    public static func write(_ value: Double, into buf: inout [UInt8]) {
        writeDouble(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterBool : FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return String(bytes: try readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterData: FfiConverterRustBuffer {
    typealias SwiftType = Data

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Data {
        let len: Int32 = try readInt(&buf)
        return Data(try readBytes(&buf, count: Int(len)))
    }

    public static func write(_ value: Data, into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        writeBytes(&buf, value)
    }
}




/**
 * The store is the entry point to the Suggest component. It incrementally
 * downloads suggestions from the Remote Settings service, stores them in a
 * local database, and returns them in response to user queries.
 *
 * Your application should create a single store, and manage it as a singleton.
 * The store is thread-safe, and supports concurrent queries and ingests. We
 * expect that your application will call [`SuggestStore::query()`] to show
 * suggestions as the user types into the address bar, and periodically call
 * [`SuggestStore::ingest()`] in the background to update the database with
 * new suggestions from Remote Settings.
 *
 * For responsiveness, we recommend always calling `query()` on a worker
 * thread. When the user types new input into the address bar, call
 * [`SuggestStore::interrupt()`] on the main thread to cancel the query
 * for the old input, and unblock the worker thread for the new query.
 *
 * The store keeps track of the state needed to support incremental ingestion,
 * but doesn't schedule the ingestion work itself, or decide how many
 * suggestions to ingest at once. This is for two reasons:
 *
 * 1. The primitives for scheduling background work vary between platforms, and
 * aren't available to the lower-level Rust layer. You might use an idle
 * timer on Desktop, `WorkManager` on Android, or `BGTaskScheduler` on iOS.
 * 2. Ingestion constraints can change, depending on the platform and the needs
 * of your application. A mobile device on a metered connection might want
 * to request a small subset of the Suggest data and download the rest
 * later, while a desktop on a fast link might download the entire dataset
 * on the first launch.
 */
public protocol SuggestStoreProtocol: AnyObject {
    
    /**
     * Return whether any suggestions have been dismissed.
     */
    func anyDismissedSuggestions() throws  -> Bool
    
    /**
     * Removes all content from the database.
     */
    func clear() throws 
    
    /**
     * Clear dismissed suggestions
     */
    func clearDismissedSuggestions() throws 
    
    /**
     * Dismiss a suggestion by its dismissal key.
     *
     * Dismissed suggestions cannot be fetched again.
     *
     * Prefer [SuggestStore::dismiss_by_suggestion] if you have a
     * `crate::Suggestion`. This method is intended for cases where a
     * suggestion originates outside this component.
     */
    func dismissByKey(key: String) throws 
    
    /**
     * Dismiss a suggestion.
     *
     * Dismissed suggestions cannot be fetched again.
     */
    func dismissBySuggestion(suggestion: Suggestion) throws 
    
    /**
     * Deprecated, use [SuggestStore::dismiss_by_suggestion] or
     * [SuggestStore::dismiss_by_key] instead.
     *
     * Dismiss a suggestion
     *
     * Dismissed suggestions will not be returned again
     */
    func dismissSuggestion(suggestionUrl: String) throws 
    
    /**
     * Fetches a geoname's names stored in the database.
     *
     * See `fetch_geoname_alternates` in `geoname.rs` for documentation.
     */
    func fetchGeonameAlternates(geoname: Geoname) throws  -> GeonameAlternates
    
    /**
     * Fetches geonames stored in the database. A geoname represents a
     * geographic place.
     *
     * See `fetch_geonames` in `geoname.rs` for documentation.
     */
    func fetchGeonames(query: String, matchNamePrefix: Bool, filter: [Geoname]?) throws  -> [GeonameMatch]
    
    /**
     * Returns global Suggest configuration data.
     */
    func fetchGlobalConfig() throws  -> SuggestGlobalConfig
    
    /**
     * Returns per-provider Suggest configuration data.
     */
    func fetchProviderConfig(provider: SuggestionProvider) throws  -> SuggestProviderConfig?
    
    /**
     * Ingests new suggestions from Remote Settings.
     */
    func ingest(constraints: SuggestIngestionConstraints) throws  -> SuggestIngestionMetrics
    
    /**
     * Interrupts any ongoing queries.
     *
     * This should be called when the user types new input into the address
     * bar, to ensure that they see fresh suggestions as they type. This
     * method does not interrupt any ongoing ingests.
     */
    func interrupt(kind: InterruptKind?) 
    
    /**
     * Return whether a suggestion has been dismissed given its dismissal key.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a suggestion has been dismissed.
     * This method is intended for cases where a dismissal key originates
     * outside this component.
     */
    func isDismissedByKey(key: String) throws  -> Bool
    
    /**
     * Return whether a suggestion has been dismissed.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a `Suggestion` has been
     * dismissed, but this method can be used to do so.
     */
    func isDismissedBySuggestion(suggestion: Suggestion) throws  -> Bool
    
    /**
     * Queries the database for suggestions.
     */
    func query(query: SuggestionQuery) throws  -> [Suggestion]
    
    /**
     * Queries the database for suggestions.
     */
    func queryWithMetrics(query: SuggestionQuery) throws  -> QueryWithMetricsResult
    
}
/**
 * The store is the entry point to the Suggest component. It incrementally
 * downloads suggestions from the Remote Settings service, stores them in a
 * local database, and returns them in response to user queries.
 *
 * Your application should create a single store, and manage it as a singleton.
 * The store is thread-safe, and supports concurrent queries and ingests. We
 * expect that your application will call [`SuggestStore::query()`] to show
 * suggestions as the user types into the address bar, and periodically call
 * [`SuggestStore::ingest()`] in the background to update the database with
 * new suggestions from Remote Settings.
 *
 * For responsiveness, we recommend always calling `query()` on a worker
 * thread. When the user types new input into the address bar, call
 * [`SuggestStore::interrupt()`] on the main thread to cancel the query
 * for the old input, and unblock the worker thread for the new query.
 *
 * The store keeps track of the state needed to support incremental ingestion,
 * but doesn't schedule the ingestion work itself, or decide how many
 * suggestions to ingest at once. This is for two reasons:
 *
 * 1. The primitives for scheduling background work vary between platforms, and
 * aren't available to the lower-level Rust layer. You might use an idle
 * timer on Desktop, `WorkManager` on Android, or `BGTaskScheduler` on iOS.
 * 2. Ingestion constraints can change, depending on the platform and the needs
 * of your application. A mobile device on a metered connection might want
 * to request a small subset of the Suggest data and download the rest
 * later, while a desktop on a fast link might download the entire dataset
 * on the first launch.
 */
open class SuggestStore: SuggestStoreProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_suggest_fn_clone_suggeststore(self.pointer, $0) }
    }
    /**
     * Creates a Suggest store.
     */
public convenience init(path: String, remoteSettingsService: RemoteSettingsService) {
    let pointer =
        try! rustCall() {
    uniffi_suggest_fn_constructor_suggeststore_new(
        FfiConverterString.lower(path),
        FfiConverterTypeRemoteSettingsService_lower(remoteSettingsService),$0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_suggest_fn_free_suggeststore(pointer, $0) }
    }

    

    
    /**
     * Return whether any suggestions have been dismissed.
     */
open func anyDismissedSuggestions()throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_any_dismissed_suggestions(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Removes all content from the database.
     */
open func clear()throws   {try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_clear(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Clear dismissed suggestions
     */
open func clearDismissedSuggestions()throws   {try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_clear_dismissed_suggestions(self.uniffiClonePointer(),$0
    )
}
}
    
    /**
     * Dismiss a suggestion by its dismissal key.
     *
     * Dismissed suggestions cannot be fetched again.
     *
     * Prefer [SuggestStore::dismiss_by_suggestion] if you have a
     * `crate::Suggestion`. This method is intended for cases where a
     * suggestion originates outside this component.
     */
open func dismissByKey(key: String)throws   {try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_dismiss_by_key(self.uniffiClonePointer(),
        FfiConverterString.lower(key),$0
    )
}
}
    
    /**
     * Dismiss a suggestion.
     *
     * Dismissed suggestions cannot be fetched again.
     */
open func dismissBySuggestion(suggestion: Suggestion)throws   {try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_dismiss_by_suggestion(self.uniffiClonePointer(),
        FfiConverterTypeSuggestion_lower(suggestion),$0
    )
}
}
    
    /**
     * Deprecated, use [SuggestStore::dismiss_by_suggestion] or
     * [SuggestStore::dismiss_by_key] instead.
     *
     * Dismiss a suggestion
     *
     * Dismissed suggestions will not be returned again
     */
open func dismissSuggestion(suggestionUrl: String)throws   {try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_dismiss_suggestion(self.uniffiClonePointer(),
        FfiConverterString.lower(suggestionUrl),$0
    )
}
}
    
    /**
     * Fetches a geoname's names stored in the database.
     *
     * See `fetch_geoname_alternates` in `geoname.rs` for documentation.
     */
open func fetchGeonameAlternates(geoname: Geoname)throws  -> GeonameAlternates  {
    return try  FfiConverterTypeGeonameAlternates_lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_fetch_geoname_alternates(self.uniffiClonePointer(),
        FfiConverterTypeGeoname_lower(geoname),$0
    )
})
}
    
    /**
     * Fetches geonames stored in the database. A geoname represents a
     * geographic place.
     *
     * See `fetch_geonames` in `geoname.rs` for documentation.
     */
open func fetchGeonames(query: String, matchNamePrefix: Bool, filter: [Geoname]?)throws  -> [GeonameMatch]  {
    return try  FfiConverterSequenceTypeGeonameMatch.lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_fetch_geonames(self.uniffiClonePointer(),
        FfiConverterString.lower(query),
        FfiConverterBool.lower(matchNamePrefix),
        FfiConverterOptionSequenceTypeGeoname.lower(filter),$0
    )
})
}
    
    /**
     * Returns global Suggest configuration data.
     */
open func fetchGlobalConfig()throws  -> SuggestGlobalConfig  {
    return try  FfiConverterTypeSuggestGlobalConfig_lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_fetch_global_config(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Returns per-provider Suggest configuration data.
     */
open func fetchProviderConfig(provider: SuggestionProvider)throws  -> SuggestProviderConfig?  {
    return try  FfiConverterOptionTypeSuggestProviderConfig.lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_fetch_provider_config(self.uniffiClonePointer(),
        FfiConverterTypeSuggestionProvider_lower(provider),$0
    )
})
}
    
    /**
     * Ingests new suggestions from Remote Settings.
     */
open func ingest(constraints: SuggestIngestionConstraints)throws  -> SuggestIngestionMetrics  {
    return try  FfiConverterTypeSuggestIngestionMetrics_lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_ingest(self.uniffiClonePointer(),
        FfiConverterTypeSuggestIngestionConstraints_lower(constraints),$0
    )
})
}
    
    /**
     * Interrupts any ongoing queries.
     *
     * This should be called when the user types new input into the address
     * bar, to ensure that they see fresh suggestions as they type. This
     * method does not interrupt any ongoing ingests.
     */
open func interrupt(kind: InterruptKind? = nil)  {try! rustCall() {
    uniffi_suggest_fn_method_suggeststore_interrupt(self.uniffiClonePointer(),
        FfiConverterOptionTypeInterruptKind.lower(kind),$0
    )
}
}
    
    /**
     * Return whether a suggestion has been dismissed given its dismissal key.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a suggestion has been dismissed.
     * This method is intended for cases where a dismissal key originates
     * outside this component.
     */
open func isDismissedByKey(key: String)throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_is_dismissed_by_key(self.uniffiClonePointer(),
        FfiConverterString.lower(key),$0
    )
})
}
    
    /**
     * Return whether a suggestion has been dismissed.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a `Suggestion` has been
     * dismissed, but this method can be used to do so.
     */
open func isDismissedBySuggestion(suggestion: Suggestion)throws  -> Bool  {
    return try  FfiConverterBool.lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_is_dismissed_by_suggestion(self.uniffiClonePointer(),
        FfiConverterTypeSuggestion_lower(suggestion),$0
    )
})
}
    
    /**
     * Queries the database for suggestions.
     */
open func query(query: SuggestionQuery)throws  -> [Suggestion]  {
    return try  FfiConverterSequenceTypeSuggestion.lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_query(self.uniffiClonePointer(),
        FfiConverterTypeSuggestionQuery_lower(query),$0
    )
})
}
    
    /**
     * Queries the database for suggestions.
     */
open func queryWithMetrics(query: SuggestionQuery)throws  -> QueryWithMetricsResult  {
    return try  FfiConverterTypeQueryWithMetricsResult_lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststore_query_with_metrics(self.uniffiClonePointer(),
        FfiConverterTypeSuggestionQuery_lower(query),$0
    )
})
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestStore: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = SuggestStore

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> SuggestStore {
        return SuggestStore(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: SuggestStore) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestStore {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: SuggestStore, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestStore_lift(_ pointer: UnsafeMutableRawPointer) throws -> SuggestStore {
    return try FfiConverterTypeSuggestStore.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestStore_lower(_ value: SuggestStore) -> UnsafeMutableRawPointer {
    return FfiConverterTypeSuggestStore.lower(value)
}






/**
 * Builder for [SuggestStore]
 *
 * Using a builder is preferred to calling the constructor directly since it's harder to confuse
 * the data_path and cache_path strings.
 */
public protocol SuggestStoreBuilderProtocol: AnyObject {
    
    func build() throws  -> SuggestStore
    
    /**
     * Deprecated: this is no longer used by the suggest component.
     */
    func cachePath(path: String)  -> SuggestStoreBuilder
    
    func dataPath(path: String)  -> SuggestStoreBuilder
    
    /**
     * Add an sqlite3 extension to load
     *
     * library_name should be the name of the library without any extension, for example `libmozsqlite3`.
     * entrypoint should be the entry point, for example `sqlite3_fts5_init`.  If `null` (the default)
     * entry point will be used (see https://sqlite.org/loadext.html for details).
     */
    func loadExtension(library: String, entryPoint: String?)  -> SuggestStoreBuilder
    
    func remoteSettingsBucketName(bucketName: String)  -> SuggestStoreBuilder
    
    func remoteSettingsServer(server: RemoteSettingsServer)  -> SuggestStoreBuilder
    
    func remoteSettingsService(rsService: RemoteSettingsService)  -> SuggestStoreBuilder
    
}
/**
 * Builder for [SuggestStore]
 *
 * Using a builder is preferred to calling the constructor directly since it's harder to confuse
 * the data_path and cache_path strings.
 */
open class SuggestStoreBuilder: SuggestStoreBuilderProtocol, @unchecked Sendable {
    fileprivate let pointer: UnsafeMutableRawPointer!

    /// Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public struct NoPointer {
        public init() {}
    }

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required public init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    // This constructor can be used to instantiate a fake object.
    // - Parameter noPointer: Placeholder value so we can have a constructor separate from the default empty one that may be implemented for classes extending [FFIObject].
    //
    // - Warning:
    //     Any object instantiated with this constructor cannot be passed to an actual Rust-backed object. Since there isn't a backing [Pointer] the FFI lower functions will crash.
#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public init(noPointer: NoPointer) {
        self.pointer = nil
    }

#if swift(>=5.8)
    @_documentation(visibility: private)
#endif
    public func uniffiClonePointer() -> UnsafeMutableRawPointer {
        return try! rustCall { uniffi_suggest_fn_clone_suggeststorebuilder(self.pointer, $0) }
    }
public convenience init() {
    let pointer =
        try! rustCall() {
    uniffi_suggest_fn_constructor_suggeststorebuilder_new($0
    )
}
    self.init(unsafeFromRawPointer: pointer)
}

    deinit {
        guard let pointer = pointer else {
            return
        }

        try! rustCall { uniffi_suggest_fn_free_suggeststorebuilder(pointer, $0) }
    }

    

    
open func build()throws  -> SuggestStore  {
    return try  FfiConverterTypeSuggestStore_lift(try rustCallWithError(FfiConverterTypeSuggestApiError_lift) {
    uniffi_suggest_fn_method_suggeststorebuilder_build(self.uniffiClonePointer(),$0
    )
})
}
    
    /**
     * Deprecated: this is no longer used by the suggest component.
     */
open func cachePath(path: String) -> SuggestStoreBuilder  {
    return try!  FfiConverterTypeSuggestStoreBuilder_lift(try! rustCall() {
    uniffi_suggest_fn_method_suggeststorebuilder_cache_path(self.uniffiClonePointer(),
        FfiConverterString.lower(path),$0
    )
})
}
    
open func dataPath(path: String) -> SuggestStoreBuilder  {
    return try!  FfiConverterTypeSuggestStoreBuilder_lift(try! rustCall() {
    uniffi_suggest_fn_method_suggeststorebuilder_data_path(self.uniffiClonePointer(),
        FfiConverterString.lower(path),$0
    )
})
}
    
    /**
     * Add an sqlite3 extension to load
     *
     * library_name should be the name of the library without any extension, for example `libmozsqlite3`.
     * entrypoint should be the entry point, for example `sqlite3_fts5_init`.  If `null` (the default)
     * entry point will be used (see https://sqlite.org/loadext.html for details).
     */
open func loadExtension(library: String, entryPoint: String?) -> SuggestStoreBuilder  {
    return try!  FfiConverterTypeSuggestStoreBuilder_lift(try! rustCall() {
    uniffi_suggest_fn_method_suggeststorebuilder_load_extension(self.uniffiClonePointer(),
        FfiConverterString.lower(library),
        FfiConverterOptionString.lower(entryPoint),$0
    )
})
}
    
open func remoteSettingsBucketName(bucketName: String) -> SuggestStoreBuilder  {
    return try!  FfiConverterTypeSuggestStoreBuilder_lift(try! rustCall() {
    uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_bucket_name(self.uniffiClonePointer(),
        FfiConverterString.lower(bucketName),$0
    )
})
}
    
open func remoteSettingsServer(server: RemoteSettingsServer) -> SuggestStoreBuilder  {
    return try!  FfiConverterTypeSuggestStoreBuilder_lift(try! rustCall() {
    uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_server(self.uniffiClonePointer(),
        FfiConverterTypeRemoteSettingsServer_lower(server),$0
    )
})
}
    
open func remoteSettingsService(rsService: RemoteSettingsService) -> SuggestStoreBuilder  {
    return try!  FfiConverterTypeSuggestStoreBuilder_lift(try! rustCall() {
    uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_service(self.uniffiClonePointer(),
        FfiConverterTypeRemoteSettingsService_lower(rsService),$0
    )
})
}
    

}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestStoreBuilder: FfiConverter {

    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = SuggestStoreBuilder

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> SuggestStoreBuilder {
        return SuggestStoreBuilder(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: SuggestStoreBuilder) -> UnsafeMutableRawPointer {
        return value.uniffiClonePointer()
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestStoreBuilder {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if (ptr == nil) {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: SuggestStoreBuilder, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestStoreBuilder_lift(_ pointer: UnsafeMutableRawPointer) throws -> SuggestStoreBuilder {
    return try FfiConverterTypeSuggestStoreBuilder.lift(pointer)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestStoreBuilder_lower(_ value: SuggestStoreBuilder) -> UnsafeMutableRawPointer {
    return FfiConverterTypeSuggestStoreBuilder.lower(value)
}




/**
 * A set of names for a single entity.
 */
public struct AlternateNames {
    /**
     * The entity's primary name. For a `Geoname`, this is `Geoname::name`.
     */
    public var primary: String
    /**
     * The entity's name in the language that was ingested according to the
     * locale in the remote settings context. If none exists and this
     * `AlternateNames` is for a `Geoname`, then this will be its primary name.
     */
    public var localized: String?
    /**
     * The entity's abbreviation, if any.
     */
    public var abbreviation: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The entity's primary name. For a `Geoname`, this is `Geoname::name`.
         */primary: String, 
        /**
         * The entity's name in the language that was ingested according to the
         * locale in the remote settings context. If none exists and this
         * `AlternateNames` is for a `Geoname`, then this will be its primary name.
         */localized: String?, 
        /**
         * The entity's abbreviation, if any.
         */abbreviation: String?) {
        self.primary = primary
        self.localized = localized
        self.abbreviation = abbreviation
    }
}

#if compiler(>=6)
extension AlternateNames: Sendable {}
#endif


extension AlternateNames: Equatable, Hashable {
    public static func ==(lhs: AlternateNames, rhs: AlternateNames) -> Bool {
        if lhs.primary != rhs.primary {
            return false
        }
        if lhs.localized != rhs.localized {
            return false
        }
        if lhs.abbreviation != rhs.abbreviation {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(primary)
        hasher.combine(localized)
        hasher.combine(abbreviation)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAlternateNames: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AlternateNames {
        return
            try AlternateNames(
                primary: FfiConverterString.read(from: &buf), 
                localized: FfiConverterOptionString.read(from: &buf), 
                abbreviation: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: AlternateNames, into buf: inout [UInt8]) {
        FfiConverterString.write(value.primary, into: &buf)
        FfiConverterOptionString.write(value.localized, into: &buf)
        FfiConverterOptionString.write(value.abbreviation, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAlternateNames_lift(_ buf: RustBuffer) throws -> AlternateNames {
    return try FfiConverterTypeAlternateNames.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAlternateNames_lower(_ value: AlternateNames) -> RustBuffer {
    return FfiConverterTypeAlternateNames.lower(value)
}


/**
 * Additional data about how an FTS match was made
 */
public struct FtsMatchInfo {
    /**
     * Was this a prefix match (`water b` matched against `water bottle`)
     */
    public var prefix: Bool
    /**
     * Did the match require stemming? (`run shoes` matched against `running shoes`)
     */
    public var stemming: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * Was this a prefix match (`water b` matched against `water bottle`)
         */prefix: Bool, 
        /**
         * Did the match require stemming? (`run shoes` matched against `running shoes`)
         */stemming: Bool) {
        self.prefix = prefix
        self.stemming = stemming
    }
}

#if compiler(>=6)
extension FtsMatchInfo: Sendable {}
#endif


extension FtsMatchInfo: Equatable, Hashable {
    public static func ==(lhs: FtsMatchInfo, rhs: FtsMatchInfo) -> Bool {
        if lhs.prefix != rhs.prefix {
            return false
        }
        if lhs.stemming != rhs.stemming {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(prefix)
        hasher.combine(stemming)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeFtsMatchInfo: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> FtsMatchInfo {
        return
            try FtsMatchInfo(
                prefix: FfiConverterBool.read(from: &buf), 
                stemming: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: FtsMatchInfo, into buf: inout [UInt8]) {
        FfiConverterBool.write(value.prefix, into: &buf)
        FfiConverterBool.write(value.stemming, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFtsMatchInfo_lift(_ buf: RustBuffer) throws -> FtsMatchInfo {
    return try FfiConverterTypeFtsMatchInfo.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeFtsMatchInfo_lower(_ value: FtsMatchInfo) -> RustBuffer {
    return FfiConverterTypeFtsMatchInfo.lower(value)
}


/**
 * A single geographic place.
 *
 * This corresponds to a single row in the main "geoname" table described in
 * the GeoNames documentation [1]. We exclude fields we don't need.
 *
 * [1]: https://download.geonames.org/export/dump/readme.txt
 */
public struct Geoname {
    /**
     * The `geonameid` straight from the geoname table.
     */
    public var geonameId: Int64
    /**
     * The geoname type. This is derived from `feature_class` and
     * `feature_code` as a more convenient representation of the type.
     */
    public var geonameType: GeonameType
    /**
     * The place's primary name.
     */
    public var name: String
    /**
     * ISO-3166 two-letter uppercase country code, e.g., "US".
     */
    public var countryCode: String
    /**
     * Primary geoname category. Examples:
     *
     * "PCLI" - Independent political entity: country
     * "A" - Administrative division: state, province, borough, district, etc.
     * "P" - Populated place: city, village, etc.
     */
    public var featureClass: String
    /**
     * Secondary geoname category, depends on `feature_class`. Examples:
     *
     * "ADM1" - Administrative division 1
     * "PPL" - Populated place like a city
     */
    public var featureCode: String
    /**
     * Administrative divisions. This maps admin division levels (1-based) to
     * their corresponding codes. For example, Liverpool has two admin
     * divisions: "ENG" at level 1 and "H8" at level 2. They would be
     * represented in this map with entries `(1, "ENG")` and `(2, "H8")`.
     */
    public var adminDivisionCodes: [UInt8: String]
    /**
     * Population size.
     */
    public var population: UInt64
    /**
     * Latitude in decimal degrees (as a string).
     */
    public var latitude: String
    /**
     * Longitude in decimal degrees (as a string).
     */
    public var longitude: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The `geonameid` straight from the geoname table.
         */geonameId: Int64, 
        /**
         * The geoname type. This is derived from `feature_class` and
         * `feature_code` as a more convenient representation of the type.
         */geonameType: GeonameType, 
        /**
         * The place's primary name.
         */name: String, 
        /**
         * ISO-3166 two-letter uppercase country code, e.g., "US".
         */countryCode: String, 
        /**
         * Primary geoname category. Examples:
         *
         * "PCLI" - Independent political entity: country
         * "A" - Administrative division: state, province, borough, district, etc.
         * "P" - Populated place: city, village, etc.
         */featureClass: String, 
        /**
         * Secondary geoname category, depends on `feature_class`. Examples:
         *
         * "ADM1" - Administrative division 1
         * "PPL" - Populated place like a city
         */featureCode: String, 
        /**
         * Administrative divisions. This maps admin division levels (1-based) to
         * their corresponding codes. For example, Liverpool has two admin
         * divisions: "ENG" at level 1 and "H8" at level 2. They would be
         * represented in this map with entries `(1, "ENG")` and `(2, "H8")`.
         */adminDivisionCodes: [UInt8: String], 
        /**
         * Population size.
         */population: UInt64, 
        /**
         * Latitude in decimal degrees (as a string).
         */latitude: String, 
        /**
         * Longitude in decimal degrees (as a string).
         */longitude: String) {
        self.geonameId = geonameId
        self.geonameType = geonameType
        self.name = name
        self.countryCode = countryCode
        self.featureClass = featureClass
        self.featureCode = featureCode
        self.adminDivisionCodes = adminDivisionCodes
        self.population = population
        self.latitude = latitude
        self.longitude = longitude
    }
}

#if compiler(>=6)
extension Geoname: Sendable {}
#endif


extension Geoname: Equatable, Hashable {
    public static func ==(lhs: Geoname, rhs: Geoname) -> Bool {
        if lhs.geonameId != rhs.geonameId {
            return false
        }
        if lhs.geonameType != rhs.geonameType {
            return false
        }
        if lhs.name != rhs.name {
            return false
        }
        if lhs.countryCode != rhs.countryCode {
            return false
        }
        if lhs.featureClass != rhs.featureClass {
            return false
        }
        if lhs.featureCode != rhs.featureCode {
            return false
        }
        if lhs.adminDivisionCodes != rhs.adminDivisionCodes {
            return false
        }
        if lhs.population != rhs.population {
            return false
        }
        if lhs.latitude != rhs.latitude {
            return false
        }
        if lhs.longitude != rhs.longitude {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(geonameId)
        hasher.combine(geonameType)
        hasher.combine(name)
        hasher.combine(countryCode)
        hasher.combine(featureClass)
        hasher.combine(featureCode)
        hasher.combine(adminDivisionCodes)
        hasher.combine(population)
        hasher.combine(latitude)
        hasher.combine(longitude)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeGeoname: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Geoname {
        return
            try Geoname(
                geonameId: FfiConverterInt64.read(from: &buf), 
                geonameType: FfiConverterTypeGeonameType.read(from: &buf), 
                name: FfiConverterString.read(from: &buf), 
                countryCode: FfiConverterString.read(from: &buf), 
                featureClass: FfiConverterString.read(from: &buf), 
                featureCode: FfiConverterString.read(from: &buf), 
                adminDivisionCodes: FfiConverterDictionaryUInt8String.read(from: &buf), 
                population: FfiConverterUInt64.read(from: &buf), 
                latitude: FfiConverterString.read(from: &buf), 
                longitude: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: Geoname, into buf: inout [UInt8]) {
        FfiConverterInt64.write(value.geonameId, into: &buf)
        FfiConverterTypeGeonameType.write(value.geonameType, into: &buf)
        FfiConverterString.write(value.name, into: &buf)
        FfiConverterString.write(value.countryCode, into: &buf)
        FfiConverterString.write(value.featureClass, into: &buf)
        FfiConverterString.write(value.featureCode, into: &buf)
        FfiConverterDictionaryUInt8String.write(value.adminDivisionCodes, into: &buf)
        FfiConverterUInt64.write(value.population, into: &buf)
        FfiConverterString.write(value.latitude, into: &buf)
        FfiConverterString.write(value.longitude, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeoname_lift(_ buf: RustBuffer) throws -> Geoname {
    return try FfiConverterTypeGeoname.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeoname_lower(_ value: Geoname) -> RustBuffer {
    return FfiConverterTypeGeoname.lower(value)
}


/**
 * Alternate names for a geoname and its country and admin divisions.
 */
public struct GeonameAlternates {
    /**
     * Names for the geoname itself.
     */
    public var geoname: AlternateNames
    /**
     * Names for the geoname's country. This will be `Some` as long as the
     * country is also in the ingested data, which should typically be true.
     */
    public var country: AlternateNames?
    /**
     * Names for the geoname's admin divisions. This is parallel to
     * `Geoname::admin_division_codes`. If there are no names in the ingested
     * data for an admin division, then it will be absent from this map.
     */
    public var adminDivisions: [UInt8: AlternateNames]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * Names for the geoname itself.
         */geoname: AlternateNames, 
        /**
         * Names for the geoname's country. This will be `Some` as long as the
         * country is also in the ingested data, which should typically be true.
         */country: AlternateNames?, 
        /**
         * Names for the geoname's admin divisions. This is parallel to
         * `Geoname::admin_division_codes`. If there are no names in the ingested
         * data for an admin division, then it will be absent from this map.
         */adminDivisions: [UInt8: AlternateNames]) {
        self.geoname = geoname
        self.country = country
        self.adminDivisions = adminDivisions
    }
}

#if compiler(>=6)
extension GeonameAlternates: Sendable {}
#endif


extension GeonameAlternates: Equatable, Hashable {
    public static func ==(lhs: GeonameAlternates, rhs: GeonameAlternates) -> Bool {
        if lhs.geoname != rhs.geoname {
            return false
        }
        if lhs.country != rhs.country {
            return false
        }
        if lhs.adminDivisions != rhs.adminDivisions {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(geoname)
        hasher.combine(country)
        hasher.combine(adminDivisions)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeGeonameAlternates: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> GeonameAlternates {
        return
            try GeonameAlternates(
                geoname: FfiConverterTypeAlternateNames.read(from: &buf), 
                country: FfiConverterOptionTypeAlternateNames.read(from: &buf), 
                adminDivisions: FfiConverterDictionaryUInt8TypeAlternateNames.read(from: &buf)
        )
    }

    public static func write(_ value: GeonameAlternates, into buf: inout [UInt8]) {
        FfiConverterTypeAlternateNames.write(value.geoname, into: &buf)
        FfiConverterOptionTypeAlternateNames.write(value.country, into: &buf)
        FfiConverterDictionaryUInt8TypeAlternateNames.write(value.adminDivisions, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameAlternates_lift(_ buf: RustBuffer) throws -> GeonameAlternates {
    return try FfiConverterTypeGeonameAlternates.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameAlternates_lower(_ value: GeonameAlternates) -> RustBuffer {
    return FfiConverterTypeGeonameAlternates.lower(value)
}


/**
 * A fetched geoname with info on how it was matched.
 */
public struct GeonameMatch {
    /**
     * The geoname that was matched.
     */
    public var geoname: Geoname
    /**
     * The type of name that was matched.
     */
    public var matchType: GeonameMatchType
    /**
     * Whether the name was matched by prefix.
     */
    public var prefix: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * The geoname that was matched.
         */geoname: Geoname, 
        /**
         * The type of name that was matched.
         */matchType: GeonameMatchType, 
        /**
         * Whether the name was matched by prefix.
         */prefix: Bool) {
        self.geoname = geoname
        self.matchType = matchType
        self.prefix = prefix
    }
}

#if compiler(>=6)
extension GeonameMatch: Sendable {}
#endif


extension GeonameMatch: Equatable, Hashable {
    public static func ==(lhs: GeonameMatch, rhs: GeonameMatch) -> Bool {
        if lhs.geoname != rhs.geoname {
            return false
        }
        if lhs.matchType != rhs.matchType {
            return false
        }
        if lhs.prefix != rhs.prefix {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(geoname)
        hasher.combine(matchType)
        hasher.combine(prefix)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeGeonameMatch: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> GeonameMatch {
        return
            try GeonameMatch(
                geoname: FfiConverterTypeGeoname.read(from: &buf), 
                matchType: FfiConverterTypeGeonameMatchType.read(from: &buf), 
                prefix: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: GeonameMatch, into buf: inout [UInt8]) {
        FfiConverterTypeGeoname.write(value.geoname, into: &buf)
        FfiConverterTypeGeonameMatchType.write(value.matchType, into: &buf)
        FfiConverterBool.write(value.prefix, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameMatch_lift(_ buf: RustBuffer) throws -> GeonameMatch {
    return try FfiConverterTypeGeonameMatch.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameMatch_lower(_ value: GeonameMatch) -> RustBuffer {
    return FfiConverterTypeGeonameMatch.lower(value)
}


/**
 * Single sample for a Glean labeled_timing_distribution
 */
public struct LabeledTimingSample {
    public var label: String
    /**
     * Time in microseconds
     */
    public var value: UInt64

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(label: String, 
        /**
         * Time in microseconds
         */value: UInt64) {
        self.label = label
        self.value = value
    }
}

#if compiler(>=6)
extension LabeledTimingSample: Sendable {}
#endif


extension LabeledTimingSample: Equatable, Hashable {
    public static func ==(lhs: LabeledTimingSample, rhs: LabeledTimingSample) -> Bool {
        if lhs.label != rhs.label {
            return false
        }
        if lhs.value != rhs.value {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(label)
        hasher.combine(value)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeLabeledTimingSample: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> LabeledTimingSample {
        return
            try LabeledTimingSample(
                label: FfiConverterString.read(from: &buf), 
                value: FfiConverterUInt64.read(from: &buf)
        )
    }

    public static func write(_ value: LabeledTimingSample, into buf: inout [UInt8]) {
        FfiConverterString.write(value.label, into: &buf)
        FfiConverterUInt64.write(value.value, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLabeledTimingSample_lift(_ buf: RustBuffer) throws -> LabeledTimingSample {
    return try FfiConverterTypeLabeledTimingSample.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeLabeledTimingSample_lower(_ value: LabeledTimingSample) -> RustBuffer {
    return FfiConverterTypeLabeledTimingSample.lower(value)
}


public struct QueryWithMetricsResult {
    public var suggestions: [Suggestion]
    /**
     * Samples for the `suggest.query_time` metric
     */
    public var queryTimes: [LabeledTimingSample]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(suggestions: [Suggestion], 
        /**
         * Samples for the `suggest.query_time` metric
         */queryTimes: [LabeledTimingSample]) {
        self.suggestions = suggestions
        self.queryTimes = queryTimes
    }
}

#if compiler(>=6)
extension QueryWithMetricsResult: Sendable {}
#endif


extension QueryWithMetricsResult: Equatable, Hashable {
    public static func ==(lhs: QueryWithMetricsResult, rhs: QueryWithMetricsResult) -> Bool {
        if lhs.suggestions != rhs.suggestions {
            return false
        }
        if lhs.queryTimes != rhs.queryTimes {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(suggestions)
        hasher.combine(queryTimes)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeQueryWithMetricsResult: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> QueryWithMetricsResult {
        return
            try QueryWithMetricsResult(
                suggestions: FfiConverterSequenceTypeSuggestion.read(from: &buf), 
                queryTimes: FfiConverterSequenceTypeLabeledTimingSample.read(from: &buf)
        )
    }

    public static func write(_ value: QueryWithMetricsResult, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeSuggestion.write(value.suggestions, into: &buf)
        FfiConverterSequenceTypeLabeledTimingSample.write(value.queryTimes, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeQueryWithMetricsResult_lift(_ buf: RustBuffer) throws -> QueryWithMetricsResult {
    return try FfiConverterTypeQueryWithMetricsResult.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeQueryWithMetricsResult_lower(_ value: QueryWithMetricsResult) -> RustBuffer {
    return FfiConverterTypeQueryWithMetricsResult.lower(value)
}


/**
 * Global Suggest configuration data.
 */
public struct SuggestGlobalConfig {
    public var showLessFrequentlyCap: Int32

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(showLessFrequentlyCap: Int32) {
        self.showLessFrequentlyCap = showLessFrequentlyCap
    }
}

#if compiler(>=6)
extension SuggestGlobalConfig: Sendable {}
#endif


extension SuggestGlobalConfig: Equatable, Hashable {
    public static func ==(lhs: SuggestGlobalConfig, rhs: SuggestGlobalConfig) -> Bool {
        if lhs.showLessFrequentlyCap != rhs.showLessFrequentlyCap {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(showLessFrequentlyCap)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestGlobalConfig: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestGlobalConfig {
        return
            try SuggestGlobalConfig(
                showLessFrequentlyCap: FfiConverterInt32.read(from: &buf)
        )
    }

    public static func write(_ value: SuggestGlobalConfig, into buf: inout [UInt8]) {
        FfiConverterInt32.write(value.showLessFrequentlyCap, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestGlobalConfig_lift(_ buf: RustBuffer) throws -> SuggestGlobalConfig {
    return try FfiConverterTypeSuggestGlobalConfig.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestGlobalConfig_lower(_ value: SuggestGlobalConfig) -> RustBuffer {
    return FfiConverterTypeSuggestGlobalConfig.lower(value)
}


/**
 * Constraints limit which suggestions to ingest from Remote Settings.
 */
public struct SuggestIngestionConstraints {
    public var providers: [SuggestionProvider]?
    public var providerConstraints: SuggestionProviderConstraints?
    /**
     * Only run ingestion if the table `suggestions` is empty

     */
    public var emptyOnly: Bool

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(providers: [SuggestionProvider]? = nil, providerConstraints: SuggestionProviderConstraints? = nil, 
        /**
         * Only run ingestion if the table `suggestions` is empty

         */emptyOnly: Bool = false) {
        self.providers = providers
        self.providerConstraints = providerConstraints
        self.emptyOnly = emptyOnly
    }
}

#if compiler(>=6)
extension SuggestIngestionConstraints: Sendable {}
#endif


extension SuggestIngestionConstraints: Equatable, Hashable {
    public static func ==(lhs: SuggestIngestionConstraints, rhs: SuggestIngestionConstraints) -> Bool {
        if lhs.providers != rhs.providers {
            return false
        }
        if lhs.providerConstraints != rhs.providerConstraints {
            return false
        }
        if lhs.emptyOnly != rhs.emptyOnly {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(providers)
        hasher.combine(providerConstraints)
        hasher.combine(emptyOnly)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestIngestionConstraints: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestIngestionConstraints {
        return
            try SuggestIngestionConstraints(
                providers: FfiConverterOptionSequenceTypeSuggestionProvider.read(from: &buf), 
                providerConstraints: FfiConverterOptionTypeSuggestionProviderConstraints.read(from: &buf), 
                emptyOnly: FfiConverterBool.read(from: &buf)
        )
    }

    public static func write(_ value: SuggestIngestionConstraints, into buf: inout [UInt8]) {
        FfiConverterOptionSequenceTypeSuggestionProvider.write(value.providers, into: &buf)
        FfiConverterOptionTypeSuggestionProviderConstraints.write(value.providerConstraints, into: &buf)
        FfiConverterBool.write(value.emptyOnly, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestIngestionConstraints_lift(_ buf: RustBuffer) throws -> SuggestIngestionConstraints {
    return try FfiConverterTypeSuggestIngestionConstraints.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestIngestionConstraints_lower(_ value: SuggestIngestionConstraints) -> RustBuffer {
    return FfiConverterTypeSuggestIngestionConstraints.lower(value)
}


/**
 * Ingestion metrics
 *
 * These are recorded during [crate::Store::ingest] and returned to the consumer to record.
 */
public struct SuggestIngestionMetrics {
    /**
     * Samples for the `suggest.ingestion_time` metric
     */
    public var ingestionTimes: [LabeledTimingSample]
    /**
     * Samples for the `suggest.ingestion_download_time` metric
     */
    public var downloadTimes: [LabeledTimingSample]

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * Samples for the `suggest.ingestion_time` metric
         */ingestionTimes: [LabeledTimingSample], 
        /**
         * Samples for the `suggest.ingestion_download_time` metric
         */downloadTimes: [LabeledTimingSample]) {
        self.ingestionTimes = ingestionTimes
        self.downloadTimes = downloadTimes
    }
}

#if compiler(>=6)
extension SuggestIngestionMetrics: Sendable {}
#endif


extension SuggestIngestionMetrics: Equatable, Hashable {
    public static func ==(lhs: SuggestIngestionMetrics, rhs: SuggestIngestionMetrics) -> Bool {
        if lhs.ingestionTimes != rhs.ingestionTimes {
            return false
        }
        if lhs.downloadTimes != rhs.downloadTimes {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(ingestionTimes)
        hasher.combine(downloadTimes)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestIngestionMetrics: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestIngestionMetrics {
        return
            try SuggestIngestionMetrics(
                ingestionTimes: FfiConverterSequenceTypeLabeledTimingSample.read(from: &buf), 
                downloadTimes: FfiConverterSequenceTypeLabeledTimingSample.read(from: &buf)
        )
    }

    public static func write(_ value: SuggestIngestionMetrics, into buf: inout [UInt8]) {
        FfiConverterSequenceTypeLabeledTimingSample.write(value.ingestionTimes, into: &buf)
        FfiConverterSequenceTypeLabeledTimingSample.write(value.downloadTimes, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestIngestionMetrics_lift(_ buf: RustBuffer) throws -> SuggestIngestionMetrics {
    return try FfiConverterTypeSuggestIngestionMetrics.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestIngestionMetrics_lower(_ value: SuggestIngestionMetrics) -> RustBuffer {
    return FfiConverterTypeSuggestIngestionMetrics.lower(value)
}


/**
 * Some providers manage multiple suggestion subtypes. Queries, ingests, and
 * other operations on those providers must be constrained to a desired subtype.
 */
public struct SuggestionProviderConstraints {
    /**
     * Which dynamic suggestions should we fetch or ingest? Corresponds to the
     * `suggestion_type` value in dynamic suggestions remote settings records.
     */
    public var dynamicSuggestionTypes: [String]?
    /**
     * Which strategy should we use for the AMP queries?
     * Use None for the default strategy.
     */
    public var ampAlternativeMatching: AmpMatchingStrategy?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(
        /**
         * Which dynamic suggestions should we fetch or ingest? Corresponds to the
         * `suggestion_type` value in dynamic suggestions remote settings records.
         */dynamicSuggestionTypes: [String]? = nil, 
        /**
         * Which strategy should we use for the AMP queries?
         * Use None for the default strategy.
         */ampAlternativeMatching: AmpMatchingStrategy? = nil) {
        self.dynamicSuggestionTypes = dynamicSuggestionTypes
        self.ampAlternativeMatching = ampAlternativeMatching
    }
}

#if compiler(>=6)
extension SuggestionProviderConstraints: Sendable {}
#endif


extension SuggestionProviderConstraints: Equatable, Hashable {
    public static func ==(lhs: SuggestionProviderConstraints, rhs: SuggestionProviderConstraints) -> Bool {
        if lhs.dynamicSuggestionTypes != rhs.dynamicSuggestionTypes {
            return false
        }
        if lhs.ampAlternativeMatching != rhs.ampAlternativeMatching {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(dynamicSuggestionTypes)
        hasher.combine(ampAlternativeMatching)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestionProviderConstraints: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestionProviderConstraints {
        return
            try SuggestionProviderConstraints(
                dynamicSuggestionTypes: FfiConverterOptionSequenceString.read(from: &buf), 
                ampAlternativeMatching: FfiConverterOptionTypeAmpMatchingStrategy.read(from: &buf)
        )
    }

    public static func write(_ value: SuggestionProviderConstraints, into buf: inout [UInt8]) {
        FfiConverterOptionSequenceString.write(value.dynamicSuggestionTypes, into: &buf)
        FfiConverterOptionTypeAmpMatchingStrategy.write(value.ampAlternativeMatching, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestionProviderConstraints_lift(_ buf: RustBuffer) throws -> SuggestionProviderConstraints {
    return try FfiConverterTypeSuggestionProviderConstraints.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestionProviderConstraints_lower(_ value: SuggestionProviderConstraints) -> RustBuffer {
    return FfiConverterTypeSuggestionProviderConstraints.lower(value)
}


/**
 * A query for suggestions to show in the address bar.
 */
public struct SuggestionQuery {
    public var keyword: String
    public var providers: [SuggestionProvider]
    public var providerConstraints: SuggestionProviderConstraints?
    public var limit: Int32?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(keyword: String, providers: [SuggestionProvider], providerConstraints: SuggestionProviderConstraints? = nil, limit: Int32? = nil) {
        self.keyword = keyword
        self.providers = providers
        self.providerConstraints = providerConstraints
        self.limit = limit
    }
}

#if compiler(>=6)
extension SuggestionQuery: Sendable {}
#endif


extension SuggestionQuery: Equatable, Hashable {
    public static func ==(lhs: SuggestionQuery, rhs: SuggestionQuery) -> Bool {
        if lhs.keyword != rhs.keyword {
            return false
        }
        if lhs.providers != rhs.providers {
            return false
        }
        if lhs.providerConstraints != rhs.providerConstraints {
            return false
        }
        if lhs.limit != rhs.limit {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(keyword)
        hasher.combine(providers)
        hasher.combine(providerConstraints)
        hasher.combine(limit)
    }
}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestionQuery: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestionQuery {
        return
            try SuggestionQuery(
                keyword: FfiConverterString.read(from: &buf), 
                providers: FfiConverterSequenceTypeSuggestionProvider.read(from: &buf), 
                providerConstraints: FfiConverterOptionTypeSuggestionProviderConstraints.read(from: &buf), 
                limit: FfiConverterOptionInt32.read(from: &buf)
        )
    }

    public static func write(_ value: SuggestionQuery, into buf: inout [UInt8]) {
        FfiConverterString.write(value.keyword, into: &buf)
        FfiConverterSequenceTypeSuggestionProvider.write(value.providers, into: &buf)
        FfiConverterOptionTypeSuggestionProviderConstraints.write(value.providerConstraints, into: &buf)
        FfiConverterOptionInt32.write(value.limit, into: &buf)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestionQuery_lift(_ buf: RustBuffer) throws -> SuggestionQuery {
    return try FfiConverterTypeSuggestionQuery.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestionQuery_lower(_ value: SuggestionQuery) -> RustBuffer {
    return FfiConverterTypeSuggestionQuery.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum AmpMatchingStrategy {
    
    /**
     * Disable keywords added via keyword expansion.
     * This eliminates keywords that for terms related to the "real" keywords, for example
     * misspellings like "underarmor" instead of "under armor"'.
     */
    case noKeywordExpansion
    /**
     * Use FTS matching against the full keywords, joined together.
     */
    case ftsAgainstFullKeywords
    /**
     * Use FTS matching against the title field
     */
    case ftsAgainstTitle
}


#if compiler(>=6)
extension AmpMatchingStrategy: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeAmpMatchingStrategy: FfiConverterRustBuffer {
    typealias SwiftType = AmpMatchingStrategy

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AmpMatchingStrategy {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .noKeywordExpansion
        
        case 2: return .ftsAgainstFullKeywords
        
        case 3: return .ftsAgainstTitle
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: AmpMatchingStrategy, into buf: inout [UInt8]) {
        switch value {
        
        
        case .noKeywordExpansion:
            writeInt(&buf, Int32(1))
        
        
        case .ftsAgainstFullKeywords:
            writeInt(&buf, Int32(2))
        
        
        case .ftsAgainstTitle:
            writeInt(&buf, Int32(3))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAmpMatchingStrategy_lift(_ buf: RustBuffer) throws -> AmpMatchingStrategy {
    return try FfiConverterTypeAmpMatchingStrategy.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeAmpMatchingStrategy_lower(_ value: AmpMatchingStrategy) -> RustBuffer {
    return FfiConverterTypeAmpMatchingStrategy.lower(value)
}


extension AmpMatchingStrategy: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.

public enum GeonameMatchType {
    
    case abbreviation
    case airportCode
    /**
     * This includes any names that aren't abbreviations or airport codes.
     */
    case name
}


#if compiler(>=6)
extension GeonameMatchType: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeGeonameMatchType: FfiConverterRustBuffer {
    typealias SwiftType = GeonameMatchType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> GeonameMatchType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .abbreviation
        
        case 2: return .airportCode
        
        case 3: return .name
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: GeonameMatchType, into buf: inout [UInt8]) {
        switch value {
        
        
        case .abbreviation:
            writeInt(&buf, Int32(1))
        
        
        case .airportCode:
            writeInt(&buf, Int32(2))
        
        
        case .name:
            writeInt(&buf, Int32(3))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameMatchType_lift(_ buf: RustBuffer) throws -> GeonameMatchType {
    return try FfiConverterTypeGeonameMatchType.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameMatchType_lower(_ value: GeonameMatchType) -> RustBuffer {
    return FfiConverterTypeGeonameMatchType.lower(value)
}


extension GeonameMatchType: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * The type of a geoname.
 */

public enum GeonameType {
    
    case country
    /**
     * A state, province, prefecture, district, borough, etc.
     */
    case adminDivision(level: UInt8
    )
    case adminDivisionOther
    /**
     * A city, town, village, populated place, etc.
     */
    case city
    case other
}


#if compiler(>=6)
extension GeonameType: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeGeonameType: FfiConverterRustBuffer {
    typealias SwiftType = GeonameType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> GeonameType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .country
        
        case 2: return .adminDivision(level: try FfiConverterUInt8.read(from: &buf)
        )
        
        case 3: return .adminDivisionOther
        
        case 4: return .city
        
        case 5: return .other
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: GeonameType, into buf: inout [UInt8]) {
        switch value {
        
        
        case .country:
            writeInt(&buf, Int32(1))
        
        
        case let .adminDivision(level):
            writeInt(&buf, Int32(2))
            FfiConverterUInt8.write(level, into: &buf)
            
        
        case .adminDivisionOther:
            writeInt(&buf, Int32(3))
        
        
        case .city:
            writeInt(&buf, Int32(4))
        
        
        case .other:
            writeInt(&buf, Int32(5))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameType_lift(_ buf: RustBuffer) throws -> GeonameType {
    return try FfiConverterTypeGeonameType.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeGeonameType_lower(_ value: GeonameType) -> RustBuffer {
    return FfiConverterTypeGeonameType.lower(value)
}


extension GeonameType: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * What should be interrupted when [SuggestStore::interrupt] is called?
 */

public enum InterruptKind {
    
    /**
     * Interrupt read operations like [SuggestStore::query]
     */
    case read
    /**
     * Interrupt write operations.  This mostly means [SuggestStore::ingest], but
     * other operations may also be interrupted.
     */
    case write
    /**
     * Interrupt both read and write operations,
     */
    case readWrite
}


#if compiler(>=6)
extension InterruptKind: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeInterruptKind: FfiConverterRustBuffer {
    typealias SwiftType = InterruptKind

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> InterruptKind {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .read
        
        case 2: return .write
        
        case 3: return .readWrite
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: InterruptKind, into buf: inout [UInt8]) {
        switch value {
        
        
        case .read:
            writeInt(&buf, Int32(1))
        
        
        case .write:
            writeInt(&buf, Int32(2))
        
        
        case .readWrite:
            writeInt(&buf, Int32(3))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeInterruptKind_lift(_ buf: RustBuffer) throws -> InterruptKind {
    return try FfiConverterTypeInterruptKind.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeInterruptKind_lower(_ value: InterruptKind) -> RustBuffer {
    return FfiConverterTypeInterruptKind.lower(value)
}


extension InterruptKind: Equatable, Hashable {}




/**
 * The error type for all Suggest component operations. These errors are
 * exposed to your application, which should handle them as needed.
 */
public enum SuggestApiError {

    
    
    case Network(reason: String
    )
    /**
     * The server requested a backoff after too many requests
     */
    case Backoff(seconds: UInt64
    )
    /**
     * An operation was interrupted by calling `SuggestStore.interrupt()`
     */
    case Interrupted
    case Other(reason: String
    )
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestApiError: FfiConverterRustBuffer {
    typealias SwiftType = SuggestApiError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestApiError {
        let variant: Int32 = try readInt(&buf)
        switch variant {

        

        
        case 1: return .Network(
            reason: try FfiConverterString.read(from: &buf)
            )
        case 2: return .Backoff(
            seconds: try FfiConverterUInt64.read(from: &buf)
            )
        case 3: return .Interrupted
        case 4: return .Other(
            reason: try FfiConverterString.read(from: &buf)
            )

         default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SuggestApiError, into buf: inout [UInt8]) {
        switch value {

        

        
        
        case let .Network(reason):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(reason, into: &buf)
            
        
        case let .Backoff(seconds):
            writeInt(&buf, Int32(2))
            FfiConverterUInt64.write(seconds, into: &buf)
            
        
        case .Interrupted:
            writeInt(&buf, Int32(3))
        
        
        case let .Other(reason):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(reason, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestApiError_lift(_ buf: RustBuffer) throws -> SuggestApiError {
    return try FfiConverterTypeSuggestApiError.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestApiError_lower(_ value: SuggestApiError) -> RustBuffer {
    return FfiConverterTypeSuggestApiError.lower(value)
}


extension SuggestApiError: Equatable, Hashable {}



extension SuggestApiError: Foundation.LocalizedError {
    public var errorDescription: String? {
        String(reflecting: self)
    }
}


// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * Per-provider configuration data.
 */

public enum SuggestProviderConfig {
    
    case weather(
        /**
         * Weather suggestion score.
         */score: Double, 
        /**
         * Threshold for weather keyword prefix matching when a weather keyword
         * is the first term in a query. Zero means prefix matching is disabled
         * and weather keywords must be typed in full when they are first in
         * the query. (Ideally this would be an `Option` and `None` would mean
         * full keywords are required, but it's probably not worth the breaking
         * API change.) This threshold does not apply to city and region names.
         */minKeywordLength: Int32
    )
}


#if compiler(>=6)
extension SuggestProviderConfig: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestProviderConfig: FfiConverterRustBuffer {
    typealias SwiftType = SuggestProviderConfig

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestProviderConfig {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .weather(score: try FfiConverterDouble.read(from: &buf), minKeywordLength: try FfiConverterInt32.read(from: &buf)
        )
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SuggestProviderConfig, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .weather(score,minKeywordLength):
            writeInt(&buf, Int32(1))
            FfiConverterDouble.write(score, into: &buf)
            FfiConverterInt32.write(minKeywordLength, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestProviderConfig_lift(_ buf: RustBuffer) throws -> SuggestProviderConfig {
    return try FfiConverterTypeSuggestProviderConfig.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestProviderConfig_lower(_ value: SuggestProviderConfig) -> RustBuffer {
    return FfiConverterTypeSuggestProviderConfig.lower(value)
}


extension SuggestProviderConfig: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * A suggestion from the database to show in the address bar.
 */

public enum Suggestion {
    
    case amp(title: String, url: String, rawUrl: String, icon: Data?, iconMimetype: String?, fullKeyword: String, blockId: Int64, advertiser: String, iabCategory: String, impressionUrl: String, clickUrl: String, rawClickUrl: String, score: Double, ftsMatchInfo: FtsMatchInfo?
    )
    case wikipedia(title: String, url: String, icon: Data?, iconMimetype: String?, fullKeyword: String
    )
    case amo(title: String, url: String, iconUrl: String, description: String, rating: String?, numberOfRatings: Int64, guid: String, score: Double
    )
    case yelp(url: String, title: String, icon: Data?, iconMimetype: String?, score: Double, hasLocationSign: Bool, subjectExactMatch: Bool, subjectType: YelpSubjectType, locationParam: String
    )
    case mdn(title: String, url: String, description: String, score: Double
    )
    case weather(city: Geoname?, score: Double
    )
    case fakespot(fakespotGrade: String, productId: String, rating: Double, title: String, totalReviews: Int64, url: String, icon: Data?, iconMimetype: String?, score: Double, matchInfo: FtsMatchInfo?
    )
    case dynamic(suggestionType: String, data: JsonValue?, 
        /**
         * This value is optionally defined in the suggestion's remote settings
         * data and is an opaque token used for dismissing the suggestion in
         * lieu of a URL. If `Some`, the suggestion can be dismissed by passing
         * the wrapped string to [crate::SuggestStore::dismiss_suggestion].
         */dismissalKey: String?, score: Double
    )
}


#if compiler(>=6)
extension Suggestion: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestion: FfiConverterRustBuffer {
    typealias SwiftType = Suggestion

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Suggestion {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .amp(title: try FfiConverterString.read(from: &buf), url: try FfiConverterString.read(from: &buf), rawUrl: try FfiConverterString.read(from: &buf), icon: try FfiConverterOptionData.read(from: &buf), iconMimetype: try FfiConverterOptionString.read(from: &buf), fullKeyword: try FfiConverterString.read(from: &buf), blockId: try FfiConverterInt64.read(from: &buf), advertiser: try FfiConverterString.read(from: &buf), iabCategory: try FfiConverterString.read(from: &buf), impressionUrl: try FfiConverterString.read(from: &buf), clickUrl: try FfiConverterString.read(from: &buf), rawClickUrl: try FfiConverterString.read(from: &buf), score: try FfiConverterDouble.read(from: &buf), ftsMatchInfo: try FfiConverterOptionTypeFtsMatchInfo.read(from: &buf)
        )
        
        case 2: return .wikipedia(title: try FfiConverterString.read(from: &buf), url: try FfiConverterString.read(from: &buf), icon: try FfiConverterOptionData.read(from: &buf), iconMimetype: try FfiConverterOptionString.read(from: &buf), fullKeyword: try FfiConverterString.read(from: &buf)
        )
        
        case 3: return .amo(title: try FfiConverterString.read(from: &buf), url: try FfiConverterString.read(from: &buf), iconUrl: try FfiConverterString.read(from: &buf), description: try FfiConverterString.read(from: &buf), rating: try FfiConverterOptionString.read(from: &buf), numberOfRatings: try FfiConverterInt64.read(from: &buf), guid: try FfiConverterString.read(from: &buf), score: try FfiConverterDouble.read(from: &buf)
        )
        
        case 4: return .yelp(url: try FfiConverterString.read(from: &buf), title: try FfiConverterString.read(from: &buf), icon: try FfiConverterOptionData.read(from: &buf), iconMimetype: try FfiConverterOptionString.read(from: &buf), score: try FfiConverterDouble.read(from: &buf), hasLocationSign: try FfiConverterBool.read(from: &buf), subjectExactMatch: try FfiConverterBool.read(from: &buf), subjectType: try FfiConverterTypeYelpSubjectType.read(from: &buf), locationParam: try FfiConverterString.read(from: &buf)
        )
        
        case 5: return .mdn(title: try FfiConverterString.read(from: &buf), url: try FfiConverterString.read(from: &buf), description: try FfiConverterString.read(from: &buf), score: try FfiConverterDouble.read(from: &buf)
        )
        
        case 6: return .weather(city: try FfiConverterOptionTypeGeoname.read(from: &buf), score: try FfiConverterDouble.read(from: &buf)
        )
        
        case 7: return .fakespot(fakespotGrade: try FfiConverterString.read(from: &buf), productId: try FfiConverterString.read(from: &buf), rating: try FfiConverterDouble.read(from: &buf), title: try FfiConverterString.read(from: &buf), totalReviews: try FfiConverterInt64.read(from: &buf), url: try FfiConverterString.read(from: &buf), icon: try FfiConverterOptionData.read(from: &buf), iconMimetype: try FfiConverterOptionString.read(from: &buf), score: try FfiConverterDouble.read(from: &buf), matchInfo: try FfiConverterOptionTypeFtsMatchInfo.read(from: &buf)
        )
        
        case 8: return .dynamic(suggestionType: try FfiConverterString.read(from: &buf), data: try FfiConverterOptionTypeJsonValue.read(from: &buf), dismissalKey: try FfiConverterOptionString.read(from: &buf), score: try FfiConverterDouble.read(from: &buf)
        )
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: Suggestion, into buf: inout [UInt8]) {
        switch value {
        
        
        case let .amp(title,url,rawUrl,icon,iconMimetype,fullKeyword,blockId,advertiser,iabCategory,impressionUrl,clickUrl,rawClickUrl,score,ftsMatchInfo):
            writeInt(&buf, Int32(1))
            FfiConverterString.write(title, into: &buf)
            FfiConverterString.write(url, into: &buf)
            FfiConverterString.write(rawUrl, into: &buf)
            FfiConverterOptionData.write(icon, into: &buf)
            FfiConverterOptionString.write(iconMimetype, into: &buf)
            FfiConverterString.write(fullKeyword, into: &buf)
            FfiConverterInt64.write(blockId, into: &buf)
            FfiConverterString.write(advertiser, into: &buf)
            FfiConverterString.write(iabCategory, into: &buf)
            FfiConverterString.write(impressionUrl, into: &buf)
            FfiConverterString.write(clickUrl, into: &buf)
            FfiConverterString.write(rawClickUrl, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            FfiConverterOptionTypeFtsMatchInfo.write(ftsMatchInfo, into: &buf)
            
        
        case let .wikipedia(title,url,icon,iconMimetype,fullKeyword):
            writeInt(&buf, Int32(2))
            FfiConverterString.write(title, into: &buf)
            FfiConverterString.write(url, into: &buf)
            FfiConverterOptionData.write(icon, into: &buf)
            FfiConverterOptionString.write(iconMimetype, into: &buf)
            FfiConverterString.write(fullKeyword, into: &buf)
            
        
        case let .amo(title,url,iconUrl,description,rating,numberOfRatings,guid,score):
            writeInt(&buf, Int32(3))
            FfiConverterString.write(title, into: &buf)
            FfiConverterString.write(url, into: &buf)
            FfiConverterString.write(iconUrl, into: &buf)
            FfiConverterString.write(description, into: &buf)
            FfiConverterOptionString.write(rating, into: &buf)
            FfiConverterInt64.write(numberOfRatings, into: &buf)
            FfiConverterString.write(guid, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            
        
        case let .yelp(url,title,icon,iconMimetype,score,hasLocationSign,subjectExactMatch,subjectType,locationParam):
            writeInt(&buf, Int32(4))
            FfiConverterString.write(url, into: &buf)
            FfiConverterString.write(title, into: &buf)
            FfiConverterOptionData.write(icon, into: &buf)
            FfiConverterOptionString.write(iconMimetype, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            FfiConverterBool.write(hasLocationSign, into: &buf)
            FfiConverterBool.write(subjectExactMatch, into: &buf)
            FfiConverterTypeYelpSubjectType.write(subjectType, into: &buf)
            FfiConverterString.write(locationParam, into: &buf)
            
        
        case let .mdn(title,url,description,score):
            writeInt(&buf, Int32(5))
            FfiConverterString.write(title, into: &buf)
            FfiConverterString.write(url, into: &buf)
            FfiConverterString.write(description, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            
        
        case let .weather(city,score):
            writeInt(&buf, Int32(6))
            FfiConverterOptionTypeGeoname.write(city, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            
        
        case let .fakespot(fakespotGrade,productId,rating,title,totalReviews,url,icon,iconMimetype,score,matchInfo):
            writeInt(&buf, Int32(7))
            FfiConverterString.write(fakespotGrade, into: &buf)
            FfiConverterString.write(productId, into: &buf)
            FfiConverterDouble.write(rating, into: &buf)
            FfiConverterString.write(title, into: &buf)
            FfiConverterInt64.write(totalReviews, into: &buf)
            FfiConverterString.write(url, into: &buf)
            FfiConverterOptionData.write(icon, into: &buf)
            FfiConverterOptionString.write(iconMimetype, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            FfiConverterOptionTypeFtsMatchInfo.write(matchInfo, into: &buf)
            
        
        case let .dynamic(suggestionType,data,dismissalKey,score):
            writeInt(&buf, Int32(8))
            FfiConverterString.write(suggestionType, into: &buf)
            FfiConverterOptionTypeJsonValue.write(data, into: &buf)
            FfiConverterOptionString.write(dismissalKey, into: &buf)
            FfiConverterDouble.write(score, into: &buf)
            
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestion_lift(_ buf: RustBuffer) throws -> Suggestion {
    return try FfiConverterTypeSuggestion.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestion_lower(_ value: Suggestion) -> RustBuffer {
    return FfiConverterTypeSuggestion.lower(value)
}


extension Suggestion: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * A provider is a source of search suggestions.
 * Please preserve the integer values after removing or adding providers.
 * Provider configs are associated with integer keys stored in the database.
 */

public enum SuggestionProvider : UInt8 {
    
    case amp = 1
    case wikipedia = 2
    case amo = 3
    case yelp = 5
    case mdn = 6
    case weather = 7
    case fakespot = 8
    case dynamic = 9
}


#if compiler(>=6)
extension SuggestionProvider: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeSuggestionProvider: FfiConverterRustBuffer {
    typealias SwiftType = SuggestionProvider

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SuggestionProvider {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .amp
        
        case 2: return .wikipedia
        
        case 3: return .amo
        
        case 4: return .yelp
        
        case 5: return .mdn
        
        case 6: return .weather
        
        case 7: return .fakespot
        
        case 8: return .dynamic
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: SuggestionProvider, into buf: inout [UInt8]) {
        switch value {
        
        
        case .amp:
            writeInt(&buf, Int32(1))
        
        
        case .wikipedia:
            writeInt(&buf, Int32(2))
        
        
        case .amo:
            writeInt(&buf, Int32(3))
        
        
        case .yelp:
            writeInt(&buf, Int32(4))
        
        
        case .mdn:
            writeInt(&buf, Int32(5))
        
        
        case .weather:
            writeInt(&buf, Int32(6))
        
        
        case .fakespot:
            writeInt(&buf, Int32(7))
        
        
        case .dynamic:
            writeInt(&buf, Int32(8))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestionProvider_lift(_ buf: RustBuffer) throws -> SuggestionProvider {
    return try FfiConverterTypeSuggestionProvider.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeSuggestionProvider_lower(_ value: SuggestionProvider) -> RustBuffer {
    return FfiConverterTypeSuggestionProvider.lower(value)
}


extension SuggestionProvider: Equatable, Hashable {}



// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
/**
 * Subject type for Yelp suggestion.
 */

public enum YelpSubjectType : UInt8 {
    
    case service = 0
    case business = 1
}


#if compiler(>=6)
extension YelpSubjectType: Sendable {}
#endif

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeYelpSubjectType: FfiConverterRustBuffer {
    typealias SwiftType = YelpSubjectType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> YelpSubjectType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        
        case 1: return .service
        
        case 2: return .business
        
        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: YelpSubjectType, into buf: inout [UInt8]) {
        switch value {
        
        
        case .service:
            writeInt(&buf, Int32(1))
        
        
        case .business:
            writeInt(&buf, Int32(2))
        
        }
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeYelpSubjectType_lift(_ buf: RustBuffer) throws -> YelpSubjectType {
    return try FfiConverterTypeYelpSubjectType.lift(buf)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeYelpSubjectType_lower(_ value: YelpSubjectType) -> RustBuffer {
    return FfiConverterTypeYelpSubjectType.lower(value)
}


extension YelpSubjectType: Equatable, Hashable {}



#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionInt32: FfiConverterRustBuffer {
    typealias SwiftType = Int32?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt32.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt32.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionData: FfiConverterRustBuffer {
    typealias SwiftType = Data?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterData.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterData.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeAlternateNames: FfiConverterRustBuffer {
    typealias SwiftType = AlternateNames?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeAlternateNames.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeAlternateNames.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeFtsMatchInfo: FfiConverterRustBuffer {
    typealias SwiftType = FtsMatchInfo?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeFtsMatchInfo.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeFtsMatchInfo.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeGeoname: FfiConverterRustBuffer {
    typealias SwiftType = Geoname?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeGeoname.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeGeoname.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeSuggestionProviderConstraints: FfiConverterRustBuffer {
    typealias SwiftType = SuggestionProviderConstraints?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeSuggestionProviderConstraints.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeSuggestionProviderConstraints.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeAmpMatchingStrategy: FfiConverterRustBuffer {
    typealias SwiftType = AmpMatchingStrategy?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeAmpMatchingStrategy.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeAmpMatchingStrategy.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeInterruptKind: FfiConverterRustBuffer {
    typealias SwiftType = InterruptKind?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeInterruptKind.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeInterruptKind.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeSuggestProviderConfig: FfiConverterRustBuffer {
    typealias SwiftType = SuggestProviderConfig?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeSuggestProviderConfig.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeSuggestProviderConfig.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceTypeGeoname: FfiConverterRustBuffer {
    typealias SwiftType = [Geoname]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeGeoname.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeGeoname.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionSequenceTypeSuggestionProvider: FfiConverterRustBuffer {
    typealias SwiftType = [SuggestionProvider]?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterSequenceTypeSuggestionProvider.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterSequenceTypeSuggestionProvider.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterOptionTypeJsonValue: FfiConverterRustBuffer {
    typealias SwiftType = JsonValue?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeJsonValue.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeJsonValue.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeGeoname: FfiConverterRustBuffer {
    typealias SwiftType = [Geoname]

    public static func write(_ value: [Geoname], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeGeoname.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Geoname] {
        let len: Int32 = try readInt(&buf)
        var seq = [Geoname]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeGeoname.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeGeonameMatch: FfiConverterRustBuffer {
    typealias SwiftType = [GeonameMatch]

    public static func write(_ value: [GeonameMatch], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeGeonameMatch.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [GeonameMatch] {
        let len: Int32 = try readInt(&buf)
        var seq = [GeonameMatch]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeGeonameMatch.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeLabeledTimingSample: FfiConverterRustBuffer {
    typealias SwiftType = [LabeledTimingSample]

    public static func write(_ value: [LabeledTimingSample], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeLabeledTimingSample.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [LabeledTimingSample] {
        let len: Int32 = try readInt(&buf)
        var seq = [LabeledTimingSample]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeLabeledTimingSample.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeSuggestion: FfiConverterRustBuffer {
    typealias SwiftType = [Suggestion]

    public static func write(_ value: [Suggestion], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeSuggestion.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [Suggestion] {
        let len: Int32 = try readInt(&buf)
        var seq = [Suggestion]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeSuggestion.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterSequenceTypeSuggestionProvider: FfiConverterRustBuffer {
    typealias SwiftType = [SuggestionProvider]

    public static func write(_ value: [SuggestionProvider], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeSuggestionProvider.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [SuggestionProvider] {
        let len: Int32 = try readInt(&buf)
        var seq = [SuggestionProvider]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            seq.append(try FfiConverterTypeSuggestionProvider.read(from: &buf))
        }
        return seq
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterDictionaryUInt8String: FfiConverterRustBuffer {
    public static func write(_ value: [UInt8: String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for (key, value) in value {
            FfiConverterUInt8.write(key, into: &buf)
            FfiConverterString.write(value, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [UInt8: String] {
        let len: Int32 = try readInt(&buf)
        var dict = [UInt8: String]()
        dict.reserveCapacity(Int(len))
        for _ in 0..<len {
            let key = try FfiConverterUInt8.read(from: &buf)
            let value = try FfiConverterString.read(from: &buf)
            dict[key] = value
        }
        return dict
    }
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
fileprivate struct FfiConverterDictionaryUInt8TypeAlternateNames: FfiConverterRustBuffer {
    public static func write(_ value: [UInt8: AlternateNames], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for (key, value) in value {
            FfiConverterUInt8.write(key, into: &buf)
            FfiConverterTypeAlternateNames.write(value, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [UInt8: AlternateNames] {
        let len: Int32 = try readInt(&buf)
        var dict = [UInt8: AlternateNames]()
        dict.reserveCapacity(Int(len))
        for _ in 0..<len {
            let key = try FfiConverterUInt8.read(from: &buf)
            let value = try FfiConverterTypeAlternateNames.read(from: &buf)
            dict[key] = value
        }
        return dict
    }
}


/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias JsonValue = String

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public struct FfiConverterTypeJsonValue: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> JsonValue {
        return try FfiConverterString.read(from: &buf)
    }

    public static func write(_ value: JsonValue, into buf: inout [UInt8]) {
        return FfiConverterString.write(value, into: &buf)
    }

    public static func lift(_ value: RustBuffer) throws -> JsonValue {
        return try FfiConverterString.lift(value)
    }

    public static func lower(_ value: JsonValue) -> RustBuffer {
        return FfiConverterString.lower(value)
    }
}


#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJsonValue_lift(_ value: RustBuffer) throws -> JsonValue {
    return try FfiConverterTypeJsonValue.lift(value)
}

#if swift(>=5.8)
@_documentation(visibility: private)
#endif
public func FfiConverterTypeJsonValue_lower(_ value: JsonValue) -> RustBuffer {
    return FfiConverterTypeJsonValue.lower(value)
}

/**
 * Determines whether a "raw" sponsored suggestion URL is equivalent to a
 * "cooked" URL. The two URLs are equivalent if they are identical except for
 * their replaced template parameters, which can be different.
 */
public func rawSuggestionUrlMatches(rawUrl: String, cookedUrl: String) -> Bool  {
    return try!  FfiConverterBool.lift(try! rustCall() {
    uniffi_suggest_fn_func_raw_suggestion_url_matches(
        FfiConverterString.lower(rawUrl),
        FfiConverterString.lower(cookedUrl),$0
    )
})
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}
// Use a global variable to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private let initializationResult: InitializationResult = {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_suggest_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if (uniffi_suggest_checksum_func_raw_suggestion_url_matches() != 23311) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_any_dismissed_suggestions() != 57138) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_clear() != 24590) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_clear_dismissed_suggestions() != 39430) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_dismiss_by_key() != 48043) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_dismiss_by_suggestion() != 22306) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_dismiss_suggestion() != 47056) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_fetch_geoname_alternates() != 45937) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_fetch_geonames() != 64684) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_fetch_global_config() != 45439) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_fetch_provider_config() != 15656) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_ingest() != 35498) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_interrupt() != 26986) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_is_dismissed_by_key() != 29440) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_is_dismissed_by_suggestion() != 6416) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_query() != 856) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststore_query_with_metrics() != 14851) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_build() != 42072) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_cache_path() != 55168) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_data_path() != 48491) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_load_extension() != 7246) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_remote_settings_bucket_name() != 41780) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_remote_settings_server() != 19990) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_method_suggeststorebuilder_remote_settings_service() != 25201) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_constructor_suggeststore_new() != 7882) {
        return InitializationResult.apiChecksumMismatch
    }
    if (uniffi_suggest_checksum_constructor_suggeststorebuilder_new() != 1218) {
        return InitializationResult.apiChecksumMismatch
    }

    uniffiEnsureRemoteSettingsInitialized()
    return InitializationResult.ok
}()

// Make the ensure init function public so that other modules which have external type references to
// our types can call it.
public func uniffiEnsureSuggestInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// swiftlint:enable all