;'use strict';(function(exports){var DEBUG=false;exports.Service={_providers:new Map(),_services:new Map(),_requestsByService:new Map(),_requestsByProvider:new Map(),request:function(service){var requestItems=service.split(':');var args=Array.prototype.slice.call(arguments,1);var self=this;this.debug(requestItems);if(requestItems.length>1){var serverName=requestItems[0];var serviceName=requestItems[1];if(this._providers.get(serverName)){this.debug('service: '+serviceName+' is online, perform the request with '+args.concat());return new Promise(function(resolve,reject){var returnValue=self._providers.get(serverName)[serviceName].apply(self._providers.get(serverName),args);self._unwrapPromise(returnValue,resolve,reject);});}else{return new Promise(function(resolve,reject){self.debug('service: '+service+' is offline, queue the task.');if(!self._requestsByProvider.has(serverName)){self._requestsByProvider.set(serverName,[]);}
self._requestsByProvider.get(serverName).push({service:serviceName,resolve:resolve,reject:reject,args:args});});}
return;}
if(this._services.has(service)){var server=this._services.get(service);this.debug('service ['+service+'] provider ['+server.name+'] is online, perform the task.');return new Promise(function(resolve,reject){var returnValue=resolve(server[service].apply(server,args));self._unwrapPromise(returnValue,resolve,reject);});}else{this.debug('service: '+service+' is offline, queue the task.');var promise=new Promise(function(resolve,reject){self.debug('storing the requests...');if(!self._requestsByService.has(service)){self._requestsByService.set(service,[]);}
self._requestsByService.get(service).push({service:service,args:args,resolve:resolve,reject:reject});});return promise;}},register:function(service,server){var self=this;if(!this._providers.has(server.name)){this._providers.set(server.name,server);}
this.debug((server.name||'(Anonymous)')+' is registering service: ['+service+']');this.debug('checking awaiting requests by server..');if(this._requestsByProvider.has(server.name)){this._requestsByProvider.get(server.name).forEach(function(request){self.debug('resolving..',server,server.name,request.service,request.args);var returnValue=(typeof(server[request.service])==='function')?server[request.service].apply(server,request.args):server[request.service];self._unwrapPromise(returnValue,request.resolve,request.reject);});this._requestsByProvider.delete(server.name);}
if(!this._services.has(service)){this._services.set(service,server);}else{this.debug('the service ['+service+'] has already been '+'registered by other server:',this._services.get(service).name);return;}
this.debug('checking awaiting requests by service..');if(this._requestsByService.has(service)){this._requestsByService.get(service).forEach(function(request){self.debug('resolving..',server,request.service);var returnValue=server[request.service].apply(server,request.args);self._unwrapPromise(returnValue,request.resolve,request.reject);});this._requestsByService.delete(service);}},_unwrapPromise:function(returnValue,resolve,reject){if(returnValue&&returnValue.then&&returnValue.catch){this.debug('return value is promise',returnValue);returnValue.then(function(result){resolve(result);}).catch(function(error){reject(error);});}else{this.debug('return value is non-promise',returnValue);resolve(returnValue);}},unregister:function(service,server){this._providers.delete(server.name);var se=this._services.get(service);if(se&&server===se){this._services.delete(service);}},_states:new Map(),_statesByState:new Map(),registerState:function(state,provider){this._states.set(provider.name,provider);this._statesByState.set(state,provider);},unregisterState:function(state,provider){this._states.delete(provider.name);var machine=this._statesByState.get(state);if(machine===provider){this._statesByState.delete(state);}},query:function(stateString){this.debug(stateString);var args=stateString.split('.');var state,provider;if(args.length>1){provider=this._states.get(args[0]);state=args[1];}else{state=args[0];provider=this._statesByState.get(state);}
if(!provider){this.debug('Provider not ready, return undefined state.');return undefined;}
if(typeof(provider[state])==='function'){var functionArgs=Array.prototype.slice.call(arguments,1);return provider[state].apply(provider,functionArgs);}else{return provider[state];}},get applicationReady(){return window.applications&&window.applications.ready;},isBusyLoading:function(){var app=this.currentApp;return app&&!app.loaded;},_start:new Date().getTime()/1000,currentTime:function(){return(new Date().getTime()/1000-this._start).toFixed(3);},debug:function sys_debug(){if(DEBUG){console.log('[System]'+'['+window.Service.currentTime()+']'+
Array.slice(arguments).concat());}},get runningFTU(){if('undefined'===typeof window.FtuLauncher){return false;}else{return window.FtuLauncher.isFtuRunning();}},get locked(){if('undefined'===typeof window.lockScreenWindowManager){return false;}else{return window.lockScreenWindowManager.isActive();}},get manifestURL(){return window.location.href.replace('index.html','manifest.webapp');},get currentApp(){if('undefined'===typeof window.appWindowManager){return null;}else{return window.appWindowManager.getActiveApp();}}};})(window);;'use strict';var FtuLauncher={name:'FtuLauncher',_ftu:null,_ftuManifestURL:'',_ftuOrigin:'',_ftuPing:null,_isRunningFirstTime:false,_isUpgrading:false,_bypassHomeEvent:false,isFtuRunning:function fl_isFtuRunning(){return this._isRunningFirstTime;},isFtuUpgrading:function fl_isFtuUpgrading(){return this._isUpgrading;},getFtuOrigin:function fl_getFtuOrigin(){return this._ftuOrigin;},getFtuPing:function fl_getFtuPing(){return this._ftuPing;},setBypassHome:function fl_setBypassHome(value){this._bypassHomeEvent=value;},init:function fl_init(){this._stepsList=[];this._storedStepRequest=[];window.addEventListener('iac-ftucomms',this);window.addEventListener('appterminated',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('appopened',this);Service.registerState('isFtuUpgrading',this);Service.registerState('isFtuRunning',this);Service.register('stepReady',this);},updateStep:function(step){if(this._stepsList.indexOf(step)<0){this._stepsList.push(step);}
var remainingRequest=[];this._storedStepRequest.forEach(function(request,index){if(this._skipped||this._stepsList.indexOf(request.step)>=0){request.resolve();}else{remainingRequest.push(request);}},this);this._storedStepRequest=remainingRequest;},_handle_home:function(){if(this._isRunningFirstTime){if(!this._bypassHomeEvent){return false;}else{var killEvent=document.createEvent('CustomEvent');killEvent.initCustomEvent('killapp',true,false,{origin:this._ftuOrigin});window.dispatchEvent(killEvent);}}
return true;},_handle_holdhome:function(){if(this._isRunningFirstTime){return false;}
return true;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;},stepReady:function(step){return new Promise(function(resolve){if(this._stepsList.indexOf(step)>=0||this._skipped){resolve();}else{this._storedStepRequest.push({resolve:resolve,step:step});}}.bind(this));},handleEvent:function fl_init(evt){switch(evt.type){case'appopened':if(evt.detail.origin==this._ftuOrigin&&this._isRunningFirstTime){var ftuopenEvt=document.createEvent('CustomEvent');ftuopenEvt.initCustomEvent('ftuopen',true,false,{});window.dispatchEvent(ftuopenEvt);}
break;case'iac-ftucomms':var message=evt.detail;if(message==='done'){this.setBypassHome(true);}else if(evt.detail.type==='step'){this.updateStep(evt.detail.hash);}
break;case'appterminated':if(evt.detail.origin==this._ftuOrigin){this.close();}
break;}},close:function fl_close(){this._isRunningFirstTime=false;this._isUpgrading=false;window.asyncStorage.setItem('ftu.enabled',false);VersionHelper.updatePrevious();this.updateStep('done');var evt=document.createEvent('CustomEvent');evt.initCustomEvent('ftudone',true,false,{});window.dispatchEvent(evt);},launch:function fl_launch(){var self=this;var req=navigator.mozSettings.createLock().get('ftu.manifestURL');req.onsuccess=function(){var manifestURL=req.result['ftu.manifestURL'];self._ftuManifestURL=manifestURL;if(!manifestURL){dump('FTU manifest cannot be found, skipping.\n');self.skip();return;}
var ftu=self._ftu=applications.getByManifestURL(manifestURL);if(!ftu){dump('Opps, bogus FTU manifest.\n');self.skip();return;}
self._isRunningFirstTime=true;self._ftuOrigin=ftu.origin;ftu.launch();};req.onerror=function(){dump('Couldn\'t get the ftu manifestURL.\n');self.skip();};},skip:function fl_skip(){this._isRunningFirstTime=false;this._isUpgrading=false;this._skipped=true;this.updateStep('done');var evt=document.createEvent('CustomEvent');evt.initCustomEvent('ftuskip',true,false,{});window.dispatchEvent(evt);},retrieve:function fl_retrieve(){var self=this;if(!this._ftuPing){this._ftuPing=new FtuPing();}
this._ftuPing.ensurePing();VersionHelper.getVersionInfo().then(function(versionInfo){if(versionInfo.isUpgrade()){self._isUpgrading=true;self.launch();}else{window.asyncStorage.getItem('ftu.enabled',function getItem(shouldFTU){self._isUpgrading=false;if(shouldFTU!==false){self.launch();}else{self.skip();}});}},function(err){dump('VersionHelper failed to lookup version settings, skipping.\n');self.skip();});}};FtuLauncher.init();;'use strict';(function(window){var nextId=0;window.BrowserFrame=function BrowserFrame(){this.element=null;this._id=nextId++;createFrame.apply(this,arguments);return this;};BrowserFrame.prototype.CLASS_NAME='browser';function createFrame(config,frame){var browser=frame||document.createElement('iframe');browser.setAttribute('mozbrowser','true');browser.name=config.window_name||'main';if(config.oop){browser.setAttribute('remote','true');}
if(config.isPrivate){browser.setAttribute('mozprivatebrowsing','true');}
if(config.manifestURL){browser.setAttribute('mozapp',config.manifestURL);if(config.isSystemMessage){browser.setAttribute('expecting-system-message','expecting-system-message');}}
if(config.parentApp){browser.setAttribute('parentapp',config.parentApp);}
if(config.isInputMethod){browser.setAttribute('mozpasspointerevents','true');browser.setAttribute('ignoreuserfocus','true');}else{browser.setAttribute('mozallowfullscreen','true');}
setMozAppType(browser,config);if(config.url){browser.src=config.url;browser.dataset.url=config.url;}
browser.id=this.CLASS_NAME+this._id;browser.classList.add(this.CLASS_NAME);this.config=config;this.element=browser;};function setMozAppType(iframe,config){if(config.url.startsWith(window.location.protocol+'//callscreen.gaiamobile.org')||config.url.startsWith(window.location.protocol+'//clock.gaiamobile.org')){iframe.setAttribute('mozapptype','critical');}else if(config.isHomescreen){iframe.setAttribute('mozapptype','homescreen');}else if(config.isSearch){iframe.setAttribute('mozapptype','search');}else if(config.isInputMethod){iframe.setAttribute('mozapptype','inputmethod');}}}(this));;'use strict';var EntrySheet=(function invocation(){function EntrySheet(){render.apply(this,arguments);}
EntrySheet.className='entrySheet';EntrySheet.prototype.setTitle=function(title){this.titleElement.textContent=title;};EntrySheet.prototype.open=function(){setTimeout(function(){this.element.classList.add('active');}.bind(this));};EntrySheet.prototype.close=function(){this.element.addEventListener('transitionend',function onTransitionend(){this.element.removeEventListener('transitionend',onTransitionend);this.element.classList.remove('disappearing');this.element.classList.remove('active');this.container.removeChild(this.element);}.bind(this));this.element.classList.add('disappearing');};function view(){return`<div class="${EntrySheet.className}">
      <section role="region" class="skin-organic header">
        <gaia-header action="close">
          <h1 class="title"></h1>
        </gaia-header>
        <div class="throbber"></div>
      </section>
      <div class="content">
      </div>
    </div>`;}
function render(container,title,content){this.container=container;this.title=title;this.container.insertAdjacentHTML('beforeend',view.apply(this));this.header=this.container.querySelector('.'+EntrySheet.className+' gaia-header');this.titleElement=this.container.querySelector('.'+EntrySheet.className+' .title');this.throbberElement=this.container.querySelector('.'+EntrySheet.className+' .throbber');this.content=this.container.querySelector('.'+EntrySheet.className+' .content');this.element=this.container.querySelector('.'+EntrySheet.className);this.element.dataset.zIndexLevel='dialog-overlay';var self=this;if(typeof(BrowserFrame)!='undefined'&&content instanceof BrowserFrame){content.element.addEventListener('mozbrowserloadstart',function onLoadStart(){self.throbberElement.dataset.loading=true;});content.element.addEventListener('mozbrowserloadend',function onLoadEnd(){delete self.throbberElement.dataset.loading;});this.content.appendChild(content.element);}else if(content&&content.nodeType==1){this.content.appendChild(content);}
this.setTitle(this.title);this.header.addEventListener('action',function(){self.close();});}
return EntrySheet;}());;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,value,ast){var pos,v;if(value.indexOf('{{')!==-1){value=this.parseString(value);}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v===undefined?null:node.$v,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
var value;if(Array.isArray(node)){value=node;}
return{id:id,value:value||node.$v||null,index:node.$x||null,env:env,dirty:false};}
function format(args,entity){if(typeof entity==='string'){return entity;}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var val;try{val=resolveValue(args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return val;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return env['__'+id];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return args[id];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(args,env,id){var value;try{value=resolveIdentifier(args,env,id);}catch(err){return'{{ '+id+' }}';}
if(typeof value==='number'){return value;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
return value;}
return'{{ '+id+' }}';}
function interpolate(args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return prev+cur;}else if(cur.t==='idOrVar'){return prev+subPlaceable(args,env,cur.v);}},'');}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName);if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1]):undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(args,env,expr,index){if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'||!expr){return expr;}
if(Array.isArray(expr)){return interpolate(args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(args,env,expr[selector]);}}
if('other'in expr){return resolveValue(args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;(key=keys[i]);i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function replaceChars(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\}|&[#\w]+;)/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return replaceChars(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO={'qps-ploc':new Pseudo('qps-ploc','Runtime Accented',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Runtime Mirrored',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo()?this.ctx.defaultLocale:id);}
Locale.prototype.isPseudo=function(){return this.ctx.qps.indexOf(this.id)!==-1;};var bindingsIO={extra:function(id,ver,path,type,callback,errback){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo()?ctx.defaultLocale:this.id;var appVersion=null;var source='app';if(typeof(navigator)!=='undefined'){source=navigator.mozL10n._config.localeSources[this.id]||'app';appVersion=navigator.mozL10n._config.appVersion;}
for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo()?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0,node;node=ast[i];i++){this.entries[node.$i]=createEntry(node,this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.qps=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);return entity.id;}}
function formatEntity(args,entity){if(!entity.attrs){return{value:formatValue.call(this,args,entity),attrs:null};}
var formatted={value:formatValue.call(this,args,entity),attrs:Object.create(null)};for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){var supportedLocale;for(var i=0;i<requested.length;i++){var locale=requested[i];if(available.indexOf(locale)!==-1){supportedLocale=locale;break;}}
if(!supportedLocale||supportedLocale===defaultLocale){return[defaultLocale];}
return[supportedLocale,defaultLocale];}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];this.qps=Object.keys(PSEUDO);if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);var pos=this.qps.indexOf(loc);if(pos!==-1){this.qps.splice(pos,1);}}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var supported=negotiate(this.availableLocales.concat(this.qps),requested,this.defaultLocale);if(this.supportedLocales[0]!==supported[0]){freeze.call(this,supported);}};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=navigator.mozL10n.ctx.qps.indexOf(navigator.language)===-1&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(!pretranslate){initObserver();}
initResources.call(navigator.mozL10n);}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
var allowedHtmlAttrs={'ariaLabel':'aria-label','ariaValueText':'aria-valuetext','ariaMozHint':'aria-moz-hint','label':'label','placeholder':'placeholder','title':'title'};function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(!entity){return false;}
if(typeof entity.value==='string'){setTextContent.call(this,l10n.id,element,entity.value);}
for(var key in entity.attrs){var attr=entity.attrs[key];if(allowedHtmlAttrs.hasOwnProperty(key)){element.setAttribute(allowedHtmlAttrs[key],attr);}else if(key==='innerHTML'){element.innerHTML=attr;}}
return true;}
function setTextContent(id,element,text){if(element.firstElementChild){throw new L10nError('setTextContent is deprecated (https://bugzil.la/1053629). '+'Setting text content of elements with child elements is no longer '+'supported by l10n.js. Offending data-l10n-id: "'+id+'" on element '+element.outerHTML+' in '+this.ctx.id);}
element.textContent=text;}})(this);;(function(exports){'use strict';var SettingsHelper=function(key,defaultValue){var SETTINGS_KEY=key;var _settings=navigator.mozSettings;var _value=null;var _defaultValue=defaultValue;var _isReady=false;var _callbacks=[];var _return=function sh_return(callback){if(!callback){return;}
callback.apply(null,Array.prototype.slice.call(arguments,1));};var _ready=function sh_ready(callback){if(!callback){return;}
if(_isReady){callback();}else{_callbacks.push(callback);}};var _getValue=function sh_getValue(callback){var req=_settings.createLock().get(SETTINGS_KEY);req.onsuccess=function(){_return(callback,req.result[SETTINGS_KEY]);};req.onerror=function(){console.error('Error getting '+SETTINGS_KEY+'.');_return(callback,null);};};var _setValue=function sh_setValue(value,callback){var obj={};obj[SETTINGS_KEY]=value;var req=_settings.createLock().set(obj);req.onsuccess=function(){_return(callback);};req.onerror=function(){console.error('Error setting '+SETTINGS_KEY+'.');_return(callback);};};var _valuechanged=function sh_valuehanged(e){_value=e.settingValue;};var _init=function sh_init(callback){_getValue(function(value){_value=value?value:_defaultValue;_return(callback);});_settings.addObserver(SETTINGS_KEY,_valuechanged);};_init(function(){_isReady=true;_callbacks.forEach(function(callback){callback();});});return{get:function(callback){_ready(function(){_return(callback,_value?_value:_defaultValue);});},set:function(value,callback){_ready(function(){_setValue(value,_return.bind(null,callback));});},uninit:function(){_settings.removeObserver(SETTINGS_KEY,_valuechanged);}};};exports.SettingsHelper=SettingsHelper;})(this);;'use strict';var DateHelper={todayStarted:function dh_todayStarted(){var now=(new Date()).valueOf();return this.getMidnight(now);},yesterdayStarted:function dh_yesterdayStarted(){var now=(new Date()).valueOf();var dayAgo=now-86400000;return this.getMidnight(dayAgo);},thisWeekStarted:function dh_thisWeekStarted(){var now=new Date();var dayOfTheWeek=now.getDay();var firstDay=new Date(now.getFullYear(),now.getMonth(),now.getDate()-dayOfTheWeek);return this.getMidnight(firstDay);},thisMonthStarted:function dh_thisMonthStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),now.getMonth(),1).valueOf());return firstDay;},lastSixMonthsStarted:function dh_lastSixMonthsStarted(){var now=new Date().valueOf();var sixMonthsAgo=now-2629743830*6;return sixMonthsAgo;},thisYearStarted:function dh_thisYearStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),0).valueOf());return firstDay;},getMidnight:function dh_getMidnight(timestamp){var day=new Date(timestamp);var midnight=(new Date(day.getFullYear(),day.getMonth(),day.getDate(),0).valueOf());return midnight;}};var NumberHelper={zfill:function nh_zfill(string,len){var s=string;while(s.length<len){s='0'+s;}
return s;}};var StringHelper={fromUTF8:function ut_fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;},camelCase:function ut_camelCase(str){var rdashes=/-(.)/g;return str.replace(rdashes,function replacer(str,p1){return p1.toUpperCase();});}};var HtmlHelper={createHighlightHTML:function ut_createHighlightHTML(text,terms){var toHighlight=[];var normalizedText=Normalizer.toAscii(text).toLowerCase();terms.forEach(function(term){term=Normalizer.toAscii(term).toLowerCase();var index=normalizedText.indexOf(term);while(index>=0){for(var i=0,length=term.length;i<length;i++){toHighlight[index+i]=true;}
index=normalizedText.indexOf(term,index+term.length);}});var highlighted=[];for(var i=0;i<text.length;i++){if(!toHighlight[i]){highlighted.push(text[i]);}else{var term='';while(toHighlight[i]){term+=text[i];i++;}
i--;highlighted.push('<mark>',term,'</mark>');}}
return highlighted.join('');},escapeHTML:function ut_escapeHTML(str,escapeQuotes){var span=document.createElement('span');span.textContent=str;span.innerHTML=span.innerHTML.replace(/\s/g,'&nbsp;');if(escapeQuotes){return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');}
return span.innerHTML;},importElements:function importElements(context){var ids=[].slice.call(arguments,1);ids.forEach(function(id){context[StringHelper.camelCase(id)]=document.getElementById(id);});}};;window.COMPONENTS_BASE_URL='/shared/elements/';;!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.GaiaHeader=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var debug=0?console.log.bind(console):function(){};var cache={};var MIN=16;var MAX=24;var BUFFER=3;module.exports=function(config){debug('font fit',config);var space=config.space-BUFFER;var min=config.min||MIN;var max=config.max||MAX;var text=trim(config.text);var fontSize=max;var textWidth;var font;do{font=config.font.replace(/\d+px/,fontSize+'px');textWidth=getTextWidth(text,font);}while(textWidth>space&&fontSize!==min&&fontSize--);return{textWidth:textWidth,fontSize:fontSize};};function getTextWidth(text,font){var ctx=getCanvasContext(font);var width=ctx.measureText(text).width;debug('got text width',width);return width;}
function getCanvasContext(font){debug('get canvas context',font);var cached=cache[font];if(cached){return cached;}
var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1px');canvas.setAttribute('height','1px');debug('created canvas',canvas);var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=font;return cache[font]=ctx;}
function trim(text){return text.replace(/\s+/g,' ').trim();}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('font-fit',this));},{}],2:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var textContent=Object.getOwnPropertyDescriptor(Node.prototype,'textContent');var removeAttribute=HTMLElement.prototype.removeAttribute;var setAttribute=HTMLElement.prototype.setAttribute;var noop=function(){};var hasShadowCSS=(function(){var div=document.createElement('div');try{div.querySelector(':host');return true;}
catch(e){return false;}})();module.exports.register=function(name,props){var parent=props.extends?props.extends.prototype:base;props.super=parent;delete props.extends;if(props.template){var output=processCss(props.template,name);props.template=document.createElement('template');props.template.innerHTML=output.template;props.lightCss=output.lightCss;props.globalCss=props.globalCss||'';props.globalCss+=output.globalCss;}
injectGlobalCss(props.globalCss);delete props.globalCss;var descriptors=Object.assign(props.attrs||{},baseAttrs);props._attrs=props.attrs;delete props.attrs;var proto=Object.assign(Object.create(parent),props);Object.defineProperties(proto,descriptors);return document.registerElement(name,{prototype:proto});};var base=Object.assign(Object.create(HTMLElement.prototype),{attributeChanged:noop,attached:noop,detached:noop,created:noop,createdCallback:function(){injectLightCss(this);this.created();},attributeChangedCallback:function(name,from,to){var prop=toCamelCase(name);if(this._attrs&&this._attrs[prop]){this[prop]=to;}
this.attributeChanged(name,from,to);},attachedCallback:function(){this.attached();},detachedCallback:function(){this.detached();},setupShadowRoot:function(){if(!this.template){return;}
var node=document.importNode(this.template.content,true);this.createShadowRoot().appendChild(node);return this.shadowRoot;},setAttr:function(name,value){var internal=this.shadowRoot.firstElementChild;setAttribute.call(internal,name,value);setAttribute.call(this,name,value);},removeAttr:function(name){var internal=this.shadowRoot.firstElementChild;removeAttribute.call(internal,name);removeAttribute.call(this,name);}});var baseAttrs={textContent:{set:function(value){var node=firstChildTextNode(this);if(node){node.nodeValue=value;}},get:function(){var node=firstChildTextNode(this);return node&&node.nodeValue;}}};function firstChildTextNode(el){for(var i=0;i<el.childNodes.length;i++){var node=el.childNodes[i];if(node&&node.nodeType===3){return node;}}}
var regex={shadowCss:/(?:\:host|\:\:content)[^{]*\{[^}]*\}/g,':host':/(?:\:host)/g,':host()':/\:host\((.+)\)/g,':host-context':/\:host-context\((.+)\)([^{,]+)?/g,'::content':/(?:\:\:content)/g};function processCss(template,name){var globalCss='';var lightCss='';if(!hasShadowCSS){template=template.replace(regex.shadowCss,function(match){var hostContext=regex[':host-context'].exec(match);if(hostContext){globalCss+=match.replace(regex['::content'],'').replace(regex[':host-context'],'$1 '+name+'$2').replace(/ +/g,' ');}else{lightCss+=match.replace(regex[':host()'],name+'$1').replace(regex[':host'],name).replace(regex['::content'],name);}
return'';});}
return{template:template,lightCss:lightCss,globalCss:globalCss};}
function injectGlobalCss(css){if(!css)return;var style=document.createElement('style');style.innerHTML=css.trim();document.head.appendChild(style);}
function injectLightCss(el){if(hasShadowCSS){return;}
el.lightStyle=document.createElement('style');el.lightStyle.setAttribute('scoped','');el.lightStyle.innerHTML=el.lightCss;el.appendChild(el.lightStyle);}
function toCamelCase(string){return string.replace(/-(.)/g,function replacer(string,p1){return p1.toUpperCase();});}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-component',this));},{}],3:[function(require,module,exports){(function(define){define(function(require,exports,module){var base=window.GAIA_ICONS_BASE_URL||window.COMPONENTS_BASE_URL||'bower_components/';if(!isLoaded()){load(base+'gaia-icons/gaia-icons.css');}
function load(href){var link=document.createElement('link');link.rel='stylesheet';link.type='text/css';link.href=href;document.head.appendChild(link);exports.loaded=true;}
function isLoaded(){return exports.loaded||document.querySelector('link[href*=gaia-icons]')||document.documentElement.classList.contains('gaia-icons-loaded');}});})(typeof define=='function'&&define.amd?define:(function(n,w){return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-icons',this));},{}],4:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var component=require('gaia-component');var fontFit=require('font-fit');require('gaia-icons');var debug=0?console.log.bind(console):function(){};const KNOWN_ACTIONS={menu:'menu',back:'back',close:'close'};const TITLE_FONT='italic 300 24px FiraSans';const TITLE_PADDING=10;const MINIMUM_FONT_SIZE_CENTERED=20;const MINIMUM_FONT_SIZE_UNCENTERED=18;const MAXIMUM_FONT_SIZE=23;module.exports=component.register('gaia-header',{created:function(){debug('created');this.setupShadowRoot();this.els={actionButton:this.shadowRoot.querySelector('.action-button'),buttons:this.querySelectorAll('button, a'),titles:this.querySelectorAll('h1')};this.els.actionButton.addEventListener('click',e=>this.onActionButtonClick(e));this.observer=new MutationObserver(this.onMutation.bind(this));this.titleEnd=this.getAttribute('title-end');this.titleStart=this.getAttribute('title-start');this.noFontFit=this.getAttribute('no-font-fit');this.notFlush=this.hasAttribute('not-flush');this.action=this.getAttribute('action');this.unresolved={};this.pending={};},attached:function(){debug('attached');this.runFontFitSoon();this.observerStart();},detached:function(){debug('detached');this.observerStop();this.clearPending();},clearPending:function(){for(var key in this.pending){this.pending[key].clear();delete this.pending[key];}},runFontFit:function(){debug('run font-fit');if(this.noFontFit){return Promise.resolve();}
var titles=this.els.titles;var space=this.getTitleSpace();var styles=[].map.call(titles,(el)=>this.getTitleStyle(el,space));return this.setTitleStylesSoon(styles);},runFontFitSoon:function(){debug('run font-fit soon');if(this.pending.runFontFitSoon){return;}
this.pending.runFontFitSoon=this.nextTick(()=>{delete this.pending.runFontFitSoon;this.runFontFit();});},getTitleStyle:function(el,space){debug('get el style',el,space);var text=el.textContent;var styleId=text+space.value;if(!text||!text.trim()){return false;}
if(getStyleId(el)===styleId){return false;}
var marginStart=this.getTitleMarginStart();var textSpace=space.value-Math.abs(marginStart);var fontFitResult=this.fontFit(text,textSpace,{min:MINIMUM_FONT_SIZE_CENTERED});var overflowing=fontFitResult.textWidth>textSpace;var padding={start:0,end:0};if(overflowing){debug('title overflowing');padding.start=!space.start?TITLE_PADDING:0;padding.end=!space.end?TITLE_PADDING:0;textSpace=space.value-padding.start-padding.end;fontFitResult=this.fontFit(text,textSpace);marginStart=0;}
return{id:styleId,fontSize:fontFitResult.fontSize,marginStart:marginStart,overflowing:overflowing,padding:padding};},setTitleStylesSoon:function(styles){debug('set title styles soon',styles);var key='setStyleTitlesSoon';this._titleStyles=styles;return this.unresolved[key]=this.unresolved[key]||new Promise((resolve)=>{this.pending[key]=this.nextTick(()=>{var styles=this._titleStyles;var els=this.els.titles;[].forEach.call(els,(el,i)=>{if(!styles[i]){return debug('exit');}
this.setTitleStyle(el,styles[i]);});delete this._titleStyles;delete this.unresolved[key];delete this.pending[key];resolve();});});},setTitleStyle:function(el,style){debug('set title style',style);this.observerStop();el.style.marginLeft=style.marginStart+'px';el.style.paddingLeft=style.padding.start+'px';el.style.paddingRight=style.padding.end+'px';el.style.fontSize=style.fontSize+'px';setStyleId(el,style.id);this.observerStart();},fontFit:function(text,space,opts={}){debug('font fit:',text,space,opts);var fontFitArgs={font:TITLE_FONT,min:opts.min||MINIMUM_FONT_SIZE_UNCENTERED,max:MAXIMUM_FONT_SIZE,text:text,space:space};return fontFit(fontFitArgs);},observerStart:function(){if(this.observing){return;}
this.observer.observe(this,{childList:true,attributes:true,subtree:true});this.observing=true;debug('observer started');},observerStop:function(){if(!this.observing){return;}
this.observer.disconnect();this.observing=false;debug('observer stopped');},onMutation:function(mutations){debug('on mutation',mutations);if(!this.pending.runFontFitSoon){this.runFontFit();}},getTitleSpace:function(){var start=this.titleStart;var end=this.titleEnd;var space=this.getWidth()-start-end;var result={value:space,start:start,end:end};debug('get title space',result);return result;},getWidth:function(){var value=this.notFlush?this.clientWidth:window.innerWidth;debug('get width',value);return value;},triggerAction:function(){if(this.action){this.els.actionButton.click();}},onActionButtonClick:function(){debug('action button click');var config={detail:{type:this.action}};var e=new CustomEvent('action',config);setTimeout(()=>this.dispatchEvent(e));},getTitleMarginStart:function(){var start=this.titleStart;var end=this.titleEnd;var marginStart=end-start;debug('get title margin start',marginStart);return marginStart;},getButtonsBeforeTitle:function(){var children=this.children;var l=children.length;var els=[];for(var i=0;i<l;i++){var el=children[i];if(el.tagName==='H1'){break;}
if(!isButton(el)){continue;}
els.push(el);}
if(this.action){els.push(this.els.actionButton);}
return els;},getButtonsAfterTitle:function(){var children=this.children;var els=[];for(var i=children.length-1;i>=0;i--){var el=children[i];if(el.tagName==='H1'){break;}
if(!isButton(el)){continue;}
els.push(el);}
return els;},sumButtonWidths:function(buttons){var defaultWidth=50;var sum=buttons.reduce((prev,button)=>{var isStandardButton=button===this.els.actionButton;var width=isStandardButton?defaultWidth:button.clientWidth;return prev+width;},0);debug('sum button widths',buttons,sum);return sum;},attrs:{action:{get:function(){return this._action;},set:function(value){var action=KNOWN_ACTIONS[value];if(action===this._action){return;}
this.setAttr('action',action);this._action=action;},},titleStart:{get:function(){debug('get title-start');if('_titleStart'in this){return this._titleStart;}
var buttons=this.getButtonsBeforeTitle();var value=this.sumButtonWidths(buttons);debug('get title-start',buttons,value);return value;},set:function(value){debug('set title-start',value);value=parseInt(value,10);if(value===this._titleStart||isNaN(value)){return;}
this.setAttr('title-start',value);this._titleStart=value;debug('set');}},titleEnd:{get:function(){debug('get title-end');if('_titleEnd'in this){return this._titleEnd;}
var buttons=this.getButtonsAfterTitle();return this.sumButtonWidths(buttons);},set:function(value){debug('set title-end',value);value=parseInt(value,10);if(value===this._titleEnd||isNaN(value)){return;}
this.setAttr('title-end',value);this._titleEnd=value;}},noFontFit:{get:function(){return this._noFontFit||false;},set:function(value){debug('set no-font-fit',value);value=!!(value||value==='');if(value===this.noFontFit){return;}
this._noFontFit=value;if(value){this.setAttr('no-font-fit','');}
else{this.removeAttr('no-font-fit');}}}},template:`<div class="inner">
    <button class="action-button">
      <content select=".l10n-action"></content>
    </button>
    <content select="h1,a,button"></content>
  </div>

  <style>

  :host {
    display: block;

    --gaia-header-button-color:
      var(--header-button-color,
      var(--header-color,
      var(--link-color,
      inherit)));
  }

  /**
   * [hidden]
   */

  :host[hidden] {
    display: none;
  }

  /** Reset
   ---------------------------------------------------------*/

  ::-moz-focus-inner { border: 0; }

  /** Inner
   ---------------------------------------------------------*/

  .inner {
    display: flex;
    min-height: 50px;
    direction: ltr;

    background:
      var(--header-background,
      var(--background,
      #fff));
  }

  /** Action Button
   ---------------------------------------------------------*/

  /**
   * 1. Hidden by default
   */

  .action-button {
    display: none; /* 1 */
    position: relative;
    width: 50px;
    font-size: 30px;
    margin: 0;
    padding: 0;
    border: 0;
    align-items: center;
    background: none;
    cursor: pointer;
    transition: opacity 200ms 280ms;

    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [action=back]
   * [action=menu]
   * [action=close]
   *
   * 1. For icon vertical-alignment
   */

  [action=back] .action-button,
  [action=menu] .action-button,
  [action=close] .action-button {
    display: flex; /* 1 */
  }

  /**
   * :active
   */

  .action-button:active {
    transition: none;
    opacity: 0.2;
  }

  /** Action Button Icon
   ---------------------------------------------------------*/

  .action-button:before {
    font-family: 'gaia-icons';
    font-style: normal;
    text-rendering: optimizeLegibility;
    font-weight: 500;
  }

  [action=close] .action-button:before { content: 'close' }
  [action=back] .action-button:before { content: 'back' }
  [action=menu] .action-button:before { content: 'menu' }

  /** Action Button Icon
   ---------------------------------------------------------*/

  /**
   * 1. To enable vertical alignment.
   */

  .action-button:before {
    display: block;
  }

  /** Action Button Text
   ---------------------------------------------------------*/

  /**
   * To provide custom localized content for
   * the action-button, we allow the user
   * to provide an element with the class
   * .l10n-action. This node is then
   * pulled inside the real action-button.
   *
   * Example:
   *
   *   <gaia-header action="back">
   *     <span class="l10n-action" aria-label="Back">Localized text</span>
   *     <h1>title</h1>
   *   </gaia-header>
   */

  ::content .l10n-action {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    font-size: 0;
  }

  /** Title
   ---------------------------------------------------------*/

  /**
   * 1. Vertically center text. We can't use flexbox
   *    here as it breaks text-overflow ellipsis
   *    without an inner div.
   */

  ::content h1 {
    flex: 1;
    margin: 0;
    padding: 0;
    overflow: hidden;

    white-space: nowrap;
    text-overflow: ellipsis;
    text-align: center;
    line-height: 50px; /* 1 */
    font-weight: 300;
    font-style: italic;
    font-size: 24px;
    -moz-user-select: none;

    color:
      var(--header-title-color,
      var(--header-color,
      var(--title-color,
      var(--text-color,
      inherit))));
  }

  /**
   * [dir=rtl]
   *
   * When the document is in RTL mode we still
   * want the <h1> text to be reversed to that
   * strings like '1 selected' become 'selected 1'.
   *
   * When we're happy for gaia-header to be fully
   * RTL responsive we won't need this rule anymore,
   * but this depends on all Gaia apps being ready.
   */

  :host-context([dir=rtl]) ::content h1 {
    direction: rtl;
  }

  /** Buttons
   ---------------------------------------------------------*/

  ::content a,
  ::content button {
    position: relative;
    z-index: 1;
    box-sizing: border-box;
    display: flex;
    border: none;
    width: auto;
    height: auto;
    min-width: 50px;
    margin: 0;
    padding: 0 10px;

    font-size: 14px;
    line-height: 1;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    text-align: center;
    background: none;
    border-radius: 0;
    font-style: italic;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color: var(--gaia-header-button-color);
  }

  /**
   * :active
   */

  ::content a:active,
  ::content button:active {
    transition: none;
    opacity: 0.2;
  }

  /**
   * [hidden]
   */

  ::content a[hidden],
  ::content button[hidden] {
    display: none;
  }

  /**
   * [disabled]
   */

  ::content a[disabled],
  ::content button[disabled] {
    pointer-events: none;
    color: var(--header-disabled-button-color);
  }

  /** Icon Buttons
   ---------------------------------------------------------*/

  /**
   * Icons are a different color to text
   */

  ::content .icon,
  ::content [data-icon] {
    color:
      var(--header-icon-color,
      var(--gaia-header-button-color));
  }

  /**
   * If users want their action button
   * to be in the component's light-dom
   * they can add an .action class
   * to make it look like the
   * shadow action button.
   */

  ::content .action {
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [data-icon]:empty
   *
   * Icon buttons with no textContent,
   * should always be 50px.
   *
   * This is to prevent buttons being
   * larger than they should be before
   * icon-font has loaded.
   */

  ::content [data-icon]:empty {
    width: 50px;
  }

  </style>`,nextTick:nextTick});function isButton(el){return{BUTTON:true,A:true}[el.tagName];}
function setStyleId(el,id){el._styleId=id;}
function getStyleId(el){return el._styleId;}
function nextTick(fn){var cleared;Promise.resolve().then(()=>{if(!cleared){fn();}});return{clear:function(){cleared=true;}};}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-header',this));},{"font-fit":1,"gaia-component":2,"gaia-icons":3}]},{},[4])(4)});;'use strict';(function(exports){var pref='identity.fxaccounts.reset-password.url';var fxaSettingsHelper=SettingsHelper(pref);var fxaURL;fxaSettingsHelper.get(function on_fxa_get_settings(url){fxaURL=url;});function _setAccountDetails(response){if(response&&response.user&&response.user.email){FxaModuleManager.setParam('done',true);FxaModuleManager.setParam('verified',response.user.verified);}}
function _ensureFxaClient(callback){window.parent.LazyLoader.load('../js/fxa_client.js',function(){callback&&callback();});}
var FxModuleServerRequest={checkEmail:function fxmsr_checkEmail(email,onsuccess,onerror){_ensureFxaClient(function(){window.parent.FxAccountsClient.queryAccount(email,onsuccess,onerror);});},signIn:function fxmsr_signIn(email,password,onsuccess,onerror){function successHandler(response){_setAccountDetails(response);var authenticated=(response&&response.user&&response.user.verified)||false;onsuccess&&onsuccess({authenticated:authenticated});}
function errorHandler(response){onerror&&onerror(response);}
_ensureFxaClient(function signIn(){window.parent.FxAccountsClient.signIn(email,password,successHandler,errorHandler);});},signUp:function fxmsr_signUp(email,password,onsuccess,onerror){function successHandler(response){_setAccountDetails(response);onsuccess&&onsuccess(response);}
_ensureFxaClient(function signUp(){window.parent.FxAccountsClient.signUp(email,password,successHandler,onerror);});},requestPasswordReset:function fxmsr_requestPasswordReset(email,onsuccess,onerror){var url=email?fxaURL+'?email='+email:fxaURL;var activity=new MozActivity({name:'view',data:{type:'url',url:url}});activity.onsuccess=function on_reset_success(){onsuccess&&onsuccess();FxaModuleManager.close();};activity.onerror=function on_reset_error(err){console.error(err);onerror&&onerror(err);};}};exports.FxModuleServerRequest=FxModuleServerRequest;}(window));;'use strict';var FxaModuleOverlay={init:function fxam_overlay_init(){if(this.initialized){return;}
HtmlHelper.importElements(this,'fxa-overlay','fxa-overlay-msg');this.initialized=true;},show:function fxam_overlay_show(l10nId){this.init();this.fxaOverlayMsg.setAttribute('data-l10n-id',l10nId);this.fxaOverlay.classList.add('show');},hide:function fxam_overlay_hide(){this.init();this.fxaOverlay.classList.remove('show');}};;'use strict';var FxaModuleErrorOverlay={init:function fxam_error_overlay_init(){if(this.initialized){return;}
HtmlHelper.importElements(this,'fxa-error-overlay','fxa-error-title','fxa-error-msg','fxa-error-ok');this.fxaErrorOk.addEventListener('click',this.hide.bind(this));this.fxaErrorOverlay.addEventListener('submit',this.prevent);this.initialized=true;},show:function fxam_error_overlay_show(titleL10n,messageL10n){this.init();this.fxaErrorTitle.setAttribute('data-l10n-id',titleL10n);if(typeof(messageL10n)==='object'){this.fxaErrorMsg.innerHTML=messageL10n.html;}else{this.fxaErrorMsg.setAttribute('data-l10n-id',messageL10n);}
this.fxaErrorOverlay.classList.add('show');},hide:function fxam_overlay_hide(){this.init();this.fxaErrorOverlay.classList.remove('show');},prevent:function fxam_prevent(event){event.preventDefault();event.stopPropagation();}};;'use strict';var FxaModuleNavigation={stepCount:0,currentModule:null,init:function fxam_nav_init(flow){window.addEventListener('hashchange',this.hashchangeHandler.bind(this),false);LazyLoader.load('view/view_'+flow+'.js',function loaded(){FxaModuleUI.setMaxSteps(View.length);window.location.hash=View.start.id;}.bind(this));},hashchangeHandler:function fxam_nav_hashchangeHandler(){if(!location.hash){return;}
var panel=document.querySelector(location.hash);if(!panel||!panel.classList.contains('screen')){return;}
if(this.backAnim){this.stepCount--;this.loadStep(panel,true);}else{this.stepCount++;this.loadStep(panel);}},loadStep:function fxam_nav_loadStep(panel,back){if(!panel){return;}
FxaModuleUI.loadScreen({panel:panel,count:this.stepCount,back:this.backAnim,onload:function(){this.currentModule=window[this.moduleById(panel.id)];this.currentModule.init&&this.currentModule.init(FxaModuleManager.paramsRetrieved);}.bind(this),onanimate:function(){this.backAnim=false;this.updatingStep=false;}.bind(this)});},back:function fxam_nav_back(){if(this.updatingStep){return;}
this.updatingStep=true;this.currentModule.onBack&&this.currentModule.onBack();this.backAnim=true;window.history.back();},loadNextStep:function fxam_loadNextStep(nextStep){if(!nextStep||!nextStep.id){return;}
location.hash=nextStep.id;},next:function fxam_nav_next(){this.currentModule.onNext(this.loadNextStep.bind(this));},moduleById:function fxam_nav_moduleById(id){var moduleKey=Object.keys(FxaModuleStates).filter(function(module){return FxaModuleStates[module]&&FxaModuleStates[module].id&&FxaModuleStates[module].id===id;}).pop();if(moduleKey){return FxaModuleStates[moduleKey].module;}},done:function fxam_nav_done(){this.currentModule.onDone(FxaModuleManager.done);}};;'use strict';const OFFLINE_TIMEOUT=30*1000;var FxaModuleUI={maxSteps:null,init:function(flow){HtmlHelper.importElements(this,'fxa-module-header','fxa-module-back','fxa-module-next','fxa-module-navigation','fxa-module-done','fxa-progress');this.fxaModuleHeader.addEventListener('action',function(){FxaModuleManager.close('DIALOG_CLOSED_BY_USER');});this.fxaModuleBack.addEventListener('mousedown',function(){FxaModuleNavigation.back();});this.fxaModuleNext.addEventListener('mousedown',function(){FxaModuleNavigation.next();});this.fxaModuleDone.addEventListener('click',function(){FxaModuleNavigation.done();});var offlineTimer;window.addEventListener('online',function onOnline(evt){clearTimeout(offlineTimer);FxaModule.hideErrorResponse();});window.addEventListener('offline',function onOffline(evt){if(offlineTimer){return;}
offlineTimer=setTimeout(function onOfflineTimeout(){return FxaModule.showErrorResponse({error:'OFFLINE'});},OFFLINE_TIMEOUT);});FxaModuleNavigation.init(flow);},setMaxSteps:function(num){this.maxSteps=num;},increaseMaxStepsBy:function(inc){this.maxSteps=this.maxSteps+inc;},decreaseMaxStepsBy:function(dec){this.maxSteps=this.maxSteps-dec;},loadScreen:function(params){var currentScreen=document.querySelector('.current');var nextScreen=params.panel;this.fxaProgress.style.width=(100/this.maxSteps)+'%';LazyLoader.load(nextScreen,function(){var scripts=[].slice.call(nextScreen.querySelectorAll('script')).map(function(script){return script.getAttribute('src');});LazyLoader.load(scripts,function(){if(params.count>1&&params.count<this.maxSteps){this.fxaModuleNavigation.classList.remove('navigation-single-button');this.fxaModuleNavigation.classList.remove('navigation-back-only');if(nextScreen.getAttribute('data-navigation')==='back'){this.fxaModuleNavigation.classList.add('navigation-back-only');}}else{this.fxaModuleNavigation.classList.add('navigation-single-button');if(params.count===this.maxSteps){this.fxaModuleNavigation.classList.add('navigation-done');}}
this.setProgressBar(params.count);navigator.mozL10n.once(function(){params.onload&&params.onload();if(nextScreen){this._animate(currentScreen,nextScreen,params.back,params.onanimate);}}.bind(this));}.bind(this));}.bind(this));},_animate:function(from,to,back,callback){if(!to){return;}
if(!from){to.classList.add('current');return;}
if(this._inTransition(from)||this._inTransition(to)){return;}
from.addEventListener('animationend',function fromAnimEnd(){from.removeEventListener('animationend',fromAnimEnd,false);from.classList.remove(back?'currentToRight':'currentToLeft');from.classList.remove('current');from.classList.remove('back');},false);to.addEventListener('animationend',function toAnimEnd(){to.removeEventListener('animationend',toAnimEnd,false);to.classList.remove(back?'leftToCurrent':'rightToCurrent');to.classList.add('current');callback&&callback();},false);from.classList.add(back?'currentToRight':'currentToLeft');to.classList.add(back?'leftToCurrent':'rightToCurrent');},_inTransition:function(elem){return elem.classList.contains('currentToRight')||elem.classList.contains('currentToLeft')||elem.classList.contains('rightToCurrent')||elem.classList.contains('leftToCurrent')||false;},setProgressBar:function(value){this.fxaProgress.value=100*value/this.maxSteps;this.fxaProgress.style.transform='translateX('+100*(value-1)+'%)';},setNextText:function(l10n){this.fxaModuleNext.textContent=l10n;},disableNextButton:function(){this.fxaModuleNext.setAttribute('disabled','disabled');},enableNextButton:function(){this.fxaModuleNext.removeAttribute('disabled');},disableDoneButton:function(){this.fxaModuleDone.setAttribute('disabled','disabled');},enableDoneButton:function(){this.fxaModuleDone.removeAttribute('disabled');}};;'use strict';var FxaModuleManager={paramsRetrieved:null,init:function fxamm_init(){var hash=window.location.hash.split('?');var flow=hash[0].replace('#','');if(hash.length>1){var queryParams=hash[1].split('&');for(var i=0;i<queryParams.length;i++){var param=queryParams[i].split('=');if(param.length!=2){console.warning('Wrong query parameter');continue;}
this.setParam(param[0],param[1]);}}
FxaModuleUI.init(flow);},setParam:function fxamm_setParam(key,value){if(!this.paramsRetrieved){this.paramsRetrieved={};}
this.paramsRetrieved[key]=value;},done:function fxamm_done(){window.parent.FxAccountsUI.done(FxaModuleManager.paramsRetrieved);},close:function fxamm_close(error){if(!this.paramsRetrieved||!this.paramsRetrieved.done){window.parent.FxAccountsUI.error(error);return;}
window.parent.FxAccountsUI.done(this.paramsRetrieved);}};window.addEventListener('load',function managerLoaded(){window.removeEventListener('load',managerLoaded);FxaModuleManager.init();});;'use strict';var FxaModuleStates=(function(){return{ENTER_EMAIL:{id:'fxa-email',module:'FxaModuleEnterEmail'},SET_PASSWORD:{id:'fxa-set-password',module:'FxaModuleSetPassword'},ENTER_PASSWORD:{id:'fxa-enter-password',module:'FxaModuleEnterPassword'},SIGNUP_SUCCESS:{id:'fxa-signup-success',module:'FxaModuleSignupSuccess'},SIGNIN_SUCCESS:{id:'fxa-signin-success',module:'FxaModuleSigninSuccess'},REFRESH_AUTH:{id:'fxa-refresh-auth',module:'FxaModuleRefreshAuth'},COPPA:{id:'fxa-coppa',module:'FxaModuleCoppa'},TOS:{id:'fxa-tos'},PP:{id:'fxa-pp'},DONE:null,back:function(){FxaModuleNavigation.back();},setState:function setState(state){if(!(state in this)||typeof state==='function'){return;}
document.location.hash=state.id;}};}());;'use strict';var FxaModule=(function(){var Module={initialized:false,init:function fxam_init(){},onNext:function fxam_onNext(gotoNextStepCallback){},onBack:function fxam_onBack(){},onDone:function fxam_onDone(doneCallback){doneCallback();},importElements:function fxam_importElements(){var args=[].slice.call(arguments);args.unshift(this);HtmlHelper.importElements.apply(null,args);},showErrorResponse:function fxam_showErrorResponse(response){var resp=response;if(window.location.search.indexOf('isftu')!=-1&&resp=='OFFLINE_ERROR'){resp='CONNECTION_ERROR';}
FxaModuleOverlay.hide();LazyLoader.load('js/fxam_errors.js',function(){var config=FxaModuleErrors.responseToParams(resp);FxaModuleErrorOverlay.show(config.title,config.message);});},hideErrorResponse:function fxam_hideErrorResponse(){FxaModuleErrorOverlay.hide();FxaModuleOverlay.hide();}};return Module;}());