;'use strict';(function(window){window.mozPerformance={timing:{}};function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();var epoch=Date.now();setTimeout(function(){var detail={name:name,timestamp:now,epoch:epoch};var event=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(event);});}
['moz-chrome-dom-loaded','moz-chrome-interactive','moz-app-visually-complete','moz-content-interactive','moz-app-loaded'].forEach(function(eventName){window.addEventListener(eventName,function mozPerfLoadHandler(){dispatch(eventName);},false);});window.PerformanceTestingHelper={dispatch:dispatch};})(window);;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,value,ast){var pos,v;if(value.indexOf('{{')!==-1){value=this.parseString(value);}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v===undefined?null:node.$v,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
var value;if(Array.isArray(node)){value=node;}
return{id:id,value:value||node.$v||null,index:node.$x||null,env:env,dirty:false};}
function format(args,entity){if(typeof entity==='string'){return entity;}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var val;try{val=resolveValue(args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return val;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return env['__'+id];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return args[id];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(args,env,id){var value;try{value=resolveIdentifier(args,env,id);}catch(err){return'{{ '+id+' }}';}
if(typeof value==='number'){return value;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
return value;}
return'{{ '+id+' }}';}
function interpolate(args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return prev+cur;}else if(cur.t==='idOrVar'){return prev+subPlaceable(args,env,cur.v);}},'');}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName);if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1]):undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(args,env,expr,index){if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'||!expr){return expr;}
if(Array.isArray(expr)){return interpolate(args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(args,env,expr[selector]);}}
if('other'in expr){return resolveValue(args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;(key=keys[i]);i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function replaceChars(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\}|&[#\w]+;)/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return replaceChars(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO={'qps-ploc':new Pseudo('qps-ploc','Runtime Accented',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Runtime Mirrored',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo()?this.ctx.defaultLocale:id);}
Locale.prototype.isPseudo=function(){return this.ctx.qps.indexOf(this.id)!==-1;};var bindingsIO={extra:function(id,ver,path,type,callback,errback){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo()?ctx.defaultLocale:this.id;var appVersion=null;var source='app';if(typeof(navigator)!=='undefined'){source=navigator.mozL10n._config.localeSources[this.id]||'app';appVersion=navigator.mozL10n._config.appVersion;}
for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo()?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0,node;node=ast[i];i++){this.entries[node.$i]=createEntry(node,this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.qps=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);return entity.id;}}
function formatEntity(args,entity){if(!entity.attrs){return{value:formatValue.call(this,args,entity),attrs:null};}
var formatted={value:formatValue.call(this,args,entity),attrs:Object.create(null)};for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){var supportedLocale;for(var i=0;i<requested.length;i++){var locale=requested[i];if(available.indexOf(locale)!==-1){supportedLocale=locale;break;}}
if(!supportedLocale||supportedLocale===defaultLocale){return[defaultLocale];}
return[supportedLocale,defaultLocale];}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];this.qps=Object.keys(PSEUDO);if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);var pos=this.qps.indexOf(loc);if(pos!==-1){this.qps.splice(pos,1);}}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var supported=negotiate(this.availableLocales.concat(this.qps),requested,this.defaultLocale);if(this.supportedLocales[0]!==supported[0]){freeze.call(this,supported);}};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=navigator.mozL10n.ctx.qps.indexOf(navigator.language)===-1&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(!pretranslate){initObserver();}
initResources.call(navigator.mozL10n);}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
var allowedHtmlAttrs={'ariaLabel':'aria-label','ariaValueText':'aria-valuetext','ariaMozHint':'aria-moz-hint','label':'label','placeholder':'placeholder','title':'title'};function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(!entity){return false;}
if(typeof entity.value==='string'){setTextContent.call(this,l10n.id,element,entity.value);}
for(var key in entity.attrs){var attr=entity.attrs[key];if(allowedHtmlAttrs.hasOwnProperty(key)){element.setAttribute(allowedHtmlAttrs[key],attr);}else if(key==='innerHTML'){element.innerHTML=attr;}}
return true;}
function setTextContent(id,element,text){if(element.firstElementChild){throw new L10nError('setTextContent is deprecated (https://bugzil.la/1053629). '+'Setting text content of elements with child elements is no longer '+'supported by l10n.js. Offending data-l10n-id: "'+id+'" on element '+element.outerHTML+' in '+this.ctx.id);}
element.textContent=text;}})(this);;'use strict';function enumerateAll(storages,dir,options){var storageIndex=0;var ds_cursor=null;var cursor={continue:function cursor_continue(){ds_cursor.continue();}};function onsuccess(e){cursor.result=e.target.result;if(!cursor.result){storageIndex++;if(storageIndex<storages.length){enumerateNextStorage();return;}}
if(cursor.onsuccess){try{cursor.onsuccess(e);}catch(err){console.warn('enumerateAll onsuccess threw',err);}}}
function onerror(e){cursor.error=e.target.error;if(cursor.error.name==='NotFoundError'&&storageIndex!==storages.length-1){storageIndex++;enumerateNextStorage();return;}
if(cursor.onerror){try{cursor.onerror(e);}catch(err){console.warn('enumerateAll onerror threw',err);}}}
function enumerateNextStorage(){ds_cursor=storages[storageIndex].enumerate(dir,options||{});ds_cursor.onsuccess=onsuccess;ds_cursor.onerror=onerror;}
enumerateNextStorage();return cursor;};'use strict';var MediaDB=(function(){function MediaDB(mediaType,metadataParser,options){this.mediaType=mediaType;this.metadataParser=metadataParser;if(!options){options={};}
this.indexes=options.indexes||[];this.version=options.version||1;this.mimeTypes=options.mimeTypes;this.autoscan=(options.autoscan!==undefined)?options.autoscan:true;this.state=MediaDB.OPENING;this.scanning=false;this.parsingBigFiles=false;this.updateRecord=options.updateRecord;this.reparsedRecord=options.reparsedRecord;if(options.excludeFilter&&(options.excludeFilter instanceof RegExp)){this.clientExcludeFilter=options.excludeFilter;}
this.batchHoldTime=options.batchHoldTime||100;this.batchSize=options.batchSize||0;this.dbname='MediaDB/'+this.mediaType+'/';var media=this;this.details={eventListeners:{},pendingInsertions:[],pendingDeletions:[],whenDoneProcessing:[],pendingCreateNotifications:[],pendingDeleteNotifications:[],pendingNotificationTimer:null,newestFileModTime:0};if(!this.metadataParser){this.metadataParser=function(file,callback){setTimeout(function(){callback({});},0);};}
var dbVersion=(0xFFFF&this.version)<<16|(0xFFFF&MediaDB.VERSION);var openRequest=indexedDB.open(this.dbname,dbVersion);openRequest.onerror=function(e){console.error('MediaDB():',openRequest.error.name);};openRequest.onblocked=function(e){console.error('indexedDB.open() is blocked in MediaDB()');};openRequest.onupgradeneeded=function(e){var db=openRequest.result;var transaction=e.target.transaction;var oldVersion=e.oldVersion;var oldDbVersion=0xFFFF&oldVersion;var oldClientVersion=0xFFFF&(oldVersion>>16);if(oldClientVersion===0){oldDbVersion=2;oldClientVersion=oldVersion/oldDbVersion;}
if(0===db.objectStoreNames.length){createObjectStores(db);}else{handleUpgrade(db,transaction,oldDbVersion,oldClientVersion);}};openRequest.onsuccess=function(e){media.db=openRequest.result;media.db.onerror=function(event){console.error('MediaDB: ',event.target.error&&event.target.error.name);};changeState(media,MediaDB.ENUMERABLE);var cursorRequest=media.db.transaction('files','readonly').objectStore('files').index('date').openCursor(null,'prev');cursorRequest.onerror=function(){console.error('MediaDB initialization error',cursorRequest.error);};cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){media.details.newestFileModTime=cursor.value.date;}
else{media.details.newestFileModTime=0;}
initDeviceStorage();};};function createObjectStores(db){var filestore=db.createObjectStore('files',{keyPath:'name'});filestore.createIndex('date','date');media.indexes.forEach(function(indexName){if(indexName==='name'||indexName==='date'){return;}
filestore.createIndex(indexName,indexName);});}
function enumerateOldFiles(store,callback){var openCursorReq=store.openCursor();openCursorReq.onsuccess=function(){var cursor=openCursorReq.result;if(cursor){callback(cursor.value);cursor.continue();}};}
function handleUpgrade(db,trans,oldDbVersion,oldClientVersion){media.state=MediaDB.UPGRADING;var evtDetail={'oldMediaDBVersion':oldDbVersion,'oldClientVersion':oldClientVersion,'newMediaDBVersion':MediaDB.VERSION,'newClientVersion':media.version};dispatchEvent(media,'upgrading',evtDetail);var store=trans.objectStore('files');if(media.version!=oldClientVersion){upgradeIndexesChanges(store);}
var clientUpgradeNeeded=(media.version!=oldClientVersion)&&media.updateRecord;if((2!=oldDbVersion||3!=MediaDB.VERSION)&&!clientUpgradeNeeded){return;}
enumerateOldFiles(store,function doUpgrade(dbfile){if(2==oldDbVersion&&3==MediaDB.VERSION){upgradeDBVer2to3(store,dbfile);}
if(clientUpgradeNeeded){handleClientUpgrade(store,dbfile,oldClientVersion);}});}
function upgradeIndexesChanges(store){var dbIndexes=store.indexNames;var clientIndexes=media.indexes;for(var i=0;i<dbIndexes.length;i++){if('name'===dbIndexes[i]||'date'===dbIndexes[i]){continue;}
if(clientIndexes.indexOf(dbIndexes[i])<0){store.deleteIndex(dbIndexes[i]);}}
for(i=0;i<clientIndexes.length;i++){if(!dbIndexes.contains(clientIndexes[i])){store.createIndex(clientIndexes[i],clientIndexes[i]);}}}
function upgradeDBVer2to3(store,dbfile){if(dbfile.name[0]==='/'){return;}
store.delete(dbfile.name);dbfile.name='/sdcard/'+dbfile.name;store.add(dbfile);}
function handleClientUpgrade(store,dbfile,oldClientVersion){try{dbfile.metadata=media.updateRecord(dbfile,oldClientVersion,media.version);if(dbfile.needsReparse&&!media.reparsedRecord){console.warn('client app requested reparse, but no reparsedRecord was set');delete dbfile.needsReparse;}
store.put(dbfile);}catch(ex){console.warn('client app updates record, '+dbfile.name+', failed: '+ex.message);}}
function initDeviceStorage(){var details=media.details;details.storages=navigator.getDeviceStorages(mediaType);details.availability={};getStorageAvailability();function getStorageAvailability(){var next=0;getNextAvailability();function getNextAvailability(){if(next>=details.storages.length){setupHandlers();return;}
var s=details.storages[next++];var name=s.storageName;var req=s.available();req.onsuccess=function(e){details.availability[name]=req.result;getNextAvailability();};req.onerror=function(e){details.availability[name]='unavailable';getNextAvailability();};}}
function setupHandlers(){for(var i=0;i<details.storages.length;i++){details.storages[i].addEventListener('change',changeHandler);}
details.dsEventListener=changeHandler;sendInitialEvent();}
function sendInitialEvent(){var state=getState(details.availability);changeState(media,state);if(media.autoscan){scan(media);}}
function getState(availability){var n=0;var a=0;var u=0;var s=0;for(var name in availability){n++;switch(availability[name]){case'available':a++;break;case'unavailable':u++;break;case'shared':s++;break;}}
if(s>0){return MediaDB.UNMOUNTED;}
if(u===n){return MediaDB.NOCARD;}
return MediaDB.READY;}
function changeHandler(e){switch(e.reason){case'modified':case'deleted':fileChangeHandler(e);return;case'available':case'unavailable':case'shared':volumeChangeHandler(e);return;default:return;}}
function volumeChangeHandler(e){var storageName=e.target.storageName;if(details.availability[storageName]===e.reason){return;}
var oldState=media.state;details.availability[storageName]=e.reason;var newState=getState(details.availability);if(newState!==oldState){changeState(media,newState);if(newState===MediaDB.READY){if(media.autoscan){scan(media);}}
else{endscan(media);}}
else if(newState===MediaDB.READY){if(e.reason==='available'){dispatchEvent(media,'ready');if(media.autoscan){scan(media);}}
else if(e.reason==='unavailable'){dispatchEvent(media,'cardremoved');deleteAllFiles(storageName);}}}
function fileChangeHandler(e){var filename=e.path;if(ignoreName(media,filename)){return;}
if(e.reason==='modified'){insertRecord(media,filename);}else{deleteRecord(media,filename);}}
function deleteAllFiles(storageName){var storagePrefix=storageName?'/'+storageName+'/':'';var store=media.db.transaction('files').objectStore('files');var cursorRequest=store.openCursor();cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){if(cursor.value.name.startsWith(storagePrefix)){deleteRecord(media,cursor.value.name);}
cursor.continue();}};}}}
MediaDB.prototype={close:function close(){this.db.close();for(var i=0;i<this.details.storages.length;i++){var s=this.details.storages[i];s.removeEventListener('change',this.details.dsEventListener);}
changeState(this,MediaDB.CLOSED);},addEventListener:function addEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type)){this.details.eventListeners[type]=[];}
var listeners=this.details.eventListeners[type];if(listeners.indexOf(listener)!==-1){return;}
listeners.push(listener);},removeEventListener:function removeEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type)){return;}
var listeners=this.details.eventListeners[type];var position=listeners.indexOf(listener);if(position===-1){return;}
listeners.splice(position,1);},getFileInfo:function getFile(filename,callback,errback){if(this.state===MediaDB.OPENING){throw Error('MediaDB is not ready. State: '+this.state);}
var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){var msg='MediaDB.getFileInfo: unknown filename: '+filename;if(errback){errback(msg);}else{console.error(msg);}};read.onsuccess=function(){if(callback){callback(read.result);}};},getFile:function getFile(filename,callback,errback){if(this.state!==MediaDB.READY){throw Error('MediaDB is not ready. State: '+this.state);}
var storage=navigator.getDeviceStorage(this.mediaType);var getRequest=storage.get(filename);getRequest.onsuccess=function(){callback(getRequest.result);};getRequest.onerror=function(){var errmsg=getRequest.error&&getRequest.error.name;if(errback){errback(errmsg);}else{console.error('MediaDB.getFile:',errmsg);}};},deleteFile:function deleteFile(filename){if(this.state!==MediaDB.READY){throw Error('MediaDB is not ready. State: '+this.state);}
var storage=navigator.getDeviceStorage(this.mediaType);storage.delete(filename).onerror=function(e){console.error('MediaDB.deleteFile(): Failed to delete',filename,'from DeviceStorage:',e.target.error);};},addFile:function addFile(filename,file){if(this.state!==MediaDB.READY){throw Error('MediaDB is not ready. State: '+this.state);}
var media=this;var storage=navigator.getDeviceStorage(media.mediaType);var deletereq=storage.delete(filename);deletereq.onsuccess=deletereq.onerror=save;function save(){var request=storage.addNamed(file,filename);request.onerror=function(){console.error('MediaDB: Failed to store',filename,'in DeviceStorage:',request.error);};}},updateMetadata:function(filename,metadata,callback){if(this.state===MediaDB.OPENING){throw Error('MediaDB is not ready. State: '+this.state);}
var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){console.error('MediaDB.updateMetadata called with unknown filename');};read.onsuccess=function(){var fileinfo=read.result;Object.keys(metadata).forEach(function(key){fileinfo.metadata[key]=metadata[key];});var write=media.db.transaction('files','readwrite').objectStore('files').put(fileinfo);write.onerror=function(){console.error('MediaDB.updateMetadata: database write failed',write.error&&write.error.name);};if(callback){write.onsuccess=function(){callback();};}};},count:function(key,range,callback){if(this.state!==MediaDB.READY&&this.state!==MediaDB.ENUMERABLE){throw Error('MediaDB is not ready or enumerable. State: '+this.state);}
if(arguments.length===1){callback=key;range=undefined;key=undefined;}
else if(arguments.length===2){callback=range;range=key;key=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name'){store=store.index(key);}
var countRequest=store.count(range||null);countRequest.onerror=function(){console.error('MediaDB.count() failed with',countRequest.error);};countRequest.onsuccess=function(e){callback(e.target.result);};},enumerate:function enumerate(key,range,direction,callback){if(this.state!==MediaDB.READY&&this.state!==MediaDB.ENUMERABLE){throw Error('MediaDB is not ready or enumerable. State: '+this.state);}
var handle={state:'enumerating'};if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name'){store=store.index(key);}
var cursorRequest=store.openCursor(range||null,direction||'next');cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{var fileinfo=cursor.value;if(!fileinfo.fail){callback(fileinfo);}}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}
cursor.continue();}
else{handle.state='complete';callback(null);}};return handle;},advancedEnumerate:function(key,range,direction,index,callback){if(this.state!==MediaDB.READY){throw Error('MediaDB is not ready. State: '+this.state);}
var handle={state:'enumerating'};var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name'){store=store.index(key);}
var cursorRequest=store.openCursor(range||null,direction||'next');var isTarget=false;cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(index===0){isTarget=true;}
var fileinfo=cursor.value;if(!fileinfo.fail&&isTarget){callback(cursor.value);cursor.continue();}
else{cursor.advance(index);isTarget=true;}}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}}
else{handle.state='complete';callback(null);}};return handle;},enumerateAll:function enumerateAll(key,range,direction,callback){var batch=[];if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
return this.enumerate(key,range,direction,function(fileinfo){if(fileinfo!==null){batch.push(fileinfo);}else{callback(batch);}});},cancelEnumeration:function cancelEnumeration(handle){if(handle.state==='enumerating'){handle.state='cancelling';}},getAll:function getAll(callback){if(this.state!==MediaDB.READY&&this.state!==MediaDB.ENUMERABLE){throw Error('MediaDB is not ready or enumerable. State: '+this.state);}
var store=this.db.transaction('files').objectStore('files');var request=store.mozGetAll();request.onerror=function(){console.error('MediaDB.getAll() failed with',request.error);};request.onsuccess=function(){var all=request.result;var good=all.filter(function(fileinfo){return!fileinfo.fail;});callback(good);};},scan:function(){scan(this);},freeSpace:function freeSpace(callback){if(this.state!==MediaDB.READY){throw Error('MediaDB is not ready. State: '+this.state);}
var storage=navigator.getDeviceStorage(this.mediaType);var freereq=storage.freeSpace();freereq.onsuccess=function(){callback(freereq.result);};}};MediaDB.VERSION=3;MediaDB.OPENING='opening';MediaDB.UPGRADING='upgrading';MediaDB.ENUMERABLE='enumerable';MediaDB.READY='ready';MediaDB.NOCARD='nocard';MediaDB.UNMOUNTED='unmounted';MediaDB.CLOSED='closed';function ignore(media,file){if(ignoreName(media,file.name)){return true;}
if(media.mimeTypes&&media.mimeTypes.indexOf(file.type)===-1){return true;}
return false;}
function ignoreName(media,filename){if(media.clientExcludeFilter&&media.clientExcludeFilter.test(filename)){return true;}else{var path=filename.substring(0,filename.lastIndexOf('/')+1);return(path[0]==='.'||path.indexOf('/.')!==-1);}}
function scan(media){media.scanning=true;dispatchEvent(media,'scanstart');quickScan(media.details.newestFileModTime);function quickScan(timestamp){var cursor;if(timestamp>0){media.details.firstscan=false;cursor=enumerateAll(media.details.storages,'',{since:new Date(timestamp+1)});}
else{media.details.firstscan=true;media.details.records=[];cursor=enumerateAll(media.details.storages,'');}
cursor.onsuccess=function(){if(!media.scanning){return;}
var file=cursor.result;if(file){if(!ignore(media,file)){insertRecord(media,file);}
cursor.continue();}
else{whenDoneProcessing(media,function(){sendNotifications(media);if(media.details.firstscan){endscan(media);}
else{fullScan();}});}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};}
function fullScan(){if(media.state!==MediaDB.READY){endscan(media);return;}
var dsfiles=[];var cursor=enumerateAll(media.details.storages,'');cursor.onsuccess=function(){if(!media.scanning){return;}
var file=cursor.result;if(file){if(!ignore(media,file)){dsfiles.push(file);}
cursor.continue();}
else{getDBFiles();}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};function getDBFiles(){var store=media.db.transaction('files').objectStore('files');var getAllRequest=store.mozGetAll();getAllRequest.onsuccess=function(){if(!media.scanning){return;}
var dbfiles=getAllRequest.result;compareLists(dbfiles,dsfiles);};}
function compareLists(dbfiles,dsfiles){dsfiles.sort(function(a,b){if(a.name<b.name){return-1;}else{return 1;}});var dsindex=0,dbindex=0;while(true){var dsfile;if(dsindex<dsfiles.length){dsfile=dsfiles[dsindex];}else{dsfile=null;}
var dbfile;if(dbindex<dbfiles.length){dbfile=dbfiles[dbindex];}else{dbfile=null;}
if(dsfile===null&&dbfile===null){break;}
if(dbfile===null){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile===null){deleteRecord(media,dbfile.name);dbindex++;continue;}
if(dsfile.name===dbfile.name){var lastModified=dsfile.lastModifiedDate;var timeDifference=lastModified.getTime()-dbfile.date;var sameTime=(timeDifference===0||((Math.abs(timeDifference)<=12*60*60*1000)&&(timeDifference%10*60*1000===0)));var sameSize=dsfile.size===dbfile.size;if(!sameTime||!sameSize){deleteRecord(media,dbfile.name);insertRecord(media,dsfile);}else if(dbfile.needsReparse){deleteRecord(media,dbfile.name);insertRecord(media,dsfile,dbfile.metadata);}
dsindex++;dbindex++;continue;}
if(dsfile.name<dbfile.name){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile.name>dbfile.name){deleteRecord(media,dbfile.name);dbindex++;continue;}
console.error('Assertion failed');}
insertRecord(media,null);}}}
function endscan(media){if(media.scanning){media.scanning=false;media.parsingBigFiles=false;dispatchEvent(media,'scanend');}}
function insertRecord(media,fileOrName,oldMetadata){var details=media.details;details.pendingInsertions.push([fileOrName,oldMetadata]);if(details.processingQueue){return;}
processQueue(media);}
function deleteRecord(media,filename){var details=media.details;details.pendingDeletions.push(filename);if(details.processingQueue){return;}
processQueue(media);}
function whenDoneProcessing(media,f){var details=media.details;if(details.processingQueue){details.whenDoneProcessing.push(f);}else{f();}}
function processQueue(media){var details=media.details;details.processingQueue=true;next();function next(){if(details.pendingDeletions.length>0){deleteFiles();}
else if(details.pendingInsertions.length>0){insertFile(...details.pendingInsertions.shift());}
else{details.processingQueue=false;if(details.whenDoneProcessing.length>0){var functions=details.whenDoneProcessing;details.whenDoneProcessing=[];functions.forEach(function(f){f();});}}}
function deleteFiles(){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');deleteNextFile();function deleteNextFile(){if(details.pendingDeletions.length===0){next();return;}
var filename=details.pendingDeletions.shift();var request=store.delete(filename);request.onerror=function(){console.warn('MediaDB: Unknown file in deleteRecord:',filename,getreq.error);deleteNextFile();};request.onsuccess=function(){queueDeleteNotification(media,filename);deleteNextFile();};}}
function insertFile(f,oldMetadata){if(f===null){sendNotifications(media);endscan(media);next();return;}
if(typeof f==='string'){var storage=navigator.getDeviceStorage(media.mediaType);var getreq=storage.get(f);getreq.onerror=function(){console.warn('MediaDB: Unknown file in insertRecord:',f,getreq.error);next();};getreq.onsuccess=function(){if(media.mimeTypes&&ignore(media,getreq.result)){next();}else{parseMetadata(getreq.result,f,oldMetadata);}};}
else{parseMetadata(f,f.name,oldMetadata);}}
function parseMetadata(file,filename,oldMetadata){if(!file.lastModifiedDate){console.warn('MediaDB: parseMetadata: no lastModifiedDate for',filename,'using Date.now() until #793955 is fixed');}
var fileinfo={name:filename,type:file.type,size:file.size,date:file.lastModifiedDate?file.lastModifiedDate.getTime():Date.now()};if(fileinfo.date>details.newestFileModTime){details.newestFileModTime=fileinfo.date;}
media.metadataParser(file,gotMetadata,metadataError,parsingBigFile);function parsingBigFile(){media.parsingBigFiles=true;}
function metadataError(e){console.warn('MediaDB: error parsing metadata for',filename,':',e);fileinfo.fail=true;storeRecord(fileinfo);}
function gotMetadata(metadata){fileinfo.metadata=metadata;if(oldMetadata&&media.reparsedRecord){fileinfo.metadata=media.reparsedRecord(oldMetadata,metadata);}
storeRecord(fileinfo);if(!media.scanning){media.parsingBigFiles=false;}}}
function storeRecord(fileinfo){if(media.details.firstscan){media.details.records.push(fileinfo);if(!fileinfo.fail){queueCreateNotification(media,fileinfo);}
next();}
else{var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');var request=store.add(fileinfo);request.onsuccess=function(){if(!fileinfo.fail){queueCreateNotification(media,fileinfo);}
next();};request.onerror=function(event){if(request.error.name==='ConstraintError'){event.stopPropagation();event.preventDefault();var putrequest=store.put(fileinfo);putrequest.onsuccess=function(){queueDeleteNotification(media,fileinfo.name);if(!fileinfo.fail){queueCreateNotification(media,fileinfo);}
next();};putrequest.onerror=function(){console.error('MediaDB: unexpected ConstraintError','in insertRecord for file:',fileinfo.name);next();};}
else{console.error('MediaDB: unexpected error in insertRecord:',request.error,'for file:',fileinfo.name);next();}};}}}
function queueCreateNotification(media,fileinfo){var creates=media.details.pendingCreateNotifications;creates.push(fileinfo);if(media.batchSize&&creates.length>=media.batchSize){sendNotifications(media);}else{resetNotificationTimer(media);}}
function queueDeleteNotification(media,filename){var deletes=media.details.pendingDeleteNotifications;deletes.push(filename);if(media.batchSize&&deletes.length>=media.batchSize){sendNotifications(media);}else{resetNotificationTimer(media);}}
function resetNotificationTimer(media){var details=media.details;if(details.pendingNotificationTimer){clearTimeout(details.pendingNotificationTimer);}
details.pendingNotificationTimer=setTimeout(function(){sendNotifications(media);},media.scanning?media.batchHoldTime:100);}
function sendNotifications(media){var details=media.details;if(details.pendingNotificationTimer){clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=null;}
if(details.pendingDeleteNotifications.length>0){var deletions=details.pendingDeleteNotifications;details.pendingDeleteNotifications=[];dispatchEvent(media,'deleted',deletions);}
if(details.pendingCreateNotifications.length>0){var creations=details.pendingCreateNotifications;details.pendingCreateNotifications=[];if(details.firstscan&&details.records.length>0){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');for(var i=0;i<details.records.length;i++){store.add(details.records[i]);}
details.records.length=0;transaction.oncomplete=function(){dispatchEvent(media,'created',creations);};}
else{dispatchEvent(media,'created',creations);}}}
function dispatchEvent(media,type,detail){var handler=media['on'+type];var listeners=media.details.eventListeners[type];if(!handler&&(!listeners||listeners.length===0)){return;}
var event={type:type,target:media,currentTarget:media,timestamp:Date.now(),detail:detail};if(typeof handler==='function'){try{handler.call(media,event);}
catch(e){console.warn('MediaDB: ','on'+type,'event handler threw',e,e.stack);}}
if(!listeners){return;}
for(var i=0;i<listeners.length;i++){try{var listener=listeners[i];if(typeof listener==='function'){listener.call(media,event);}
else{listener.handleEvent(event);}}
catch(e){console.warn('MediaDB: ',type,'event listener threw',e,e.stack);}}}
function changeState(media,state){if(media.state!==state){media.state=state;switch(state){case MediaDB.READY:case MediaDB.ENUMERABLE:dispatchEvent(media,state);break;default:dispatchEvent(media,'unavailable',state);break;}}}
return MediaDB;}());;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;'use strict';(function(exports){var AccessibilityHelper={setAriaSelected:function ah_setAriaSelected(selectedTab,tabs){Array.prototype.forEach.call(tabs,function setAriaSelectedAttr(tab){tab.setAttribute('aria-selected',tab===selectedTab?'true':'false');});}};exports.AccessibilityHelper=AccessibilityHelper;})(window);;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;(function(exports){'use strict';var ImageUtils=exports.ImageUtils={};const JPEG='image/jpeg';const PNG='image/png';const GIF='image/gif';const BMP='image/bmp';ImageUtils.JPEG=JPEG;ImageUtils.PNG=PNG;ImageUtils.GIF=GIF;ImageUtils.BMP=BMP;ImageUtils.getSizeAndType=function getSizeAndType(imageBlob){if(!(imageBlob instanceof Blob)){return Promise.reject(new TypeError('argument is not a Blob'));}
return new Promise(function(resolve,reject){if(imageBlob.size<=16){reject('corrupt image file');return;}
var bytesToRead=32*1024;if(imageBlob.type===PNG||imageBlob.type===GIF||imageBlob.type===BMP){bytesToRead=512;}
findSizeAndType(imageBlob,bytesToRead,success,tryagain);function success(data){resolve(data);}
function tryagain(data){if(data.type===JPEG){findSizeAndType(imageBlob,imageBlob.size,success,failure);}
else{reject(data.error);}}
function failure(data){reject(data.error);}});function findSizeAndType(imageBlob,amountToRead,success,failure){var slice=imageBlob.slice(0,Math.min(amountToRead,imageBlob.size));var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){parseImageData(reader.result);};function parseImageData(buffer){var header=new Uint8Array(buffer,0,16);var view=new DataView(buffer);if(header[0]===0x89&&header[1]===0x50&&header[2]===0x4e&&header[3]===0x47&&header[4]===0x0d&&header[5]===0x0a&&header[6]===0x1A&&header[7]===0x0a&&header[12]===0x49&&header[13]===0x48&&header[14]===0x44&&header[15]===0x52)
{try{success({type:PNG,width:view.getUint32(16,false),height:view.getUint32(20,false)});}
catch(ex){failure({error:ex.toString()});}}
else if(header[0]===0x47&&header[1]===0x49&&header[2]===0x46&&header[3]===0x38&&(header[4]===0x37||header[4]===0x39)&&header[5]===0x61)
{try{success({type:GIF,width:view.getUint16(6,true),height:view.getUint16(8,true)});}
catch(ex){failure({error:ex.toString()});}}
else if(header[0]===0x42&&header[1]===0x4D&&view.getUint32(2,true)===imageBlob.size)
{try{var width,height;if(view.getUint16(14,true)===12){width=view.getUint16(18,true);height=view.getUint16(20,true);}
else{width=view.getUint32(18,true);height=view.getUint32(22,true);}
success({type:BMP,width:width,height:height});}
catch(ex){failure({error:ex.toString()});}}
else if(header[0]===0xFF&&header[1]===0xD8){var value={type:JPEG};try{var offset=2;for(;;){if(view.getUint8(offset)!==0xFF){failure({error:'corrupt JPEG file'});}
var segmentType=view.getUint8(offset+1);var segmentSize=view.getUint16(offset+2)+2;if((segmentType>=0xC0&&segmentType<=0xC3)||(segmentType>=0xC5&&segmentType<=0xC7)||(segmentType>=0xC9&&segmentType<=0xCB)||(segmentType>=0xCD&&segmentType<=0xCF))
{value.height=view.getUint16(offset+5,false);value.width=view.getUint16(offset+7,false);success(value);break;}
offset+=segmentSize;if(offset+9>view.byteLength){value.error='corrupt JPEG file';failure(value);break;}}}
catch(ex){failure({error:ex.toString()});}}
else{failure({error:'unknown image type'});}}}};ImageUtils.resizeAndCropToCover=function(inputImageBlob,outputWidth,outputHeight,outputType,encoderOptions)
{if(!outputWidth||!isFinite(outputWidth)||outputWidth<=0||!outputHeight||!isFinite(outputHeight)||outputHeight<=0){return Promise.reject(new TypeError('invalid output dimensions'));}
outputWidth=Math.round(outputWidth);outputHeight=Math.round(outputHeight);return ImageUtils.getSizeAndType(inputImageBlob).then(function resolve(data){var inputWidth=data.width;var inputHeight=data.height;if(inputWidth===outputWidth&&inputHeight===outputHeight){return inputImageBlob;}
return resize(data);},function reject(error){return resize({});});function resize(data){var inputType=data.type;var inputWidth=data.width;var inputHeight=data.height;if(outputType&&outputType!==JPEG&&outputType!==PNG){console.warn('Ignoring unsupported outputType',outputType);outputType=undefined;}
if(!outputType){if(inputType===JPEG||inputType===PNG){outputType=inputType;}
else{outputType=PNG;}}
var url=URL.createObjectURL(inputImageBlob);var mediaFragment;if(inputType===JPEG&&inputWidth>outputWidth&&inputHeight>outputHeight){var reduction=Math.max(outputWidth/inputWidth,outputHeight/inputHeight);mediaFragment=ImageUtils.Downsample.sizeNoMoreThan(reduction);}
else{mediaFragment='';}
return new Promise(function(resolve,reject){var offscreenImage=new Image();offscreenImage.src=url+mediaFragment;offscreenImage.onerror=function(e){cleanupImage();reject('failed to decode image');};offscreenImage.onload=function(){var actualWidth=offscreenImage.width;var actualHeight=offscreenImage.height;var widthScale=outputWidth/actualWidth;var heightScale=outputHeight/actualHeight;var scale=Math.max(widthScale,heightScale);var cropWidth=Math.round(outputWidth/scale);var cropHeight=Math.round(outputHeight/scale);var cropLeft=Math.floor((actualWidth-cropWidth)/2);var cropTop=Math.floor((actualHeight-cropHeight)/2);var canvas=document.createElement('canvas');canvas.width=outputWidth;canvas.height=outputHeight;var context=canvas.getContext('2d',{willReadFrequently:true});context.drawImage(offscreenImage,cropLeft,cropTop,cropWidth,cropHeight,0,0,outputWidth,outputHeight);cleanupImage();canvas.toBlob(function(blob){canvas.width=0;resolve(blob);},outputType,encoderOptions);};function cleanupImage(){offscreenImage.onerror=offscreenImage.onload='';offscreenImage.src='';URL.revokeObjectURL(url);}});}};(function(exports){'use strict';function round(x){return Math.round(x*100)/100;}
function MozSampleSize(n,scale){return Object.freeze({dimensionScale:round(scale),areaScale:round(scale*scale),toString:function(){return'#-moz-samplesize='+n;},scale:function(x){return Math.ceil(x*scale);}});}
var NONE=Object.freeze({dimensionScale:1,areaScale:1,toString:function(){return'';},scale:function(x){return x;}});var fragments=[NONE,MozSampleSize(2,1/2),MozSampleSize(3,3/8),MozSampleSize(4,1/4),MozSampleSize(8,1/8)];function sizeAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.dimensionScale<=scale){return f;}}
return fragments[fragments.length-1];}
function sizeNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.dimensionScale>=scale){return f;}}
return NONE;}
function areaAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.areaScale<=scale){return f;}}
return fragments[fragments.length-1];}
function areaNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.areaScale>=scale){return f;}}
return NONE;}
exports.Downsample={sizeAtLeast:sizeAtLeast,sizeNoMoreThan:sizeNoMoreThan,areaAtLeast:areaAtLeast,areaNoMoreThan:areaNoMoreThan,NONE:NONE,MAX_SIZE_REDUCTION:1/fragments[fragments.length-1].dimensionScale,MAX_AREA_REDUCTION:1/fragments[fragments.length-1].areaScale};}(exports.ImageUtils));})(window);;'use strict';var Normalizer={initAsciiNormalizer:function normalizer_init(){var equivalentChars={'a':'áăǎâäȧạȁàảȃāąåḁⱥãǽǣæ','A':'ÁĂǍÂÄȦẠȀÀẢȂĀĄÅḀȺÃǼǢÆ','b':'ḃḅɓḇƀƃ','B':'ḂḄƁḆɃƂ','c':'ćčçĉċƈȼ','C':'ĆČÇĈĊƇȻ','d':'ďḑḓḋḍɗḏđƌð','D':'ĎḐḒḊḌƊḎĐƋ','e':'éĕěȩêḙëėẹȅèẻȇēę','E':'ÉĔĚȨÊḘËĖẸȄÈẺȆĒĘ','f':'ḟƒ','F':'ḞƑ','g':'ǵğǧģĝġɠḡǥ','G':'ǴĞǦĢĜĠƓḠǤ','h':'ḫȟḩĥⱨḧḣḥħ','H':'ḪȞḨĤⱧḦḢḤĦ','i':'íĭǐîïịȉìỉȋīįɨĩḭı','I':'ÍĬǏÎÏỊȈÌỈȊĪĮƗĨḬ','j':'ĵɉ','J':'ĴɈ','k':'ḱǩķⱪꝃḳƙḵꝁ','K':'ḰǨĶⱩꝂḲƘḴꝀ','l':'ĺƚľļḽḷⱡꝉḻŀɫł','L':'ĹȽĽĻḼḶⱠꝈḺĿⱢŁ','m':'ḿṁṃɱ','M':'ḾṀṂⱮ','n':'ńňņṋṅṇǹɲṉƞñ','N':'ŃŇŅṊṄṆǸƝṈȠÑ','o':'óŏǒôöȯọőȍòỏơȏꝋꝍōǫøõœ','O':'ÓŎǑÔÖȮỌŐȌÒỎƠȎꝊꝌŌǪØÕŒ','p':'ṕṗꝓƥᵽꝑ','P':'ṔṖꝒƤⱣꝐ','q':'ꝗ','Q':'Ꝗ','r':'ŕřŗṙṛȑȓṟɍɽ','R':'ŔŘŖṘṚȐȒṞɌⱤ','s':'śšşŝșṡṣß','S':'ŚŠŞŜȘṠṢ','t':'ťţṱțⱦṫṭƭṯʈŧ','T':'ŤŢṰȚȾṪṬƬṮƮŦ','u':'úŭǔûṷüṳụűȕùủưȗūųůũṵ','U':'ÚŬǓÛṶÜṲỤŰȔÙỦƯȖŪŲŮŨṴ','v':'ṿʋṽ','V':'ṾƲṼ','w':'ẃŵẅẇẉẁⱳ','W':'ẂŴẄẆẈẀⱲ','x':'ẍẋ','X':'ẌẊ','y':'ýŷÿẏỵỳƴỷỿȳɏỹ','Y':'ÝŶŸẎỴỲƳỶỾȲɎỸ','z':'źžẑⱬżẓȥẕƶ','Z':'ŹŽẐⱫŻẒȤẔƵ'};this._toAsciiForm={};for(var letter in equivalentChars){var accentedForms=equivalentChars[letter];for(var i=accentedForms.length-1;i>=0;i--){this._toAsciiForm[accentedForms[i]]=letter;}}},toAscii:function normalizer_toAscii(str){if(!str||typeof str!='string'){return'';}
if(!this._toAsciiForm){Normalizer.initAsciiNormalizer();}
var result='';for(var i=0,len=str.length;i<len;i++){result+=this._toAsciiForm[str.charAt(i)]||str.charAt(i);}
return result;},escapeHTML:function normalizer_escapeHTML(str,escapeQuotes){if(Array.isArray(str)){return Normalizer.escapeHTML(str.join(' '),escapeQuotes);}
if(!str||typeof str!='string'){return'';}
var escaped=str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');if(escapeQuotes){return escaped.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');}
return escaped;},unescapeHTML:function normalizer_unescapeHTML(text){return text.replace(/&amp;/g,'&').replace(/&lt;/g,'<').replace(/&gt;/g,'>').replace(/&quot;/g,'"').replace(/&#x27;/g,'\'');},escapeRegExp:function normalizer_escapeRegExp(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,'\\$&');}};;'use strict';var AVRCP={PLAY_PRESS:'media-play-button-press',PLAY_RELEASE:'media-play-button-release',PAUSE_PRESS:'media-pause-button-press',PAUSE_RELEASE:'media-pause-button-release',PLAY_PAUSE_PRESS:'media-play-pause-button-press',PLAY_PAUSE_RELEASE:'media-play-pause-button-release',STOP_PRESS:'media-stop-button-press',STOP_RELEASE:'media-stop-button-release',NEXT_PRESS:'media-next-track-button-press',NEXT_RELEASE:'media-next-track-button-release',PREVIOUS_PRESS:'media-previous-track-button-press',PREVIOUS_RELEASE:'media-previous-track-button-release',FAST_FORWARD_PRESS:'media-fast-forward-button-press',FAST_FORWARD_RELEASE:'media-fast-forward-button-release',REWIND_PRESS:'media-rewind-button-press',REWIND_RELEASE:'media-rewind-button-release'};var IAC={PLAY_PRESS:'play',PLAY_PAUSE_PRESS:'playpause',PAUSE_PRESS:'pause',STOP_PRESS:'stop',NEXT_PRESS:'nexttrack',PREVIOUS_PRESS:'prevtrack',FAST_FORWARD_PRESS:'fastforwardstart',FAST_FORWARD_RELEASE:'fastforwardend',REWIND_PRESS:'rewindstart',REWIND_RELEASE:'rewindend'};var REMOTE_CONTROLS={PLAY:'play',PLAY_PAUSE:'playpause',PAUSE:'pause',STOP:'stop',NEXT:'next',PREVIOUS:'previous',SEEK_PRESS:'seekpress',SEEK_RELEASE:'seekrelease',UPDATE_METADATA:'updatemetadata',UPDATE_PLAYSTATUS:'updateplaystatus'};function MediaRemoteControls(){this.bluetooth=navigator.mozBluetooth;this.defaultAdapter=null;this._commandListeners={};this._isSCOConnected=false;for(var command in REMOTE_CONTROLS){this._commandListeners[REMOTE_CONTROLS[command]]=[];}}
MediaRemoteControls.prototype.addCommandListener=function(command,listener){if(this._commandListeners[command]){this._commandListeners[command].push(listener);}};MediaRemoteControls.prototype.removeCommandListener=function(name,listener){if(this._commandListeners[name]){var index=-1;this._commandListeners[name].forEach(function(currListener,i){if(currListener===listener){index=i;}});if(index!==-1){this._commandListeners[name].splice(index,1);}}};MediaRemoteControls.prototype.start=function(callback){this._setupBluetooth(callback);this._setupIAC();};MediaRemoteControls.prototype._setupBluetooth=function(callback){var self=this;navigator.mozSetMessageHandler('media-button',this._commandHandler.bind(this));if(this.bluetooth){this.bluetooth.onadapteradded=initialDefaultAdapter;this.bluetooth.ondisabled=resetDefaultAdapter;initialDefaultAdapter();}else{console.warn('No mozBluetooth');}
function initialDefaultAdapter(){var request=self.bluetooth.getDefaultAdapter();request.onsuccess=configureAdapter;request.onerror=resetDefaultAdapter;}
function configureAdapter(event){self.defaultAdapter=event.target.result;self.defaultAdapter.onrequestmediaplaystatus=playstatusHandler;self.defaultAdapter.ona2dpstatuschanged=a2dpConnectionHandler;self.defaultAdapter.onscostatuschanged=scoConnectionHandler;if(callback){callback();}}
function playstatusHandler(){if(self._commandListeners.updateplaystatus.length>0){self._commandHandler(REMOTE_CONTROLS.UPDATE_PLAYSTATUS);}}
function a2dpConnectionHandler(event){var isConnected=event.status;if(isConnected&&self._commandListeners.updatemetadata.length>0){self._commandHandler(REMOTE_CONTROLS.UPDATE_METADATA);}}
function scoConnectionHandler(event){self._isSCOConnected=event.status;if(self._isSCOConnected){self._commandHandler(AVRCP.PAUSE_PRESS);}
else{self._commandHandler(AVRCP.PLAY_PRESS);}}
function resetDefaultAdapter(){self.defaultAdapter=null;}};MediaRemoteControls.prototype._setupIAC=function(){var self=this;this._queuedMessages=[];navigator.mozApps.getSelf().onsuccess=function(){var app=this.result;if(!app.connect){this._queuedMessages=null;return;}
app.connect('mediacomms').then(function(ports){self._ports=ports;self._ports.forEach(function(port){port.onmessage=function(event){self._commandHandler(event.data.command);};self._queuedMessages.forEach(function(message){port.postMessage(message);});});self._queuedMessages=null;});};};MediaRemoteControls.prototype.getSCOStatus=function(callback){if(this.defaultAdapter){var request=this.defaultAdapter.isScoConnected();request.onsuccess=function(event){callback(event.target.result);};request.onerror=function(event){callback(false);};}else{callback(false);}};MediaRemoteControls.prototype._postMessage=function(name,value){var message={type:name,data:value};if(!this._ports){if(this._queuedMessages){this._queuedMessages.push(message);}}else{this._ports.forEach(function(port){port.postMessage(message);});}};MediaRemoteControls.prototype._commandHandler=function(message){var type='remote';var option={};switch(message){case AVRCP.PLAY_PRESS:case IAC.PLAY_PRESS:option.detail={command:REMOTE_CONTROLS.PLAY,isSCOConnected:this._isSCOConnected};break;case AVRCP.PLAY_PAUSE_PRESS:case IAC.PLAY_PAUSE_PRESS:option.detail={command:REMOTE_CONTROLS.PLAY_PAUSE,isSCOConnected:this._isSCOConnected};break;case AVRCP.PAUSE_PRESS:case IAC.PAUSE_PRESS:option.detail={command:REMOTE_CONTROLS.PAUSE,isSCOConnected:this._isSCOConnected};break;case AVRCP.STOP_PRESS:case IAC.STOP_PRESS:option.detail={command:REMOTE_CONTROLS.STOP};break;case AVRCP.NEXT_PRESS:case IAC.NEXT_PRESS:option.detail={command:REMOTE_CONTROLS.NEXT};break;case AVRCP.PREVIOUS_PRESS:case IAC.PREVIOUS_PRESS:option.detail={command:REMOTE_CONTROLS.PREVIOUS};break;case AVRCP.FAST_FORWARD_PRESS:case IAC.FAST_FORWARD_PRESS:option.detail={command:REMOTE_CONTROLS.SEEK_PRESS,direction:1};break;case AVRCP.REWIND_PRESS:case IAC.REWIND_PRESS:option.detail={command:REMOTE_CONTROLS.SEEK_PRESS,direction:-1};break;case AVRCP.FAST_FORWARD_RELEASE:case IAC.FAST_FORWARD_RELEASE:case AVRCP.REWIND_RELEASE:case IAC.REWIND_RELEASE:option.detail={command:REMOTE_CONTROLS.SEEK_RELEASE};break;case REMOTE_CONTROLS.UPDATE_METADATA:case REMOTE_CONTROLS.UPDATE_PLAYSTATUS:option.detail={command:message};break;default:return;}
var event=new CustomEvent(type,option);this._executeCommandListeners(event);};MediaRemoteControls.prototype._executeCommandListeners=function(event){if(!event.detail){return;}
this._commandListeners[event.detail.command].forEach(function(listener){listener(event);});};MediaRemoteControls.prototype.notifyAppInfo=function(info){this._postMessage('appinfo',info);};MediaRemoteControls.prototype.notifyMetadataChanged=function(metadata){if(this.defaultAdapter){var request=this.defaultAdapter.sendMediaMetaData(metadata);request.onerror=function(){console.log('Sending Metadata error');};}
this._postMessage('nowplaying',metadata);};MediaRemoteControls.prototype.notifyStatusChanged=function(status){if(this.defaultAdapter){if(status==='mozinterruptbegin'){return;}
var request=this.defaultAdapter.sendMediaPlayStatus(status);request.onerror=function(){console.log('Sending Playstatus error');};}
this._postMessage('status',status);};;'use strict';(function(exports){if(exports.ForwardLock){return;}
const mimeSubtype='vnd.mozilla.oma.drm.fl';const SECRET_SETTINGS_ID='oma.drm.forward_lock.secret.key';var secret=null;function xor(buffer,key){var words=new Uint32Array(buffer,0,buffer.byteLength>>2);for(var i=0,n=words.length;i<n;i++){words[i]^=key;}}
function lockBuffer(secret,content,type,metadata){var header='LOCKED 1 '+escape(type)+'\n';if(metadata){for(var p in metadata){header+=escape(p)+':'+escape(metadata[p])+'\n';}}
header+='\0';var buffer=new Uint8Array(new Uint8Array(content)).buffer;xor(buffer,secret);return new Blob([header,buffer],{type:type.split('/')[0]+'/'+mimeSubtype});}
function lockBlob(secret,blob,metadata,callback){var reader=new FileReader();reader.readAsArrayBuffer(blob);reader.onload=function(){callback(lockBuffer(secret,reader.result,blob.type,metadata));};}
function unlockBlob(secret,blob,callback,errorCallback){if(!secret){return error('no secret supplied');}
var reader=new FileReader();reader.readAsArrayBuffer(blob);reader.onload=function(){var buffer=reader.result;var bytes=new Uint8Array(buffer);var header='';var contentStart;for(var i=0;i<bytes.length;i++){if(bytes[i]===0){contentStart=i+1;break;}
header+=String.fromCharCode(bytes[i]);}
if(!header.startsWith('LOCKED')){return error('Bad magic number');}
if(header.substring(6,9)!==' 1 '){return error('Unsupported version number');}
if(!contentStart){return error('No content');}
var eol=header.indexOf('\n');if(eol===-1){return error('malformed header');}
var type=unescape(header.substring(9,eol).trim());var metadata={};var lines=header.substring(eol+1).split('\n');for(var j=0;j<lines.length;j++){var line=lines[j];if(!line){continue;}
var[key,value]=line.split(':');if(!key||!value){return error('malformed metadata');}
metadata[unescape(key)]=unescape(value);}
var content=buffer.slice(contentStart);xor(content,secret);var blob=new Blob([content],{type:type});try{callback(blob,metadata);}
catch(e){console.error('Exception in content callback',e);}};function error(msg){msg='LCKA.decrypt(): '+msg;if(errorCallback){try{errorCallback(msg);}
catch(e){console.error('Exception in error callback',e);}}
else{console.error(msg);}}}
function getKey(callback){try{if(secret!==null){report(secret);return;}
var lock=navigator.mozSettings.createLock();var getreq=lock.get(SECRET_SETTINGS_ID);getreq.onsuccess=function(){secret=getreq.result[SECRET_SETTINGS_ID]||null;report(secret);};getreq.onerror=function(){console.error('Error getting ForwardLock setting',getreq.error);report(null);};}
catch(e){console.error('Exception in ForwardLock.getKey():',e);report(null);}
function report(secret){if(callback){try{callback(secret);}
catch(e){console.error('Exception in ForwardLock.getKey() callback',e);}}}}
function getOrCreateKey(callback){getKey(function(key){if(key!==null){report(key);return;}
secret=((Math.random()*0xFFFFFFFF)|0)+1;var setting={};setting[SECRET_SETTINGS_ID]=secret;var setreq=navigator.mozSettings.createLock().set(setting);setreq.onsuccess=function(){report(secret);};setreq.onerror=function(){console.error('Failed to set key in ForwardLock.getOrCreateKey()',setreq.error.name);secret=null;};});function report(secret){if(callback){try{callback(secret);}
catch(e){console.error('Exception in ForwardLock.getOrCreateKey() callback');}}}}
exports.ForwardLock={lockBuffer:lockBuffer,lockBlob:lockBlob,unlockBlob:unlockBlob,mimeSubtype:mimeSubtype,getKey:getKey,getOrCreateKey:getOrCreateKey};}(window));;(function ScrollDetector(){'use strict';var scrollTimeout=null;const IDLE_TIME=400;var isScrolling=false;function handleScroll(e){if(!isScrolling){dispatchScrollStart();}
if(scrollTimeout){window.clearTimeout(scrollTimeout);}
scrollTimeout=window.setTimeout(dispatchScrollEnd,IDLE_TIME);}
function dispatchScrollStart(){isScrolling=true;dispatchCustomScrollEvent();}
function dispatchScrollEnd(){isScrolling=false;dispatchCustomScrollEvent();}
function dispatchCustomScrollEvent(){var eventName=isScrolling?'scrollstart':'scrollend';window.dispatchEvent(new CustomEvent(eventName));}
window.addEventListener('mozbrowserasyncscroll',handleScroll,true);window.addEventListener('scroll',handleScroll,true);})();;(function(exports){'use strict';exports.ComponentUtils={style:function(baseUrl){var style=document.createElement('style');var url=baseUrl+'style.css';var self=this;style.setAttribute('scoped','');style.innerHTML='@import url('+url+');';this.appendChild(style);this.style.visibility='hidden';style.addEventListener('load',function(){if(self.shadowRoot){self.shadowRoot.appendChild(style.cloneNode(true));}
self.style.visibility='';});}};}(window));;'use strict';window.GaiaSubheader=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaSubheaderBaseurl||'/shared/elements/gaia_subheader/';proto.createdCallback=function(){ComponentUtils.style.call(this,baseurl);};return document.registerElement('gaia-subheader',{prototype:proto});})(window);;!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.GaiaHeader=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var textContent=Object.getOwnPropertyDescriptor(Node.prototype,'textContent');var removeAttribute=HTMLElement.prototype.removeAttribute;var setAttribute=HTMLElement.prototype.setAttribute;var noop=function(){};var hasShadowCSS=(function(){var div=document.createElement('div');try{div.querySelector(':host');return true;}
catch(e){return false;}})();module.exports.register=function(name,props){injectGlobalCss(props.globalCss);delete props.globalCSS;var proto=Object.assign(Object.create(base),props);var output=extractLightDomCSS(proto.template,name);var _attrs=Object.assign(props.attrs||{},attrs);proto.template=output.template;proto.lightCss=output.lightCss;Object.defineProperties(proto,_attrs);var El=document.registerElement(name,{prototype:proto});return El;};var base=Object.assign(Object.create(HTMLElement.prototype),{attributeChanged:noop,attached:noop,detached:noop,created:noop,template:'',createdCallback:function(){this.injectLightCss(this);this.created();},attributeChangedCallback:function(name,from,to){if(this.attrs&&this.attrs[name]){this[name]=to;}
this.attributeChanged(name,from,to);},attachedCallback:function(){this.attached();},detachedCallback:function(){this.detached();},setAttr:function(name,value){var internal=this.shadowRoot.firstElementChild;setAttribute.call(internal,name,value);setAttribute.call(this,name,value);},removeAttr:function(){var internal=this.shadowRoot.firstElementChild;removeAttribute.call(internal,name,value);removeAttribute.call(this,name,value);},injectLightCss:function(el){if(hasShadowCSS){return;}
this.lightStyle=document.createElement('style');this.lightStyle.setAttribute('scoped','');this.lightStyle.innerHTML=el.lightCss;el.appendChild(this.lightStyle);}});var attrs={textContent:{set:function(value){var node=firstChildTextNode(this);if(node){node.nodeValue=value;}},get:function(){var node=firstChildTextNode(this);return node&&node.nodeValue;}}};function firstChildTextNode(el){for(var i=0;i<el.childNodes.length;i++){var node=el.childNodes[i];if(node&&node.nodeType===3){return node;}}}
function extractLightDomCSS(template,name){var regex=/(?::host|::content)[^{]*\{[^}]*\}/g;var lightCss='';if(!hasShadowCSS){template=template.replace(regex,function(match){lightCss+=match.replace(/::content|:host/g,name);return'';});}
return{template:template,lightCss:lightCss};}
function injectGlobalCss(css){if(!css)return;var style=document.createElement('style');style.innerHTML=css;document.head.appendChild(style);}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-component',this));},{}],2:[function(require,module,exports){(function(define){define(function(require,exports,module){var base=window.GAIA_ICONS_BASE_URL||window.COMPONENTS_BASE_URL||'bower_components/';if(!isLoaded()){load(base+'gaia-icons/gaia-icons.css');}
function load(href){var link=document.createElement('link');link.rel='stylesheet';link.type='text/css';link.href=href;document.head.appendChild(link);exports.loaded=true;}
function isLoaded(){return exports.loaded||document.querySelector('link[href*=gaia-icons]')||document.documentElement.classList.contains('gaia-icons-loaded');}});})(typeof define=='function'&&define.amd?define:(function(n,w){return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-icons',this));},{}],3:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var Component=require('gaia-component');var fontFit=require('./lib/font-fit');require('gaia-icons');var actionTypes={menu:1,back:1,close:1};module.exports=Component.register('gaia-header',{created:function(){this.createShadowRoot().innerHTML=this.template;this.els={actionButton:this.shadowRoot.querySelector('.action-button'),headings:this.querySelectorAll('h1,h2,h3,h4'),inner:this.shadowRoot.querySelector('.inner')};this.els.actionButton.addEventListener('click',e=>this.onActionButtonClick(e));this.configureActionButton();this.runFontFit();},attached:function(){this.rerunFontFit();},attributeChanged:function(attr){if(attr==='action'){this.configureActionButton();this.rerunFontFit();}},runFontFit:function(){for(var i=0;i<this.els.headings.length;i++){fontFit.reformatHeading(this.els.headings[i]);fontFit.observeHeadingChanges(this.els.headings[i]);}},rerunFontFit:function(){for(var i=0;i<this.els.headings.length;i++){fontFit.reformatHeading(this.els.headings[i]);}},triggerAction:function(){if(this.isSupportedAction(this.getAttribute('action'))){this.els.actionButton.click();}},configureActionButton:function(){var old=this.els.actionButton.getAttribute('icon');var type=this.getAttribute('action');var supported=this.isSupportedAction(type);this.els.actionButton.classList.remove('icon-'+old);this.els.actionButton.setAttribute('icon',type);this.els.inner.classList.toggle('supported-action',supported);if(supported){this.els.actionButton.classList.add('icon-'+type);}},isSupportedAction:function(action){return action&&actionTypes[action];},onActionButtonClick:function(e){var config={detail:{type:this.getAttribute('action')}};var actionEvent=new CustomEvent('action',config);setTimeout(this.dispatchEvent.bind(this,actionEvent));},template:`
  <style>

  :host {
    display: block;

    --gaia-header-button-color:
      var(--header-button-color,
      var(--header-color,
      var(--link-color,
      inherit)));
  }

  /**
   * [hidden]
   */

  :host[hidden] {
    display: none;
  }

  /** Reset
   ---------------------------------------------------------*/

  ::-moz-focus-inner { border: 0; }

  /** Inner
   ---------------------------------------------------------*/

  .inner {
    display: flex;
    min-height: 50px;
    direction: ltr;

    background:
      var(--header-background,
      var(--background,
      #fff));
  }

  /** Action Button
   ---------------------------------------------------------*/

  /**
   * 1. Hidden by default
   */

  .action-button {
    display: none; /* 1 */
    position: relative;
    width: 50px;
    font-size: 30px;
    margin: 0;
    padding: 0;
    border: 0;
    align-items: center;
    background: none;
    cursor: pointer;
    transition: opacity 200ms 280ms;

    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * .action-supported
   *
   * 1. For icon vertical-alignment
   */

  .supported-action .action-button {
    display: flex; /* 1 */
  }

  /**
   * :active
   */

  .action-button:active {
    transition: none;
    opacity: 0.2;
  }

  /** Action Button Icon
   ---------------------------------------------------------*/

  /**
   * 1. To enable vertical alignment.
   */

  .action-button:before {
    display: block;
  }

  /** Action Button Text
   ---------------------------------------------------------*/

  /**
   * To provide custom localized content for
   * the action-button, we allow the user
   * to provide an element with the class
   * .l10n-action. This node is then
   * pulled inside the real action-button.
   *
   * Example:
   *
   *   <gaia-header action="back">
   *     <span class="l10n-action" aria-label="Back">Localized text</span>
   *     <h1>title</h1>
   *   </gaia-header>
   */

  ::content .l10n-action {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    font-size: 0;
  }

  /** Title
   ---------------------------------------------------------*/

  /**
   * 1. Vertically center text. We can't use flexbox
   *    here as it breaks text-overflow ellipsis
   *    without an inner div.
   */

  ::content h1 {
    flex: 1;
    margin: 0;
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
    text-align: center;
    line-height: 50px; /* 1 */
    font-weight: 300;
    font-style: italic;
    font-size: 24px;
    -moz-user-select: none;

    color:
      var(--header-title-color,
      var(--header-color,
      var(--title-color,
      var(--text-color,
      inherit))));
  }

  /**
   * .flush-left
   *
   * When the fitted text is flush with the
   * edge of the left edge of the container
   * we pad it in a bit.
   */

  ::content h1.flush-left {
    padding-left: 10px;
  }

  /**
   * .flush-right
   *
   * When the fitted text is flush with the
   * edge of the right edge of the container
   * we pad it in a bit.
   */

  ::content h1.flush-right {
    padding-right: 10px; /* 1 */
  }

  /** Buttons
   ---------------------------------------------------------*/

  ::content a,
  ::content button {
    box-sizing: border-box;
    display: flex;
    border: none;
    width: auto;
    height: auto;
    margin: 0;
    padding: 0 10px;
    font-size: 14px;
    line-height: 1;
    min-width: 50px;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    text-align: center;
    background: none;
    border-radius: 0;
    font-style: italic;
    cursor: pointer;

    transition: opacity 200ms 280ms;

    color:
      var(--gaia-header-button-color);
  }

  /**
   * :active
   */

  ::content a:active,
  ::content button:active {
    transition: none;
    opacity: 0.2;
  }

  /**
   * [hidden]
   */

  ::content a[hidden],
  ::content button[hidden] {
    display: none;
  }

  /**
   * [disabled]
   */

  ::content a[disabled],
  ::content button[disabled] {
    pointer-events: none;
    color: var(--header-disabled-button-color);
  }

  /** Icon Buttons
   ---------------------------------------------------------*/

  /**
   * Icons are a different color to text
   */

  ::content .icon,
  ::content [data-icon] {
    color:
      var(--header-icon-color,
      var(--gaia-header-button-color));
  }

  /** Icons
   ---------------------------------------------------------*/

  [class^="icon-"]:before,
  [class*="icon-"]:before {
    font-family: 'gaia-icons';
    font-style: normal;
    text-rendering: optimizeLegibility;
    font-weight: 500;
  }

  .icon-menu:before { content: 'menu'; }
  .icon-close:before { content: 'close'; }
  .icon-back:before { content: 'back'; }

  </style>

  <div class="inner">
    <button class="action-button">
      <content select=".l10n-action"></content>
    </button>
    <content select="h1,h2,h3,h4,a,button"></content>
  </div>`});});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-header',this));},{"./lib/font-fit":4,"gaia-component":1,"gaia-icons":2}],4:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var GaiaHeaderFontFit={_HEADER_SIZES:[16,17,18,19,20,21,22,23,24],observeHeadingChanges:function(heading){var observer=this._getTextChangeObserver();observer.observe(heading,{childList:true});},reformatHeading:function(heading){if(!heading||heading.textContent.trim()===''){return;}
this._resetCentering(heading);var style=this._getStyleProperties(heading);if(!style){return;}
style.textWidth=this._autoResizeElement(heading,style);this._centerTextToScreen(heading,style);},resetCache:function(){this._cachedContexts={};},_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},_textChangeObserver:null,_handleTextChanges:function(mutations){var targets=new Set();for(var i=0;i<mutations.length;i++){targets.add(mutations[i].target);}
for(var target of targets){this.reformatHeading(target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},_getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this._getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},_getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},_getStyleProperties:function(heading){var style=getComputedStyle(heading)||{};var contentWidth=this._getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily||'unknown',contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:heading.offsetLeft};},_autoResizeElement:function(heading,styleOptions){var contentWidth=styleOptions.contentWidth||this._getContentWidth(heading);var fontFamily=styleOptions.fontFamily||getComputedStyle(heading).fontFamily;var text=heading.textContent.replace(/\s+/g,' ').trim();var info=this._getMaxFontSizeInfo(text,this._HEADER_SIZES,fontFamily,contentWidth);heading.style.fontSize=info.fontSize+'px';return info.textWidth;},_resetCentering:function(heading){heading.style.marginLeft=heading.style.marginRight='0';},_centerTextToScreen:function(heading,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var tightText=styleOptions.textWidth>(styleOptions.contentWidth-30);var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this._getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;heading.classList.toggle('flush-left',tightText&&!sideSpaceLeft);heading.classList.toggle('flush-right',tightText&&!sideSpaceRight);if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this._getWindowWidth()-1){if(sideSpaceLeft<sideSpaceRight){heading.style.marginLeft=(sideSpaceRight-sideSpaceLeft)+'px';}
if(sideSpaceRight<sideSpaceLeft){heading.style.marginRight=(sideSpaceLeft-sideSpaceRight)+'px';}}},_getWindowWidth:function(){return window.innerWidth;}};module.exports=GaiaHeaderFontFit;});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('./lib/font-fit',this));},{}]},{},[3])(3)});;'use strict';function formatTime(secs){if(isNaN(secs)){return;}
secs=Math.floor(secs);var formatedTime;var seconds=secs%60;var minutes=Math.floor(secs/60)%60;var hours=Math.floor(secs/3600);if(hours===0){formatedTime=(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}else{formatedTime=(hours<10?'0'+hours:hours)+':'+
(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}
return formatedTime;}
function createListElement(option,data,index,highlight){var li=document.createElement('li');li.className='list-item';li.setAttribute('role','presentation');var a=document.createElement('a');a.dataset.index=index;a.dataset.option=option;a.setAttribute('role','option');var titleSpan;li.appendChild(a);function highlightText(result,text){var textContent=result.textContent;var textLowerCased=textContent.toLocaleLowerCase();var index=Normalizer.toAscii(textLowerCased).indexOf(text);if(index>=0){var innerHTML=textContent.substring(0,index)+'<span class="search-highlight">'+
textContent.substring(index,index+text.length)+'</span>'+
textContent.substring(index+text.length);result.innerHTML=innerHTML;}}
switch(option){case'playlist':titleSpan=document.createElement('span');titleSpan.className='list-playlist-title';if(data.metadata.l10nId){titleSpan.textContent=navigator.mozL10n.get(data.metadata.l10nId);titleSpan.dataset.l10nId=data.metadata.l10nId;}else{titleSpan.textContent=data.metadata.title||navigator.mozL10n.get('unknownTitle');titleSpan.dataset.l10nId=data.metadata.title?'':'unknownTitle';}
a.dataset.keyRange='all';a.dataset.option=data.option;a.appendChild(titleSpan);if(index===0){var shuffleIcon=document.createElement('div');shuffleIcon.className='list-playlist-icon';shuffleIcon.dataset.icon='shuffle';a.appendChild(shuffleIcon);}
break;case'artist':case'album':case'title':var artistSpan;AlbumArtCache.getCoverURL(data).then(function(url){li.style.backgroundImage='url('+url+')';});if(option==='artist'){artistSpan=document.createElement('span');artistSpan.className='list-single-title';artistSpan.textContent=data.metadata.artist||navigator.mozL10n.get('unknownArtist');artistSpan.dataset.l10nId=data.metadata.artist?'':'unknownArtist';if(highlight){highlightText(artistSpan,highlight);}
a.appendChild(artistSpan);}else{var albumOrTitleSpan=document.createElement('span');artistSpan=document.createElement('span');albumOrTitleSpan.className='list-main-title';artistSpan.className='list-sub-title';if(option==='album'){albumOrTitleSpan.textContent=data.metadata.album||navigator.mozL10n.get('unknownAlbum');albumOrTitleSpan.dataset.l10nId=data.metadata.album?'':'unknownAlbum';}else{albumOrTitleSpan.textContent=data.metadata.title||navigator.mozL10n.get('unknownTitle');albumOrTitleSpan.dataset.l10nId=data.metadata.title?'':'unknownTitle';}
artistSpan.textContent=data.metadata.artist||navigator.mozL10n.get('unknownArtist');artistSpan.dataset.l10nId=data.metadata.artist?'':'unknownArtist';if(highlight){highlightText(albumOrTitleSpan,highlight);}
a.appendChild(albumOrTitleSpan);a.appendChild(artistSpan);}
a.dataset.keyRange=data.metadata[option];a.dataset.option=option;break;case'song':case'song-index':var songTitle=data.metadata.title||navigator.mozL10n.get('unknownTitle');var indexSpan=document.createElement('span');indexSpan.className='list-song-index';if(option==='song-index'){indexSpan.textContent=index+1;}else{var trackNum=data.metadata.tracknum;if(data.metadata.discnum&&data.multidisc){trackNum=data.metadata.discnum+'.'+
(trackNum<10?'0'+trackNum:trackNum);}
indexSpan.textContent=trackNum;}
titleSpan=document.createElement('span');titleSpan.className='list-song-title';titleSpan.textContent=songTitle;titleSpan.dataset.l10nId=data.metadata.title?'':'unknownTitle';var lengthSpan=document.createElement('span');lengthSpan.className='list-song-length';a.appendChild(indexSpan);a.appendChild(titleSpan);a.appendChild(lengthSpan);break;}
return li;};'use strict';var SETTINGS_OPTION_KEY='settings_option_key';var App=(function(){var app;var chromeInteractive=false;init();function init(){navigator.mozL10n.once(function onLocalizationInit(){window.performance.mark('navigationLoaded');window.dispatchEvent(new CustomEvent('moz-chrome-dom-loaded'));initDB();TitleBar.init();TilesView.init();ListView.init();SubListView.init();SearchView.init();TabBar.init();setStartMode();navigator.mozL10n.ready(function(){ModeManager.updateTitle();if(!chromeInteractive){chromeInteractive=true;window.performance.mark('navigationInteractive');window.dispatchEvent(new CustomEvent('moz-chrome-interactive'));}});});window.addEventListener('scrollstart',function onScroll(e){var views=document.getElementById('views');views.classList.add('scrolling');});window.addEventListener('scrollend',function onScroll(e){var views=document.getElementById('views');views.classList.remove('scrolling');});}
function setStartMode(){if(document.URL.indexOf('#pick')!==-1){navigator.mozSetMessageHandler('activity',function activityHandler(a){var activityName=a.source.name;if(activityName==='pick'){app.pendingPick=a;}});TabBar.option='title';ModeManager.start(MODE_PICKER);}else{TabBar.option='mix';ModeManager.start(MODE_TILES);asyncStorage.getItem(SETTINGS_OPTION_KEY,function(settings){app.playerSettings=settings;});var doneButton=document.getElementById('title-done');doneButton.parentNode.removeChild(doneButton);}}
function showOverlay(id){app.currentOverlay=id;function setVisibility(visible){Array.forEach(document.body.children,function(elt){if(elt.id==='overlay'){elt.classList.toggle('hidden',!visible);}else{elt.setAttribute('aria-hidden',visible);}});}
if(id===null){setVisibility(false);return;}
var menu=document.getElementById('overlay-menu');if(app.pendingPick){menu.classList.remove('hidden');}else{menu.classList.add('hidden');}
var l10nIds={'title':id+'-title','text':id+'-text'};if(id==='nocard'){l10nIds.title='nocard2-title';l10nIds.text='nocard3-text';}
var titleElement=document.getElementById('overlay-title');var textElement=document.getElementById('overlay-text');titleElement.dataset.l10nId=l10nIds.title;textElement.dataset.l10nId=l10nIds.text;setVisibility(true);}
function showCorrectOverlay(){if(app.knownSongs.length>0){if(app.currentOverlay==='empty'||app.currentOverlay==='upgrade'){app.showOverlay(null);}}else if(reparsingMetadata){app.showOverlay('upgrade');}else{app.showOverlay('empty');}}
function showCurrentView(callback){LazyLoader.load('js/metadata/album_art_cache.js',function(){function showListView(){var option=TabBar.option;var info={key:'metadata.'+option,range:null,direction:(option==='title')?'next':'nextunique',option:option};ListView.activate(info);}
if(app.pendingPick){showListView();if(callback){callback();}
return;}
if(ModeManager.currentMode===MODE_LIST&&TabBar.option!=='playlist'){showListView();}
TilesView.handle=musicdb.enumerateAll('metadata.album',null,'nextunique',function(songs){songs.push(null);TilesView.clean();app.knownSongs.length=0;songs.forEach(function(song){TilesView.update(song);app.knownSongs.push(song);});window.performance.mark('visuallyLoaded');window.dispatchEvent(new CustomEvent('moz-app-visually-complete'));window.performance.mark('contentInteractive');window.dispatchEvent(new CustomEvent('moz-content-interactive'));if(callback){callback();}});});}
app={pendingPick:null,playerSettings:null,currentOverlay:null,knownSongs:[],showOverlay:showOverlay,showCorrectOverlay:showCorrectOverlay,showCurrentView:showCurrentView};return app;})();;'use strict';var musicdb;var displayingScanProgress=false;var firstScanDone=false;var reparsingMetadata=false;function initDB(){var excludedFolders=['Ringtones','Notifications','Alarms'];var excludeFilter=new RegExp('^(/[^/]*/)?('+excludedFolders.join('|')+')/','i');musicdb=new MediaDB('music',metadataParserWrapper,{indexes:['metadata.album','metadata.artist','metadata.title','metadata.rated','metadata.played','date'],excludeFilter:excludeFilter,batchSize:1,autoscan:false,updateRecord:updateRecord,reparsedRecord:reparsedRecord,version:3});function metadataParserWrapper(file,onsuccess,onerror){LazyLoader.load(['/js/metadata_scripts.js','/js/metadata/album_art.js'],function(){AudioMetadata.parse(file).then(function(metadata){return AlbumArt.process(file,metadata);}).then(onsuccess,onerror);});}
function updateRecord(record,oldVersion,newVersion){if(oldVersion===2){record.needsReparse=true;reparsingMetadata=true;}
return record.metadata;}
function reparsedRecord(oldMetadata,newMetadata){newMetadata.rated=oldMetadata.rated;newMetadata.played=oldMetadata.played;return newMetadata;}
musicdb.onupgrading=function(event){App.showOverlay('upgrade');};musicdb.onunavailable=function(event){stopPlayingAndReset();var why=event.detail;if(why===MediaDB.NOCARD){App.showOverlay('nocard');}else if(why===MediaDB.UNMOUNTED){App.showOverlay('pluggedin');}};musicdb.oncardremoved=stopPlayingAndReset;function stopPlayingAndReset(){if(typeof PlayerView!=='undefined'){PlayerView.stop();}
if(!App.pendingPick){TabBar.option='mix';ModeManager.start(MODE_TILES);TilesView.hideSearch();}}
musicdb.onready=function(){if(App.currentOverlay==='nocard'||App.currentOverlay==='pluggedin'||App.currentOverlay==='upgrade')
{App.showOverlay(null);}
App.showCurrentView(function(){reparsingMetadata=false;document.getElementById('spinner-overlay').classList.add('hidden');musicdb.scan();if(document.URL.indexOf('#pick')===-1){MusicComms.init();}});};var filesDeletedWhileScanning=0;var filesFoundWhileScanning=0;var filesFoundBatch=0;var scanning=false;var SCAN_UPDATE_BATCH_SIZE=25;var DELETE_BATCH_TIMEOUT=500;var deleteTimer=null;var scanProgress=document.getElementById('scan-progress');var scanCount=document.getElementById('scan-count');var scanArtist=document.getElementById('scan-artist');var scanTitle=document.getElementById('scan-title');musicdb.onscanstart=function(){scanning=true;displayingScanProgress=false;filesFoundWhileScanning=0;filesFoundBatch=0;filesDeletedWhileScanning=0;};musicdb.onscanend=function(){scanning=false;if(displayingScanProgress){scanProgress.classList.add('hidden');displayingScanProgress=false;}
if(filesFoundBatch>0||filesDeletedWhileScanning>0){filesFoundWhileScanning=0;filesFoundBatch=0;filesDeletedWhileScanning=0;App.showCurrentView();}
if(!firstScanDone){firstScanDone=true;window.performance.mark('fullyLoaded');window.dispatchEvent(new CustomEvent('moz-app-loaded'));}};musicdb.oncreated=function(event){if(scanning){var currentMode=ModeManager.currentMode;if(!displayingScanProgress&&(currentMode===MODE_TILES||currentMode===MODE_LIST||currentMode===MODE_PICKER))
{displayingScanProgress=true;scanProgress.classList.remove('hidden');}
var n=event.detail.length;filesFoundWhileScanning+=n;filesFoundBatch+=n;scanCount.textContent=filesFoundWhileScanning;var metadata=event.detail[0].metadata;scanArtist.textContent=metadata.artist||'';scanTitle.textContent=metadata.title||'';if(filesFoundBatch>SCAN_UPDATE_BATCH_SIZE){filesFoundBatch=0;App.showCurrentView();}}
else{App.showCurrentView();}};musicdb.ondeleted=function(event){if(scanning){filesDeletedWhileScanning+=event.detail.length;}
else{if(deleteTimer){clearTimeout(deleteTimer);}
deleteTimer=setTimeout(function(){deleteTimer=null;App.showCurrentView();},DELETE_BATCH_TIMEOUT);}};document.getElementById('overlay-cancel-button').addEventListener('click',function(){if(App.pendingPick){App.pendingPick.postError('pick cancelled');}});};'use strict';var TitleBar={get view(){return document.getElementById('title');},get titleText(){return document.getElementById('title-text');},get playerIcon(){return document.getElementById('title-player');},init:function tb_init(){this.view.addEventListener('click',this);this.view.addEventListener('action',this.onActionBack);},changeTitleText:function tb_changeTitleText(content){this.titleText.textContent=content;},showBackArrow:function(show){if(show){this.view.setAttribute('action','back');}
else{this.view.removeAttribute('action');}},onActionBack:function(){if(App.pendingPick){if(ModeManager.currentMode===MODE_PICKER){App.pendingPick.postError('pick cancelled');return;}
PlayerView.stop();}
ModeManager.pop();},handleEvent:function tb_handleEvent(evt){var target=evt.target;function cleanupPick(){PlayerView.stop();}
switch(evt.type){case'click':if(!target){return;}
switch(target.id){case'title-player':if(PlayerView.dataSource.length!==0){ModeManager.push(MODE_PLAYER);}
break;case'title-done':var currentFileinfo=PlayerView.dataSource[PlayerView.currentIndex];var playingBlob=PlayerView.playingBlob;AlbumArtCache.getCoverBlob(currentFileinfo).then(function(picture){var currentMetadata=currentFileinfo.metadata;App.pendingPick.postResult({type:playingBlob.type,blob:playingBlob,name:currentMetadata.title||'',metadata:{title:currentMetadata.title,artist:currentMetadata.artist,album:currentMetadata.album,picture:picture}});cleanupPick();});break;}
break;default:return;}}};;'use strict';var TabBar={playlistArray:[{metadata:{l10nId:'playlists-shuffle-all'},option:'shuffleAll'},{metadata:{l10nId:'playlists-highest-rated'},option:'rated'},{metadata:{l10nId:'playlists-recently-added'},option:'date'},{metadata:{l10nId:'playlists-most-played'},option:'played'},{metadata:{l10nId:'playlists-least-played'},option:'played'},null],get view(){return document.getElementById('tabs');},get tabs(){return this.view.querySelectorAll('[role="tab"]');},set option(choice){var map={'mix':'tabs-mix','playlist':'tabs-playlists','artist':'tabs-artists','album':'tabs-albums','title':'tabs-songs'};var tab=document.getElementById(map[choice]);AccessibilityHelper.setAriaSelected(tab,this.tabs);this._option=choice;},get option(){return this._option;},init:function tab_init(){this.option='mix';this.view.addEventListener('touchend',this);},setDisabled:function tab_setDisabled(option){this.disabled=option;},handleEvent:function tab_handleEvent(evt){if(this.disabled){return;}
switch(evt.type){case'touchend':var target=evt.target;if(!target){return;}
if(this.option===target.dataset.option){return;}else{this.option=target.dataset.option;}
switch(target.id){case'tabs-mix':ListView.cancelEnumeration();ModeManager.start(MODE_TILES);TilesView.hideSearch();SearchView.searchContext=SearchView.context.ALL;break;case'tabs-playlists':ModeManager.start(MODE_LIST);ListView.activate();this.playlistArray.forEach(function(playlist){ListView.update(this.option,playlist);}.bind(this));SearchView.searchContext=SearchView.context.ALL;break;case'tabs-artists':case'tabs-albums':case'tabs-songs':var info={key:'metadata.'+this.option,range:null,direction:(this.option==='title')?'next':'nextunique',option:this.option};ModeManager.start(MODE_LIST);ListView.activate(info);switch(target.id){case'tabs-artists':SearchView.searchContext=SearchView.context.ARTISTS;break;case'tabs-albums':SearchView.searchContext=SearchView.context.ALBUMS;break;case'tabs-songs':SearchView.searchContext=SearchView.context.SONGS;break;}
break;}
break;default:return;}}};;'use strict';var MODE_TILES=1;var MODE_LIST=2;var MODE_SUBLIST=3;var MODE_PLAYER=4;var MODE_SEARCH_FROM_TILES=5;var MODE_SEARCH_FROM_LIST=6;var MODE_PICKER=7;var ModeManager={_modeStack:[],playerTitle:null,get currentMode(){return this._modeStack[this._modeStack.length-1];},start:function(mode,callback){this._modeStack=[mode];this._updateMode(callback);},push:function(mode,callback){this._modeStack.push(mode);this._updateMode(callback);},pop:function(){if(this._modeStack.length<=1){return;}
this._modeStack.pop();this._updateMode();},updateBackArrow:function(){var noBackArrow=[MODE_TILES,MODE_LIST,MODE_SEARCH_FROM_TILES,MODE_SEARCH_FROM_LIST];var hide=noBackArrow.indexOf(this.currentMode)>-1;TitleBar.showBackArrow(!hide);},updateTitle:function(){var title;switch(this.currentMode){case MODE_TILES:title=this.playerTitle||navigator.mozL10n.get('music');break;case MODE_LIST:case MODE_SUBLIST:switch(TabBar.option){case'playlist':title=navigator.mozL10n.get('playlists');break;case'artist':title=navigator.mozL10n.get('artists');break;case'album':title=navigator.mozL10n.get('albums');break;case'title':title=navigator.mozL10n.get('songs');break;}
break;case MODE_PLAYER:title=this.playerTitle||navigator.mozL10n.get('unknownTitle');break;case MODE_PICKER:title=navigator.mozL10n.get('picker-title');break;}
if(title){TitleBar.changeTitleText(title);}},_updateMode:function(callback){var mode=this.currentMode;var playerLoaded=(typeof PlayerView!='undefined');this.updateTitle();this.updateBackArrow();if(mode===MODE_PLAYER){document.getElementById('views-player').classList.remove('hidden');LazyLoader.load('js/ui/views/player_view.js',function(){if(!playerLoaded){PlayerView.init();PlayerView.setOptions(App.playerSettings);}
this.enableNFCSharing(true);if(callback){callback();}}.bind(this));}else{if(mode===MODE_LIST||mode===MODE_PICKER){document.getElementById('views-list').classList.remove('hidden');}else if(mode===MODE_SUBLIST){document.getElementById('views-sublist').classList.remove('hidden');}else if(mode===MODE_SEARCH_FROM_TILES||mode===MODE_SEARCH_FROM_LIST){document.getElementById('search').classList.remove('hidden');document.getElementById('views-sublist').classList.add('hidden');document.getElementById('views-player').classList.add('hidden');}
this.enableNFCSharing(false);if(callback){callback();}}
if(App.pendingPick){document.getElementById('title-done').hidden=(mode!==MODE_PLAYER);}
var modeClasses=['tiles-mode','list-mode','sublist-mode','player-mode','search-from-tiles-mode','search-from-list-mode','picker-mode'];modeClasses.forEach(function resetMode(targetClass){document.body.classList.remove(targetClass);});document.body.classList.add(modeClasses[mode-1]);if(displayingScanProgress&&(mode===MODE_SUBLIST||mode===MODE_PLAYER)){document.getElementById('scan-progress').classList.add('hidden');displayingScanProgress=false;}},enableNFCSharing:function(enabled){if(!navigator.mozNfc){return;}
if(enabled&&!App.pendingPick){navigator.mozNfc.onpeerready=function(event){var peer=event.peer;if(peer){peer.sendFile(PlayerView.playingBlob);}};}else{navigator.mozNfc.onpeerready=null;}}};;'use strict';var TilesView={get view(){return document.getElementById('views-tiles');},get anchor(){return document.getElementById('views-tiles-anchor');},get searchBox(){return document.getElementById('views-tiles-search');},get searchInput(){return document.getElementById('views-tiles-search-input');},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;},init:function tv_init(){this.handle=null;this.dataSource=[];this.index=0;this.view.addEventListener('click',this);this.view.addEventListener('input',this);this.view.addEventListener('touchend',this);this.searchInput.addEventListener('focus',this);this.searchInput.addEventListener('keypress',this);},clean:function tv_clean(){if(this.handle){musicdb.cancelEnumeration(this.handle);}
this.dataSource=[];this.index=0;this.anchor.innerHTML='';this.view.scrollTop=0;this.hideSearch();},hideSearch:function tv_hideSearch(){this.searchInput.value='';if(this.view.scrollTop<this.searchBox.offsetHeight){this.view.scrollTop=this.searchBox.offsetHeight;}},update:function tv_update(result){TabBar.setDisabled(!this.dataSource.length);if(result===null){App.showCorrectOverlay();document.getElementById('views-tiles').classList.remove('hidden');window.setTimeout(this.hideSearch.bind(this),1000);return;}
this.dataSource.push(result);var tile=document.createElement('div');tile.className='tile';var container=document.createElement('div');container.className='tile-container';container.setAttribute('role','button');var titleBar=document.createElement('div');titleBar.className='tile-title-bar';var artistName=document.createElement('div');artistName.className='tile-title-artist';var albumName=document.createElement('div');albumName.className='tile-title-album';artistName.textContent=result.metadata.artist||navigator.mozL10n.get('unknownArtist');artistName.dataset.l10nId=result.metadata.artist?'':'unknownArtist';albumName.textContent=result.metadata.album||navigator.mozL10n.get('unknownAlbum');albumName.dataset.l10nId=result.metadata.album?'':'unknownAlbum';titleBar.appendChild(artistName);if(this.index%6===0){tile.classList.add('main-tile');artistName.classList.add('main-tile-title');titleBar.appendChild(albumName);}else{tile.classList.add('sub-tile');artistName.classList.add('sub-tile-title');}
var NUM_INITIALLY_VISIBLE_TILES=8;var INITIALLY_HIDDEN_TILE_WAIT_TIME_MS=1000;var setTileBackgroundClosure=function(url){tile.style.backgroundImage='url('+url+')';};if(this.index<=NUM_INITIALLY_VISIBLE_TILES){AlbumArtCache.getCoverURL(result).then(setTileBackgroundClosure);}else{setTimeout(function(){AlbumArtCache.getCoverURL(result).then(setTileBackgroundClosure);},INITIALLY_HIDDEN_TILE_WAIT_TIME_MS);}
container.dataset.index=this.index;if(!result.metadata.picture){container.appendChild(titleBar);}else{container.setAttribute('aria-label',artistName.textContent+' '+
albumName.textContent);}
tile.appendChild(container);this.anchor.appendChild(tile);this.index++;},handleEvent:function tv_handleEvent(evt){function tv_resetSearch(self){evt.preventDefault();self.searchInput.value='';SearchView.clearSearch();}
var target=evt.target;if(!target){return;}
switch(evt.type){case'touchend':if(target.id==='views-tiles-search'){var id=evt.originalTarget.id;if(id&&id!=='views-tiles-search-input'&&id!=='views-tiles-search-close'){tv_resetSearch(this);return;}}
if(target.id==='views-tiles-search-clear'){tv_resetSearch(this);return;}
break;case'click':if(target.id==='views-tiles-search-close'){if(ModeManager.currentMode===MODE_SEARCH_FROM_TILES){ModeManager.pop();}
this.hideSearch();evt.preventDefault();}else if(target.dataset.index){var handler;var index=target.dataset.index;var data=this.dataSource[index];handler=tv_playAlbum.bind(this,data,index);target.addEventListener('transitionend',handler);}
break;case'focus':if(target.id==='views-tiles-search-input'){if(ModeManager.currentMode!==MODE_SEARCH_FROM_TILES){ModeManager.push(MODE_SEARCH_FROM_TILES);SearchView.search(target.value);}}
break;case'input':if(target.id==='views-tiles-search-input'){SearchView.search(target.value);}
break;case'keypress':if(target.id==='views-tiles-search-input'){if(evt.keyCode===evt.DOM_VK_RETURN){evt.preventDefault();}}
break;default:return;}
function tv_playAlbum(data,index){var key='metadata.album';var range=IDBKeyRange.only(data.metadata.album);var direction='next';ModeManager.push(MODE_PLAYER,function(){PlayerView.clean();PlayerView.handle=musicdb.enumerateAll(key,range,direction,function tv_enumerateAll(dataArray){PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=dataArray;if(PlayerView.shuffleOption){PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);}else{PlayerView.play(0);}});});target.removeEventListener('transitionend',handler);}}};;'use strict';var LIST_BATCH_SIZE=7*5;var ListView={get view(){return document.getElementById('views-list');},get anchor(){return document.getElementById('views-list-anchor');},get searchBox(){return document.getElementById('views-list-search');},get searchInput(){return document.getElementById('views-list-search-input');},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;},init:function lv_init(){this.clean();this.view.addEventListener('click',this);this.view.addEventListener('input',this);this.view.addEventListener('touchmove',this);this.view.addEventListener('touchend',this);this.view.addEventListener('scroll',this);this.searchInput.addEventListener('focus',this);this.searchInput.addEventListener('keypress',this);},clean:function lv_clean(){this.cancelEnumeration();this.info=null;this.handle=null;this.dataSource=[];this.index=0;this.lastDataIndex=0;this.firstLetters=[];this.lastFirstLetter=null;this.anchor.innerHTML='';this.anchor.style.height=0;this.view.scrollTop=0;this.hideSearch();this.moveTimer=null;this.scrollTimer=null;},cancelEnumeration:function lv_cancelEnumeration(){if(this.handle){musicdb.cancelEnumeration(this.handle);}},hideSearch:function lv_hideSearch(){this.searchInput.value='';if(this.view.scrollTop<this.searchBox.offsetHeight){this.view.scrollTop=this.searchBox.offsetHeight;}},createHeader:function lv_createHeader(option,result){var firstLetter=result.metadata[option].charAt(0);var headerLi;if(this.lastFirstLetter!==firstLetter){this.lastFirstLetter=firstLetter;headerLi=document.createElement('li');headerLi.className='list-header';headerLi.textContent=this.lastFirstLetter||'?';headerLi.setAttribute('role','heading');headerLi.setAttribute('aria-level','2');}
return headerLi;},activate:function lv_activate(info){if(!info){this.clean();return;}
musicdb.count('metadata.'+info.option,null,function(count){this.clean();this.info=info;this.info.count=count;this.handle=musicdb.enumerate(info.key,info.range,info.direction,function(record){if(record){if(!App.pendingPick||!record.metadata.locked){this.dataSource.push(record);}
this.lastDataIndex=this.dataSource.length;}
if(this.dataSource.length===LIST_BATCH_SIZE||!record){this.batchUpdate(info.option,LIST_BATCH_SIZE);count=record?count:null;this.adjustHeight(info.option,count);if(App.pendingPick){App.knownSongs=this.dataSource;App.showCorrectOverlay();}}}.bind(this));}.bind(this));},update:function lv_update(option,result){if(result===null){App.showCorrectOverlay();return;}
this.dataSource.push(result);if(option!=='playlist'){var header=this.createHeader(option,result);if(header){this.anchor.appendChild(header);}}
this.anchor.appendChild(createListElement(option,result,this.index));this.index++;},judgeAndUpdate:function lv_judgeAndUpdate(){if(!this.anchor.lastChild||!this.info){return;}
var itemHeight=this.anchor.lastChild.offsetHeight;var scrolledHeight=this.view.scrollTop+this.view.offsetHeight;var position=Math.round(scrolledHeight/itemHeight);var last=this.anchor.children.length;var range=position+this.firstLetters.length-last;if(range>0){this.batchUpdate(TabBar.option,range+LIST_BATCH_SIZE);if(this.handle.state==='cancelled'&&this.lastDataIndex>-1){var info=this.info;var index=this.lastDataIndex+1;this.handle=musicdb.advancedEnumerate(info.key,info.range,info.direction,index,function(record){if(record){this.dataSource[index]=record;this.lastDataIndex=index;index++;}else{this.lastDataIndex=-1;}}.bind(this));}}},batchUpdate:function lv_batchUpdate(option,range){var start=this.index;var end=start+range;var fragment=document.createDocumentFragment();if(end>this.dataSource.length){end=this.dataSource.length;}
for(var i=start;i<end;i++){var data=this.dataSource[i];if(data){var header=this.createHeader(option,data);if(header){fragment.appendChild(header);}
fragment.appendChild(createListElement(option,data,this.index));this.index++;}}
this.anchor.appendChild(fragment);},adjustHeight:function lv_adjustHeight(option,count){if(this.dataSource.length===0){return;}
if(!count){count=this.dataSource.length;this.firstLetters.length=0;var previousFirstLetter;for(var i=0;i<this.dataSource.length;i++){var metadata=this.dataSource[i].metadata;var firstLetter=metadata[option].charAt(0);if(previousFirstLetter!==firstLetter){this.firstLetters.push(firstLetter);previousFirstLetter=firstLetter;}}}else{this.firstLetters.length=26;}
var headerHeight=this.anchor.firstChild.offsetHeight;var itemHeight=this.anchor.lastChild.offsetHeight;var bottomHeight=parseInt(getComputedStyle(this.anchor.lastChild,null).getPropertyValue('margin-bottom'),10);this.anchor.style.height=(headerHeight*this.firstLetters.length+
itemHeight*count+
bottomHeight)+'px';},playWithShuffleAll:function lv_playWithShuffleAll(){ModeManager.push(MODE_PLAYER,function(){musicdb.count('metadata.title',null,function(count){var info={key:'metadata.title',range:null,direction:'next',option:'title',count:count};PlayerView.setSourceType(TYPE_MIX);PlayerView.dataSource=new Array(count);PlayerView.setDBInfo(info);PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);});});},playWithIndex:function lv_playWithIndex(index){ModeManager.push(MODE_PLAYER,function(){if(App.pendingPick){PlayerView.setSourceType(TYPE_SINGLE);}else{PlayerView.setSourceType(TYPE_MIX);}
this.cancelEnumeration();PlayerView.dataSource=this.dataSource;PlayerView.setDBInfo(this.info);if(PlayerView.shuffleOption){PlayerView.shuffleList(index);PlayerView.play(PlayerView.shuffledList[0]);}else{PlayerView.play(index);}}.bind(this));},activateSubListView:function lv_activateSubListView(target){var option=target.dataset.option;var index=target.dataset.index;var data=this.dataSource[index];var keyRange=(target.dataset.keyRange!='all')?IDBKeyRange.only(target.dataset.keyRange):null;var l10nId=data.metadata.l10nId;var direction=(l10nId==='playlists-most-played'||l10nId==='playlists-recently-added'||l10nId==='playlists-highest-rated')?'prev':'next';SubListView.activate(option,data,index,keyRange,direction,function(){ModeManager.push(MODE_SUBLIST);});},handleEvent:function lv_handleEvent(evt){function lv_resetSearch(self){evt.preventDefault();self.searchInput.value='';SearchView.clearSearch();}
var target=evt.target;if(!target){return;}
switch(evt.type){case'touchend':if(target.id==='views-list-search'){var id=evt.originalTarget.id;if(id&&id!=='views-list-search-input'&&id!=='views-list-search-close'){lv_resetSearch(this);return;}}
if(target.id==='views-list-search-clear'){lv_resetSearch(this);return;}
break;case'click':if(target.id==='views-list-search-close'){if(ModeManager.currentMode===MODE_SEARCH_FROM_LIST){ModeManager.pop();}
this.hideSearch();evt.preventDefault();}else{var option=target.dataset.option;if(option==='shuffleAll'){this.playWithShuffleAll();}else if(option==='title'){this.playWithIndex(target.dataset.index);}else if(option){this.activateSubListView(target);}}
break;case'focus':if(target.id==='views-list-search-input'){if(ModeManager.currentMode!==MODE_SEARCH_FROM_LIST){ModeManager.push(MODE_SEARCH_FROM_LIST);SearchView.search(target.value);}}
break;case'input':if(target.id==='views-list-search-input'){SearchView.search(target.value);}
break;case'keypress':if(target.id==='views-list-search-input'){if(evt.keyCode===evt.DOM_VK_RETURN){evt.preventDefault();}}
break;case'touchmove':if(this.anchor.children.length===0){return;}
if(this.moveTimer){clearTimeout(this.moveTimer);}
this.moveTimer=setTimeout(function(){this.judgeAndUpdate();this.moveTimer=null;}.bind(this),50);break;case'scroll':if(this.anchor.children.length===0){return;}
if(this.scrollTimer){clearTimeout(this.scrollTimer);}
this.scrollTimer=setTimeout(function(){this.judgeAndUpdate();this.scrollTimer=null;}.bind(this),500);break;default:return;}}};;'use strict';var SubListView={get view(){return document.getElementById('views-sublist');},get dataSource(){return this._dataSource;},get anchor(){return document.getElementById('views-sublist-anchor');},set dataSource(source){this._dataSource=source;this.shuffleButton.disabled=(this._dataSource.length<2);},init:function slv_init(){this.albumImage=document.getElementById('views-sublist-header-image');this.offscreenImage=new Image();this.albumName=document.getElementById('views-sublist-header-name');this.playAllButton=document.getElementById('views-sublist-controls-play');this.shuffleButton=document.getElementById('views-sublist-controls-shuffle');this.handle=null;this.dataSource=[];this.index=0;this.view.addEventListener('click',this);},clean:function slv_clean(){if(this.handle){musicdb.cancelEnumeration(this.handle);}
this.dataSource=[];this.index=0;this.offscreenImage.src='';this.anchor.innerHTML='';this.view.scrollTop=0;},setAlbumSrc:function slv_setAlbumSrc(fileinfo){if(TabBar.playlistArray.indexOf(fileinfo)!==-1){fileinfo=this.dataSource[0];}
this.offscreenImage.src='';this.albumImage.classList.remove('fadeIn');AlbumArtCache.getCoverURL(fileinfo).then(function(url){this.offscreenImage.addEventListener('load',slv_showImage.bind(this));this.offscreenImage.src=url;}.bind(this));function slv_showImage(evt){evt.target.removeEventListener('load',slv_showImage);var url='url('+this.offscreenImage.src+')';this.albumImage.style.backgroundImage=url;this.albumImage.classList.add('fadeIn');}},setAlbumName:function slv_setAlbumName(name,l10nId){this.albumName.textContent=name;this.albumName.dataset.l10nId=l10nId;},activate:function(option,data,index,keyRange,direction,callback){var targetOption=(option==='date')?option:'metadata.'+option;this.clean();this.handle=musicdb.enumerateAll(targetOption,keyRange,direction,function lv_enumerateAll(dataArray){var albumName;var albumNameL10nId;var maxDiscNum=1;if(option==='album'){dataArray.sort(function(e1,e2){return(e1.metadata.discnum-e2.metadata.discnum)||(e1.metadata.tracknum-e2.metadata.tracknum);});maxDiscNum=Math.max(dataArray[dataArray.length-1].metadata.disccount,dataArray[dataArray.length-1].metadata.discnum);}
if(option==='artist'){albumName=data.metadata.artist||navigator.mozL10n.get('unknownArtist');albumNameL10nId=data.metadata.artist?'':'unknownArtist';}else if(option==='album'){albumName=data.metadata.album||navigator.mozL10n.get('unknownAlbum');albumNameL10nId=data.metadata.album?'':'unknownAlbum';}else{albumName=data.metadata.title||navigator.mozL10n.get('unknownTitle');albumNameL10nId=data.metadata.title?'':'unknownTitle';}
if(data.metadata.l10nId){albumNameL10nId=data.metadata.l10nId;}
this.dataSource=dataArray;this.setAlbumName(albumName,albumNameL10nId);this.setAlbumSrc(data);var inPlaylist=(option!=='artist'&&option!=='album'&&option!=='title');dataArray.forEach(function(songData){songData.multidisc=(maxDiscNum>1);this.update(songData,inPlaylist);}.bind(this));if(callback){callback();}}.bind(this));},update:function slv_update(result,useIndexNumber){if(result===null){return;}
var option=useIndexNumber?'song-index':'song';this.anchor.appendChild(createListElement(option,result,this.index));this.index++;},handleEvent:function slv_handleEvent(evt){var target=evt.target;if(!target){return;}
switch(evt.type){case'click':if(target===this.shuffleButton){ModeManager.push(MODE_PLAYER,function(){PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=this.dataSource;PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);}.bind(this));return;}
if(target.dataset.index||target===this.playAllButton){ModeManager.push(MODE_PLAYER,function(){PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=this.dataSource;if(target===this.playAllButton){target=this.view.querySelector('li > a[data-index="0"]');PlayerView.setShuffle(false);}
var targetIndex=parseInt(target.dataset.index,10);if(PlayerView.shuffleOption){PlayerView.shuffleList(targetIndex);PlayerView.play(PlayerView.shuffledList[0]);}else{PlayerView.play(targetIndex);}}.bind(this));}
break;default:return;}}};;'use strict';var SearchView={context:{ALL:'ALL',ARTISTS:'ARTISTS',ALBUMS:'ALBUMS',SONGS:'SONGS',},searchContext:'ALL',get view(){return document.getElementById('search');},get searchArtistsView(){return document.getElementById('views-search-artists');},get searchAlbumsView(){return document.getElementById('views-search-albums');},get searchTitlesView(){return document.getElementById('views-search-titles');},showNoResult:function sv_showNoResult(show){var view=document.getElementById('views-search-no-result');view.classList.toggle('hidden',!show);},init:function sv_init(){this.dataSource=[];this.searchHandles={artist:null,album:null,title:null};this.view.addEventListener('click',this);},search:function sv_search(query){this.clearSearch();if(!query){return;}
var queryLowerCased=query.toLocaleLowerCase();query=Normalizer.toAscii(queryLowerCased);var lists={artist:this.searchArtistsView,album:this.searchAlbumsView,title:this.searchTitlesView};var numResults={artist:0,album:0,title:0};function sv_showResult(option,result){if(result===null){this.searchHandles[option]=null;return;}
var resultLowerCased=result.metadata[option].toLocaleLowerCase();if(Normalizer.toAscii(resultLowerCased).indexOf(query)!==-1){this.dataSource.push(result);numResults[option]++;lists[option].classList.remove('hidden');lists[option].getElementsByClassName('search-result-count')[0].textContent=numResults[option];lists[option].getElementsByClassName('search-results')[0].appendChild(createListElement(option,result,this.dataSource.length-1,query));}
var totalFound=numResults.artist+numResults.album+numResults.title;this.showNoResult(totalFound===0);}
if(!App.pendingPick){if(this.searchContext===this.context.ALL||this.searchContext===this.context.ARTISTS){this.searchHandles.artist=musicdb.enumerate('metadata.artist',null,'nextunique',sv_showResult.bind(this,'artist'));}
if(this.searchContext===this.context.ALL||this.searchContext===this.context.ALBUMS){this.searchHandles.album=musicdb.enumerate('metadata.album',null,'nextunique',sv_showResult.bind(this,'album'));}}
if(this.searchContext===this.context.ALL||this.searchContext===this.context.SONGS){this.searchHandles.title=musicdb.enumerate('metadata.title',sv_showResult.bind(this,'title'));}},clearSearch:function sv_clearSearch(){for(var option in this.searchHandles){var handle=this.searchHandles[option];if(handle){musicdb.cancelEnumeration(handle);}}
var views=[this.searchArtistsView,this.searchAlbumsView,this.searchTitlesView];views.forEach(function(view){view.getElementsByClassName('search-results')[0].innerHTML='';view.classList.add('hidden');});this.showNoResult(false);this.dataSource=[];},handleEvent:function sv_handleEvent(evt){var target=evt.target;switch(evt.type){case'click':if(!target){return;}
if(target.dataset.index){var handler;var index=target.dataset.index;var option=target.dataset.option;var keyRange=target.dataset.keyRange;var data=this.dataSource[index];handler=sv_openResult.bind(this,option,data,index,keyRange);target.addEventListener('transitionend',handler);}
break;default:return;}
function sv_openResult(option,data,index,keyRange){if(option==='title'){ModeManager.push(MODE_PLAYER,function(){if(App.pendingPick){PlayerView.setSourceType(TYPE_SINGLE);PlayerView.dataSource=this.dataSource;PlayerView.play(index);}else{PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=[data];PlayerView.play(0);}}.bind(this));}else{SubListView.activate(option,data,index,keyRange,'next',function(){ModeManager.push(MODE_SUBLIST);});}
target.removeEventListener('transitionend',handler);}}};;'use strict';var MusicComms={commands:{play:function(event){this.commands.playpause.call(this,event);},playpause:function(event){this._getPlayerReady(function(){var isResumedBySCO=this.isSCOEnabled;this.isSCOEnabled=event.detail.isSCOConnected;if(isResumedBySCO){if(this._statusBeforeSCO===PLAYSTATUS_PLAYING||this._statusBeforeSCO===INTERRUPT_BEGIN)
{PlayerView.play();}else{PlayerView.pause();}}else{if(PlayerView.playStatus===PLAYSTATUS_STOPPED){musicdb.getAll(function remote_getAll(dataArray){PlayerView.setSourceType(TYPE_MIX);PlayerView.dataSource=dataArray;PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);ModeManager.push(MODE_PLAYER);});}else if(PlayerView.playStatus===PLAYSTATUS_PLAYING){PlayerView.pause();}else{PlayerView.play();}}}.bind(this));},pause:function(event){this.isSCOEnabled=event.detail.isSCOConnected;if(!this._isPlayerActivated()){return;}
if(this.isSCOEnabled){this._statusBeforeSCO=PlayerView.playStatus;}
PlayerView.pause();},stop:function(event){if(!this._isPlayerActivated()){return;}
PlayerView.stop();},next:function(event){if(!this._isPlayerActivated()){return;}
PlayerView.next();},previous:function(event){if(!this._isPlayerActivated()){return;}
PlayerView.previous();},seekpress:function(event){if(!this._isPlayerActivated()){return;}
if(!PlayerView.isTouching){PlayerView.startFastSeeking(event.detail.direction);}},seekrelease:function(event){if(!this._isPlayerActivated()){return;}
PlayerView.stopFastSeeking();},updatemetadata:function(){this._getPlayerReady(function(){PlayerView.updateRemoteMetadata();});},updateplaystatus:function(){this._getPlayerReady(function(){PlayerView.updateRemotePlayStatus();});}},enabled:false,isSCOEnabled:false,_statusBeforeSCO:null,init:function(){this.mrc=new MediaRemoteControls();for(var command in this.commands){this.mrc.addCommandListener(command,this.commands[command].bind(this));}
this.mrc.start(this.updateSCOStatus.bind(this));this.mrc.notifyAppInfo({origin:window.location.origin,icon:window.location.origin+'/style/icons/music_84.png'});this.enabled=true;},_getPlayerReady:function(callback){if(typeof PlayerView==='undefined'){LazyLoader.load('js/ui/views/player_view.js',function(){PlayerView.init();PlayerView.setOptions(App.playerSettings);callback();});}else{callback();}},_isPlayerActivated:function(){return(typeof PlayerView!=='undefined'&&PlayerView.playStatus!==PLAYSTATUS_STOPPED);},notifyMetadataChanged:function(metadata){if(this.enabled){this.mrc.notifyMetadataChanged(metadata);}},notifyStatusChanged:function(info){if(this.enabled){this.mrc.notifyStatusChanged(info);}},updateSCOStatus:function(){if(this.enabled){this.mrc.getSCOStatus(function(status){this.isSCOEnabled=status;}.bind(this));}}};