;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','video/3gpp2':'3g2','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','3g2':'video/3gpp2','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.GaiaHeader=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var textContent=Object.getOwnPropertyDescriptor(Node.prototype,'textContent');var removeAttribute=HTMLElement.prototype.removeAttribute;var setAttribute=HTMLElement.prototype.setAttribute;var noop=function(){};var hasShadowCSS=(function(){var div=document.createElement('div');try{div.querySelector(':host');return true;}
catch(e){return false;}})();module.exports.register=function(name,props){injectGlobalCss(props.globalCss);delete props.globalCSS;var proto=Object.assign(Object.create(base),props);var output=extractLightDomCSS(proto.template,name);var _attrs=Object.assign(props.attrs||{},attrs);proto.template=output.template;proto.lightCss=output.lightCss;Object.defineProperties(proto,_attrs);var El=document.registerElement(name,{prototype:proto});return El;};var base=Object.assign(Object.create(HTMLElement.prototype),{attributeChanged:noop,attached:noop,detached:noop,created:noop,template:'',createdCallback:function(){this.injectLightCss(this);this.created();},attributeChangedCallback:function(name,from,to){if(this.attrs&&this.attrs[name]){this[name]=to;}
this.attributeChanged(name,from,to);},attachedCallback:function(){this.attached();},detachedCallback:function(){this.detached();},setAttr:function(name,value){var internal=this.shadowRoot.firstElementChild;setAttribute.call(internal,name,value);setAttribute.call(this,name,value);},removeAttr:function(){var internal=this.shadowRoot.firstElementChild;removeAttribute.call(internal,name,value);removeAttribute.call(this,name,value);},injectLightCss:function(el){if(hasShadowCSS){return;}
this.lightStyle=document.createElement('style');this.lightStyle.setAttribute('scoped','');this.lightStyle.innerHTML=el.lightCss;el.appendChild(this.lightStyle);}});var attrs={textContent:{set:function(value){var node=firstChildTextNode(this);if(node){node.nodeValue=value;}},get:function(){var node=firstChildTextNode(this);return node&&node.nodeValue;}}};function firstChildTextNode(el){for(var i=0;i<el.childNodes.length;i++){var node=el.childNodes[i];if(node&&node.nodeType===3){return node;}}}
function extractLightDomCSS(template,name){var regex=/(?::host|::content)[^{]*\{[^}]*\}/g;var lightCss='';if(!hasShadowCSS){template=template.replace(regex,function(match){lightCss+=match.replace(/::content|:host/g,name);return'';});}
return{template:template,lightCss:lightCss};}
function injectGlobalCss(css){if(!css)return;var style=document.createElement('style');style.innerHTML=css;document.head.appendChild(style);}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-component',this));},{}],2:[function(require,module,exports){(function(define){define(function(require,exports,module){var base=window.GAIA_ICONS_BASE_URL||window.COMPONENTS_BASE_URL||'bower_components/';if(!isLoaded()){load(base+'gaia-icons/gaia-icons.css');}
function load(href){var link=document.createElement('link');link.rel='stylesheet';link.type='text/css';link.href=href;document.head.appendChild(link);exports.loaded=true;}
function isLoaded(){return exports.loaded||document.querySelector('link[href*=gaia-icons]')||document.documentElement.classList.contains('gaia-icons-loaded');}});})(typeof define=='function'&&define.amd?define:(function(n,w){return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-icons',this));},{}],3:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var Component=require('gaia-component');var fontFit=require('./lib/font-fit');require('gaia-icons');var actionTypes={menu:1,back:1,close:1};module.exports=Component.register('gaia-header',{created:function(){this.createShadowRoot().innerHTML=this.template;this.els={actionButton:this.shadowRoot.querySelector('.action-button'),headings:this.querySelectorAll('h1,h2,h3,h4'),inner:this.shadowRoot.querySelector('.inner')};this.els.actionButton.addEventListener('click',e=>this.onActionButtonClick(e));this.configureActionButton();this.runFontFit();},attached:function(){this.rerunFontFit();},attributeChanged:function(attr){if(attr==='action'){this.configureActionButton();this.rerunFontFit();}},runFontFit:function(){for(var i=0;i<this.els.headings.length;i++){fontFit.reformatHeading(this.els.headings[i]);fontFit.observeHeadingChanges(this.els.headings[i]);}},rerunFontFit:function(){for(var i=0;i<this.els.headings.length;i++){fontFit.reformatHeading(this.els.headings[i]);}},triggerAction:function(){if(this.isSupportedAction(this.getAttribute('action'))){this.els.actionButton.click();}},configureActionButton:function(){var old=this.els.actionButton.getAttribute('icon');var type=this.getAttribute('action');var supported=this.isSupportedAction(type);this.els.actionButton.classList.remove('icon-'+old);this.els.actionButton.setAttribute('icon',type);this.els.inner.classList.toggle('supported-action',supported);if(supported){this.els.actionButton.classList.add('icon-'+type);}},isSupportedAction:function(action){return action&&actionTypes[action];},onActionButtonClick:function(e){var config={detail:{type:this.getAttribute('action')}};var actionEvent=new CustomEvent('action',config);setTimeout(this.dispatchEvent.bind(this,actionEvent));},template:`
  <style>

  :host {
    display: block;

    --gaia-header-button-color:
      var(--header-button-color,
      var(--header-color,
      var(--link-color,
      inherit)));
  }

  /**
   * [hidden]
   */

  :host[hidden] {
    display: none;
  }

  /** Reset
   ---------------------------------------------------------*/

  ::-moz-focus-inner { border: 0; }

  /** Inner
   ---------------------------------------------------------*/

  .inner {
    display: flex;
    min-height: 50px;
    direction: ltr;

    background:
      var(--header-background,
      var(--background,
      #fff));
  }

  /** Action Button
   ---------------------------------------------------------*/

  /**
   * 1. Hidden by default
   */

  .action-button {
    display: none; /* 1 */
    position: relative;
    width: 50px;
    font-size: 30px;
    margin: 0;
    padding: 0;
    border: 0;
    align-items: center;
    background: none;
    cursor: pointer;
    transition: opacity 200ms 280ms;

    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * .action-supported
   *
   * 1. For icon vertical-alignment
   */

  .supported-action .action-button {
    display: flex; /* 1 */
  }

  /**
   * :active
   */

  .action-button:active {
    transition: none;
    opacity: 0.2;
  }

  /** Action Button Icon
   ---------------------------------------------------------*/

  /**
   * 1. To enable vertical alignment.
   */

  .action-button:before {
    display: block;
  }

  /** Action Button Text
   ---------------------------------------------------------*/

  /**
   * To provide custom localized content for
   * the action-button, we allow the user
   * to provide an element with the class
   * .l10n-action. This node is then
   * pulled inside the real action-button.
   *
   * Example:
   *
   *   <gaia-header action="back">
   *     <span class="l10n-action" aria-label="Back">Localized text</span>
   *     <h1>title</h1>
   *   </gaia-header>
   */

  ::content .l10n-action {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    font-size: 0;
  }

  /** Title
   ---------------------------------------------------------*/

  /**
   * 1. Vertically center text. We can't use flexbox
   *    here as it breaks text-overflow ellipsis
   *    without an inner div.
   */

  ::content h1 {
    flex: 1;
    margin: 0;
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
    text-align: center;
    line-height: 50px; /* 1 */
    font-weight: 300;
    font-style: italic;
    font-size: 24px;
    -moz-user-select: none;

    color:
      var(--header-title-color,
      var(--header-color,
      var(--title-color,
      var(--text-color,
      inherit))));
  }

  /**
   * .flush-left
   *
   * When the fitted text is flush with the
   * edge of the left edge of the container
   * we pad it in a bit.
   */

  ::content h1.flush-left {
    padding-left: 10px;
  }

  /**
   * .flush-right
   *
   * When the fitted text is flush with the
   * edge of the right edge of the container
   * we pad it in a bit.
   */

  ::content h1.flush-right {
    padding-right: 10px; /* 1 */
  }

  /** Buttons
   ---------------------------------------------------------*/

  ::content a,
  ::content button {
    box-sizing: border-box;
    display: flex;
    border: none;
    width: auto;
    height: auto;
    margin: 0;
    padding: 0 10px;
    font-size: 14px;
    line-height: 1;
    min-width: 50px;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    text-align: center;
    background: none;
    border-radius: 0;
    font-style: italic;
    cursor: pointer;

    transition: opacity 200ms 280ms;

    color:
      var(--gaia-header-button-color);
  }

  /**
   * :active
   */

  ::content a:active,
  ::content button:active {
    transition: none;
    opacity: 0.2;
  }

  /**
   * [hidden]
   */

  ::content a[hidden],
  ::content button[hidden] {
    display: none;
  }

  /**
   * [disabled]
   */

  ::content a[disabled],
  ::content button[disabled] {
    pointer-events: none;
    color: var(--header-disabled-button-color);
  }

  /** Icon Buttons
   ---------------------------------------------------------*/

  /**
   * Icons are a different color to text
   */

  ::content .icon,
  ::content [data-icon] {
    color:
      var(--header-icon-color,
      var(--gaia-header-button-color));
  }

  /** Icons
   ---------------------------------------------------------*/

  [class^="icon-"]:before,
  [class*="icon-"]:before {
    font-family: 'gaia-icons';
    font-style: normal;
    text-rendering: optimizeLegibility;
    font-weight: 500;
  }

  .icon-menu:before { content: 'menu'; }
  .icon-close:before { content: 'close'; }
  .icon-back:before { content: 'back'; }

  </style>

  <div class="inner">
    <button class="action-button">
      <content select=".l10n-action"></content>
    </button>
    <content select="h1,h2,h3,h4,a,button"></content>
  </div>`});});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-header',this));},{"./lib/font-fit":4,"gaia-component":1,"gaia-icons":2}],4:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var GaiaHeaderFontFit={_HEADER_SIZES:[16,17,18,19,20,21,22,23,24],observeHeadingChanges:function(heading){var observer=this._getTextChangeObserver();observer.observe(heading,{childList:true});},reformatHeading:function(heading){if(!heading||heading.textContent.trim()===''){return;}
this._resetCentering(heading);var style=this._getStyleProperties(heading);if(!style){return;}
style.textWidth=this._autoResizeElement(heading,style);this._centerTextToScreen(heading,style);},resetCache:function(){this._cachedContexts={};},_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},_textChangeObserver:null,_handleTextChanges:function(mutations){var targets=new Set();for(var i=0;i<mutations.length;i++){targets.add(mutations[i].target);}
for(var target of targets){this.reformatHeading(target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},_getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this._getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},_getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},_getStyleProperties:function(heading){var style=getComputedStyle(heading)||{};var contentWidth=this._getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily||'unknown',contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:heading.offsetLeft};},_autoResizeElement:function(heading,styleOptions){var contentWidth=styleOptions.contentWidth||this._getContentWidth(heading);var fontFamily=styleOptions.fontFamily||getComputedStyle(heading).fontFamily;var text=heading.textContent.replace(/\s+/g,' ').trim();var info=this._getMaxFontSizeInfo(text,this._HEADER_SIZES,fontFamily,contentWidth);heading.style.fontSize=info.fontSize+'px';return info.textWidth;},_resetCentering:function(heading){heading.style.marginLeft=heading.style.marginRight='0';},_centerTextToScreen:function(heading,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var tightText=styleOptions.textWidth>(styleOptions.contentWidth-30);var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this._getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;heading.classList.toggle('flush-left',tightText&&!sideSpaceLeft);heading.classList.toggle('flush-right',tightText&&!sideSpaceRight);if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this._getWindowWidth()-1){if(sideSpaceLeft<sideSpaceRight){heading.style.marginLeft=(sideSpaceRight-sideSpaceLeft)+'px';}
if(sideSpaceRight<sideSpaceLeft){heading.style.marginRight=(sideSpaceLeft-sideSpaceRight)+'px';}}},_getWindowWidth:function(){return window.innerWidth;}};module.exports=GaiaHeaderFontFit;});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('./lib/font-fit',this));},{}]},{},[3])(3)});;'use strict';var BlobView=(function(){function fail(msg){throw Error(msg);}
function BlobView(blob,sliceOffset,sliceLength,slice,viewOffset,viewLength,littleEndian)
{this.blob=blob;this.sliceOffset=sliceOffset;this.sliceLength=sliceLength;this.slice=slice;this.viewOffset=viewOffset;this.viewLength=viewLength;this.littleEndian=littleEndian;this.view=new DataView(slice,viewOffset,viewLength);this.buffer=slice;this.byteLength=viewLength;this.byteOffset=viewOffset;this.index=0;}
BlobView.get=function(blob,offset,length,callback,littleEndian){if(offset<0){fail('negative offset');}
if(length<0){fail('negative length');}
if(offset>blob.size){fail('offset larger than blob size');}
if(offset+length>blob.size){length=blob.size-offset;}
var slice=blob.slice(offset,offset+length);var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){var result=null;if(reader.result){result=new BlobView(blob,offset,length,reader.result,0,length,littleEndian||false);}
callback(result,reader.error);};};BlobView.getFromArrayBuffer=function(buffer,offset,length,littleEndian){return new BlobView(null,offset,length,buffer,offset,length,littleEndian);};BlobView.prototype={constructor:BlobView,getMore:function(offset,length,callback){if(!this.blob)
fail('no blob backing this BlobView');if(offset>=this.sliceOffset&&offset+length<=this.sliceOffset+this.sliceLength){callback(new BlobView(this.blob,this.sliceOffset,this.sliceLength,this.slice,offset-this.sliceOffset,length,this.littleEndian));}
else{BlobView.get(this.blob,offset,length,callback,this.littleEndian);}},littleEndian:function(){this.littleEndian=true;},bigEndian:function(){this.littleEndian=false;},getUint8:function(offset){return this.view.getUint8(offset);},getInt8:function(offset){return this.view.getInt8(offset);},getUint16:function(offset,le){return this.view.getUint16(offset,le!==undefined?le:this.littleEndian);},getInt16:function(offset,le){return this.view.getInt16(offset,le!==undefined?le:this.littleEndian);},getUint32:function(offset,le){return this.view.getUint32(offset,le!==undefined?le:this.littleEndian);},getInt32:function(offset,le){return this.view.getInt32(offset,le!==undefined?le:this.littleEndian);},getFloat32:function(offset,le){return this.view.getFloat32(offset,le!==undefined?le:this.littleEndian);},getFloat64:function(offset,le){return this.view.getFloat64(offset,le!==undefined?le:this.littleEndian);},readByte:function(){return this.view.getInt8(this.index++);},readUnsignedByte:function(){return this.view.getUint8(this.index++);},readShort:function(le){var val=this.view.getInt16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readUnsignedShort:function(le){var val=this.view.getUint16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readInt:function(le){var val=this.view.getInt32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readUnsignedInt:function(le){var val=this.view.getUint32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readFloat:function(le){var val=this.view.getFloat32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readDouble:function(le){var val=this.view.getFloat64(this.index,le!==undefined?le:this.littleEndian);this.index+=8;return val;},tell:function(){return this.index;},remaining:function(){return this.byteLength-this.index;},seek:function(index){if(index<0){fail('negative index');}
if(index>this.byteLength){fail('index greater than buffer size');}
this.index=index;},advance:function(n){var index=this.index+n;if(index<0){fail('advance past beginning of buffer');}
if(index>this.byteLength){fail('advance past end of buffer');}
this.index=index;},getUnsignedByteArray:function(offset,n){return new Uint8Array(this.buffer,offset+this.viewOffset,n);},readUnsignedByteArray:function(n){var val=new Uint8Array(this.buffer,this.index+this.viewOffset,n);this.index+=n;return val;},getBit:function(offset,bit){var byte=this.view.getUint8(offset);return(byte&(1<<bit))!==0;},getUint24:function(offset,le){var b1,b2,b3;if(le!==undefined?le:this.littleEndian){b1=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b3=this.view.getUint8(offset+2);}
else{b3=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b1=this.view.getUint8(offset+2);}
return(b3<<16)+(b2<<8)+b1;},readUint24:function(le){var value=this.getUint24(this.index,le);this.index+=3;return value;},getASCIIText:function(offset,len){var bytes=new Uint8Array(this.buffer,offset+this.viewOffset,len);return String.fromCharCode.apply(String,bytes);},readASCIIText:function(len){var bytes=new Uint8Array(this.buffer,this.index+this.viewOffset,len);this.index+=len;return String.fromCharCode.apply(String,bytes);},getUTF8Text:function(offset,len){function fail(){throw new Error('Illegal UTF-8');}
var pos=offset;var end=offset+len;var charcode;var s='';var b1,b2,b3,b4;while(pos<end){var b1=this.view.getUint8(pos);if(b1<128){s+=String.fromCharCode(b1);pos+=1;}
else if(b1<194){fail();}
else if(b1<224){if(pos+1>=end){fail();}
b2=this.view.getUint8(pos+1);if(b2<128||b2>191){fail();}
charcode=((b1&0x1f)<<6)+(b2&0x3f);s+=String.fromCharCode(charcode);pos+=2;}
else if(b1<240){if(pos+2>=end){fail();}
b2=this.view.getUint8(pos+1);if(b2<128||b2>191){fail();}
b3=this.view.getUint8(pos+2);if(b3<128||b3>191){fail();}
charcode=((b1&0x0f)<<12)+((b2&0x3f)<<6)+(b3&0x3f);s+=String.fromCharCode(charcode);pos+=3;}
else if(b1<245){if(pos+3>=end){fail();}
b2=this.view.getUint8(pos+1);if(b2<128||b2>191){fail();}
b3=this.view.getUint8(pos+2);if(b3<128||b3>191){fail();}
b4=this.view.getUint8(pos+3);if(b4<128||b4>191){fail();}
charcode=((b1&0x07)<<18)+
((b2&0x3f)<<12)+
((b3&0x3f)<<6)+
(b4&0x3f);charcode-=0x10000;s+=String.fromCharCode(0xd800+((charcode&0x0FFC00)>>>10));s+=String.fromCharCode(0xdc00+(charcode&0x0003FF));pos+=4;}
else{fail();}}
return s;},readUTF8Text:function(len){try{return this.getUTF8Text(this.index,len);}
finally{this.index+=len;}},getUTF16Text:function(offset,len,le){if(len%2){fail('len must be a multiple of two');}
if(le===null||le===undefined){var BOM=this.getUint16(offset);len-=2;offset+=2;if(BOM===0xFEFF)
le=false;else
le=true;}
var s='';for(var i=0;i<len;i+=2)
s+=String.fromCharCode(this.getUint16(offset+i,le));return s;},readUTF16Text:function(len,le){var value=this.getUTF16Text(this.index,len,le);this.index+=len;return value;},getID3Uint28BE:function(offset){var b1=this.view.getUint8(offset)&0x7f;var b2=this.view.getUint8(offset+1)&0x7f;var b3=this.view.getUint8(offset+2)&0x7f;var b4=this.view.getUint8(offset+3)&0x7f;return(b1<<21)|(b2<<14)|(b3<<7)|b4;},readID3Uint28BE:function(){var value=this.getID3Uint28BE(this.index);this.index+=4;return value;},readNullTerminatedLatin1Text:function(size){var s='';for(var i=0;i<size;i++){var charcode=this.view.getUint8(this.index+i);if(charcode===0){i++;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;},readNullTerminatedUTF8Text:function(size){for(var len=0;len<size;len++){if(this.view.getUint8(this.index+len)===0){break;}}
var s=this.readUTF8Text(len);if(len<size){this.advance(1);}
return s;},readNullTerminatedUTF16Text:function(size,le){if(size%2){fail('size must be a multiple of two');}
if(le===null||le===undefined){var BOM=this.readUnsignedShort();size-=2;if(BOM===0xFEFF){le=false;}else{le=true;}}
var s='';for(var i=0;i<size;i+=2){var charcode=this.getUint16(this.index+i,le);if(charcode===0){i+=2;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;}};return{get:BlobView.get,getFromArrayBuffer:BlobView.getFromArrayBuffer};}());'use strict';var MetadataFormats=(function(){var formats=[{file:'js/metadata/forward_lock.js',get module(){return ForwardLockMetadata;},match:function(header){return header.getASCIIText(0,9)==='LOCKED 1 ';}},{file:'js/metadata/id3v2.js',get module(){return ID3v2Metadata;},match:function(header){return header.getASCIIText(0,3)==='ID3';}},{file:'js/metadata/ogg.js',get module(){return OggMetadata;},match:function(header){return header.getASCIIText(0,4)==='OggS';}},{file:'js/metadata/flac.js',get module(){return FLACMetadata;},match:function(header){return header.getASCIIText(0,4)==='fLaC';}},{file:'js/metadata/mp4.js',get module(){return MP4Metadata;},match:function(header){return header.getASCIIText(4,4)==='ftyp';}},{file:'js/metadata/id3v1.js',get module(){return ID3v1Metadata;},match:function(header){return(header.getUint16(0,false)&0xFFFE)===0xFFFA;}}];function MetadataParser(formatInfo){this._formatInfo=formatInfo;}
MetadataParser.prototype={parse:function(header){var info=this._formatInfo;return new Promise(function(resolve,reject){LazyLoader.load(info.file,function(){resolve(info.module.parse(header));});});}};function findParser(header){for(var i=0;i<formats.length;i++){if(formats[i].match(header)){return new MetadataParser(formats[i]);}}
return null;}
return{findParser:findParser};})();'use strict';var AudioMetadata=(function(){function parse(blob){var filename=blob.name;if(filename){if(filename.slice(0,5)==='DCIM/'&&filename.slice(-4).toLowerCase()==='.3gp'){return Promise.reject('skipping 3gp video file');}}
if(blob.size<128){return Promise.reject('file is empty or too small');}
return new Promise(function(resolve,reject){var headersize=Math.min(64*1024,blob.size);BlobView.get(blob,0,headersize,function(header,error){if(error){reject(error);return;}
try{var parser=MetadataFormats.findParser(header);var promise;if(parser){promise=parser.parse(header);}else{promise=checkPlayability(blob);}
resolve(promise.then(function(metadata){return addDefaultMetadata(metadata||{},filename);}));}catch(e){console.error('AudioMetadata.parse:',e,e.stack);reject(e);}});});}
function addDefaultMetadata(metadata,filename){if(!metadata.artist){metadata.artist='';}
if(!metadata.album){metadata.album='';}
if(!metadata.title){if(filename){var p1=filename.lastIndexOf('/');var p2=filename.lastIndexOf('.');if(p2<=p1){p2=filename.length;}
metadata.title=filename.substring(p1+1,p2);}else{metadata.title='';}}
metadata.rated=metadata.played=0;return metadata;}
function checkPlayability(blob){var player=new Audio();player.mozAudioChannelType='content';var canplay=blob.type&&player.canPlayType(blob.type);if(canplay==='probably'){return Promise.resolve();}else{return new Promise(function(resolve,reject){var url=URL.createObjectURL(blob);player.src=url;player.onerror=function(){URL.revokeObjectURL(url);player.removeAttribute('src');player.load();reject('Unplayable music file');};player.oncanplay=function(){URL.revokeObjectURL(url);player.removeAttribute('src');player.load();resolve();};});}}
return{parse:parse};})();;'use strict';var AlbumArtCache=(function(){var THUMBNAIL_WIDTH=300;var THUMBNAIL_HEIGHT=300;var L1Cache={};function getCoverURL(fileinfo,noPlaceholder){if(!fileinfo.metadata.picture){return Promise.resolve(noPlaceholder?null:getDefaultCoverURL(fileinfo));}
var cacheKey=makeCacheKey(fileinfo);if(cacheKey&&cacheKey in L1Cache){return Promise.resolve(L1Cache[cacheKey]);}
return checkL2Cache(cacheKey).then(function(cachedBlob){return cachedBlob||createThumbnail(cacheKey,fileinfo);}).then(function(blob){return makeURL(cacheKey,blob);});}
function getCoverBlob(fileinfo,noPlaceholder){if(!fileinfo.metadata.picture){if(noPlaceholder){return Promise.resolve(null);}
return getBlobFromURL(getDefaultCoverURL(fileinfo));}
var cacheKey=makeCacheKey(fileinfo);return checkL2Cache(cacheKey).then(function(cachedBlob){return cachedBlob||createThumbnail(cacheKey,fileinfo);});}
function getDefaultCoverURL(fileinfo){var metadata=fileinfo.metadata;var infoForHash=(!metadata.album&&!metadata.artist)?metadata.title:metadata.album+metadata.artist;var hashedNumber=(Math.abs(hash(infoForHash))%10)+1;return'/style/images/AlbumArt'+hashedNumber+'_small.png';}
function hash(str){var hashCode=0;if(str.length===0){return hashCode;}
for(var i=0;i<str.length;i++){var c=str.charCodeAt(i);hashCode=((hashCode<<5)-hashCode)+c;hashCode=hashCode&hashCode;}
return hashCode;}
function makeCacheKey(fileinfo){var metadata=fileinfo.metadata;if(metadata.picture.filename){return'external.'+metadata.picture.filename;}else if(metadata.picture.flavor==='embedded'){var album=metadata.album;var artist=metadata.artist;var size=metadata.picture.end-metadata.picture.start;if(album||artist){return'thumbnail.'+album+'.'+artist+'.'+size;}else{return'thumbnail.'+(fileinfo.name||fileinfo.blob.name);}}
return null;}
function checkL2Cache(cacheKey){if(!cacheKey){return Promise.resolve(null);}else{return new Promise(function(resolve,reject){asyncStorage.getItem(cacheKey,function(blob){resolve(blob);});});}}
function makeURL(cacheKey,blob){var url=URL.createObjectURL(blob);if(cacheKey){L1Cache[cacheKey]=url;}
return url;}
function createThumbnail(cacheKey,fileinfo){return getAlbumArtBlob(fileinfo).then(function(blob){return ImageUtils.resizeAndCropToCover(blob,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT);}).then(function(thumbnailBlob){if(cacheKey){asyncStorage.setItem(cacheKey,thumbnailBlob);}
return thumbnailBlob;});}
function getAlbumArtBlob(fileinfo){var picture=fileinfo.metadata.picture;return new Promise(function(resolve,reject){if(picture.blob){resolve(picture.blob);}else if(picture.filename){var getreq=AlbumArt.pictureStorage.get(picture.filename);getreq.onsuccess=function(){resolve(this.result);};getreq.onerror=function(){reject(this.error);};}else if(picture.start){getSongBlob(fileinfo).then(function(blob){var embedded=blob.slice(picture.start,picture.end,picture.type);resolve(embedded);}).catch(reject);}else{var err=new Error('unknown picture flavor: '+picture.flavor);console.error(err);reject(err);}});}
function getSongBlob(fileinfo){return new Promise(function(resolve,reject){if(fileinfo.blob){resolve(fileinfo.blob);}else{musicdb.getFile(fileinfo.name,function(file){if(file){resolve(file);}else{reject('unable to get file: '+fileinfo.name);}});}});}
function getBlobFromURL(url){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.responseType='blob';xhr.onload=function(){resolve(xhr.response);};xhr.onerror=function(){reject(null);};xhr.send();});}
return{getCoverURL:getCoverURL,getCoverBlob:getCoverBlob};})();;'use strict';function formatTime(secs){if(isNaN(secs)){return;}
secs=Math.floor(secs);var formatedTime;var seconds=secs%60;var minutes=Math.floor(secs/60)%60;var hours=Math.floor(secs/3600);if(hours===0){formatedTime=(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}else{formatedTime=(hours<10?'0'+hours:hours)+':'+
(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}
return formatedTime;}
function createListElement(option,data,index,highlight){var li=document.createElement('li');li.className='list-item';li.setAttribute('role','presentation');var a=document.createElement('a');a.dataset.index=index;a.dataset.option=option;a.setAttribute('role','option');var titleSpan;li.appendChild(a);function highlightText(result,text){var textContent=result.textContent;var textLowerCased=textContent.toLocaleLowerCase();var index=Normalizer.toAscii(textLowerCased).indexOf(text);if(index>=0){var innerHTML=textContent.substring(0,index)+'<span class="search-highlight">'+
textContent.substring(index,index+text.length)+'</span>'+
textContent.substring(index+text.length);result.innerHTML=innerHTML;}}
switch(option){case'playlist':titleSpan=document.createElement('span');titleSpan.className='list-playlist-title';if(data.metadata.l10nId){titleSpan.textContent=navigator.mozL10n.get(data.metadata.l10nId);titleSpan.dataset.l10nId=data.metadata.l10nId;}else{titleSpan.textContent=data.metadata.title||navigator.mozL10n.get('unknownTitle');titleSpan.dataset.l10nId=data.metadata.title?'':'unknownTitle';}
a.dataset.keyRange='all';a.dataset.option=data.option;a.appendChild(titleSpan);if(index===0){var shuffleIcon=document.createElement('div');shuffleIcon.className='list-playlist-icon';shuffleIcon.dataset.icon='shuffle';a.appendChild(shuffleIcon);}
break;case'artist':case'album':case'title':var artistSpan;AlbumArtCache.getCoverURL(data).then(function(url){li.style.backgroundImage='url('+url+')';});if(option==='artist'){artistSpan=document.createElement('span');artistSpan.className='list-single-title';artistSpan.textContent=data.metadata.artist||navigator.mozL10n.get('unknownArtist');artistSpan.dataset.l10nId=data.metadata.artist?'':'unknownArtist';if(highlight){highlightText(artistSpan,highlight);}
a.appendChild(artistSpan);}else{var albumOrTitleSpan=document.createElement('span');artistSpan=document.createElement('span');albumOrTitleSpan.className='list-main-title';artistSpan.className='list-sub-title';if(option==='album'){albumOrTitleSpan.textContent=data.metadata.album||navigator.mozL10n.get('unknownAlbum');albumOrTitleSpan.dataset.l10nId=data.metadata.album?'':'unknownAlbum';}else{albumOrTitleSpan.textContent=data.metadata.title||navigator.mozL10n.get('unknownTitle');albumOrTitleSpan.dataset.l10nId=data.metadata.title?'':'unknownTitle';}
artistSpan.textContent=data.metadata.artist||navigator.mozL10n.get('unknownArtist');artistSpan.dataset.l10nId=data.metadata.artist?'':'unknownArtist';if(highlight){highlightText(albumOrTitleSpan,highlight);}
a.appendChild(albumOrTitleSpan);a.appendChild(artistSpan);}
a.dataset.keyRange=data.metadata[option];a.dataset.option=option;break;case'song':case'song-index':var songTitle=data.metadata.title||navigator.mozL10n.get('unknownTitle');var indexSpan=document.createElement('span');indexSpan.className='list-song-index';if(option==='song-index'){indexSpan.textContent=index+1;}else{var trackNum=data.metadata.tracknum;if(data.metadata.discnum&&data.multidisc){trackNum=data.metadata.discnum+'.'+
(trackNum<10?'0'+trackNum:trackNum);}
indexSpan.textContent=trackNum;}
titleSpan=document.createElement('span');titleSpan.className='list-song-title';titleSpan.textContent=songTitle;titleSpan.dataset.l10nId=data.metadata.title?'':'unknownTitle';var lengthSpan=document.createElement('span');lengthSpan.className='list-song-length';a.appendChild(indexSpan);a.appendChild(titleSpan);a.appendChild(lengthSpan);break;}
return li;};'use strict';var TYPE_MIX='mix';var TYPE_LIST='list';var TYPE_SINGLE='single';var TYPE_BLOB='blob';var REPEAT_OFF=0;var REPEAT_LIST=1;var REPEAT_SONG=2;var PLAYSTATUS_STOPPED='STOPPED';var PLAYSTATUS_PLAYING='PLAYING';var PLAYSTATUS_PAUSED='PAUSED';var PLAYSTATUS_FWD_SEEK='FWD_SEEK';var PLAYSTATUS_REV_SEEK='REV_SEEK';var INTERRUPT_BEGIN='mozinterruptbegin';var PlayerView={get view(){return document.getElementById('views-player');},get audio(){return document.getElementById('player-audio');},get playStatus(){return this._playStatus;},set playStatus(val){this._playStatus=val;},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;if(this.sourceType){if(this.sourceType===TYPE_MIX||this.sourceType===TYPE_LIST){this.shuffleButton.disabled=(this._dataSource.length<2);TitleBar.playerIcon.hidden=(this._dataSource.length<1);}else{this.shuffleButton.disabled=true;this.repeatButton.disabled=true;this.previousControl.disabled=true;this.nextControl.disabled=true;}}},init:function pv_init(){this.artist=document.getElementById('player-cover-artist');this.album=document.getElementById('player-cover-album');this.timeoutID;this.cover=document.getElementById('player-cover');this.coverImage=document.getElementById('player-cover-image');this.offscreenImage=new Image();this.shareButton=document.getElementById('player-cover-share');this.repeatButton=document.getElementById('player-album-repeat');this.shuffleButton=document.getElementById('player-album-shuffle');this.ratings=document.getElementById('player-album-rating').children;this.seekRegion=document.getElementById('player-seek-bar');this.seekBar=document.getElementById('player-seek-bar-progress');this.seekIndicator=document.getElementById('player-seek-bar-indicator');this.seekElapsed=document.getElementById('player-seek-elapsed');this.seekRemaining=document.getElementById('player-seek-remaining');this.playControl=document.getElementById('player-controls-play');this.previousControl=document.getElementById('player-controls-previous');this.nextControl=document.getElementById('player-controls-next');this.banner=document.getElementById('info-banner');this.isTouching=false;this.isFastSeeking=false;this.playStatus=PLAYSTATUS_STOPPED;this.pausedPosition=null;this.handle=null;this.dataSource=[];this.playingBlob=null;this.currentIndex=0;this.setSeekBar(0,0,0);this.intervalID=null;this.view.addEventListener('click',this);this.view.addEventListener('contextmenu',this);this.seekRegion.addEventListener('touchstart',this);this.seekRegion.addEventListener('touchmove',this);this.seekRegion.addEventListener('touchend',this);this.previousControl.addEventListener('touchend',this);this.nextControl.addEventListener('touchend',this);this.audio.addEventListener('play',this);this.audio.addEventListener('pause',this);this.audio.addEventListener('playing',this);this.audio.addEventListener('durationchange',this);this.audio.addEventListener('timeupdate',this);this.audio.addEventListener('ended',this);this.audio.addEventListener('mozinterruptbegin',this);this.audio.addEventListener('mozinterruptend',this);window.addEventListener('visibilitychange',this);window.addEventListener('storage',this._handleInterpageMessage.bind(this));this.endedTimer=null;navigator.mozL10n.ready(this.updateL10n.bind(this));},checkSCOStatus:function pv_checkSCOStatus(){if(typeof MusicComms!=='undefined'&&MusicComms.enabled){var SCOStatus=MusicComms.isSCOEnabled;this.playControl.disabled=this.previousControl.disabled=this.nextControl.disabled=SCOStatus;this.seekRegion.parentNode.classList.toggle('disabled',SCOStatus);this.banner.classList.toggle('visible',SCOStatus);}},clean:function pv_clean(){if(this.handle){musicdb.cancelEnumeration(this.handle);}
this.dataSource=[];this.playingBlob=null;},setSourceType:function pv_setSourceType(type){this.sourceType=type;},setDBInfo:function pv_setDBInfo(info){this.DBInfo=info;this.dataSource.length=info.count;},showInfo:function pv_showInfo(){this.cover.classList.add('slideOut');if(this.timeoutID){window.clearTimeout(this.timeoutID);}
this.timeoutID=window.setTimeout(function pv_hideInfo(){this.cover.classList.remove('slideOut');}.bind(this),5000);},setInfo:function pv_setInfo(fileinfo){var metadata=fileinfo.metadata;if(typeof ModeManager!=='undefined'){ModeManager.playerTitle=metadata.title;ModeManager.updateTitle();if(metadata.locked||App.pendingPick){this.shareButton.classList.add('hidden');this.artist.classList.add('hidden-cover-share');this.album.classList.add('hidden-cover-share');}else{this.shareButton.classList.remove('hidden');this.artist.classList.remove('hidden-cover-share');this.album.classList.remove('hidden-cover-share');}}else{var titleBar=document.getElementById('title-text');titleBar.textContent=metadata.title||navigator.mozL10n.get('unknownTitle');titleBar.dataset.l10nId=metadata.title?'':'unknownTitle';}
this.artist.textContent=metadata.artist||navigator.mozL10n.get('unknownArtist');this.artist.dataset.l10nId=metadata.artist?'':'unknownArtist';this.album.textContent=metadata.album||navigator.mozL10n.get('unknownAlbum');this.album.dataset.l10nId=metadata.album?'':'unknownAlbum';this.setCoverImage(fileinfo);},setCoverImage:function pv_setCoverImage(fileinfo){this.offscreenImage.src='';this.coverImage.classList.remove('fadeIn');AlbumArtCache.getCoverURL(fileinfo).then(function(url){this.offscreenImage.addEventListener('load',pv_showImage.bind(this));this.offscreenImage.src=url;}.bind(this));function pv_showImage(evt){evt.target.removeEventListener('load',pv_showImage);var url='url('+this.offscreenImage.src+')';this.coverImage.style.backgroundImage=url;this.coverImage.classList.add('fadeIn');}},setOptions:function pv_setOptions(settings){var repeatOption=(settings&&settings.repeat)?settings.repeat:REPEAT_OFF;var shuffleOption=(settings&&settings.shuffle)?settings.shuffle:false;this.setRepeat(repeatOption);this.setShuffle(shuffleOption);},setRepeat:function pv_setRepeat(value){var repeatModes=['repeat-off','repeat-list','repeat-song'];repeatModes.forEach(function pv_resetRepeat(targetClass){this.repeatButton.classList.remove(targetClass);}.bind(this));this.repeatOption=value;this.repeatButton.classList.add(repeatModes[this.repeatOption]);this.repeatButton.setAttribute('data-l10n-id',repeatModes[this.repeatOption]);},setShuffle:function pv_setShuffle(value,index){this.shuffleOption=value;if(this.shuffleOption){this.shuffleButton.classList.add('shuffle-on');if(arguments.length>1){this.shuffleList(this.currentIndex);}else{this.shuffleList();}}else{this.shuffleButton.classList.remove('shuffle-on');}
this.shuffleButton.setAttribute('aria-pressed',this.shuffleOption);},setRatings:function pv_setRatings(rated){for(var i=0;i<5;i++){var rating=this.ratings[i];if(i===rated-1){rating.setAttribute('aria-checked',true);}else{rating.setAttribute('aria-checked',false);}
if(i<rated){rating.classList.add('star-on');}else{rating.classList.remove('star-on');}}},shuffleList:function slv_shuffleList(index){if(this.dataSource.length===0){return;}
this.shuffleIndex=0;this.shuffledList=[];for(var i=0;i<this.dataSource.length;i++){this.shuffledList.push(i);}
if(arguments.length>0){var currentItem=this.shuffledList.splice(index,1);slv_shuffle(this.shuffledList);this.shuffledList=currentItem.concat(this.shuffledList);}else{slv_shuffle(this.shuffledList);}
function slv_shuffle(a){for(var i=a.length-1;i>=1;i--){var j=Math.floor(Math.random()*(i+1));if(j<i){var tmp=a[j];a[j]=a[i];a[i]=tmp;}}}},getMetadata:function pv_getMetadata(blob,callback){AudioMetadata.parse(blob).then(pv_gotMetadata,pv_metadataError.bind(this));function pv_gotMetadata(metadata){callback(metadata);}
function pv_metadataError(e){console.warn('parseAudioMetadata: error parsing metadata - ',e);if(this.onerror){this.onerror(e);}}},setAudioSrc:function pv_setAudioSrc(file){var url=URL.createObjectURL(file);this.playingBlob=file;this.audio.removeAttribute('src');this.audio.load();this.audio.mozAudioChannelType='content';this.audio.src=url;this.audio.load();this.audio.play();this.audio.onloadeddata=function(evt){URL.revokeObjectURL(url);};this.audio.onerror=(function(evt){if(this.onerror){this.onerror(evt);}}).bind(this);this.setSeekBar(0,0,0);if(this.endedTimer){clearTimeout(this.endedTimer);this.endedTimer=null;}},updateRemoteMetadata:function pv_updateRemoteMetadata(){if(typeof MusicComms==='undefined'||this.dataSource.length===0){return;}
var fileinfo=this.dataSource[this.currentIndex];var metadata=fileinfo.metadata;var notifyMetadata={title:metadata.title||navigator.mozL10n.get('unknownTitle'),artist:metadata.artist||navigator.mozL10n.get('unknownArtist'),album:metadata.album||navigator.mozL10n.get('unknownAlbum'),duration:this.audio.duration*1000,mediaNumber:this.currentIndex+1,totalMediaCount:this.dataSource.length};if(this.audio.currentTime===0){AlbumArtCache.getCoverBlob(fileinfo).then(function(blob){notifyMetadata.picture=blob;MusicComms.notifyMetadataChanged(notifyMetadata);});}
else{MusicComms.notifyMetadataChanged(notifyMetadata);}},updateRemotePlayStatus:function pv_updateRemotePlayStatus(){if(typeof MusicComms==='undefined'){return;}
var position=this.pausedPosition?this.pausedPosition:this.audio.currentTime;var info={playStatus:this.playStatus,duration:this.audio.duration*1000,position:position*1000};this.pausedPosition=(this.playStatus===PLAYSTATUS_PLAYING)?null:this.audio.currentTime;MusicComms.notifyStatusChanged(info);},getSongData:function pv_getSongData(index,callback){var info=this.DBInfo;var songData=this.dataSource[index];if(songData){callback(songData);}else{ListView.cancelEnumeration();var handle=musicdb.advancedEnumerate(info.key,info.range,info.direction,index,function(record){musicdb.cancelEnumeration(handle);this.dataSource[index]=record;callback(record);}.bind(this));}},getFile:function pv_getFile(songData,callback){if(!songData.metadata.locked){musicdb.getFile(songData.name,callback);return;}
musicdb.getFile(songData.name,function(locked){ForwardLock.getKey(function(secret){ForwardLock.unlockBlob(secret,locked,function(unlocked){callback(unlocked);},null,function(msg){console.error(msg);callback(null);});});});},PLAYER_IS_OCCUPIED_BY:'music-player-is-occupied-by',_handleInterpageMessage:function(evt){if(evt.key===this.PLAYER_IS_OCCUPIED_BY){if(evt.newValue&&evt.newValue!==location.href){this.pause();}}},_sendInterpageMessage:function(){window.localStorage.setItem(this.PLAYER_IS_OCCUPIED_BY,location.href);},_clearInterpageMessage:function(){var whoIsPlaying=window.localStorage.getItem(this.PLAYER_IS_OCCUPIED_BY);if(whoIsPlaying&&whoIsPlaying===window.location.href){window.localStorage.removeItem(this.PLAYER_IS_OCCUPIED_BY);}},play:function pv_play(targetIndex){this.checkSCOStatus();this._sendInterpageMessage();this.showInfo();if(arguments.length>0){this.getSongData(targetIndex,function(songData){this.currentIndex=targetIndex;this.setInfo(songData);this.setRatings(songData.metadata.rated);songData.metadata.played++;musicdb.updateMetadata(songData.name,songData.metadata);this.getFile(songData,function(file){this.setAudioSrc(file);if(this.sourceType===TYPE_SINGLE||MusicComms.isSCOEnabled){this.pause();}}.bind(this));}.bind(this));}else if(this.sourceType===TYPE_BLOB&&!this.audio.src){this.getMetadata(this.dataSource,function(metadata){this.setInfo({metadata:metadata,name:this.dataSource.name,blob:this.dataSource});this.setAudioSrc(this.dataSource);}.bind(this));}else{this.audio.play();}},pause:function pv_pause(){this.checkSCOStatus();this._clearInterpageMessage();this.audio.pause();},stop:function pv_stop(){this.pause();this.audio.removeAttribute('src');this.audio.load();this.clean();if(typeof ModeManager!=='undefined'){ModeManager.playerTitle=null;if(ModeManager.currentMode===MODE_PLAYER){ModeManager.pop();}else{ModeManager.updateTitle();}}
this.playStatus=PLAYSTATUS_STOPPED;this.updateRemotePlayStatus();},next:function pv_next(isAutomatic){if(this.sourceType===TYPE_BLOB||this.sourceType===TYPE_SINGLE){this.setAudioSrc(this.playingBlob);this.pause();return;}
if(this.repeatOption===REPEAT_SONG&&isAutomatic){this.play(this.currentIndex);return;}
var playingIndex=(this.shuffleOption)?this.shuffleIndex:this.currentIndex;if(playingIndex>=this.dataSource.length-1){if(this.repeatOption===REPEAT_LIST){if(this.shuffleOption){this.shuffleList(this.shuffledList[0]);}else{this.currentIndex=0;}}else{this.stop();return;}}else{if(this.shuffleOption){this.shuffleIndex++;}else{this.currentIndex++;}}
var realIndex=(this.shuffleOption)?this.shuffledList[this.shuffleIndex]:this.currentIndex;this.play(realIndex);},previous:function pv_previous(){if(this.audio.currentTime>3){this.play(this.currentIndex);return;}
var playingIndex=(this.shuffleOption)?this.shuffleIndex:this.currentIndex;if(playingIndex<=0){var newIndex=(this.repeatOption===REPEAT_LIST)?this.dataSource.length-1:0;if(this.shuffleOption){this.shuffleIndex=newIndex;}else{this.currentIndex=newIndex;}}else{if(this.shuffleOption){this.shuffleIndex--;}else{this.currentIndex--;}}
var realIndex=(this.shuffleOption)?this.shuffledList[this.shuffleIndex]:this.currentIndex;this.play(realIndex);},startFastSeeking:function pv_startFastSeeking(direction){this.isTouching=this.isFastSeeking=true;var offset=direction*2;this.prevPlayStatus=this.playStatus;this.playStatus=direction?PLAYSTATUS_FWD_SEEK:PLAYSTATUS_REV_SEEK;this.updateRemotePlayStatus();this.intervalID=window.setInterval(function(){this.seekAudio(this.audio.currentTime+offset);}.bind(this),15);},stopFastSeeking:function pv_stopFastSeeking(){this.isTouching=this.isFastSeeking=false;if(this.intervalID){window.clearInterval(this.intervalID);}
this.playStatus=this.prevPlayStatus;this.prevPlayStatus=null;this.updateRemotePlayStatus();},updateSeekBar:function pv_updateSeekBar(){if(this.isTouching){return;}
if(typeof ModeManager==='undefined'||ModeManager.currentMode===MODE_PLAYER){this.seekAudio();}},seekAudio:function pv_seekAudio(seekTime){if(seekTime!==undefined){this.audio.currentTime=Math.floor(seekTime);}
var startTime=this.audio.startTime;var endTime;if(isNaN(this.audio.duration)){endTime=0;}else if(this.audio.duration===Infinity){endTime=(this.audio.buffered.length>0)?this.audio.buffered.end(this.audio.buffered.length-1):0;}else{endTime=this.audio.duration;}
var currentTime=this.audio.currentTime;this.setSeekBar(startTime,endTime,currentTime);},setSeekBar:function pv_setSeekBar(startTime,endTime,currentTime){this.seekBar.min=startTime;this.seekBar.max=endTime;this.seekBar.value=currentTime;var ratio=(endTime!==0)?(currentTime/endTime):0;var x=(ratio*this.seekBar.offsetWidth-
this.seekIndicator.offsetWidth/2);if(this.isLTR){x=x+'px';}else{if(x<0){x=Math.abs(x)+'px';}else{x='-'+x+'px';}}
this.seekIndicator.style.transform='translateX('+x+')';this.seekElapsed.textContent=formatTime(currentTime);var remainingTime=endTime-currentTime;this.seekRemaining.textContent=(remainingTime>0)?'-'+formatTime(remainingTime):'---:--';},share:function pv_shareFile(){var songData=this.dataSource[this.currentIndex];if(songData.metadata.locked){return;}
musicdb.getFile(songData.name,function(file){AlbumArtCache.getCoverBlob(songData).then(function(pictureBlob){var filename=songData.name,name=filename.substring(filename.lastIndexOf('/')+1);var activityData={type:'audio/*',number:1,blobs:[file],filenames:[name],filepaths:[filename],metadata:[{title:songData.metadata.title,artist:songData.metadata.artist,album:songData.metadata.album,picture:pictureBlob}]};if(PlayerView.playStatus!==PLAYSTATUS_PLAYING){var a=new MozActivity({name:'share',data:activityData});a.onerror=function(e){console.warn('share activity error:',a.error.name);};}
else{(function(){var hack_activity_property='_hack_hack_shut_up';var hack_setting_property='music._hack.pause_please';navigator.mozSettings.addObserver(hack_setting_property,observer);activityData[hack_activity_property]=hack_setting_property;var a=new MozActivity({name:'share',data:activityData});a.onerror=a.onsuccess=cleanup;function observer(e){PlayerView.pause();}
function cleanup(){navigator.mozSettings.removeObserver(hack_setting_property,observer);if(PlayerView.playStatus===PLAYSTATUS_PAUSED){PlayerView.play();}}}());}});});},handleEvent:function pv_handleEvent(evt){var target=evt.target;if(!target){return;}
switch(evt.type){case'click':switch(target.id){case'player-cover':case'player-cover-image':this.showInfo();break;case'player-controls-play':if(this.playControl.classList.contains('is-pause')){this.play();}else{this.pause();}
break;case'player-album-repeat':this.showInfo();var newValue=++this.repeatOption%3;asyncStorage.setItem(SETTINGS_OPTION_KEY,{repeat:newValue,shuffle:this.shuffleOption});this.setRepeat(newValue);break;case'player-album-shuffle':this.showInfo();asyncStorage.setItem(SETTINGS_OPTION_KEY,{repeat:this.repeatOption,shuffle:!this.shuffleOption});this.setShuffle(!this.shuffleOption,this.currentIndex);break;case'player-cover-share':this.share();break;}
if(target.dataset.rating){this.showInfo();var songData=this.dataSource[this.currentIndex];var targetRating=parseInt(target.dataset.rating,10);var newRating=(targetRating===songData.metadata.rated)?targetRating-1:targetRating;songData.metadata.rated=newRating;musicdb.updateMetadata(songData.name,songData.metadata);this.setRatings(newRating);}
break;case'play':this.playControl.classList.remove('is-pause');this.playStatus=PLAYSTATUS_PLAYING;this.playControl.setAttribute('data-l10n-id','playbackPause');this.updateRemotePlayStatus();break;case'pause':this.playControl.classList.add('is-pause');this.playStatus=PLAYSTATUS_PAUSED;this.playControl.setAttribute('data-l10n-id','playbackPlay');this.updateRemotePlayStatus();break;case'touchstart':case'touchmove':if(evt.type==='touchstart'){this.isTouching=true;this.seekIndicator.classList.add('highlight');}
if(this.isTouching&&this.audio.duration>0){var touch=evt.touches[0];var x=(touch.clientX-target.offsetLeft)/target.offsetWidth;if(x<0){x=0;}
if(x>1){x=1;}
if(this.isLTR){this.seekTime=x*this.seekBar.max;}else{this.seekTime=this.audio.duration-x*this.seekBar.max;}
this.setSeekBar(this.audio.startTime,this.audio.duration,this.seekTime);}
break;case'touchend':if(this.isFastSeeking){this.stopFastSeeking();}else if(target.id==='player-seek-bar'){this.seekIndicator.classList.remove('highlight');if(this.audio.duration>0&&this.isTouching){this.seekAudio(this.seekTime);this.seekTime=0;}
this.isTouching=false;}else if(target.id==='player-controls-previous'){this.previous();}else if(target.id==='player-controls-next'){this.next();}
break;case'contextmenu':if(target.id==='player-controls-next'){this.startFastSeeking(1);}else if(target.id==='player-controls-previous'){this.startFastSeeking(-1);}
break;case'durationchange':case'timeupdate':this.updateSeekBar();if(evt.type==='durationchange'||this.audio.currentTime===0){this.updateRemoteMetadata();}
if(this.audio.currentTime>=this.audio.duration-1&&this.endedTimer==null){var timeToNext=(this.audio.duration-this.audio.currentTime+1);this.endedTimer=setTimeout(function(){this.next(true);}.bind(this),timeToNext*1000);}
break;case'ended':if(!this.endedTimer){this.next(true);}
break;case'visibilitychange':if(document.hidden){this.audio.removeEventListener('timeupdate',this);}else{this.audio.addEventListener('timeupdate',this);this.updateSeekBar();}
break;case'mozinterruptbegin':this.playStatus=INTERRUPT_BEGIN;this.updateRemotePlayStatus();break;case'mozinterruptend':this.playStatus=PLAYSTATUS_PLAYING;this.updateRemotePlayStatus();break;default:return;}},updateL10n:function pv_updateL10n(){this.isLTR=navigator.mozL10n.language.direction==='ltr'?true:false;}};;'use strict';navigator.mozL10n.once(function onLocalizationInit(){navigator.mozSetMessageHandler('activity',handleOpenActivity);});function handleOpenActivity(request){var data=request.source.data;var blob=request.source.data.blob;var header=document.getElementById('header');var saveButton=document.getElementById('title-save');var banner=document.getElementById('banner');var message=document.getElementById('message');var storage;var saved=false;if(data.allowSave&&data.filename&&checkFilename()){saveButton.hidden=false;saveButton.disabled=true;header.runFontFit();getStorageIfAvailable('music',blob.size,function(ds){storage=ds;saveButton.disabled=false;});}
playBlob(blob);function playBlob(blob){PlayerView.init();PlayerView.stop();PlayerView.setSourceType(TYPE_BLOB);PlayerView.dataSource=blob;PlayerView.play();PlayerView.onerror=function invalid(){alert(navigator.mozL10n.get('audioinvalid'));done();};}
header.addEventListener('action',done);saveButton.addEventListener('click',save);window.addEventListener('visibilitychange',function onVisibilityChanged(){if(document.hidden){done();}});function done(){PlayerView.stop();request.postResult({saved:saved});}
function save(){saveButton.hidden=true;document.getElementById('title-text').textContent=document.getElementById('title-text').textContent;getUnusedFilename(storage,data.filename,function(filename){var savereq=storage.addNamed(blob,filename);savereq.onsuccess=function(){saved=filename;showBanner(navigator.mozL10n.get('saved',{title:document.getElementById('title-text').textContent}));};savereq.onerror=function(e){console.error('Error saving',filename,e);};});}
function checkFilename(){var dotIdx=data.filename.lastIndexOf('.'),ext;if(dotIdx>-1){ext=data.filename.substr(dotIdx+1);if(ext==='ogg'){return true;}else{return MimeMapper.guessTypeFromExtension(ext)===blob.type;}}else{return false;}}
function showBanner(msg){message.textContent=msg;banner.hidden=false;setTimeout(function(){banner.hidden=true;},3000);}}