define([ "require", "tmpl!./tng/account_settings_server.html", "tmpl!./tng/account_delete_confirm.html", "evt", "l10n!", "cards", "confirm_dialog", "./base", "template!./settings_account.html", "./account_prefs_mixins" ], function(e) {
    var t = e("tmpl!./tng/account_settings_server.html"), n = e("tmpl!./tng/account_delete_confirm.html"), i = e("evt"), s = e("l10n!"), o = e("cards"), a = e("confirm_dialog");
    return [ e("./base")(e("template!./settings_account.html")), e("./account_prefs_mixins"), {
        onArgs: function(e) {
            this.account = e.account, this.identity = this.account.identities[0], this.headerLabel.textContent = e.account.name, 
            this._bindPrefs("tng-account-check-interval", "tng-notify-mail", "tng-sound-onsend", "tng-signature-input", "signature-button"), 
            this.accountNameNode.textContent = this.identity && this.identity.name || this.account.name, 
            this.accountTypeNode.textContent = "activesync" === this.account.type ? "ActiveSync" : "imap+smtp" === this.account.type ? "IMAP+SMTP" : "POP3+SMTP", 
            this.account.isDefault ? (this.defaultInputNode.disabled = !0, this.defaultInputNode.checked = !0) : this.defaultLabelNode.addEventListener("click", this.onChangeDefaultAccount.bind(this), !1), 
            "activesync" === this.account.type ? this.synchronizeNode.value = this.account.syncRange : this.syncSettingNode.parentNode.removeChild(this.syncSettingNode), 
            this.account.servers.forEach(function(e, n) {
                var i = t.cloneNode(!0), o = i.querySelector(".tng-account-server-label");
                s.setAttributes(o, "settings-" + e.type + "-label"), o.addEventListener("click", this.onClickServers.bind(this, n), !1), 
                this.serversContainer.appendChild(i);
            }.bind(this));
            var n = "settings-account-userpass";
            "oauth2" === this.account.authMechanism && (n = "settings-account-useroauth2"), 
            s.setAttributes(this.accountCredNode, n);
        },
        onBack: function() {
            o.removeCardAndSuccessors(this, "animate", 1);
        },
        onCardVisible: function() {
            this.updateSignatureButton();
        },
        onClickCredentials: function() {
            o.pushCard("settings_account_credentials", "animate", {
                account: this.account
            }, "right");
        },
        onClickServers: function(e) {
            o.pushCard("settings_account_servers", "animate", {
                account: this.account,
                index: e
            }, "right");
        },
        onChangeDefaultAccount: function(e) {
            e.stopPropagation(), e.preventBubble && e.preventBubble(), this.defaultInputNode.disabled || (this.defaultInputNode.disabled = !0, 
            this.defaultInputNode.checked = !0, this.account.modifyAccount({
                setAsDefault: !0
            }));
        },
        onChangeSynchronize: function(e) {
            this.account.modifyAccount({
                syncRange: e.target.value
            });
        },
        onDelete: function() {
            var e = this.account, t = n.cloneNode(!0), o = t.getElementsByTagName("p")[0];
            s.setAttributes(o, "settings-account-delete-prompt", {
                account: e.name
            }), a.show(t, {
                id: "account-delete-ok",
                handler: function() {
                    e.deleteAccount(), i.emit("accountDeleted", e);
                }
            }, {
                id: "account-delete-cancel",
                handler: null
            });
        },
        die: function() {}
    } ];
});