;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::(?:\/\/)?)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},_getScheme:function(input){return(rscheme.exec(input)||[])[0];},hasScheme:function(input){return!!this._getScheme(input);},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data|view-source)\:/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)||this._getScheme(str)===str){return true;}
if(case3Reg.test(str)){return false;}
if(!this.hasScheme(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;'use strict';(function(exports){var datastore;var DATASTORE_NAME='bookmarks_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('ds-initialized',function oninitalized(){document.removeEventListener('ds-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Bookmark store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Bookmark store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('ds-initialized'));resolve();},reject);});}
function doGetAll(resolve,reject){var result=Object.create(null);var cursor=datastore.sync();function cursorResolve(task){switch(task.operation){case'update':case'add':result[task.data.id]=task.data;break;case'remove':delete result[task.data.id];break;case'clear':result=Object.create(null);break;case'done':resolve(result);return;}
cursor.next().then(cursorResolve,reject);}
cursor.next().then(cursorResolve,reject);}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function getAll(){return new Promise(function doGet(resolve,reject){init().then(doGetAll.bind(null,resolve,reject),reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:result||event});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function add(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){var id=data.url;Object.defineProperty(data,'id',{enumerable:true,configurable:false,writable:false,value:id});datastore.add(data,id).then(function add_success(){resolve(true);},function add_error(){datastore.put(data,id).then(function put_success(){resolve();},reject);});},reject);});}
function getRevisionId(){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){resolve(datastore.revisionId);},reject);});}
function put(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(data,data.id).then(function success(){resolve();},reject);},reject);});}
function remove(id){return new Promise(function doRemove(resolve,reject){init().then(function onInitialized(){datastore.remove(id).then(resolve,reject);},reject);});}
function clear(){return new Promise(function doClear(resolve,reject){init().then(function onInitialized(){datastore.clear().then(resolve,reject);},reject);});}
exports.BookmarksDatabase={get:get,getAll:getAll,getRevisionId:getRevisionId,addEventListener:addEventListener,removeEventListener:removeEventListener,add:add,put:put,remove:remove,clear:clear};}(window));;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;'use strict';(function(exports){const SHADOW_BLUR=1;const SHADOW_OFFSET_Y=1;const SHADOW_OFFSET_X=1;const SHADOW_COLOR='rgba(0, 0, 0, 0.2)';const DEFAULT_BACKGROUND_COLOR='rgb(228, 234, 238)';const UNSCALED_CANVAS_PADDING=2;const CANVAS_PADDING=UNSCALED_CANVAS_PADDING*devicePixelRatio;function IconRenderer(icon){this._icon=icon;}
IconRenderer.TYPE={CLIP:'clip',FAVICON:'favicon',STANDARD:'standard',};IconRenderer.prototype={unscaledCanvasPadding:UNSCALED_CANVAS_PADDING*2,get _maxSize(){return this._icon.grid.layout.gridMaxIconSize;},_createCanvas:function(){var canvas=document.createElement('canvas');canvas.width=this._maxSize+(CANVAS_PADDING*2);canvas.height=this._maxSize+(CANVAS_PADDING*2);return canvas;},_decorateShadowCanvas:function(canvas){var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.shadowColor=SHADOW_COLOR;ctx.shadowBlur=SHADOW_BLUR;ctx.shadowOffsetY=SHADOW_OFFSET_Y;ctx.shadowOffsetX=SHADOW_OFFSET_X;return ctx;},clip:function(img){return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);var clipCanvas=this._createCanvas();var clipCtx=clipCanvas.getContext('2d',{willReadFrequently:true});clipCtx.beginPath();clipCtx.arc(clipCanvas.width/2,clipCanvas.height/2,clipCanvas.height/2,0,2*Math.PI);clipCtx.clip();clipCtx.drawImage(img,0,0,clipCanvas.width,clipCanvas.height);shadowCtx.drawImage(clipCanvas,CANVAS_PADDING,CANVAS_PADDING,this._maxSize,this._maxSize);shadowCanvas.toBlob(resolve);});},favicon:function(img){if(img.width>this._icon.grid.layout.gridIconSize/2){return this.clip(img);}
return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);var iconWidth;var iconHeight;shadowCtx.beginPath();shadowCtx.arc(shadowCanvas.width/2,shadowCanvas.height/2,shadowCanvas.height/2-CANVAS_PADDING,0,2*Math.PI,false);shadowCtx.fillStyle=DEFAULT_BACKGROUND_COLOR;shadowCtx.fill();iconWidth=iconHeight=this._maxSize*0.55;shadowCtx.shadowBlur=0;shadowCtx.shadowOffsetY=0;shadowCtx.mozImageSmoothingEnabled=false;shadowCtx.drawImage(img,(shadowCanvas.width-iconWidth)/2,(shadowCanvas.height-iconHeight)/2,iconWidth,iconHeight);shadowCanvas.toBlob(resolve);});},standard:function(img){return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);shadowCtx.drawImage(img,CANVAS_PADDING,CANVAS_PADDING,this._maxSize,this._maxSize);shadowCanvas.toBlob(resolve);});}};exports.GridIconRenderer=IconRenderer;}(window));;'use strict';(function(exports){const FETCH_XHR_TIMEOUT=10000;function fetchBlob(uri){return new Promise(function(accept,reject){var xhr=new XMLHttpRequest({mozAnon:true,mozSystem:true});xhr.open('GET',uri,true);xhr.responseType='blob';xhr.timeout=FETCH_XHR_TIMEOUT;xhr.send();xhr.onload=function(){var status=xhr.status;if(status!==0&&status!==200){reject(new Error('Got HTTP status '+status+' trying to load '+uri));return;}
accept(xhr.response);};xhr.onerror=xhr.ontimeout=function(){reject(new Error('Error while HTTP GET: ',uri));};});}
function Icon(elem,uri){this.elem=elem;this.uri=uri;}
Icon.prototype={get size(){return 40;},render:function render(options){options=options||{};var size=(options.size||this.size)*devicePixelRatio;var style=this.elem.style;style.backgroundSize=style.width=style.height=size+'px';var uri=this.uri;if(!uri){return;}
fetchBlob(uri).then((blob)=>{var img=new Image();img.src=URL.createObjectURL(blob);img.onload=()=>{var renderer=new GridIconRenderer({grid:{layout:{get gridIconSize(){return size;},get gridMaxIconSize(){return size*devicePixelRatio;}}}});var type=options.type||GridIconRenderer.TYPE.FAVICON;renderer[type](img).then((blob)=>{var url=URL.createObjectURL(blob);style.backgroundImage='url('+url+')';});URL.revokeObjectURL(img.src);};});}};exports.Icon=Icon;}(window));;'use strict';var BookmarkEditor={BOOKMARK_ICON_SIZE:60,init:function bookmarkEditor_show(options){this.data=options.data;this.onsaved=options.onsaved;this.oncancelled=options.oncancelled;var mode='add';BookmarksDatabase.get(this.data.url).then((function got(bookmark){if(bookmark){this.data=bookmark;mode='put';}
this._init(mode);}).bind(this),this._init.bind(this,mode));},_init:function bookmarkEditor_init(mode){var _=navigator.mozL10n.get;this.mode=document.body.dataset.mode=mode;this.bookmarkTitle=document.getElementById('bookmark-title');this.bookmarkIcon=document.getElementById('bookmark-icon');this.cancelButton=document.getElementById('cancel-button');this.saveButton=document.getElementById('done-button');this.appInstallationSection=document.getElementById('app-installation');this.appNameText=document.getElementById('app-name');this.installAppButton=document.getElementById('install-app-button');this.cancelButton.addEventListener('click',this.close.bind(this));this.saveListener=this.save.bind(this);this.saveButton.addEventListener('click',this.saveListener);this.bookmarkTitle.value=this.data.name||'';this._renderIcon();if(this.data.manifestURL){this.manifestURL=this.data.manifestURL;this._fetchManifest(this.manifestURL);}
this._checkDoneButton();this.form=document.getElementById('bookmark-form');this.form.addEventListener('input',this._checkDoneButton.bind(this));this.form.addEventListener('submit',this._submit.bind(this));var touchstart='ontouchstart'in window?'touchstart':'mousedown';this.clearButton=document.getElementById('bookmark-title-clear');this.clearButton.addEventListener(touchstart,this._clearTitle.bind(this));if(mode==='put'){this._onEditMode();this.saveButton.textContent=_('done-action');}else{this.saveButton.textContent=_('add-action');}
window.dispatchEvent(new CustomEvent('lazyload',{detail:document.body}));},_renderIcon:function renderIcon(){var icon=new Icon(this.bookmarkIcon,this.data.icon);icon.render({'size':this.BOOKMARK_ICON_SIZE});},_fetchManifest:function bookmarkEditor_fetchManifest(manifestURL){var manifestPromise=window.WebManifestHelper.getManifest(manifestURL);manifestPromise.then((function(manifestData){if(manifestData){this.installAppButtonListener=this._installApp.bind(this);this.installAppButton.addEventListener('click',this.installAppButtonListener);this.appInstallationSection.classList.remove('hidden');this.appNameText.textContent=manifestData.short_name||manifestData.name;}}).bind(this)).catch(function(error){console.error('Unable to get web manifest: '+error);});return manifestPromise;},_onEditMode:function bookmarkEditor_onEditMode(){this.saveButton.disabled=true;},close:function bookmarkEditor_close(){this.oncancelled();},_submit:function(event){event.preventDefault();this.save();},_clearTitle:function bookmarkEditor_clearTitle(event){event.preventDefault();this.bookmarkTitle.value='';this._checkDoneButton();},_checkDoneButton:function bookmarkEditor_checkDoneButton(){var title=this.bookmarkTitle.value.trim();this.saveButton.disabled=title==='';},_installApp:function bookmarkEditor_installApp(){window.navigator.mozApps.install(this.manifestURL);},save:function bookmarkEditor_save(evt){this.saveButton.removeEventListener('click',this.saveListener);if(this.installAppButtonListener){this.installAppButton.removeEventListener('click',this.installAppButtonListener);}
var url=this.data.url.trim();if(UrlHelper.isNotURL(url)){this.oncancelled();return;}
this.data.name=this.bookmarkTitle.value;this.data.url=url;BookmarksDatabase[this.mode](this.data).then(this.onsaved.bind(this),this.close.bind(this));}};;'use strict';window.utils=window.utils||{};window.utils.status=(function(){var DISPLAYED_TIME=1500;var section,content;var timeoutID;function clearHideTimeout(){if(timeoutID===null){return;}
window.clearTimeout(timeoutID);timeoutID=null;}
function show(message,duration){clearHideTimeout();content.innerHTML='';if(typeof message==='string'){content.textContent=message;}else{try{content.appendChild(message);}catch(ex){console.error('DOMException: '+ex.message);}}
section.classList.remove('hidden');section.classList.add('onviewport');timeoutID=window.setTimeout(hide,duration||DISPLAYED_TIME);}
function animationEnd(evt){var eventName='status-showed';if(evt.animationName==='hide'){clearHideTimeout();section.classList.add('hidden');eventName='status-hidden';}
window.dispatchEvent(new CustomEvent(eventName));}
function hide(){section.classList.remove('onviewport');}
function destroy(){section.removeEventListener('animationend',animationEnd);document.body.removeChild(section);clearHideTimeout();section=content=null;}
function getPath(){return'/js/components/';}
function initialize(){if(section){return;}
section=document.createElement('section');var link=document.createElement('link');link.type='text/css';link.rel='stylesheet';link.href=getPath()+'status-behavior.css';document.head.appendChild(link);section.setAttribute('role','status');section.classList.add('hidden');content=document.createElement('p');section.appendChild(content);section.addEventListener('animationend',animationEnd);setTimeout(function append(){document.body.appendChild(section);});}
if(document.readyState==='complete'){initialize();}else{document.addEventListener('DOMContentLoaded',function loaded(){document.removeEventListener('DOMContentLoaded',loaded);initialize();});}
return{init:initialize,show:show,hide:hide,destroy:destroy,setDuration:function setDuration(time){DISPLAYED_TIME=time||DISPLAYED_TIME;}};})();;'use strict';var ActivityHandler={'save-bookmark':function ah_save(activity){BookmarkEditor.init({data:activity.source.data,onsaved:function onsaved(saved){window.addEventListener('status-hidden',function hidden(){window.removeEventListener('status-hidden',hidden);activity.postResult(saved?'saved':'updated');});utils.status.show(navigator.mozL10n.get(saved?'added-to-home-screen-message':'updated-bookmark'));},oncancelled:function oncancelled(){activity.postError('cancelled');}});},'remove-bookmark':function ah_remove(activity){BookmarkRemover.init({id:activity.source.data.url,onremoved:function onremoved(){activity.postResult('removed');},oncancelled:function oncancelled(e){activity.postError(e);}});}};navigator.mozSetMessageHandler('activity',function onActivity(activity){var name=activity.source.name;switch(name){case'save-bookmark':case'remove-bookmark':if(activity.source.data.type==='url'){ActivityHandler[name](activity);}else{activity.postError('type not supported');}
break;default:activity.postError('name not supported');}});;'use strict';(function WebManifestHelper(exports){var getManifest=function(url){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('get',url,true);xhr.responseType='json';xhr.setRequestHeader('Accept','application/manifest+json');xhr.onload=function(){var status=xhr.status;if(status==200){resolve(xhr.response);}else{reject(status);}};xhr.onerror=function(e){console.error('Unable to get web manifest');reject(e.target.status);};xhr.send();});};exports.WebManifestHelper={getManifest:getManifest};})(window);