;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,value,ast){var pos,v;if(value.indexOf('{{')!==-1){value=this.parseString(value);}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v===undefined?null:node.$v,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
var value;if(Array.isArray(node)){value=node;}
return{id:id,value:value||node.$v||null,index:node.$x||null,env:env,dirty:false};}
function format(args,entity){if(typeof entity==='string'){return entity;}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var val;try{val=resolveValue(args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return val;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return env['__'+id];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return args[id];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(args,env,id){var value;try{value=resolveIdentifier(args,env,id);}catch(err){return'{{ '+id+' }}';}
if(typeof value==='number'){return value;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
return value;}
return'{{ '+id+' }}';}
function interpolate(args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return prev+cur;}else if(cur.t==='idOrVar'){return prev+subPlaceable(args,env,cur.v);}},'');}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName);if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1]):undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(args,env,expr,index){if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'||!expr){return expr;}
if(Array.isArray(expr)){return interpolate(args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(args,env,expr[selector]);}}
if('other'in expr){return resolveValue(args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;(key=keys[i]);i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function replaceChars(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\}|&[#\w]+;)/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return replaceChars(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO={'qps-ploc':new Pseudo('qps-ploc','Runtime Accented',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Runtime Mirrored',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo()?this.ctx.defaultLocale:id);}
Locale.prototype.isPseudo=function(){return this.ctx.qps.indexOf(this.id)!==-1;};var bindingsIO={extra:function(id,ver,path,type,callback,errback){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo()?ctx.defaultLocale:this.id;var appVersion=null;var source='app';if(typeof(navigator)!=='undefined'){source=navigator.mozL10n._config.localeSources[this.id]||'app';appVersion=navigator.mozL10n._config.appVersion;}
for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo()?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0,node;node=ast[i];i++){this.entries[node.$i]=createEntry(node,this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.qps=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);return entity.id;}}
function formatEntity(args,entity){if(!entity.attrs){return{value:formatValue.call(this,args,entity),attrs:null};}
var formatted={value:formatValue.call(this,args,entity),attrs:Object.create(null)};for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){var supportedLocale;for(var i=0;i<requested.length;i++){var locale=requested[i];if(available.indexOf(locale)!==-1){supportedLocale=locale;break;}}
if(!supportedLocale||supportedLocale===defaultLocale){return[defaultLocale];}
return[supportedLocale,defaultLocale];}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];this.qps=Object.keys(PSEUDO);if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);var pos=this.qps.indexOf(loc);if(pos!==-1){this.qps.splice(pos,1);}}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var supported=negotiate(this.availableLocales.concat(this.qps),requested,this.defaultLocale);if(this.supportedLocales[0]!==supported[0]){freeze.call(this,supported);}};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=navigator.mozL10n.ctx.qps.indexOf(navigator.language)===-1&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(!pretranslate){initObserver();}
initResources.call(navigator.mozL10n);}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
var allowedHtmlAttrs={'ariaLabel':'aria-label','ariaValueText':'aria-valuetext','ariaMozHint':'aria-moz-hint','label':'label','placeholder':'placeholder','title':'title'};function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(!entity){return false;}
if(typeof entity.value==='string'){setTextContent.call(this,l10n.id,element,entity.value);}
for(var key in entity.attrs){var attr=entity.attrs[key];if(allowedHtmlAttrs.hasOwnProperty(key)){element.setAttribute(allowedHtmlAttrs[key],attr);}else if(key==='innerHTML'){element.innerHTML=attr;}}
return true;}
function setTextContent(id,element,text){if(element.firstElementChild){throw new L10nError('setTextContent is deprecated (https://bugzil.la/1053629). '+'Setting text content of elements with child elements is no longer '+'supported by l10n.js. Offending data-l10n-id: "'+id+'" on element '+element.outerHTML+' in '+this.ctx.id);}
element.textContent=text;}})(this);;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;(function(exports){'use strict';const kEventName='statechange';const kCommunicationKey='airplaneMode.enabled';const kStatusKey='airplaneMode.status';var AirplaneModeHelper={_mozSettings:window.navigator.mozSettings,_callbacks:[],_cachedStatus:'',ready:function(cb){if(this._cachedStatus===''){var self=this;this.addEventListener(kEventName,function onChangeEvent(){if(self._cachedStatus!==''){self.removeEventListener(kEventName,onChangeEvent);cb();}});}else{cb();}},getStatus:function(){return this._cachedStatus;},addEventListener:function(eventName,callback){if(eventName===kEventName){this._callbacks.push(callback);}},removeEventListener:function(eventName,callback){if(eventName===kEventName){var index=this._callbacks.indexOf(callback);if(index>=0){this._callbacks.splice(index,1);}}},setEnabled:function(enabled){this.ready(function(){var status=this.getStatus();if(status==='enabling'||status==='disabling'){}else{if(enabled&&status==='enabled'||!enabled&&status==='disabled'){return;}
var setObj={};setObj[kCommunicationKey]=enabled;this._mozSettings.createLock().set(setObj);}}.bind(this));},init:function(){var self=this;var lock=window.navigator.mozSettings.createLock();var req=lock.get(kStatusKey);req.onsuccess=function(){self._cachedStatus=req.result[kStatusKey];self._callbacks.forEach(function(callback){callback(self._cachedStatus);});};this._mozSettings.addObserver(kStatusKey,function(evt){var currentStatus=evt.settingValue;self._cachedStatus=currentStatus;self._callbacks.forEach(function(callback){callback(currentStatus);});});}};exports.AirplaneModeHelper=AirplaneModeHelper;AirplaneModeHelper.init();})(this);;'use strict';(function(window){window.mozPerformance={timing:{}};function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();var epoch=Date.now();setTimeout(function(){var detail={name:name,timestamp:now,epoch:epoch};var event=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(event);});}
['moz-chrome-dom-loaded','moz-chrome-interactive','moz-app-visually-complete','moz-content-interactive','moz-app-loaded'].forEach(function(eventName){window.addEventListener(eventName,function mozPerfLoadHandler(){dispatch(eventName);},false);});window.PerformanceTestingHelper={dispatch:dispatch};})(window);;'use strict';function $(id){return document.getElementById(id);}
function $$(expr){return document.querySelectorAll(expr);}
var mozFMRadio=navigator.mozFM||navigator.mozFMRadio||{speakerEnabled:false,frequency:null,enabled:false,antennaAvailable:true,signalStrength:1,frequencyLowerBound:87.5,frequencyUpperBound:108,channelWidth:0.1,onsignalstrengthchange:function emptyFunction(){},onfrequencychange:function emptyFunction(){},onenabled:function emptyFunction(){},ondisabled:function emptyFunction(){},onantennaavailablechange:function emptyFunction(){},disable:function fm_disable(){if(!this.enabled){return;}
this.enabled=false;var self=this;window.setTimeout(function(){self.ondisabled();},500);return{};},enable:function fm_enable(frequency){if(this.enabled){return;}
this.enabled=true;var self=this;window.setTimeout(function(){self.onenabled();self.setFrequency(frequency);},500);return{};},setFrequency:function fm_setFrequency(freq){freq=parseFloat(freq.toFixed(1));var previousValue=this.frequency;this.frequency=freq;if(previousValue!=freq){this.onfrequencychange();}
return{};},seekUp:function fm_seekUp(){var self=this;if(this._seekRequest){return;}
this._seekRequest={};this._seekTimeout=window.setTimeout(function su_timeout(){self.setFrequency(self.frequency+0.5);if(self._seekRequest.onsuccess){self._seekRequest.onsuccess();}
self._clearSeekRequest();},1000);return this._seekRequest;},seekDown:function fm_seekDown(){var self=this;if(this._seekRequest){return;}
this._seekRequest={};this._seekTimeout=window.setTimeout(function sd_timeout(){self.setFrequency(self.frequency-0.5);if(self._seekRequest.onsuccess){self._seekRequest.onsuccess();}
self._clearSeekRequest();},1000);return this._seekRequest;},cancelSeek:function fm_cancelSeek(){this._clearSeekRequest();var request={};window.setTimeout(function(){if(request.onsuccess){request.onsuccess();}},0);return request;},_clearSeekRequest:function fm_clearSeek(){if(this._seekTimeout){window.clearTimeout(this._seekTimeout);this._seekTimeout=null;}
if(this._seekRequest&&this._seekRequest.onerror){this._seekRequest.onerror();this._seekRequest=null;}}};(function(aGlobal){aGlobal.SpeakerManager=aGlobal.SpeakerManager||aGlobal.MozSpeakerManager;if(aGlobal.SpeakerManager)
return;function SpeakerManager(){this.speakerforced=false;}
SpeakerManager.prototype={set forcespeaker(enable){if(this.speakerforced!=enable){this.speakerforced=enable;if(this.onspeakerforcedchange){this.onspeakerforcedchange();}}}};aGlobal.SpeakerManager=SpeakerManager;})(window);function updateFreqUI(){historyList.add(mozFMRadio.frequency);frequencyDialer.setFrequency(mozFMRadio.frequency);var frequency=frequencyDialer.getFrequency();favoritesList.select(frequency);var bookmarkButton=$('bookmark-button');bookmarkButton.dataset.bookmarked=favoritesList.contains(frequency);bookmarkButton.setAttribute('aria-pressed',favoritesList.contains(frequency));}
function updatePowerUI(){var enabled=mozFMRadio.enabled;var powerSwitch=$('power-switch');if(enabled){window.performance.mark('fmRadioEnabled');PerformanceTestingHelper.dispatch('fm-radio-enabled');powerSwitch.setAttribute('data-l10n-id','power-switch-off');}else{powerSwitch.setAttribute('data-l10n-id','power-switch-on');}
console.log('Power status: '+(enabled?'on':'off'));powerSwitch.dataset.enabled=enabled;powerSwitch.dataset.enabling=enabling;}
function updateWarningModeUI(){$('airplane-mode-warning').hidden=!airplaneModeEnabled;$('antenna-warning').hidden=mozFMRadio.antennaAvailable||airplaneModeEnabled;$('container').classList.toggle('hidden-block',airplaneModeEnabled||!mozFMRadio.antennaAvailable);}
var enabling=false;function updateFrequencyBarUI(){var frequencyBar=$('frequency-bar');if(enabling){frequencyBar.classList.add('dim');}else{frequencyBar.classList.remove('dim');}}
function updateEnablingState(enablingState){enabling=enablingState;updatePowerUI();updateFrequencyBarUI();}
var airplaneModeEnabled=false;function enableFMRadio(frequency){if(airplaneModeEnabled)
return;var request=mozFMRadio.enable(frequency);request.onerror=function onerror_enableFMRadio(event){updateEnablingState(false);};updateEnablingState(true);}
function cancelSeekAndSetFreq(frequency){function setFreq(){mozFMRadio.setFrequency(frequency);}
var seeking=!!$('power-switch').getAttribute('data-seeking');if(!seeking){setFreq();}else{var request=mozFMRadio.cancelSeek();request.onsuccess=setFreq;request.onerror=setFreq;}}
var frequencyDialer={unit:2,_bandUpperBound:0,_bandLowerBound:0,_minFrequency:0,_maxFrequency:0,_currentFreqency:0,_translateX:0,init:function(){updateWarningModeUI();this._initUI();this.setFrequency(mozFMRadio.frequency);this._addEventListeners();},_addEventListeners:function(){function _removeEventListeners(){document.body.removeEventListener('touchend',fd_body_touchend,false);document.body.removeEventListener('touchmove',fd_body_touchmove,false);}
function cloneEvent(evt){if('touches'in evt){evt=evt.touches[0];}
return{x:evt.clientX,y:evt.clientX,timestamp:evt.timeStamp};}
var self=this;var SPEED_THRESHOLD=0.1;var currentEvent,startEvent,currentSpeed;var tunedFrequency=0;function toFixed(frequency){return parseFloat(frequency.toFixed(1));}
function _calcSpeed(){var movingSpace=startEvent.x-currentEvent.x;var deltaTime=currentEvent.timestamp-startEvent.timestamp;var speed=movingSpace/deltaTime;currentSpeed=parseFloat(speed.toFixed(2));}
function _calcTargetFrequency(){return tunedFrequency-getMovingSpace()/self._space;}
function getMovingSpace(){var movingSpace=currentEvent.x-startEvent.x;return movingSpace;}
function fd_body_touchmove(event){event.stopPropagation();currentEvent=cloneEvent(event);_calcSpeed();var dialer=$('frequency-dialer');var translateX=self._translateX+getMovingSpace();self._translateX=translateX;var count=dialer.childNodes.length;for(var i=0;i<count;i++){var child=dialer.childNodes[i];child.style.MozTransform='translateX('+translateX+'px)';}
tunedFrequency=_calcTargetFrequency();var roundedFrequency=Math.round(tunedFrequency*10)/10;if(roundedFrequency!=self._currentFreqency){self.setFrequency(toFixed(roundedFrequency),true);}
startEvent=currentEvent;}
function fd_body_touchend(event){event.stopPropagation();_removeEventListeners();$('frequency-dialer').classList.add('animation-on');if(Math.abs(currentSpeed)>SPEED_THRESHOLD){var direction=currentSpeed>0?1:-1;tunedFrequency+=Math.min(Math.abs(currentSpeed)*3,3)*direction;}
tunedFrequency=self.setFrequency(toFixed(tunedFrequency));cancelSeekAndSetFreq(tunedFrequency);currentEvent=null;startEvent=null;currentSpeed=0;}
function fd_touchstart(event){event.stopPropagation();$('frequency-dialer').classList.remove('animation-on');startEvent=currentEvent=cloneEvent(event);tunedFrequency=self._currentFreqency;_removeEventListeners();document.body.addEventListener('touchmove',fd_body_touchmove,false);document.body.addEventListener('touchend',fd_body_touchend,false);}
function fd_key(event){if(event.keyCode===event.DOM_VK_UP){tunedFrequency=self._currentFreqency+0.1;}else if(event.keyCode===event.DOM_VK_DOWN){tunedFrequency=self._currentFreqency-0.1;}else{return;}
tunedFrequency=self.setFrequency(toFixed(tunedFrequency));cancelSeekAndSetFreq(tunedFrequency);}
var dialerContainer=$('dialer-container');dialerContainer.addEventListener('touchstart',fd_touchstart,false);dialerContainer.addEventListener('keypress',fd_key,false);},_initUI:function(){$('frequency-dialer').innerHTML='';var lower=this._bandLowerBound=mozFMRadio.frequencyLowerBound;var upper=this._bandUpperBound=mozFMRadio.frequencyUpperBound;var unit=this.unit;this._minFrequency=lower-lower%unit;this._maxFrequency=upper+unit-upper%unit;var unitCount=(this._maxFrequency-this._minFrequency)/unit;for(var i=0;i<unitCount;++i){var start=this._minFrequency+i*unit;start=start<lower?lower:start;var end=this._maxFrequency+i*unit+unit;end=upper<end?upper:end;this._addDialerUnit(start,end);}
var _dialerUnits=$$('#frequency-dialer .dialer-unit');var _dialerUnitWidth=_dialerUnits[0].clientWidth;this._dialerWidth=_dialerUnitWidth*_dialerUnits.length;this._space=this._dialerWidth/(this._maxFrequency-this._minFrequency);for(var i=0;i<_dialerUnits.length;i++){_dialerUnits[i].style.left=i*_dialerUnitWidth+'px';}},_addDialerUnit:function(start,end){var markStart=start-start%this.unit;var startMaskWidth=0;var endMaskWidth=0;var unitWidth=16;var total=this.unit*10;for(var i=0;i<total;i++){var dialValue=markStart+i*0.1;if(dialValue<start){startMaskWidth+=unitWidth;}else if(dialValue>end){endMaskWidth+=unitWidth;}}
var container=document.createElement('div');container.classList.add('dialer-unit-mark-box');if(startMaskWidth>0){var markStart=document.createElement('div');markStart.classList.add('dialer-unit-mark-mask-start');markStart.style.width=startMaskWidth+'px';container.appendChild(markStart);}
if(endMaskWidth>0){var markEnd=document.createElement('div');markEnd.classList.add('dialer-unit-mark-mask-end');markEnd.style.width=endMaskWidth+'px';container.appendChild(markEnd);}
var width=(100/this.unit)+'%';for(var j=0;j<this.unit;j++){var frequency=Math.floor(markStart)+j;var showFloor=frequency>=start&&frequency<=end;var unit=document.createElement('div');unit.classList.add('dialer-unit-floor');if(!showFloor){unit.classList.add('hidden-block');}
unit.style.width=width;unit.appendChild(document.createTextNode(frequency));container.appendChild(unit);}
var unit=document.createElement('div');unit.className='dialer-unit';unit.appendChild(container);$('frequency-dialer').appendChild(unit);},_updateUI:function(frequency,ignoreDialer){$('frequency').textContent=frequency.toFixed(1);if(true!==ignoreDialer){this._translateX=(this._minFrequency-frequency)*this._space;var dialer=$('frequency-dialer');var count=dialer.childNodes.length;for(var i=0;i<count;i++){dialer.childNodes[i].style.MozTransform='translateX('+this._translateX+'px)';}
$('dialer-container').setAttribute('aria-valuenow',frequency);}},setFrequency:function(frequency,ignoreDialer){if(frequency<this._bandLowerBound){frequency=this._bandLowerBound;}
if(frequency>this._bandUpperBound){frequency=this._bandUpperBound;}
this._currentFreqency=frequency;this._updateUI(frequency,ignoreDialer);return frequency;},getFrequency:function(){return this._currentFreqency;}};var historyList={_historyList:[],KEYNAME:'historylist',SIZE:1,init:function hl_init(callback){var self=this;window.asyncStorage.getItem(this.KEYNAME,function storage_getItem(value){self._historyList=value||[];if(typeof callback=='function'){callback();}});},_save:function hl_save(){window.asyncStorage.setItem(this.KEYNAME,this._historyList);},add:function hl_add(freq){if(freq==null)
return;var self=this;self._historyList.push({name:freq+'',frequency:freq});if(self._historyList.length>self.SIZE)
self._historyList.shift();self._save();},last:function hl_last(){if(this._historyList.length==0){return null;}
else{return this._historyList[this._historyList.length-1];}}};var favoritesList={_favList:null,KEYNAME:'favlist',init:function(callback){var self=this;window.asyncStorage.getItem(this.KEYNAME,function storage_getItem(value){self._favList=value||{};self._showListUI();if(typeof callback=='function'){callback();}});var _container=$('fav-list-container');_container.addEventListener('click',function _onclick(event){var frequency=self._getElemFreq(event.target);if(!frequency){return;}
if(event.target.classList.contains('fav-list-remove-button')){self.remove(frequency);updateFreqUI();}else{if(mozFMRadio.enabled){cancelSeekAndSetFreq(frequency);}else{enableFMRadio(frequency);}}});},_save:function(){window.asyncStorage.setItem(this.KEYNAME,this._favList);},_showListUI:function(){var self=this;this.forEach(function(f){self._addItemToListUI(f);});},_addItemToListUI:function(item){var container=$('fav-list-container');var elem=document.createElement('div');elem.id=this._getUIElemId(item);elem.className='fav-list-item';elem.setAttribute('role','option');var html='';html+='<div class="fav-list-frequency">';html+=item.frequency.toFixed(1);html+='</div>';html+='<div class="fav-list-remove-button"></div>';elem.innerHTML=html;if(container.childNodes.length==0){container.appendChild(elem);}else{var childNodes=container.childNodes;for(var i=0;i<childNodes.length;i++){var child=childNodes[i];var elemFreq=this._getElemFreq(child);if(item.frequency<elemFreq){container.insertBefore(elem,child);break;}else if(i==childNodes.length-1){container.appendChild(elem);break;}}}
return elem;},_removeItemFromListUI:function(freq){if(!this.contains(freq)){return;}
var itemElem=$(this._getUIElemId(this._favList[freq]));if(itemElem){itemElem.parentNode.removeChild(itemElem);}},_getUIElemId:function(item){return'frequency-'+item.frequency;},_getElemFreq:function(elem){var isParentListItem=elem.parentNode.classList.contains('fav-list-item');var listItem=isParentListItem?elem.parentNode:elem;return parseFloat(listItem.id.substring(listItem.id.indexOf('-')+1));},forEach:function(callback){for(var freq in this._favList){callback(this._favList[freq]);}},contains:function(freq){if(!this._favList){return false;}
return typeof this._favList[freq]!='undefined';},add:function(freq){if(!this.contains(freq)){this._favList[freq]={name:freq+'',frequency:freq};this._save();this._addItemToListUI(this._favList[freq]).scrollIntoView();}},remove:function(freq){var exists=this.contains(freq);this._removeItemFromListUI(freq);delete this._favList[freq];this._save();return exists;},select:function(freq){var items=$$('#fav-list-container div.fav-list-item');for(var i=0;i<items.length;i++){var item=items[i];if(this._getElemFreq(item)==freq){item.classList.add('selected');item.setAttribute('aria-selected',true);}else{item.classList.remove('selected');item.setAttribute('aria-selected',false);}}}};function init(){frequencyDialer.init();var seeking=false;function onclick_seekbutton(event){var seekButton=this;var powerSwitch=$('power-switch');var seeking=!!powerSwitch.getAttribute('data-seeking');var up=seekButton.id=='frequency-op-seekup';function seek(){powerSwitch.dataset.seeking=true;var request=up?mozFMRadio.seekUp():mozFMRadio.seekDown();request.onsuccess=function seek_onsuccess(){powerSwitch.removeAttribute('data-seeking');};request.onerror=function seek_onerror(){powerSwitch.removeAttribute('data-seeking');};}
if(seeking){var request=mozFMRadio.cancelSeek();request.onsuccess=seek;request.onerror=seek;}else{seek();}}
$('frequency-op-seekdown').addEventListener('click',onclick_seekbutton,false);$('frequency-op-seekup').addEventListener('click',onclick_seekbutton,false);$('power-switch').addEventListener('click',function toggle_fm(){if(mozFMRadio.enabled){mozFMRadio.disable();}else{enableFMRadio(frequencyDialer.getFrequency());}},false);$('bookmark-button').addEventListener('click',function toggle_bookmark(){var frequency=frequencyDialer.getFrequency();if(favoritesList.contains(frequency)){favoritesList.remove(frequency);}else{favoritesList.add(frequency);}
updateFreqUI();},false);var speakerManager=new SpeakerManager();$('speaker-switch').addEventListener('click',function toggle_speaker(){speakerManager.forcespeaker=!speakerManager.speakerforced;},false);speakerManager.onspeakerforcedchange=function onspeakerforcedchange(){var speakerSwitch=$('speaker-switch');speakerSwitch.dataset.speakerOn=speakerManager.speakerforced;speakerSwitch.setAttribute('aria-pressed',speakerManager.speakerforced);};mozFMRadio.onfrequencychange=updateFreqUI;mozFMRadio.onenabled=function(){updateEnablingState(false);};mozFMRadio.ondisabled=function(){updateEnablingState(false);};mozFMRadio.onantennaavailablechange=function onAntennaChange(){updateWarningModeUI();if(mozFMRadio.antennaAvailable){if(!!window._previousFMRadioState||!!window._previousEnablingState){enableFMRadio(frequencyDialer.getFrequency());}}else{window._previousFMRadioState=mozFMRadio.enabled;window._previousEnablingState=enabling;mozFMRadio.disable();}};updateWarningModeUI();AirplaneModeHelper.addEventListener('statechange',function(status){airplaneModeEnabled=status==='enabled';updateWarningModeUI();});historyList.init(function hl_ready(){if(mozFMRadio.antennaAvailable){if(historyList.last()&&historyList.last().frequency)
enableFMRadio(historyList.last().frequency);else
enableFMRadio(mozFMRadio.frequencyLowerBound);favoritesList.init(updateFreqUI);}else{window._previousFMRadioState=true;updateWarningModeUI();favoritesList.init();}
updatePowerUI();window.performance.mark('fullyLoaded');window.dispatchEvent(new CustomEvent('moz-app-loaded'));});navigator.mozSettings.addObserver('private.broadcast.attention_screen_opening',function(event){if(event.settingValue){window._previousFMRadioState=mozFMRadio.enabled;window._previousEnablingState=enabling;window._previousSpeakerForcedState=speakerManager.speakerforced;mozFMRadio.disable();}
else{if(!!window._previousFMRadioState||!!window._previousEnablingState){if(mozFMRadio.antennaAvailable){enableFMRadio(frequencyDialer.getFrequency());}
speakerManager.forcespeaker=!!window._previousSpeakerForcedState;}}});}
window.addEventListener('load',function(e){AirplaneModeHelper.ready(function(){airplaneModeEnabled=AirplaneModeHelper.getStatus()=='enabled';init();window.performance.mark('navigationInteractive');window.dispatchEvent(new CustomEvent('moz-chrome-interactive'));window.performance.mark('visuallyLoaded');window.dispatchEvent(new CustomEvent('moz-app-visually-complete'));window.performance.mark('contentInteractive');window.dispatchEvent(new CustomEvent('moz-content-interactive'));});},false);window.addEventListener('unload',function(e){mozFMRadio.disable();},false);window.performance.mark('navigationLoaded');window.dispatchEvent(new CustomEvent('moz-chrome-dom-loaded'));