define([ "require", "l10n!", "cards" ], function(e) {
    var t = e("l10n!"), n = e("cards");
    return {
        _bindPrefs: function(e, n, i, o, s) {
            if (e) {
                var a = this.nodeFromClass(e), r = this.account.syncInterval, c = String(r), l = [];
                "undefined" != typeof _secretDebug && _secretDebug.fastSync && (l = l.concat(_secretDebug.fastSync));
                var d = Array.slice(a.options, 0).some(function(e) {
                    return c === e.value;
                });
                d || -1 !== l.indexOf(r) || l.push(r), l.forEach(function(e) {
                    var n = document.createElement("option"), i = e / 1e3;
                    n.value = String(e), t.setAttributes(n, "settings-check-dynamic", {
                        n: i
                    }), a.appendChild(n);
                }), a.value = c, a.addEventListener("change", this.onChangeSyncInterval.bind(this), !1);
            }
            if (n) {
                var u = this.nodeFromClass(n);
                u.addEventListener("click", this.onNotifyEmailClick.bind(this), !1), u.checked = this.account.notifyOnNew;
            }
            if (i) {
                var h = this.nodeFromClass(i);
                h.addEventListener("click", this.onSoundOnSendClick.bind(this), !1), h.checked = this.account.playSoundOnSend;
            }
            if (o) {
                var p = this.nodeFromClass(o);
                p.addEventListener("click", this.onSignatureEnabledClick.bind(this), !1), p.checked = !!this.identity.signatureEnabled;
            }
            s && (this.signatureButton = this.nodeFromClass(s), this.updateSignatureButton(), 
            this.signatureButton.addEventListener("click", this.onClickSignature.bind(this), !1));
        },
        nodeFromClass: function(e) {
            return this.getElementsByClassName(e)[0];
        },
        onChangeSyncInterval: function(e) {
            var t = parseInt(e.target.value, 10);
            console.log("sync interval changed to", t), this.account.modifyAccount({
                syncInterval: t
            });
        },
        onNotifyEmailClick: function(e) {
            var t = e.target.checked;
            console.log("notifyOnNew changed to: " + t), this.account.modifyAccount({
                notifyOnNew: t
            });
        },
        onSoundOnSendClick: function(e) {
            var t = e.target.checked;
            console.log("playSoundOnSend changed to: " + t), this.account.modifyAccount({
                playSoundOnSend: t
            });
        },
        onSignatureEnabledClick: function(e) {
            var t = e.target.checked;
            console.log("signatureEnabled changed to: " + t), this.identity.modifyIdentity({
                signatureEnabled: t
            });
        },
        updateSignatureButton: function() {
            var e = this.identity.signature || "", n = 0 === e.trim().length, i = this.signatureButton.firstElementChild;
            i.textContent = e, i.classList.toggle("empty-placeholder", n), n ? t.setAttributes(i, "settings-empty-signature-label") : i.removeAttribute("data-l10n-id");
        },
        onClickSignature: function(e) {
            n.pushCard("settings_signature", "animate", {
                account: this.account,
                index: e
            }, "right");
        }
    };
});