define("activesync/folder", [ "rdcommon/log", "../date", "../syncbase", "../allback", "../db/mail_rep", "activesync/codepages/AirSync", "activesync/codepages/AirSyncBase", "activesync/codepages/ItemEstimate", "activesync/codepages/Email", "activesync/codepages/ItemOperations", "safe-base64", "mimetypes", "module", "require", "exports" ], function(e, t, n, o, r, s, a, i, c, d, l, u, h, f, g) {
    function y() {
        _ = s.Enums.FilterType, S = {
            auto: null,
            "1d": _.OneDayBack,
            "3d": _.ThreeDaysBack,
            "1w": _.OneWeekBack,
            "2w": _.TwoWeeksBack,
            "1m": _.OneMonthBack,
            all: _.NoFilter
        }, I = {
            0: "all messages",
            1: "one day",
            2: "three days",
            3: "one week",
            4: "two weeks",
            5: "one month"
        };
    }
    function p(e, t, n) {
        return function() {
            var o = Array.slice(arguments), r = o[e], s = this;
            f([ "wbxml", "addressparser", "../mailchew" ], function(e, a, i) {
                w || (w = e, b = a.parse.bind(a), F = i, y()), s._account.withConnection(r, function() {
                    t.apply(s, o);
                }, n);
            });
        };
    }
    function v(e, t, n) {
        this._account = e, this._storage = t, this._LOG = C.ActiveSyncFolderConn(this, n, t.folderId), 
        this.folderMeta = t.folderMeta, this.syncKey || (this.syncKey = "0");
    }
    function m(e, t, n) {
        this._account = e, this.folderStorage = t, this._LOG = C.ActiveSyncFolderSyncer(this, n, t.folderId), 
        this.folderConn = new v(e, t, this._LOG);
    }
    var _, S, I, w, b, F, E = 512, T = 50;
    v.prototype = {
        get syncKey() {
            return this.folderMeta.syncKey;
        },
        set syncKey(e) {
            return this.folderMeta.syncKey = e;
        },
        get serverId() {
            return this.folderMeta.serverId;
        },
        get filterType() {
            var e = this._account.accountDef.syncRange;
            if (S.hasOwnProperty(e)) {
                var t = S[e];
                return t ? t : this.folderMeta.filterType;
            }
            return console.warn("Got an invalid syncRange (" + e + ") using three days back instead"), 
            s.Enums.FilterType.ThreeDaysBack;
        },
        _getSyncKey: p(1, function(e, t) {
            var n = this, o = this._account, r = s.Tags, a = new w.Writer("1.3", 1, "UTF-8");
            a.stag(r.Sync).stag(r.Collections).stag(r.Collection), o.conn.currentVersion.lt("12.1") && a.tag(r.Class, "Email"), 
            a.tag(r.SyncKey, "0").tag(r.CollectionId, this.serverId).stag(r.Options).tag(r.FilterType, e).etag().etag().etag().etag(), 
            o.conn.postCommand(a, function(e, s) {
                if (e) return console.error(e), o._reportErrorIfNecessary(e), t("unknown"), void 0;
                n.syncKey = "0";
                var a = new w.EventParser();
                a.addEventListener([ r.Sync, r.Collections, r.Collection, r.SyncKey ], function(e) {
                    n.syncKey = e.children[0].textContent;
                }), a.onerror = function() {}, a.run(s), "0" === n.syncKey ? (console.error("Unable to get sync key for folder"), 
                t("unknown")) : t();
            });
        }),
        _getItemEstimate: p(1, function(e, t) {
            var n = i.Tags, o = s.Tags, r = this._account, a = new w.Writer("1.3", 1, "UTF-8");
            a.stag(n.GetItemEstimate).stag(n.Collections).stag(n.Collection), this._account.conn.currentVersion.gte("14.0") ? a.tag(o.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).stag(o.Options).tag(o.FilterType, e).etag() : this._account.conn.currentVersion.gte("12.0") ? a.tag(n.CollectionId, this.serverId).tag(o.FilterType, e).tag(o.SyncKey, this.syncKey) : a.tag(n.Class, "Email").tag(o.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).tag(o.FilterType, e), 
            a.etag(n.Collection).etag(n.Collections).etag(n.GetItemEstimate), r.conn.postCommand(a, function(e, o) {
                if (e) return console.error(e), r._reportErrorIfNecessary(e), t("unknown"), void 0;
                var s, a, c = new w.EventParser(), d = [ n.GetItemEstimate, n.Response ];
                c.addEventListener(d.concat(n.Status), function(e) {
                    s = e.children[0].textContent;
                }), c.addEventListener(d.concat(n.Collection, n.Estimate), function(e) {
                    a = parseInt(e.children[0].textContent, 10);
                });
                try {
                    c.run(o);
                } catch (l) {
                    return console.error("Error parsing GetItemEstimate response", l, "\n", l.stack), 
                    t("unknown"), void 0;
                }
                s !== i.Enums.Status.Success ? (console.error("Error getting item estimate:", s), 
                t("unknown")) : t(null, a);
            });
        }),
        _inferFilterType: p(0, function(e) {
            var t = this, n = s.Enums.FilterType, o = function(o, r) {
                t._getSyncKey(o, function(s) {
                    return s ? (e("unknown"), void 0) : (t._getItemEstimate(o, function(t, o) {
                        return t ? (e(null, n.ThreeDaysBack), void 0) : (r(o), void 0);
                    }), void 0);
                });
            };
            o(n.TwoWeeksBack, function(r) {
                var s, a = r / 14;
                if (0 > r) s = n.ThreeDaysBack; else if (a >= T) s = n.OneDayBack; else if (3 * a >= T) s = n.ThreeDaysBack; else if (7 * a >= T) s = n.OneWeekBack; else if (14 * a >= T) s = n.TwoWeeksBack; else {
                    if (!(30 * a >= T)) return o(n.NoFilter, function(o) {
                        var r;
                        o > T ? (r = n.OneMonthBack, t.syncKey = "0") : r = n.NoFilter, t._LOG.inferFilterType(r), 
                        e(null, r);
                    }), void 0;
                    s = n.OneMonthBack;
                }
                s !== n.TwoWeeksBack && (t.syncKey = "0"), t._LOG.inferFilterType(s), e(null, s);
            });
        }),
        _enumerateFolderChanges: p(0, function(e, t) {
            var n = this, o = this._storage;
            if (!this.filterType) return this._inferFilterType(function(o, r) {
                return o ? (e("unknown"), void 0) : (console.log("We want a filter of", I[r]), n.folderMeta.filterType = r, 
                n._enumerateFolderChanges(e, t), void 0);
            }), void 0;
            if ("0" === this.syncKey) return this._getSyncKey(this.filterType, function(o) {
                return o ? (e("aborted"), void 0) : (n._enumerateFolderChanges(e, t), void 0);
            }), void 0;
            var r = s.Tags, i = s.Enums;
            a.Tags, a.Enums;
            var c;
            0 === this._account._syncsInProgress++ && this._account._lastSyncKey === this.syncKey && this._account._lastSyncFilterType === this.filterType && this._account._lastSyncResponseWasEmpty ? c = r.Sync : (c = new w.Writer("1.3", 1, "UTF-8"), 
            c.stag(r.Sync).stag(r.Collections).stag(r.Collection), this._account.conn.currentVersion.lt("12.1") && c.tag(r.Class, "Email"), 
            c.tag(r.SyncKey, this.syncKey).tag(r.CollectionId, this.serverId).tag(r.GetChanges).stag(r.Options).tag(r.FilterType, this.filterType), 
            this._account.conn.currentVersion.lte("12.0") && c.tag(r.MIMESupport, i.MIMESupport.Never).tag(r.Truncation, i.MIMETruncation.TruncateAll), 
            c.etag().etag().etag().etag()), this._account.conn.postCommand(c, function(s, a) {
                var c, d = [], l = [], u = [], h = !1;
                if (n._account._syncsInProgress--, s) return console.error("Error syncing folder:", s), 
                n._account._reportErrorIfNecessary(s), e("aborted"), void 0;
                if (n._account._lastSyncKey = n.syncKey, n._account._lastSyncFilterType = n.filterType, 
                !a) return console.log("Sync completed with empty response"), n._account._lastSyncResponseWasEmpty = !0, 
                e(null, d, l, u), void 0;
                n._account._lastSyncResponseWasEmpty = !1;
                var f = new w.EventParser(), g = [ r.Sync, r.Collections, r.Collection ];
                f.addEventListener(g.concat(r.SyncKey), function(e) {
                    n.syncKey = e.children[0].textContent;
                }), f.addEventListener(g.concat(r.Status), function(e) {
                    c = e.children[0].textContent;
                }), f.addEventListener(g.concat(r.MoreAvailable), function() {
                    h = !0;
                }), f.addEventListener(g.concat(r.Commands, [ [ r.Add, r.Change ] ]), function(e) {
                    var t, s;
                    for (var a in Iterator(e.children)) {
                        var i = a[1];
                        switch (i.tag) {
                          case r.ServerId:
                            t = i.children[0].textContent;
                            break;

                          case r.ApplicationData:
                            try {
                                s = n._parseMessage(i, e.tag === r.Add, o);
                            } catch (c) {
                                return console.error("Failed to parse a message:", c, "\n", c.stack), void 0;
                            }
                        }
                    }
                    s.header.srvid = t;
                    var u = e.tag === r.Add ? d : l;
                    u.push(s);
                }), f.addEventListener(g.concat(r.Commands, [ [ r.Delete, r.SoftDelete ] ]), function(e) {
                    var t;
                    for (var n in Iterator(e.children)) {
                        var o = n[1];
                        switch (o.tag) {
                          case r.ServerId:
                            t = o.children[0].textContent;
                        }
                    }
                    u.push(t);
                });
                try {
                    f.run(a);
                } catch (y) {
                    return console.error("Error parsing Sync response:", y, "\n", y.stack), e("unknown"), 
                    void 0;
                }
                c === i.Status.Success ? (console.log("Sync completed: added " + d.length + ", changed " + l.length + ", deleted " + u.length), 
                e(null, d, l, u, h), h && n._enumerateFolderChanges(e, t)) : c === i.Status.InvalidSyncKey ? (console.warn("ActiveSync had a bad sync key"), 
                e("badkey")) : (console.error("Something went wrong during ActiveSync syncing and we got a status of " + c), 
                e("unknown"));
            }, null, null, function(e, n) {
                n || (n = Math.max(1e6, e)), t(.1 + .7 * e / n);
            });
        }, "aborted"),
        _parseMessage: function(e, t, n) {
            var o, s, i, d = c.Tags, l = a.Tags, h = a.Enums;
            if (t) {
                var f = n._issueNewHeaderId();
                o = {
                    id: f,
                    srvid: null,
                    suid: n.folderId + "/" + f,
                    guid: "",
                    author: null,
                    to: null,
                    cc: null,
                    bcc: null,
                    replyTo: null,
                    date: null,
                    flags: [],
                    hasAttachments: !1,
                    subject: null,
                    snippet: null
                }, s = {
                    date: null,
                    size: 0,
                    attachments: [],
                    relatedParts: [],
                    references: null,
                    bodyReps: null
                }, i = function(e, t) {
                    t && o.flags.push(e);
                };
            } else o = {
                flags: [],
                mergeInto: function(e) {
                    for (var t in Iterator(this.flags)) {
                        var n = t[1];
                        if (n[1]) e.flags.push(n[0]); else {
                            var o = e.flags.indexOf(n[0]);
                            -1 !== o && e.flags.splice(o, 1);
                        }
                    }
                    var r = [ "mergeInto", "suid", "srvid", "guid", "id", "flags" ];
                    for (var t in Iterator(this)) {
                        var s = t[0], a = t[1];
                        -1 === r.indexOf(s) && (e[s] = a);
                    }
                }
            }, s = {
                mergeInto: function(e) {
                    for (var t in Iterator(this)) {
                        var n = t[0], o = t[1];
                        "mergeInto" !== n && (e[n] = o);
                    }
                }
            }, i = function(e, t) {
                o.flags.push([ e, t ]);
            };
            var g, y;
            for (var p in Iterator(e.children)) {
                var v = p[1], m = v.children.length ? v.children[0].textContent : null;
                switch (v.tag) {
                  case d.Subject:
                    o.subject = m;
                    break;

                  case d.From:
                    o.author = b(m)[0] || null;
                    break;

                  case d.To:
                    o.to = b(m);
                    break;

                  case d.Cc:
                    o.cc = b(m);
                    break;

                  case d.ReplyTo:
                    o.replyTo = b(m);
                    break;

                  case d.DateReceived:
                    s.date = o.date = new Date(m).valueOf();
                    break;

                  case d.Read:
                    i("\\Seen", "1" === m);
                    break;

                  case d.Flag:
                    for (var _ in Iterator(v.children)) {
                        var S = _[1];
                        S.tag === d.Status && i("\\Flagged", "0" !== S.children[0].textContent);
                    }
                    break;

                  case l.Body:
                    for (var _ in Iterator(v.children)) {
                        var S = _[1];
                        switch (S.tag) {
                          case l.Type:
                            var I = S.children[0].textContent;
                            I === h.Type.HTML ? g = "html" : (I !== h.Type.PlainText && console.warn("A message had a strange body type:", I), 
                            g = "plain");
                            break;

                          case l.EstimatedDataSize:
                            y = S.children[0].textContent;
                        }
                    }
                    break;

                  case d.BodySize:
                    g = "plain", y = m;
                    break;

                  case l.Attachments:
                  case d.Attachments:
                    for (var _ in Iterator(v.children)) {
                        var w = _[1];
                        if (w.tag === l.Attachment || w.tag === d.Attachment) {
                            var F = {
                                name: null,
                                contentId: null,
                                type: null,
                                part: null,
                                encoding: null,
                                sizeEstimate: null,
                                file: null
                            }, E = !1;
                            for (var T in Iterator(w.children)) {
                                var C, k, O = T[1], A = O.children.length ? O.children[0].textContent : null;
                                switch (O.tag) {
                                  case l.DisplayName:
                                  case d.DisplayName:
                                    F.name = A, C = F.name.lastIndexOf("."), k = C > 0 ? F.name.substring(C + 1).toLowerCase() : "", 
                                    F.type = u.detectMimeType(k);
                                    break;

                                  case l.FileReference:
                                  case d.AttName:
                                  case d.Att0Id:
                                    F.part = A;
                                    break;

                                  case l.EstimatedDataSize:
                                  case d.AttSize:
                                    F.sizeEstimate = parseInt(A, 10);
                                    break;

                                  case l.ContentId:
                                    F.contentId = A;
                                    break;

                                  case l.IsInline:
                                    E = "1" === A;
                                }
                            }
                            E ? s.relatedParts.push(r.makeAttachmentPart(F)) : s.attachments.push(r.makeAttachmentPart(F));
                        }
                    }
                    o.hasAttachments = s.attachments.length > 0;
                }
            }
            return t ? (s.bodyReps = [ r.makeBodyPart({
                type: g,
                sizeEstimate: y,
                amountDownloaded: 0,
                isDownloaded: !1
            }) ], {
                header: r.makeHeaderInfo(o),
                body: r.makeBodyInfo(s)
            }) : {
                header: o,
                body: s
            };
        },
        downloadBodies: function(e, t, n) {
            if (this._account.conn.currentVersion.lt("12.0")) return this._syncBodies(e, n);
            for (var r = 0, s = o.latch(), a = 0; a < e.length; a++) {
                var i = e[a];
                i && null === i.snippet && (r++, this.downloadBodyReps(i, t, s.defer(i.suid)));
            }
            s.then(function(e) {
                n(o.extractErrFromCallbackArgs(e), r);
            });
        },
        downloadBodyReps: p(1, function(e, t, n) {
            var o = this, r = this._account;
            if (r.conn.currentVersion.lt("12.0")) return this._syncBodies([ e ], n);
            "function" == typeof t && (n = t, t = null), t = t || {};
            var i = d.Tags, c = d.Enums, l = s.Tags;
            s.Enums;
            var u = a.Tags, h = a.Enums.Type, f = function(s) {
                if (!s) return n("unknown");
                var a, d = s.bodyReps[0], f = "html" === d.type ? h.HTML : h.PlainText;
                t.maximumBytesToFetch < d.sizeEstimate && (f = h.PlainText, a = E);
                var g = new w.Writer("1.3", 1, "UTF-8");
                g.stag(i.ItemOperations).stag(i.Fetch).tag(i.Store, "Mailbox").tag(l.CollectionId, o.serverId).tag(l.ServerId, e.srvid).stag(i.Options).stag(i.Schema).tag(u.Body).etag().stag(u.BodyPreference).tag(u.Type, f), 
                a && g.tag(u.TruncationSize, a), g.etag().etag().etag().etag(), r.conn.postCommand(g, function(t, d) {
                    if (t) return console.error(t), r._reportErrorIfNecessary(t), n("unknown"), void 0;
                    var l, h, f = new w.EventParser();
                    f.addEventListener([ i.ItemOperations, i.Status ], function(e) {
                        l = e.children[0].textContent;
                    }), f.addEventListener([ i.ItemOperations, i.Response, i.Fetch, i.Properties, u.Body, u.Data ], function(e) {
                        h = e.children[0].textContent;
                    });
                    try {
                        f.run(d);
                    } catch (g) {
                        return n("unknown");
                    }
                    return l !== c.Status.Success ? n("unknown") : (o._updateBody(e, s, h, !!a, n), 
                    void 0);
                });
            };
            this._storage.getMessageBody(e.suid, e.date, f);
        }),
        _syncBodies: function(e, t) {
            var n = s.Tags, r = s.Enums, a = c.Tags, i = this, d = this._account, l = new w.Writer("1.3", 1, "UTF-8");
            l.stag(n.Sync).stag(n.Collections).stag(n.Collection).tag(n.Class, "Email").tag(n.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).stag(n.Options).tag(n.MIMESupport, r.MIMESupport.Never).etag().stag(n.Commands);
            for (var u = 0; u < e.length; u++) l.stag(n.Fetch).tag(n.ServerId, e[u].srvid).etag();
            l.etag().etag().etag().etag(), d.conn.postCommand(l, function(s, c) {
                if (s) return console.error(s), d._reportErrorIfNecessary(s), t("unknown"), void 0;
                var l = o.latch(), u = 0, h = new w.EventParser(), f = [ n.Sync, n.Collections, n.Collection ];
                h.addEventListener(f.concat(n.SyncKey), function(e) {
                    i.syncKey = e.children[0].textContent;
                }), h.addEventListener(f.concat(n.Status), function(e) {
                    var t = e.children[0].textContent;
                    t !== r.Status.Success && l.defer("status")("unknown");
                }), h.addEventListener(f.concat(n.Responses, n.Fetch, n.ApplicationData, a.Body), function(t) {
                    var n = e[u++], o = t.children[0].textContent, r = l.defer(n.suid);
                    i._storage.getMessageBody(n.suid, n.date, function(e) {
                        i._updateBody(n, e, o, !1, r);
                    });
                }), h.run(c), l.then(function(e) {
                    t(o.extractErrFromCallbackArgs(e));
                });
            });
        },
        _activeSyncHeaderIsSeen: function(e) {
            for (var t = 0; t < e.flags.length; t++) if ("\\Seen" === e.flags[t][0] && e.flags[t][1]) return !0;
            return !1;
        },
        _updateBody: function(e, t, n, r, s) {
            var a = t.bodyReps[0];
            n = n.replace(/\r/g, "");
            var i = r ? "plain" : a.type, c = F.processMessageContent(n, i, !r, !0, this._LOG);
            e.snippet = c.snippet, a.isDownloaded = !r, a.amountDownloaded = n.length, r || (a.content = c.content);
            var d = {
                changeDetails: {
                    bodyReps: [ 0 ]
                }
            }, l = o.latch();
            this._storage.updateMessageHeader(e.date, e.id, !1, e, t, l.defer("header")), this._storage.updateMessageBody(e, t, {}, d, l.defer("body")), 
            l.then(s.bind(null, null, t, !1));
        },
        sync: p(1, function(e, t, r) {
            var s = this, a = 0, i = 0, c = 0;
            this._LOG.sync_begin(null, null, null);
            var d = this;
            this._enumerateFolderChanges(function(r, l, u, h, f) {
                var g = s._storage;
                if ("badkey" === r) return s._account._recreateFolder(g.folderId, function() {
                    s._storage = null, s._LOG.sync_end(null, null, null);
                }), void 0;
                if (r) return s._LOG.sync_end(null, null, null), t(r), void 0;
                var y = o.latch();
                for (var p in Iterator(l)) {
                    var v = p[1];
                    g.hasMessageWithServerId(v.header.srvid) || (g.addMessageHeader(v.header, v.body, y.defer()), 
                    g.addMessageBody(v.header, v.body, y.defer()), a++);
                }
                for (var p in Iterator(u)) {
                    var v = p[1];
                    g.hasMessageWithServerId(v.header.srvid) && (g.updateMessageHeaderByServerId(v.header.srvid, !0, function(e, t) {
                        return !d._activeSyncHeaderIsSeen(t) && d._activeSyncHeaderIsSeen(e.header) ? g.folderMeta.unreadCount-- : d._activeSyncHeaderIsSeen(t) && !d._activeSyncHeaderIsSeen(e.header) && g.folderMeta.unreadCount++, 
                        e.header.mergeInto(t), !0;
                    }.bind(null, v), null, y.defer()), i++);
                }
                for (var p in Iterator(h)) {
                    var m = p[1];
                    g.hasMessageWithServerId(m) && (g.deleteMessageByServerId(m, y.defer()), c++);
                }
                if (!f) {
                    var _ = a + i + c;
                    y.then(function() {
                        s._LOG.sync_end(a, i, c), g.markSyncRange(n.OLDEST_SYNC_DATE, e, "XXX", e), t(null, null, _);
                    });
                }
            }, r);
        }),
        performMutation: p(1, function(e, t) {
            var n = this, o = s.Tags, r = this._account, a = new w.Writer("1.3", 1, "UTF-8");
            a.stag(o.Sync).stag(o.Collections).stag(o.Collection), r.conn.currentVersion.lt("12.1") && a.tag(o.Class, "Email"), 
            a.tag(o.SyncKey, this.syncKey).tag(o.CollectionId, this.serverId).tag(o.DeletesAsMoves, "trash" === this.folderMeta.type ? "0" : "1").tag(o.GetChanges, "0").stag(o.Commands);
            try {
                e(a);
            } catch (i) {
                return console.error("Exception in performMutation callee:", i, "\n", i.stack), 
                t("unknown"), void 0;
            }
            a.etag(o.Commands).etag(o.Collection).etag(o.Collections).etag(o.Sync), r.conn.postCommand(a, function(e, a) {
                if (e) return console.error("postCommand error:", e), r._reportErrorIfNecessary(e), 
                t("unknown"), void 0;
                var i, c, d = new w.EventParser(), l = [ o.Sync, o.Collections, o.Collection ];
                d.addEventListener(l.concat(o.SyncKey), function(e) {
                    i = e.children[0].textContent;
                }), d.addEventListener(l.concat(o.Status), function(e) {
                    c = e.children[0].textContent;
                });
                try {
                    d.run(a);
                } catch (u) {
                    return console.error("Error parsing Sync response:", u, "\n", u.stack), t("unknown"), 
                    void 0;
                }
                c === s.Enums.Status.Success ? (n.syncKey = i, t && t(null)) : (console.error("Something went wrong during ActiveSync syncing and we got a status of " + c), 
                t("status:" + c));
            });
        }),
        downloadMessageAttachments: p(2, function(e, t, n) {
            var o = this, r = d.Tags, s = d.Enums.Status, i = a.Tags, c = new w.Writer("1.3", 1, "UTF-8");
            c.stag(r.ItemOperations);
            for (var u in Iterator(t)) {
                var h = u[1];
                c.stag(r.Fetch).tag(r.Store, "Mailbox").tag(i.FileReference, h.part).etag();
            }
            c.etag(), this._account.conn.postCommand(c, function(e, a) {
                if (e) return console.error("postCommand error:", e), o._account._reportErrorIfNecessary(e), 
                n("unknown"), void 0;
                var c, d = {}, u = new w.EventParser();
                u.addEventListener([ r.ItemOperations, r.Status ], function(e) {
                    c = e.children[0].textContent;
                }), u.addEventListener([ r.ItemOperations, r.Response, r.Fetch ], function(e) {
                    var t = null, n = {};
                    for (var o in Iterator(e.children)) {
                        var s = o[1];
                        switch (s.tag) {
                          case r.Status:
                            n.status = s.children[0].textContent;
                            break;

                          case i.FileReference:
                            t = s.children[0].textContent;
                            break;

                          case r.Properties:
                            var a = null, c = null;
                            for (var u in Iterator(s.children)) {
                                var h = u[1], f = h.children[0].textContent;
                                switch (h.tag) {
                                  case i.ContentType:
                                    a = f;
                                    break;

                                  case r.Data:
                                    c = l.decode(f);
                                }
                            }
                            a && c && (n.data = new Blob([ c ], {
                                type: a
                            }));
                        }
                        t && (d[t] = n);
                    }
                }), u.run(a);
                var h = c !== s.Success ? "unknown" : null, f = [];
                for (var g in Iterator(t)) {
                    var y = g[1];
                    d.hasOwnProperty(y.part) && d[y.part].status === s.Success ? f.push(d[y.part].data) : (h = "unknown", 
                    f.push(null));
                }
                n(h, f);
            });
        })
    }, g.ActiveSyncFolderSyncer = m, m.prototype = {
        get syncable() {
            return null !== this.folderConn.serverId;
        },
        get canGrowSync() {
            return !1;
        },
        initialSync: function(e, n, o, r, s) {
            o("sync", !0), this.folderConn.sync(t.NOW(), this.onSyncCompleted.bind(this, r, !0), s);
        },
        refreshSync: function(e, n, o, r, s, a, i) {
            this.folderConn.sync(t.NOW(), this.onSyncCompleted.bind(this, a, !1), i);
        },
        growSync: function() {
            return !1;
        },
        onSyncCompleted: function(e, t, o, r, s) {
            var a = this.folderStorage;
            console.log("Sync Completed!", s, "messages synced"), o || a.markSyncedToDawnOfTime(), 
            this._account.__checkpointSyncCompleted(function() {
                o ? e(o) : t ? (a._curSyncSlice.ignoreHeaders = !1, a._curSyncSlice.waitingOnData = "db", 
                a.getMessagesInImapDateRange(0, null, n.INITIAL_FILL_SIZE, n.INITIAL_FILL_SIZE, a.onFetchDBHeaders.bind(a, a._curSyncSlice, !1, e, null))) : e(o);
            });
        },
        allConsumersDead: function() {},
        shutdown: function() {
            this.folderConn.shutdown(), this._LOG.__die();
        }
    };
    var C = g.LOGFAB = e.register(h, {
        ActiveSyncFolderConn: {
            type: e.CONNECTION,
            subtype: e.CLIENT,
            events: {
                inferFilterType: {
                    filterType: !1
                }
            },
            asyncJobs: {
                sync: {
                    newMessages: !0,
                    changedMessages: !0,
                    deletedMessages: !0
                }
            },
            errors: {
                htmlParseError: {
                    ex: e.EXCEPTION
                },
                htmlSnippetError: {
                    ex: e.EXCEPTION
                },
                textChewError: {
                    ex: e.EXCEPTION
                },
                textSnippetError: {
                    ex: e.EXCEPTION
                }
            }
        },
        ActiveSyncFolderSyncer: {
            type: e.DATABASE,
            events: {}
        }
    });
}), define("activesync/jobs", [ "rdcommon/log", "mix", "../jobmixins", "../drafts/jobs", "activesync/codepages/AirSync", "activesync/codepages/Email", "activesync/codepages/Move", "module", "require", "exports" ], function(e, t, n, o, r, s, a, i, c, d) {
    function l(e, t, n) {
        return function() {
            var o = Array.slice(arguments), r = o[e], s = this;
            c([ "wbxml" ], function(e) {
                h || (h = e), s.account.withConnection(r, function() {
                    t.apply(s, o);
                }, n);
            });
        };
    }
    function u(e, t, n) {
        this.account = e, this.resilientServerIds = !0, this._heldMutexReleasers = [], this._LOG = f.ActiveSyncJobDriver(this, n, this.account.id), 
        this._state = t, t.hasOwnProperty("suidToServerId") || (t.suidToServerId = {}, t.moveMap = {}), 
        this._stateDelta = {
            serverIdMap: null,
            moveMap: null
        };
    }
    var h;
    d.ActiveSyncJobDriver = u, u.prototype = {
        postJobCleanup: n.postJobCleanup,
        allJobsDone: n.allJobsDone,
        _accessFolderForMutation: function(e, t, n, o, r) {
            var s = this.account.getFolderStorageForFolderId(e), a = this;
            s.runMutexed(r, function(e) {
                a._heldMutexReleasers.push(e);
                var o = s.folderSyncer;
                if (t) a.account.withConnection(n, function() {
                    try {
                        n(o.folderConn, s);
                    } catch (e) {
                        a._LOG.callbackErr(e);
                    }
                }); else try {
                    n(o.folderConn, s);
                } catch (r) {
                    a._LOG.callbackErr(r);
                }
            });
        },
        _partitionAndAccessFoldersSequentially: n._partitionAndAccessFoldersSequentially,
        local_do_modtags: n.local_do_modtags,
        do_modtags: l(1, function(e, t, n) {
            function o(e) {
                return a && -1 !== a.indexOf(e) ? !0 : i && -1 !== i.indexOf(e) ? !1 : void 0;
            }
            var a = n ? e.removeTags : e.addTags, i = n ? e.addTags : e.removeTags, c = o("\\Seen"), d = o("\\Flagged"), l = r.Tags, u = s.Tags, h = null;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, n, o, r) {
                return n = n.filter(function(e) {
                    return !!e;
                }), n.length ? (e.performMutation(function(e) {
                    for (var t = 0; t < n.length; t++) e.stag(l.Change).tag(l.ServerId, n[t]).stag(l.ApplicationData), 
                    void 0 !== c && e.tag(u.Read, c ? "1" : "0"), void 0 !== d && e.stag(u.Flag).tag(u.Status, d ? "2" : "0").etag(), 
                    e.etag(l.ApplicationData).etag(l.Change);
                }, function(e) {
                    e && (h = e), r();
                }), void 0) : (r(), void 0);
            }, function() {
                t(h);
            }, function() {
                h = "aborted-retry";
            }, n, "modtags");
        }),
        check_modtags: function(e, t) {
            t(null, "idempotent");
        },
        local_undo_modtags: n.local_undo_modtags,
        undo_modtags: function(e, t) {
            this.do_modtags(e, t, !0);
        },
        local_do_move: n.local_do_move,
        do_move: l(1, function(e, t) {
            var n = null, o = this.account, r = this.account.getFolderStorageForFolderId(e.targetFolder), s = a.Tags;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, a, i, c) {
                if (a = a.filter(function(e) {
                    return !!e;
                }), !a.length) return c(), void 0;
                if (a = a.filter(function(e) {
                    return !!e;
                }), !a.length) return c(), void 0;
                var d = new h.Writer("1.3", 1, "UTF-8");
                d.stag(s.MoveItems);
                for (var l = 0; l < a.length; l++) d.stag(s.Move).tag(s.SrcMsgId, a[l]).tag(s.SrcFldId, t.folderMeta.serverId).tag(s.DstFldId, r.folderMeta.serverId).etag(s.Move);
                d.etag(s.MoveItems), o.conn.postCommand(d, function(e) {
                    e && (n = e, console.error("failure moving messages:", e)), c();
                });
            }, function() {
                t(n, null, !0);
            }, function() {
                n = "aborted-retry";
            }, !1, "move");
        }),
        check_move: function() {},
        local_undo_move: n.local_undo_move,
        undo_move: function() {},
        local_do_delete: n.local_do_delete,
        do_delete: l(1, function(e, t) {
            var n = null, o = r.Tags;
            s.Tags, this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, r, s, a) {
                return r = r.filter(function(e) {
                    return !!e;
                }), r.length ? (e.performMutation(function(e) {
                    for (var t = 0; t < r.length; t++) e.stag(o.Delete).tag(o.ServerId, r[t]).etag(o.Delete);
                }, function(e) {
                    e && (n = e, console.error("failure deleting messages:", e)), a();
                }), void 0) : (a(), void 0);
            }, function() {
                t(n, null, !0);
            }, function() {
                n = "aborted-retry";
            }, !1, "delete");
        }),
        check_delete: function(e, t) {
            t(null, "idempotent");
        },
        local_undo_delete: n.local_undo_delete,
        undo_delete: function(e, t) {
            t("moot");
        },
        local_do_syncFolderList: function(e, t) {
            t(null);
        },
        do_syncFolderList: l(1, function(e, t) {
            var n, o = this.account, r = o.getFirstFolderWithType("inbox");
            r && null === r.serverId && (n = o.getFolderStorageForFolderId(r.id)), o.syncFolderList(function(e) {
                e || (o.meta.lastFolderSyncAt = Date.now()), t(e ? "aborted-retry" : null, null, !e), 
                n && n.hasActiveSlices && (e || (console.log("Refreshing fake inbox"), n.resetAndRefreshActiveSlices()));
            });
        }, "aborted-retry"),
        check_syncFolderList: function(e, t) {
            t(null, "coherent-notyet");
        },
        local_undo_syncFolderList: function(e, t) {
            t("moot");
        },
        undo_syncFolderList: function(e, t) {
            t("moot");
        },
        local_do_downloadBodies: n.local_do_downloadBodies,
        do_downloadBodies: n.do_downloadBodies,
        check_downloadBodies: n.check_downloadBodies,
        local_do_downloadBodyReps: n.local_do_downloadBodyReps,
        do_downloadBodyReps: n.do_downloadBodyReps,
        check_downloadBodyReps: n.check_downloadBodyReps,
        local_do_download: n.local_do_download,
        do_download: n.do_download,
        check_download: n.check_download,
        local_undo_download: n.local_undo_download,
        undo_download: n.undo_download,
        local_do_sendOutboxMessages: n.local_do_sendOutboxMessages,
        do_sendOutboxMessages: n.do_sendOutboxMessages,
        check_sendOutboxMessages: n.check_sendOutboxMessages,
        local_undo_sendOutboxMessages: n.local_undo_sendOutboxMessages,
        undo_sendOutboxMessages: n.undo_sendOutboxMessages,
        local_do_setOutboxSyncEnabled: n.local_do_setOutboxSyncEnabled,
        local_do_upgradeDB: n.local_do_upgradeDB,
        local_do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        check_purgeExcessMessages: function() {
            return "idempotent";
        },
        local_undo_purgeExcessMessages: function(e, t) {
            t(null);
        },
        undo_purgeExcessMessages: function(e, t) {
            t(null);
        }
    }, t(u.prototype, o.draftsMixins);
    var f = d.LOGFAB = e.register(i, {
        ActiveSyncJobDriver: {
            type: e.DAEMON,
            events: {
                savedAttachment: {
                    storage: !0,
                    mimeType: !0,
                    size: !0
                },
                saveFailure: {
                    storage: !1,
                    mimeType: !1,
                    error: !1
                }
            },
            TEST_ONLY_events: {
                saveFailure: {
                    filename: !1
                }
            },
            errors: {
                callbackErr: {
                    ex: e.EXCEPTION
                }
            }
        }
    });
}), define("activesync/account", [ "rdcommon/log", "../a64", "../accountmixins", "../mailslice", "../searchfilter", "activesync/codepages/FolderHierarchy", "./folder", "./jobs", "../util", "../db/folder_info_rep", "module", "require", "exports" ], function(e, t, n, o, r, s, a, i, c, d, l, u, h) {
    function f(e, t, n) {
        return function() {
            var o = Array.slice(arguments), r = o[e], s = this;
            this.withConnection(r, function() {
                t.apply(s, o);
            }, n);
        };
    }
    function g(e, t, r, s, c, d) {
        this.universe = e, this.id = t.id, this.accountDef = t, t.connInfo.deviceId || (t.connInfo.deviceId = h.makeUniqueDeviceId()), 
        this._db = s, this._LOG = I.ActiveSyncAccount(this, d, this.id), c ? (this.conn = c, 
        this._attachLoggerToConnection(this.conn)) : this.conn = null, this.enabled = !0, 
        this.problems = [], this._alive = !0, this.identities = t.identities, this.folders = [], 
        this._folderStorages = {}, this._folderInfos = r, this._serverIdToFolderId = {}, 
        this._deadFolderIds = null, this._syncsInProgress = 0, this._lastSyncKey = null, 
        this._lastSyncResponseWasEmpty = !1, this.meta = r.$meta, this.mutations = r.$mutations;
        for (var l in r) if ("$" !== l[0]) {
            var u = r[l];
            this._folderStorages[l] = new o.FolderStorage(this, l, u, this._db, a.ActiveSyncFolderSyncer, this._LOG), 
            this._serverIdToFolderId[u.$meta.serverId] = l, this.folders.push(u.$meta);
        }
        this.folders.sort(function(e, t) {
            return e.path.localeCompare(t.path);
        }), this._jobDriver = new i.ActiveSyncJobDriver(this, this._folderInfos.$mutationState), 
        this.ensureEssentialOfflineFolders(), n.accountConstructorMixin.call(this, this, this);
    }
    var y, p, v, m = c.bsearchForInsert, _ = s.Enums.Type, S = h.DEFAULT_TIMEOUT_MS = 3e4;
    h.makeUniqueDeviceId = function() {
        return Math.random().toString(36).substr(2);
    }, h.Account = h.ActiveSyncAccount = g, g.prototype = {
        type: "activesync",
        supportsServerFolders: !0,
        toString: function() {
            return "[ActiveSyncAccount: " + this.id + "]";
        },
        withConnection: function(e, t, n) {
            if (!y) return u([ "wbxml", "activesync/protocol", "activesync/codepages" ], function(o, r, s) {
                y = o, p = r, v = s, this.withConnection(e, t, n);
            }.bind(this)), void 0;
            if (!this.conn) {
                var o = this.accountDef;
                this.conn = new p.Connection(o.connInfo.deviceId), this._attachLoggerToConnection(this.conn), 
                this.conn.open(o.connInfo.server, o.credentials.username, o.credentials.password), 
                this.conn.timeout = S;
            }
            this.conn.connected ? t() : this.conn.connect(function(o) {
                return o ? (this._reportErrorIfNecessary(o), this._isBadUserOrPassError(o) && !n && (n = "bad-user-or-pass"), 
                e(n || "unknown"), void 0) : (t(), void 0);
            }.bind(this));
        },
        _isBadUserOrPassError: function(e) {
            return e && e instanceof p.HttpError && 401 === e.status;
        },
        _reportErrorIfNecessary: function(e) {
            e && this._isBadUserOrPassError(e) && this.universe.__reportAccountProblem(this, "bad-user-or-pass", "incoming");
        },
        _attachLoggerToConnection: function(e) {
            var t = I.ActiveSyncConnection(e, this._LOG, Date.now() % 1e3);
            "safe" === t.logLevel ? e.onmessage = this._onmessage_safe.bind(this, t) : "dangerous" === t.logLevel && (e.onmessage = this._onmessage_dangerous.bind(this, t));
        },
        _onmessage_safe: function(e, t, n, o, r, s, a, i) {
            "options" === t ? e.options(n, o.status, i) : e.command(t, n, o.status);
        },
        _onmessage_dangerous: function(e, t, n, o, r, s, a, i) {
            if ("options" === t) e.options(n, o.status, i); else {
                var c, d;
                if (a) try {
                    var l = new y.Reader(new Uint8Array(a), v);
                    c = l.dump();
                } catch (u) {
                    c = "parse problem";
                }
                if (i) try {
                    d = i.dump(), i.rewind();
                } catch (u) {
                    d = "parse problem";
                }
                e.command(t, n, o.status, r, s, c, d);
            }
        },
        toBridgeWire: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: this.accountDef.type,
                defaultPriority: this.accountDef.defaultPriority,
                enabled: this.enabled,
                problems: this.problems,
                syncRange: this.accountDef.syncRange,
                syncInterval: this.accountDef.syncInterval,
                notifyOnNew: this.accountDef.notifyOnNew,
                playSoundOnSend: this.accountDef.playSoundOnSend,
                identities: this.identities,
                credentials: {
                    username: this.accountDef.credentials.username
                },
                servers: [ {
                    type: this.accountDef.type,
                    connInfo: this.accountDef.connInfo
                } ]
            };
        },
        toBridgeFolder: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: "account"
            };
        },
        get numActiveConns() {
            return 0;
        },
        checkAccount: function(e) {
            null != this.conn && (this.conn.connected && this.conn.disconnect(), this.conn = null), 
            this.withConnection(function(t) {
                e(t);
            }, function() {
                e();
            });
        },
        __checkpointSyncCompleted: function(e, t) {
            this.saveAccountState(null, e, t || "checkpointSync");
        },
        shutdown: function(e) {
            this._LOG.__die(), e && e();
        },
        accountDeleted: function() {
            this._alive = !1, this.shutdown();
        },
        sliceFolderMessages: function(e, t) {
            var n = this._folderStorages[e], r = new o.MailSlice(t, n, this._LOG);
            n.sliceOpenMostRecent(r);
        },
        searchFolderMessages: function(e, t, n, o) {
            var s = this._folderStorages[e], a = new r.SearchSlice(t, s, n, o, this._LOG);
            return s.sliceOpenSearch(a), a;
        },
        syncFolderList: f(0, function(e) {
            var t = this, n = v.FolderHierarchy.Tags, o = new y.Writer("1.3", 1, "UTF-8");
            o.stag(n.FolderSync).tag(n.SyncKey, this.meta.syncKey).etag(), this.conn.postCommand(o, function(o, r) {
                if (o) return t._reportErrorIfNecessary(o), e(o), void 0;
                var s = new y.EventParser(), a = [];
                s.addEventListener([ n.FolderSync, n.SyncKey ], function(e) {
                    t.meta.syncKey = e.children[0].textContent;
                }), s.addEventListener([ n.FolderSync, n.Changes, [ n.Add, n.Delete ] ], function(e) {
                    var o = {};
                    for (var r in Iterator(e.children)) {
                        var s = r[1];
                        o[s.localTagName] = s.children[0].textContent;
                    }
                    e.tag === n.Add ? t._addedFolder(o.ServerId, o.ParentId, o.DisplayName, o.Type) || a.push(o) : t._deletedFolder(o.ServerId);
                });
                try {
                    s.run(r);
                } catch (i) {
                    return console.error("Error parsing FolderSync response:", i, "\n", i.stack), e("unknown"), 
                    void 0;
                }
                for (;a.length; ) {
                    var c = [];
                    for (var d in Iterator(a)) {
                        var l = d[1];
                        t._addedFolder(l.ServerId, l.ParentId, l.DisplayName, l.Type) || c.push(l);
                    }
                    if (c.length === a.length) throw new Error("got some orphaned folders");
                    a = c;
                }
                t.ensureEssentialOnlineFolders(), t.normalizeFolderHierarchy(), console.log("Synced folder list"), 
                e && e(null);
            });
        }),
        _folderTypes: {
            1: "normal",
            2: "inbox",
            3: "drafts",
            4: "trash",
            5: "sent",
            6: "normal",
            12: "normal"
        },
        _junkFolderNames: [ "bulk mail", "correo no deseado", "courrier indésirable", "istenmeyen", "istenmeyen e-posta", "junk", "levélszemét", "nevyžiadaná pošta", "nevyžádaná pošta", "no deseado", "posta indesiderata", "pourriel", "roskaposti", "skräppost", "spam", "spamowanie", "søppelpost", "thư rác", "спам", "דואר זבל", "الرسائل العشوائية", "هرزنامه", "สแปม", "垃圾郵件", "垃圾邮件", "垃圾電郵" ],
        _addedFolder: function(e, n, r, s, i, c) {
            if (!(i || s in this._folderTypes)) return !0;
            var l = r, u = null, h = 0;
            if ("0" !== n) {
                if (u = this._serverIdToFolderId[n], void 0 === u) return null;
                var f = this._folderInfos[u];
                l = f.$meta.path + "/" + l, h = f.$meta.depth + 1;
            }
            var g = this._folderTypes[s];
            if (2 > h) {
                var y = r.toLowerCase();
                -1 !== this._junkFolderNames.indexOf(y) && (g = "junk");
            }
            if (i && (g = i), s === _.DefaultInbox) {
                var p = this.getFirstFolderWithType("inbox");
                if (p) return delete this._serverIdToFolderId[p.serverId], this._serverIdToFolderId[e] = p.id, 
                p.serverId = e, p.name = r, p.path = l, p.depth = h, p;
            }
            var v = this.id + "/" + t.encodeInt(this.meta.nextFolderNum++), S = this._folderInfos[v] = {
                $meta: d.makeFolderMeta({
                    id: v,
                    serverId: e,
                    name: r,
                    type: g,
                    path: l,
                    parentId: u,
                    depth: h,
                    lastSyncedAt: 0,
                    syncKey: "0",
                    version: o.FOLDER_DB_VERSION
                }),
                $impl: {
                    nextId: 0,
                    nextHeaderBlock: 0,
                    nextBodyBlock: 0
                },
                accuracy: [],
                headerBlocks: [],
                bodyBlocks: [],
                serverIdHeaderBlockMapping: {}
            };
            console.log("Added folder " + r + " (" + v + ")"), this._folderStorages[v] = new o.FolderStorage(this, v, S, this._db, a.ActiveSyncFolderSyncer, this._LOG), 
            this._serverIdToFolderId[e] = v;
            var I = S.$meta, w = m(this.folders, I, function(e, t) {
                return e.path.localeCompare(t.path);
            });
            return this.folders.splice(w, 0, I), c || this.universe.__notifyAddedFolder(this, I), 
            I;
        },
        _deletedFolder: function(e, t) {
            var n = this._serverIdToFolderId[e], o = this._folderInfos[n], r = o.$meta;
            console.log("Deleted folder " + r.name + " (" + n + ")"), delete this._serverIdToFolderId[e], 
            delete this._folderInfos[n], delete this._folderStorages[n];
            var s = this.folders.indexOf(r);
            this.folders.splice(s, 1), null === this._deadFolderIds && (this._deadFolderIds = []), 
            this._deadFolderIds.push(n), t || this.universe.__notifyRemovedFolder(this, r);
        },
        _recreateFolder: function(e, t) {
            this._LOG.recreateFolder(e);
            var n = this._folderInfos[e];
            n.$impl = {
                nextId: 0,
                nextHeaderBlock: 0,
                nextBodyBlock: 0
            }, n.accuracy = [], n.headerBlocks = [], n.bodyBlocks = [], n.serverIdHeaderBlockMapping = {}, 
            null === this._deadFolderIds && (this._deadFolderIds = []), this._deadFolderIds.push(e);
            var r = this;
            this.saveAccountState(null, function() {
                var s = new o.FolderStorage(r, e, n, r._db, a.ActiveSyncFolderSyncer, r._LOG);
                for (var i in Iterator(r._folderStorages[e]._slices)) {
                    var c = i[1];
                    c._storage = s, c.reset(), s.sliceOpenMostRecent(c);
                }
                r._folderStorages[e]._slices = [], r._folderStorages[e] = s, t(s);
            }, "recreateFolder");
        },
        createFolder: f(3, function(e, t, n, o) {
            var r = this, s = e ? this._folderInfos[e] : "0", a = v.FolderHierarchy.Tags, i = v.FolderHierarchy.Enums.Status, c = v.FolderHierarchy.Enums.Type.Mail, d = new y.Writer("1.3", 1, "UTF-8");
            d.stag(a.FolderCreate).tag(a.SyncKey, this.meta.syncKey).tag(a.ParentId, s).tag(a.DisplayName, t).tag(a.Type, c).etag(), 
            this.conn.postCommand(d, function(e, n) {
                r._reportErrorIfNecessary(e);
                var d, l, u = new y.EventParser();
                u.addEventListener([ a.FolderCreate, a.Status ], function(e) {
                    d = e.children[0].textContent;
                }), u.addEventListener([ a.FolderCreate, a.SyncKey ], function(e) {
                    r.meta.syncKey = e.children[0].textContent;
                }), u.addEventListener([ a.FolderCreate, a.ServerId ], function(e) {
                    l = e.children[0].textContent;
                });
                try {
                    u.run(n);
                } catch (h) {
                    return console.error("Error parsing FolderCreate response:", h, "\n", h.stack), 
                    o("unknown"), void 0;
                }
                if (d === i.Success) {
                    var f = r._addedFolder(l, s, t, c);
                    o(null, f);
                } else d === i.FolderExists ? o("already-exists") : o("unknown");
            });
        }),
        deleteFolder: f(1, function(e, t) {
            var n = this, o = this._folderInfos[e].$meta, r = v.FolderHierarchy.Tags, s = v.FolderHierarchy.Enums.Status;
            v.FolderHierarchy.Enums.Type.Mail;
            var a = new y.Writer("1.3", 1, "UTF-8");
            a.stag(r.FolderDelete).tag(r.SyncKey, this.meta.syncKey).tag(r.ServerId, o.serverId).etag(), 
            this.conn.postCommand(a, function(e, a) {
                n._reportErrorIfNecessary(e);
                var i, c = new y.EventParser();
                c.addEventListener([ r.FolderDelete, r.Status ], function(e) {
                    i = e.children[0].textContent;
                }), c.addEventListener([ r.FolderDelete, r.SyncKey ], function(e) {
                    n.meta.syncKey = e.children[0].textContent;
                });
                try {
                    c.run(a);
                } catch (d) {
                    return console.error("Error parsing FolderDelete response:", d, "\n", d.stack), 
                    t("unknown"), void 0;
                }
                i === s.Success ? (n._deletedFolder(o.serverId), t(null, o)) : t("unknown");
            });
        }),
        sendMessage: f(1, function(e, t) {
            var n = this;
            e.withMessageBlob({
                includeBcc: !0
            }, function(o) {
                if (this.conn.currentVersion.gte("14.0")) {
                    var r = v.ComposeMail.Tags, s = new y.Writer("1.3", 1, "UTF-8", null, "blob");
                    s.stag(r.SendMail).tag(r.ClientId, Date.now().toString() + "@mozgaia").tag(r.SaveInSentItems).stag(r.Mime).opaque(o).etag().etag(), 
                    this.conn.postCommand(s, function(e, o) {
                        return e ? (n._reportErrorIfNecessary(e), console.error(e), t("unknown"), void 0) : (null === o ? (console.log("Sent message successfully!"), 
                        t(null)) : (console.error("Error sending message. XML dump follows:\n" + o.dump()), 
                        t("unknown")), void 0);
                    }, null, null, function() {
                        e.renewSmartWakeLock("ActiveSync XHR Progress");
                    });
                } else this.conn.postData("SendMail", "message/rfc822", o, function(e) {
                    return e ? (n._reportErrorIfNecessary(e), console.error(e), t("unknown"), void 0) : (console.log("Sent message successfully!"), 
                    t(null), void 0);
                }, {
                    SaveInSent: "T"
                }, null, function() {
                    e.renewSmartWakeLock("ActiveSync XHR Progress");
                });
            }.bind(this));
        }),
        getFolderStorageForFolderId: function(e) {
            return this._folderStorages[e];
        },
        getFolderStorageForServerId: function(e) {
            return this._folderStorages[this._serverIdToFolderId[e]];
        },
        getFolderMetaForFolderId: function(e) {
            return this._folderInfos.hasOwnProperty(e) ? this._folderInfos[e].$meta : null;
        },
        ensureEssentialOfflineFolders: function() {
            [ {
                type: "inbox",
                displayName: "Inbox",
                typeNum: _.DefaultInbox
            }, {
                type: "outbox",
                displayName: "outbox",
                typeNum: _.Unknown
            }, {
                type: "localdrafts",
                displayName: "localdrafts",
                typeNum: _.Unknown
            } ].forEach(function(e) {
                this.getFirstFolderWithType(e.type) || this._addedFolder(null, "0", e.displayName, e.typeNum, e.type, !0);
            }, this);
        },
        ensureEssentialOnlineFolders: function(e) {
            e && e();
        },
        normalizeFolderHierarchy: n.normalizeFolderHierarchy,
        scheduleMessagePurge: function(e, t) {
            t && t();
        },
        upgradeFolderStoragesIfNeeded: n.upgradeFolderStoragesIfNeeded,
        runOp: n.runOp,
        getFirstFolderWithType: n.getFirstFolderWithType,
        getFolderByPath: n.getFolderByPath,
        saveAccountState: n.saveAccountState,
        runAfterSaves: n.runAfterSaves,
        allOperationsCompleted: function() {}
    };
    var I = h.LOGFAB = e.register(l, {
        ActiveSyncAccount: {
            type: e.ACCOUNT,
            events: {
                createFolder: {},
                deleteFolder: {},
                recreateFolder: {
                    id: !1
                },
                accountDeleted: {
                    where: !1
                }
            },
            asyncJobs: {
                runOp: {
                    mode: !0,
                    type: !0,
                    error: !0,
                    op: !1
                },
                saveAccountState: {
                    reason: !0,
                    folderSaveCount: !0
                }
            },
            errors: {
                opError: {
                    mode: !1,
                    type: !1,
                    ex: e.EXCEPTION
                }
            }
        },
        ActiveSyncConnection: {
            type: e.CONNECTION,
            events: {
                options: {
                    special: !1,
                    status: !1,
                    result: !1
                },
                command: {
                    name: !1,
                    special: !1,
                    status: !1
                }
            },
            TEST_ONLY_events: {
                options: {},
                command: {
                    params: !1,
                    extraHeaders: !1,
                    sent: !1,
                    response: !1
                }
            }
        }
    });
}), define("activesync/configurator", [ "rdcommon/log", "slog", "../accountcommon", "../a64", "./account", "../date", "tcp-socket", "require", "exports" ], function(e, t, n, o, r, s, a, i, c) {
    function d(e, t) {
        function n(e) {
            if (i) {
                var n = i;
                i = null;
                try {
                    n.close();
                } catch (o) {}
                t(e);
            }
        }
        var o = /^https:\/\/([^:/]+)(?::(\d+))?/.exec(e);
        if (!o) return t(null), void 0;
        var r = o[2] ? parseInt(o[2], 10) : 443, s = o[1];
        console.log("checking", s, r, "for security problem");
        var i = a.open(s, r);
        i.onopen = function() {
            i.send(new TextEncoder("utf-8").encode("GET /images/logo.png HTTP/1.1\n\n"));
        }, i.onerror = function(e) {
            var t = null;
            e && "object" == typeof e && /^Security/.test(e.name) && (t = "bad-security"), n(t);
        }, i.ondata = function() {
            n(null);
        };
    }
    c.account = r, c.configurator = {
        timeout: 3e4,
        _getFullDetailsFromAutodiscover: function(e, n, o, r) {
            t.log("activesync.configurator.autodiscover:begin", {
                url: o
            }), e.raw_autodiscover(o, n.emailAddress, n.password, self.timeout, !1, function(n, s) {
                if (n) {
                    var a = "no-config-info", i = {};
                    return n instanceof e.HttpError ? 401 === n.status ? a = "bad-user-or-pass" : 403 === n.status ? a = "not-authorized" : i.status = n.status : n instanceof e.AutodiscoverDomainError && t.log("activesync.configurator.autodiscover.error", {
                        message: n.message
                    }), t.log("activesync.configurator.autodiscover:end", {
                        url: o,
                        err: a
                    }), r(a, null, i), void 0;
                }
                t.log("activesync.configurator.autodiscover:end", {
                    url: o,
                    server: s.mobileSyncServer.url
                });
                var c = {
                    type: "activesync",
                    displayName: s.user.name,
                    incoming: {
                        server: s.mobileSyncServer.url,
                        username: s.user.email
                    }
                };
                r(null, c, null);
            });
        },
        tryToCreateAccount: function(e, t, n, o, r) {
            i([ "activesync/protocol" ], function(s) {
                return n.incoming.autodiscoverEndpoint ? (this._getFullDetailsFromAutodiscover(s, t, n.incoming.autodiscoverEndpoint, function(n, a, i) {
                    return n ? (o(n, a, i), void 0) : (this._createAccountUsingFullInfo(e, t, a, o, s, r), 
                    void 0);
                }.bind(this)), void 0) : (this._createAccountUsingFullInfo(e, t, n, o, s, r), void 0);
            }.bind(this));
        },
        _createAccountUsingFullInfo: function(e, n, a, i, c) {
            t.log("activesync.configurator.create:begin", {
                server: a.incoming.server
            });
            var l = {
                username: a.incoming.username,
                password: n.password
            }, u = r.makeUniqueDeviceId(), h = this, f = new c.Connection(u);
            f.open(a.incoming.server, l.username, l.password), f.timeout = r.DEFAULT_TIMEOUT_MS, 
            f.connect(function(r) {
                if (r) {
                    var g, y = {
                        server: a.incoming.server
                    };
                    return r instanceof c.HttpError ? (401 === r.status ? g = "bad-user-or-pass" : 403 === r.status ? g = "not-authorized" : (g = "server-problem", 
                    y.status = r.status), t.log("activesync.configurator.create:end", {
                        server: a.incoming.server,
                        err: g
                    }), i(g, null, y), void 0) : (d(a.incoming.server, function(e) {
                        var t;
                        t = e ? "bad-security" : "unresponsive-server", i(t, null, y);
                    }), void 0);
                }
                var p = o.encodeInt(e.config.nextAccountNum++), v = {
                    id: p,
                    name: n.accountName || n.emailAddress,
                    defaultPriority: s.NOW(),
                    type: "activesync",
                    syncRange: "auto",
                    syncInterval: n.syncInterval || 0,
                    notifyOnNew: n.hasOwnProperty("notifyOnNew") ? n.notifyOnNew : !0,
                    playSoundOnSend: n.hasOwnProperty("playSoundOnSend") ? n.playSoundOnSend : !0,
                    credentials: l,
                    connInfo: {
                        server: a.incoming.server,
                        deviceId: u
                    },
                    identities: [ {
                        id: p + "/" + o.encodeInt(e.config.nextIdentityNum++),
                        name: n.displayName || a.displayName,
                        address: n.emailAddress,
                        replyTo: null,
                        signature: null
                    } ]
                };
                t.log("activesync.configurator.create:end", {
                    server: a.incoming.server,
                    id: p
                }), h._loadAccount(e, v, f, function(e) {
                    i(null, e, null);
                });
            });
        },
        recreateAccount: function(e, t, s, a) {
            var i = s.def, c = {
                username: i.credentials.username,
                password: i.credentials.password
            }, d = o.encodeInt(e.config.nextAccountNum++), l = {
                id: d,
                name: i.name,
                type: "activesync",
                syncRange: i.syncRange,
                syncInterval: i.syncInterval || 0,
                notifyOnNew: i.hasOwnProperty("notifyOnNew") ? i.notifyOnNew : !0,
                playSoundOnSend: i.hasOwnProperty("playSoundOnSend") ? i.playSoundOnSend : !0,
                credentials: c,
                connInfo: {
                    server: i.connInfo.server,
                    deviceId: i.connInfo.deviceId || r.makeUniqueDeviceId()
                },
                identities: n.recreateIdentities(e, d, i.identities)
            };
            this._loadAccount(e, l, null, function(e) {
                a(null, e, null);
            });
        },
        _loadAccount: function(e, t, n, o) {
            var r = {
                $meta: {
                    nextFolderNum: 0,
                    nextMutationNum: 0,
                    lastFolderSyncAt: 0,
                    syncKey: "0"
                },
                $mutations: [],
                $mutationState: {}
            };
            e.saveAccountDef(t, r), e._loadAccount(t, r, n, o);
        }
    };
});