;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;'use strict';(function(){var loader=LazyLoader;window.LazyL10n={_baseLoaded:false,_ready:false,get:function ll10n_get(callback){if(this._ready){callback(navigator.mozL10n.get);return;}
var loadDateAndFinalize=this._loadDateAndFinalize.bind(this,callback);if(this._baseLoaded){navigator.mozL10n.once(loadDateAndFinalize);return;}
loader.load(['/shared/js/l10n.js'],function baseLoaded(){this._baseLoaded=true;navigator.mozL10n.once(loadDateAndFinalize);}.bind(this));},_loadDateAndFinalize:function ll10n_loadDateAndFinalize(callback){loader.load('/shared/js/l10n_date.js',this._finalize.bind(this,callback));},_finalize:function ll10n_finalize(callback){this._ready=true;callback(navigator.mozL10n.get);}};}());;'use strict';function onLoadCallScreen(evt){window.removeEventListener('load',onLoadCallScreen);CallsHandler.setup();AudioCompetingHelper.init('callscreen');CallScreen.init();KeypadManager.init(true);}
function unloadCallScreen(evt){}
window.addEventListener('load',onLoadCallScreen);window.addEventListener('unload',unloadCallScreen);;'use strict';var SettingsListener={_timer:null,_lock:null,_observers:[],getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));var settingChanged=function settingChanged(evt){callback(evt.settingValue);};settings.addObserver(name,settingChanged);this._observers.push({name:name,callback:callback,observer:settingChanged});},unobserve:function sl_unobserve(name,callback){var settings=window.navigator.mozSettings;var that=this;this._observers.forEach(function(value,index){if(value.name===name&&value.callback===callback){settings.removeObserver(name,value.observer);that._observers.splice(index,1);}});}};;'use strict';function SettingsURL(){this._url=null;this._isBlob=false;}
SettingsURL.prototype={set:function(value){if(this._isBlob){window.URL.revokeObjectURL(this._url);}
if(value instanceof Blob){this._isBlob=true;this._url=window.URL.createObjectURL(value);}else{this._isBlob=false;this._url=value;}
return this._url;},get:function(){return this._url;}};;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;(function(exports){'use strict';function getThumbnail(contact){return getOnePhoto(contact,'begin');}
function getFullResolution(contact){return getOnePhoto(contact,'end');}
function getOnePhoto(contact,position){if(!contact||!contact.photo||!contact.photo.length){return null;}
if(contact.photo.length===1){return contact.photo[0];}
var photos=contact.photo;var category=contact.category;if(Array.isArray(category)&&category.indexOf('fb_linked')!==-1){if(photos.length>=4){return photos[(position=='begin')?1:0];}
return photos[0];}
photos=photosBySize(contact);var index=(position=='begin')?0:photos.length-1;return photos[index];}
function photosBySize(contact){var photos=contact.photo.slice(0);photos.sort(function(p1,p2){if(size(p1)<size(p2)){return-1;}
if(size(p1)>size(p2)){return 1;}
return 0;});return photos;}
function size(photo){if(typeof photo=='string'){return photo.length;}
return photo.size;}
exports.ContactPhotoHelper={getThumbnail:getThumbnail,getFullResolution:getFullResolution};})(window);;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;(function(){'use strict';if(window.navigator.mozHour12||window.navigator.hour12){return;}
window.navigator.mozHour12=null;var _setMozHour12=function(result){if(window.navigator.mozHour12!==result){window.navigator.mozHour12=result;window.dispatchEvent(new CustomEvent('timeformatchange'));}};var _hour12Handler=function(event){_setMozHour12(event.settingValue);};var _kLocaleTime='locale.hour12';var req=window.navigator.mozSettings.createLock().get(_kLocaleTime);req.onsuccess=function(){_setMozHour12(req.result[_kLocaleTime]);};window.navigator.mozSettings.addObserver(_kLocaleTime,_hour12Handler);})();;'use strict';var SimplePhoneMatcher={mcc:'724',sanitizedNumber:function spm_sanitizedNumber(number){var join=this._formattingChars.join('|\\');var regexp=new RegExp('(\\'+join+')','g');return number.replace(regexp,'');},generateVariants:function spm_generateVariants(number){var sanitizedNumber=this.sanitizedNumber(number);var variants=[];variants=variants.concat(this._internationalPrefixes(sanitizedNumber),this._trunkPrefixes(sanitizedNumber),this._carrierPrefixes(sanitizedNumber),this._areaPrefixes(sanitizedNumber));return variants.sort(function shortestFirst(a,b){return a.length>b.length;});},bestMatch:function spm_bestMatchIndex(variants,matches){var bestMatchIndex=0;var bestLocalIndex=0;var bestMatchLength=0;var allMatches=[];var matchNum=0;matches.forEach(function(match,matchIndex){var indexes=[];match.forEach(function(number,localIndex){var sanitizedNumber=this.sanitizedNumber(number);variants.forEach(function match(variant){if(variant.indexOf(sanitizedNumber)!==-1||sanitizedNumber.indexOf(variant)!==-1){var length=sanitizedNumber.length;if(indexes.indexOf(localIndex)===-1){indexes.push(localIndex);matchNum+=1;}
if(length>bestMatchLength){bestMatchLength=length;bestMatchIndex=matchIndex;bestLocalIndex=localIndex;}}});},this);if(indexes.length){allMatches.push(indexes);}else{matchNum+=1;allMatches.push([0]);}},this);return{totalMatchNum:matchNum,allMatches:allMatches,bestMatchIndex:bestMatchIndex,localIndex:bestLocalIndex};},_formattingChars:['\s','-','.','(',')'],_mccWith00Prefix:['208','214','234','235','724'],_mccWith011Prefix:['310','311','312','313','314','315','316'],_countryPrefixes:[{p:'1',t:false},{p:'1242',t:false},{p:'1246',t:false},{p:'1264',t:false},{p:'1268',t:false},{p:'1284',t:false},{p:'1340',t:false},{p:'1345',t:false},{p:'1441',t:false},{p:'1473',t:false},{p:'1649',t:false},{p:'1664',t:false},{p:'1670',t:false},{p:'1671',t:false},{p:'1684',t:false},{p:'1721',t:false},{p:'1758',t:false},{p:'1767',t:false},{p:'1784',t:false},{p:'1787',t:false},{p:'1809',t:false},{p:'1829',t:false},{p:'1849',t:false},{p:'1868',t:false},{p:'1869',t:false},{p:'1876',t:false},{p:'1939',t:false},{p:'20',t:false},{p:'210',t:false},{p:'211',t:false},{p:'212',t:false},{p:'213',t:false},{p:'214',t:false},{p:'215',t:false},{p:'216',t:false},{p:'217',t:false},{p:'218',t:false},{p:'219',t:false},{p:'220',t:false},{p:'221',t:false},{p:'222',t:false},{p:'223',t:false},{p:'224',t:false},{p:'225',t:false},{p:'226',t:false},{p:'227',t:false},{p:'228',t:false},{p:'229',t:false},{p:'230',t:false},{p:'231',t:false},{p:'232',t:false},{p:'233',t:false},{p:'234',t:false},{p:'235',t:false},{p:'236',t:false},{p:'237',t:false},{p:'238',t:false},{p:'239',t:false},{p:'240',t:false},{p:'241',t:false},{p:'242',t:false},{p:'243',t:false},{p:'244',t:false},{p:'245',t:false},{p:'246',t:false},{p:'247',t:false},{p:'248',t:false},{p:'249',t:false},{p:'250',t:false},{p:'251',t:false},{p:'252',t:false},{p:'253',t:false},{p:'254',t:false},{p:'255',t:false},{p:'256',t:false},{p:'257',t:false},{p:'258',t:false},{p:'259',t:false},{p:'260',t:false},{p:'261',t:false},{p:'262',t:false},{p:'263',t:false},{p:'264',t:false},{p:'265',t:false},{p:'266',t:false},{p:'267',t:false},{p:'268',t:false},{p:'269',t:false},{p:'27',t:false},{p:'28',t:false},{p:'290',t:false},{p:'291',t:false},{p:'292',t:false},{p:'293',t:false},{p:'294',t:false},{p:'295',t:false},{p:'296',t:false},{p:'297',t:false},{p:'298',t:false},{p:'299',t:false},{p:'30',t:false},{p:'31',t:true},{p:'32',t:true},{p:'33',t:true},{p:'34',t:false},{p:'350',t:false},{p:'351',t:true},{p:'352',t:false},{p:'353',t:false},{p:'354',t:false},{p:'355',t:true},{p:'356',t:false},{p:'357',t:false},{p:'358',t:false},{p:'359',t:true},{p:'36',t:true},{p:'370',t:true},{p:'371',t:false},{p:'372',t:false},{p:'373',t:true},{p:'374',t:false},{p:'375',t:true},{p:'376',t:false},{p:'377',t:false},{p:'378',t:false},{p:'379',t:false},{p:'380',t:true},{p:'381',t:true},{p:'382',t:true},{p:'383',t:false},{p:'384',t:false},{p:'385',t:true},{p:'386',t:false},{p:'387',t:true},{p:'388',t:false},{p:'389',t:true},{p:'39',t:false},{p:'40',t:true},{p:'41',t:true},{p:'420',t:false},{p:'421',t:false},{p:'422',t:false},{p:'423',t:false},{p:'424',t:false},{p:'425',t:false},{p:'426',t:false},{p:'427',t:false},{p:'428',t:false},{p:'429',t:false},{p:'43',t:true},{p:'44',t:true},{p:'45',t:false},{p:'46',t:true},{p:'47',t:false},{p:'48',t:true},{p:'49',t:true},{p:'500',t:false},{p:'501',t:false},{p:'502',t:false},{p:'503',t:false},{p:'504',t:false},{p:'505',t:false},{p:'506',t:false},{p:'507',t:false},{p:'508',t:false},{p:'509',t:false},{p:'51',t:true},{p:'52',t:false},{p:'53',t:false},{p:'54',t:true},{p:'55',t:true},{p:'56',t:false},{p:'57',t:false},{p:'58',t:false},{p:'590',t:false},{p:'591',t:true},{p:'592',t:false},{p:'593',t:false},{p:'594',t:false},{p:'595',t:false},{p:'596',t:false},{p:'597',t:false},{p:'598',t:false},{p:'599',t:true},{p:'60',t:true},{p:'61',t:true},{p:'62',t:true},{p:'63',t:true},{p:'64',t:false},{p:'65',t:true},{p:'66',t:true},{p:'670',t:false},{p:'671',t:false},{p:'672',t:false},{p:'673',t:true},{p:'674',t:false},{p:'675',t:false},{p:'676',t:false},{p:'677',t:false},{p:'678',t:false},{p:'679',t:false},{p:'680',t:false},{p:'681',t:false},{p:'682',t:false},{p:'683',t:false},{p:'684',t:false},{p:'685',t:false},{p:'686',t:false},{p:'687',t:false},{p:'688',t:false},{p:'689',t:false},{p:'690',t:false},{p:'691',t:false},{p:'692',t:false},{p:'693',t:false},{p:'694',t:false},{p:'695',t:false},{p:'696',t:false},{p:'697',t:false},{p:'698',t:false},{p:'699',t:false},{p:'699',t:false},{p:'7',t:true},{p:'76',t:true},{p:'77',t:true},{p:'7840',t:false},{p:'7940',t:false},{p:'800',t:false},{p:'801',t:false},{p:'802',t:false},{p:'803',t:false},{p:'804',t:false},{p:'805',t:false},{p:'806',t:false},{p:'807',t:false},{p:'808',t:false},{p:'809',t:false},{p:'81',t:false},{p:'82',t:true},{p:'83',t:false},{p:'84',t:true},{p:'850',t:true},{p:'851',t:false},{p:'852',t:false},{p:'853',t:false},{p:'854',t:false},{p:'855',t:true},{p:'856',t:true},{p:'857',t:false},{p:'858',t:false},{p:'859',t:false},{p:'86',t:true},{p:'870',t:false},{p:'871',t:false},{p:'872',t:false},{p:'873',t:false},{p:'874',t:false},{p:'875',t:false},{p:'876',t:false},{p:'877',t:false},{p:'878',t:false},{p:'879',t:false},{p:'880',t:true},{p:'881',t:false},{p:'882',t:false},{p:'883',t:false},{p:'884',t:false},{p:'885',t:false},{p:'886',t:true},{p:'887',t:false},{p:'888',t:false},{p:'889',t:false},{p:'89',t:false},{p:'90',t:false},{p:'91',t:true},{p:'92',t:true},{p:'93',t:true},{p:'94',t:false},{p:'95',t:true},{p:'960',t:false},{p:'961',t:false},{p:'962',t:false},{p:'963',t:false},{p:'964',t:false},{p:'965',t:false},{p:'966',t:false},{p:'967',t:false},{p:'968',t:false},{p:'969',t:false},{p:'970',t:false},{p:'971',t:false},{p:'972',t:false},{p:'973',t:false},{p:'974',t:false},{p:'975',t:true},{p:'976',t:true},{p:'977',t:true},{p:'978',t:false},{p:'979',t:false},{p:'98',t:false},{p:'990',t:false},{p:'991',t:false},{p:'992',t:false},{p:'993',t:true},{p:'994',t:true},{p:'995',t:true},{p:'996',t:false},{p:'997',t:false},{p:'998',t:true},{p:'999',t:false}],_trunkCodes:['0'],_areaCodeSwipe:{'55':2,'44':3,'1':3},_internationalPrefixes:function spm_internatialPrefixes(number){var variants=[number];var internationalPrefix='';if(this._mccWith00Prefix.indexOf(this.mcc)!==-1){internationalPrefix='00';}
if(this._mccWith011Prefix.indexOf(this.mcc)!==-1){internationalPrefix='011';}
var plusRegexp=new RegExp('^\\+');if(number.match(plusRegexp)){variants.push(number.replace(plusRegexp,internationalPrefix));}
var ipRegexp=new RegExp('^'+internationalPrefix);if(number.match(ipRegexp)){variants.push(number.replace(ipRegexp,'+'));}
return variants;},_trunkPrefixes:function spm_trunkPrefixes(number){var variants=[];var prefixesWithTrunk0=[];var prefixesWithNoTrunk=[];this._countryPrefixes.forEach(function(prefix){if(prefix.t){prefixesWithTrunk0.push(prefix.p);}else{prefixesWithNoTrunk.push(prefix.p);}});var trunk0Join=prefixesWithTrunk0.join('|');var trunk0Regexp=new RegExp('^\\+('+trunk0Join+')');this._internationalPrefixes(number).some(function match(variant){var match=variant.match(trunk0Regexp);if(match){variants.push(variant.replace(trunk0Regexp,'0'));variants.push(variant.replace(trunk0Regexp,''));}
return match;});var noTrunkJoin=prefixesWithNoTrunk.join('|');var noTrunkRegexp=new RegExp('^\\+('+noTrunkJoin+')');this._internationalPrefixes(number).some(function match(variant){var match=variant.match(noTrunkRegexp);if(match){variants.push(variant.replace(noTrunkRegexp,''));}
return match;});var withTrunkRegexp=new RegExp('^('+this._trunkCodes.join('|')+')');if(number.match(withTrunkRegexp)){variants.push(number.replace(withTrunkRegexp,''));}
return variants;},_areaPrefixes:function spm_areaPrefixes(number){var variants=[];Object.keys(this._areaCodeSwipe).forEach(function(country){var re=new RegExp('^\\+'+country);this._internationalPrefixes(number).some(function match(variant){var match=variant.match(re);if(match){var afterArea=1+country.length+this._areaCodeSwipe[country];variants.push(variant.substring(afterArea));}
return match;},this);},this);return variants;},_carrierPrefixes:function spm_carrierPrefix(number){if(this.mcc!='724'){return[];}
var variants=[];var withTrunk=new RegExp('^0');if(number.length>=13&&number.match(withTrunk)){var afterCarrier=3;variants.push(number.substring(afterCarrier));}
return variants;}};;'use strict';var Contacts={_FB_FILES:['/shared/js/fb/fb_request.js','/shared/js/fb/fb_data_reader.js','/shared/js/fb/fb_reader_utils.js'],getRevision:function getRevision(callback){var mozContacts=navigator.mozContacts;if(!mozContacts){callback(null);return;}
var req=mozContacts.getRevision();req.onsuccess=function onsuccess(event){callback(event.target.result);};req.onerror=function onerror(event){console.log('Error '+event.target.error);callback(null);};},findByNumber:function findByNumber(number,callback){LazyLoader.load(this._FB_FILES,this._findByNumber.bind(this,number,callback));},_findByNumber:function _findByNumber(number,callback){if(!number){callback(null);return;}
var options;var variants;if(number.length<7){variants=[number];options={filterBy:['tel'],filterOp:'equals',filterValue:number};}else{variants=SimplePhoneMatcher.generateVariants(number);var sanitizedNumber=SimplePhoneMatcher.sanitizedNumber(number);options={filterBy:['tel'],filterOp:'match',filterValue:sanitizedNumber};}
var mozContacts=navigator.mozContacts;if(!mozContacts){callback(null);return;}
var request=mozContacts.find(options);request.onsuccess=function findCallback(){var contacts=request.result;if(contacts.length===0){fb.getContactByNumber(number,function fb_ready(finalContact){var objMatching=null;if(finalContact){objMatching={value:number,type:'personal',carrier:null};}
callback(finalContact,objMatching);},function fb_err(err){callback(null);});return;}
var matches=contacts.map(function getTels(contact){return contact.tel.map(function getNumber(tel){return tel.value;});});var matchResult=SimplePhoneMatcher.bestMatch(variants,matches);var contact=contacts[matchResult.bestMatchIndex];var contactsWithSameNumber;if(contacts.length>1){contactsWithSameNumber=contacts.length-1;}
var matchingTel=contact.tel[matchResult.localIndex];if(fb.isFbLinked(contact)){var req=fb.getData(contact);req.onsuccess=function(){callback(req.result,matchingTel,contactsWithSameNumber);};req.onerror=function(){window.console.error('Error while getting FB Data');callback(contact,matchingTel,contactsWithSameNumber);};}
else{callback(contact,matchingTel,contactsWithSameNumber);}};request.onerror=function findError(){callback(null);};},_mergeOneFbContact:function _mergeOneFbContact(contacts,index){return new Promise(function(resolve,reject){var fbReq=fb.getData(contacts[index]);fbReq.onsuccess=function(){var originalTel=contacts[index].tel;contacts[index]=fbReq.result;contacts[index].tel=originalTel;resolve();};fbReq.onerror=function(){console.error('Could not merge Facebook data for',contacts[index].id);reject();};});},_mergeFbContacts:function _mergeFbContacts(contacts,callback){if(!callback||!(callback instanceof Function)){return;}
if(!contacts){callback(null);}
LazyLoader.load(this._FB_FILES,function(){var pending=contacts.length;var onContactMerged=function(){if(--pending===0){callback(contacts);}};for(var i=0,length=contacts.length;i<length;i++){if(fb.isFbContact(contacts[i])){this._mergeOneFbContact(contacts,i).then(onContactMerged,onContactMerged);}else{onContactMerged();}}}.bind(this));},_findContacts:function _findContacts(options,callback){if(!callback||!(callback instanceof Function)){return;}
if(!navigator.mozContacts||!options){callback(null);return;}
var self=this;var req=navigator.mozContacts.find(options);req.onsuccess=function onsuccess(){var contacts=req.result;if(!contacts.length){callback(null);return;}
self._mergeFbContacts(contacts,callback);};req.onerror=function onerror(){console.error('Contact finding error. Error: '+req.errorCode);callback(null);};},findListByNumber:function findListByNumber(number,limit,callback){var self=this;asyncStorage.getItem('order.lastname',function(value){var sortKey=value?'familyName':'givenName';var options={filterBy:['tel'],filterOp:'contains',filterValue:number,sortBy:sortKey,sortOrder:'ascending',filterLimit:limit};self._findContacts(options,callback);});},getLength:function getLength(prop){if(!prop||!prop.length){return 0;}
return prop.length;},sendEmailOrPick:function sendEmailOrPick(address){try{new MozActivity({name:'new',data:{type:'mail',URI:'mailto:'+address}});}catch(e){console.error('WebActivities unavailable? : '+e);}}};;'use strict';const kMasterVolume=0.5;const kToneVolume=0.7;const kShortPressDuration=0.15;const kAttackDuration=0.025;const kDecayDuration=0.025;const kReleaseDuration=0.05;var TonePlayer={_audioContext:null,_channel:null,_gainNode:null,_playingNodes:[],_maybeTrashAudio:null,_initialized:false,init:function tp_init(channel){var telephony=navigator.mozTelephony;this._reset();this._channel=channel;this._maybeTrashAudio=(function tp_maybeTrashAudio(){var callIsActive=telephony&&(telephony.calls.length||telephony.conferenceGroup.calls.length);if(document.hidden&&!((this._channel==='telephony')&&callIsActive)){this._trashAudio();}}).bind(this);window.addEventListener('visibilitychange',this._maybeTrashAudio);telephony&&telephony.addEventListener('callschanged',this._maybeTrashAudio);this._initialized=true;},teardown:function tp_teardown(){var telephony=navigator.mozTelephony;telephony&&telephony.removeEventListener('callschanged',this._maybeTrashAudio);window.removeEventListener('visibilitychange',this._maybeTrashAudio);this._reset();this._initialized=false;},_reset:function tp_reset(){this._audioContext=null;this._channel=null;this._gainNode=null;this._playingNodes=[];this._maybeTrashAudio=null;},_ensureAudio:function tp_ensureAudio(){if(this._audioContext||!this._initialized){return;}
this._audioContext=new AudioContext(this._channel);},_trashAudio:function tp_trashAudio(){this.stop();this._audioContext=null;},_startAt:function tp_startAt(frequencies,when,duration){var context=this._audioContext;var sampleRate=context.sampleRate;var envelope=context.createBuffer(1,(duration?duration:0.05)*sampleRate,sampleRate);for(var i=0;i<envelope.length;i++){var factor=kToneVolume;var t=i/sampleRate;if(t<=kAttackDuration){factor=t/kAttackDuration;}else if(t-kAttackDuration<=kDecayDuration){factor=1.0-(1.0-kToneVolume)*(t-kAttackDuration)/kDecayDuration;}
if(!duration){factor-=kToneVolume;}else if(t>duration-kReleaseDuration){factor*=(duration-t)/kReleaseDuration;}
envelope.getChannelData(0)[i]=factor*kMasterVolume;}
var gainNode=context.createGain();gainNode.connect(context.destination);if(!duration){this._gainNode=gainNode;}
var envelopeNode=context.createBufferSource();envelopeNode.buffer=envelope;envelopeNode.start(when);envelopeNode.connect(gainNode.gain);gainNode.gain.setValueAtTime(duration?0.0:kToneVolume*kMasterVolume,0.0);for(i=0;i<frequencies.length;++i){var oscNode=this._audioContext.createOscillator();oscNode.type='sine';oscNode.frequency.value=frequencies[i];oscNode.start(when);if(duration){oscNode.stop(Math.max(when,context.currentTime+0.5)+duration);}else{this._playingNodes.push(oscNode);}
oscNode.connect(gainNode);}},start:function tp_start(frequencies,shortPress){this._ensureAudio();this._startAt(frequencies,0,shortPress?kShortPressDuration:0);},stop:function tp_stop(){if(!this._gainNode){return;}
var context=this._audioContext;var sampleRate=context.sampleRate;var gain=this._gainNode.gain;this._gainNode=null;var ramp=context.createBuffer(1,kReleaseDuration*sampleRate,sampleRate);for(var i=0;i<ramp.length;i++){ramp.getChannelData(0)[i]=(ramp.length-i-1)/ramp.length*kToneVolume*kMasterVolume;}
var rampNode=context.createBufferSource();rampNode.buffer=ramp;rampNode.start();rampNode.connect(gain);gain.setValueAtTime(0.0,0.0);while(this._playingNodes.length){this._playingNodes.pop().stop(context.currentTime+kReleaseDuration+0.5);}},playSequence:function tp_playSequence(sequence){this._ensureAudio();var when=this._audioContext.currentTime+0.2;for(var index=0;index<sequence.length;++index){var step=sequence[index];var frequencies=step.slice(0,2);var duration=step[2]/1000;this._startAt(frequencies,when,duration);when+=duration;}}};;'use strict';function DtmfTone(tone,short,serviceId){this.tone=tone;this.short=short;this.serviceId=serviceId;this.timer=0;}
DtmfTone.kShortToneLength=120;DtmfTone.prototype={play:function dt_play(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);navigator.mozTelephony.startTone(this.tone,this.serviceId);if(this.short){this.timer=window.setTimeout(function dt_stopTone(serviceId){navigator.mozTelephony.stopTone(serviceId);},DtmfTone.kShortToneLength,this.serviceId);}},stop:function dt_stop(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);}};;'use strict';var gTonesFrequencies={'1':[697,1209],'2':[697,1336],'3':[697,1477],'4':[770,1209],'5':[770,1336],'6':[770,1477],'7':[852,1209],'8':[852,1336],'9':[852,1477],'*':[941,1209],'0':[941,1336],'#':[941,1477]};var KeypadManager={kMaxDigits:50,_phoneNumber:'',_onCall:false,_keypadSoundIsEnabled:false,_shortTone:false,_vibrationEnabled:false,kVibrationDuration:50,_insertPosition:null,onValueChanged:null,get phoneNumberView(){delete this.phoneNumberView;this.phoneNumberView=document.getElementById('phone-number-view');return this.phoneNumberView;},get phoneNumberViewContainer(){delete this.phoneNumberViewContainer;this.phoneNumberViewContainer=document.getElementById('phone-number-view-container');return this.phoneNumberViewContainer;},get keypad(){delete this.keypad;this.keypad=document.getElementById('keypad');return this.keypad;},get callBar(){delete this.callBar;this.callBar=document.getElementById('keypad-callbar');return this.callBar;},get hideBar(){delete this.hideBar;this.hideBar=document.getElementById('keypad-hidebar');return this.hideBar;},get callBarAddContact(){delete this.callBarAddContact;this.callBarAddContact=document.getElementById('keypad-callbar-add-contact');return this.callBarAddContact;},get callBarCallAction(){delete this.callBarCallAction;this.callBarCallAction=document.getElementById('keypad-callbar-call-action');return this.callBarCallAction;},get callBarCancelAction(){delete this.callBarCancelAction;this.callBarCancelAction=document.getElementById('keypad-callbar-cancel');return this.callBarCancelAction;},get deleteButton(){delete this.deleteButton;this.deleteButton=document.getElementById('keypad-delete');return this.deleteButton;},get hideBarHangUpAction(){delete this.hideBarHangUpAction;this.hideBarHangUpAction=document.getElementById('keypad-hidebar-hang-up-action-wrapper');return this.hideBarHangUpAction;},get hideBarHideAction(){delete this.hideBarHideAction;this.hideBarHideAction=document.getElementById('keypad-hidebar-hide-keypad-action');return this.hideBarHideAction;},multiSimActionButton:null,init:function kh_init(oncall){this._onCall=!!oncall;this.phoneNumberView.value='';this.phoneNumberView.addEventListener('click',this._updateInsertPosition.bind(this));this._phoneNumber='';var keyHandler=this.keyHandler.bind(this);this.keypad.addEventListener('contextmenu',keyHandler);this.keypad.addEventListener('touchstart',keyHandler,true);this.keypad.addEventListener('touchmove',keyHandler,true);this.keypad.addEventListener('touchend',keyHandler,true);this.keypad.addEventListener('touchcancel',keyHandler,true);this.deleteButton.addEventListener('touchstart',keyHandler);this.deleteButton.addEventListener('touchend',keyHandler);if(this.callBarAddContact){this.callBarAddContact.addEventListener('click',this.addContact.bind(this));}
if(this.callBarCallAction){if(typeof MultiSimActionButton!=='undefined'){if(navigator.mozMobileConnections&&navigator.mozMobileConnections.length>1){var self=this;LazyL10n.get(function localized(_){self.multiSimActionButton=new MultiSimActionButton(self.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',self.phoneNumber.bind(self));});}else{this.multiSimActionButton=new MultiSimActionButton(this.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',this.phoneNumber.bind(this));}}
this.callBarCallAction.addEventListener('click',this.fetchLastCalled.bind(this));}
if(this.callBarCancelAction){this.callBarCancelAction.addEventListener('click',function(){window.parent.LockScreen.switchPanel();});}
if(this.hideBarHideAction){this.hideBarHideAction.addEventListener('click',this.callbarBackAction);}
if(this.hideBarHangUpAction){this.hideBarHangUpAction.addEventListener('click',this.hangUpCallFromKeypad);}
TonePlayer.init(this._onCall?'telephony':'notification');this.render();LazyLoader.load(['/shared/style/action_menu.css','/dialer/js/suggestion_bar.js']);this._observePreferences();},render:function hk_render(layoutType){if(layoutType=='oncall'){if(CallsHandler.activeCall){var activeCall=CallsHandler.activeCall.call;this._phoneNumber=activeCall.id.number;}
this._isKeypadClicked=false;this.phoneNumberViewContainer.classList.add('keypad-visible');if(this.callBar){this.callBar.classList.add('hide');}
if(this.hideBar){this.hideBar.classList.remove('hide');}
this.deleteButton.classList.add('hide');}else{this.phoneNumberViewContainer.classList.remove('keypad-visible');if(this.callBar){this.callBar.classList.remove('hide');}
if(this.hideBar){this.hideBar.classList.add('hide');}
this.deleteButton.classList.remove('hide');}},phoneNumber:function hk_phoneNumber(){return this._phoneNumber;},fetchLastCalled:function hk_fetchLastCalled(){if(this._phoneNumber!==''){return;}
var self=this;CallLogDBManager.getGroupAtPosition(1,'lastEntryDate',true,'dialing',function hk_ggap_callback(result){if(result&&(typeof result==='object')&&result.number){self.updatePhoneNumber(result.number);}});},addContact:function hk_addContact(event){var number=this._phoneNumber;if(!number){return;}
LazyLoader.load(['/dialer/js/add_contact_menu.js'],function(){AddContactMenu.show(number);});},callbarBackAction:function hk_callbarBackAction(event){CallScreen.hideKeypad();},hangUpCallFromKeypad:function hk_hangUpCallFromKeypad(event){CallScreen.body.classList.remove('showKeypad');CallsHandler.end();},_lastPressedKey:null,_dtmfTone:null,_playDtmfTone:function kh_playDtmfTone(key){var serviceId=0;if(!this._onCall){return;}
if(CallsHandler.activeCall){serviceId=CallsHandler.activeCall.call.serviceId;}else{serviceId=navigator.mozTelephony.active.calls[0].serviceId;}
if(this._dtmfTone){this._dtmfTone.stop();this._dtmfTone=null;}
this._dtmfTone=new DtmfTone(key,this._shortTone,serviceId);this._dtmfTone.play();},_stopDtmfTone:function kh_stopDtmfTone(){if(!this._dtmfTone){return;}
this._dtmfTone.stop();this._dtmfTone=null;},_touchStart:function kh_touchStart(key){this._longPress=false;this._lastPressedKey=key;if(key!='delete'){if(this._keypadSoundIsEnabled){TonePlayer.start(gTonesFrequencies[key],!this._onCall||this._shortTone);}
if(this._vibrationEnabled){navigator.vibrate(this.kVibrationDuration);}
this._playDtmfTone(key);}
if(((key=='0'||key=='*')&&!this._onCall)||key=='delete'){this._holdTimer=setTimeout(function(self){self.restoreCaretPosition();if(key=='delete'){self._clearPhoneNumber();}else if(key==='0'){self._replaceLastKey('+');}else if(key==='*'){var isAtTheEnd=self._insertPosition===null;var isFirst=self._insertPosition===1||(isAtTheEnd&&self._phoneNumber.length===1);if(!isFirst){self._replaceLastKey(',');}else{self._deleteAtInsertPosition();}}
self._longPress=true;self._updatePhoneNumberView('begin',false);},400,this);}
if(key==='1'&&this._phoneNumber===''){this._holdTimer=setTimeout(function vm_call(self){self._longPress=true;self._callVoicemail();self._phoneNumber='';self._updatePhoneNumberView('begin',false);},400,this);}
if(key=='delete'){this._deleteAtInsertPosition();}else if(this.phoneNumberViewContainer.classList.contains('keypad-visible')){if(!this._isKeypadClicked){this._isKeypadClicked=true;this._phoneNumber=key;this.replaceAdditionalContactInfo('');}else{this._insertAtCaret(key);}}else{this._insertAtCaret(key);}
setTimeout(function(self){self._updatePhoneNumberView('begin',false);},0,this);},_touchMove:function kh_touchMove(touch){var target=document.elementFromPoint(touch.pageX,touch.pageY);var key=target.dataset?target.dataset.value:null;if(key!==this._lastPressedKey||key==='delete'){this._stopDtmfTone();this._lastPressedKey=null;}},_touchEnd:function kh_touchEnd(key){if(key!=='delete'&&key===this._lastPressedKey){this._stopDtmfTone();this._lastPressedKey=null;}
if(this._keypadSoundIsEnabled){TonePlayer.stop();}
this.restoreCaretPosition();if(this._longPress){this._longPress=false;this._holdTimer=null;return;}
if(this._holdTimer){clearTimeout(this._holdTimer);}},keyHandler:function kh_keyHandler(event){event.preventDefault();if(event.type=='contextmenu'){return;}
var key=event.target.dataset.value;if(!key){return;}
if(key==='#'){if(this._phoneNumber==='*#06#'){this.multiSimActionButton.performAction();event.target.classList.remove('active');return;}else if(this._isSpeedDialNumber(this._phoneNumber)){var self=this;var index=this._phoneNumber.slice(0,-1);this.updatePhoneNumber('','begin',false);this._getSpeedDialNumber(+index).then(function(number){self.updatePhoneNumber(number,'begin',false);},function(error){if(error){ConfirmDialog.show(error,null,{title:'noContactsFoundDialogOk',callback:ConfirmDialog.hide});}});event.target.classList.remove('active');return;}}
if(key!='delete'&&this._phoneNumber.length>=this.kMaxDigits&&!this._onCall){event.target.classList.remove('active');return;}
event.stopPropagation();switch(event.type){case'touchstart':event.target.classList.add('active');this._touchStart(key);break;case'touchmove':this._touchMove(event.touches[0]);break;case'touchend':case'touchcancel':event.target.classList.remove('active');this._touchEnd(key);break;}},_isSpeedDialNumber:function(number){return!!number.match(/^[0-9][0-9]{0,2}\#$/);},_getSpeedDialNumber:function(index){var self=this;var cardIndex;index--;return new Promise(function(resolve,reject){LazyLoader.load(['/shared/js/sim_settings_helper.js'],function(){SimSettingsHelper.getCardIndexFrom('outgoingCall',function(defaultCardIndex){if(defaultCardIndex==SimSettingsHelper.ALWAYS_ASK_OPTION_VALUE){LazyLoader.load(['/shared/js/component_utils.js','/shared/elements/gaia_sim_picker/script.js'],function(){var simPicker=document.getElementById('sim-picker');simPicker.getOrPick(defaultCardIndex,null,function(pickedCardIndex){cardIndex=pickedCardIndex;resolve();});});}else{cardIndex=defaultCardIndex;resolve();}});});}).then(function(){return self._getSimContactsList(cardIndex).then(function(simContactsList){if((index>=0)&&(index<simContactsList.length)){return simContactsList[index].number;}else{return Promise.reject('noContactsWereFound');}});});},_createSimContactList:function(contacts){var numbers=new Array(contacts.length);for(var i=0;i<contacts.length;i++){numbers[i]={id:contacts[i].id,number:contacts[i].tel[0].value,};}
numbers.sort(function(a,b){if(a.id.length==b.id.length){return(a.id>b.id)?1:0;}else{return(a.id.length>b.id.length)?1:0;}});return numbers;},_getSimContactsList:function(cardIndex){var self=this;var canceled=false;return new Promise(function(resolve,reject){LazyLoader.load(['/shared/style/confirm.css','/shared/js/confirm.js',document.getElementById('confirmation-message')],function(){var iccId=navigator.mozIccManager.iccIds[cardIndex];var icc=navigator.mozIccManager.getIccById(iccId);var req=icc.readContacts('adn');req.onsuccess=function(event){var adnContacts=event.target.result;var contacts=self._createSimContactList(adnContacts);if(!canceled){ConfirmDialog.hide();}
resolve(contacts);};req.onerror=function(error){console.error('Could not retrieve the ADN contacts from SIM card '+
cardIndex+', got error '+error.name);reject('noContactsWereFound');};ConfirmDialog.show('loadingSimContacts',null,{title:'cancel',callback:function(){canceled=true;ConfirmDialog.hide();reject();}});});});},sanitizePhoneNumber:function(number){return number.replace(/\s+/g,'');},updatePhoneNumber:function kh_updatePhoneNumber(number,ellipsisSide,forceMaxFontSize){number=this.sanitizePhoneNumber(number);this._phoneNumber=number;this._updatePhoneNumberView(ellipsisSide,forceMaxFontSize);},press:function(value){this._playDtmfTone(value);TonePlayer.start(gTonesFrequencies[value],true);setTimeout((function nextTick(){TonePlayer.stop();this._stopDtmfTone();}).bind(this));},_updatePhoneNumberView:function kh_updatePhoneNumberview(ellipsisSide,forceMaxFontSize){var phoneNumber=this._phoneNumber;if(this._onCall){this.replacePhoneNumber(phoneNumber,ellipsisSide,forceMaxFontSize);}else{var visibility;if(phoneNumber.length>0){visibility='visible';this.callBarAddContact.removeAttribute('disabled');}else{visibility='hidden';this.callBarAddContact.setAttribute('disabled','disabled');}
this.deleteButton.style.visibility=visibility;this.phoneNumberView.blur();this.phoneNumberView.value=phoneNumber;FontSizeManager.adaptToSpace(FontSizeManager.DIAL_PAD,this.phoneNumberView,forceMaxFontSize,ellipsisSide);}
if(this.onValueChanged){this.onValueChanged(this._phoneNumber);}},replacePhoneNumber:function kh_replacePhoneNumber(phoneNumber,ellipsisSide,forceMaxFontSize){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.replacePhoneNumber(phoneNumber,ellipsisSide,forceMaxFontSize);}},restorePhoneNumber:function kh_restorePhoneNumber(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restorePhoneNumber();}},replaceAdditionalContactInfo:function kh_replaceAdditionalContactInfo(additionalContactInfo){var call=CallsHandler.activeCall;if(this._onCall&&call){call.replaceAdditionalContactInfo(additionalContactInfo);}},restoreAdditionalContactInfo:function kh_restoreAdditionalContactInfo(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restoreAdditionalContactInfo();}},_callVoicemail:function(){if(navigator.mozIccManager.iccIds.length<=1){this._callVoicemailForSim(0);return;}
var self=this;var key='ril.voicemail.defaultServiceId';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function(){LazyLoader.load(['/shared/js/component_utils.js','/shared/elements/gaia_sim_picker/script.js'],function(){LazyL10n.get(function(_){var simPicker=document.getElementById('sim-picker');simPicker.getOrPick(req.result[key],_('voiceMail'),self._callVoicemailForSim.bind(self));});});};},_callVoicemailForSim:function(cardIndex){var settings=navigator.mozSettings;if(!settings){return;}
var transaction=settings.createLock();var request=transaction.get('ril.iccInfo.mbdn');request.onsuccess=(function(){var numbers=request.result['ril.iccInfo.mbdn'];var number;if(typeof numbers=='string'){number=numbers;}else{number=numbers&&numbers[cardIndex];}
var voicemail=navigator.mozVoicemail;if(!number&&voicemail){number=voicemail.getNumber(cardIndex);}
if(number){CallHandler.call(number,cardIndex);}else{this._showNoVoicemailDialog();}}).bind(this);request.onerror=function(){};},_showNoVoicemailDialog:function hk_showNoVoicemailDialog(){var voicemailDialog={title:'voicemailNoNumberTitle',text:'voicemailNoNumberText',confirm:{title:'voicemailNoNumberSettings',recommend:true,callback:this.showVoicemailSettings},cancel:{title:'voicemailNoNumberCancel',callback:this._hideNoVoicemailDialog}};LazyLoader.load(['/shared/js/custom_dialog.js'],function(){CustomDialog.show(voicemailDialog.title,voicemailDialog.text,voicemailDialog.cancel,voicemailDialog.confirm);});},_hideNoVoicemailDialog:function kh_hideNoVoicemailDialog(){CustomDialog.hide();},showVoicemailSettings:function kh_showVoicemailSettings(){var activity=new window.MozActivity({name:'configure',data:{target:'device',section:'call'}});activity.onerror=function(){console.warn('Configure activity error:',activity.error.name);};},_observePreferences:function kh_observePreferences(){var self=this;LazyLoader.load('/shared/js/settings_listener.js',function(){SettingsListener.observe('phone.ring.keypad',false,function(value){self._keypadSoundIsEnabled=!!value;});SettingsListener.observe('phone.dtmf.type',false,function(value){self._shortTone=(value==='short');});SettingsListener.observe('keyboard.vibration',false,function(value){self._vibrationEnabled=!!value;});});},_updateInsertPosition:function kh_updateInsertPosition(){this._insertPosition=this._realStartPosition();},_replaceLastKey:function kh_replaceLastKey(newKey){this._deleteAtInsertPosition();this.restoreCaretPosition();this._insertAtCaret(newKey);},_insertAtCaret:function kh_insertAtCaret(key){if(this._insertPosition===null){this._phoneNumber+=key;}else{var start=this._realStartPosition();var end=this._realEndPosition();this._phoneNumber=this._phoneNumber.substring(0,start)+key+
this._phoneNumber.substring(end);this._insertPosition=start+1;}},_deleteAtInsertPosition:function kh_deleteAtInsertPosition(){if(this._insertPosition===null){this._phoneNumber=this._phoneNumber.slice(0,-1);}else{var start=this._realStartPosition();var end=this._realEndPosition();if(start>0&&start===end){start=end-1;}
this._phoneNumber=this._phoneNumber.substring(0,start)+
this._phoneNumber.substring(end);this._insertPosition=this._phoneNumber?start:null;}},_clearPhoneNumber:function kh_clearPhoneNumber(){if(this._insertPosition===null){this._phoneNumber='';}else{var start=this._realStartPosition();this._phoneNumber=this._phoneNumber.substring(start);this._insertPosition=this._phoneNumber?0:null;}},restoreCaretPosition:function kh_restoreCaretPosition(){if(this._insertPosition!==null){var caretPosition=this._caretPosition(this._insertPosition);this.phoneNumberView.selectionStart=caretPosition;this.phoneNumberView.selectionEnd=caretPosition;this.phoneNumberView.focus();}else{this.phoneNumberView.blur();}},_realStartPosition:function kh_realStartPosition(){var start=this.phoneNumberView.selectionStart;return this._realPosition(this.phoneNumberView,start);},_realEndPosition:function kh_realEndPosition(){var end=this.phoneNumberView.selectionEnd;return this._realPosition(this.phoneNumberView,end);},_caretPosition:function kh_caretPosition(realPosition){return realPosition-this._ellipsisOffset(this.phoneNumberView);},_realPosition:function kh_realPosition(input,position){return position+this._ellipsisOffset(this.phoneNumberView);},_ellipsisOffset:function kh_ellipsisOffset(input){var ellipsedCharacters=+input.dataset.ellipsedCharacters;return ellipsedCharacters?(ellipsedCharacters-1):0;}};;'use strict';var Utils={prettyDate:function ut_prettyDate(time){var _=navigator.mozL10n.get;var timeFormat=window.navigator.mozHour12?_('shortTimeFormat12'):_('shortTimeFormat24');var dtf=new navigator.mozL10n.DateTimeFormat();return dtf.localeFormat(new Date(time),timeFormat);},prettyDuration:function(node,duration,l10nPrefix){var elapsed=new Date(duration);var h=elapsed.getUTCHours();var m=elapsed.getUTCMinutes();var s=elapsed.getUTCSeconds();var l10nId=l10nPrefix||'callDuration';var durationL10n={h:h+'',m:m+'',s:s+''};if(l10nId==='callDuration'){durationL10n={h:(h>9?'':'0')+h,m:(m>9?'':'0')+m,s:(s>9?'':'0')+s};}
if(l10nPrefix==='callDurationTextFormat'&&h===0&&m===0){l10nId+='Seconds';}else{l10nId+=h>0?'Hours':'Minutes';}
navigator.mozL10n.setAttributes(node,l10nId,durationL10n);},headerDate:function ut_headerDate(time){var _=navigator.mozL10n.get;var dtf=new navigator.mozL10n.DateTimeFormat();var diff=(Date.now()-time)/1000;var day_diff=Math.floor(diff/86400);var formattedTime;if(isNaN(day_diff)){formattedTime=_('incorrectDate');}else if(day_diff===0){formattedTime=_('today');}else if(day_diff===1){formattedTime=_('yesterday');}else if(day_diff<6){formattedTime=dtf.localeFormat(new Date(time),'%A');}else{formattedTime=dtf.localeFormat(new Date(time),'%x');}
return formattedTime;},getDayDate:function re_getDayDate(timestamp){var date=new Date(timestamp);var startDate=new Date(date.getFullYear(),date.getMonth(),date.getDate());return startDate.getTime();},getPhoneNumberPrimaryInfo:function ut_getPhoneNumberPrimaryInfo(matchingTel,contact){if(contact){if(contact.name&&contact.name.length&&contact.name[0]!==''){return contact.name;}else if(contact.org&&contact.org.length&&contact.org[0]!==''){return contact.org;}}
if(matchingTel){return matchingTel.value;}
return null;},toCamelCase:function ut_toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});},_getPhoneNumberType:function ut_getPhoneNumberType(matchingTel){var type=matchingTel.type;if(Array.isArray(type)){type=type[0];}
var _=navigator.mozL10n.get;var result=type?_(type):_('mobile');result=result?result:type;return result;},getPhoneNumberAdditionalInfo:function ut_getPhoneNumberAdditionalInfo(matchingTel){var result=this._getPhoneNumberType(matchingTel);var carrier=matchingTel.carrier;if(carrier){result+=', '+carrier;}
return result;},getPhoneNumberAndType:function ut_getPhoneNumberAndType(matchingTel){return this._getPhoneNumberType(matchingTel)+', '+matchingTel.value;}};;'use strict';var FontSizeManager=(function fontSizeManager(){var DIAL_PAD=0,SINGLE_CALL=1,CALL_WAITING=2,STATUS_BAR=3,SECOND_INCOMING_CALL=4;var _sizes={};_sizes[DIAL_PAD]={min:2.6,max:4.1};_sizes[SINGLE_CALL]={min:2.3,max:3.4,line:3.4};_sizes[CALL_WAITING]={min:2.3,max:2.5,line:1.3};_sizes[STATUS_BAR]={min:1.7,max:1.7};_sizes[SECOND_INCOMING_CALL]={min:2.3,max:2.5,line:3.7};var _defaultFontSize;function _getRootFontSize(){_defaultFontSize=_defaultFontSize||parseInt(window.getComputedStyle(document.body,null).getPropertyValue('font-size'));return _defaultFontSize;}
function _getMinFontSize(scenario){return Math.round(_sizes[scenario].min*_getRootFontSize());}
function _getMaxFontSize(scenario){return Math.round(_sizes[scenario].max*_getRootFontSize());}
function _getAllowedFontSizes(scenario){var minFontSize=_getMinFontSize(scenario);var maxFontSize=_getMaxFontSize(scenario);var allowedSizes=[];for(var size=minFontSize;size<=maxFontSize;size+=4){allowedSizes.push(size);}
if(allowedSizes.indexOf(maxFontSize)===-1){allowedSizes.push(maxFontSize);}
return allowedSizes;}
function adaptToSpace(scenario,view,forceMaxFontSize,ellipsisSide){var computedStyle=window.getComputedStyle(view);if((!view.value&&!view.textContent)||!computedStyle){return;}
var viewWidth=view.getBoundingClientRect().width;var viewFont=computedStyle.fontFamily;var allowedSizes;if(forceMaxFontSize){allowedSizes=[_getMaxFontSize(scenario)];}else{allowedSizes=_getAllowedFontSizes(scenario);}
var infos=FontSizeUtils.getMaxFontSizeInfo(view.value||view.textContent,allowedSizes,viewFont,viewWidth);var newFontSize=infos.fontSize;if(view.style.fontSize!==newFontSize){view.style.fontSize=newFontSize+'px';}
if(infos&&infos.overflow){var overflowCount=FontSizeUtils.getOverflowCount(view.value||view.textContent,newFontSize,viewFont,viewWidth);overflowCount+=2;_useEllipsis(view,overflowCount,ellipsisSide);view.dataset.ellipsedCharacters=overflowCount;}else{view.dataset.ellipsedCharacters=0;}}
function _useEllipsis(view,overflowCount,ellipsisSide){var side=ellipsisSide||'begin';var localizedSide=(side==='begin'?'left':'right');var value=view.value||view.textContent;if(localizedSide=='left'){value='\u2026'+value.substr(-value.length+overflowCount);}else if(localizedSide=='right'){value=value.substr(0,value.length-overflowCount)+'\u2026';}
if(view.value){view.value=value;}else{view.textContent=value;}}
function ensureFixedBaseline(scenario,view){var initialLineHeight=_sizes[scenario].line;if(!initialLineHeight){return;}
var maxFontSize=_getMaxFontSize(scenario);var fontSize=parseInt(window.getComputedStyle(view).fontSize,10);view.style.lineHeight=initialLineHeight*_getRootFontSize()+
(maxFontSize-fontSize)/2+'px';}
function resetFixedBaseline(view){view.style.removeProperty('line-height');}
return{DIAL_PAD:DIAL_PAD,SINGLE_CALL:SINGLE_CALL,CALL_WAITING:CALL_WAITING,STATUS_BAR:STATUS_BAR,SECOND_INCOMING_CALL:SECOND_INCOMING_CALL,adaptToSpace:adaptToSpace,ensureFixedBaseline:ensureFixedBaseline,resetFixedBaseline:resetFixedBaseline};})();;'use strict';(function(exports){var Voicemail={check:function vm_check(number,cardIndex){return new Promise(function(resolve,reject){if(!number){resolve(false);return;}
var serviceId=cardIndex;var voicemail=navigator.mozVoicemail;if(voicemail){var voicemailNumber=voicemail.getNumber(serviceId);if(voicemailNumber===number){resolve(true);return;}}
var settings=navigator.mozSettings;var req=settings.createLock().get('ril.iccInfo.mbdn');req.onsuccess=function getVoicemailNumber(){var isVoicemailNumber=false;var voicemailNumbers=req.result['ril.iccInfo.mbdn'];var voicemailNumber;if(typeof voicemailNumbers==='string'){voicemailNumber=voicemailNumbers;}else{voicemailNumber=voicemailNumbers&&voicemailNumbers[serviceId];}
if(voicemailNumber===number){isVoicemailNumber=true;}
resolve(isVoicemailNumber);};req.onerror=function getVoicemailNumberError(){resolve(false);};});}};exports.Voicemail=Voicemail;}(window));;'use strict';var BluetoothHelper=function(){var profiles={'HFP':0x111E,'A2DP':0x110D};var _bluetooth=window.navigator.mozBluetooth;var _isReady=false;var _callbacks=[];var _adapter=null;var _v2=true;var _ready=function(callback){if(!callback||!_bluetooth){return;}
if(_isReady){callback();}else{_callbacks.push(callback);}};var _handleRequest=function(request,callback,errorcb){request.onsuccess=function(){if(callback){callback(request.result);}};request.onerror=function(){console.log('Error handling bluetooth request');if(errorcb){errorcb();}};};var _processCallbacks=function(){if(_adapter){_isReady=true;_callbacks.forEach(function(callback){callback();});_callbacks=[];}else{console.log('BluetoothHelper(): connot get default adapter yet');}};var _fetchAdapterV2=function(){_bluetooth.onattributechanged=function onManagerAttributeChanged(evt){for(var i in evt.attrs){switch(evt.attrs[i]){case'defaultAdapter':console.log('defaultAdapter changed. address:',_bluetooth.defaultAdapter.address);_adapter=_bluetooth.defaultAdapter;_processCallbacks();break;default:break;}}};_adapter=_bluetooth.defaultAdapter;if(_adapter){_processCallbacks();}};var _fetchAdapter=function(){var req=_bluetooth.getDefaultAdapter();if(req){req.onsuccess=function(){var _oldAdapter;if(_adapter){_oldAdapter=_adapter;}
_isReady=true;_adapter=req.result;if(_oldAdapter&&_oldAdapter.onpairedstatuschanged){_adapter.onpairedstatuschanged=_oldAdapter.onpairedstatuschanged;}
_callbacks.forEach(function(callback){callback();});_callbacks=[];};req.onerror=function(){console.log('BluetoothHelper(): connot get default adapter!!!');};}};var _getAdapter=function(){if(_v2){_fetchAdapterV2();}else{_fetchAdapter();}};if(_bluetooth){if(typeof(_bluetooth.onattributechanged)==='undefined'){_v2=false;}
if(_v2){_bluetooth.onadapteradded=function onAdapterAdded(evt){_getAdapter();};}else{_bluetooth.addEventListener('enabled',_getAdapter);_bluetooth.addEventListener('adapteradded',_getAdapter);}
_getAdapter();}
return{profiles:profiles,answerWaitingCall:function(){_ready(function(){_adapter.answerWaitingCall();});},ignoreWaitingCall:function(){_ready(function(){_adapter.ignoreWaitingCall();});},toggleCalls:function(){_ready(function(){_adapter.toggleCalls();});},getConnectedDevicesByProfile:function(profileID,cb){if(_v2){console.log('getConnectedDevicesByProfile API is deprecated');return;}
_ready(function(){_handleRequest(_adapter.getConnectedDevices(profileID),cb);});},connectSco:function(cb){_ready(function(){_handleRequest(_adapter.connectSco(),cb);});},disconnectSco:function(cb){_ready(function(){_handleRequest(_adapter.disconnectSco(),cb);});},getPairedDevices:function(cb){_ready(function(){_handleRequest(_adapter.getPairedDevices(),cb);});},getAddress:function(cb){if(_v2){console.log('getAddress function is deprecated');return;}
_ready(function(){var address=_adapter.address;cb(address);});},setPairingConfirmation:function(address,confirmed){if(_v2){console.log('setPairingConfirmation API is deprecated');return;}
_ready(function(){_adapter.setPairingConfirmation(address,confirmed);});},setPinCode:function(address,pincode){if(_v2){console.log('setPairingConfirmation API is deprecated');return;}
_ready(function(){_adapter.setPinCode(address,pincode);});},setPasskey:function(address,key){if(_v2){console.log('setPairingConfirmation API is deprecated');return;}
_ready(function(){_adapter.setPasskey(address,key);});},set onhfpstatuschanged(callback){_ready(function(){_adapter.onhfpstatuschanged=callback;});},set onscostatuschanged(callback){_ready(function(){_adapter.onscostatuschanged=callback;});},set onpairedstatuschanged(callback){if(_v2){console.log('onpairedstatuschanged API is deprecated');return;}
_ready(function(){_adapter.onpairedstatuschanged=callback;});},v2:_v2,enable:function(){if(_v2){_ready(function(){_adapter.enable();});}else{console.log('enable is not support in v1 API!');}},disable:function(){if(_v2){_ready(function(){_adapter.disable();});}else{console.log('disable is not support in v1 API!');}}};};;(function(exports){'use strict';var _appName=null;var _ac=null;var _silenceBufferSource=null;var _onmozinterruptbegin=null;var _onmozinterruptend=null;var _listeners={mozinterruptbegin:[],mozinterruptend:[]};var _addListenersBeforeCompeting=true;function _fireEvent(type){if(!_listeners[type]){return;}
for(var i=0;i<_listeners[type].length;i++){if(_listeners[type][i]&&(typeof _listeners[type][i]==='function')){_listeners[type][i].call(null);}}}
var AudioCompetingHelper={init:function ach_init(appName){_appName=appName;},compete:function ach_compete(){_ac=new AudioContext('telephony');_silenceBufferSource=_ac.createBufferSource();_silenceBufferSource.buffer=_ac.createBuffer(1,2048,_ac.sampleRate);_silenceBufferSource.connect(_ac.destination);_silenceBufferSource.loop=true;if(_addListenersBeforeCompeting){_onmozinterruptbegin=_fireEvent.bind(null,'mozinterruptbegin');_ac.addEventListener('mozinterruptbegin',_onmozinterruptbegin);_onmozinterruptend=_fireEvent.bind(null,'mozinterruptend');_ac.addEventListener('mozinterruptend',_onmozinterruptend);_addListenersBeforeCompeting=false;}
_silenceBufferSource.start(0);},leaveCompetition:function ach_leaveCompetition(){if(!_silenceBufferSource){return;}
_silenceBufferSource.stop(0);_ac.removeEventListener('mozinterruptbegin',_onmozinterruptbegin);_ac.removeEventListener('mozinterruptend',_onmozinterruptend);_addListenersBeforeCompeting=true;_silenceBufferSource.buffer=null;_silenceBufferSource=null;_ac=null;},addListener:function ach_addEventListener(type,listener){if((type!=='mozinterruptbegin')&&(type!=='mozinterruptend')){return;}
if(listener&&(typeof listener!=='function')){return;}
_listeners[type].push(listener);},clearListeners:function ach_clearListeners(type){if(type){_listeners[type]=[];return;}
_listeners.mozinterruptbegin=[];_listeners.mozinterruptend=[];},get audioContext(){return _ac;}};exports.AudioCompetingHelper=AudioCompetingHelper;})(this);;'use strict';var CallScreen={_ticker:null,_screenWakeLock:null,_typedNumber:'',callEndPromptTime:2000,body:document.body,screen:document.getElementById('call-screen'),lockscreenConnStates:document.getElementById('lockscreen-conn-states'),views:document.getElementById('views'),calls:document.getElementById('calls'),mainContainer:document.getElementById('main-container'),contactBackground:document.getElementById('contact-background'),callToolbar:document.getElementById('co-advanced'),muteButton:document.getElementById('mute'),speakerButton:document.getElementById('speaker'),bluetoothButton:document.getElementById('bt'),keypadButton:document.getElementById('keypad-visibility'),placeNewCallButton:document.getElementById('place-new-call'),holdButton:document.getElementById('on-hold'),mergeButton:document.getElementById('merge'),holdAndMergeContainer:document.getElementById('hold-and-merge-container'),hideBarMuteButton:document.getElementById('keypad-hidebar-mute-action'),bluetoothMenu:document.getElementById('bluetooth-menu'),switchToDeviceButton:document.getElementById('btmenu-btdevice'),switchToReceiverButton:document.getElementById('btmenu-receiver'),switchToSpeakerButton:document.getElementById('btmenu-speaker'),bluetoothMenuCancel:document.getElementById('btmenu-cancel'),answerButton:document.getElementById('callbar-answer'),rejectButton:document.getElementById('callbar-hang-up'),incomingContainer:document.getElementById('incoming-container'),incomingInfo:document.getElementById('incoming-info'),incomingNumber:document.getElementById('incoming-number'),incomingSim:document.getElementById('incoming-sim'),incomingNumberAdditionalInfo:document.getElementById('incoming-number-additional-info'),incomingAnswer:document.getElementById('incoming-answer'),incomingEnd:document.getElementById('incoming-end'),incomingIgnore:document.getElementById('incoming-ignore'),lockedClockTime:document.getElementById('lockscreen-clock-time'),lockedDate:document.getElementById('lockscreen-date'),statusMessage:document.getElementById('statusMsg'),configs:{lockMode:'incoming-call'},showStatusMessage:function cs_showStatusMesssage(text){var STATUS_TIME=2000;var self=this;self.statusMessage.querySelector('p').textContent=text;self.statusMessage.classList.add('visible');self.statusMessage.addEventListener('transitionend',function tend(evt){evt.stopPropagation();self.statusMessage.removeEventListener('transitionend',tend);setTimeout(function hide(){self.statusMessage.classList.remove('visible');},STATUS_TIME);});},updateCallsDisplay:function cs_updateCallsDisplay(){var visibleCalls=this.calls.querySelectorAll('section:not([hidden])').length;this.body.classList.toggle('single-line',visibleCalls<=1);this.calls.classList.toggle('big-duration',visibleCalls<=1);CallsHandler.updateAllPhoneNumberDisplays();},hidePlaceNewCallButton:function cs_hidePlaceNewCallButton(){this.callToolbar.classList.add('no-add-call');},showPlaceNewCallButton:function cs_showPlaceNewCallButton(){this.callToolbar.classList.remove('no-add-call');},set holdAndAnswerOnly(enabled){this.incomingContainer.classList.toggle('hold-and-answer-only',enabled);},set cdmaCallWaiting(enabled){this.calls.classList.toggle('switch',enabled);this.callToolbar.classList.toggle('no-add-call',enabled);},get inStatusBarMode(){return window.innerHeight<=40;},init:function cs_init(){this.muteButton.addEventListener('click',this.toggleMute.bind(this));this.hideBarMuteButton.addEventListener('click',this.toggleMute.bind(this));this.keypadButton.addEventListener('click',this.showKeypad.bind(this));this.placeNewCallButton.addEventListener('click',this.placeNewCall.bind(this));this.speakerButton.addEventListener('click',this.toggleSpeaker.bind(this));this.bluetoothButton.addEventListener('click',this.toggleBluetoothMenu.bind(this));this.holdButton.addEventListener('click',CallsHandler.holdOrResumeCallByUser);this.mergeButton.addEventListener('click',CallsHandler.mergeCalls.bind(this));this.answerButton.addEventListener('click',CallsHandler.answer);this.rejectButton.addEventListener('click',CallsHandler.end);this.switchToDeviceButton.addEventListener('click',this.switchToDefaultOut.bind(this,false));this.switchToReceiverButton.addEventListener('click',this.switchToReceiver.bind(this));this.switchToSpeakerButton.addEventListener('click',this.switchToSpeaker.bind(this));this.bluetoothMenuCancel.addEventListener('click',this.toggleBluetoothMenu.bind(this));this.incomingAnswer.addEventListener('click',CallsHandler.holdAndAnswer);this.incomingEnd.addEventListener('click',CallsHandler.endAndAnswer);this.incomingIgnore.addEventListener('click',CallsHandler.ignore);this.calls.addEventListener('click',CallsHandler.toggleCalls.bind(this));window.addEventListener('resize',this.resizeHandler.bind(this));window.addEventListener('hashchange',this.hashchangeHandler.bind(this));this.hashchangeHandler();SettingsListener.observe('wallpaper.image',null,this._wallpaperImageHandler.bind(this));this.syncSpeakerEnabled();},_connInfoManagerInitialized:false,initLockScreenConnInfoManager:function cs_initLockScreenConnInfoManager(){if(this._connInfoManagerInitialized){return;}
if(window.navigator.mozMobileConnections){LazyL10n.get(function localized(_){new window.LockScreenConnInfoManager(CallScreen.lockscreenConnStates);CallScreen._connInfoManagerInitialized=true;});}},_slideInitialized:false,initLockScreenSlide:function cs_initLockScreenSlide(){if(this._slideInitialized){return;}
this._slideInitialized=true;this.hangUpIcon=document.getElementById('lockscreen-area-hangup');this.pickUpIcon=document.getElementById('lockscreen-area-pickup');this.initUnlockerEvents();new LockScreenSlide({useNewStyle:true,IDs:{overlay:'main-container',areas:{left:'lockscreen-area-hangup',right:'lockscreen-area-pickup'},},trackNew:{strokeColorTop:'rgba(0, 0, 0, 0)',strokeColorBottom:'rgba(0, 0, 0, 0)',fillColorTop:'rgba(0, 0, 0, 0.1)',fillColorBottom:'rgba(0, 0, 0, 0.1)'},colors:{left:{touchedColor:'224, 0, 0',touchedColorStop:'255, 255, 255'},right:{touchedColor:'0, 173, 173',touchedColorStop:'255, 255, 255'}},iconBG:{left:{color:'rgba(224, 0, 0, 0.80)'},right:{color:'rgba(0, 173, 173, 0.80)'}},resourcesNew:{larrow:'/style/images/lock_screen/lockscreen_toggle_arrow_left.png',rarrow:'/style/images/lock_screen/lockscreen_toggle_arrow_right.png'}});},_wallpaperImageHandler:function cs_wallpaperImageHandler(image){this.mainContainer.style.backgroundImage='url('+
(typeof image==='string'?image:URL.createObjectURL(image))+')';},setCallerContactImage:function cs_setCallerContactImage(){var activeCallForContactImage=CallsHandler.activeCallForContactImage;var blob=activeCallForContactImage&&activeCallForContactImage.photo;var background=blob?'url('+URL.createObjectURL(blob)+')':'';this.contactBackground.style.backgroundImage=background;},insertCall:function cs_insertCall(node){this.calls.appendChild(node);this.updateCallsDisplay();},removeCall:function cs_removeCall(node){if(node.parentNode){node.parentNode.removeChild(node);this.updateCallsDisplay();}},resizeHandler:function cs_resizeHandler(){if(!this.body.classList.contains('showKeypad')){this.updateCallsDisplay(this.inStatusBarMode);}else if(this.inStatusBarMode){this._typedNumber=KeypadManager._phoneNumber;KeypadManager.restorePhoneNumber();}else{KeypadManager.updatePhoneNumber(this._typedNumber,'begin',true);}},hashchangeHandler:function cs_hashchangeHandler(){if(window.location.hash.startsWith('#locked')){this.initLockScreenConnInfoManager();this.showClock(new Date());this.initLockScreenSlide();if(!this.screen.dataset.layout){this.render('incoming-locked');}}},toggleMute:function cs_toggleMute(){this.muteButton.classList.toggle('active-state');this.hideBarMuteButton.classList.toggle('active-state');this.calls.classList.toggle('muted');CallsHandler.toggleMute();},unmute:function cs_unmute(){this.muteButton.classList.remove('active-state');this.hideBarMuteButton.classList.remove('active-state');this.calls.classList.remove('muted');CallsHandler.unmute();},toggleSpeaker:function cs_toggleSpeaker(){this.speakerButton.classList.toggle('active-state');CallsHandler.toggleSpeaker();},toggleBluetoothMenu:function cs_toggleBluetoothMenu(value){if(typeof value!='boolean'){this.bluetoothMenu.classList.toggle('display');}else{this.bluetoothMenu.classList.toggle('display',value);}},switchToSpeaker:function cs_switchToReceiver(){this.speakerButton.classList.add('active-state');this.bluetoothButton.classList.add('active-state');CallsHandler.switchToSpeaker();this.toggleBluetoothMenu(false);},switchToReceiver:function cs_switchToReceiver(){this.speakerButton.classList.remove('active-state');this.bluetoothButton.classList.remove('active-state');CallsHandler.switchToReceiver();this.toggleBluetoothMenu(false);},setShowIsHeld:function cs_setShowIsHeld(enabled){this.holdButton.classList.toggle('active-state',enabled);},switchToDefaultOut:function cs_switchToDefaultOut(doNotConnect){this.speakerButton.classList.remove('active-state');this.bluetoothButton.classList.add('active-state');CallsHandler.switchToDefaultOut(doNotConnect);this.toggleBluetoothMenu(false);},setBTReceiverIcon:function cs_setBTReceiverIcon(enabled){if(enabled){this.speakerButton.classList.add('hide');this.bluetoothButton.classList.remove('hide');}else{this.speakerButton.classList.remove('hide');this.bluetoothButton.classList.add('hide');}},showKeypad:function cs_showKeypad(){KeypadManager.render('oncall');this.body.classList.add('showKeypad');},hideKeypad:function cs_hideKeypad(){KeypadManager.restorePhoneNumber();KeypadManager.restoreAdditionalContactInfo();this.body.classList.remove('showKeypad');},placeNewCall:function cs_placeNewCall(){new MozActivity({name:'dial',data:{type:'webtelephony/number',number:''}});},render:function cs_render(layout_type){this.screen.dataset.layout=layout_type;},showClock:function cs_showClock(now){LazyL10n.get(function localized(_){var f=new navigator.mozL10n.DateTimeFormat();var timeFormat=window.navigator.mozHour12?_('shortTimeFormat12'):_('shortTimeFormat24');timeFormat=timeFormat.replace('%p','<span>%p</span>');var dateFormat=_('longDateFormat');this.lockedClockTime.innerHTML=f.localeFormat(now,timeFormat);this.lockedDate.textContent=f.localeFormat(now,dateFormat);}.bind(this));},showIncoming:function cs_showIncoming(){this.body.classList.remove('showKeypad');this.callToolbar.classList.add('transparent');this.incomingContainer.classList.add('displayed');this._screenWakeLock=navigator.requestWakeLock('screen');},hideIncoming:function cs_hideIncoming(){this.callToolbar.classList.remove('transparent');this.incomingContainer.classList.remove('displayed');if(this._screenWakeLock){this._screenWakeLock.unlock();this._screenWakeLock=null;}
this.setCallerContactImage();},syncSpeakerEnabled:function cs_syncSpeakerEnabled(){if(navigator.mozTelephony.speakerEnabled){this.speakerButton.classList.add('active-state');}else{this.speakerButton.classList.remove('active-state');}},enableMuteButton:function cs_enableMuteButton(){this.muteButton.removeAttribute('disabled');},disableMuteButton:function cs_disableMuteButton(){this.muteButton.setAttribute('disabled','disabled');},enablePlaceNewCallButton:function cs_enablePlaceNewCallButton(){this.placeNewCallButton.removeAttribute('disabled');},disablePlaceNewCallButton:function cs_disablePlaceNewCallButton(){this.placeNewCallButton.setAttribute('disabled','disabled');},enableSpeakerButton:function cs_enableSpeakerButton(){this.speakerButton.removeAttribute('disabled');},disableSpeakerButton:function cs_disableSpeakerButton(){this.speakerButton.setAttribute('disabled','disabled');},showOnHoldButton:function cs_showOnHoldButton(){this.holdButton.classList.remove('hide');},hideOnHoldButton:function cs_hideOnHoldButton(){this.holdButton.classList.add('hide');},enableOnHoldButton:function cs_enableOnHoldButton(){this.holdButton.removeAttribute('disabled');},disableOnHoldButton:function cs_disableOnHoldButton(){this.holdButton.setAttribute('disabled','disabled');},showMergeButton:function cs_showMergeButton(){this.mergeButton.classList.remove('hide');},hideMergeButton:function cs_hideMergeButton(){this.mergeButton.classList.add('hide');},hideOnHoldAndMergeContainer:function cs_hideOnHoldAndMergeContainer(){this.holdAndMergeContainer.style.display='none';},createTicker:function(durationNode){var durationChildNode=durationNode.querySelector('span');if(durationNode.dataset.tickerId){return false;}
durationChildNode.textContent='00:00';durationNode.classList.add('isTimer');LazyL10n.get(function localized(_){var ticker=setInterval(function ut_updateTimer(startTime){var delta=Math.round((performance.now()-startTime)/1000)*1000;Utils.prettyDuration(durationChildNode,delta);},1000,performance.now());durationNode.dataset.tickerId=ticker;});return true;},stopTicker:function(durationNode){durationNode.classList.remove('isTimer');clearInterval(durationNode.dataset.tickerId);delete durationNode.dataset.tickerId;},handleEvent:function cs_handleEvent(evt){var state=null,statePrev=null;switch(evt.type){case'lockscreenslide-unlocker-initializer':break;case'lockscreenslide-near-left':state=evt.detail.state;statePrev=evt.detail.statePrev;if(state==='accelerating'){CallScreen.hangUpIcon.classList.add('triggered');}else{CallScreen.hangUpIcon.classList.remove('triggered');}
break;case'lockscreenslide-near-right':state=evt.detail.state;statePrev=evt.detail.statePrev;if(state==='accelerating'){CallScreen.pickUpIcon.classList.add('triggered');}else{CallScreen.pickUpIcon.classList.remove('triggered');}
break;case'lockscreenslide-unlocking-start':break;case'lockscreenslide-unlocking-stop':break;case'lockscreenslide-activate-left':CallsHandler.end();break;case'lockscreenslide-activate-right':CallsHandler.answer();break;case'lockscreen-mode-on':this.modeSwitch(evt.detail,true);break;case'lockscreen-mode-off':this.modeSwitch(evt.detail,false);break;}},modeSwitch:function cs_modeSwitch(mode,switcher){if(switcher){if(mode!==this.configs.lockMode){this.suspendUnlockerEvents();}}else{if(mode!==this.configs.lockMode){this.initUnlockerEvents();}}},cdmaConferenceCall:function cs_cdmaConferenceCall(){this.hidePlaceNewCallButton();this.calls.classList.add('cdma-conference-call');},initUnlockerEvents:function cs_initUnlockerEvents(){window.addEventListener('lockscreenslide-unlocker-initializer',this);window.addEventListener('lockscreenslide-near-left',this);window.addEventListener('lockscreenslide-near-right',this);window.addEventListener('lockscreenslide-unlocking-start',this);window.addEventListener('lockscreenslide-activate-left',this);window.addEventListener('lockscreenslide-activate-right',this);window.addEventListener('lockscreenslide-unlocking-stop',this);},suspendUnlockerEvents:function cs_initUnlockerEvents(){window.removeEventListener('lockscreenslide-unlocker-initializer',this);window.removeEventListener('lockscreenslide-near-left',this);window.removeEventListener('lockscreenslide-near-right',this);window.removeEventListener('lockscreenslide-unlocking-start',this);window.removeEventListener('lockscreenslide-activate-left',this);window.removeEventListener('lockscreenslide-activate-right',this);window.removeEventListener('lockscreenslide-unlocking-stop',this);},getScenario:function cs_getScenario(){var scenario;if(this.inStatusBarMode){scenario=FontSizeManager.STATUS_BAR;}else if(this.body.classList.contains('single-line')){scenario=FontSizeManager.SINGLE_CALL;}else{scenario=FontSizeManager.CALL_WAITING;}
return scenario;}};;'use strict';var CallsHandler=(function callsHandler(){var CALLS_LIMIT=2;var CDMA_CALLS_LIMIT=2;var handledCalls=[];var exitCallScreenTimeout=null;var toneInterval=null;var callHeldByUser=null;var telephony=window.navigator.mozTelephony;telephony.oncallschanged=onCallsChanged;var conn=window.navigator.mozMobileConnections&&window.navigator.mozMobileConnections[0];if(conn&&conn.voice&&conn.voice.network&&conn.voice.network.mcc){SimplePhoneMatcher.mcc=conn.voice.network.mcc;}
var btHelper=new BluetoothHelper();var screenLock;function setup(){if(telephony){telephony.muted=false;}
btHelper.getConnectedDevicesByProfile(btHelper.profiles.HFP,function(result){CallScreen.setBTReceiverIcon(!!(result&&result.length));});btHelper.onhfpstatuschanged=function(evt){CallScreen.setBTReceiverIcon(evt.status);};var acm=navigator.mozAudioChannelManager;if(acm){acm.addEventListener('headphoneschange',function onheadphoneschange(){if(acm.headphones){CallScreen.switchToDefaultOut();}});}
btHelper.onscostatuschanged=function onscostatuschanged(evt){if(evt.status){CallScreen.switchToDefaultOut();}};navigator.mozSetMessageHandler('headset-button',handleHSCommand);navigator.mozSetMessageHandler('bluetooth-dialer-command',handleBTCommand);AudioCompetingHelper.clearListeners();AudioCompetingHelper.addListener('mozinterruptbegin',onMozInterrupBegin);}
var highPriorityWakeLock=null;function onCallsChanged(){if(!highPriorityWakeLock&&telephony.calls.length>0){highPriorityWakeLock=navigator.requestWakeLock('high-priority');}
if(highPriorityWakeLock&&telephony.calls.length===0){highPriorityWakeLock.unlock();highPriorityWakeLock=null;}
if(telephony.active){telephony.active.addEventListener('error',handleBusyErrorAndPlayTone);}
telephony.calls.forEach(function callIterator(call){var alreadyAdded=handledCalls.some(function hcIterator(hc){return(hc.call==call);});if(!alreadyAdded){addCall(call);}});function hcIterator(call){return(call==hc.call);}
for(var index=(handledCalls.length-1);index>=0;index--){var hc=handledCalls[index];var stillHere=telephony.calls.some(hcIterator)||telephony.conferenceGroup.calls.some(hcIterator);if(!stillHere){removeCall(index);}}
if(cdmaCallWaiting()){handleCallWaiting(telephony.calls[0]);}else{if(isCdma3WayCall()){CallScreen.hidePlaceNewCallButton();}else if(handledCalls.length!==0){CallScreen.showPlaceNewCallButton();}}
if(isFirstCallOnCdmaNetwork()){CallScreen.hideOnHoldAndMergeContainer();}
CallScreen.setCallerContactImage();exitCallScreenIfNoCalls(CallScreen.callEndPromptTime);}
function addCall(call){if(handledCalls.length&&(call.state!='incoming')&&(call.state!='dialing')){return;}
if(telephony.calls.length>CALLS_LIMIT){HandledCall(call);call.hangUp();return;}
if(handledCalls.length===0){CallScreen.unmute();CallScreen.switchToDefaultOut(true);}
var hc=new HandledCall(call);handledCalls.push(hc);CallScreen.insertCall(hc.node);if(call.state==='incoming'){turnScreenOn(call);}
if(handledCalls.length>1){if(call.state==='incoming'){hc.hide();handleCallWaiting(call);}else{updatePlaceNewCall();updateMergeAndOnHoldStatus();hc.show();}}else{if(window.location.hash.startsWith('#locked')&&(call.state=='incoming')){CallScreen.render('incoming-locked');}else{CallScreen.render(call.state);}}}
function removeCall(index){handledCalls.splice(index,1);if(handledCalls.length===0){return;}
CallScreen.hideIncoming();var remainingCall=handledCalls[0];if(remainingCall.call.state=='incoming'){remainingCall.show();setTimeout(function nextTick(){if(remainingCall.call.state=='incoming'){CallScreen.render('incoming');}});return;}
var remainingCallOrGroup=remainingCall.call.group||remainingCall.call;if(callHeldByUser!==remainingCallOrGroup){remainingCallOrGroup.resume();}else{CallScreen.render('connected-hold');}}
function turnScreenOn(call){screenLock=navigator.requestWakeLock('screen');call.addEventListener('statechange',function callStateChange(){call.removeEventListener('statechange',callStateChange);if(screenLock){screenLock.unlock();screenLock=null;}});}
function handleBusyErrorAndPlayTone(evt){if(evt.call.error.name==='BusyError'){var sequence=[[480,620,500],[0,0,500],[480,620,500],[0,0,500],[480,620,500],[0,0,500]];var sequenceDuration=sequence.reduce(function(prev,curr){return prev+curr[2];},0);TonePlayer.playSequence(sequence);exitCallScreenIfNoCalls(sequenceDuration);}}
function handleCallWaiting(call){LazyL10n.get(function localized(_){var number=call.secondId?call.secondId.number:call.id.number;if(!number){CallScreen.incomingNumber.textContent=_('withheld-number');FontSizeManager.adaptToSpace(FontSizeManager.SECOND_INCOMING_CALL,CallScreen.incomingNumber,false,'end');return;}
if(navigator.mozIccManager.iccIds.length>1){CallScreen.incomingSim.textContent=_('sim-number',{n:call.serviceId+1});}else{CallScreen.incomingSim.hidden=true;}
Contacts.findByNumber(number,function lookupContact(contact,matchingTel){if(contact&&contact.name){CallScreen.incomingInfo.classList.add('additionalInfo');CallScreen.incomingNumber.textContent=contact.name;CallScreen.incomingNumberAdditionalInfo.textContent=Utils.getPhoneNumberAndType(matchingTel);}else{CallScreen.incomingNumber.textContent=number;CallScreen.incomingNumberAdditionalInfo.textContent='';}
FontSizeManager.adaptToSpace(FontSizeManager.SECOND_INCOMING_CALL,CallScreen.incomingNumber,false,'end');if(contact&&contact.name){FontSizeManager.ensureFixedBaseline(FontSizeManager.SECOND_INCOMING_CALL,CallScreen.incomingNumber);}});});if(cdmaCallWaiting()){CallScreen.holdAndAnswerOnly=true;}
CallScreen.showIncoming();playWaitingTone(call);}
function exitCallScreenIfNoCalls(timeout){if(handledCalls.length===0){document.body.classList.toggle('no-handled-calls',true);if(exitCallScreenTimeout!==null){clearTimeout(exitCallScreenTimeout);exitCallScreenTimeout=null;}
exitCallScreenTimeout=setTimeout(function(evt){exitCallScreenTimeout=null;if(handledCalls.length===0){window.close();}else{document.body.classList.toggle('no-handled-calls',false);}},timeout);}}
function updateAllPhoneNumberDisplays(){handledCalls.forEach(function(call){if(!call._leftGroup){call.restorePhoneNumber();}});}
window.addEventListener('resize',updateAllPhoneNumberDisplays);function handleBTCommand(message){var command=message.command;switch(command){case'CHUP':end();break;case'ATA':answer();break;case'CHLD=0':hangupWaitingCalls();break;case'CHLD=1':if((handledCalls.length===1)&&!cdmaCallWaiting()){end();}else{endAndAnswer();}
break;case'CHLD=2':if((handledCalls.length===1)&&!cdmaCallWaiting()){holdOrResumeCallByUser();}else{holdAndAnswer();}
break;case'CHLD=3':if(!telephony.conferenceGroup.state&&telephony.calls.length==2){telephony.conferenceGroup.add(telephony.calls[0],telephony.calls[1]);break;}
if(telephony.conferenceGroup.state&&telephony.calls.length==1){telephony.conferenceGroup.add(telephony.calls[0]);break;}
console.warn('Cannot join conference call.');break;default:var partialCommand=command.substring(0,3);if(partialCommand==='VTS'){KeypadManager.press(command.substring(4));}
break;}}
var lastHeadsetPress=0;function handleHSCommand(message){switch(message){case'headset-button-press':lastHeadsetPress=Date.now();return;case'headset-button-release':if((Date.now()-lastHeadsetPress)>1000){return;}
break;default:return;}
if(telephony.active){end();}else if((handledCalls.length>1)||cdmaCallWaiting()){holdAndAnswer();}else{answer();}}
function answer(){if(!handledCalls.length){return;}
handledCalls[0].call.answer();CallScreen.render('connected');}
function holdAndAnswer(){if((handledCalls.length<2)&&!cdmaCallWaiting()){return;}
if(telephony.active){telephony.active.hold();if(cdmaCallWaiting()){btHelper.answerWaitingCall();}}else if(handledCalls.length>=2){var lastCall=handledCalls[handledCalls.length-1].call;lastCall.answer();}else{handledCalls[0].call.hold();}
CallScreen.hideIncoming();if(cdmaCallWaiting()){handledCalls[0].updateCallNumber();CallScreen.cdmaCallWaiting=true;stopWaitingTone();}}
function endAndAnswer(){if((handledCalls.length<2)&&!cdmaCallWaiting()){return;}
if(telephony.active==telephony.conferenceGroup){endConferenceCall().then(function(){CallScreen.hideIncoming();},function(){});return;}
if(cdmaCallWaiting()){handledCalls[0].call.hold();stopWaitingTone();btHelper.answerWaitingCall();}else{var callToEnd=telephony.active||handledCalls[handledCalls.length-2].call;var callToAnswer;handledCalls.some(function(handledCall){if(handledCall.call!==callToEnd){callToAnswer=handledCall.call;return true;}});if(callToEnd&&callToAnswer){callToEnd.addEventListener('disconnected',function ondisconnected(){callToEnd.removeEventListener('disconnected',ondisconnected);callToAnswer.answer();});callToEnd.hangUp();}else if(callToEnd){callToEnd.hangUp();}else if(callToAnswer){callToAnswer.answer();}}
CallScreen.hideIncoming();if(cdmaCallWaiting()){handledCalls[0].updateCallNumber();CallScreen.cdmaCallWaiting=true;}}
function toggleCalls(){if(CallScreen.incomingContainer.classList.contains('displayed')&&!cdmaCallWaiting()){return;}
var openLines=telephony.calls.length+
(telephony.conferenceGroup.calls.length?1:0);if(openLines<2&&!cdmaCallWaiting()){if(!telephony.active){holdOrResumeSingleCall();}
return;}
telephony.active.hold();btHelper.toggleCalls();callHeldByUser=null;}
function holdOrResumeCallByUser(){if(telephony.active){callHeldByUser=telephony.active;}
holdOrResumeSingleCall();}
function holdOrResumeSingleCall(){var openLines=telephony.calls.length+
(telephony.conferenceGroup.calls.length?1:0);if(openLines!==1||isFirstCallOnCdmaNetwork()){return;}
if(telephony.calls.length&&telephony.calls[0].state==='incoming'){return;}
if(telephony.active){telephony.active.hold();CallScreen.render('connected-hold');CallScreen.disableMuteButton();CallScreen.disableSpeakerButton();}else{var line=telephony.calls.length?telephony.calls[0]:telephony.conferenceGroup;line.resume();callHeldByUser=null;CallScreen.render('connected');CallScreen.enableMuteButton();CallScreen.enableSpeakerButton();}}
function hangupWaitingCalls(){handledCalls.forEach(function(handledCall){var callState=handledCall.call.state;if(callState==='held'||(callState==='incoming'&&handledCalls.length>1)){handledCall.call.hangUp();}});}
function ignore(){if(cdmaCallWaiting()){stopWaitingTone();btHelper.ignoreWaitingCall();}else{var ignoreIndex=handledCalls.length-1;handledCalls[ignoreIndex].call.hangUp();}
CallScreen.hideIncoming();}
function endConferenceCall(){return telephony.conferenceGroup.hangUp().then(function(){ConferenceGroupHandler.signalConferenceEnded();},function(){console.error('Failed to hangup Conference Call');});}
function end(){if(telephony.active==telephony.conferenceGroup){endConferenceCall();return;}
if(telephony.active){telephony.active.hangUp();return;}
if(!handledCalls.length){return;}
var lastCallIndex=handledCalls.length-1;handledCalls[lastCallIndex].call.hangUp();}
function unmute(){telephony.muted=false;}
function switchToSpeaker(){btHelper.disconnectSco();if(!telephony.speakerEnabled){telephony.speakerEnabled=true;}}
function switchToDefaultOut(doNotConnect){if(telephony.speakerEnabled){telephony.speakerEnabled=false;}
if(!doNotConnect&&telephony.active&&!document.hidden){btHelper.connectSco();}}
function switchToReceiver(){btHelper.disconnectSco();if(telephony.speakerEnabled){telephony.speakerEnabled=false;}}
function toggleMute(){telephony.muted=!telephony.muted;}
function toggleSpeaker(){if(telephony.speakerEnabled){CallsHandler.switchToDefaultOut();}else{CallsHandler.switchToSpeaker();}}
function playWaitingTone(call){var sequence=[[440,440,100],[0,0,100],[440,440,100]];toneInterval=window.setInterval(function playTone(){TonePlayer.playSequence(sequence);},10000);TonePlayer.playSequence(sequence);call.addEventListener('statechange',function callStateChange(){call.removeEventListener('statechange',callStateChange);window.clearInterval(toneInterval);});}
function stopWaitingTone(){window.clearInterval(toneInterval);}
function activeCall(){var telephonyActiveCall=telephony.active;var active=null;for(var i=0;i<handledCalls.length;i++){var handledCall=handledCalls[i];if(telephonyActiveCall===handledCall.call){active=handledCall;break;}}
return active;}
function activeCallForContactImage(){if(handledCalls.length===1){return handledCalls[0];}
return[activeCall()].concat(handledCalls).find(function(elem){return!elem||!elem.call.group;});}
function cdmaCallWaiting(){return((telephony.calls.length==1)&&(telephony.calls[0].state=='connected')&&(telephony.calls[0].secondId));}
function isFirstCallOnCdmaNetwork(){var cdmaTypes=['evdo0','evdoa','evdob','1xrtt','is95a','is95b'];if(handledCalls.length!==0){var ci=handledCalls[0].call.serviceId;var type=window.navigator.mozMobileConnections[ci].voice.type;return(cdmaTypes.indexOf(type)!==-1);}else{return false;}}
function isCdma3WayCall(){return isFirstCallOnCdmaNetwork()&&((telephony.calls.length===CDMA_CALLS_LIMIT)||(telephony.conferenceGroup.calls.length>0));}
function mergeCalls(){if(!telephony.conferenceGroup.calls.length){telephony.conferenceGroup.add(telephony.calls[0],telephony.calls[1]);}else{telephony.conferenceGroup.add(telephony.calls[0]);}
callHeldByUser=null;}
function forceAnAudioCompetitionWin(){AudioCompetingHelper.leaveCompetition();AudioCompetingHelper.compete();}
function onMozInterrupBegin(){var openLines=telephony.calls.length+(telephony.conferenceGroup.calls.length?1:0);if(openLines!==1){forceAnAudioCompetitionWin();return;}
holdOrResumeSingleCall();}
function isEstablishingCall(){return telephony.calls.some(function(call){return call.state=='dialing'||call.state=='alerting';});}
function updatePlaceNewCall(){if(isEstablishingCall()){CallScreen.disablePlaceNewCallButton();}else{CallScreen.enablePlaceNewCallButton();}}
function updateMergeAndOnHoldStatus(){if(isFirstCallOnCdmaNetwork()){return;}
var isEstablishing=isEstablishingCall();var openLines=telephony.calls.length+
(telephony.conferenceGroup.calls.length?1:0);if(openLines>1&&!isEstablishing){CallScreen.hideOnHoldButton();CallScreen.showMergeButton();}else{CallScreen.setShowIsHeld(!telephony.active&&isAnyCallOnHold());if(isEstablishing){CallScreen.disableOnHoldButton();}else{CallScreen.enableOnHoldButton();}
CallScreen.hideMergeButton();CallScreen.showOnHoldButton();}}
function isAnyCallOnHold(){return telephony.calls.some((call)=>call.state==='held')||telephony.conferenceGroup.state==='held';}
return{setup:setup,answer:answer,holdAndAnswer:holdAndAnswer,endAndAnswer:endAndAnswer,toggleCalls:toggleCalls,ignore:ignore,end:end,toggleMute:toggleMute,toggleSpeaker:toggleSpeaker,unmute:unmute,switchToReceiver:switchToReceiver,switchToSpeaker:switchToSpeaker,switchToDefaultOut:switchToDefaultOut,holdOrResumeCallByUser:holdOrResumeCallByUser,checkCalls:onCallsChanged,mergeCalls:mergeCalls,updateAllPhoneNumberDisplays:updateAllPhoneNumberDisplays,updatePlaceNewCall:updatePlaceNewCall,exitCallScreenIfNoCalls:exitCallScreenIfNoCalls,updateMergeAndOnHoldStatus:updateMergeAndOnHoldStatus,get activeCall(){return activeCall();},get activeCallForContactImage(){return activeCallForContactImage();},isFirstCallOnCdmaNetwork:isFirstCallOnCdmaNetwork};})();;'use strict';var ConferenceGroupHandler=(function(){var bdiCount=document.createElement('bdi');var groupLine=document.getElementById('group-call');var groupLabel=document.getElementById('group-call-label');groupLabel.appendChild(bdiCount);var groupDuration=document.querySelector('#group-call > .duration');var groupDurationChildNode=groupDuration.querySelector('span');var groupTotalDurationChildNode=groupDuration.querySelector('.total-duration');var telephony=window.navigator.mozTelephony;if(telephony.conferenceGroup){telephony.conferenceGroup.oncallschanged=onCallsChanged;telephony.conferenceGroup.onstatechange=onStateChange;telephony.conferenceGroup.onerror=onConferenceError;}
function onCallsChanged(){var calls=telephony.conferenceGroup.calls;CallScreen.updateCallsDisplay();if(!calls.length){ConferenceGroupUI.hideGroupDetails();}
LazyL10n.get(function localized(_){var groupDetailsHeaderText=_('conferenceCall',{n:calls.length});bdiCount.textContent=groupDetailsHeaderText;ConferenceGroupUI.setGroupDetailsHeader(bdiCount.textContent);});if(telephony.conferenceGroup.calls.length>=2){CallsHandler.checkCalls();}
if(CallsHandler.isFirstCallOnCdmaNetwork()){CallScreen.cdmaConferenceCall();}}
function show(){groupLine.hidden=false;groupLine.classList.remove('ended');groupLine.classList.remove('held');CallScreen.createTicker(groupDuration);CallScreen.setCallerContactImage();}
function end(){groupTotalDurationChildNode.textContent=groupDurationChildNode.textContent;LazyL10n.get(function localized(_){groupDurationChildNode.textContent=_('callEnded');});groupLine.classList.add('ended');groupLine.classList.remove('held');FontSizeManager.adaptToSpace(CallScreen.getScenario(),groupLabel,false,'end');CallScreen.stopTicker(groupDuration);setTimeout(function(evt){groupLine.hidden=true;CallScreen.updateCallsDisplay();},CallScreen.callEndPromptTime);}
function onStateChange(){switch(telephony.conferenceGroup.state){case'resuming':case'connected':show();break;case'held':groupLine.classList.add('held');break;case'':end();CallsHandler.checkCalls();break;}}
function onConferenceError(evt){LazyL10n.get(function localized(_){var errorMsg;if(evt.name=='addError'){errorMsg=_('conferenceAddError');}else{errorMsg=_('conferenceRemoveError');}
CallScreen.showStatusMessage(errorMsg);});}
function signalConferenceEnded(){ConferenceGroupUI.markCallsAsEnded();}
function addToGroupDetails(node){ConferenceGroupUI.addCall(node);}
function removeFromGroupDetails(node){ConferenceGroupUI.removeCall(node);}
function isGroupDetailsShown(){return ConferenceGroupUI.isGroupDetailsShown();}
return{addToGroupDetails:addToGroupDetails,removeFromGroupDetails:removeFromGroupDetails,signalConferenceEnded:signalConferenceEnded,isGroupDetailsShown:isGroupDetailsShown,get currentDuration(){return groupDurationChildNode.textContent;}};})();;'use strict';var ConferenceGroupUI=(function(){var groupCalls=document.getElementById('group-call-details'),groupCallsList,groupCallsHeader,initialized=false,bdiGroupCallsCountElt;document.getElementById('group-show').addEventListener('click',showGroupDetails);function _init(callback){if(initialized){callback();}
LazyLoader.load([groupCalls],function(){groupCallsHeader=groupCalls.querySelector('header');groupCallsList=document.getElementById('group-call-details-list');document.getElementById('group-hide').addEventListener('click',_hideGroupDetails);if(!initialized){bdiGroupCallsCountElt=document.createElement('bdi');groupCallsHeader.appendChild(bdiGroupCallsCountElt);}
initialized=true;callback();});}
function _hideGroupDetails(evt){if(evt){evt.preventDefault();}
if(!navigator.mozTelephony.conferenceGroup.calls.length){_removeAllCalls();}
groupCalls.classList.remove('display');}
function _removeAllCalls(){var callNodes=groupCalls.querySelectorAll('.handled-call');for(var i=0;i<callNodes.length;i++){removeCall(callNodes[i]);}}
function addCall(node){_init(function(){groupCallsList.appendChild(node);});}
function removeCall(node){if(node.parentNode){node.parentNode.removeChild(node);}}
function showGroupDetails(evt){if(evt){evt.stopPropagation();}
groupCalls.classList.add('display');}
function hideGroupDetails(){setTimeout(_hideGroupDetails,ConferenceGroupUI.isGroupDetailsShown()?CallScreen.callEndPromptTime:0);}
function isGroupDetailsShown(){return groupCalls.classList.contains('display');}
function markCallsAsEnded(){_init(function(){var callElems=groupCallsList.getElementsByTagName('SECTION');for(var i=0;i<callElems.length;i++){callElems[i].dataset.groupHangup='groupHangup';}});}
function setGroupDetailsHeader(text){_init(function(){bdiGroupCallsCountElt.textContent=text;});}
return{addCall:addCall,removeCall:removeCall,showGroupDetails:showGroupDetails,hideGroupDetails:hideGroupDetails,isGroupDetailsShown:isGroupDetailsShown,markCallsAsEnded:markCallsAsEnded,setGroupDetailsHeader:setGroupDetailsHeader};})();;'use strict';function HandledCall(aCall){this.photo=null;this._leftGroup=false;this.call=aCall;aCall.addEventListener('statechange',this);aCall.ongroupchange=(function onGroupChange(){if(this.call.group){ConferenceGroupHandler.addToGroupDetails(this.node);this._leftGroup=false;}else if(this._wasUnmerged()){if(ConferenceGroupHandler.isGroupDetailsShown()){this.node.parentNode.insertBefore(this.node.cloneNode(true),this.node);}
CallScreen.insertCall(this.node);this._leftGroup=false;}else{this._leftGroup=!this.node.dataset.groupHangup;}}).bind(this);this._initialState=this.call.state;this._cachedInfo='';this._cachedAdditionalInfo='';this._removed=false;this._wasConnected=false;this.node=document.getElementById('handled-call-template').cloneNode(true);this.node.id='';this.node.classList.add('handled-call');this.node.hidden=false;this.durationNode=this.node.querySelector('.duration');this.durationChildNode=this.node.querySelector('.duration span');this.totalDurationNode=this.node.querySelector('.total-duration');this.viaSimNode=this.node.querySelector('.sim .via-sim');this.simNumberNode=this.node.querySelector('.sim .sim-number');this.numberNode=this.node.querySelector('.numberWrapper .number');this.groupCallNumberNode=document.getElementById('group-call-label');this.additionalInfoNode=this.node.querySelector('.additionalContactInfo');this.hangupButton=this.node.querySelector('.hangup-button');this.hangupButton.onclick=(function(){this.call.hangUp();}.bind(this));this.updateCallNumber();LazyL10n.get((function localized(_){var durationMessage=(this.call.state=='incoming')?_('incoming'):_('connecting');this.durationChildNode.textContent=durationMessage;this.updateDirection();if(navigator.mozIccManager.iccIds.length>1){this.node.classList.add('sim-info');var n=this.call.serviceId+1;this.viaSimNode.textContent=_('via-sim',{n:n});this.simNumberNode.textContent=_('sim-number',{n:n});}else{this.viaSimNode.hidden=true;this.simNumberNode.hidden=true;}}).bind(this));if(this._initialState==='connected'){this.connected();}}
HandledCall.prototype._wasUnmerged=function hc_wasUnmerged(){return!this.node.dataset.groupHangup&&this.call.state!='disconnecting'&&this.call.state!='disconnected';};HandledCall.prototype.handleEvent=function hc_handle(evt){CallsHandler.updatePlaceNewCall();CallsHandler.updateMergeAndOnHoldStatus();switch(evt.call.state){case'connected':window.setTimeout(function onTimeout(){AudioCompetingHelper.compete();},1000);CallScreen.render('connected');this.connected();break;case'disconnected':AudioCompetingHelper.leaveCompetition();this.disconnected();break;case'held':AudioCompetingHelper.leaveCompetition();this.node.classList.add('held');break;}};HandledCall.prototype.updateCallNumber=function hc_updateCallNumber(){var number=this.call.id.number;var node=this.numberNode;var self=this;CallScreen.setCallerContactImage();if(this.call.secondId){LazyL10n.get(function localized(_){node.textContent=_('switch-calls');self._cachedInfo=_('switch-calls');self._cachedAdditionalInfo='';self.replaceAdditionalContactInfo('');self.numberNode.style.fontSize='';});return;}
if(!number){LazyL10n.get(function localized(_){node.textContent=_('withheld-number');self._cachedInfo=_('withheld-number');});return;}
var isEmergencyNumber=this.call.emergency;if(isEmergencyNumber){this.node.classList.add('emergency');LazyL10n.get(function localized(_){self.replacePhoneNumber(number,'end');self._cachedInfo=number;self.replaceAdditionalContactInfo(_('emergencyNumber'));self._cachedAdditionalInfo=_('emergencyNumber');});return;}
Voicemail.check(number,this.call.serviceId).then(function(isVoicemailNumber){if(isVoicemailNumber){LazyL10n.get(function localized(_){node.textContent=_('voiceMail');self._cachedInfo=_('voiceMail');});}else{Contacts.findByNumber(number,lookupContact);checkICCMessage();}});function checkICCMessage(){var callMessageReq=navigator.mozSettings.createLock().get('icc.callmessage');callMessageReq.onsuccess=function onCallMessageSuccess(){self._iccCallMessage=callMessageReq.result['icc.callmessage'];if(self._iccCallMessage){self.replacePhoneNumber(self._iccCallMessage,'end');self._cachedInfo=self._iccCallMessage;navigator.mozSettings.createLock().set({'icc.callmessage':null});}};}
function lookupContact(contact,matchingTel,contactsWithSameNumber){if(self._iccCallMessage){return;}
if(contact){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);var contactCopy={id:contact.id,name:contact.name,org:contact.org,tel:contact.tel};if(primaryInfo){node.textContent=primaryInfo;self._cachedInfo=primaryInfo;}else{LazyL10n.get(function gotL10n(_){self._cachedInfo=_('withheld-number');node.textContent=self._cachedInfo;});}
self._cachedAdditionalInfo=Utils.getPhoneNumberAndType(matchingTel);self.replaceAdditionalContactInfo(self._cachedAdditionalInfo);self.formatPhoneNumber('end');var photo=ContactPhotoHelper.getFullResolution(contact);if(photo){self.photo=photo;CallScreen.setCallerContactImage();var thumbnail=ContactPhotoHelper.getThumbnail(contact);contactCopy.photo=[thumbnail];}
return;}
self._cachedInfo=number;node.textContent=self._cachedInfo;self.replaceAdditionalContactInfo(self._cachedAdditionalInfo);self.formatPhoneNumber('end');}};HandledCall.prototype.replaceAdditionalContactInfo=function hc_replaceAdditionalContactInfo(additionalContactInfo){if(!additionalContactInfo||additionalContactInfo.trim()===''){this.additionalInfoNode.textContent='';this.node.classList.remove('additionalInfo');}else{this.additionalInfoNode.textContent=additionalContactInfo;this.node.classList.add('additionalInfo');}};HandledCall.prototype.restoreAdditionalContactInfo=function hc_restoreAdditionalContactInfo(){this.replaceAdditionalContactInfo(this._cachedAdditionalInfo);};HandledCall.prototype.formatPhoneNumber=function hc_formatPhoneNumber(ellipsisSide){if(this._removed){return;}
if(this.call.group){this.numberNode.style='';return;}
var scenario=CallScreen.getScenario();if(scenario===FontSizeManager.CALL_WAITING&&this.call.state==='incoming'&&CallScreen.incomingContainer.classList.contains('displayed')){scenario=FontSizeManager.SECOND_INCOMING_CALL;}
FontSizeManager.adaptToSpace(scenario,this.numberNode,false,ellipsisSide);if(this.node.classList.contains('additionalInfo')){FontSizeManager.ensureFixedBaseline(scenario,this.numberNode);}else{FontSizeManager.resetFixedBaseline(this.numberNode);}};HandledCall.prototype.replacePhoneNumber=function hc_replacePhoneNumber(phoneNumber,ellipsisSide){this.numberNode.textContent=phoneNumber;this.formatPhoneNumber(ellipsisSide);};HandledCall.prototype.restorePhoneNumber=function hc_restorePhoneNumber(){this.numberNode.textContent=this._cachedInfo;this.formatPhoneNumber('end');};HandledCall.prototype.updateDirection=function hc_updateDirection(){var self=this;var classList=this.node.classList;if(this._initialState=='incoming'){classList.add('incoming');LazyL10n.get(function localized(_){self.node.setAttribute('aria-label',_('incoming'));});}else{classList.add('outgoing');LazyL10n.get(function localized(_){self.node.setAttribute('aria-label',_('outgoing'));});}
if(this.call.state=='connected'){classList.add('ongoing');}};HandledCall.prototype.remove=function hc_remove(){this._removed=true;this.call.removeEventListener('statechange',this);this.photo=null;var self=this;CallScreen.stopTicker(this.durationNode);var currentDuration=ConferenceGroupHandler.isGroupDetailsShown()?ConferenceGroupHandler.currentDuration:this.durationChildNode.textContent;var totalDuration=!!currentDuration.match(/\d+/g)?currentDuration:'';this.totalDurationNode.textContent=totalDuration;this.node.classList.add('ended');LazyL10n.get(function localized(_){self.durationNode.classList.remove('isTimer');self.durationChildNode.textContent=_('callEnded');});setTimeout(function(evt){CallScreen.removeCall(self.node);self.node=null;},CallScreen.callEndPromptTime);};HandledCall.prototype.connected=function hc_connected(){this.show();this.node.classList.remove('held');this.updateDirection();CallScreen.createTicker(this.durationNode);CallScreen.syncSpeakerEnabled();this.updateCallNumber();this._wasConnected=true;};HandledCall.prototype.disconnected=function hc_disconnected(){var self=this;if(this._leftGroup){LazyL10n.get(function localized(_){CallScreen.showStatusMessage(_('caller-left-call',{caller:self._cachedInfo.toString()}));});self._leftGroup=false;}
if(this._wasConnected){TonePlayer.playSequence([[480,620,250]]);}
this._wasConnected=false;this.remove();};HandledCall.prototype.show=function hc_show(){if(this.node){this.node.hidden=false;}
CallScreen.updateCallsDisplay();};HandledCall.prototype.hide=function hc_hide(){if(this.node){this.node.hidden=true;}
CallScreen.updateCallsDisplay();};;'use strict';var SettingsListener={_timer:null,_lock:null,_observers:[],getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));var settingChanged=function settingChanged(evt){callback(evt.settingValue);};settings.addObserver(name,settingChanged);this._observers.push({name:name,callback:callback,observer:settingChanged});},unobserve:function sl_unobserve(name,callback){var settings=window.navigator.mozSettings;var that=this;this._observers.forEach(function(value,index){if(value.name===name&&value.callback===callback){settings.removeObserver(name,value.observer);that._observers.splice(index,1);}});}};;'use strict';var MobileInfo={brazil:{carriers:{'00':'NEXTEL','02':'TIM','03':'TIM','04':'TIM','05':'CLARO','06':'VIVO','07':'CTBC','08':'TIM','10':'VIVO','11':'VIVO','15':'SERCOMTEL','16':'OI','23':'VIVO','24':'OI','31':'OI','32':'CTBC','33':'CTBC','34':'CTBC','37':'AEIOU'},regions:{'11':'SP','12':'SP','13':'SP','14':'SP','15':'SP','16':'SP','17':'SP','18':'SP','19':'SP','21':'RJ','22':'RJ','24':'RJ','27':'ES','28':'ES','31':'MG','32':'MG','33':'MG','34':'MG','35':'MG','37':'MG','38':'MG','41':'PR','42':'PR','43':'PR','44':'PR','45':'PR','46':'PR','47':'SC','48':'SC','49':'SC','51':'RS','53':'RS','54':'RS','55':'RS','61':'DF','62':'GO','63':'TO','64':'GO','65':'MT','66':'MT','67':'MS','68':'AC','69':'RO','71':'BA','73':'BA','74':'BA','75':'BA','77':'BA','79':'SE','81':'PE','82':'AL','83':'PB','84':'RN','85':'CE','86':'PI','87':'PE','88':'CE','89':'PI','91':'PA','92':'AM','93':'PA','94':'PA','95':'RR','96':'AP','97':'AM','98':'MA','99':'MA'}}};var MobileOperator={BRAZIL_MCC:'724',BRAZIL_CELLBROADCAST_CHANNEL:50,userFacingInfo:function mo_userFacingInfo(mobileConnection){var network=mobileConnection.voice.network;var iccid=mobileConnection.iccId;var iccObj=navigator.mozIccManager.getIccById(iccid);var iccInfo=iccObj?iccObj.iccInfo:null;var operator=network?(network.shortName||network.longName):null;if(operator&&iccInfo&&iccInfo.isDisplaySpnRequired&&iccInfo.spn){if(iccInfo.isDisplayNetworkNameRequired&&operator!==iccInfo.spn){operator=operator+' '+iccInfo.spn;}else{operator=iccInfo.spn;}}
var carrier,region;if(this.isBrazil(mobileConnection)){var lac=mobileConnection.voice.cell.gsmLocationAreaCode%100;var carriers=MobileInfo.brazil.carriers;var regions=MobileInfo.brazil.regions;carrier=carriers[network.mnc]||(this.BRAZIL_MCC+network.mnc);region=(regions[lac]?regions[lac]+' '+lac:'');}
return{'operator':operator,'carrier':carrier,'region':region};},isBrazil:function mo_isBrazil(mobileConnection){var cell=mobileConnection.voice.cell;var net=mobileConnection.voice.network;return net?(net.mcc===this.BRAZIL_MCC&&cell&&cell.gsmLocationAreaCode):null;}};;'use strict';(function(exports){var LockScreenSlide=function(opts){this.initialize(opts);};var LockScreenSlidePrototype={canvas:null,layout:'',useNewStyle:false,track:{length:{tiny:'280',large:'410'},color:'rgba(255, 255, 255, 0.4)',backgroundColor:'rgba(0, 0, 0, 0)',from:0,to:0,radius:0,width:0},trackNew:{length:{tiny:'276',large:'406'},strokeColorTop:'rgba(0, 0, 0, 0.2)',strokeColorBottom:'rgba(0, 0, 0, 0)',fillColorTop:'rgba(0, 0, 0, 0.2)',fillColorBottom:'rgba(0, 0, 0, 0)',backColor:'rgba(51, 51, 51, 0.15)',from:0,to:0,radius:0,width:0},arrows:{left:null,right:null,ldraw:{x:null,y:null},rdraw:{x:null,y:null}},iconBG:{radius:20,left:{color:'rgba(255, 255, 255, 0.25)'},right:{color:'rgba(255, 255, 255, 0.25)'}},slides:{left:null,right:null},areas:{left:null,right:null},area:null,overlay:null,width:0,height:80,center:{x:null,y:null},handle:{autoExpand:{accState:'normal',accFactor:1.02,sentinelOffset:40,sentinelWidth:0},bounceBackTime:200,radius:28,lineWidth:1.6,maxWidth:0,touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239',color:'255, 255, 255',backgroundColor:'255, 255, 255',backgroundAlpha:0},handleNew:{autoExpand:{accState:'normal',accFactor:1.02,sentinelOffset:40,sentinelWidth:0},bounceBackTime:200,radius:30,innerRadius:15,outerColor:'rgba(255, 255, 255, 0.9)',innerColor:'rgba(0, 0, 0, 0.05)',lineWidth:1.6,maxWidth:0,towardLeft:false,touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239'},colors:{left:{touchedColor:'255, 255, 255',touchedColorStop:'255, 255, 255'},right:{touchedColor:'255, 255, 255',touchedColorStop:'255, 255, 255'}},states:{initialized:false,sliding:false,slideReachEnd:false,slidingColorful:false,slidingColorGradientEnd:false,touch:{id:'',touched:false,initX:-1,pageX:-1,pageY:-1,tx:-1,prevX:-1,deltaX:0}},IDs:{overlay:'lockscreen',area:'lockscreen-area',canvas:'lockscreen-canvas',areas:{left:'lockscreen-area-camera',right:'lockscreen-area-unlock'}},resources:{larrow:'/lockscreen/style/images/larrow.png',rarrow:'/lockscreen/style/images/rarrow.png'},resourcesNew:{larrow:'/lockscreen/style/images/lockscreen_toggle_arrow_left.png',rarrow:'/lockscreen/style/images/lockscreen_toggle_arrow_right.png'}};LockScreenSlidePrototype.initialize=function(opts){if(opts){this._overwriteSettings(opts);}
if(opts.useNewStyle){this.track=this.trackNew;this.handle=this.handleNew;this.resources=this.resourcesNew;}
this._initializeCanvas();this.publish('lockscreenslide-unlocker-initializer');this.states.initialized=true;};LockScreenSlidePrototype.reset=function lss_reset(){this._clearCanvas();this._drawTrack();this._resetHandle();this._resetArrows();this._drawIconBG();};LockScreenSlidePrototype._overwriteSettings=function(options){var iterate=function _iterate(opts,settings){for(var property in opts){if(opts.hasOwnProperty(property)){if('object'===typeof opts[property]){iterate(opts[property],settings[property]);}
else{settings[property]=opts[property];}}}};iterate(options,this);};LockScreenSlidePrototype.handleEvent=function(evt){switch(evt.type){case'screenchange':if(evt.detail.screenOffBy=='proximity'){break;}
this._clearCanvas();this._drawTrack();this._resetHandle();this._resetArrows();this._drawIconBG();break;case'touchstart':evt.preventDefault();if(evt.target!==this.area||evt.touches.length>1){return;}
this.states.touch.id=evt.touches[0].identifier;this._onSlideBegin(this._dpx(evt.touches[0].pageX));window.addEventListener('touchend',this);window.addEventListener('touchmove',this);break;case'touchmove':if(evt.touches.length>1){this._endGesture();return;}
this._onTouchMove(this._dpx(evt.touches[0].pageX),this._dpx(evt.touches[0].pageY));if(this.states.sliding){this._onSliding(this._dpx(evt.touches[0].pageX));}
break;case'touchend':if(evt.changedTouches[0].identifier!==this.states.touch.id){return;}
this._endGesture();break;}};LockScreenSlidePrototype._initializeCanvas=function lss_initializeCanvas(){this.overlay=document.getElementById(this.IDs.overlay);this.area=document.getElementById(this.IDs.area);this.canvas=document.getElementById(this.IDs.canvas);this.areas.left=document.getElementById(this.IDs.areas.left);this.areas.right=document.getElementById(this.IDs.areas.right);this.area.addEventListener('touchstart',this);this.layout=(ScreenLayout&&ScreenLayout.getCurrentLayout&&ScreenLayout.getCurrentLayout())?ScreenLayout.getCurrentLayout():'tiny';var center=this.center;this.arrows.left=new Image();this.arrows.right=new Image();var larrow=this.arrows.left;var rarrow=this.arrows.right;larrow.src=this.resources.larrow;rarrow.src=this.resources.rarrow;larrow.onload=(function(){var offset=this.useNewStyle?(this.arrows.left.width+this.handle.radius):(this.arrows.left.width<<1);this.arrows.ldraw.x=center.x-offset;this.arrows.ldraw.y=center.y-(this.arrows.left.height>>1);var ctx=this.canvas.getContext('2d');ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);}).bind(this);rarrow.onload=(function(){var offset=this.useNewStyle?this.handle.radius:this.arrows.right.width;this.arrows.rdraw.x=center.x+offset;this.arrows.rdraw.y=center.y-(this.arrows.right.height>>1);var ctx=this.canvas.getContext('2d');ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);}).bind(this);this.width=this._dpx(window.innerWidth);this.height=this._dpx(80);this.canvas.width=this.width;this.canvas.height=this.height;this.canvas.style.width=window.innerWidth+'px';this.canvas.style.height=80+'px';this.center.x=this.canvas.offsetLeft+this.canvas.width>>1;this.center.y=this.canvas.offsetTop+this.canvas.height>>1;this.handle.radius=this._dpx(this.handle.radius);if(this.useNewStyle){this.handle.innerRadius=this._dpx(this.handle.innerRadius);}
this.track.radius=this.handle.radius+this._dpx(this.useNewStyle?2:1);this.handle.lineWidth=this._dpx(this.handle.lineWidth);this.handle.autoExpand.sentinelOffset=this._dpx(this.handle.autoExpand.sentinelOffset);this.iconBG.radius=this._dpx(this.iconBG.radius);this.canvas.getContext('2d').save();this.canvas.getContext('2d',this.handle.radius<<1,0);var trackLength='tiny'===this.layout?this.track.length.tiny:this.track.length.large;trackLength=this._dpx(trackLength);var maxWidth=(trackLength-
(this.handle.radius<<1))>>1;maxWidth-=2;this.handle.maxWidth=maxWidth;this.handle.autoExpand.sentinelWidth=maxWidth-this.handle.autoExpand.sentinelOffset;this.track.width=trackLength;this.track.from=this.center.x-maxWidth;this.track.to=this.center.x+maxWidth;this.track.y=this.center.y;this._drawTrack();this._drawIconBG();this._resetHandle();this._resetTouchStates();};LockScreenSlidePrototype._finalizeCanvas=function lss_finalizeCanvas(){this.states.slidingColorful=false;this.states.slidingColorGradientEnd=false,this._clearCanvas();};LockScreenSlidePrototype._onSliding=function lss_onSliding(tx){var mtx=this._mapCoord(tx,0)[0];var isLeft=tx-this.center.x<0;this._clearCanvas();var expandSentinelR=this.center.x+
this.handle.autoExpand.sentinelWidth;var expandSentinelL=this.center.x-
this.handle.autoExpand.sentinelWidth;var center=this.center;var radius=this.handle.radius;var ctx=this.canvas.getContext('2d');if(tx>expandSentinelR||tx<expandSentinelL){var prevState=this.handle.autoExpand.accState;this.handle.autoExpand.accState='accelerating';var currentState=this.handle.autoExpand.accState;var slow=false;if(isLeft){slow=this.states.touch.deltaX>0;if(prevState!==currentState)
this.publish('lockscreenslide-near-left',{'currentState':currentState,'prevState':prevState});}else{slow=this.states.touch.deltaX<0;if(prevState!==currentState)
this.publish('lockscreenslide-near-right',{'currentState':currentState,'prevState':prevState});}}else{var prevState=this.handle.autoExpand.accState;this.handle.autoExpand.accState='normal';var currentState=this.handle.autoExpand.accState;if(prevState!==currentState){if(isLeft){if(prevState!==currentState)
this.publish('lockscreenslide-near-left',{'currentState':currentState,'prevState':prevState});}else{if(prevState!==currentState)
this.publish('lockscreenslide-near-right',{'currentState':currentState,'prevState':prevState});}}}
mtx=this._accelerateSlide(tx);this._drawTrack();this._drawArrowsTo(mtx);this._drawIconBG();this._drawSlideTo(mtx);};LockScreenSlidePrototype._onSlideBegin=function lss_onSlideBegin(tx){var canvasCenterX=this.canvas.clientWidth>>1;var center=this.center;var boundaryR=center.x+this.handle.radius;var boundaryL=center.x-this.handle.radius;if(tx>boundaryR||tx<boundaryL){this.states.sliding=false;return;}
this.publish('lockscreenslide-unlocking-start');this.states.touch.initX=tx;this.states.sliding=true;this._lightIcons();};LockScreenSlidePrototype._endGesture=function lss_endGesture(){window.removeEventListener('touchmove',this);window.removeEventListener('touchend',this);this.states.sliding=false;this._onSlideEnd();this._resetTouchStates();this.overlay.classList.remove('touched');this.states.slideReachEnd=false;};LockScreenSlidePrototype._onSlideEnd=function lss_onSlideEnd(){var isLeft=this.states.touch.pageX-this.center.x<0;if(false===this.states.slideReachEnd){this._bounceBack(this.states.touch.pageX);}else{var intention=isLeft?'lockscreenslide-activate-left':'lockscreenslide-activate-right';this.publish(intention);}
this.publish('lockscreenslide-unlocking-stop');this._darkIcons();};LockScreenSlidePrototype._onTouchMove=function ls_handleMove(pageX,pageY){var touch=this.states.touch;if(!touch.touched){if(!this.states.sliding)
return;touch.touched=true;touch.initX=pageX;var overlay=this.overlay;overlay.classList.add('touched');}
touch.tx=pageX-touch.initX;touch.pageX=pageX;if(-1!==touch.pageX){touch.deltaX=pageX-touch.prevX;}
touch.prevX=pageX;};LockScreenSlidePrototype._accelerateSlide=function lss_accelerateSlide(tx){var isLeft=tx-this.center.x<0;var dx=Math.abs(tx-this.center.x);var accFactor=this.handle.autoExpand.accFactor;var acc=Math.pow(dx,accFactor);var accTx=tx+acc;if(isLeft)
accTx=tx-acc;if(accTx<0)
accTx=0;return accTx;};LockScreenSlidePrototype._clearCanvas=function lss_clearCanvas(){var canvas=this.canvas;var ctx=canvas.getContext('2d');ctx.clearRect(0,0,canvas.width,canvas.height);};LockScreenSlidePrototype._bounceBack=function lss_bounceBack(tx,cb){var canvas=this.canvas;var ctx=canvas.getContext('2d');var duration=this.handle.bounceBackTime;var center=this.center;var nextTx=tx;var tsBegin=null;var mspf=0;var interval=1;var isLeft=tx-center.x<0;var drawIt=(function _drawIt(ts){if(null===tsBegin)
tsBegin=ts;if(ts-tsBegin<duration){if(0===mspf)
mspf=ts-tsBegin;interval=Math.abs(center.x-tx)/(duration/mspf);nextTx=isLeft?nextTx+interval:nextTx-interval;if((isLeft&&nextTx<center.x)||(!isLeft&&nextTx>=center.x)){this._clearCanvas();this._drawTrack();this._drawArrowsTo(nextTx);this._drawIconBG();this._drawSlideTo(nextTx);}
requestAnimationFrame(drawIt);}else{this._clearCanvas();this._drawTrack();this._drawArrowsTo(center.x);this._drawIconBG();this._drawSlideTo(center.x);if(cb)
cb();}}).bind(this);requestAnimationFrame(drawIt);};LockScreenSlidePrototype._darkIcons=function lss_darkIcons(){this.areas.left.classList.add('dark');this.areas.right.classList.add('dark');};LockScreenSlidePrototype._drawArrowsTo=function lss_drawArrows(tx){var canvas=this.canvas;var ctx=canvas.getContext('2d');var radius=this.handle.radius;var center=this.center;var offset=tx-center.x;var isLeft=offset<0;var alpha=1-Math.min(1,Math.abs(offset)/this._dpx(30));if(this.handle.maxWidth<Math.abs(offset)){this.states.slideReachEnd=true;return;}
this.states.slideReachEnd=false;if(isLeft){var position=this.useNewStyle?(tx-this.arrows.left.width-this.handle.radius):(tx-(this.arrows.left.width<<1));var oldAlpha=ctx.globalAlpha;ctx.globalAlpha=alpha;ctx.drawImage(this.arrows.left,position,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);ctx.globalAlpha=oldAlpha;ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);}else{var position=this.useNewStyle?(tx+this.handle.radius):(tx+this.arrows.right.width);var oldAlpha=ctx.globalAlpha;ctx.globalAlpha=alpha;ctx.drawImage(this.arrows.right,position,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);ctx.globalAlpha=oldAlpha;ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);}};LockScreenSlidePrototype._drawTrack=function lss_drawTrack(){var canvas=this.canvas;var ctx=canvas.getContext('2d');var radius=this.track.radius;if(this.useNewStyle){var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var draw=(function(fillStyle,strokeStyle){ctx.beginPath();ctx.fillStyle=fillStyle;ctx.strokeStyle=strokeStyle;ctx.lineWidth=this.handle.lineWidth;ctx.moveTo(this.track.from,this.track.y-radius);ctx.lineTo(this.track.to,this.track.y-radius);ctx.arc(this.track.to,this.track.y,radius,startAngle,endAngle,false);ctx.lineTo(this.track.from,this.track.y+radius);ctx.arc(this.track.from,this.track.y,radius,endAngle,startAngle,false);ctx.fill();ctx.closePath();ctx.stroke();}).bind(this);draw(this.track.backColor,'transparent');var gradientStroke=ctx.createLinearGradient(this.track.from-radius,this.track.y-radius,this.track.from-radius,this.track.y+radius);var gradientFill=ctx.createLinearGradient(this.track.from-radius,this.track.y-radius,this.track.from-radius,this.track.y+radius);gradientStroke.addColorStop(0,this.track.strokeColorTop);gradientStroke.addColorStop(1,this.track.strokeColorBottom);gradientFill.addColorStop(0,this.track.fillColorTop);gradientFill.addColorStop(1,this.track.fillColorBottom);draw(gradientFill,gradientStroke);}else{var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var strokeStyle=this.track.color;ctx.fillStyle=this.track.backgroundColor;ctx.lineWidth=this.handle.lineWidth;ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(this.track.from,this.track.y,radius,endAngle,startAngle,false);ctx.lineTo(this.track.from,this.track.y-radius);ctx.lineTo(this.track.to,this.track.y-radius);ctx.arc(this.track.to,this.track.y,radius,startAngle,endAngle,false);ctx.lineTo(this.track.from,this.track.y+radius);ctx.fill();ctx.stroke();ctx.closePath();}};LockScreenSlidePrototype._drawSlideTo=function lss_drawSlideTo(tx){var canvas=this.canvas;var ctx=canvas.getContext('2d');var maxWidth=this.handle.maxWidth;var offset=tx;var radius=this.handle.radius;var center=this.center;var rw=offset-center.x;var urw=Math.abs(rw);if(this.handle.maxWidth<urw){offset=rw>0?center.x+maxWidth:center.x-maxWidth;}
var counterclock=false;if(offset-center.x<0){counterclock=true;}
var isLeft=counterclock;var isLeft=counterclock;var isRight=offset-center.x>0;if(isLeft){this.handle.touchedColor=this.colors.left.touchedColor;this.handle.touchedColorStop=this.colors.left.touchedColorStop;}else if(isRight){this.handle.touchedColor=this.colors.right.touchedColor;this.handle.touchedColorStop=this.colors.right.touchedColorStop;}
var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var fillAlpha=0.0;var strokeStyle='white';const GRADIENT_LENGTH=50;if(this.useNewStyle){if(0===urw){ctx.beginPath();ctx.arc(center.x,center.y,radius,0,2*Math.PI,false);ctx.fillStyle=this.handle.outerColor;ctx.closePath();ctx.fill();ctx.beginPath();ctx.arc(center.x,center.y,this.handle.innerRadius,0,2*Math.PI,false);ctx.fillStyle=this.handle.innerColor;ctx.closePath();ctx.fill();}else{fillAlpha=0.9-Math.min(0.7,(urw/this.handle.maxWidth)*0.7);strokeStyle='transparent';ctx.fillStyle='rgba('+this.handle.touchedColor+', '+
fillAlpha+')';ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(center.x,center.y,radius,endAngle,startAngle,counterclock);ctx.lineTo(center.x,center.y-radius);ctx.lineTo(center.x+(offset-center.x),center.y-radius);ctx.arc(offset,center.y,radius,startAngle,endAngle,counterclock);ctx.lineTo(center.x,center.y+radius);ctx.fill();ctx.stroke();ctx.closePath();}}else{var fillColor;var strokeColor;if(urw>15&&true!==this.states.slidingColorful){fillAlpha=(urw-15)/GRADIENT_LENGTH;if(fillAlpha>1.0){fillAlpha=1.0;this.states.slidingColorGradientEnd=true;}
var borderAlpha=1.0-fillAlpha;strokeStyle='rgba('+this.handle.touchedColorStop+','+borderAlpha+')';this.states.slidingColorful=true;}else{if(0===urw){fillAlpha=this.handle.backgroundAlpha;strokeColor=this.handle.color;fillColor=this.handle.backgroundColor;}else{fillAlpha=(urw-15)/GRADIENT_LENGTH;if(fillAlpha>1.0){fillAlpha=1.0;}
strokeColor=this.handle.touchedColorStop;fillColor=this.handle.touchedColor;}
var borderAlpha=1.0-fillAlpha;strokeStyle='rgba('+strokeColor+','+borderAlpha+')';}
ctx.fillStyle='rgba('+fillColor+','+fillAlpha+')';ctx.lineWidth=this.handle.lineWidth;ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(center.x,center.y,radius,endAngle,startAngle,counterclock);ctx.lineTo(center.x,center.y-radius);ctx.lineTo(center.x+(offset-center.x),center.y-radius);ctx.arc(offset,center.y,radius,startAngle,endAngle,counterclock);ctx.lineTo(center.x,center.y+radius);ctx.fill();ctx.stroke();ctx.closePath();}};LockScreenSlidePrototype._drawIconBG=function lss_dibg(){if(!this.useNewStyle)
return;var canvas=this.canvas;var ctx=canvas.getContext('2d');ctx.fillStyle=this.iconBG.left.color;ctx.strokeStyle='transparent';ctx.beginPath();ctx.arc(this.track.from,this.track.y,this.iconBG.radius,0,2*Math.PI,false);ctx.stroke();ctx.closePath();ctx.fill();ctx.fillStyle=this.iconBG.right.color;ctx.beginPath();ctx.arc(this.track.to,this.track.y,this.iconBG.radius,0,2*Math.PI,false);ctx.fill();ctx.stroke();ctx.closePath();};LockScreenSlidePrototype._dpx=function lss_dpx(px){return px*window.devicePixelRatio;};LockScreenSlidePrototype._lightIcons=function lss_lightIcons(){this.areas.left.classList.remove('dark');this.areas.right.classList.remove('dark');};LockScreenSlidePrototype._mapCoord=function lss_mapCoord(x,y){var cw=this.canvas.clientWidth;var ch=this.canvas.clientHeight;return[cw*x/window.innerWidth,ch*y/window.innerHeight];};LockScreenSlidePrototype._resetArrows=function lss_restoreArrows(){var canvas=this.canvas;var ctx=canvas.getContext('2d');var center=this.center;ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);};LockScreenSlidePrototype._resetHandle=function lss_resetHandle(){this.states.slidingColorful=false;this.states.slidingColorGradientEnd=false;var canvas=this.canvas;var centerx=this.center.x;this._drawSlideTo(centerx);};LockScreenSlidePrototype._resetTouchStates=function lss_resetTouchStates(){this.states.touch={id:null,touched:false,initX:this.center.x,pageX:this.center.x,pageY:this.center.y,tx:0,prevX:this.center.x,deltaX:0};};LockScreenSlidePrototype.publish=function lss_publish(type,detail){window.dispatchEvent(new CustomEvent(type,{'detail':detail}));};LockScreenSlide.prototype=LockScreenSlidePrototype;exports.LockScreenSlide=LockScreenSlide;})(window);;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined'){return this._isOnRealDevice;}
if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name]&&this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media){continue;}
window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;'use strict';(function(window){var _start=Date.now();var DEBUG=false;window.SIMSlot=function SIMSlot(conn,index,card){this.index=index;this.conn=conn;if(card){this.update(card);}
this.publish('created');};SIMSlot.EVENTS=['cardstatechange','iccinfochange','stkcommand','stksessionend'];SIMSlot.METHODS=['sendStkResponse','sendStkMenuSelection','sendStkTimerExpiration','sendStkEventDownload'];SIMSlot.DOM_REQUEST_METHODS=['getCardLock','unlockCardLock','setCardLock','getCardLockRetryCount','readContacts','updateContact','iccOpenChannel','iccExchangeAPDU','iccCloseChannel'];SIMSlot.ABSENT_TYPES=['permanentBlocked'];SIMSlot.LOCK_TYPES=['pinRequired','pukRequired','networkLocked','corporateLocked','serviceProviderLocked','network1Locked','network2Locked','hrpdNetworkLocked','ruimCorporateLocked','ruimServiceProviderLocked'];SIMSlot.prototype.update=function ss_update(iccObj){this.simCard=iccObj;this.constructor.EVENTS.forEach(function iterater(evt){iccObj.addEventListener(evt,this);},this);this.constructor.DOM_REQUEST_METHODS.forEach(function iterator(domRequest){this[domRequest]=function(){return iccObj[domRequest].apply(iccObj,arguments);};},this);this.constructor.METHODS.forEach(function iterator(method){this[method]=function(){return iccObj[method].apply(iccObj,arguments);};},this);this.publish('updated');};SIMSlot.prototype.EVENT_PREFIX='simslot-';SIMSlot.prototype.CLASS_NAME='SIMSLOT';SIMSlot.prototype.publish=function ss_publish(eventName){this.debug(' publish: '+eventName);window.dispatchEvent(new CustomEvent(this.EVENT_PREFIX+eventName,{detail:this}));};SIMSlot.prototype.handleEvent=function ss_handleEvent(evt){switch(evt.type){default:this.publish(evt.type);if(this.simCard){this.debug(this.simCard.cardState);}
break;}};SIMSlot.prototype.debug=function(){if(DEBUG){console.log('['+this.CLASS_NAME+']'+'['+(this.index)+']'+'['+(new Date().getTime()/1000-_start).toFixed(3)+']'+
Array.slice(arguments).concat());}};SIMSlot.prototype.isAbsent=function ss_isAbsent(){return(!this.simCard||this.constructor.ABSENT_TYPES.indexOf(this.simCard.cardState)>=0||this.simCard&&this.simCard.iccInfo&&this.simCard.iccInfo.iccid===null);};SIMSlot.prototype.getSmsc=function ss_getSmsc(cb){var mobileMessage=window.navigator.mozMobileMessage;if(!mobileMessage){console.error('can\'t access mozMobileMessage');cb(null);}else{var req=mobileMessage.getSmscAddress(this.index);req.onsuccess=function(){var smsc=this.result.split(',')[0].replace(/"/g,'');cb(smsc);};req.onerror=function(){console.error(this.error);cb(null);};}};SIMSlot.prototype.isUnknownState=function ss_isUnknownState(){var empty=(this.simCard.cardState==='');var unknown=(this.simCard.cardState==='unknown');return!this.simCard.cardState||unknown||empty;};SIMSlot.prototype.isLocked=function ss_isLocked(){return this.constructor.LOCK_TYPES.indexOf(this.simCard.cardState)>=0;};SIMSlot.prototype.getCardState=function ss_getCardState(){return this.simCard.cardState;};}(window));;'use strict';(function(window){var IccManager=navigator.mozIccManager;window.SIMSlotManager={length:0,_instances:[],TIMEOUT_FOR_SIM2:2000,_timerForSIM2:null,ready:false,init:function ssm_init(){if(!IccManager){return;}
this._conns=Array.prototype.slice.call(navigator.mozMobileConnections);this.length=this._conns.length;if(this._conns.length===0){return;}
var allSIMCardDetected=true;this._conns.forEach(function iterator(conn,index){var slot=new SIMSlot(conn,index,IccManager.getIccById(conn.iccId));this._instances.push(slot);if(slot.isAbsent()){allSIMCardDetected=false;}},this);if(allSIMCardDetected){this.publishSIMSlotIsReady();return;}
if(this.isMultiSIM()&&this.hasOnlyOneSIMCardDetected()){this.waitForSecondSIM();}
IccManager.addEventListener('iccdetected',this);},isMultiSIM:function(){return(this.length>1);},isSIMCardAbsent:function ssm_isSIMCardAbsent(index){var slot=this.get(index);if(slot){return slot.isAbsent();}else{return true;}},hasOnlyOneSIMCardDetected:function(){var sim0Absent=this.isSIMCardAbsent(0);var sim1Absent=this.isSIMCardAbsent(1);var hasOneSim=(sim0Absent&&!sim1Absent)||(!sim0Absent&&sim1Absent);return hasOneSim;},noSIMCardOnDevice:function ssm_noSIMCardOnDevice(){if(!IccManager||!IccManager.iccIds){return true;}
return(IccManager.iccIds.length===0);},noSIMCardConnectedToNetwork:function ssm_noSIMCardConnectedToNetwork(){if(!IccManager||!IccManager.iccIds){return true;}
return this._instances.every(function iterator(instance){return instance.conn.voice&&instance.conn.voice.emergencyCallsOnly;});},get:function ssm_get(index){if(index>this.length-1){return null;}
return this._instances[index];},getMobileConnection:function ssm_getMobileConnection(index){if(index>this.length-1){return null;}
return this._instances[index].conn;},getSlots:function ssm_getSlots(){return this._instances;},getSlotByIccId:function ssm_getSlotByIccId(iccId){var found=null;this._instances.some(function iterator(slot,index){if(slot.conn.iccId&&slot.conn.iccId===iccId){found=slot;return true;}else{return false;}},this);return found;},waitForSecondSIM:function(){var self=this;this._timerForSIM2=setTimeout(function(){clearTimeout(self._timerForSIM2);self.publishSIMSlotIsReady();},this.TIMEOUT_FOR_SIM2);},publishSIMSlotIsReady:function(){if(!this.ready){this.ready=true;window.dispatchEvent(new CustomEvent('simslotready'));}},handleEvent:function ssm_handleEvent(evt){switch(evt.type){case'iccdetected':var slot=this.getSlotByIccId(evt.iccId);if(slot){slot.update(IccManager.getIccById(evt.iccId));if(!this.isMultiSIM()){this.publishSIMSlotIsReady();}else{if(this.hasOnlyOneSIMCardDetected()){this.waitForSecondSIM();}else{clearTimeout(this._timerForSIM2);this.publishSIMSlotIsReady();}}}
break;}}};SIMSlotManager.init();}(window));;'use strict';(function(exports){var _lockedStateMsgMap={'unknown':'emergencyCallsOnly-unknownSIMState','pinRequired':'emergencyCallsOnly-pinRequired','pukRequired':'emergencyCallsOnly-pukRequired','networkLocked':'emergencyCallsOnly-networkLocked','serviceProviderLocked':'emergencyCallsOnly-serviceProviderLocked','corporateLocked':'emergencyCallsOnly-corporateLocked','network1Locked':'emergencyCallsOnly-network1Locked','network2Locked':'emergencyCallsOnly-network2Locked','hrpdNetworkLocked':'emergencyCallsOnly-hrpdNetworkLocked','ruimCorporateLocked':'emergencyCallsOnly-ruimCorporateLocked','ruimServiceProviderLocked':'emergencyCallsOnly-ruimServiceProviderLocked'};var _NETWORKS_2G=['gsm','gprs','edge'];var LockScreenConnInfoManager=function(root){if(root){this._initialize(root);}};var LockScreenConnInfoManagerPrototype={_connStates:null,_settings:null,_cellbroadcastLabel:null,_telephonyDefaultServiceId:0,_airplaneMode:false};LockScreenConnInfoManagerPrototype._initialize=function lscs_initialize(root){this._connStates=root;this._settings=navigator.mozSettings;this._connStates.hidden=false;SIMSlotManager.getSlots().forEach(function(simslot,index){this._connStates.appendChild(this._createConnStateElement());simslot.conn.addEventListener('voicechange',(function(index){this.updateConnState(simslot);}).bind(this));},this);navigator.mozL10n.ready(this.updateConnStates.bind(this));window.addEventListener('simslot-cardstatechange',(function(evt){this.updateConnState(evt.detail);}).bind(this));window.addEventListener('simslot-iccinfochange',(function(evt){this.updateConnState(evt.detail);}).bind(this));window.addEventListener('cellbroadcastmsgchanged',(function(evt){this._cellbroadcastLabel=evt.detail;this.updateConnStates();}).bind(this));this._settings.addObserver('ril.radio.disabled',(function(evt){this._airplaneMode=evt.settingValue;this.updateConnStates();}).bind(this));this._settings.addObserver('ril.telephony.defaultServiceId',(function(evt){this._telephonyDefaultServiceId=evt.settingValue;this.updateConnStates();}).bind(this));var req=SettingsListener.getSettingsLock().get('ril.radio.disabled');req.onsuccess=(function(){this._airplaneMode=!!req.result['ril.radio.disabled'];var req2=SettingsListener.getSettingsLock().get('ril.telephony.defaultServiceId');req2.onsuccess=(function(){this._telephonyDefaultServiceId=req2.result['ril.telephony.defaultServiceId']||0;this.updateConnStates();}).bind(this);}).bind(this);};LockScreenConnInfoManagerPrototype._createConnStateElement=function lscs_createConnStateElement(){var div=document.createElement('div');var span=document.createElement('span');var line1=document.createElement('span');var line2=document.createElement('span');line1.className=line2.className='connstate-line';div.appendChild(span);div.appendChild(line1);div.appendChild(line2);return div;};LockScreenConnInfoManagerPrototype.updateConnStates=function lscs_updateConnStates(){SIMSlotManager.getSlots().forEach((function(simslot){this.updateConnState(simslot);}).bind(this));};function lineText(node,l10nId,l10nArgs,text){if(!l10nId&&!text){node.setAttribute('data-content',true);}else{node.removeAttribute('data-content');}
if(l10nId){navigator.mozL10n.setAttributes(node,l10nId,l10nArgs);}else{node.removeAttribute('data-l10n-id');if(text){node.textContent=text;}else{node.textContent='';}}}
LockScreenConnInfoManagerPrototype.updateConnState=function lscs_updateConnState(simslot){var conn=simslot.conn;var index=simslot.index;var connstate=this._connStates.children[index];var simIDLine=connstate.children[0];var connstateLines=Array.prototype.slice.call(connstate.querySelectorAll('.connstate-line'));var iccObj=simslot.simCard;var voice=conn.voice;connstate.hidden=false;if(SIMSlotManager.isMultiSIM()){simIDLine.hidden=false;lineText(simIDLine,'lockscreen-sim-id',{n:(index+1)});}else{simIDLine.hidden=true;}
connstateLines.forEach(function(line){lineText(line);});var nextLine=function(){for(var i=0;i<connstateLines.length;i++){var line=connstateLines[i];if(line.hasAttribute('data-content')){return line;}}
return connstateLines[connstateLines.length-1];};if(this._airplaneMode){if(index===0){lineText(nextLine(),'airplaneMode');}else{connstate.hidden=true;}
simIDLine.hidden=true;return;}
if(SIMSlotManager.noSIMCardOnDevice()){if(index===0){if(voice.emergencyCallsOnly){lineText(nextLine(),'emergencyCallsOnly');lineText(nextLine(),'emergencyCallsOnly-noSIM');}else{lineText(nextLine(),'emergencyCallsOnly-noSIM');}}
simIDLine.hidden=true;return;}else if(SIMSlotManager.noSIMCardConnectedToNetwork()){if(index===0){lineText(nextLine(),'emergencyCallsOnly');}
simIDLine.hidden=true;return;}
if(SIMSlotManager.isMultiSIM()&&navigator.mozIccManager.iccIds.length==1&&simslot.isAbsent()){connstate.hidden=true;return;}
if(voice&&'state'in voice&&voice.state=='notSearching'){lineText(nextLine(),'noNetwork');return;}
if(!voice.connected&&!voice.emergencyCallsOnly){lineText(nextLine(),'searching');return;}
if(voice.emergencyCallsOnly){if(this._telephonyDefaultServiceId==index){lineText(nextLine(),'emergencyCallsOnly');lineText(nextLine(),_lockedStateMsgMap[iccObj.cardState]);}else{connstate.hidden=true;}
return;}
var operatorInfos=MobileOperator.userFacingInfo(conn);var operator=operatorInfos.operator;var is2G=_NETWORKS_2G.some(function checkConnectionType(elem){return(conn.voice.type==elem);});var l10nArgs;if(voice.roaming){l10nArgs={operator:operator};lineText(nextLine(),'roaming',l10nArgs);}else{lineText(nextLine(),null,null,operator);}
if(this._cellbroadcastLabel&&is2G){lineText(nextLine(),null,null,this._cellbroadcastLabel);}else if(operatorInfos.carrier){l10nArgs={carrier:operatorInfos.carrier,region:operatorInfos.region};lineText(nextLine(),'operator-info',l10nArgs);}};LockScreenConnInfoManager.prototype=LockScreenConnInfoManagerPrototype;exports.LockScreenConnInfoManager=LockScreenConnInfoManager;})(window);