;window.COMPONENTS_BASE_URL='/shared/elements/';;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,value,ast){var pos,v;if(value.indexOf('{{')!==-1){value=this.parseString(value);}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v===undefined?null:node.$v,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
var value;if(Array.isArray(node)){value=node;}
return{id:id,value:value||node.$v||null,index:node.$x||null,env:env,dirty:false};}
function format(args,entity){if(typeof entity==='string'){return entity;}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var val;try{val=resolveValue(args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return val;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return env['__'+id];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return args[id];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(args,env,id){var value;try{value=resolveIdentifier(args,env,id);}catch(err){return'{{ '+id+' }}';}
if(typeof value==='number'){return value;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
return value;}
return'{{ '+id+' }}';}
function interpolate(args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return prev+cur;}else if(cur.t==='idOrVar'){return prev+subPlaceable(args,env,cur.v);}},'');}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName);if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1]):undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(args,env,expr,index){if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'||!expr){return expr;}
if(Array.isArray(expr)){return interpolate(args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(args,env,expr[selector]);}}
if('other'in expr){return resolveValue(args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;(key=keys[i]);i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function replaceChars(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\}|&[#\w]+;)/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return replaceChars(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO={'qps-ploc':new Pseudo('qps-ploc','Runtime Accented',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Runtime Mirrored',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo()?this.ctx.defaultLocale:id);}
Locale.prototype.isPseudo=function(){return this.ctx.qps.indexOf(this.id)!==-1;};var bindingsIO={extra:function(id,ver,path,type,callback,errback){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo()?ctx.defaultLocale:this.id;var appVersion=null;var source='app';if(typeof(navigator)!=='undefined'){source=navigator.mozL10n._config.localeSources[this.id]||'app';appVersion=navigator.mozL10n._config.appVersion;}
for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo()?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0,node;node=ast[i];i++){this.entries[node.$i]=createEntry(node,this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.qps=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);return entity.id;}}
function formatEntity(args,entity){if(!entity.attrs){return{value:formatValue.call(this,args,entity),attrs:null};}
var formatted={value:formatValue.call(this,args,entity),attrs:Object.create(null)};for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){var supportedLocale;for(var i=0;i<requested.length;i++){var locale=requested[i];if(available.indexOf(locale)!==-1){supportedLocale=locale;break;}}
if(!supportedLocale||supportedLocale===defaultLocale){return[defaultLocale];}
return[supportedLocale,defaultLocale];}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];this.qps=Object.keys(PSEUDO);if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);var pos=this.qps.indexOf(loc);if(pos!==-1){this.qps.splice(pos,1);}}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var supported=negotiate(this.availableLocales.concat(this.qps),requested,this.defaultLocale);if(this.supportedLocales[0]!==supported[0]){freeze.call(this,supported);}};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=navigator.mozL10n.ctx.qps.indexOf(navigator.language)===-1&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(!pretranslate){initObserver();}
initResources.call(navigator.mozL10n);}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
var allowedHtmlAttrs={'ariaLabel':'aria-label','ariaValueText':'aria-valuetext','ariaMozHint':'aria-moz-hint','label':'label','placeholder':'placeholder','title':'title'};function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(!entity){return false;}
if(typeof entity.value==='string'){setTextContent.call(this,l10n.id,element,entity.value);}
for(var key in entity.attrs){var attr=entity.attrs[key];if(allowedHtmlAttrs.hasOwnProperty(key)){element.setAttribute(allowedHtmlAttrs[key],attr);}else if(key==='innerHTML'){element.innerHTML=attr;}}
return true;}
function setTextContent(id,element,text){if(element.firstElementChild){throw new L10nError('setTextContent is deprecated (https://bugzil.la/1053629). '+'Setting text content of elements with child elements is no longer '+'supported by l10n.js. Offending data-l10n-id: "'+id+'" on element '+element.outerHTML+' in '+this.ctx.id);}
element.textContent=text;}})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(Math.abs(secDiff)>60){secDiff=secDiff>0?Math.ceil(secDiff):Math.floor(secDiff);}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;(function(){'use strict';if(window.navigator.mozHour12||window.navigator.hour12){return;}
window.navigator.mozHour12=null;var _setMozHour12=function(result){if(window.navigator.mozHour12!==result){window.navigator.mozHour12=result;window.dispatchEvent(new CustomEvent('timeformatchange'));}};var _hour12Handler=function(event){_setMozHour12(event.settingValue);};var _kLocaleTime='locale.hour12';var req=window.navigator.mozSettings.createLock().get(_kLocaleTime);req.onsuccess=function(){_setMozHour12(req.result[_kLocaleTime]);};window.navigator.mozSettings.addObserver(_kLocaleTime,_hour12Handler);})();;(function(exports){'use strict';var priv=new WeakMap();var rmatcher=/\$\{([^}]+)\}/g;var rentity=/[&<>"']/g;var rentities={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&apos;'};function extract(node){var nodeId;if(typeof node==='string'){nodeId=node;node=document.getElementById(node);}else if(node){nodeId=node.id;}
if(!node){console.error('Can not find the node passed to Template',nodeId);return'';}
if(!node.firstChild){console.error('Node passed to Template should have a comment node',nodeId);return'';}
node=node.firstChild;do{if(node.nodeType===Node.COMMENT_NODE){return(node.nodeValue||'').trim();}}while((node=node.nextSibling));console.error('Nodes passed to Template should have a comment node',nodeId);return'';}
function Template(idOrNode){if(!(this instanceof Template)){return new Template(idOrNode);}
priv.set(this,{idOrNode:idOrNode});}
Template.prototype.extract=function(){var members=priv.get(this);if(!members.tmpl){members.tmpl=extract(members.idOrNode);delete members.idOrNode;}
return members.tmpl;};Template.prototype.toString=function(){return this.extract().slice();};Template.prototype.interpolate=function(data,options){options=options||{};options.safe=options.safe||[];return this.extract().replace(rmatcher,function(match,property){property=property.trim();return options.safe.indexOf(property)===-1?Template.escape(data[property]):data[property];});};Template.prototype.prepare=function(data,options){var self=this;return{toString:function t_toString(){return self.interpolate(data,options);},toDocumentFragment:function t_toDocumentFragment(){var template=document.createElement('template');template.innerHTML=this.toString();return template.content.cloneNode(true);}};};Template.escape=function escape(str){if(typeof str!=='string'){return'';}
return str.replace(rentity,function(s){return rentities[s];});};exports.Template=Template;}(this));;'use strict';(function(window){window.mozPerformance={timing:{}};function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();var epoch=Date.now();setTimeout(function(){var detail={name:name,timestamp:now,epoch:epoch};var event=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(event);});}
['moz-chrome-dom-loaded','moz-chrome-interactive','moz-app-visually-complete','moz-content-interactive','moz-app-loaded'].forEach(function(eventName){window.addEventListener(eventName,function mozPerfLoadHandler(){dispatch(eventName);},false);});window.PerformanceTestingHelper={dispatch:dispatch};})(window);;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;function StickyHeader(scrollable,sticky){'use strict';var headers=scrollable.getElementsByTagName('header');var stickyPosition;var stickyStyle=sticky.style;this._throttledRefresh=function(){var display=false;if(stickyPosition===undefined){stickyPosition=sticky.offsetHeight+sticky.offsetTop;}
for(var i=1,length=headers.length;i<length;i++){if(headers[i].offsetTop-scrollable.scrollTop>stickyPosition){var lookupIndex=1;var header=headers[i-lookupIndex];while(header&&header.offsetHeight===0){lookupIndex++;header=headers[i-lookupIndex];}
stickyStyle.backgroundImage='-moz-element(#'+header.id+')';display=true;break;}}
sticky.classList.toggle('has-content',display);this.throttle=null;}.bind(this);this.refresh=function(){if(!this.throttle){this.throttle=setTimeout(this._throttledRefresh,0);}}.bind(this);scrollable.addEventListener('scroll',this.refresh);};(function(exports){'use strict';function getThumbnail(contact){return getOnePhoto(contact,'begin');}
function getFullResolution(contact){return getOnePhoto(contact,'end');}
function getOnePhoto(contact,position){if(!contact||!contact.photo||!contact.photo.length){return null;}
if(contact.photo.length===1){return contact.photo[0];}
var photos=contact.photo;var category=contact.category;if(Array.isArray(category)&&category.indexOf('fb_linked')!==-1){if(photos.length>=4){return photos[(position=='begin')?1:0];}
return photos[0];}
photos=photosBySize(contact);var index=(position=='begin')?0:photos.length-1;return photos[index];}
function photosBySize(contact){var photos=contact.photo.slice(0);photos.sort(function(p1,p2){if(size(p1)<size(p2)){return-1;}
if(size(p1)>size(p2)){return 1;}
return 0;});return photos;}
function size(photo){if(typeof photo=='string'){return photo.length;}
return photo.size;}
exports.ContactPhotoHelper={getThumbnail:getThumbnail,getFullResolution:getFullResolution};})(window);;'use strict';var fb=this.fb||{};this.fb=fb;fb.utils=this.fb.utils||{};this.fb.utils=fb.utils;if(typeof fb.utils.Request!=='function'){fb.utils.Request=function(){this.done=function(result){this.result=result;if(typeof this.onsuccess==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onsuccess(ev);}.bind(this),0);}};this.failed=function(error){this.error=error;if(typeof this.onerror==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onerror(ev);}.bind(this),0);}};};};'use strict';var fb=this.fb||{};this.fb=fb;(function(){var contacts=fb.contacts||{};fb.contacts=contacts;var datastore;var DATASTORE_NAME='Gaia_Facebook_Friends';var INDEX_ID=1;var readyState='notInitialized';var INITIALIZE_EVENT='fb_ds_init';var revisionId;function createIndex(){return{byTel:Object.create(null),treeTel:[]};}
var index;function safeError(err){if(err&&err.name){return err;}
return{name:'UnknownError'};}
function notifyOpenSuccess(cb){readyState='initialized';if(typeof cb==='function'){window.setTimeout(cb,0);}
var ev=new CustomEvent(INITIALIZE_EVENT);document.dispatchEvent(ev);}
function initError(outRequest,error){outRequest.failed(error);}
function handleInitError(err,errorCb){readyState='error';contacts.error=err;if(typeof errorCb==='function'){window.setTimeout(function(){errorCb(err);},0);}
document.dispatchEvent(new CustomEvent(INITIALIZE_EVENT));}
function defaultError(request){return defaultErrorCb.bind(null,request);}
function defaultSuccess(request){return defaultSuccessCb.bind(null,request);}
function defaultErrorCb(request,error){request.failed(error);}
function defaultSuccessCb(request,result){request.done(result);}
function setIndex(obj){index=(obj||createIndex());}
function successGet(outReq,data){outReq.done(data);}
function errorGet(outReq,uid,err){window.console.error('Error while getting object for UID: ',uid);outReq.failed(err.name);}
Object.defineProperty(contacts,'datastore',{get:function getDataStore(){return datastore},enumerable:false,configurable:false});Object.defineProperty(contacts,'dsIndex',{get:function getIndex(){return index;},set:setIndex,enumerable:false,configurable:false});contacts.get=function(uid){var outRequest=new fb.utils.Request();window.setTimeout(function get(){contacts.init(function(){doGet(uid,outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doGet(uid,outRequest){var successCb=successGet.bind(null,outRequest);var errorCb=errorGet.bind(null,outRequest,uid);datastore.get(uid).then(successCb,errorCb);}
contacts.getByPhone=function(tel){var outRequest=new fb.utils.Request();window.setTimeout(function get_by_phone(){contacts.init(function get_by_phone(){doGetByPhone(tel,outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doGetByPhone(tel,outRequest){var dsId;var normalizedNumber=navigator.mozPhoneNumberService.normalize(tel);if(datastore.revisionId!==revisionId){window.console.info('Datastore revision id has changed!');datastore.get(INDEX_ID).then(function success(obj){setIndex(obj);revisionId=datastore.revisionId;dsId=index.byTel[normalizedNumber];if(typeof dsId!=='undefined'){datastore.get(dsId).then(function success(friend){outRequest.done(friend);},defaultError(outRequest));}
else{outRequest.done(null);}},function(err){err=safeError(err);window.console.error('The index cannot be refreshed: ',err.name);outRequest.failed(err);});}
else{dsId=index.byTel[normalizedNumber];if(typeof dsId!=='undefined'){datastore.get(dsId).then(function success(friend){outRequest.done(friend);},defaultError(outRequest));}
else{outRequest.done(null);}}}
contacts.search=function(by,number){var outRequest=new fb.utils.Request();window.setTimeout(function do_search(){contacts.init(function do_search_init(){if(by==='phone'){doSearchByPhone(number,outRequest);}},function(err){initError(outRequest,err);});},0);return outRequest;};function doSearchByPhone(number,outRequest){var normalizedNumber=navigator.mozPhoneNumberService.normalize(number);LazyLoader.load(['/shared/js/fb/fb_tel_index.js','/shared/js/binary_search.js'],function(){var toSearchNumber=normalizedNumber;if(number.charAt(0)==='+'){toSearchNumber=number.substring(1);}
if(datastore.revisionId!==revisionId){window.console.info('Datastore revision id has changed!');datastore.get(INDEX_ID).then(function success(obj){setIndex(obj);revisionId=datastore.revisionId;var results=TelIndexer.search(index.treeTel,toSearchNumber);var out=null;if(results.length>0){out=datastore.get.apply(datastore,results);}
return out;},function(err){err=safeError(err);window.console.error('The index cannot be refreshed: ',err.name);outRequest.failed(err);}).then(function success(objList){if(objList&&!Array.isArray(objList)){objList=[objList];}
else{objList=[];}
outRequest.done(objList);},function error(err){err=safeError(err);window.console.error('Error while retrieving result data: ',err.name);outRequest.failed(err);});}
else{var results=TelIndexer.search(index.treeTel,toSearchNumber);if(results.length>0){datastore.get.apply(datastore,results).then(function success(objList){if(!Array.isArray(objList)){objList=[objList];}
outRequest.done(objList);},function error(err){err=safeError(err);window.console.error('Error while retrieving result data: ',err.name);outRequest.failed(err);});}
else{outRequest.done(results);}}});}
contacts.refresh=function(){var outRequest=new fb.utils.Request();window.setTimeout(function clear(){contacts.init(function(){doRefresh(outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doRefresh(outRequest){datastore.get(INDEX_ID).then(function success(obj){setIndex(obj);outRequest.done();},defaultError(outRequest));}
contacts.getLength=function(){var retRequest=new fb.utils.Request();window.setTimeout(function(){contacts.init(function get_all(){doGetLength(retRequest);},function(err){initError(retRequest,err);});},0);return retRequest;};function doGetLength(outRequest){datastore.getLength().then(function success(length){outRequest.done(length-1);},function error(err){outRequest.failed(safeError(err));});}
contacts.restart=function(){readyState='notInitialized';};contacts.init=function(cb,errorCb){if(!navigator.getDataStores){handleInitError({name:'DatastoreNotFound'},errorCb);return;}
if(readyState==='initialized'){cb();return;}
if(readyState==='initializing'){document.addEventListener(INITIALIZE_EVENT,function oninitalized(){cb();document.removeEventListener(INITIALIZE_EVENT,oninitalized);});return;}
readyState='initializing';navigator.getDataStores(DATASTORE_NAME).then(function success(ds){if(ds.length<1){handleInitError({name:'DatastoreNotFound'},errorCb);return;}
datastore=ds[0];datastore.getLength().then(function(length){if(length===0&&datastore.readOnly===false){window.console.info('Adding index as length is 0');setIndex(createIndex());return datastore.add(index);}
else if(length>0){return datastore.get(INDEX_ID);}
else if(datastore.readOnly===true){window.console.warn('The datastore is empty and readonly');}
return null;}).then(function add_index_success(v){if(typeof v!=='number'){setIndex(v);}
revisionId=datastore.revisionId;notifyOpenSuccess(cb);},function add_index_error(err){err=safeError(err);window.console.error('Error while setting the index: ',err.name);handleInitError(err,errorCb);});},function error(err){err=safeError(err);window.console.error('FB: Error while opening the DataStore: ',err.name);handleInitError(err,errorCb);});};})();;'use strict';var fb=this.fb||{};this.fb=fb;if(!this.AuxFB){this.AuxFb=(function(){var CATEGORY='facebook';var NOT_LINKED='not_linked';var LINKED='fb_linked';function populate(source,target,propertyNames){propertyNames.forEach(function(property){var propertyValue=source[property];if(propertyValue){if(Array.isArray(propertyValue)){target[property]=propertyValue.slice(0,propertyValue.length);}else{target[property]=propertyValue;}}});}
function mergeFbData(dcontact,fbdata){var multipleFields=['email','tel','photo','org','adr'];multipleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=[];}
var items=fbdata[field];if(items){items.forEach(function(item){var dupList=checkDuplicates(field,item,dcontact[field],fbdata.shortTelephone);if(dupList.length===0){dcontact[field].push(item);}});}});var singleFields=['bday','anniversary'];singleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=fbdata[field];}});mergeNames(dcontact,fbdata);}
function mergeNames(devContact,fbContact){var namesChanged=false;var nameFields=['givenName','familyName'];nameFields.forEach(function(anameField){var fieldValue=devContact[anameField];var fbValue=fbContact[anameField];if((!Array.isArray(fieldValue)||fieldValue.length===0)&&Array.isArray(fbValue)&&fbValue.length>0){namesChanged=true;devContact[anameField]=(fieldValue&&fieldValue[0])||[];devContact[anameField].push(fbValue[0]);}});if(namesChanged){var givenName=devContact.givenName[0]||'';var familyName=devContact.familyName[0]||'';devContact.name=[givenName+' '+familyName];}}
function isFbContact(devContact){return(devContact&&devContact.category&&devContact.category.indexOf(CATEGORY)!==-1);}
function isFbLinked(devContact){return(devContact&&devContact.category&&devContact.category.indexOf(LINKED)!==-1);}
function getData(devContact){var outReq=new fb.utils.Request();window.setTimeout(function do_getData(){var uid=getFriendUid(devContact);if(uid){var fbreq=fb.contacts.get(uid);fbreq.onsuccess=function(){var fbdata=fbreq.result;var out=mergeContact(devContact,fbdata);outReq.done(out);};fbreq.onerror=function(){outReq.failed(fbreq.error);};}
else{outReq.done(devContact);}},0);return outReq;}
function getFriendUid(devContact){var out=devContact.uid;if(!out){if(isFbLinked(devContact)){out=getLinkedTo(devContact);}
else if(devContact.category){var idx=devContact.category.indexOf(CATEGORY);if(idx!==-1){out=devContact.category[idx+2];}}}
return out;}
function getLinkedTo(devContact){var out;if(devContact.category){var idx=devContact.category.indexOf(LINKED);if(idx!==-1){out=devContact.category[idx+1];}}
return out;}
function mergeContact(devContact,fbContact){var out=devContact;if(fbContact){out=Object.create(null);out.updated=devContact.updated;out.published=devContact.published;populate(devContact,out,Object.getOwnPropertyNames(devContact));populate(devContact,out,Object.getOwnPropertyNames(Object.getPrototypeOf(devContact)));mergeFbData(out,fbContact);}
return out;}
function getContactByNumber(number,onsuccess,onerror){var req=fb.contacts.getByPhone(number);req.onsuccess=function get_by_phone_success(e){var fbData=req.result;if(fbData){fb.getMozContactByUid(fbData.uid,function merge(result){if(Array.isArray(result)&&result[0]){var finalContact=fb.mergeContact(result[0],fbData);onsuccess(finalContact);}
else{onsuccess(null);}},function error_get_mozContact(err){console.error('Error getting mozContact: ',err.name);onerror(err);});}
else{onsuccess(null);}};req.onerror=function(){onerror(req.error);};}
function checkDuplicates(field,fbItem,devContactItems,extraFbItems){var potentialDuplicatesFields=['email','tel'];var out=[];if(devContactItems&&potentialDuplicatesFields.indexOf(field)!==-1){var total=devContactItems.length;for(var i=0;i<total;i++){var localValue=devContactItems[i].value;var fbValue=fbItem.value;if(localValue){var trimedLocal=localValue.trim();if(trimedLocal===fbValue||(field==='tel'&&Array.isArray(extraFbItems)&&extraFbItems.indexOf(trimedLocal)!==-1)){out.push(trimedLocal);out.push(fbValue);}}}}
return out;}
function getMozContactByUid(uid,onsuccess,onerror){var filter={filterBy:['category'],filterValue:uid,filterOp:'contains'};var req=navigator.mozContacts.find(filter);req.onsuccess=function(){onsuccess(req.result);};req.onerror=function(){onerror(req.error);};}
return{'isFbContact':isFbContact,'isFbLinked':isFbLinked,'getData':getData,'getFriendUid':getFriendUid,'getLinkedTo':getLinkedTo,'mergeContact':mergeContact,'getContactByNumber':getContactByNumber,'getMozContactByUid':getMozContactByUid,'checkDuplicates':checkDuplicates,get CATEGORY(){return CATEGORY;},get LINKED(){return LINKED;},get NOT_LINKED(){return NOT_LINKED;}};})();var props=Object.keys(this.AuxFb);var self=this;for(var j=0,end=props.length;j<end;j++){var prop=props[j];if(typeof self.fb[prop]==='function'){self.fb[prop]=self.AuxFb[prop];}
else{Object.defineProperty(self.fb,prop,{value:(function(){return self.AuxFb[prop];})(),writable:false,enumerable:true,configurable:false});}}};(function(exports){'use strict';function ensureValidEventName(eventName){if(!eventName||typeof eventName!=='string'){throw new Error('Event name should be a valid non-empty string!');}}
function ensureValidHandler(handler){if(typeof handler!=='function'){throw new Error('Handler should be a function!');}}
function ensureAllowedEventName(allowedEvents,eventName){if(allowedEvents&&allowedEvents.indexOf(eventName)<0){throw new Error('Event "'+eventName+'" is not allowed!');}}
var eventDispatcher={on:function(eventName,handler){ensureValidEventName(eventName);ensureAllowedEventName(this.allowedEvents,eventName);ensureValidHandler(handler);var handlers=this.listeners.get(eventName);if(!handlers){handlers=new Set();this.listeners.set(eventName,handlers);}
handlers.add(handler);},off:function(eventName,handler){ensureValidEventName(eventName);ensureAllowedEventName(this.allowedEvents,eventName);ensureValidHandler(handler);var handlers=this.listeners.get(eventName);if(!handlers){return;}
handlers.delete(handler);if(!handlers.size){this.listeners.delete(eventName);}},offAll:function(eventName){if(typeof eventName==='undefined'){this.listeners.clear();return;}
ensureValidEventName(eventName);ensureAllowedEventName(this.allowedEvents,eventName);var handlers=this.listeners.get(eventName);if(!handlers){return;}
handlers.clear();this.listeners.delete(eventName);},emit:function(eventName,parameters){ensureValidEventName(eventName);ensureAllowedEventName(this.allowedEvents,eventName);var handlers=this.listeners.get(eventName);if(!handlers){return;}
handlers.forEach(function(handler){try{handler(parameters);}catch(e){console.error(e);}});}};exports.EventDispatcher={mixin:function(target,allowedEvents){if(!target||typeof target!=='object'){throw new Error('Object to mix into should be valid object!');}
if(typeof allowedEvents!=='undefined'&&!Array.isArray(allowedEvents)){throw new Error('Allowed events should be a valid array of strings!');}
Object.keys(eventDispatcher).forEach(function(method){if(typeof target[method]!=='undefined'){throw new Error('Object to mix into already has "'+method+'" property defined!');}
target[method]=eventDispatcher[method].bind(this);},{listeners:new Map(),allowedEvents:allowedEvents});return target;}};})(window);;'use strict';(function(window){function catchError(e){if(e){console.error('Navigation.toPanel: got an exception: (%s) %s',e,e.stack&&e.stack.replace(/\n/g,'|'));}else{console.log('Navigation.toPanel: got a rejected promise');}}
var currentPanel;var queuedPanel;function nextQueuedPanel(){if(queuedPanel){var next=queuedPanel;queuedPanel=null;Navigation.toPanel(next.panel,next.args).then(next.defer.resolve,next.defer.reject);}}
var Navigation={isReady:false,panelObjects:window,defaultPanel:'thread-list',panels:{'thread':{behaviour:'ThreadUI',wrapperPosition:'left',container:'thread-messages'},'thread-list':{behaviour:'ThreadListUI',wrapperPosition:'right',container:'thread-list'},'composer':{behaviour:'ThreadUI',wrapperPosition:'left',container:'thread-messages'},'group-view':{behaviour:'GroupView',wrapperPosition:'left',container:'information-participants'},'report-view':{behaviour:'ReportView',wrapperPosition:'left',container:'information-report'}},init:function n_init(){this.mainWrapper=document.getElementById('main-wrapper');this.transitionPromise=null;currentPanel=null;Startup.on('post-initialize',function(){this.isReady=true;nextQueuedPanel();}.bind(this));return this.toPanelFromHash();},isCurrentPanel:function n_isCurrentPanel(panel,args){if(!currentPanel||!panel){return false;}
if(panel!==currentPanel.panel){return false;}
if(!args){return true;}
var currentArgs=currentPanel.args||{};for(var arg in args){if(args[arg]!==currentArgs[arg]){return false;}}
return true;},ensureCurrentPanel:function(){if(this.transitionPromise){return this.transitionPromise;}
if(!currentPanel){return this.toPanel(this.defaultPanel);}
return Promise.resolve();},toPanel:function n_toPanel(panel,args){if(!(panel in this.panels)){return Promise.reject(new Error('Panel '+panel+' is unknown.'));}
var notReadyNavigate=(panel!==this.defaultPanel&&!this.isReady);if(this.transitionPromise||notReadyNavigate){queuedPanel={panel:panel,args:args};return new Promise(function(resolve,reject){queuedPanel.defer={resolve:resolve,reject:reject};});}
if(this.isCurrentPanel(panel,args)){return Promise.resolve();}
var transitionArgs=args||{};document.activeElement.blur();transitionArgs.meta={next:{panel:panel,args:args},prev:currentPanel};var nextPanelInfo=this.panels[panel];var nextPanelContainer=document.getElementById(nextPanelInfo.container);var nextPanelObject=this.panelObjects[nextPanelInfo.behaviour];if(!nextPanelObject){var error=new Error('Navigation.toPanel: no behaviour found for panel '+panel);return Promise.reject(error);}
var currentPanelObject;var currentPanelContainer;if(currentPanel){var currentPanelInfo=this.panels[currentPanel.panel];currentPanelObject=this.panelObjects[currentPanelInfo.behaviour];currentPanelContainer=document.getElementById(currentPanelInfo.container);}
var promise=Promise.resolve();if(currentPanelObject&&currentPanelObject.beforeLeave){promise=promise.then(currentPanelObject.beforeLeave.bind(currentPanelObject,transitionArgs));}
if(nextPanelObject.beforeEnter){promise=promise.then(nextPanelObject.beforeEnter.bind(nextPanelObject,transitionArgs));}
promise=promise.then(function resetPanel(){currentPanel=null;});promise=promise.then(this.slide.bind(this,nextPanelInfo.wrapperPosition)).then(function changePanel(){currentPanel={panel:panel,args:args};});promise=promise.then(function(){var promise=Promise.resolve();if(currentPanelObject&&currentPanelObject.afterLeave){promise=promise.then(currentPanelObject.afterLeave.bind(currentPanelObject,transitionArgs)).catch(catchError);}
if(nextPanelObject.afterEnter){promise=promise.then(nextPanelObject.afterEnter.bind(nextPanelObject,transitionArgs)).catch(catchError);}
return promise;});promise=promise.then(function resolved(){this.transitionPromise=null;if(nextPanelContainer===currentPanelContainer){return;}
nextPanelContainer.setAttribute('aria-hidden',false);if(currentPanelContainer){currentPanelContainer.setAttribute('aria-hidden',true);}}.bind(this),function rejected(e){catchError(e);this.transitionPromise=null;return Promise.reject(new Error('Error while transitioning'));}.bind(this));promise.then(()=>this.emit('navigated',{panel:panel,args:args})).then(nextQueuedPanel,nextQueuedPanel);return(this.transitionPromise=promise);},getPanelName:function n_getPanelName(){var hash=window.location.hash;if(hash.length&&hash.startsWith('#')){hash=hash.slice(1);}
var index;if((index=hash.indexOf('&'))!==-1){hash=hash.slice(0,index);}
return hash;},toPanelFromHash:function n_toPanelFromHash(){var panelName=this.getPanelName()||this.defaultPanel;return this.toPanel(panelName,Utils.params(window.location.hash));},slide:function n_slide(position){var wrapper=this.mainWrapper;if(wrapper.dataset.position===position){return Promise.resolve();}
wrapper.dataset.position=position;return new Promise(function(resolve,reject){var trEndCount=0;wrapper.addEventListener('transitionend',function trWait(e){trEndCount++;if(trEndCount<2){return;}
e.currentTarget.removeEventListener(e.type,trWait);resolve();});});}};window.Navigation=EventDispatcher.mixin(Navigation,['navigated']);})(window);;(function(exports){'use strict';var channel=null;const BROADCAST_CHANNEL_NAME='messages-channel';const ALLOWED_EVENTS=['drafts-changed'];function postMessage(name,parameters){if(!channel){throw new Error('Channel is not created!');}
if(!name){throw new Error('Name should be defined!');}
channel.postMessage(parameters!==undefined?{name:name,parameters:parameters}:{name:name});}
const Dispatcher=EventDispatcher.mixin({connect:function(){if(channel){return;}
channel=new BroadcastChannel(BROADCAST_CHANNEL_NAME);channel.addEventListener('message',onMessage);exports.addEventListener('unload',()=>this.disconnect());},disconnect:function(){if(!channel){return;}
channel.close();channel.removeEventListener('message',onMessage);channel=null;}},ALLOWED_EVENTS);const originalEmitter=Dispatcher.emit.bind(Dispatcher);Dispatcher.emit=function(eventName,parameters){if(ALLOWED_EVENTS.indexOf(eventName)<0){throw new Error('Event "'+eventName+'" is not allowed!');}
postMessage(eventName,parameters);};function onMessage(message){try{originalEmitter(message.data.name,message.data.parameters);}catch(error){console.error('Error while emitting event "%s" with parameters "%s"',message.data&&message.data.name,JSON.stringify(message.data&&message.data.parameters),error);}}
exports.InterInstanceEventDispatcher=Dispatcher;})(window);;(function(exports){'use strict';var updateTimer=null;var TimeHeaders={init:function th_init(){onvisibilityChange();document.addEventListener('visibilitychange',onvisibilityChange);},startScheduler:function th_startScheduler(){var now=Date.now(),nextTimeout=new Date(now+60000);nextTimeout.setSeconds(0);nextTimeout.setMilliseconds(0);this.stopScheduler();updateTimer=setTimeout(function(){this.updateAll('header[data-time-update=repeat]');this.startScheduler();}.bind(this),nextTimeout.getTime()-now);},stopScheduler:function th_stopScheduler(){clearTimeout(updateTimer);},updateAll:function th_updateAll(selector){selector=selector||'[data-time-update]';var elements=document.querySelectorAll(selector),length=elements.length,i;for(i=0;i<length;i++){this.update(elements[i]);}},update:function th_update(element){var ts=element.dataset.time;if(!ts){return;}
var newElement;if(element.dataset.dateOnly==='true'){newElement=Utils.getHeaderDate(ts);}else if(element.dataset.timeOnly==='true'){newElement=Utils.getFormattedHour(ts);}else{newElement=Utils.getHeaderDate(ts)+' '+Utils.getFormattedHour(ts);}
if(newElement!==element.textContent){element.textContent=newElement;}}};function onvisibilityChange(){if(document.hidden){TimeHeaders.stopScheduler();}
else{TimeHeaders.updateAll();TimeHeaders.startScheduler();}}
exports.TimeHeaders=TimeHeaders;}(this));;(function(exports){'use strict';var unknownNumbers=[];var filterFns={contains:function(a,b){a=a.toLowerCase();b=b.toLowerCase();return a.contains(b);},equality:function(a,b){a=a.toLowerCase();b=b.toLowerCase();return a===b;}};function isMatch(contact,criteria,filterFn){var found={};outer:for(var i=0,ilen=criteria.terms.length;i<ilen;i++){var term=criteria.terms[i];for(var j=0,jlen=criteria.fields.length;j<jlen;j++){var field=criteria.fields[j];if(!contact[field]){continue;}
for(var k=0,klen=contact[field].length;k<klen;k++){var value=contact[field][k];if(typeof value.value!=='undefined'){value=value.value;}
if((found[term]=filterFn(value.trim(),term))){continue outer;}}}}
return Object.keys(found).every(function(key){return found[key];});}
var rspaces=/\s+/;var Contacts={findBy:function contacts_findBy(filter,callback){var lower=[];var filterValue=(filter.filterValue||'').trim();var terms,request;if(!navigator.mozContacts||!filterValue.length){setTimeout(function(){callback(typeof filter.filterValue==='undefined'?null:[],{});});return;}
terms=filterValue.split(rspaces);filter.filterValue=terms.length===1?terms[0]:terms.reduce(function(initial,term){lower.push(term.toLowerCase());return term.length>initial.length?term:initial;},'');if(filter.filterValue.length<3){filter.filterLimit=10;}
lower.splice(lower.indexOf(filter.filterValue.toLowerCase()),1);lower.push.apply(lower,terms);request=navigator.mozContacts.find(filter);request.onsuccess=function onsuccess(){var contacts=this.result.slice();var fields=['tel','givenName','familyName'];if(Settings.supportEmailRecipient){fields.push('email');}
var criteria={fields:fields,terms:lower};var results=[];var contact;if(terms.length>1){while((contact=contacts.pop())){if(isMatch(contact,criteria,filterFns.contains)){results.push(contact);}}}else{results=contacts;}
callback(results,{terms:terms});};request.onerror=function onerror(){this.onsuccess=this.onerror=null;callback(null);};},findByString:function contacts_findBy(filterValue,callback){var unknownCallback=function(contacts){contacts=contacts||[];this.findByUnknown(filterValue,function(unknown){unknown=unknown||[];callback(contacts.concat(unknown));});}.bind(this);this.findContactByString(filterValue,unknownCallback);},findContactByString:function contacts_findBy(filterValue,callback){var props=['tel','givenName','familyName'];if(Settings.supportEmailRecipient){props.push('email');}
return this.findBy({filterBy:props,filterOp:'contains',filterValue:filterValue},callback);},findByUnknown:function findByUnknown(filterValue,callback){var list=[];for(var i=0,length=unknownNumbers.length;i<length;i++){if(list.length>2){break;}
var num=unknownNumbers[i];if(num.contains(filterValue)){var obj={name:[num],tel:[{value:num}],source:'unknown'};list.push(obj);}}
callback(list);},findExact:function contacts_findBy(filterValue,callback){return this.findBy({filterBy:['givenName','familyName'],filterOp:'contains',filterValue:filterValue},function(results,meta){var contact=results&&results.length?results[0]:null;var criteria={fields:['name'],terms:[filterValue]};var isExact=false;if(contact){isExact=isMatch(contact,criteria,filterFns.equality);}
callback(isExact?[contact]:[]);});},findByPhoneNumber:function contacts_findByPhone(filterValue,callback){return this.findBy({filterBy:['tel'],filterOp:'match',filterValue:filterValue.replace(/\s+/g,'')},function(results){if(results&&results.length){callback(results);return;}
fb.getContactByNumber(filterValue,function fbByPhone(contact){callback(contact?[contact]:[]);},function error_fbByPhone(err){if(err.name!=='DatastoreNotFound'){console.error('Error while retrieving fb by phone: ',err.name);}
callback(results);});});},findByAddress:function contacts_findByAddress(fValue,callback){if(Settings.supportEmailRecipient&&Utils.isEmailAddress(fValue)){this.findExactByEmail(fValue,callback);}else{this.findByPhoneNumber(fValue,callback);}},findExactByEmail:function contacts_findExactByEmail(fValue,callback){return this.findBy({filterBy:['email'],filterOp:'equals',filterValue:fValue},callback);},addUnknown:function addUnknown(number){var index=unknownNumbers.indexOf(number);if(index===-1){unknownNumbers.push(number);}},clearUnknown:function clearUnknown(){unknownNumbers.length=0;},getunknownLength:function getunknownLength(){return unknownNumbers.length;}};exports.Contacts=Contacts;}(this));;(function(exports){'use strict';var draftIndex=new Map();var deferredDraftRequest=null;var Drafts=exports.Drafts={List:DraftList,get size(){return draftIndex.size;},add:function(draft){var threadId;var thread;var stored;if(draft){if(!(draft instanceof Draft)){draft=new Draft(draft);}
threadId=draft.threadId||null;thread=draftIndex.get(threadId)||[];stored=thread[thread.length-1];if(threadId!==null&&thread.length){this.delete(stored);}
if(threadId===null&&thread.length){thread.some(function(d,i){if(d.id===draft.id){this.delete(d);stored=null;return true;}},this);}
thread.push(draft);draftIndex.set(threadId,thread);this.store();}
return this;},delete:function(draft){var thread;var index;if(draft){thread=draftIndex.get(draft.threadId);if(!thread){return this;}
index=thread.indexOf(draft);if(index===-1){if(thread&&typeof draft.id==='undefined'){thread.length=0;}else{if(thread){thread.some(function(stored,i){if(stored.id===draft.id){index=i;return true;}});}}}
if(index>-1){thread.splice(index,1);}}
return this;},byThreadId:function(id){return new Drafts.List(draftIndex.get(id));},get:function(id){var draft;draftIndex.forEach(function(records,threadId){if(!draft){draft=records.find(function(record){return record.id===+id;});}});return draft;},forEach:function(callback,thisArg){if(thisArg){callback=callback.bind(thisArg);}
draftIndex.forEach(function(drafts,threadId){if(threadId){var latest=drafts[drafts.length-1];callback(latest,threadId);}else{drafts.forEach(function(draft){callback(draft,null);});}});},clear:function(){draftIndex=new Map();deferredDraftRequest=null;return this;},store:function(){var entries=[];draftIndex.forEach(function(v,k){entries.push([k,v]);});asyncStorage.setItem('draft index',entries,()=>{InterInstanceEventDispatcher.emit('drafts-changed');});},request:function(force){if(deferredDraftRequest&&!force){return deferredDraftRequest.promise;}
deferredDraftRequest=Utils.Promise.defer();asyncStorage.getItem('draft index',function(records){records&&records.forEach((record)=>{record[1]=record[1].map((draft)=>new Draft(draft));});draftIndex=new Map(records||[]);deferredDraftRequest.resolve(Drafts.byThreadId(null));});return deferredDraftRequest.promise;}};var priv=new WeakMap();function DraftList(initializer){priv.set(this,initializer||[]);}
DraftList.prototype={get length(){return priv.get(this).length;},get latest(){var list=priv.get(this);return list.length?list[list.length-1]:null;},forEach:function(callback,thisArg){var drafts=priv.get(this);if(thisArg){callback=callback.bind(thisArg);}
for(var i=0;i<drafts.length;i++){callback(drafts[i]);}}};function Draft(opts){var draft=opts||{};if(draft.id&&typeof draft.id!=='number'){throw new Error('Draft id must be a number');}
this.id=draft.id||guid();this.recipients=draft.recipients||[];this.content=draft.content||[];this.subject=draft.subject||'';this.timestamp=+draft.timestamp||Date.now();this.threadId=draft.threadId||null;this.type=draft.type;this.isEdited=false;}
function guid(){return+(Date.now()+''+(Math.random()*1000|0));}
exports.Draft=Draft;}(this));;(function(exports){'use strict';var threads=new Map();function Thread(thread){var length=Thread.FIELDS.length;var key;for(var i=0;i<length;i++){key=Thread.FIELDS[i];this[key]=thread[key];}
this.messages=[];}
Thread.FIELDS=['body','id','lastMessageSubject','lastMessageType','participants','timestamp','unreadCount'];Thread.fromMessage=function(record,options){var participants=[];if(typeof record.delivery!=='undefined'){if(record.delivery==='received'||record.delivery==='not-downloaded'){participants=[record.sender];}else{participants=record.receivers||[record.receiver];}}
return new Thread({id:record.threadId,participants:participants,body:record.body,timestamp:record.timestamp,unreadCount:(options&&options.unread)?1:0,lastMessageType:record.type||'sms'});};Thread.fromDraft=function(record,options){var participants=record.recipients&&record.recipients.length?record.recipients:[''];var body=record.content&&record.content.length?record.content.find(function(content){if(typeof content==='string'){return true;}}):'';return new Thread({id:record.threadId||record.id,participants:participants,body:body,timestamp:new Date(record.timestamp),unreadCount:(options&&options.unread)?1:0,lastMessageType:record.type||'sms'});};Thread.create=function(record,options){if(record instanceof Thread){return record;}
return record.delivery?Thread.fromMessage(record,options):Thread.fromDraft(record,options);};Thread.prototype={constructor:Thread,get drafts(){return Drafts.byThreadId(this.id);},get hasDrafts(){return!!this.drafts.length;}};var Threads=exports.Threads={registerMessage:function(message){var thread=Thread.create(message);var threadId=message.threadId;if(!this.has(threadId)){this.set(threadId,thread);}
this.get(threadId).messages.push(message);},set:function(id,thread){var old,length,key;id=+id;if(threads.has(id)){old=threads.get(id);length=Thread.FIELDS.length;for(var i=0;i<length;i++){key=Thread.FIELDS[i];old[key]=thread[key];}
return threads;}
return threads.set(id,new Thread(thread));},get:function(id){return threads.get(+id);},has:function(id){return threads.has(+id);},delete:function(id){id=+id;var thread=this.get(id);if(thread&&thread.hasDrafts){Drafts.delete({threadId:id});Drafts.store();}
return threads.delete(id);},clear:function(){threads=new Map();},forEach:function(callback){threads.forEach(function(v,k){callback(v,k);});},get size(){if(typeof threads.size==='function'){return+threads.size();}
return+threads.size;},currentId:null,get active(){return threads.get(+Threads.currentId);}};exports.Thread=Thread;}(this));;(function(exports){'use strict';const privateMembers=new WeakMap();function createBdiNode(content){var bdi=document.createElement('bdi');bdi.textContent=content;return bdi;}
var ThreadListUI={draftLinks:null,draftRegistry:null,DRAFT_SAVED_DURATION:5000,FIRST_PANEL_THREAD_COUNT:9,timeouts:{onDraftSaved:null},count:0,inEditMode:false,init:function thlui_init(){this.tmpl={thread:Template('messages-thread-tmpl')};['container','no-messages','read-unread-button','check-uncheck-all-button','composer-link','delete-button','edit-header','options-button','settings-button','edit-mode','edit-form','draft-saved-banner'].forEach(function(id){this[Utils.camelCase(id)]=document.getElementById('threads-'+id);},this);this.mainWrapper=document.getElementById('main-wrapper');this.composerLink.addEventListener('click',this.launchComposer.bind(this));this.readUnreadButton.addEventListener('click',()=>{this.markReadUnread(this.selectionHandler.selectedList,this.readUnreadButton.dataset.action==='mark-as-read');});this.deleteButton.addEventListener('click',()=>{this.delete(this.selectionHandler.selectedList);});this.editHeader.addEventListener('action',this.cancelEdit.bind(this));this.optionsButton.addEventListener('click',this.showOptions.bind(this));this.settingsButton.addEventListener('click',function oSettings(){ActivityPicker.openSettings();});this.container.addEventListener('click',this);this.container.addEventListener('contextmenu',this);this.editForm.addEventListener('submit',this);navigator.mozContacts.addEventListener('contactchange',this.updateContactsInfo.bind(this));this.draftLinks=new Map();ThreadListUI.draftRegistry={};MessageManager.on('message-sending',this.onMessageSending.bind(this));MessageManager.on('message-received',this.onMessageReceived.bind(this));MessageManager.on('threads-deleted',this.onThreadsDeleted.bind(this));InterInstanceEventDispatcher.on('drafts-changed',this.renderDrafts.bind(this,true));privateMembers.set(this,{groupThreadTitleMaxLength:(window.innerWidth-100)/10});this.sticky=null;},initStickyHeader:function thlui_initStickyHeader(){if(!this.sticky){this.sticky=new StickyHeader(this.container,document.getElementById('sticky'));}},beforeLeave:function thlui_beforeLeave(){this.cancelEdit();},getAllInputs:function thlui_getAllInputs(){if(this.container){return Array.prototype.slice.call(this.container.querySelectorAll('input[type=checkbox]'));}else{return[];}},setContact:function thlui_setContact(node){var threadOrDraft=node.classList.contains('is-draft')?Drafts.get(node.dataset.threadId):Threads.get(node.dataset.threadId);if(!threadOrDraft){throw new Error('Thread node is invalid!');}
var threadNumbers=threadOrDraft.participants||threadOrDraft.recipients;var titleContainer=node.querySelector('.threadlist-item-title');var title=titleContainer.firstElementChild;var picture=node.querySelector('.threadlist-item-picture');if(!threadNumbers||!threadNumbers.length){title.setAttribute('data-l10n-id','no-recipient');return;}
function*updateThreadNode(number){var contact=yield ThreadListUI.findContact(number,{photoURL:true});var isContact=!!contact.isContact;picture.classList.toggle('has-picture',isContact);picture.classList.toggle('default-picture',isContact&&!contact.photoURL);title.textContent=contact.title||number;var photoUrl=node.dataset.photoUrl;if(photoUrl){window.URL.revokeObjectURL(photoUrl);}
if(contact.photoURL){node.dataset.photoUrl=contact.photoURL;}else if(photoUrl){node.dataset.photoUrl='';}
if(contact.photoURL){picture.firstElementChild.style.backgroundImage=['url('+contact.photoURL+')','url(style/images/default_contact_image.png)'].join(', ');}else{picture.firstElementChild.style.backgroundImage=null;}}
function*updateGroupThreadNode(numbers,titleMaxLength){var contactTitle,number;var i=0;var threadTitleLength=0;var groupTitle=document.createElement('span');var separatorNode=document.createElement('span');separatorNode.setAttribute('data-l10n-id','thread-participant-separator');picture.firstElementChild.textContent=numbers.length;picture.classList.add('has-picture','group-picture');while(i<numbers.length&&threadTitleLength<titleMaxLength){number=numbers[i++];contactTitle=(yield ThreadListUI.findContact(number)).title||number;if(threadTitleLength>0){groupTitle.appendChild(separatorNode.cloneNode(true));}
groupTitle.appendChild(createBdiNode(contactTitle));threadTitleLength+=contactTitle.length;}
titleContainer.replaceChild(groupTitle,title);}
if(threadNumbers.length===1){return Utils.Promise.async(updateThreadNode)(threadNumbers[0]);}
return Utils.Promise.async(updateGroupThreadNode)(threadNumbers,privateMembers.get(this).groupThreadTitleMaxLength);},findContact:function(number,options){var defer=Utils.Promise.defer();Contacts.findByAddress(number,function(contacts){var details=Utils.getContactDetails(number,contacts,options);if(!details.isContact){Contacts.addUnknown(number);}
defer.resolve(details);});return defer.promise;},handleEvent:function thlui_handleEvent(event){var draftId;var parent=event.target.parentNode;var parentThreadId=parent.dataset.threadId;switch(event.type){case'click':if(this.inEditMode){return;}
if((draftId=this.draftLinks.get(event.target))){ThreadUI.draft=Drafts.get(draftId);}
if(parentThreadId){event.preventDefault();if(parent.classList.contains('is-draft')){Navigation.toPanel('composer',{draftId:+parentThreadId});}else{Navigation.toPanel('thread',{id:+parentThreadId});}}
break;case'contextmenu':if(this.inEditMode||!parentThreadId){return;}
event.preventDefault();event.stopPropagation();var params={type:'action',header:{l10nId:'thread-options'},items:[{l10nId:'delete-thread',method:this.delete.bind(this,[parentThreadId])}]};var thread=Threads.get(+parentThreadId);if(typeof thread!=='undefined'){var isRead=thread.unreadCount>0;var l10nKey=isRead?'mark-as-read':'mark-as-unread';params.items.push({l10nId:l10nKey,method:this.markReadUnread.bind(this,[parentThreadId],isRead)});}
params.items.push({l10nId:'cancel'});var options=new OptionMenu(params);options.show();break;case'submit':event.preventDefault();break;}},launchComposer:function thui_launchComposer(e){e.preventDefault();Navigation.toPanel('composer');},checkInputs:function thlui_checkInputs(){var selected=this.selectionHandler;if(selected.selectedCount===ThreadListUI.allInputs.length){this.checkUncheckAllButton.setAttribute('data-l10n-id','deselect-all');}else{this.checkUncheckAllButton.setAttribute('data-l10n-id','select-all');}
if(selected.selectedCount){this.deleteButton.disabled=false;navigator.mozL10n.setAttributes(this.editMode,'selected-threads',{n:selected.selectedCount});var hasUnreadselected=selected.selectedList.some((id)=>{var thread=Threads.get(id);if(thread&&thread.unreadCount){return thread.unreadCount>0;}
return false;});var allDraft=selected.selectedList.every((id)=>{return(typeof Threads.get(id)==='undefined');});if(allDraft){this.readUnreadButton.disabled=true;}else{if(!hasUnreadselected){this.readUnreadButton.dataset.action='mark-as-unread';}else{this.readUnreadButton.dataset.action='mark-as-read';}
this.readUnreadButton.disabled=false;}}else{this.deleteButton.disabled=true;this.readUnreadButton.disabled=true;navigator.mozL10n.setAttributes(this.editMode,'selectThreads-title');}},markReadUnread:function thlui_markReadUnread(selected,isRead){selected.forEach((id)=>{var thread=Threads.get(id);var markable=thread&&(!thread.hasDrafts||isRead);if(markable){thread.unreadCount=isRead?0:1;this.mark(thread.id,isRead?'read':'unread');MessageManager.markThreadRead(thread.id,isRead);}});this.cancelEdit();},removeThread:function thlui_removeThread(threadId){var li=document.getElementById('thread-'+threadId);var parent,draftId;var photoUrl=li&&li.dataset.photoUrl;if(photoUrl){window.URL.revokeObjectURL(photoUrl);}
if(li){parent=li.parentNode;li.remove();}
if((draftId=this.draftLinks.get(li))){this.draftLinks.delete(li);delete this.draftRegistry[draftId];}
if(parent&&!parent.firstElementChild){parent.previousSibling.remove();parent.remove();this.sticky&&this.sticky.refresh();if(!this.container.querySelector('li')){this.setEmpty(true);}}},delete:function thlui_delete(selected){function performDeletion(){var threadIdsToDelete=[],messageIdsToDelete=[],threadCountToDelete=0;function exitEditMode(){ThreadListUI.cancelEdit();WaitingScreen.hide();}
function onAllThreadMessagesRetrieved(){if(!--threadCountToDelete){MessageManager.deleteMessages(messageIdsToDelete);threadIdsToDelete.forEach(function(threadId){ThreadListUI.deleteThread(threadId);});messageIdsToDelete=threadIdsToDelete=null;exitEditMode();}}
function onThreadMessageRetrieved(message){messageIdsToDelete.push(message.id);return true;}
WaitingScreen.show();threadIdsToDelete=selected.reduce(function(list,value){var threadId=+value;var isDraft=typeof Threads.get(threadId)==='undefined';if(isDraft){Drafts.delete(Drafts.get(threadId));ThreadListUI.removeThread(threadId);}else{list.push(threadId);}
return list;},[]);if(threadIdsToDelete.length!==selected.length){Drafts.store();}
if(!threadIdsToDelete.length){exitEditMode();return;}
threadCountToDelete=threadIdsToDelete.length;threadIdsToDelete.forEach(function(threadId){MessageManager.getMessages({filter:{threadId:threadId},each:onThreadMessageRetrieved,end:onAllThreadMessagesRetrieved});});}
return Utils.confirm({id:'deleteThreads-confirmation-message',args:{n:selected.length}},null,{text:'delete',className:'danger'}).then(performDeletion.bind(this));},setEmpty:function thlui_setEmpty(empty){var panel=document.getElementById('thread-list');panel.classList.toggle('threadlist-is-empty',!!empty);},showOptions:function thlui_options(){var params={items:[{l10nId:'selectThreads-label',method:this.startEdit.bind(this)},{l10nId:'settings',method:function oSettings(){ActivityPicker.openSettings();}},{l10nId:'cancel',incomplete:true}]};new OptionMenu(params).show();},startEdit:function thlui_edit(){function editModeSetup(){this.inEditMode=true;this.selectionHandler.cleanForm();this.mainWrapper.classList.toggle('edit');}
if(!this.selectionHandler){LazyLoader.load('js/selection_handler.js',()=>{this.selectionHandler=new SelectionHandler({container:this.container,checkUncheckAllButton:this.checkUncheckAllButton,checkInputs:this.checkInputs.bind(this),getAllInputs:this.getAllInputs.bind(this),isInEditMode:this.isInEditMode.bind(this)});editModeSetup.call(this);});}else{editModeSetup.call(this);}},isInEditMode:function thlui_isInEditMode(){return this.inEditMode;},cancelEdit:function thlui_cancelEdit(){this.inEditMode=false;this.mainWrapper.classList.remove('edit');},renderDrafts:function thlui_renderDrafts(force){return Drafts.request(force).then(()=>{Drafts.forEach(function(draft,threadId){if(threadId){var el=document.getElementById('thread-'+threadId);if(el){this.updateThread(Threads.get(threadId));}}else{this.setEmpty(false);if(!this.draftRegistry[draft.id]){this.appendThread(Thread.create(draft));}}},this);this.sticky&&this.sticky.refresh();});},prepareRendering:function thlui_prepareRendering(){this.container.innerHTML='';this.renderDrafts();},startRendering:function thlui_startRenderingThreads(){this.setEmpty(false);},finalizeRendering:function thlui_finalizeRendering(empty){if(empty){this.setEmpty(true);}
if(!empty){TimeHeaders.updateAll('header[data-time-update]');}
this.sticky&&this.sticky.refresh();},ensureReadAheadSetting:function thlui_ensureReadAheadSettting(){Settings.setReadAheadThreadRetrieval(this.FIRST_PANEL_THREAD_COUNT);},renderThreads:function thlui_renderThreads(firstViewDoneCb,allDoneCb){window.performance.mark('willRenderThreads');PerformanceTestingHelper.dispatch('will-render-threads');var hasThreads=false;var firstPanelCount=this.FIRST_PANEL_THREAD_COUNT;this.prepareRendering();var firstViewDone=function firstViewDone(){this.initStickyHeader();if(typeof firstViewDoneCb==='function'){firstViewDoneCb();}}.bind(this);function onRenderThread(thread){Threads.set(thread.id,thread);if(Navigation.isCurrentPanel('thread',{id:thread.id})){ThreadUI.updateHeaderData();}
if(!hasThreads){hasThreads=true;this.startRendering();}
this.appendThread(thread);if(--firstPanelCount===0){window.performance.mark('visuallyLoaded');window.dispatchEvent(new CustomEvent('moz-app-visually-complete'));firstViewDone();}}
function onThreadsRendered(){this.finalizeRendering(!(hasThreads||Drafts.size));if(firstPanelCount>0){window.performance.mark('visuallyLoaded');window.dispatchEvent(new CustomEvent('moz-app-visually-complete'));firstViewDone();}}
function onDone(){this.ensureReadAheadSetting();allDoneCb&&allDoneCb();}
var renderingOptions={each:onRenderThread.bind(this),end:onThreadsRendered.bind(this),done:onDone.bind(this)};MessageManager.getThreads(renderingOptions);},createThread:function thlui_createThread(record){var li=document.createElement('li');var timestamp=+record.timestamp;var type=record.lastMessageType;var participants=record.participants;var number=participants[0];var id=record.id;var bodyHTML=record.body;var thread=Threads.get(id);var draft,draftId;var iconLabel='';var isDraft=typeof thread==='undefined';var hasDrafts=isDraft?false:thread.hasDrafts;if(hasDrafts){draft=Drafts.byThreadId(thread.id).latest;timestamp=Math.max(draft.timestamp,timestamp);if(draft.timestamp>=record.timestamp){bodyHTML=draft.content.find(function(content){if(typeof content==='string'){return true;}});type=draft.type;}}
bodyHTML=Template.escape(bodyHTML||'');li.id='thread-'+id;li.dataset.threadId=id;li.dataset.time=timestamp;li.dataset.lastMessageType=type;li.classList.add('threadlist-item');if(hasDrafts||isDraft){li.classList.add('draft');if(hasDrafts){li.classList.add('has-draft');iconLabel='has-draft';}else{li.classList.add('is-draft');iconLabel='is-draft';}
draftId=hasDrafts?draft.id:record.id;this.draftRegistry[draftId]=true;}
if(record.unreadCount>0){li.classList.add('unread');iconLabel='unread-thread';}
li.innerHTML=this.tmpl.thread.interpolate({hash:isDraft?'#composer':'#thread='+id,mode:isDraft?'drafts':'threads',id:isDraft?draftId:id,number:number,bodyHTML:bodyHTML,timestamp:String(timestamp),iconLabel:iconLabel},{safe:['id','bodyHTML']});TimeHeaders.update(li.querySelector('time'));if(draftId){this.draftLinks.set(li.querySelector('a'),draftId);}
return li;},deleteThread:function(threadId){Threads.delete(threadId);this.removeThread(threadId);Utils.closeNotificationsForThread(threadId);},insertThreadContainer:function thlui_insertThreadContainer(group,timestamp){var headers=ThreadListUI.container.getElementsByTagName('header');var groupFound=false;for(var i=0;i<headers.length;i++){if(timestamp>=headers[i].dataset.time){groupFound=true;ThreadListUI.container.insertBefore(group,headers[i].parentNode);break;}}
if(!groupFound){ThreadListUI.container.appendChild(group);}},updateThread:function thlui_updateThread(record,options){var thread=Thread.create(record,options);var threadUINode=document.getElementById('thread-'+thread.id);var threadUITime=threadUINode?+threadUINode.dataset.time:NaN;var recordTime=+thread.timestamp;if(Threads.has(thread.id)){Threads.set(thread.id,thread);}
var newMessageReceived=options&&options.unread;if(newMessageReceived&&threadUITime>recordTime){this.mark(thread.id,'unread');return;}
var messagesDeleted=options&&options.deleted;if(messagesDeleted&&threadUITime===recordTime){return;}
if(threadUINode){this.removeThread(thread.id);}
this.setEmpty(false);if(this.appendThread(thread)){this.sticky&&this.sticky.refresh();}},onMessageSending:function thlui_onMessageSending(e){this.updateThread(e.message);},onMessageReceived:function thlui_onMessageReceived(e){var markAsRead=Navigation.isCurrentPanel('thread',{id:e.message.threadId});this.updateThread(e.message,{unread:!markAsRead});},onThreadsDeleted:function thlui_onThreadDeleted(e){e.ids.forEach(function(threadId){if(Threads.has(threadId)){this.deleteThread(threadId);}},this);},appendThread:function thlui_appendThread(thread){if(navigator.mozL10n.readyState!=='complete'){navigator.mozL10n.once(this.appendThread.bind(this,thread));return;}
var timestamp=+thread.timestamp;var drafts=Drafts.byThreadId(thread.id);var firstThreadInContainer=false;if(drafts.length){timestamp=Math.max(drafts.latest.timestamp,timestamp);}
var node=this.createThread(thread);this.setContact(node);var threadsContainerID='threadsContainer_'+
Utils.getDayDate(timestamp);var threadsContainer=document.getElementById(threadsContainerID);if(!threadsContainer){var threadsContainerWrapper=ThreadListUI.createThreadContainer(timestamp);threadsContainer=threadsContainerWrapper.childNodes[1];ThreadListUI.insertThreadContainer(threadsContainerWrapper,timestamp);firstThreadInContainer=true;}
var threads=threadsContainer.getElementsByTagName('li');var threadFound=false;for(var i=0,l=threads.length;i<l;i++){if(timestamp>threads[i].dataset.time){threadFound=true;threadsContainer.insertBefore(node,threads[i]);break;}}
if(!threadFound){threadsContainer.appendChild(node);}
if(this.inEditMode){this.selectionHandler.unselect(thread.id);this.checkInputs();}
return firstThreadInContainer;},createThreadContainer:function thlui_createThreadContainer(timestamp){var threadContainer=document.createElement('div');var headerDOM=document.createElement('header');headerDOM.id='header_'+timestamp;headerDOM.dataset.timeUpdate='repeat';headerDOM.dataset.time=timestamp;headerDOM.dataset.dateOnly=true;var threadsContainerDOM=document.createElement('ul');threadsContainerDOM.id='threadsContainer_'+
Utils.getDayDate(timestamp);headerDOM.innerHTML=Utils.getHeaderDate(timestamp);threadContainer.appendChild(headerDOM);threadContainer.appendChild(threadsContainerDOM);return threadContainer;},updateContactsInfo:function thlui_updateContactsInfo(){Contacts.clearUnknown();if(!this.container){return;}
var threads=this.container.getElementsByTagName('li');[].forEach.call(threads,this.setContact.bind(this));},mark:function thlui_mark(id,current){var li=document.getElementById('thread-'+id);var remove='read';if(current==='read'){remove='unread';}
if(li){li.classList.remove(remove);li.classList.add(current);}},onDraftSaved:function thlui_onDraftSaved(){this.draftSavedBanner.classList.remove('hide');clearTimeout(this.timeouts.onDraftSaved);this.timeouts.onDraftSaved=null;this.timeouts.onDraftSaved=setTimeout(function hideDraftSavedBanner(){this.draftSavedBanner.classList.add('hide');}.bind(this),this.DRAFT_SAVED_DURATION);}};Object.defineProperty(ThreadListUI,'allInputs',{get:function(){return this.getAllInputs();}});exports.ThreadListUI=ThreadListUI;}(this));;(function(exports){'use strict';var rdashes=/-(.)/g;var rescape=/[.?*+^$[\]\\(){}|-]/g;var rparams=/([^?=&]+)(?:=([^&]*))?/g;var rnondialablechars=/[^,#+\*\d]/g;var rmail=/[\w-]+@[\w\-]/;var Utils={date:{shared:new Date(),get format(){delete Utils.date.format;return(Utils.date.format=new navigator.mozL10n.DateTimeFormat());}},escapeRegex:function ut_escapeRegex(str){if(typeof str!=='string'){return'';}
return str.replace(rescape,'\\$&');},getFormattedHour:function ut_getFormattedHour(time){this.date.shared.setTime(+time);return this.date.format.localeFormat(this.date.shared,navigator.mozL10n.get(navigator.mozHour12?'shortTimeFormat12':'shortTimeFormat24'));},getDayDate:function re_getDayDate(time){this.date.shared.setTime(+time);this.date.shared.setHours(0,0,0,0);return this.date.shared.getTime();},getHeaderDate:function ut_giveHeaderDate(time){var _=navigator.mozL10n.get;var today=Utils.getDayDate(Date.now());var otherDay=Utils.getDayDate(time);var dayDiff=(today-otherDay)/86400000;this.date.shared.setTime(+time);if(isNaN(dayDiff)){return _('incorrectDate');}
if(dayDiff<0){return this.date.format.localeFormat(this.date.shared,'%x');}
return dayDiff===0&&_('today')||dayDiff===1&&_('yesterday')||dayDiff<6&&this.date.format.localeFormat(this.date.shared,'%A')||this.date.format.localeFormat(this.date.shared,'%x');},getContactDetails:function ut_getContactDetails(number,contacts,include){var details={};include=include||{};function updateDetails(contact){var name,phone,i,length,subscriber,org;name=contact.name[0];org=contact.org&&contact.org[0];length=contact.tel?contact.tel.length:0;subscriber=number.length>7?number.substr(-8):number;for(i=0;i<length;i++){if(contact.tel[i].value.indexOf(subscriber)!==-1){phone=contact.tel[i];break;}}
details.isContact=true;if(include.photoURL){var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){details.photoURL=window.URL.createObjectURL(photo);}}
details.name=name;details.org=details.org||org;}
if(!contacts||(Array.isArray(contacts)&&contacts.length===0)){details.title='';}else if(!Array.isArray(contacts)){updateDetails(contacts);details.title=details.name||details.org;}else{for(var i=0,l=contacts.length;i<l;i++){updateDetails(contacts[i]);if(details.name){break;}}
details.title=details.name||details.org;}
return details;},getPhoneDetails:function ut_getPhoneDetails(input,tels){var length=tels.length;var hasUniqueCarriers=true;var hasUniqueTypes=true;var found,tel,type,carrier;for(var i=0;i<length;i++){tel=tels[i];if(tel.value&&Utils.probablyMatches(tel.value,input)){found=tel;}
if(carrier&&carrier===tel.carrier){hasUniqueCarriers=false;}
if(type&&type===tel.type[0]){hasUniqueTypes=false;}
carrier=tel.carrier;type=(tel.type&&tel.type[0])||'';}
if(!found){return null;}
return{type:(found.type&&found.type[0])||null,carrier:hasUniqueCarriers||hasUniqueTypes?found.carrier:null,number:found.value};},removeNonDialables:function ut_removeNonDialables(input){return input.replace(rnondialablechars,'');},probablyMatches:function ut_probablyMatches(a,b){var service=navigator.mozPhoneNumberService;if(typeof a!=='string'||typeof b!=='string'){return false;}
if(Settings.supportEmailRecipient&&Utils.isEmailAddress(a)&&Utils.isEmailAddress(b)){return a===b;}
if(service&&service.normalize){a=service.normalize(a);b=service.normalize(b);}else{a=Utils.removeNonDialables(a);b=Utils.removeNonDialables(b);}
return a===b||a.slice(-7)===b.slice(-7);},multiRecipientMatch:function ut_multiRecipientMatch(a,b){a=[].concat(a);b=[].concat(b);var blen=b.length;if(a.length!==blen){return false;}
return a.every(function(number){for(var i=0;i<blen;i++){if(Utils.probablyMatches(number,b[i])){return true;}}});},getResizedImgBlob:function ut_getResizedImgBlob(blob,limit,callback){var defaultLimit=295*1024;if(typeof limit==='function'){callback=limit;limit=defaultLimit;}
limit=limit===0?defaultLimit:Math.min(limit,defaultLimit);if(blob.size<limit){setTimeout(function blobCb(){callback(blob);});return;}
var ratio=Math.sqrt(blob.size/limit);Utils._resizeImageBlobWithRatio({blob:blob,limit:limit,ratio:ratio,callback:callback});},getSizeForL10n:function ut_getSizeForL10n(size){var sizeKB=size/1024;var sizeMB=sizeKB/1024;if(size<1000){return{l10nId:'attachmentSizeB',l10nArgs:{n:size}};}else if(sizeKB<1000){return{l10nId:'attachmentSizeKB',l10nArgs:{n:sizeKB.toFixed(1)}};}
return{l10nId:'attachmentSizeMB',l10nArgs:{n:sizeMB.toFixed(1)}};},_resizeImageBlobWithRatio:function ut_resizeImageBlobWithRatio(obj){var blob=obj.blob;var callback=obj.callback;var limit=obj.limit;var ratio=Math.ceil(obj.ratio);var qualities=[0.65,0.5,0.25];var sampleSize=1;var sampleSizeHash='';if(blob.size<limit||ratio<=1){setTimeout(function blobCb(){callback(blob);});return;}
if(blob.type==='image/jpeg'){if(ratio>=8){sampleSize=8;}else{sampleSize=ratio=Utils.getClosestSampleSize(ratio);}
sampleSizeHash='#-moz-samplesize='+sampleSize;}
var img=document.createElement('img');var url=window.URL.createObjectURL(blob);img.src=url+sampleSizeHash;img.onload=function onBlobLoaded(){window.URL.revokeObjectURL(url);var targetWidth=img.width*sampleSize/ratio;var targetHeight=img.height*sampleSize/ratio;var canvas=document.createElement('canvas');canvas.width=targetWidth;canvas.height=targetHeight;var context=canvas.getContext('2d',{willReadFrequently:true});context.drawImage(img,0,0,targetWidth,targetHeight);img.src='';var level=0;function cleanup(){canvas.width=canvas.height=0;canvas=null;}
function ensureSizeLimit(resizedBlob){if(resizedBlob.size<limit){cleanup();setTimeout(callback.bind(null,resizedBlob));}else{resizedBlob=null;if(level<qualities.length){canvas.toBlob(ensureSizeLimit,'image/jpeg',qualities[level++]);}else{cleanup();setTimeout(Utils._resizeImageBlobWithRatio.bind(Utils,{blob:blob,limit:limit,ratio:ratio*2,callback:callback}));}}}
canvas.toBlob(ensureSizeLimit,blob.type);};},getClosestSampleSize:function ut_getClosestSampleSize(ratio){if(ratio>=8){return 8;}
if(ratio>=4){return 4;}
if(ratio>=2){return 2;}
return 1;},camelCase:function ut_camelCase(str){return str.replace(rdashes,function replacer(str,p1){return p1.toUpperCase();});},typeFromMimeType:function ut_typeFromMimeType(mime){var MAX_MIME_TYPE_LENGTH=256;if(typeof mime!=='string'||mime.length>MAX_MIME_TYPE_LENGTH){return null;}
var index=mime.indexOf('/');if(index===-1){return null;}
var mainPart=mime.slice(0,index);var secondPart=mime.substr(index+1).toLowerCase();switch(mainPart){case'image':return'img';case'text':if(secondPart.indexOf('vcard')!==-1){return'vcard';}
if(secondPart!=='plain'){return'ref';}
return mainPart;case'video':case'audio':case'application':return mainPart;default:return null;}},params:function(input){var parsed={};input.replace(rparams,function($0,$1,$2){parsed[$1]=$2;});return parsed;},getContactDisplayInfo:function(resolver,phoneNumber,callback){resolver(phoneNumber,function onContacts(contacts){callback(Utils.basicContact(phoneNumber,contacts));});},basicContact:function(number,records,callback){var record;if(Array.isArray(records)){if(records.length>0){record=records[0];}}else if(records!==null){record=records;}
if(!record&&!number){if(typeof callback==='function'){callback(null);}
return;}
var telLength=(record&&record.tel)?record.tel.length:0;var tel;for(var i=0;i<telLength;i++){if(record.tel[i].value===number){tel=record.tel[i];break;}}
if(!tel){tel={type:[''],value:number,carrier:''};}
var details=Utils.getContactDetails(tel,record);var info=Utils.getDisplayObject(details.title||null,tel);return info;},getDisplayObject:function(theTitle,tel){var number=tel.value;var type=tel.type&&tel.type.length?tel.type[0]:'';var data={name:theTitle||number,number:number,type:type,carrier:tel.carrier||''};if(Settings.supportEmailRecipient){data.email=number;data.emailHTML='';}
return data;},asyncLoadRevokeURL:function(url){setTimeout(function(){var image=new Image();image.src=url;image.onload=image.onerror=function revokePhotoURL(){window.URL.revokeObjectURL(this.src);};});},isEmailAddress:function(email){return rmail.test(email);},closeNotificationsForThread:function ut_closeNotificationsForThread(tid){var threadId=tid?tid:Threads.currentId;if(!threadId){return;}
var targetTag='threadId:'+threadId;return Notification.get({tag:targetTag}).then(function onSuccess(notifications){for(var i=0;i<notifications.length;i++){notifications[i].close();}}).catch(function onError(reason){console.error('Notification.get(tag: '+targetTag+'): ',reason);});},debounce:function(func,waitTime){var timeout,args,context;var executeLater=function(){func.apply(context,args);timeout=context=args=null;};return function(){context=this;args=arguments;if(timeout){clearTimeout(timeout);}
timeout=setTimeout(executeLater,waitTime);};},alert:function(message,title){var deferred=this.Promise.defer();var dialog=new Dialog({title:title||'modal-dialog-default-title',body:message,options:{cancel:{text:'modal-dialog-ok-button',method:deferred.resolve}}});dialog.show();return deferred.promise;},confirm:function(message,title,confirmOptions){var confirmButtonText=confirmOptions&&confirmOptions.text||'modal-dialog-ok-button';var confirmButtonClassName=confirmOptions&&confirmOptions.className||'recommend';var deferred=this.Promise.defer();var dialog=new Dialog({title:title||'modal-dialog-default-title',body:message,options:{cancel:{text:'modal-dialog-cancel-button',method:deferred.reject},confirm:{text:confirmButtonText,className:confirmButtonClassName,method:deferred.resolve}}});dialog.show();return deferred.promise;},Promise:{defer:function(){var deferred={};deferred.promise=new Promise(function(resolve,reject){deferred.resolve=resolve;deferred.reject=reject;});return deferred;},async:function(generatorFunction){return function asyncGenerator(){var generator=generatorFunction.apply(this,arguments);function handle(result){if(result.done){return Promise.resolve(result.value);}
return Promise.resolve(result.value).then((result)=>handle(generator.next(result)),(error)=>handle(generator.throw(error)));}
try{return handle(generator.next());}catch(error){return Promise.reject(error);}};}}};exports.Utils=Utils;}(this));;'use strict';var Settings={SERVICE_ID_KEYS:{mmsServiceId:'ril.mms.defaultServiceId',smsServiceId:'ril.sms.defaultServiceId'},READ_AHEAD_THREADS_KEY:'ril.sms.maxReadAheadEntries',MMS_SIZE_OVERHEAD:5*1024,_serviceIds:null,supportEmailRecipient:true,maxConcatenatedMessages:10,mmsSizeLimitation:295*1024,mmsServiceId:null,smsServiceId:null,init:function settings_init(){var keyHandlerSet={'dom.mms.operatorSizeLimitation':this.initMmsSizeLimitation.bind(this),'operatorResource.sms.maxConcat':this.initSmsMaxConcatenatedMsg.bind(this)};var settings=navigator.mozSettings;var conns=navigator.mozMobileConnections;function setHandlerMap(key){var req=settings.createLock().get(key);req.onsuccess=function settings_getSizeSuccess(){var handler=keyHandlerSet[key];handler(req.result[key]);};}
this._serviceIds=[];if(!settings){return;}
if(conns&&conns.length>1){for(var prop in this.SERVICE_ID_KEYS){var setting=this.SERVICE_ID_KEYS[prop];keyHandlerSet[setting]=this.initServiceId.bind(this,setting,prop);}
for(var i=0,l=conns.length;i<l;i++){this._serviceIds.push(conns[i].iccId);}}
for(var key in keyHandlerSet){setHandlerMap(key);}},initSmsMaxConcatenatedMsg:function initSmsMaxConcatenatedMsg(num){if(num&&!isNaN(num)){this.maxConcatenatedMessages=num;}},initMmsSizeLimitation:function initMmsSizeLimitation(size){if(size&&!isNaN(size)){this.mmsSizeLimitation=size-this.MMS_SIZE_OVERHEAD;}},initServiceId:function initMmsServiceId(settingName,propName,id){if(id!==undefined){Settings[propName]=id;}
navigator.mozSettings.addObserver(settingName,function(e){Settings[propName]=e.settingValue;});},setMmsSimServiceId:function setSimServiceId(id){navigator.mozSettings.createLock().set({'ril.mms.defaultServiceId':id,'ril.data.defaultServiceId':id});},switchMmsSimHandler:function switchSimHandler(targetId){var conn=window.navigator.mozMobileConnections[targetId];return new Promise(function(resolve,reject){if(conn){if(conn.data.state==='registered'){resolve();}else{conn.addEventListener('datachange',function onDataChange(){if(conn.data.state==='registered'){conn.removeEventListener('datachange',onDataChange);resolve();}});this.setMmsSimServiceId(targetId);}}else{reject('Invalid connection');}}.bind(this));},isDualSimDevice:function isDualSimDevice(){return this._serviceIds&&this._serviceIds.length>1;},hasSeveralSim:function hasSeveralSim(){if(!this.isDualSimDevice()){return false;}
var simCount=this._serviceIds.reduce(function(simCount,iccId){return iccId===null?simCount:simCount+1;},0);return simCount>1;},getServiceIdByIccId:function getServiceIdByIccId(iccId){if(!this._serviceIds){return null;}
var index=this._serviceIds.indexOf(iccId);return index>-1?index:null;},getSimNameByIccId:function getSimNameByIccId(iccId){var index=this.getServiceIdByIccId(iccId);if(index===null){return'';}
var simName=navigator.mozL10n.get('sim-id-label',{id:index+1});return simName;},getOperatorByIccId:function getOperatorByIccId(iccId){var index=this.getServiceIdByIccId(iccId);if(index===null){return'';}
var conn=navigator.mozMobileConnections[index];return MobileOperator.userFacingInfo(conn).operator;},setReadAheadThreadRetrieval:function(value){if(!navigator.mozSettings){return;}
var setting={};setting[this.READ_AHEAD_THREADS_KEY]=value;navigator.mozSettings.createLock().set(setting);}};;'use strict';(function(exports){var MessageManager={init:function mm_init(){this._mozMobileMessage=navigator.mozMobileMessage;this._mozMobileMessage.addEventListener('received',this.onMessageReceived.bind(this));this._mozMobileMessage.addEventListener('sending',this.onMessageSending.bind(this));this._mozMobileMessage.addEventListener('sent',this.onMessageSent.bind(this));this._mozMobileMessage.addEventListener('failed',this.onMessageFailed.bind(this));this._mozMobileMessage.addEventListener('readsuccess',this.onReadSuccess.bind(this));this._mozMobileMessage.addEventListener('deliverysuccess',this.onDeliverySuccess.bind(this));this._mozMobileMessage.addEventListener('deleted',this.onDeleted.bind(this));},onMessageSending:function mm_onMessageSending(e){Threads.registerMessage(e.message);this.emit('message-sending',{message:e.message});},onMessageFailed:function mm_onMessageFailed(e){this.emit('message-failed-to-send',{message:e.message});},onDeliverySuccess:function mm_onDeliverySuccess(e){this.emit('message-delivered',{message:e.message});},onReadSuccess:function mm_onReadSuccess(e){this.emit('message-read',{message:e.message});},onMessageSent:function mm_onMessageSent(e){this.emit('message-sent',{message:e.message});},onMessageReceived:function mm_onMessageReceived(e){var message=e.message;if(message.messageClass&&message.messageClass==='class-0'){return;}
if(message.delivery==='not-downloaded'&&message.deliveryInfo[0].deliveryStatus==='pending'){return;}
Threads.registerMessage(message);this.emit('message-received',{message:message});},onDeleted:function(e){if(e.deletedThreadIds&&e.deletedThreadIds.length){this.emit('threads-deleted',{ids:e.deletedThreadIds});}},getThreads:function mm_getThreads(options){var each=options.each;var end=options.end;var done=options.done;var cursor=null;try{cursor=this._mozMobileMessage.getThreads();}catch(e){console.error('Error occurred while retrieving threads: '+e.name);end&&end();done&&done();return;}
cursor.onsuccess=function onsuccess(){if(this.result){each&&each(this.result);this.continue();return;}
end&&end();done&&done();};cursor.onerror=function onerror(){console.error('Reading the database. Error: '+this.error.name);done&&done();};},getMessage:function mm_getMsg(id){return this._mozMobileMessage.getMessage(id);},retrieveMMS:function mm_retrieveMMS(id){return this._mozMobileMessage.retrieveMMS(id);},getMessages:function mm_getMgs(options){var each=options.each;var invert=options.invert;var end=options.end;var endArgs=options.endArgs;var done=options.done;var filter=options.filter;var cursor=this._mozMobileMessage.getMessages(filter,!invert);cursor.onsuccess=function onsuccess(){if(!this.done){var shouldContinue=true;if(each){shouldContinue=each(this.result);}
if(shouldContinue!==false){this.continue();}else{done&&done();}}else{end&&end(endArgs);done&&done();}};cursor.onerror=function onerror(){var msg='Reading the database. Error: '+this.error.name;console.log(msg);done&&done();};},_sanitizeServiceId:function mm_sanitizeServiceId(serviceId){if(serviceId==null||isNaN(+serviceId)){serviceId=null;}else{serviceId=+serviceId;}
return serviceId;},_getSendOptionsFromServiceId:function mm_gSOFSI(serviceId){var sendOpts;if(serviceId!=null&&Settings.hasSeveralSim()){sendOpts={serviceId:serviceId};}
return sendOpts;},sendSMS:function mm_send(opts){var recipients=opts.recipients||[],content=opts.content,serviceId=this._sanitizeServiceId(opts.serviceId),onsuccess=opts.onsuccess,onerror=opts.onerror,oncomplete=opts.oncomplete;if(!Array.isArray(recipients)){recipients=[recipients];}
var i=0;var requestResult={hasError:false,return:[]};var sendOpts=this._getSendOptionsFromServiceId(serviceId);var requests=this._mozMobileMessage.send(recipients,content,sendOpts);var numberOfRequests=requests.length;requests.forEach(function(request,idx){request.onsuccess=function onSuccess(event){onsuccess&&onsuccess(event.target.result);requestResult.return.push({success:true,result:event.target.result,recipient:recipients[idx]});if(i===numberOfRequests-1){oncomplete&&oncomplete(requestResult);}
i++;};request.onerror=function onError(event){console.error('Error Sending: '+JSON.stringify(event.target.error));onerror&&onerror(event.target.error);requestResult.hasError=true;requestResult.return.push({success:false,code:event.target.error,recipient:recipients[idx]});if(i===numberOfRequests-1){oncomplete&&oncomplete(requestResult);}
i++;};});},sendMMS:function mm_sendMMS(opts){var request;var recipients=opts.recipients,subject=opts.subject,content=opts.content,serviceId=opts.serviceId=this._sanitizeServiceId(opts.serviceId),onsuccess=opts.onsuccess,onerror=opts.onerror;if(!Array.isArray(recipients)){recipients=[recipients];}
var message=SMIL.generate(content);var sendOpts=this._getSendOptionsFromServiceId(serviceId);request=this._mozMobileMessage.sendMMS({receivers:recipients,subject:subject,smil:message.smil,attachments:message.attachments},sendOpts);request.onsuccess=function onSuccess(event){onsuccess&&onsuccess(event.target.result);};request.onerror=function onError(event){onerror&&onerror(event.target.error);};},resendMessage:function mm_resendMessage(opts){var message=opts.message;if(!message){throw new Error('Message to resend is not defined.');}
var serviceId=Settings.getServiceIdByIccId(message.iccId);var sendOpts=this._getSendOptionsFromServiceId(serviceId);var onsuccess=opts.onsuccess;var onerror=opts.onerror;var request;if(message.type==='sms'){request=this._mozMobileMessage.send(message.receiver,message.body,sendOpts);}
if(message.type==='mms'){request=this._mozMobileMessage.sendMMS({receivers:message.receivers,subject:message.subject,smil:message.smil,attachments:message.attachments},sendOpts);}
request.onsuccess=function onSuccess(evt){MessageManager.deleteMessages(message.id);onsuccess&&onsuccess(evt.target.result);};request.onerror=function onError(evt){MessageManager.deleteMessages(message.id);onerror&&onerror(evt.target.error);};},deleteMessages:function mm_deleteMessages(id,callback){var req=this._mozMobileMessage.delete(id);req.onsuccess=function onsuccess(){callback&&callback(this.result);};req.onerror=function onerror(){var msg='Deleting in the database. Error: '+req.error.name;console.log(msg);callback&&callback(null);};},markThreadRead:function mm_markThreadRead(threadId,isRead=true){var filter={};filter.threadId=+threadId;filter.read=!isRead;var messagesUnreadIDs=[];var changeStatusOptions={each:function addUnreadMessage(message){messagesUnreadIDs.push(message.id);return true;},filter:filter,invert:true,end:function handleUnread(){MessageManager.markMessagesRead(messagesUnreadIDs,isRead);}};MessageManager.getMessages(changeStatusOptions);},markMessagesRead:function mm_markMessagesRead(list,isRead=true){if(!this._mozMobileMessage||!list.length){return;}
var id=list.pop();var req=this._mozMobileMessage.markMessageRead(id,isRead,true);req.onsuccess=(function onsuccess(){if(!list.length||!isRead){return;}else if(isRead){this.markMessagesRead(list,isRead);}}).bind(this);req.onerror=function onerror(){console.error('Error while marking message %d as read: %s',id,this.error.name);};},getSegmentInfo:function mm_getSegmentInfo(text){if(!(this._mozMobileMessage&&this._mozMobileMessage.getSegmentInfoForText)){return Promise.reject(new Error('mozMobileMessage is unavailable.'));}
var defer=Utils.Promise.defer();var request=this._mozMobileMessage.getSegmentInfoForText(text);request.onsuccess=function onsuccess(e){defer.resolve(e.target.result);};request.onerror=function onerror(e){defer.reject(e.target.error);};return defer.promise;},_isMessageBelongTo1to1Conversation:function isMessageBelongTo1to1Conversation(number,message){var isIncoming=message.delivery==='received'||message.delivery==='not-downloaded';if(isIncoming){return Utils.probablyMatches(message.sender,number);}else{switch(message.type){case'sms':return Utils.probablyMatches(message.receiver,number);case'mms':return message.receivers.length===1&&Utils.probablyMatches(message.receivers[0],number);default:console.error('Got an unknown message type: '+message.type);return false;}}},findThreadFromNumber:function mm_findThread(number){function checkCandidate(message){var isMessageInThread=MessageManager._isMessageBelongTo1to1Conversation(number,message);if(isMessageInThread){threadId=message.threadId;Threads.registerMessage(message);return false;}}
var threadId=null;var deferred=Utils.Promise.defer();MessageManager.getMessages({filter:{numbers:[number]},each:checkCandidate,done:function(){if(threadId==null){deferred.reject(new Error('No thread found for number: '+number));return;}else{deferred.resolve(threadId);return;}}});return deferred.promise;}};Object.defineProperty(exports,'MessageManager',{get:function(){delete exports.MessageManager;exports.MessageManager=EventDispatcher.mixin(MessageManager,['message-sending','message-failed-to-send','message-delivered','message-read','message-sent','message-received','threads-deleted']);return exports.MessageManager;},configurable:true,enumerable:true});})(window);;(function(exports){'use strict';const APPLICATION_READY_CLASS_NAME='js-app-ready';var app={isReady:function app_isReady(){return document.body.classList.contains(APPLICATION_READY_CLASS_NAME);},setReady:function app_setReady(){if(this.isReady()){throw new Error('Application should be marked as ready only once!');}
document.body.classList.add(APPLICATION_READY_CLASS_NAME);if(navigator.mozAudioChannelManager){navigator.mozAudioChannelManager.volumeControlChannel='notification';}},whenReady:function whenReady(){if(this.isReady()){return Promise.resolve();}
return new Promise(function(resolve,reject){var bodyClassObserver=new MutationObserver(function(){try{if(this.isReady()){bodyClassObserver.disconnect();resolve();}}catch(e){reject(e);}}.bind(this));bodyClassObserver.observe(document.body,{attributes:true,attributeFilter:['class']});}.bind(this));}};exports.App=app;})(this);;'use strict';var Startup={_lazyLoadScripts:['/shared/js/settings_listener.js','/shared/js/mime_mapper.js','/shared/js/notification_helper.js','/shared/js/option_menu.js','/shared/js/gesture_detector.js','/shared/js/settings_url.js','/shared/js/mobile_operator.js','/shared/js/multi_sim_action_button.js','/shared/js/image_utils.js','/shared/elements/gaia_sim_picker/script.js','js/waiting_screen.js','js/errors.js','js/dialog.js','js/error_dialog.js','js/link_helper.js','js/link_action_handler.js','js/contact_renderer.js','js/activity_picker.js','js/information.js','js/shared_components.js','js/task_runner.js','js/silent_sms.js','js/recipients.js','js/attachment.js','js/attachment_renderer.js','js/attachment_menu.js','js/thread_ui.js','js/subject_composer.js','js/compose.js','js/wbmp.js','js/smil.js','js/notify.js','js/activity_handler.js','js/localization_helper.js'],_lazyLoadInit:function(){var lazyLoadPromise=LazyLoader.load(this._lazyLoadScripts).then(()=>{LocalizationHelper.init();InterInstanceEventDispatcher.connect();SilentSms.init();ActivityHandler.init();TimeHeaders.init();ThreadUI.init();Information.initDefaultViews();Startup.emit('post-initialize');window.performance.mark('contentInteractive');window.dispatchEvent(new CustomEvent('moz-content-interactive'));Settings.init();window.performance.mark('objectsInitEnd');PerformanceTestingHelper.dispatch('objects-init-finished');});this._initHeaders();return lazyLoadPromise;},_initHeaders:function(){var headers=document.querySelectorAll('gaia-header[no-font-fit]');for(var i=0,l=headers.length;i<l;i++){headers[i].removeAttribute('no-font-fit');}},init:function(){function initializeDefaultPanel(firstPageLoadedCallback){Navigation.off('navigated',initializeDefaultPanel);ThreadListUI.init();ThreadListUI.renderThreads(firstPageLoadedCallback,function(){window.performance.mark('fullyLoaded');window.dispatchEvent(new CustomEvent('moz-app-loaded'));App.setReady();});}
var loaded=function(){window.removeEventListener('DOMContentLoaded',loaded);window.performance.mark('navigationLoaded');window.dispatchEvent(new CustomEvent('moz-chrome-dom-loaded'));MessageManager.init();Navigation.init();var panelName=Navigation.getPanelName();if(panelName&&panelName!=='thread-list'){Navigation.on('navigated',initializeDefaultPanel);this._lazyLoadInit();}else{initializeDefaultPanel(this._lazyLoadInit.bind(this));}
window.performance.mark('navigationInteractive');window.dispatchEvent(new CustomEvent('moz-chrome-interactive'));}.bind(this);window.addEventListener('DOMContentLoaded',loaded);}};EventDispatcher.mixin(Startup).init();