;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;'use strict';(function(){var loader=LazyLoader;window.LazyL10n={_baseLoaded:false,_ready:false,get:function ll10n_get(callback){if(this._ready){callback(navigator.mozL10n.get);return;}
var loadDateAndFinalize=this._loadDateAndFinalize.bind(this,callback);if(this._baseLoaded){navigator.mozL10n.once(loadDateAndFinalize);return;}
loader.load(['/shared/js/l10n.js'],function baseLoaded(){this._baseLoaded=true;navigator.mozL10n.once(loadDateAndFinalize);}.bind(this));},_loadDateAndFinalize:function ll10n_loadDateAndFinalize(callback){loader.load('/shared/js/l10n_date.js',this._finalize.bind(this,callback));},_finalize:function ll10n_finalize(callback){this._ready=true;callback(navigator.mozL10n.get);}};}());;'use strict';function onLoadDialer(){window.performance.mark('navigationLoaded');window.dispatchEvent(new CustomEvent('moz-chrome-dom-loaded'));window.performance.mark('visuallyLoaded');window.dispatchEvent(new CustomEvent('moz-app-visually-complete'));window.removeEventListener('load',onLoadDialer);if(navigator.mozAudioChannelManager){navigator.mozAudioChannelManager.volumeControlChannel='notification';}
KeypadManager.init(false);window.performance.mark('contentInteractive');window.dispatchEvent(new CustomEvent('moz-content-interactive'));NavbarManager.init();window.performance.mark('navigationInteractive');window.dispatchEvent(new CustomEvent('moz-chrome-interactive'));setTimeout(function nextTick(){var lazyPanels=['confirmation-message','edit-mode','sim-picker'];var lazyPanelsElements=lazyPanels.map(function toElement(id){return document.getElementById(id);});LazyLoader.load(lazyPanelsElements);CallHandler.init();LazyL10n.get(function loadLazyFilesSet(){LazyLoader.load(['/shared/js/fb/fb_request.js','/shared/js/fb/fb_data_reader.js','/shared/js/fb/fb_reader_utils.js','/shared/style/confirm.css','/shared/js/confirm.js','/shared/elements/config.js','/shared/elements/gaia-header/dist/gaia-header.js','/shared/style/edit_mode.css'],function fileSetLoaded(){window.performance.mark('fullyLoaded');window.dispatchEvent(new CustomEvent('moz-app-loaded'));});});});}
window.addEventListener('load',onLoadDialer);;'use strict';var Utils={prettyDate:function ut_prettyDate(time){var _=navigator.mozL10n.get;var timeFormat=window.navigator.mozHour12?_('shortTimeFormat12'):_('shortTimeFormat24');var dtf=new navigator.mozL10n.DateTimeFormat();return dtf.localeFormat(new Date(time),timeFormat);},prettyDuration:function(node,duration,l10nPrefix){var elapsed=new Date(duration);var h=elapsed.getUTCHours();var m=elapsed.getUTCMinutes();var s=elapsed.getUTCSeconds();var l10nId=l10nPrefix||'callDuration';var durationL10n={h:h+'',m:m+'',s:s+''};if(l10nId==='callDuration'){durationL10n={h:(h>9?'':'0')+h,m:(m>9?'':'0')+m,s:(s>9?'':'0')+s};}
if(l10nPrefix==='callDurationTextFormat'&&h===0&&m===0){l10nId+='Seconds';}else{l10nId+=h>0?'Hours':'Minutes';}
navigator.mozL10n.setAttributes(node,l10nId,durationL10n);},headerDate:function ut_headerDate(time){var _=navigator.mozL10n.get;var dtf=new navigator.mozL10n.DateTimeFormat();var diff=(Date.now()-time)/1000;var day_diff=Math.floor(diff/86400);var formattedTime;if(isNaN(day_diff)){formattedTime=_('incorrectDate');}else if(day_diff===0){formattedTime=_('today');}else if(day_diff===1){formattedTime=_('yesterday');}else if(day_diff<6){formattedTime=dtf.localeFormat(new Date(time),'%A');}else{formattedTime=dtf.localeFormat(new Date(time),'%x');}
return formattedTime;},getDayDate:function re_getDayDate(timestamp){var date=new Date(timestamp);var startDate=new Date(date.getFullYear(),date.getMonth(),date.getDate());return startDate.getTime();},getPhoneNumberPrimaryInfo:function ut_getPhoneNumberPrimaryInfo(matchingTel,contact){if(contact){if(contact.name&&contact.name.length&&contact.name[0]!==''){return contact.name;}else if(contact.org&&contact.org.length&&contact.org[0]!==''){return contact.org;}}
if(matchingTel){return matchingTel.value;}
return null;},toCamelCase:function ut_toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});},_getPhoneNumberType:function ut_getPhoneNumberType(matchingTel){var type=matchingTel.type;if(Array.isArray(type)){type=type[0];}
var _=navigator.mozL10n.get;var result=type?_(type):_('mobile');result=result?result:type;return result;},getPhoneNumberAdditionalInfo:function ut_getPhoneNumberAdditionalInfo(matchingTel){var result=this._getPhoneNumberType(matchingTel);var carrier=matchingTel.carrier;if(carrier){result+=', '+carrier;}
return result;},getPhoneNumberAndType:function ut_getPhoneNumberAndType(matchingTel){return this._getPhoneNumberType(matchingTel)+', '+matchingTel.value;}};;'use strict';const kMasterVolume=0.5;const kToneVolume=0.7;const kShortPressDuration=0.15;const kAttackDuration=0.025;const kDecayDuration=0.025;const kReleaseDuration=0.05;var TonePlayer={_audioContext:null,_channel:null,_gainNode:null,_playingNodes:[],_maybeTrashAudio:null,_initialized:false,init:function tp_init(channel){var telephony=navigator.mozTelephony;this._reset();this._channel=channel;this._maybeTrashAudio=(function tp_maybeTrashAudio(){var callIsActive=telephony&&(telephony.calls.length||telephony.conferenceGroup.calls.length);if(document.hidden&&!((this._channel==='telephony')&&callIsActive)){this._trashAudio();}}).bind(this);window.addEventListener('visibilitychange',this._maybeTrashAudio);telephony&&telephony.addEventListener('callschanged',this._maybeTrashAudio);this._initialized=true;},teardown:function tp_teardown(){var telephony=navigator.mozTelephony;telephony&&telephony.removeEventListener('callschanged',this._maybeTrashAudio);window.removeEventListener('visibilitychange',this._maybeTrashAudio);this._reset();this._initialized=false;},_reset:function tp_reset(){this._audioContext=null;this._channel=null;this._gainNode=null;this._playingNodes=[];this._maybeTrashAudio=null;},_ensureAudio:function tp_ensureAudio(){if(this._audioContext||!this._initialized){return;}
this._audioContext=new AudioContext(this._channel);},_trashAudio:function tp_trashAudio(){this.stop();this._audioContext=null;},_startAt:function tp_startAt(frequencies,when,duration){var context=this._audioContext;var sampleRate=context.sampleRate;var envelope=context.createBuffer(1,(duration?duration:0.05)*sampleRate,sampleRate);for(var i=0;i<envelope.length;i++){var factor=kToneVolume;var t=i/sampleRate;if(t<=kAttackDuration){factor=t/kAttackDuration;}else if(t-kAttackDuration<=kDecayDuration){factor=1.0-(1.0-kToneVolume)*(t-kAttackDuration)/kDecayDuration;}
if(!duration){factor-=kToneVolume;}else if(t>duration-kReleaseDuration){factor*=(duration-t)/kReleaseDuration;}
envelope.getChannelData(0)[i]=factor*kMasterVolume;}
var gainNode=context.createGain();gainNode.connect(context.destination);if(!duration){this._gainNode=gainNode;}
var envelopeNode=context.createBufferSource();envelopeNode.buffer=envelope;envelopeNode.start(when);envelopeNode.connect(gainNode.gain);gainNode.gain.setValueAtTime(duration?0.0:kToneVolume*kMasterVolume,0.0);for(i=0;i<frequencies.length;++i){var oscNode=this._audioContext.createOscillator();oscNode.type='sine';oscNode.frequency.value=frequencies[i];oscNode.start(when);if(duration){oscNode.stop(Math.max(when,context.currentTime+0.5)+duration);}else{this._playingNodes.push(oscNode);}
oscNode.connect(gainNode);}},start:function tp_start(frequencies,shortPress){this._ensureAudio();this._startAt(frequencies,0,shortPress?kShortPressDuration:0);},stop:function tp_stop(){if(!this._gainNode){return;}
var context=this._audioContext;var sampleRate=context.sampleRate;var gain=this._gainNode.gain;this._gainNode=null;var ramp=context.createBuffer(1,kReleaseDuration*sampleRate,sampleRate);for(var i=0;i<ramp.length;i++){ramp.getChannelData(0)[i]=(ramp.length-i-1)/ramp.length*kToneVolume*kMasterVolume;}
var rampNode=context.createBufferSource();rampNode.buffer=ramp;rampNode.start();rampNode.connect(gain);gain.setValueAtTime(0.0,0.0);while(this._playingNodes.length){this._playingNodes.pop().stop(context.currentTime+kReleaseDuration+0.5);}},playSequence:function tp_playSequence(sequence){this._ensureAudio();var when=this._audioContext.currentTime+0.2;for(var index=0;index<sequence.length;++index){var step=sequence[index];var frequencies=step.slice(0,2);var duration=step[2]/1000;this._startAt(frequencies,when,duration);when+=duration;}}};;'use strict';function DtmfTone(tone,short,serviceId){this.tone=tone;this.short=short;this.serviceId=serviceId;this.timer=0;}
DtmfTone.kShortToneLength=120;DtmfTone.prototype={play:function dt_play(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);navigator.mozTelephony.startTone(this.tone,this.serviceId);if(this.short){this.timer=window.setTimeout(function dt_stopTone(serviceId){navigator.mozTelephony.stopTone(serviceId);},DtmfTone.kShortToneLength,this.serviceId);}},stop:function dt_stop(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);}};;'use strict';var gTonesFrequencies={'1':[697,1209],'2':[697,1336],'3':[697,1477],'4':[770,1209],'5':[770,1336],'6':[770,1477],'7':[852,1209],'8':[852,1336],'9':[852,1477],'*':[941,1209],'0':[941,1336],'#':[941,1477]};var KeypadManager={kMaxDigits:50,_phoneNumber:'',_onCall:false,_keypadSoundIsEnabled:false,_shortTone:false,_vibrationEnabled:false,kVibrationDuration:50,_insertPosition:null,onValueChanged:null,get phoneNumberView(){delete this.phoneNumberView;this.phoneNumberView=document.getElementById('phone-number-view');return this.phoneNumberView;},get phoneNumberViewContainer(){delete this.phoneNumberViewContainer;this.phoneNumberViewContainer=document.getElementById('phone-number-view-container');return this.phoneNumberViewContainer;},get keypad(){delete this.keypad;this.keypad=document.getElementById('keypad');return this.keypad;},get callBar(){delete this.callBar;this.callBar=document.getElementById('keypad-callbar');return this.callBar;},get hideBar(){delete this.hideBar;this.hideBar=document.getElementById('keypad-hidebar');return this.hideBar;},get callBarAddContact(){delete this.callBarAddContact;this.callBarAddContact=document.getElementById('keypad-callbar-add-contact');return this.callBarAddContact;},get callBarCallAction(){delete this.callBarCallAction;this.callBarCallAction=document.getElementById('keypad-callbar-call-action');return this.callBarCallAction;},get callBarCancelAction(){delete this.callBarCancelAction;this.callBarCancelAction=document.getElementById('keypad-callbar-cancel');return this.callBarCancelAction;},get deleteButton(){delete this.deleteButton;this.deleteButton=document.getElementById('keypad-delete');return this.deleteButton;},get hideBarHangUpAction(){delete this.hideBarHangUpAction;this.hideBarHangUpAction=document.getElementById('keypad-hidebar-hang-up-action-wrapper');return this.hideBarHangUpAction;},get hideBarHideAction(){delete this.hideBarHideAction;this.hideBarHideAction=document.getElementById('keypad-hidebar-hide-keypad-action');return this.hideBarHideAction;},multiSimActionButton:null,init:function kh_init(oncall){this._onCall=!!oncall;this.phoneNumberView.value='';this.phoneNumberView.addEventListener('click',this._updateInsertPosition.bind(this));this._phoneNumber='';var keyHandler=this.keyHandler.bind(this);this.keypad.addEventListener('contextmenu',keyHandler);this.keypad.addEventListener('touchstart',keyHandler,true);this.keypad.addEventListener('touchmove',keyHandler,true);this.keypad.addEventListener('touchend',keyHandler,true);this.keypad.addEventListener('touchcancel',keyHandler,true);this.deleteButton.addEventListener('touchstart',keyHandler);this.deleteButton.addEventListener('touchend',keyHandler);if(this.callBarAddContact){this.callBarAddContact.addEventListener('click',this.addContact.bind(this));}
if(this.callBarCallAction){if(typeof MultiSimActionButton!=='undefined'){if(navigator.mozMobileConnections&&navigator.mozMobileConnections.length>1){var self=this;LazyL10n.get(function localized(_){self.multiSimActionButton=new MultiSimActionButton(self.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',self.phoneNumber.bind(self));});}else{this.multiSimActionButton=new MultiSimActionButton(this.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',this.phoneNumber.bind(this));}}
this.callBarCallAction.addEventListener('click',this.fetchLastCalled.bind(this));}
if(this.callBarCancelAction){this.callBarCancelAction.addEventListener('click',function(){window.parent.LockScreen.switchPanel();});}
if(this.hideBarHideAction){this.hideBarHideAction.addEventListener('click',this.callbarBackAction);}
if(this.hideBarHangUpAction){this.hideBarHangUpAction.addEventListener('click',this.hangUpCallFromKeypad);}
TonePlayer.init(this._onCall?'telephony':'notification');this.render();LazyLoader.load(['/shared/style/action_menu.css','/dialer/js/suggestion_bar.js']);this._observePreferences();},render:function hk_render(layoutType){if(layoutType=='oncall'){if(CallsHandler.activeCall){var activeCall=CallsHandler.activeCall.call;this._phoneNumber=activeCall.id.number;}
this._isKeypadClicked=false;this.phoneNumberViewContainer.classList.add('keypad-visible');if(this.callBar){this.callBar.classList.add('hide');}
if(this.hideBar){this.hideBar.classList.remove('hide');}
this.deleteButton.classList.add('hide');}else{this.phoneNumberViewContainer.classList.remove('keypad-visible');if(this.callBar){this.callBar.classList.remove('hide');}
if(this.hideBar){this.hideBar.classList.add('hide');}
this.deleteButton.classList.remove('hide');}},phoneNumber:function hk_phoneNumber(){return this._phoneNumber;},fetchLastCalled:function hk_fetchLastCalled(){if(this._phoneNumber!==''){return;}
var self=this;CallLogDBManager.getGroupAtPosition(1,'lastEntryDate',true,'dialing',function hk_ggap_callback(result){if(result&&(typeof result==='object')&&result.number){self.updatePhoneNumber(result.number);}});},addContact:function hk_addContact(event){var number=this._phoneNumber;if(!number){return;}
LazyLoader.load(['/dialer/js/add_contact_menu.js'],function(){AddContactMenu.show(number);});},callbarBackAction:function hk_callbarBackAction(event){CallScreen.hideKeypad();},hangUpCallFromKeypad:function hk_hangUpCallFromKeypad(event){CallScreen.body.classList.remove('showKeypad');CallsHandler.end();},_lastPressedKey:null,_dtmfTone:null,_playDtmfTone:function kh_playDtmfTone(key){var serviceId=0;if(!this._onCall){return;}
if(CallsHandler.activeCall){serviceId=CallsHandler.activeCall.call.serviceId;}else{serviceId=navigator.mozTelephony.active.calls[0].serviceId;}
if(this._dtmfTone){this._dtmfTone.stop();this._dtmfTone=null;}
this._dtmfTone=new DtmfTone(key,this._shortTone,serviceId);this._dtmfTone.play();},_stopDtmfTone:function kh_stopDtmfTone(){if(!this._dtmfTone){return;}
this._dtmfTone.stop();this._dtmfTone=null;},_touchStart:function kh_touchStart(key){this._longPress=false;this._lastPressedKey=key;if(key!='delete'){if(this._keypadSoundIsEnabled){TonePlayer.start(gTonesFrequencies[key],!this._onCall||this._shortTone);}
if(this._vibrationEnabled){navigator.vibrate(this.kVibrationDuration);}
this._playDtmfTone(key);}
if(((key=='0'||key=='*')&&!this._onCall)||key=='delete'){this._holdTimer=setTimeout(function(self){self.restoreCaretPosition();if(key=='delete'){self._clearPhoneNumber();}else if(key==='0'){self._replaceLastKey('+');}else if(key==='*'){var isAtTheEnd=self._insertPosition===null;var isFirst=self._insertPosition===1||(isAtTheEnd&&self._phoneNumber.length===1);if(!isFirst){self._replaceLastKey(',');}else{self._deleteAtInsertPosition();}}
self._longPress=true;self._updatePhoneNumberView('begin',false);},400,this);}
if(key==='1'&&this._phoneNumber===''){this._holdTimer=setTimeout(function vm_call(self){self._longPress=true;self._callVoicemail();self._phoneNumber='';self._updatePhoneNumberView('begin',false);},400,this);}
if(key=='delete'){this._deleteAtInsertPosition();}else if(this.phoneNumberViewContainer.classList.contains('keypad-visible')){if(!this._isKeypadClicked){this._isKeypadClicked=true;this._phoneNumber=key;this.replaceAdditionalContactInfo('');}else{this._insertAtCaret(key);}}else{this._insertAtCaret(key);}
setTimeout(function(self){self._updatePhoneNumberView('begin',false);},0,this);},_touchMove:function kh_touchMove(touch){var target=document.elementFromPoint(touch.pageX,touch.pageY);var key=target.dataset?target.dataset.value:null;if(key!==this._lastPressedKey||key==='delete'){this._stopDtmfTone();this._lastPressedKey=null;}},_touchEnd:function kh_touchEnd(key){if(key!=='delete'&&key===this._lastPressedKey){this._stopDtmfTone();this._lastPressedKey=null;}
if(this._keypadSoundIsEnabled){TonePlayer.stop();}
this.restoreCaretPosition();if(this._longPress){this._longPress=false;this._holdTimer=null;return;}
if(this._holdTimer){clearTimeout(this._holdTimer);}},keyHandler:function kh_keyHandler(event){event.preventDefault();if(event.type=='contextmenu'){return;}
var key=event.target.dataset.value;if(!key){return;}
if(key==='#'){if(this._phoneNumber==='*#06#'){this.multiSimActionButton.performAction();event.target.classList.remove('active');return;}else if(this._isSpeedDialNumber(this._phoneNumber)){var self=this;var index=this._phoneNumber.slice(0,-1);this.updatePhoneNumber('','begin',false);this._getSpeedDialNumber(+index).then(function(number){self.updatePhoneNumber(number,'begin',false);},function(error){if(error){ConfirmDialog.show(error,null,{title:'noContactsFoundDialogOk',callback:ConfirmDialog.hide});}});event.target.classList.remove('active');return;}}
if(key!='delete'&&this._phoneNumber.length>=this.kMaxDigits&&!this._onCall){event.target.classList.remove('active');return;}
event.stopPropagation();switch(event.type){case'touchstart':event.target.classList.add('active');this._touchStart(key);break;case'touchmove':this._touchMove(event.touches[0]);break;case'touchend':case'touchcancel':event.target.classList.remove('active');this._touchEnd(key);break;}},_isSpeedDialNumber:function(number){return!!number.match(/^[0-9][0-9]{0,2}\#$/);},_getSpeedDialNumber:function(index){var self=this;var cardIndex;index--;return new Promise(function(resolve,reject){LazyLoader.load(['/shared/js/sim_settings_helper.js'],function(){SimSettingsHelper.getCardIndexFrom('outgoingCall',function(defaultCardIndex){if(defaultCardIndex==SimSettingsHelper.ALWAYS_ASK_OPTION_VALUE){LazyLoader.load(['/shared/js/component_utils.js','/shared/elements/gaia_sim_picker/script.js'],function(){var simPicker=document.getElementById('sim-picker');simPicker.getOrPick(defaultCardIndex,null,function(pickedCardIndex){cardIndex=pickedCardIndex;resolve();});});}else{cardIndex=defaultCardIndex;resolve();}});});}).then(function(){return self._getSimContactsList(cardIndex).then(function(simContactsList){if((index>=0)&&(index<simContactsList.length)){return simContactsList[index].number;}else{return Promise.reject('noContactsWereFound');}});});},_createSimContactList:function(contacts){var numbers=new Array(contacts.length);for(var i=0;i<contacts.length;i++){numbers[i]={id:contacts[i].id,number:contacts[i].tel[0].value,};}
numbers.sort(function(a,b){if(a.id.length==b.id.length){return(a.id>b.id)?1:0;}else{return(a.id.length>b.id.length)?1:0;}});return numbers;},_getSimContactsList:function(cardIndex){var self=this;var canceled=false;return new Promise(function(resolve,reject){LazyLoader.load(['/shared/style/confirm.css','/shared/js/confirm.js',document.getElementById('confirmation-message')],function(){var iccId=navigator.mozIccManager.iccIds[cardIndex];var icc=navigator.mozIccManager.getIccById(iccId);var req=icc.readContacts('adn');req.onsuccess=function(event){var adnContacts=event.target.result;var contacts=self._createSimContactList(adnContacts);if(!canceled){ConfirmDialog.hide();}
resolve(contacts);};req.onerror=function(error){console.error('Could not retrieve the ADN contacts from SIM card '+
cardIndex+', got error '+error.name);reject('noContactsWereFound');};ConfirmDialog.show('loadingSimContacts',null,{title:'cancel',callback:function(){canceled=true;ConfirmDialog.hide();reject();}});});});},sanitizePhoneNumber:function(number){return number.replace(/\s+/g,'');},updatePhoneNumber:function kh_updatePhoneNumber(number,ellipsisSide,forceMaxFontSize){number=this.sanitizePhoneNumber(number);this._phoneNumber=number;this._updatePhoneNumberView(ellipsisSide,forceMaxFontSize);},press:function(value){this._playDtmfTone(value);TonePlayer.start(gTonesFrequencies[value],true);setTimeout((function nextTick(){TonePlayer.stop();this._stopDtmfTone();}).bind(this));},_updatePhoneNumberView:function kh_updatePhoneNumberview(ellipsisSide,forceMaxFontSize){var phoneNumber=this._phoneNumber;if(this._onCall){this.replacePhoneNumber(phoneNumber,ellipsisSide,forceMaxFontSize);}else{var visibility;if(phoneNumber.length>0){visibility='visible';this.callBarAddContact.removeAttribute('disabled');}else{visibility='hidden';this.callBarAddContact.setAttribute('disabled','disabled');}
this.deleteButton.style.visibility=visibility;this.phoneNumberView.blur();this.phoneNumberView.value=phoneNumber;FontSizeManager.adaptToSpace(FontSizeManager.DIAL_PAD,this.phoneNumberView,forceMaxFontSize,ellipsisSide);}
if(this.onValueChanged){this.onValueChanged(this._phoneNumber);}},replacePhoneNumber:function kh_replacePhoneNumber(phoneNumber,ellipsisSide,forceMaxFontSize){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.replacePhoneNumber(phoneNumber,ellipsisSide,forceMaxFontSize);}},restorePhoneNumber:function kh_restorePhoneNumber(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restorePhoneNumber();}},replaceAdditionalContactInfo:function kh_replaceAdditionalContactInfo(additionalContactInfo){var call=CallsHandler.activeCall;if(this._onCall&&call){call.replaceAdditionalContactInfo(additionalContactInfo);}},restoreAdditionalContactInfo:function kh_restoreAdditionalContactInfo(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restoreAdditionalContactInfo();}},_callVoicemail:function(){if(navigator.mozIccManager.iccIds.length<=1){this._callVoicemailForSim(0);return;}
var self=this;var key='ril.voicemail.defaultServiceId';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function(){LazyLoader.load(['/shared/js/component_utils.js','/shared/elements/gaia_sim_picker/script.js'],function(){LazyL10n.get(function(_){var simPicker=document.getElementById('sim-picker');simPicker.getOrPick(req.result[key],_('voiceMail'),self._callVoicemailForSim.bind(self));});});};},_callVoicemailForSim:function(cardIndex){var settings=navigator.mozSettings;if(!settings){return;}
var transaction=settings.createLock();var request=transaction.get('ril.iccInfo.mbdn');request.onsuccess=(function(){var numbers=request.result['ril.iccInfo.mbdn'];var number;if(typeof numbers=='string'){number=numbers;}else{number=numbers&&numbers[cardIndex];}
var voicemail=navigator.mozVoicemail;if(!number&&voicemail){number=voicemail.getNumber(cardIndex);}
if(number){CallHandler.call(number,cardIndex);}else{this._showNoVoicemailDialog();}}).bind(this);request.onerror=function(){};},_showNoVoicemailDialog:function hk_showNoVoicemailDialog(){var voicemailDialog={title:'voicemailNoNumberTitle',text:'voicemailNoNumberText',confirm:{title:'voicemailNoNumberSettings',recommend:true,callback:this.showVoicemailSettings},cancel:{title:'voicemailNoNumberCancel',callback:this._hideNoVoicemailDialog}};LazyLoader.load(['/shared/js/custom_dialog.js'],function(){CustomDialog.show(voicemailDialog.title,voicemailDialog.text,voicemailDialog.cancel,voicemailDialog.confirm);});},_hideNoVoicemailDialog:function kh_hideNoVoicemailDialog(){CustomDialog.hide();},showVoicemailSettings:function kh_showVoicemailSettings(){var activity=new window.MozActivity({name:'configure',data:{target:'device',section:'call'}});activity.onerror=function(){console.warn('Configure activity error:',activity.error.name);};},_observePreferences:function kh_observePreferences(){var self=this;LazyLoader.load('/shared/js/settings_listener.js',function(){SettingsListener.observe('phone.ring.keypad',false,function(value){self._keypadSoundIsEnabled=!!value;});SettingsListener.observe('phone.dtmf.type',false,function(value){self._shortTone=(value==='short');});SettingsListener.observe('keyboard.vibration',false,function(value){self._vibrationEnabled=!!value;});});},_updateInsertPosition:function kh_updateInsertPosition(){this._insertPosition=this._realStartPosition();},_replaceLastKey:function kh_replaceLastKey(newKey){this._deleteAtInsertPosition();this.restoreCaretPosition();this._insertAtCaret(newKey);},_insertAtCaret:function kh_insertAtCaret(key){if(this._insertPosition===null){this._phoneNumber+=key;}else{var start=this._realStartPosition();var end=this._realEndPosition();this._phoneNumber=this._phoneNumber.substring(0,start)+key+
this._phoneNumber.substring(end);this._insertPosition=start+1;}},_deleteAtInsertPosition:function kh_deleteAtInsertPosition(){if(this._insertPosition===null){this._phoneNumber=this._phoneNumber.slice(0,-1);}else{var start=this._realStartPosition();var end=this._realEndPosition();if(start>0&&start===end){start=end-1;}
this._phoneNumber=this._phoneNumber.substring(0,start)+
this._phoneNumber.substring(end);this._insertPosition=this._phoneNumber?start:null;}},_clearPhoneNumber:function kh_clearPhoneNumber(){if(this._insertPosition===null){this._phoneNumber='';}else{var start=this._realStartPosition();this._phoneNumber=this._phoneNumber.substring(start);this._insertPosition=this._phoneNumber?0:null;}},restoreCaretPosition:function kh_restoreCaretPosition(){if(this._insertPosition!==null){var caretPosition=this._caretPosition(this._insertPosition);this.phoneNumberView.selectionStart=caretPosition;this.phoneNumberView.selectionEnd=caretPosition;this.phoneNumberView.focus();}else{this.phoneNumberView.blur();}},_realStartPosition:function kh_realStartPosition(){var start=this.phoneNumberView.selectionStart;return this._realPosition(this.phoneNumberView,start);},_realEndPosition:function kh_realEndPosition(){var end=this.phoneNumberView.selectionEnd;return this._realPosition(this.phoneNumberView,end);},_caretPosition:function kh_caretPosition(realPosition){return realPosition-this._ellipsisOffset(this.phoneNumberView);},_realPosition:function kh_realPosition(input,position){return position+this._ellipsisOffset(this.phoneNumberView);},_ellipsisOffset:function kh_ellipsisOffset(input){var ellipsedCharacters=+input.dataset.ellipsedCharacters;return ellipsedCharacters?(ellipsedCharacters-1):0;}};;'use strict';var FontSizeManager=(function fontSizeManager(){var DIAL_PAD=0,SINGLE_CALL=1,CALL_WAITING=2,STATUS_BAR=3,SECOND_INCOMING_CALL=4;var _sizes={};_sizes[DIAL_PAD]={min:2.6,max:4.1};_sizes[SINGLE_CALL]={min:2.3,max:3.4,line:3.4};_sizes[CALL_WAITING]={min:2.3,max:2.5,line:1.3};_sizes[STATUS_BAR]={min:1.7,max:1.7};_sizes[SECOND_INCOMING_CALL]={min:2.3,max:2.5,line:3.7};var _defaultFontSize;function _getRootFontSize(){_defaultFontSize=_defaultFontSize||parseInt(window.getComputedStyle(document.body,null).getPropertyValue('font-size'));return _defaultFontSize;}
function _getMinFontSize(scenario){return Math.round(_sizes[scenario].min*_getRootFontSize());}
function _getMaxFontSize(scenario){return Math.round(_sizes[scenario].max*_getRootFontSize());}
function _getAllowedFontSizes(scenario){var minFontSize=_getMinFontSize(scenario);var maxFontSize=_getMaxFontSize(scenario);var allowedSizes=[];for(var size=minFontSize;size<=maxFontSize;size+=4){allowedSizes.push(size);}
if(allowedSizes.indexOf(maxFontSize)===-1){allowedSizes.push(maxFontSize);}
return allowedSizes;}
function adaptToSpace(scenario,view,forceMaxFontSize,ellipsisSide){var computedStyle=window.getComputedStyle(view);if((!view.value&&!view.textContent)||!computedStyle){return;}
var viewWidth=view.getBoundingClientRect().width;var viewFont=computedStyle.fontFamily;var allowedSizes;if(forceMaxFontSize){allowedSizes=[_getMaxFontSize(scenario)];}else{allowedSizes=_getAllowedFontSizes(scenario);}
var infos=FontSizeUtils.getMaxFontSizeInfo(view.value||view.textContent,allowedSizes,viewFont,viewWidth);var newFontSize=infos.fontSize;if(view.style.fontSize!==newFontSize){view.style.fontSize=newFontSize+'px';}
if(infos&&infos.overflow){var overflowCount=FontSizeUtils.getOverflowCount(view.value||view.textContent,newFontSize,viewFont,viewWidth);overflowCount+=2;_useEllipsis(view,overflowCount,ellipsisSide);view.dataset.ellipsedCharacters=overflowCount;}else{view.dataset.ellipsedCharacters=0;}}
function _useEllipsis(view,overflowCount,ellipsisSide){var side=ellipsisSide||'begin';var localizedSide=(side==='begin'?'left':'right');var value=view.value||view.textContent;if(localizedSide=='left'){value='\u2026'+value.substr(-value.length+overflowCount);}else if(localizedSide=='right'){value=value.substr(0,value.length-overflowCount)+'\u2026';}
if(view.value){view.value=value;}else{view.textContent=value;}}
function ensureFixedBaseline(scenario,view){var initialLineHeight=_sizes[scenario].line;if(!initialLineHeight){return;}
var maxFontSize=_getMaxFontSize(scenario);var fontSize=parseInt(window.getComputedStyle(view).fontSize,10);view.style.lineHeight=initialLineHeight*_getRootFontSize()+
(maxFontSize-fontSize)/2+'px';}
function resetFixedBaseline(view){view.style.removeProperty('line-height');}
return{DIAL_PAD:DIAL_PAD,SINGLE_CALL:SINGLE_CALL,CALL_WAITING:CALL_WAITING,STATUS_BAR:STATUS_BAR,SECOND_INCOMING_CALL:SECOND_INCOMING_CALL,adaptToSpace:adaptToSpace,ensureFixedBaseline:ensureFixedBaseline,resetFixedBaseline:resetFixedBaseline};})();;'use strict';var NavbarManager={init:function nm_init(){this.update=this.update.bind(this);this.update();window.addEventListener('hashchange',this.update);var contacts=document.getElementById('option-contacts');contacts.addEventListener('click',this.contactsTabTap);},resourcesLoaded:false,ensureResources:function(cb){if(this.resourcesLoaded){if(cb&&typeof cb==='function'){cb();}
return;}
var self=this;LazyLoader.load(['/shared/js/accessibility_helper.js','/shared/js/async_storage.js','/shared/js/notification_helper.js','/shared/js/simple_phone_matcher.js','/shared/js/contact_photo_helper.js','/shared/js/dialer/contacts.js','/shared/js/dialer/voicemail.js','/dialer/js/call_log.js','/dialer/style/call_log.css'],function rs_loaded(){self.resourcesLoaded=true;if(cb&&typeof cb==='function'){cb();}});},update:function nm_update(){var recent=document.getElementById('option-recents');var contacts=document.getElementById('option-contacts');var keypad=document.getElementById('option-keypad');var tabs=[recent,contacts,keypad];recent.classList.remove('toolbar-option-selected');contacts.classList.remove('toolbar-option-selected');keypad.classList.remove('toolbar-option-selected');var checkContactsTab=function(){var contactsIframe=document.getElementById('iframe-contacts');if(!contactsIframe){return;}
var index=contactsIframe.src.indexOf('#add-parameters');if(index!=-1){contactsIframe.src=contactsIframe.src.substr(0,index);}};var destination=window.location.hash;switch(destination){case'#call-log-view':checkContactsTab();this.ensureResources(function(){recent.classList.add('toolbar-option-selected');AccessibilityHelper.setAriaSelected(recent,tabs);CallLog.init();});break;case'#contacts-view':var frame=document.getElementById('iframe-contacts');if(!frame){var view=document.getElementById('iframe-contacts-container');frame=document.createElement('iframe');frame.src='/contacts/index.html';frame.id='iframe-contacts';frame.setAttribute('frameBorder','no');frame.classList.add('grid-wrapper');view.appendChild(frame);}
contacts.classList.add('toolbar-option-selected');this.ensureResources(function(){AccessibilityHelper.setAriaSelected(contacts,tabs);});break;case'#keyboard-view':checkContactsTab();keypad.classList.add('toolbar-option-selected');this.ensureResources(function(){AccessibilityHelper.setAriaSelected(keypad,tabs);});break;}},hide:function(){var views=document.getElementById('views');views.classList.add('hide-toolbar');},show:function(){var views=document.getElementById('views');views.classList.remove('hide-toolbar');},contactsTabTap:function(){if(window.location.hash!='#contacts-view'){return;}
this._contactsHome();},_contactsHome:function(){var contactsIframe=document.getElementById('iframe-contacts');if(!contactsIframe){return;}
var forceHashChange=new Date().getTime();contactsIframe.src='/contacts/index.html#home?forceHashChange='+
forceHashChange;}};var CallHandler=(function callHandler(){var COMMS_APP_ORIGIN=document.location.protocol+'//'+
document.location.host;var FB_SYNC_ERROR_PARAM='isSyncError';var screenState=null;var engineeringModeKey=null;function handleActivity(activity){if(activity.source.name!='dial'){return;}
var number=activity.source.data.number;if(number){KeypadManager.updatePhoneNumber(number,'begin',false);if(window.location.hash!='#keyboard-view'){window.location.hash='#keyboard-view';}}else{if(window.location.hash!='#contacts-view'){window.location.hash='#contacts-view';}
NavbarManager._contactsHome();}}
function deserializeParameters(input){var rparams=/([^?=&]+)(?:=([^&]*))?/g;var parsed={};input.replace(rparams,function($0,$1,$2){parsed[$1]=decodeURIComponent($2);});return parsed;}
function handleNotification(evt){if(!evt.clicked){return;}
navigator.mozApps.getSelf().onsuccess=function gotSelf(selfEvt){var app=selfEvt.target.result;app.launch('dialer');var location=document.createElement('a');location.href=evt.imageURL;if(location.search.indexOf(FB_SYNC_ERROR_PARAM)!==-1){window.location.hash='#contacts-view';}else if(location.search.indexOf('ussdMessage')!==-1){var params=deserializeParameters(evt.imageURL);Notification.get({tag:evt.tag}).then(function(notifications){for(var i=0;i<notifications.length;i++){notifications[i].close();}});MmiManager.handleMMIReceived(evt.body,true,params.cardIndex);}else{window.location.hash='#call-log-view';}};}
function sendNotification(number,serviceId){LazyLoader.load('/shared/js/dialer/utils.js',function(){Contacts.findByNumber(number,function lookup(contact,matchingTel){LazyL10n.get(function localized(_){var title;if(navigator.mozIccManager.iccIds.length>1){title=_('missedCallMultiSims',{n:serviceId+1});}else{title=_('missedCall');}
var body;if(!number){body=_('from-withheld-number');}else if(contact){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(primaryInfo){if(primaryInfo!==matchingTel.value){body=_('from-contact',{contact:primaryInfo.toString()});}else{body=_('from-number',{number:primaryInfo});}}else{body=_('from-withheld-number');}}else{body=_('from-number',{number:number});}
navigator.mozApps.getSelf().onsuccess=function getSelfCB(evt){var app=evt.target.result;var iconURL=NotificationHelper.getIconURI(app,'dialer');var clickCB=function(){app.launch('dialer');window.location.hash='#call-log-view';};var notification=new Notification(title,{body:body,icon:iconURL});notification.addEventListener('click',clickCB);};});});});}
function callEnded(data){var highPriorityWakeLock=navigator.requestWakeLock('high-priority');var number=data.number;var incoming=data.direction==='incoming';NavbarManager.ensureResources(function(){if(incoming&&!data.duration&&!data.hangUpLocal){sendNotification(number,data.serviceId);}
Voicemail.check(number,data.serviceId).then(function(isVoicemailNumber){var entry={date:Date.now()-parseInt(data.duration),duration:data.duration,type:incoming?'incoming':'dialing',number:number,serviceId:data.serviceId,emergency:data.emergency||false,voicemail:isVoicemailNumber,status:(incoming&&data.duration>0)?'connected':null};CallLogDBManager.add(entry,function(logEntry){CallLog.appendGroup(logEntry);if(!data.secondNumber){highPriorityWakeLock.unlock();return;}
_addSecondCdmaCall(data,isVoicemailNumber,highPriorityWakeLock);});});});}
function _addSecondCdmaCall(data,isVoicemailNumber,wakeLock){var entryCdmaSecond={date:Date.now()-parseInt(data.duration),duration:data.duration,type:'incoming',number:data.secondNumber,serviceId:data.serviceId,emergency:false,voicemail:isVoicemailNumber,status:'connected'};CallLogDBManager.add(entryCdmaSecond,function(logGroupCdmaSecondCall){CallLog.appendGroup(logGroupCdmaSecondCall);wakeLock.unlock();});}
function handleMessage(evt){if(evt.origin!==COMMS_APP_ORIGIN){return;}
var data=evt.data;if(!data.type){return;}
if(data.type==='contactsiframe'){handleContactsIframeRequest(data.message);}else if(data.type==='hide-navbar'){NavbarManager.hide();}else if(data.type==='show-navbar'){NavbarManager.show();}}
window.addEventListener('message',handleMessage);function handleContactsIframeRequest(message){switch(message){case'back':var contactsIframe=document.getElementById('iframe-contacts');contactsIframe.contentWindow.history.pushState(null,null,'/contacts/index.html');window.location.hash='#call-log-view';break;}}
function btCommandHandler(message){var command=message.command;var isAtd=command.startsWith('ATD');if(command!=='BLDN'&&!isAtd){return;}
if(isAtd&&command[3]!=='>'){var phoneNumber=command.substring(3);LazyLoader.load(['/shared/js/sim_settings_helper.js'],function(){SimSettingsHelper.getCardIndexFrom('outgoingCall',function(defaultCardIndex){if(defaultCardIndex===SimSettingsHelper.ALWAYS_ASK_OPTION_VALUE){LazyLoader.load(['/shared/js/component_utils.js','/shared/elements/gaia_sim_picker/script.js'],function(){var simPicker=document.getElementById('sim-picker');simPicker.getOrPick(defaultCardIndex,phoneNumber,function(ci){CallHandler.call(phoneNumber,ci);});navigator.mozApps.getSelf().onsuccess=function(selfEvt){var app=selfEvt.target.result;app.launch('dialer');};});}else{CallHandler.call(phoneNumber,defaultCardIndex);}});});return;}
var position=isAtd?parseInt(command.substring(4),10):1;CallLogDBManager.getGroupAtPosition(position,'lastEntryDate',true,'dialing',function(result){if(result&&(typeof result==='object')&&result.number){LazyLoader.load(['/shared/js/sim_settings_helper.js'],function(){SimSettingsHelper.getCardIndexFrom('outgoingCall',function(ci){if(ci===undefined||ci===null||ci==SimSettingsHelper.ALWAYS_ASK_OPTION_VALUE){ci=result.serviceId;}
CallHandler.call(result.number,ci);});});}else{console.log('Could not get the group at: '+position+'. Error: '+result);}});}
function call(number,cardIndex){if(engineeringModeKey&&number===engineeringModeKey){var activity=new MozActivity({name:'internal-system-engineering-mode'});activity.onerror=function(){console.log('Could not launch engineering mode');};return;}
if(MmiManager.isImei(number)){MmiManager.showImei();KeypadManager.updatePhoneNumber('','begin',true);SuggestionBar.clear();return;}
var connected,disconnected;connected=disconnected=function clearPhoneView(){KeypadManager.updatePhoneNumber('','begin',true);};var error=function(){KeypadManager.updatePhoneNumber(number,'begin',false);};var oncall=function(){SuggestionBar.hideOverlay();SuggestionBar.clear();};LazyLoader.load(['/dialer/js/telephony_helper.js'],function(){TelephonyHelper.call(number,cardIndex,oncall,connected,disconnected,error);});}
function onUssdReceived(evt){var lock=null;var safetyId;function releaseWakeLock(){if(lock){lock.unlock();lock=null;clearTimeout(safetyId);}}
if(document.hidden){lock=navigator.requestWakeLock('high-priority');safetyId=setTimeout(releaseWakeLock,30000);document.addEventListener('visibilitychange',releaseWakeLock);}
if(!document.hidden||evt.session){MmiManager.handleMMIReceived(evt.message,evt.session,evt.serviceId);}else{MmiManager.sendNotification(evt.message,evt.serviceId).then(releaseWakeLock);}}
function init(){LazyLoader.load(['/shared/js/mobile_operator.js','/dialer/js/mmi.js','/dialer/js/mmi_ui.js','/shared/style/progress_activity.css','/dialer/style/mmi.css'],function(){if(window.navigator.mozSetMessageHandler){window.navigator.mozSetMessageHandler('telephony-call-ended',callEnded);window.navigator.mozSetMessageHandler('activity',handleActivity);window.navigator.mozSetMessageHandler('notification',handleNotification);window.navigator.mozSetMessageHandler('bluetooth-dialer-command',btCommandHandler);window.navigator.mozSetMessageHandler('ussd-received',onUssdReceived);}});LazyLoader.load('/shared/js/settings_listener.js',function(){SettingsListener.observe('lockscreen.locked',null,function(value){if(value){screenState='locked';}else{screenState='unlocked';}});SettingsListener.observe('engineering-mode.key',null,function(value){engineeringModeKey=value||null;});});}
return{init:init,call:call};})();window.onresize=function(e){if(window.innerHeight<440){NavbarManager.hide();}else{NavbarManager.show();}};;'use strict';var CallLogDBManager={_db:null,_dbName:'dialerRecents',_dbRecentsStore:'dialerRecents',_dbGroupsStore:'dialerGroups',_dbVersion:5,_maxNumberOfGroups:200,_numberOfGroupsToDelete:30,_observers:{},set onupgradeneeded(callback){this._addObserver('upgradeneeded',callback);},set onupgradedone(callback){this._addObserver('upgradedone',callback);},set onupgradeprogress(callback){this._addObserver('upgradeprogress',callback);},_addObserver:function _addObserver(message,callback){if(!this._observers[message]){this._observers[message]=[];}
this._observers[message].push(callback);},_notifyObservers:function _notifyObservers(message,value){var observers=this._observers[message];if(!observers){return;}
for(var callback in observers){if(observers[callback]&&typeof observers[callback]==='function'){observers[callback](value);}}},_asyncReturn:function _asyncReturn(callback,result){if(callback&&callback instanceof Function){callback(result);}},_ensureDB:function ensureDB(callback){if(this._db){callback(null,this._db);return;}
LazyLoader.load(['/shared/js/dialer/utils.js','/shared/js/dialer/contacts.js'],(function(){try{var indexedDB=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;if(!indexedDB){callback('NO_INDEXED_DB_AVAILABLE',null);return;}
var self=this;var request=indexedDB.open(this._dbName,this._dbVersion);request.onsuccess=(function onsuccess(event){this._db=event.target.result;callback(null,this._db);}).bind(this);request.onerror=function onerror(event){callback(event.target.errorCode,null);};request.onblocked=function onblocked(){callback('DB_REQUEST_BLOCKED',null);};request.onupgradeneeded=function onupgradeneeded(event){self._notifyObservers('upgradeneeded');var db=event.target.result;var txn=event.target.transaction;var currentVersion=event.oldVersion;function update(currentVersion){var next=update.bind(self,currentVersion+1);switch(currentVersion){case 0:self._createSchema(db,next);break;case 1:self._upgradeSchemaVersion2(db,txn,next);break;case 2:self._upgradeSchemaVersion3(next);break;case 3:self._upgradeSchemaVersion4(db,txn,next);break;case 4:self._upgradeSchemaVersion5(next);break;case 5:self._notifyObservers('upgradedone');break;default:event.target.transaction.abort();break;}
currentVersion++;}
update(currentVersion);};}catch(ex){callback(ex.message,null);}}).bind(this));},_newTxn:function newTxn(txnType,objectStores,callback){if(!objectStores){objectStores=[this._dbGroupsStore];}
if(!Array.isArray(objectStores)){objectStores=[objectStores];}
this._ensureDB(function(error,db){if(error){callback(error);return;}
var txn=db.transaction(objectStores,txnType);var stores;if(objectStores.length===1){stores=txn.objectStore(objectStores[0]);}else{stores=[];for(var i=0;i<objectStores.length;i++){stores.push(txn.objectStore(objectStores[i]));}}
callback(null,txn,stores);});},close:function rbdm_close(){this._db.close();this._db=null;},_createSchema:function createSchema(db,next){var objStore=db.createObjectStore(this._dbRecentsStore,{keyPath:'date'});objStore.createIndex('number','number');next();},_upgradeSchemaVersion2:function upgradeSchemaVersion2(db,transaction,next){db.createObjectStore(this._dbGroupsStore,{keyPath:'id'});var recentsStore=transaction.objectStore(this._dbRecentsStore);recentsStore.createIndex('groupId','groupId');next();},_upgradeSchemaVersion3:function upgradeSchemaVersion3(next){next();},_upgradeSchemaVersion4:function upgradeSchemaVersion4(db,transaction,next){var self=this;var waitForAsyncCall=0;var cursorDone=false;var groups={};var recentsCount=0;var groupCount=0;function onGroupsDone(){if(!cursorDone||waitForAsyncCall){return;}
if(groupCount===0){next();return;}
self._newTxn('readwrite',[self._dbGroupsStore],function(error,txn,store){if(error){console.log('Error upgrading the database '+error);return;}
var onPutSuccess=function onsuccess(){groupCount--;if(groupCount===0){next();}};for(var group in groups){store.put(groups[group]).onsuccess=onPutSuccess;delete groups[group];}});}
function populateGroups(){var percent=parseInt(recentsCount*0.15);var countToProgressEvent=percent;var percent2=parseInt(recentsCount*0.25);var countToProgressEvent2=percent2;var progress=0;recentsStore.openCursor().onsuccess=function onsuccess(event){if(countToProgressEvent===0){countToProgressEvent=percent;progress+=10;self._notifyObservers('upgradeprogress',progress);}else{countToProgressEvent--;}
var cursor=event.target.result;if(!cursor){cursorDone=true;onGroupsDone();return;}
var record=cursor.value;var type='';var status;switch(record.type){case'incoming-connected':type='incoming';status='connected';break;case'incoming-refused':type='incoming';break;default:if(record.type&&record.type.indexOf('dialing')!=-1){type='dialing';}
break;}
var id=self._getGroupId({date:record.date,number:record.number,type:type,status:status});var date=new Date(record.date);var key=date.getDate()+date.getMonth()+date.getFullYear()+
record.number+type;if(status){key+=status;}
waitForAsyncCall++;Contacts.findByNumber(record.number,function(contact,matchingTel){if(countToProgressEvent2===0){countToProgressEvent2=percent2;progress+=10;self._notifyObservers('upgradeprogress',progress);}else{countToProgressEvent2--;}
if(key in groups){if(groups[key].lastEntryDate<=record.date){groups[key].lastEntryDate=record.date;}
groups[key].retryCount++;}else{var group={id:id,number:record.number,lastEntryDate:record.date,retryCount:1};if(contact&&contact!==null){group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){group.contactPhoto=photo;}
if(matchingTel){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)){primaryInfo=primaryInfo[0];}
group.contactPrimaryInfo=String(primaryInfo);if(Array.isArray(matchingTel.type)&&matchingTel.type[0]){group.contactMatchingTelType=String(matchingTel.type[0]);}
if(matchingTel.carrier){group.contactMatchingTelCarrier=String(matchingTel.carrier);}}}
groups[key]=group;groupCount++;}
waitForAsyncCall--;onGroupsDone();});cursor.continue();};}
transaction.objectStore(self._dbGroupsStore);db.deleteObjectStore(self._dbGroupsStore);var groupsStore=db.createObjectStore(self._dbGroupsStore,{keyPath:'id'});groupsStore.createIndex('number','number');groupsStore.createIndex('contactId','contactId');groupsStore.createIndex('lastEntryDate','lastEntryDate');var recentsStore=transaction.objectStore(self._dbRecentsStore);recentsStore.count().onsuccess=function(event){recentsCount=event.target.result;populateGroups();};},_upgradeSchemaVersion5:function upgradeSchemaVersion5(next){next();},_getGroupId:function getGroupId(recentCall){var groupId=[Utils.getDayDate(recentCall.date),(recentCall.number||''),recentCall.type];if(recentCall.status&&recentCall.type==='incoming'){groupId.push(recentCall.status);}
return groupId;},_getGroupObject:function getGroupObject(group){if(!Array.isArray(group.id)||group.id.length<3){return null;}
var contact;if(group.contactId){contact={id:group.contactId,primaryInfo:group.contactPrimaryInfo,matchingTel:{number:group.id[1],type:group.contactMatchingTelType,carrier:group.contactMatchingTelCarrier},photo:group.contactPhoto};}
return{id:group.id.join('-'),date:group.id[0],number:group.id[1],serviceId:group.serviceId,type:group.id[2],status:group.id[3]||undefined,lastEntryDate:group.lastEntryDate,retryCount:group.retryCount,contact:contact,emergency:group.emergency,voicemail:!!(group.id[1]&&group.voicemail),calls:group.calls};},_keepDbPrettyAndFit:function _keepDbPrettyAndFit(txn,callback){var self=this;var store=txn.objectStore(this._dbGroupsStore);var req=store.count();req.onsuccess=function(){var groupsToDelete=req.result-self._maxNumberOfGroups;if(groupsToDelete>0){groupsToDelete+=self._numberOfGroupsToDelete;var cursorReq=store.index('lastEntryDate').openCursor();cursorReq.onsuccess=function(){var cursor=cursorReq.result;if(!cursor||!groupsToDelete){return;}
groupsToDelete--;self.deleteGroup(null,cursor.value.id);cursor.continue();};}};txn.oncomplete=function(){if(callback&&callback instanceof Function){callback();}};},add:function add(recentCall,callback){if(typeof recentCall!=='object'){callback('INVALID_CALL');return;}
var self=this;this._newTxn('readwrite',[this._dbRecentsStore,this._dbGroupsStore],function(error,txn,stores){if(error){self._asyncReturn(callback,error);return;}
var recentsStore=stores[0];var groupsStore=stores[1];var groupId=self._getGroupId(recentCall);groupsStore.get(groupId).onsuccess=function onsuccess(){var group=this.result;if(group){self._updateExistingGroup(group,recentCall,txn,callback);}else{self._createNewGroup(groupId,recentCall,callback);}
recentCall.groupId=groupId;recentsStore.put(recentCall);};});},_updateExistingGroup:function(group,recentCall,txn,callback){var groupsStore=txn.objectStore(this._dbGroupsStore);var groupObject;var self=this;txn.oncomplete=function(){self._dispatchCallLogDbNewCall(groupObject);self._asyncReturn(callback,groupObject);};if(group.lastEntryDate<=recentCall.date){group.lastEntryDate=recentCall.date;group.serviceId=recentCall.serviceId;group.emergency=recentCall.emergency;group.voicemail=recentCall.voicemail;}
group.calls=group.calls||[];group.calls.unshift({date:recentCall.date,duration:recentCall.duration});group.retryCount++;groupsStore.put(group).onsuccess=function onsuccess(){groupObject=self._getGroupObject(group);};},_createNewGroup:function(groupId,recentCall,callback){var self=this;var group={id:groupId,number:recentCall.number,serviceId:recentCall.serviceId,lastEntryDate:recentCall.date,retryCount:1,emergency:recentCall.emergency,voicemail:recentCall.voicemail,calls:[{date:recentCall.date,duration:recentCall.duration}]};Contacts.findByNumber(recentCall.number,function(contact,matchingTel){if(contact&&contact!==null){group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){group.contactPhoto=photo;}
if(matchingTel){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)){primaryInfo=primaryInfo[0];}
group.contactPrimaryInfo=String(primaryInfo);if(Array.isArray(matchingTel.type)&&matchingTel.type[0]){group.contactMatchingTelType=String(matchingTel.type[0]);}else{group.contactMatchingTelType=String(matchingTel.type);}
if(matchingTel.carrier){group.contactMatchingTelCarrier=String(matchingTel.carrier);}}}
self._newTxn('readwrite',[self._dbGroupsStore],function(error,txn,store){if(error){self._asyncReturn(callback,error);return;}
store.get(groupId).onsuccess=function onsuccess(){if(this.result){return;}
store.add(group).onsuccess=function onsuccess(){var groupObject=self._getGroupObject(group);self._dispatchCallLogDbNewCall(groupObject);self._keepDbPrettyAndFit(txn,function(){self._asyncReturn(callback,groupObject);});};};});});},_dispatchCallLogDbNewCall:function(group){var createOrUpdateEvt=new CustomEvent('CallLogDbNewCall',{detail:{group:group}});window.dispatchEvent(createOrUpdateEvt);},deleteGroup:function deleteGroup(group,groupId,callback){if(!groupId&&(!group||typeof group!=='object'||!group.date||!group.type)){callback('NOT_VALID_GROUP');return;}
var self=this;this._newTxn('readwrite',[this._dbGroupsStore,this._dbRecentsStore],function(error,txn,stores){if(error){self._asyncReturn(callback,error);return;}
var groupsStore=stores[0];var recentsStore=stores[1];if(!groupId){groupId=self._getGroupId(group);}
var deleted=0;txn.oncomplete=function(){self._asyncReturn(callback,deleted);};groupsStore.delete(groupId).onsuccess=function onsuccess(){recentsStore.index('groupId').openCursor(groupId).onsuccess=function onsuccess(event){var cursor=event.target.result;if(cursor){cursor.delete();deleted++;cursor.continue();}};};});},deleteGroupList:function deleteGroupList(groupList,callback,deletedCount){if(!deletedCount){deletedCount=0;}
var self=this;if(groupList.length>0){var itemToDelete=groupList.pop();if(typeof itemToDelete!=='object'){self._asyncReturn(callback,'INVALID_GROUP_IN_LIST');return;}
var ondeleted=function ondeleted(result){if(typeof result!=='number'){self._asyncReturn(callback,result);return;}
deletedCount+=result;self.deleteGroupList(groupList,callback,deletedCount);};self.deleteGroup(itemToDelete,null,ondeleted);}else{self._asyncReturn(callback,deletedCount);}},deleteAll:function deleteAll(callback){var self=this;this._newTxn('readwrite',[this._dbRecentsStore,this._dbGroupsStore],function(error,txn,stores){if(error){self._asyncReturn(callback,error);return;}
var recentsStore=stores[0];var groupsStore=stores[1];txn.oncomplete=function(){self._asyncReturn(callback);};recentsStore.clear().onsuccess=function onsuccess(){groupsStore.clear();};});},deleteDb:function deleteDb(callback){var indexedDB=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;if(!indexedDB){callback('NO_INDEXEDDB_AVAILABLE');return;}
if(this._db){this._db.close();}
var self=this;var req=indexedDB.deleteDatabase(this._dbName);req.onsuccess=function onsuccess(){self._asyncReturn(callback);};req.onerror=function onerror(){self._asyncReturn(callback,req.error.name);};},_getList:function getList(storeName,callback,sortedBy,prev,getCursor,limit){var results=[];if(!callback||!(callback instanceof Function)){return;}
var self=this;this._newTxn('readonly',[storeName],function(error,txn,store){if(error){callback(error);return;}
if(!getCursor){txn.oncomplete=function(){callback(results);};}
txn.onerror=function(event){callback(event.target.error);};var cursor=null;var direction=prev?'prev':'next';if(sortedBy&&sortedBy!==null){if(!store.indexNames.contains(sortedBy)&&sortedBy!='id'){callback('INVALID_SORTED_BY_KEY');txn.abort();return;}
cursor=store.index(sortedBy).openCursor(null,direction);}else{cursor=store.openCursor(null,direction);}
cursor.onsuccess=function onsuccess(event){var item=event.target.result;if(getCursor){if(!item){callback({value:null});}else if(storeName===self._dbGroupsStore){callback({value:self._getGroupObject(item.value),continue:function(){return item.continue();}});}else{callback(item);}
return;}else if(item&&(typeof limit==='undefined'||limit>0)){if(storeName===self._dbGroupsStore){results.push(self._getGroupObject(item.value));}else{results.push(item.value);}
if(limit){limit--;}
item.continue();}};});},getRecentList:function getRecentList(callback,sortedBy,prev,getCursor,limit){this._getList(this._dbRecentsStore,callback,sortedBy,prev,getCursor,limit);},getGroupList:function getGroupList(callback,sortedBy,prev,getCursor,limit){if(sortedBy==='number'||sortedBy==='type'||sortedBy==='status'){sortedBy=null;}
this._getList(this._dbGroupsStore,callback,sortedBy,prev,getCursor,limit);},getGroupAtPosition:function rdbm_getGroupAtPosition(position,sortedBy,prev,type,callback){if(!callback||!(callback instanceof Function)){return;}
var self=this;this._newTxn('readonly',this._dbGroupsStore,function(error,txn,store){if(error){callback(error);return;}
try{var request=null;var direction=prev?'prev':'next';if(sortedBy&&sortedBy!==null){request=store.index(sortedBy).openCursor(null,direction);}else{request=store.openCursor(null,direction);}
var i=0;request.onsuccess=function(event){var cursor=event.target.result;if(!cursor){callback(null);return;}
var recentGroup=self._getGroupObject(cursor.value);var matched=!type||recentGroup.type.indexOf(type)!=-1;if(matched){i++;}
if(matched&&i==position){callback(recentGroup);}else{cursor.continue();}};request.onerror=function(event){callback(event.target.error.name);};}catch(e){callback(e);}});},getGroup:function(number,date,type,status){var self=this;return new Promise(function(resolve,reject){var recentCall={number:number,date:date,type:type,status:status};var groupId=self._getGroupId(recentCall);self._newTxn('readonly',self._dbGroupsStore,function(error,txn,groupsStore){var group=null;txn.oncomplete=function(){if(group){resolve(self._getGroupObject(group));}else{reject();}};groupsStore.get(groupId).onsuccess=function(){group=this.result;};});});},getLastCall:function getLastCall(callback){if(!callback||!(callback instanceof Function)){return;}
this._newTxn('readonly',[this._dbRecentsStore],function(error,txn,store){if(error){callback(error);return;}
var cursor=store.openCursor(null,'prev');cursor.onsuccess=function onsuccess(event){var item=event.target.result;if(item&&item.value){callback(item.value);}else{callback(null);}};cursor.onerror=function onerror(event){callback(event.target.error.name);};});},_updateCacheRevision:function _updateCacheRevision(){Contacts.getRevision(function(contactsRevision){if(contactsRevision){window.asyncStorage.setItem('contactCacheRevision',contactsRevision);}});},updateGroupContactInfo:function updateGroupContactInfo(contact,matchingTel,callback){var self=this;this._newTxn('readwrite',[this._dbGroupsStore],function(error,txn,store){var result;if(error){self._asyncReturn(callback,error);return;}
if(!contact){self._asyncReturn(callback,0);return;}
txn.oncomplete=function(){self._asyncReturn(callback,result);};var count=0;var req=store.index('number').openCursor(IDBKeyRange.only(matchingTel.value));req.onsuccess=function onsuccess(event){var cursor=event.target.result;if(cursor&&cursor.value){var group=cursor.value;group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){group.contactPhoto=photo;}
if(matchingTel){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)&&primaryInfo[0]){primaryInfo=primaryInfo[0];}
group.contactPrimaryInfo=String(primaryInfo);if(Array.isArray(matchingTel.type)&&matchingTel.type[0]){group.contactMatchingTelType=String(matchingTel.type[0]);}
if(matchingTel.carrier){group.contactMatchingTelCarrier=String(matchingTel.carrier);}}
cursor.update(group);count++;cursor.continue();}else{result=count;self._updateCacheRevision();}};req.onerror=function onerror(event){result=event.target.error;};});},removeGroupContactInfo:function removeGroupContactInfo(contactId,group,callback){if(!contactId&&!group){this._asyncReturn(callback,0);return;}
var self=this;this._newTxn('readwrite',[this._dbGroupsStore],function(error,txn,store){if(error){self._asyncReturn(callback,error);callback(error);return;}
var count=0;txn.oncomplete=function(){self._asyncReturn(callback,count);self._updateCacheRevision();};txn.onerror=function(event){self._asyncReturn(callback,event.target.error);};var req;if(contactId){req=store.index('contactId').openCursor(contactId);}else if(group){var groupId=self._getGroupId(group);req=store.openCursor(groupId);}
req.onsuccess=function onsuccess(event){var cursor=event.target.result;if(cursor){var group=cursor.value;if(group.contactId){delete group.contactId;}
if(group.contactPrimaryInfo){delete group.contactPrimaryInfo;}
if(group.contactMatchingTelType){delete group.contactMatchingTelType;}
if(group.contactMatchingTelCarrier){delete group.contactMatchingTelCarrier;}
if(group.contactPhoto){delete group.contactPhoto;}
cursor.update(group);count++;cursor.continue();}};});},_gatherAllGroups:function _gatherAllGroups(){var self=this;return new Promise(function(resolve,reject){var groups=[];self._newTxn('readonly',[self._dbGroupsStore],function(error,txn,store){if(error){reject(error);return;}
txn.oncomplete=function(){resolve(groups);};txn.onerror=function(event){reject(event.target.error);};var req=store.openCursor();req.onsuccess=function onsuccess(event){var cursor=event.target.result;if(!cursor){return;}
groups.push(cursor.value);cursor.continue();};});});},_updateGroup:function _updateGroup(group){return new Promise(function(resolve,reject){Contacts.findByNumber(group.number,function update(contact,matchingTel){var needsUpdate=false;if(!contact&&!matchingTel){if(group.contactId){needsUpdate=true;delete group.contactId;}
if(group.contactPhoto){needsUpdate=true;delete group.contactPhoto;}
if(group.contactPrimaryInfo){needsUpdate=true;delete group.contactPrimaryInfo;}
if(group.contactMatchingTelType){needsUpdate=true;delete group.contactMatchingTelType;}
if(group.contactMatchingTelCarrier){needsUpdate=true;delete group.contactMatchingTelCarrier;}}else{group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo&&group.contactPhoto!=photo){group.contactPhoto=photo;needsUpdate=true;}
var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)&&primaryInfo[0]){primaryInfo=primaryInfo[0];}
if(group.contactPrimaryInfo!=String(primaryInfo)){group.contactPrimaryInfo=String(primaryInfo);needsUpdate=true;}
if(Array.isArray(matchingTel.type)&&matchingTel.type[0]&&group.contactMatchingTelType!=String(matchingTel.type[0])){group.contactMatchingTelType=String(matchingTel.type[0]);needsUpdate=true;}
if(matchingTel.carrier&&group.contactMatchingTelCarrier!=String(matchingTel.carrier)){group.contactMatchingTelCarrier=String(matchingTel.carrier);needsUpdate=true;}}
resolve(needsUpdate?group:null);});});},invalidateContactsCache:function invalidateContactsCache(callback){var self=this;this._gatherAllGroups().then(function(groups){var promises=[];for(var i=0;i<groups.length;i++){promises.push(self._updateGroup(groups[i]));}
return Promise.all(promises);}).then(function(updatedGroups){self._newTxn('readwrite',[self._dbGroupsStore],function(error,txn,store){if(error){self._asyncReturn(callback,error);return;}
txn.oncomplete=function onContactsUpdated(){self._updateCacheRevision();self._asyncReturn(callback);};txn.onerror=function(event){self._asyncReturn(callback,event.target.error);};for(var i=0;i<updatedGroups.length;i++){if(updatedGroups[i]){store.put(updatedGroups[i]);}}});});}};;'use strict';const ALWAYS_ASK_OPTION_VALUE=-1;var MultiSimActionButton=function MultiSimActionButton(button,callCallback,settingsKey,phoneNumberGetter){this._button=button;this._callCallback=callCallback;this._settingsKey=settingsKey;this._phoneNumberGetter=phoneNumberGetter;this._simPicker=null;this._button.addEventListener('click',this._click.bind(this));var self=this;LazyLoader.load(['/shared/js/settings_listener.js'],function(){SettingsListener.observe(settingsKey,0,self._settingsObserver.bind(self));});if(navigator.mozIccManager&&navigator.mozIccManager.iccIds.length>1){this._button.addEventListener('contextmenu',this._contextmenu.bind(this));this._simIndication=this._button.querySelector('.js-sim-indication');var telephony=navigator.mozTelephony;if(telephony){telephony.addEventListener('callschanged',self._updateUI.bind(self));}}};MultiSimActionButton.prototype._settingsObserver=function(cardIndex){this._defaultCardIndex=cardIndex;this._updateUI();if(this._clickQueued){this._clickQueued=false;this._click();}};MultiSimActionButton.prototype._getCardIndexIfLoaded=function(){if(window.TelephonyHelper){var inUseSim=window.TelephonyHelper.getInUseSim();if(inUseSim!==null){return inUseSim;}}
return this._defaultCardIndex;};MultiSimActionButton.prototype._click=function(event){if(event){event.preventDefault();}
var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(!navigator.mozIccManager||phoneNumber===''){return;}
if(event){event.stopImmediatePropagation();}
if(navigator.mozIccManager.iccIds.length===0){this.performAction(0);return;}
var cardIndex=this._getCardIndexIfLoaded();if(cardIndex===undefined){this._clickQueued=true;return;}
if(cardIndex===ALWAYS_ASK_OPTION_VALUE){this._getOrPickSim(cardIndex,phoneNumber);}else{this.performAction(cardIndex);}};MultiSimActionButton.prototype._getOrPickSim=function(cardIndex,phoneNumber){var self=this;LazyLoader.load(['/shared/elements/gaia_sim_picker/script.js'],function(){self._simPicker=document.getElementById('sim-picker');self._simPicker.getOrPick(cardIndex,phoneNumber,self.performAction.bind(self));});};MultiSimActionButton.prototype._updateUI=function(){var cardIndex=this._getCardIndexIfLoaded();if(cardIndex>=0&&navigator.mozIccManager&&navigator.mozIccManager.iccIds.length>1){if(this._simIndication){var self=this;var l10nId=this._simIndication.dataset.l10nId||'gaia-sim-picker-button';navigator.mozL10n.ready(function(){navigator.mozL10n.setAttributes(self._simIndication,l10nId,{n:cardIndex+1});});}
document.body.classList.add('has-preferred-sim');}else{document.body.classList.remove('has-preferred-sim');}};MultiSimActionButton.prototype._contextmenu=function(event){var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(!navigator.mozIccManager||navigator.mozIccManager.iccIds.length===0||phoneNumber===''||event.target.disabled||(window.TelephonyHelper&&window.TelephonyHelper.getInUseSim()!==null)){return;}
if(this._getCardIndexIfLoaded()===undefined){return;}
if(event){event.preventDefault();}
this._getOrPickSim(this._getCardIndexIfLoaded(),phoneNumber);};MultiSimActionButton.prototype.performAction=function(cardIndex){var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(phoneNumber===''){return;}
if(cardIndex===undefined){cardIndex=this._getCardIndexIfLoaded();}
this._callCallback(phoneNumber,cardIndex);};;'use strict';(function(window){window.mozPerformance={timing:{}};function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();var epoch=Date.now();setTimeout(function(){var detail={name:name,timestamp:now,epoch:epoch};var event=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(event);});}
['moz-chrome-dom-loaded','moz-chrome-interactive','moz-app-visually-complete','moz-content-interactive','moz-app-loaded'].forEach(function(eventName){window.addEventListener(eventName,function mozPerfLoadHandler(){dispatch(eventName);},false);});window.PerformanceTestingHelper={dispatch:dispatch};})(window);