"use strict";let DEBUG=0;let debug;if(DEBUG){debug=function(s){dump("-*- IndexedDBHelper: "+s+"\n");}}else{debug=function(s){}}
const Cu=Components.utils;const Cc=Components.classes;const Ci=Components.interfaces;this.EXPORTED_SYMBOLS=["IndexedDBHelper"];Cu.import("resource://gre/modules/XPCOMUtils.jsm");Cu.importGlobalProperties(["indexedDB"]);XPCOMUtils.defineLazyModuleGetter(this,'Services','resource://gre/modules/Services.jsm');this.IndexedDBHelper=function IndexedDBHelper(){}
IndexedDBHelper.prototype={ _db:null, close:function close(){if(this._db){this._db.close();this._db=null;}},open:function open(aSuccessCb,aFailureCb){let self=this;if(DEBUG)debug("Try to open database:"+self.dbName+" "+self.dbVersion);let req=indexedDB.open(this.dbName,this.dbVersion);req.onsuccess=function(event){if(DEBUG)debug("Opened database:"+self.dbName+" "+self.dbVersion);self._db=event.target.result;self._db.onversionchange=function(event){if(DEBUG)debug("WARNING: DB modified from a different window.");}
aSuccessCb&&aSuccessCb();};req.onupgradeneeded=function(aEvent){if(DEBUG){debug("Database needs upgrade:"+self.dbName+aEvent.oldVersion+aEvent.newVersion);debug("Correct new database version:"+(aEvent.newVersion==this.dbVersion));}
let _db=aEvent.target.result;self.upgradeSchema(req.transaction,_db,aEvent.oldVersion,aEvent.newVersion);};req.onerror=function(aEvent){if(DEBUG)debug("Failed to open database: "+self.dbName);aFailureCb&&aFailureCb(aEvent.target.error.name);};req.onblocked=function(aEvent){if(DEBUG)debug("Opening database request is blocked.");};},ensureDB:function ensureDB(aSuccessCb,aFailureCb){if(this._db){if(DEBUG)debug("ensureDB: already have a database, returning early.");if(aSuccessCb){Services.tm.currentThread.dispatch(aSuccessCb,Ci.nsIThread.DISPATCH_NORMAL);}
return;}
this.open(aSuccessCb,aFailureCb);},newTxn:function newTxn(txn_type,store_name,callback,successCb,failureCb){this.ensureDB(function(){if(DEBUG)debug("Starting new transaction"+txn_type);let txn=this._db.transaction(Array.isArray(store_name)?store_name:this.dbStoreNames,txn_type);if(DEBUG)debug("Retrieving object store",this.dbName);let stores;if(Array.isArray(store_name)){stores=[];for(let i=0;i<store_name.length;++i){stores.push(txn.objectStore(store_name[i]));}}else{stores=txn.objectStore(store_name);}
txn.oncomplete=function(event){if(DEBUG)debug("Transaction complete. Returning to callback.");if(successCb){successCb(txn.result);}};txn.onabort=function(event){if(DEBUG)debug("Caught error on transaction");if(failureCb){if(event.target.error){failureCb(event.target.error.name);}else{failureCb("UnknownError");}}};callback(txn,stores);}.bind(this),failureCb);},initDBHelper:function initDBHelper(aDBName,aDBVersion,aDBStoreNames){this.dbName=aDBName;this.dbVersion=aDBVersion;this.dbStoreNames=aDBStoreNames;}}