"use strict";module.metadata={"stability":"stable"};const{Cc,Ci,Cr}=require("chrome");const apiUtils=require("./deprecated/api-utils");const errors=require("./deprecated/errors");const{isString,isUndefined,instanceOf}=require('./lang/type');const{URL,isLocalURL}=require('./url');const{data}=require('./self');const NOTIFICATION_DIRECTIONS=["auto","ltr","rtl"];try{let alertServ=Cc["@mozilla.org/alerts-service;1"].getService(Ci.nsIAlertsService);var notify=alertServ.showAlertNotification.bind(alertServ);}
catch(err){

notify=notifyUsingConsole;}
exports.notify=function notifications_notify(options){let valOpts=validateOptions(options);let clickObserver=!valOpts.onClick?null:{observe:function notificationClickObserved(subject,topic,data){if(topic==="alertclickcallback")
errors.catchAndLog(valOpts.onClick).call(exports,valOpts.data);}};function notifyWithOpts(notifyFn){let{iconURL}=valOpts;iconURL=iconURL&&isLocalURL(iconURL)?data.url(iconURL):iconURL;notifyFn(iconURL,valOpts.title,valOpts.text,!!clickObserver,valOpts.data,clickObserver,valOpts.tag,valOpts.dir,valOpts.lang);}
try{notifyWithOpts(notify);}
catch(err){if(err instanceof Ci.nsIException&&err.result==Cr.NS_ERROR_FILE_NOT_FOUND){console.warn("The notification icon named by "+iconURL+" does not exist.  A default icon will be used instead.");delete valOpts.iconURL;notifyWithOpts(notify);}
else{notifyWithOpts(notifyUsingConsole);}}};function notifyUsingConsole(iconURL,title,text){title=title?"["+title+"]":"";text=text||"";let str=[title,text].filter(function(s)s).join(" ");console.log(str);}
function validateOptions(options){return apiUtils.validateOptions(options,{data:{is:["string","undefined"]},iconURL:{is:["string","undefined","object"],ok:function(value){return isUndefined(value)||isString(value)||(value instanceof URL);},msg:"`iconURL` must be a string or an URL instance."},onClick:{is:["function","undefined"]},text:{is:["string","undefined","number"]},title:{is:["string","undefined","number"]},tag:{is:["string","undefined","number"]},dir:{is:["string","undefined"],ok:function(value){return isUndefined(value)||~NOTIFICATION_DIRECTIONS.indexOf(value);},msg:'`dir` option must be one of: "auto", "ltr" or "rtl".'},lang:{is:["string","undefined"]}});}