"use strict";this.EXPORTED_SYMBOLS=["FirefoxAccounts"];const{classes:Cc,interfaces:Ci,utils:Cu}=Components;Cu.import("resource://gre/modules/Log.jsm");Cu.import("resource://gre/modules/XPCOMUtils.jsm");Cu.import("resource://gre/modules/Services.jsm");Cu.import("resource://gre/modules/identity/LogUtils.jsm");XPCOMUtils.defineLazyModuleGetter(this,"objectCopy","resource://gre/modules/identity/IdentityUtils.jsm");XPCOMUtils.defineLazyModuleGetter(this,"makeMessageObject","resource://gre/modules/identity/IdentityUtils.jsm");
const PREF_LOG_LEVEL="identity.fxaccounts.loglevel";try{this.LOG_LEVEL=Services.prefs.getPrefType(PREF_LOG_LEVEL)==Ci.nsIPrefBranch.PREF_STRING&&Services.prefs.getCharPref(PREF_LOG_LEVEL);}catch(e){this.LOG_LEVEL=Log.Level.Error;}
let log=Log.repository.getLogger("Identity.FxAccounts");log.level=LOG_LEVEL;log.addAppender(new Log.ConsoleAppender(new Log.BasicFormatter()));XPCOMUtils.defineLazyModuleGetter(this,"FxAccountsManager","resource://gre/modules/FxAccountsManager.jsm","FxAccountsManager");Cu.import("resource://gre/modules/FxAccountsCommon.js");function FxAccountsService(){Services.obs.addObserver(this,"quit-application-granted",false);if(ONVERIFIED_NOTIFICATION){Services.obs.addObserver(this,ONVERIFIED_NOTIFICATION,false);Services.obs.addObserver(this,ONLOGIN_NOTIFICATION,false);Services.obs.addObserver(this,ONLOGOUT_NOTIFICATION,false);} 
this.RP=this;this._rpFlows=new Map(); this.fxAccountsManager=FxAccountsManager;}
FxAccountsService.prototype={QueryInterface:XPCOMUtils.generateQI([Ci.nsISupports,Ci.nsIObserver]),observe:function observe(aSubject,aTopic,aData){switch(aTopic){case null: break;case ONVERIFIED_NOTIFICATION:log.debug("Received "+ONVERIFIED_NOTIFICATION+"; firing request()s");for(let[rpId,]of this._rpFlows){this.request(rpId);}
break;case ONLOGIN_NOTIFICATION:log.debug("Received "+ONLOGIN_NOTIFICATION+"; doLogin()s fired");for(let[rpId,]of this._rpFlows){this.request(rpId);}
break;case ONLOGOUT_NOTIFICATION:log.debug("Received "+ONLOGOUT_NOTIFICATION+"; doLogout()s fired");for(let[rpId,]of this._rpFlows){this.doLogout(rpId);}
break;case"quit-application-granted":Services.obs.removeObserver(this,"quit-application-granted");if(ONVERIFIED_NOTIFICATION){Services.obs.removeObserver(this,ONVERIFIED_NOTIFICATION);Services.obs.removeObserver(this,ONLOGIN_NOTIFICATION);Services.obs.removeObserver(this,ONLOGOUT_NOTIFICATION);}
break;}},cleanupRPRequest:function(aRp){aRp.pendingRequest=false;this._rpFlows.set(aRp.id,aRp);},watch:function watch(aRpCaller){this._rpFlows.set(aRpCaller.id,aRpCaller);log.debug("watch: "+aRpCaller.id);log.debug("Current rp flows: "+this._rpFlows.size);let runnable={run:()=>{this.fxAccountsManager.getAssertion(aRpCaller.audience,aRpCaller.principal,{silent:true}).then(data=>{if(data){this.doLogin(aRpCaller.id,data);}else{this.doLogout(aRpCaller.id);}
this.doReady(aRpCaller.id);},error=>{log.error("get silent assertion failed: "+JSON.stringify(error));this.doError(aRpCaller.id,error);});}};Services.tm.currentThread.dispatch(runnable,Ci.nsIThread.DISPATCH_NORMAL);},unwatch:function(aRpCallerId,aTargetMM){log.debug("unwatching: "+aRpCallerId);this._rpFlows.delete(aRpCallerId);},request:function request(aRPId,aOptions){aOptions=aOptions||{};let rp=this._rpFlows.get(aRPId);if(!rp){log.error("request() called before watch()");return;}


if(rp.pendingRequest){log.debug("request() already called");return;}
rp.pendingRequest=true;this._rpFlows.set(rp.id,rp);let options=makeMessageObject(rp);objectCopy(aOptions,options);log.debug("get assertion for "+rp.audience);this.fxAccountsManager.getAssertion(rp.audience,rp.principal,options).then(data=>{log.debug("got assertion for "+rp.audience+": "+data);this.doLogin(aRPId,data);},error=>{log.debug("get assertion failed: "+JSON.stringify(error));if((error.error&&(error.error.details=="DIALOG_CLOSED_BY_USER"))||(error.details=="DIALOG_CLOSED_BY_USER")){return this.doCancel(aRPId);}
this.doError(aRPId,error);}).then(()=>{this.cleanupRPRequest(rp);}).catch(()=>{this.cleanupRPRequest(rp);});},logout:function logout(aRpCallerId){

if(!this._rpFlows.has(aRpCallerId)){log.error("logout() called before watch()");return;} 
let runnable={run:()=>{this.fxAccountsManager.signOut().then(()=>{this.doLogout(aRpCallerId);});}};Services.tm.currentThread.dispatch(runnable,Ci.nsIThread.DISPATCH_NORMAL);},childProcessShutdown:function childProcessShutdown(messageManager){for(let[key,]of this._rpFlows){if(this._rpFlows.get(key)._mm===messageManager){this._rpFlows.delete(key);}}},doLogin:function doLogin(aRpCallerId,aAssertion){let rp=this._rpFlows.get(aRpCallerId);if(!rp){log.warn("doLogin found no rp to go with callerId "+aRpCallerId);return;}
rp.doLogin(aAssertion);},doLogout:function doLogout(aRpCallerId){let rp=this._rpFlows.get(aRpCallerId);if(!rp){log.warn("doLogout found no rp to go with callerId "+aRpCallerId);return;}
rp.doLogout();},doReady:function doReady(aRpCallerId){let rp=this._rpFlows.get(aRpCallerId);if(!rp){log.warn("doReady found no rp to go with callerId "+aRpCallerId);return;}
rp.doReady();},doCancel:function doCancel(aRpCallerId){let rp=this._rpFlows.get(aRpCallerId);if(!rp){log.warn("doCancel found no rp to go with callerId "+aRpCallerId);return;}
rp.doCancel();},doError:function doError(aRpCallerId,aError){let rp=this._rpFlows.get(aRpCallerId);if(!rp){log.warn("doError found no rp to go with callerId "+aRpCallerId);return;}
rp.doError(aError);}};this.FirefoxAccounts=new FxAccountsService();