;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';(function(){var loader=LazyLoader;window.LazyL10n={_inDOM:false,_loaded:false,get:function ll10n_get(callback){if(this._loaded){callback(navigator.mozL10n.get);return;}
if(this._inDOM){this._waitForLoadAndDate(callback);return;}
loader.load(['/shared/js/l10n.js']);this._waitForLoadAndDate(function baseLoaded(){callback(navigator.mozL10n.get);});this._inDOM=true;},_waitForLoadAndDate:function ll10n_waitForLoadAndDate(callback){var finalize=this._finalize.bind(this);window.addEventListener('localized',function onLocalized(){window.removeEventListener('localized',onLocalized);loader.load('/shared/js/l10n_date.js',function(){finalize(callback);});});},_finalize:function ll10n_finalize(callback){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;this._loaded=true;callback(navigator.mozL10n.get);}};}());;'use strict';window.addEventListener('load',function callSetup(evt){window.removeEventListener('load',callSetup);CallsHandler.setup();CallScreen.init();KeypadManager.init(true);});document.addEventListener('visibilitychange',function visibilitychanged(){if(document.hidden){TonePlayer.trashAudio();}else{TonePlayer.ensureAudio();}});;'use strict';var SettingsListener={_timer:null,_lock:null,getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));settings.addObserver(name,function settingChanged(evt){callback(evt.settingValue);});}};;'use strict';function SettingsURL(){this._url=null;this._isBlob=false;}
SettingsURL.prototype={set:function(value){if(this._isBlob){window.URL.revokeObjectURL(this._url);}
if(value instanceof Blob){this._isBlob=true;this._url=window.URL.createObjectURL(value);}else{this._isBlob=false;this._url=value;}
return this._url;},get:function(){return this._url;}};;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;(function(exports){'use strict';function getThumbnail(contact){return getOnePhoto(contact,'begin');}
function getFullResolution(contact){return getOnePhoto(contact,'end');}
function getOnePhoto(contact,position){if(!contact||!contact.photo||!contact.photo.length){return null;}
if(contact.photo.length===1){return contact.photo[0];}
var photos=contact.photo;var category=contact.category;if(Array.isArray(category)&&category.indexOf('fb_linked')!==-1){if(photos.length>=4){return photos[(position=='begin')?1:0];}
return photos[0];}
photos=photosBySize(contact);var index=(position=='begin')?0:photos.length-1;return photos[index];}
function photosBySize(contact){var photos=contact.photo.slice(0);photos.sort(function(p1,p2){if(size(p1)<size(p2)){return-1;}
if(size(p1)>size(p2)){return 1;}
return 0;});return photos;}
function size(photo){if(typeof photo=='string'){return photo.length;}
return photo.size;}
exports.ContactPhotoHelper={getThumbnail:getThumbnail,getFullResolution:getFullResolution};})(window);;'use strict';var SimplePhoneMatcher={mcc:'724',sanitizedNumber:function spm_sanitizedNumber(number){var join=this._formattingChars.join('|\\');var regexp=new RegExp('(\\'+join+')','g');return number.replace(regexp,'');},generateVariants:function spm_generateVariants(number){var sanitizedNumber=this.sanitizedNumber(number);var variants=[];variants=variants.concat(this._internationalPrefixes(sanitizedNumber),this._trunkPrefixes(sanitizedNumber),this._carrierPrefixes(sanitizedNumber),this._areaPrefixes(sanitizedNumber));return variants.sort(function shortestFirst(a,b){return a.length>b.length;});},bestMatch:function spm_bestMatchIndex(variants,matches){var bestMatchIndex=0;var bestLocalIndex=0;var bestMatchLength=0;var allMatches=[];var matchNum=0;matches.forEach(function(match,matchIndex){var indexes=[];match.forEach(function(number,localIndex){var sanitizedNumber=this.sanitizedNumber(number);variants.forEach(function match(variant){if(variant.indexOf(sanitizedNumber)!==-1||sanitizedNumber.indexOf(variant)!==-1){var length=sanitizedNumber.length;if(indexes.indexOf(localIndex)===-1){indexes.push(localIndex);matchNum+=1;}
if(length>bestMatchLength){bestMatchLength=length;bestMatchIndex=matchIndex;bestLocalIndex=localIndex;}}});},this);if(indexes.length){allMatches.push(indexes);}else{matchNum+=1;allMatches.push([0]);}},this);return{totalMatchNum:matchNum,allMatches:allMatches,bestMatchIndex:bestMatchIndex,localIndex:bestLocalIndex};},_formattingChars:['\s','-','.','(',')'],_mccWith00Prefix:['208','214','234','235','724'],_mccWith011Prefix:['310','311','312','313','314','315','316'],_countryPrefixes:[{p:'1',t:false},{p:'1242',t:false},{p:'1246',t:false},{p:'1264',t:false},{p:'1268',t:false},{p:'1284',t:false},{p:'1340',t:false},{p:'1345',t:false},{p:'1441',t:false},{p:'1473',t:false},{p:'1649',t:false},{p:'1664',t:false},{p:'1670',t:false},{p:'1671',t:false},{p:'1684',t:false},{p:'1721',t:false},{p:'1758',t:false},{p:'1767',t:false},{p:'1784',t:false},{p:'1787',t:false},{p:'1809',t:false},{p:'1829',t:false},{p:'1849',t:false},{p:'1868',t:false},{p:'1869',t:false},{p:'1876',t:false},{p:'1939',t:false},{p:'20',t:false},{p:'210',t:false},{p:'211',t:false},{p:'212',t:false},{p:'213',t:false},{p:'214',t:false},{p:'215',t:false},{p:'216',t:false},{p:'217',t:false},{p:'218',t:false},{p:'219',t:false},{p:'220',t:false},{p:'221',t:false},{p:'222',t:false},{p:'223',t:false},{p:'224',t:false},{p:'225',t:false},{p:'226',t:false},{p:'227',t:false},{p:'228',t:false},{p:'229',t:false},{p:'230',t:false},{p:'231',t:false},{p:'232',t:false},{p:'233',t:false},{p:'234',t:false},{p:'235',t:false},{p:'236',t:false},{p:'237',t:false},{p:'238',t:false},{p:'239',t:false},{p:'240',t:false},{p:'241',t:false},{p:'242',t:false},{p:'243',t:false},{p:'244',t:false},{p:'245',t:false},{p:'246',t:false},{p:'247',t:false},{p:'248',t:false},{p:'249',t:false},{p:'250',t:false},{p:'251',t:false},{p:'252',t:false},{p:'253',t:false},{p:'254',t:false},{p:'255',t:false},{p:'256',t:false},{p:'257',t:false},{p:'258',t:false},{p:'259',t:false},{p:'260',t:false},{p:'261',t:false},{p:'262',t:false},{p:'263',t:false},{p:'264',t:false},{p:'265',t:false},{p:'266',t:false},{p:'267',t:false},{p:'268',t:false},{p:'269',t:false},{p:'27',t:false},{p:'28',t:false},{p:'290',t:false},{p:'291',t:false},{p:'292',t:false},{p:'293',t:false},{p:'294',t:false},{p:'295',t:false},{p:'296',t:false},{p:'297',t:false},{p:'298',t:false},{p:'299',t:false},{p:'30',t:false},{p:'31',t:true},{p:'32',t:true},{p:'33',t:true},{p:'34',t:false},{p:'350',t:false},{p:'351',t:true},{p:'352',t:false},{p:'353',t:false},{p:'354',t:false},{p:'355',t:true},{p:'356',t:false},{p:'357',t:false},{p:'358',t:false},{p:'359',t:true},{p:'36',t:true},{p:'370',t:true},{p:'371',t:false},{p:'372',t:false},{p:'373',t:true},{p:'374',t:false},{p:'375',t:true},{p:'376',t:false},{p:'377',t:false},{p:'378',t:false},{p:'379',t:false},{p:'380',t:true},{p:'381',t:true},{p:'382',t:true},{p:'383',t:false},{p:'384',t:false},{p:'385',t:true},{p:'386',t:false},{p:'387',t:true},{p:'388',t:false},{p:'389',t:true},{p:'39',t:false},{p:'40',t:true},{p:'41',t:true},{p:'420',t:false},{p:'421',t:false},{p:'422',t:false},{p:'423',t:false},{p:'424',t:false},{p:'425',t:false},{p:'426',t:false},{p:'427',t:false},{p:'428',t:false},{p:'429',t:false},{p:'43',t:true},{p:'44',t:true},{p:'45',t:false},{p:'46',t:true},{p:'47',t:false},{p:'48',t:true},{p:'49',t:true},{p:'500',t:false},{p:'501',t:false},{p:'502',t:false},{p:'503',t:false},{p:'504',t:false},{p:'505',t:false},{p:'506',t:false},{p:'507',t:false},{p:'508',t:false},{p:'509',t:false},{p:'51',t:true},{p:'52',t:false},{p:'53',t:false},{p:'54',t:true},{p:'55',t:true},{p:'56',t:false},{p:'57',t:false},{p:'58',t:false},{p:'590',t:false},{p:'591',t:true},{p:'592',t:false},{p:'593',t:false},{p:'594',t:false},{p:'595',t:false},{p:'596',t:false},{p:'597',t:false},{p:'598',t:false},{p:'599',t:true},{p:'60',t:true},{p:'61',t:true},{p:'62',t:true},{p:'63',t:true},{p:'64',t:false},{p:'65',t:true},{p:'66',t:true},{p:'670',t:false},{p:'671',t:false},{p:'672',t:false},{p:'673',t:true},{p:'674',t:false},{p:'675',t:false},{p:'676',t:false},{p:'677',t:false},{p:'678',t:false},{p:'679',t:false},{p:'680',t:false},{p:'681',t:false},{p:'682',t:false},{p:'683',t:false},{p:'684',t:false},{p:'685',t:false},{p:'686',t:false},{p:'687',t:false},{p:'688',t:false},{p:'689',t:false},{p:'690',t:false},{p:'691',t:false},{p:'692',t:false},{p:'693',t:false},{p:'694',t:false},{p:'695',t:false},{p:'696',t:false},{p:'697',t:false},{p:'698',t:false},{p:'699',t:false},{p:'699',t:false},{p:'7',t:true},{p:'76',t:true},{p:'77',t:true},{p:'7840',t:false},{p:'7940',t:false},{p:'800',t:false},{p:'801',t:false},{p:'802',t:false},{p:'803',t:false},{p:'804',t:false},{p:'805',t:false},{p:'806',t:false},{p:'807',t:false},{p:'808',t:false},{p:'809',t:false},{p:'81',t:false},{p:'82',t:true},{p:'83',t:false},{p:'84',t:true},{p:'850',t:true},{p:'851',t:false},{p:'852',t:false},{p:'853',t:false},{p:'854',t:false},{p:'855',t:true},{p:'856',t:true},{p:'857',t:false},{p:'858',t:false},{p:'859',t:false},{p:'86',t:true},{p:'870',t:false},{p:'871',t:false},{p:'872',t:false},{p:'873',t:false},{p:'874',t:false},{p:'875',t:false},{p:'876',t:false},{p:'877',t:false},{p:'878',t:false},{p:'879',t:false},{p:'880',t:true},{p:'881',t:false},{p:'882',t:false},{p:'883',t:false},{p:'884',t:false},{p:'885',t:false},{p:'886',t:true},{p:'887',t:false},{p:'888',t:false},{p:'889',t:false},{p:'89',t:false},{p:'90',t:false},{p:'91',t:true},{p:'92',t:true},{p:'93',t:true},{p:'94',t:false},{p:'95',t:true},{p:'960',t:false},{p:'961',t:false},{p:'962',t:false},{p:'963',t:false},{p:'964',t:false},{p:'965',t:false},{p:'966',t:false},{p:'967',t:false},{p:'968',t:false},{p:'969',t:false},{p:'970',t:false},{p:'971',t:false},{p:'972',t:false},{p:'973',t:false},{p:'974',t:false},{p:'975',t:true},{p:'976',t:true},{p:'977',t:true},{p:'978',t:false},{p:'979',t:false},{p:'98',t:false},{p:'990',t:false},{p:'991',t:false},{p:'992',t:false},{p:'993',t:true},{p:'994',t:true},{p:'995',t:true},{p:'996',t:false},{p:'997',t:false},{p:'998',t:true},{p:'999',t:false}],_trunkCodes:['0'],_areaCodeSwipe:{'55':2,'44':3,'1':3},_internationalPrefixes:function spm_internatialPrefixes(number){var variants=[number];var internationalPrefix='';if(this._mccWith00Prefix.indexOf(this.mcc)!==-1){internationalPrefix='00';}
if(this._mccWith011Prefix.indexOf(this.mcc)!==-1){internationalPrefix='011';}
var plusRegexp=new RegExp('^\\+');if(number.match(plusRegexp)){variants.push(number.replace(plusRegexp,internationalPrefix));}
var ipRegexp=new RegExp('^'+internationalPrefix);if(number.match(ipRegexp)){variants.push(number.replace(ipRegexp,'+'));}
return variants;},_trunkPrefixes:function spm_trunkPrefixes(number){var variants=[];var prefixesWithTrunk0=[];var prefixesWithNoTrunk=[];this._countryPrefixes.forEach(function(prefix){if(prefix.t){prefixesWithTrunk0.push(prefix.p);}else{prefixesWithNoTrunk.push(prefix.p);}});var trunk0Join=prefixesWithTrunk0.join('|');var trunk0Regexp=new RegExp('^\\+('+trunk0Join+')');this._internationalPrefixes(number).some(function match(variant){var match=variant.match(trunk0Regexp);if(match){variants.push(variant.replace(trunk0Regexp,'0'));variants.push(variant.replace(trunk0Regexp,''));}
return match;});var noTrunkJoin=prefixesWithNoTrunk.join('|');var noTrunkRegexp=new RegExp('^\\+('+noTrunkJoin+')');this._internationalPrefixes(number).some(function match(variant){var match=variant.match(noTrunkRegexp);if(match){variants.push(variant.replace(noTrunkRegexp,''));}
return match;});var withTrunkRegexp=new RegExp('^('+this._trunkCodes.join('|')+')');if(number.match(withTrunkRegexp)){variants.push(number.replace(withTrunkRegexp,''));}
return variants;},_areaPrefixes:function spm_areaPrefixes(number){var variants=[];Object.keys(this._areaCodeSwipe).forEach(function(country){var re=new RegExp('^\\+'+country);this._internationalPrefixes(number).some(function match(variant){var match=variant.match(re);if(match){var afterArea=1+country.length+this._areaCodeSwipe[country];variants.push(variant.substring(afterArea));}
return match;},this);},this);return variants;},_carrierPrefixes:function spm_carrierPrefix(number){if(this.mcc!='724'){return[];}
var variants=[];var withTrunk=new RegExp('^0');if(number.length>=13&&number.match(withTrunk)){var afterCarrier=3;variants.push(number.substring(afterCarrier));}
return variants;}};;'use strict';var Contacts={_FB_FILES:['/shared/js/fb/fb_request.js','/shared/js/fb/fb_data_reader.js','/shared/js/fb/fb_reader_utils.js'],getRevision:function getRevision(callback){var mozContacts=navigator.mozContacts;if(!mozContacts){callback(null);return;}
var req=mozContacts.getRevision();req.onsuccess=function onsuccess(event){callback(event.target.result);};req.onerror=function onerror(event){console.log('Error '+event.target.error);callback(null);};},findByNumber:function findByNumber(number,callback){LazyLoader.load(this._FB_FILES,this._findByNumber.bind(this,number,callback));},_findByNumber:function _findByNumber(number,callback){if(!number){callback(null);return;}
var options;var variants;if(number.length<7){variants=[number];options={filterBy:['tel'],filterOp:'equals',filterValue:number};}else{variants=SimplePhoneMatcher.generateVariants(number);var sanitizedNumber=SimplePhoneMatcher.sanitizedNumber(number);options={filterBy:['tel'],filterOp:'match',filterValue:sanitizedNumber};}
var mozContacts=navigator.mozContacts;if(!mozContacts){callback(null);return;}
var request=mozContacts.find(options);request.onsuccess=function findCallback(){var contacts=request.result;if(contacts.length===0){window.asyncStorage.getItem('tokenData',function(data){if(!data||!data.access_token){callback(null);return;}
fb.getContactByNumber(number,function fb_ready(finalContact){var objMatching=null;if(finalContact){objMatching={value:number,type:'personal',carrier:null};}
callback(finalContact,objMatching);},function fb_err(err){callback(null);});});return;}
var matches=contacts.map(function getTels(contact){return contact.tel.map(function getNumber(tel){return tel.value;});});var matchResult=SimplePhoneMatcher.bestMatch(variants,matches);var contact=contacts[matchResult.bestMatchIndex];var contactsWithSameNumber;if(contacts.length>1){contactsWithSameNumber=contacts.length-1;}
var matchingTel=contact.tel[matchResult.localIndex];if(fb.isFbLinked(contact)){var req=fb.getData(contact);req.onsuccess=function(){callback(req.result,matchingTel,contactsWithSameNumber);};req.onerror=function(){window.console.error('Error while getting FB Data');callback(contact,matchingTel,contactsWithSameNumber);};}
else{callback(contact,matchingTel,contactsWithSameNumber);}};request.onerror=function findError(){callback(null);};},_mergeFbContacts:function _mergeFbContacts(contacts,callback){if(!callback||!(callback instanceof Function)){return;}
if(!contacts){callback(null);}
LazyLoader.load(this._FB_FILES,function(){for(var i=0,length=contacts.length;i<length;i++){if(fb.isFbContact(contacts[i])){var fbReq=fb.getData(contacts[i]);fbReq.onsuccess=function(){contacts[i]=fbReq.result;if(i===(length-1)){callback(contacts);}};fbReq.onerror=function(){console.error('Could not merge Facebook data');callback(contacts);};}else if(i===(length-1)){callback(contacts);}}});},_findContacts:function _findContacts(options,callback){if(!callback||!(callback instanceof Function)){return;}
if(!navigator.mozContacts||!options){callback(null);return;}
var self=this;var req=navigator.mozContacts.find(options);req.onsuccess=function onsuccess(){var contacts=req.result;if(!contacts.length){callback(null);return;}
window.asyncStorage.getItem('tokenData',function(data){if(data&&data.access_token){self._mergeFbContacts(contacts,callback);}else{callback(contacts);}});};req.onerror=function onerror(){console.error('Contact finding error. Error: '+req.errorCode);callback(null);};},findListByNumber:function findListByNumber(number,limit,callback){var self=this;asyncStorage.getItem('order.lastname',function(value){var sortKey=value?'familyName':'givenName';var options={filterBy:['tel'],filterOp:'contains',filterValue:number,sortBy:sortKey,sortOrder:'ascending',filterLimit:limit};self._findContacts(options,callback);});}};;'use strict';const kMasterVolume=0.5;const kToneVolume=0.7;const kShortPressDuration=0.15;const kAttackDuration=0.025;const kDecayDuration=0.025;const kReleaseDuration=0.05;var TonePlayer={_audioElement:null,_audioContext:null,_gainNode:null,_playingNodes:[],_tonesSamples:{'/shared/resources/media/tones/tone_1.opus':[697,1209],'/shared/resources/media/tones/tone_2.opus':[697,1336],'/shared/resources/media/tones/tone_3.opus':[697,1477],'/shared/resources/media/tones/tone_4.opus':[770,1209],'/shared/resources/media/tones/tone_5.opus':[770,1336],'/shared/resources/media/tones/tone_6.opus':[770,1477],'/shared/resources/media/tones/tone_7.opus':[852,1209],'/shared/resources/media/tones/tone_8.opus':[852,1336],'/shared/resources/media/tones/tone_9.opus':[852,1477],'/shared/resources/media/tones/tone_star.opus':[941,1209],'/shared/resources/media/tones/tone_0.opus':[941,1336],'/shared/resources/media/tones/tone_hash.opus':[941,1477]},init:function tp_init(channel){this.setChannel(channel);},ensureAudio:function tp_ensureAudio(){if(this._audioContext){return;}
this._audioContext=new AudioContext(this._channel);},trashAudio:function tp_trashAudio(){this.stop();if(this._channel==='telephony'&&this._audioContext){this._audioContext.mozAudioChannelType='normal';}
this._audioContext=null;this._channel=null;},dummySound:function tp_dummySound(callback){var context=this._audioContext;var gainNode=context.createGain();gainNode.gain.value=0.001;gainNode.connect(context.destination);var oscNode=context.createOscillator();oscNode.type='sine';oscNode.frequency.value=1000;oscNode.start(0);oscNode.stop(0.005);oscNode.connect(gainNode);setTimeout(callback);},_playSample:function tp_playSample(frequencies){if(!this._audioElement){this._audioElement=new Audio();}
var sample=this._audioElement;for(var i in this._tonesSamples){if((frequencies.length===2)&&(frequencies[0]===this._tonesSamples[i][0])&&(frequencies[1]===this._tonesSamples[i][1])){sample.src=i;break;}}
sample.volume=kMasterVolume;sample.play();},_startAt:function tp_startAt(frequencies,when,duration){var context=this._audioContext;var sampleRate=context.sampleRate;var envelope=context.createBuffer(1,(duration?duration:0.05)*sampleRate,sampleRate);for(var i=0;i<envelope.length;i++){var factor=kToneVolume;var t=i/sampleRate;if(t<=kAttackDuration){factor=t/kAttackDuration;}else if(t-kAttackDuration<=kDecayDuration){factor=1.0-(1.0-kToneVolume)*(t-kAttackDuration)/kDecayDuration;}
if(!duration){factor-=kToneVolume;}else if(t>duration-kReleaseDuration){factor*=(duration-t)/kReleaseDuration;}
envelope.getChannelData(0)[i]=factor*kMasterVolume;}
var gainNode=context.createGain();gainNode.connect(context.destination);if(!duration){this._gainNode=gainNode;}
var envelopeNode=context.createBufferSource();envelopeNode.buffer=envelope;envelopeNode.start(when);envelopeNode.connect(gainNode.gain);gainNode.gain.setValueAtTime(duration?0.0:kToneVolume*kMasterVolume,0.0);for(i=0;i<frequencies.length;++i){var oscNode=this._audioContext.createOscillator();oscNode.type='sine';oscNode.frequency.value=frequencies[i];oscNode.start(when);if(duration){oscNode.stop(Math.max(when,context.currentTime+0.5)+duration);}else{this._playingNodes.push(oscNode);}
oscNode.connect(gainNode);}},start:function tp_start(frequencies,shortPress){if(shortPress){this._playSample(frequencies);}else{this._startAt(frequencies,0,shortPress?kShortPressDuration:0);}},stop:function tp_stop(){if(!this._gainNode){return;}
var context=this._audioContext;var sampleRate=context.sampleRate;var gain=this._gainNode.gain;this._gainNode=null;var ramp=context.createBuffer(1,kReleaseDuration*sampleRate,sampleRate);for(var i=0;i<ramp.length;i++){ramp.getChannelData(0)[i]=(ramp.length-i-1)/ramp.length*kToneVolume*kMasterVolume;}
var rampNode=context.createBufferSource();rampNode.buffer=ramp;rampNode.start();rampNode.connect(gain);gain.setValueAtTime(0.0,0.0);while(this._playingNodes.length){this._playingNodes.pop().stop(context.currentTime+kReleaseDuration+0.5);}},playSequence:function tp_playSequence(sequence){this.ensureAudio();this.dummySound((function(){var when=this._audioContext.currentTime+0.2;for(var index=0;index<sequence.length;++index){var step=sequence[index];var frequencies=step.slice(0,2);var duration=step[2]/1000;this._startAt(frequencies,when,duration);when+=duration;}}).bind(this));},_channel:null,setChannel:function tp_setChannel(channel){if(!channel||this._channel===channel){return;}
this.trashAudio();this._channel=channel;this.ensureAudio();}};;'use strict';var kFontStep=4;var gTonesFrequencies={'1':[697,1209],'2':[697,1336],'3':[697,1477],'4':[770,1209],'5':[770,1336],'6':[770,1477],'7':[852,1209],'8':[852,1336],'9':[852,1477],'*':[941,1209],'0':[941,1336],'#':[941,1477]};function DtmfTone(tone,short,serviceId){this.tone=tone;this.short=short;this.serviceId=serviceId;this.timer=0;}
DtmfTone.prototype={play:function dt_play(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);navigator.mozTelephony.startTone(this.tone,this.serviceId);if(this.short){this.timer=window.setTimeout(function dt_stopTone(serviceId){navigator.mozTelephony.stopTone(serviceId);},DtmfTone.kShortToneLength,this.serviceId);}},stop:function dt_stop(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);}};DtmfTone.kShortToneLength=120;var KeypadManager={_MAX_FONT_SIZE_DIAL_PAD:18,_MAX_FONT_SIZE_ON_CALL:16,_phoneNumber:'',_onCall:false,_keypadSoundIsEnabled:false,_shortTone:false,onValueChanged:null,get phoneNumberView(){delete this.phoneNumberView;return this.phoneNumberView=document.getElementById('phone-number-view');},get fakePhoneNumberView(){delete this.fakePhoneNumberView;return this.fakePhoneNumberView=document.getElementById('fake-phone-number-view');},get phoneNumberViewContainer(){delete this.phoneNumberViewContainer;return this.phoneNumberViewContainer=document.getElementById('phone-number-view-container');},get keypad(){delete this.keypad;return this.keypad=document.getElementById('keypad');},get callBar(){delete this.callBar;return this.callBar=document.getElementById('keypad-callbar');},get hideBar(){delete this.hideBar;return this.hideBar=document.getElementById('keypad-hidebar');},get callBarAddContact(){delete this.callBarAddContact;return this.callBarAddContact=document.getElementById('keypad-callbar-add-contact');},get callBarCallAction(){delete this.callBarCallAction;return this.callBarCallAction=document.getElementById('keypad-callbar-call-action');},get callBarCancelAction(){delete this.callBarCancelAction;return this.callBarCancelAction=document.getElementById('keypad-callbar-cancel');},get deleteButton(){delete this.deleteButton;return this.deleteButton=document.getElementById('keypad-delete');},get hideBarHangUpAction(){delete this.hideBarHangUpAction;return this.hideBarHangUpAction=document.getElementById('keypad-hidebar-hang-up-action-wrapper');},get hideBarHideAction(){delete this.hideBarHideAction;return this.hideBarHideAction=document.getElementById('keypad-hidebar-hide-keypad-action');},multiSimActionButton:null,init:function kh_init(oncall){this._onCall=!!oncall;var defaultFontSize=window.getComputedStyle(document.body,null).getPropertyValue('font-size');this.minFontSize=parseInt(parseInt(defaultFontSize)*10*0.226);this.maxFontSize=this._onCall?parseInt(parseInt(defaultFontSize)*this._MAX_FONT_SIZE_ON_CALL*0.226):parseInt(parseInt(defaultFontSize)*this._MAX_FONT_SIZE_DIAL_PAD*0.226);this.phoneNumberView.value='';this._phoneNumber='';var keyHandler=this.keyHandler.bind(this);this.keypad.addEventListener('touchstart',keyHandler,true);this.keypad.addEventListener('touchend',keyHandler,true);this.keypad.addEventListener('touchmove',keyHandler,true);this.deleteButton.addEventListener('touchstart',keyHandler);this.deleteButton.addEventListener('touchend',keyHandler);if(this.callBarAddContact){this.callBarAddContact.addEventListener('click',this.addContact.bind(this));}
if(this.callBarCallAction){if(typeof MultiSimActionButton!=='undefined'){if(navigator.mozMobileConnections&&navigator.mozMobileConnections.length>1){var self=this;LazyL10n.get(function localized(_){self.multiSimActionButton=new MultiSimActionButton(self.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',self.phoneNumber.bind(self));});}else{this.multiSimActionButton=new MultiSimActionButton(this.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',this.phoneNumber.bind(this));}}
this.callBarCallAction.addEventListener('click',this.fetchLastCalled.bind(this));}
if(this.callBarCancelAction){this.callBarCancelAction.addEventListener('click',function(){window.parent.LockScreen.switchPanel();});}
if(this.hideBarHideAction){this.hideBarHideAction.addEventListener('click',this.callbarBackAction);}
if(this.hideBarHangUpAction){this.hideBarHangUpAction.addEventListener('click',this.hangUpCallFromKeypad);}
TonePlayer.init('normal');var channel=this._onCall?'telephony':'normal';window.addEventListener('visibilitychange',(function(){TonePlayer.setChannel(document.mozHidden?'normal':channel);}).bind(this));this.render();LazyLoader.load(['/shared/style/action_menu.css','/dialer/js/suggestion_bar.js']);this._observePreferences();},moveCaretToEnd:function hk_util_moveCaretToEnd(el){if(typeof el.selectionStart=='number'){el.selectionStart=el.selectionEnd=el.value.length;}else if(typeof el.createTextRange!='undefined'){el.focus();var range=el.createTextRange();range.collapse(false);range.select();}},render:function hk_render(layoutType){if(layoutType=='oncall'){if(CallsHandler.activeCall){this._phoneNumber=CallsHandler.activeCall.call.number;}
this._isKeypadClicked=false;this.phoneNumberViewContainer.classList.add('keypad-visible');if(this.callBar){this.callBar.classList.add('hide');}
if(this.hideBar){this.hideBar.classList.remove('hide');}
this.deleteButton.classList.add('hide');}else{this.phoneNumberViewContainer.classList.remove('keypad-visible');if(this.callBar){this.callBar.classList.remove('hide');}
if(this.hideBar){this.hideBar.classList.add('hide');}
this.deleteButton.classList.remove('hide');}},phoneNumber:function hk_phoneNumber(){return this._phoneNumber;},fetchLastCalled:function hk_fetchLastCalled(){if(this._phoneNumber!==''){return;}
var self=this;CallLogDBManager.getGroupAtPosition(1,'lastEntryDate',true,'dialing',function hk_ggap_callback(result){if(result&&(typeof result==='object')&&result.number){self.updatePhoneNumber(result.number);}});},addContact:function hk_addContact(event){var number=this._phoneNumber;if(!number){return;}
LazyLoader.load(['/dialer/js/phone_action_menu.js'],function hk_showPhoneNumberActionMenu(){PhoneNumberActionMenu.show(null,number,['new-contact','add-to-existent']);});},callbarBackAction:function hk_callbarBackAction(event){CallScreen.hideKeypad();},hangUpCallFromKeypad:function hk_hangUpCallFromKeypad(event){CallScreen.body.classList.remove('showKeypad');CallsHandler.end();},formatPhoneNumber:function kh_formatPhoneNumber(ellipsisSide,maxFontSize){var fakeView=this.fakePhoneNumberView;var view=this.phoneNumberView;if(view.value===''){view.style.fontSize=this.maxFontSize;return;}
var newFontSize;if(maxFontSize){newFontSize=this.maxFontSize;}else{newFontSize=Utils.getNextFontSize(view,fakeView,this.maxFontSize,this.minFontSize,kFontStep);}
view.style.fontSize=newFontSize+'px';Utils.addEllipsis(view,fakeView,ellipsisSide);},_lastPressedKey:null,_dtmfTone:null,_playDtmfTone:function kh_playDtmfTone(key){var serviceId=0;if(!this._onCall){return;}
if(CallsHandler.activeCall){serviceId=CallsHandler.activeCall.call.serviceId;}else{serviceId=navigator.mozTelephony.active.calls[0].serviceId;}
if(this._dtmfTone){this._dtmfTone.stop();this._dtmfTone=null;}
this._dtmfTone=new DtmfTone(key,this._shortTone,serviceId);this._dtmfTone.play();},_stopDtmfTone:function kh_stopDtmfTone(){if(!this._dtmfTone){return;}
this._dtmfTone.stop();this._dtmfTone=null;},_touchStart:function kh_touchStart(key,voicemail){this._longPress=false;this._lastPressedKey=key;if(key!='delete'){if(this._keypadSoundIsEnabled){TonePlayer.start(gTonesFrequencies[key],!this._onCall||this._shortTone);}
this._playDtmfTone(key);}
if((key=='0'&&!this._onCall)||key=='delete'){this._holdTimer=setTimeout(function(self){if(key=='delete'){self._phoneNumber='';}else{var index=self._phoneNumber.length-1;if(index>=0&&self._phoneNumber[index]==='0'){self._phoneNumber=self._phoneNumber.substr(0,index);}
self._phoneNumber+='+';}
self._longPress=true;self._updatePhoneNumberView('begin',false);},400,this);}
if(voicemail){this._holdTimer=setTimeout(function vm_call(self){self._longPress=true;self._callVoicemail();},1500,this);}
if(key=='delete'){this._phoneNumber=this._phoneNumber.slice(0,-1);}else if(this.phoneNumberViewContainer.classList.contains('keypad-visible')){if(!this._isKeypadClicked){this._isKeypadClicked=true;this._phoneNumber=key;this.replaceAdditionalContactInfo('');}else{this._phoneNumber+=key;}}else{this._phoneNumber+=key;}
setTimeout(function(self){self._updatePhoneNumberView('begin',false);},0,this);},_touchMove:function kh_touchMove(touch){var target=document.elementFromPoint(touch.pageX,touch.pageY);var key=target.dataset?target.dataset.value:null;if(key!==this._lastPressedKey||key==='delete'){this._stopDtmfTone();this._lastPressedKey=null;}},_touchEnd:function kh_touchEnd(key){if(key!=='delete'&&key===this._lastPressedKey){this._stopDtmfTone();this._lastPressedKey=null;}
if(this._keypadSoundIsEnabled){TonePlayer.stop();}
if(this._longPress){this._longPress=false;this._holdTimer=null;return;}
if(this._holdTimer){clearTimeout(this._holdTimer);}},keyHandler:function kh_keyHandler(event){var key=event.target.dataset.value;if(!key){return;}
if(key==='#'&&this._phoneNumber==='*#06#'){this.multiSimActionButton.performAction();return;}
if(key!='delete'&&this._phoneNumber.length>=50&&!this._onCall){return;}
event.stopPropagation();switch(event.type){case'touchstart':this._touchStart(key,event.target.dataset.voicemail);break;case'touchmove':this._touchMove(event.touches[0]);break;case'touchend':this._touchEnd(key);break;}},sanitizePhoneNumber:function(number){return number.replace(/\s+/g,'');},updatePhoneNumber:function kh_updatePhoneNumber(number,ellipsisSide,maxFontSize){number=this.sanitizePhoneNumber(number);this._phoneNumber=number;this._updatePhoneNumberView(ellipsisSide,maxFontSize);},press:function(value){this._playDtmfTone(value);TonePlayer.start(gTonesFrequencies[value],true);setTimeout((function nextTick(){TonePlayer.stop();this._stopDtmfTone();}).bind(this));},_updatePhoneNumberView:function kh_updatePhoneNumberview(ellipsisSide,maxFontSize){var phoneNumber=this._phoneNumber;if(this._onCall){this.replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize);}else{var visibility;if(phoneNumber.length>0){visibility='visible';this.callBarAddContact.classList.remove('disabled');}else{visibility='hidden';this.callBarAddContact.classList.add('disabled');}
this.deleteButton.style.visibility=visibility;this.phoneNumberView.value=phoneNumber;this.moveCaretToEnd(this.phoneNumberView);this.formatPhoneNumber(ellipsisSide,maxFontSize);}
if(this.onValueChanged){this.onValueChanged(this._phoneNumber);}},replacePhoneNumber:function kh_replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize);}},restorePhoneNumber:function kh_restorePhoneNumber(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restorePhoneNumber();}},replaceAdditionalContactInfo:function kh_updateAdditionalContactInfo(additionalContactInfo){var call=CallsHandler.activeCall;if(this._onCall&&call){call.replaceAdditionalContactInfo(additionalContactInfo);}},restoreAdditionalContactInfo:function kh_restoreAdditionalContactInfo(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restoreAdditionalContactInfo();}},_callVoicemail:function(){if(navigator.mozIccManager.iccIds.length<=1){this._callVoicemailForSim(0);return;}
var self=this;var key='ril.voicemail.defaultServiceId';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function(){LazyLoader.load(['/shared/js/sim_picker.js'],function(){LazyL10n.get(function(_){SimPicker.getOrPick(req.result[key],_('voiceMail'),self._callVoicemailForSim);});});};},_callVoicemailForSim:function(cardIndex){var settings=navigator.mozSettings;if(!settings){return;}
var transaction=settings.createLock();var request=transaction.get('ril.iccInfo.mbdn');request.onsuccess=function(){var numbers=request.result['ril.iccInfo.mbdn'];var number;if(typeof numbers=='string'){number=numbers;}else{number=numbers&&numbers[cardIndex];}
var voicemail=navigator.mozVoicemail;if(!number&&voicemail){number=voicemail.getNumber();}
if(number){CallHandler.call(number,cardIndex);}};request.onerror=function(){};},_observePreferences:function kh_observePreferences(){var self=this;LazyLoader.load('/shared/js/settings_listener.js',function(){SettingsListener.observe('phone.ring.keypad',false,function(value){self._keypadSoundIsEnabled=!!value;});SettingsListener.observe('phone.dtmf.type',false,function(value){self._shortTone=(value==='short');});});}};;'use strict';var Utils={prettyDate:function ut_prettyDate(time){var _=navigator.mozL10n.get;var dtf=new navigator.mozL10n.DateTimeFormat();return dtf.localeFormat(new Date(time),_('shortTimeFormat'));},headerDate:function ut_headerDate(time){var _=navigator.mozL10n.get;var dtf=new navigator.mozL10n.DateTimeFormat();var today=_('today');var yesterday=_('yesterday');var diff=(Date.now()-time)/1000;var day_diff=Math.floor(diff/86400);if(isNaN(day_diff))
return'(incorrect date)';if(day_diff<0||diff<0){return dtf.localeFormat(new Date(time),_('shortDateTimeFormat'));}
return day_diff==0&&today||day_diff==1&&yesterday||day_diff<6&&dtf.localeFormat(new Date(time),'%A')||dtf.localeFormat(new Date(time),'%x');},getDayDate:function re_getDayDate(timestamp){var date=new Date(timestamp);var startDate=new Date(date.getFullYear(),date.getMonth(),date.getDate());return startDate.getTime();},getPhoneNumberPrimaryInfo:function ut_getPhoneNumberPrimaryInfo(matchingTel,contact){if(contact){if(contact.name&&contact.name.length&&contact.name[0]!==''){return contact.name;}else if(contact.org&&contact.org.length&&contact.org[0]!==''){return contact.org;}}
if(matchingTel){return matchingTel.value;}
return null;},toCamelCase:function ut_toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});},getPhoneNumberAdditionalInfo:function ut_getPhoneNumberAdditionalInfo(matchingTel){var number=matchingTel.number||matchingTel.value;if(!number){return;}
var carrier=matchingTel.carrier;var type=matchingTel.type;if(Array.isArray(type)){type=type[0];}
var _=navigator.mozL10n.get;var result=type?_(type):_('mobile');result=result?result:type;if(carrier){result+=', '+carrier;}else{result+=', '+number;}
return result;},addEllipsis:function ut_addEllipsis(view,fakeView,ellipsisSide){var side=ellipsisSide||'begin';LazyL10n.get(function localized(_){var localizedSide;if(navigator.mozL10n.language.direction==='rtl'){localizedSide=(side==='begin'?'right':'left');}else{localizedSide=(side==='begin'?'left':'right');}
var computedStyle=window.getComputedStyle(view,null);var currentFontSize=parseInt(computedStyle.getPropertyValue('font-size'));var viewWidth=view.getBoundingClientRect().width;fakeView.style.fontSize=currentFontSize+'px';fakeView.style.fontWeight=computedStyle.getPropertyValue('font-weight');fakeView.innerHTML=view.value?view.value:view.innerHTML;var value=fakeView.innerHTML;var counter=value.length-
(viewWidth*(fakeView.textContent.length/fakeView.getBoundingClientRect().width));var newPhoneNumber;while(fakeView.getBoundingClientRect().width>viewWidth){if(localizedSide=='left'){newPhoneNumber='\u2026'+value.substr(-value.length+counter);}else if(localizedSide=='right'){newPhoneNumber=value.substr(0,value.length-counter)+'\u2026';}
fakeView.innerHTML=newPhoneNumber;counter++;}
if(newPhoneNumber){if(view.value){view.value=newPhoneNumber;}else{view.innerHTML=newPhoneNumber;}}});},getNextFontSize:function ut_getNextFontSize(view,fakeView,maxFontSize,minFontSize,fontStep){var computedStyle=window.getComputedStyle(view,null);var fontSize=parseInt(computedStyle.getPropertyValue('font-size'));var viewWidth=view.getBoundingClientRect().width;var viewHeight=view.getBoundingClientRect().height;fakeView.style.fontSize=fontSize+'px';fakeView.innerHTML=(view.value?view.value:view.innerHTML);var rect=fakeView.getBoundingClientRect();while((rect.width<viewWidth)&&(fontSize<maxFontSize)){fontSize=Math.min(fontSize+fontStep,maxFontSize);fakeView.style.fontSize=fontSize+'px';rect=fakeView.getBoundingClientRect();}
while((rect.width>viewWidth)&&(fontSize>minFontSize)){fontSize=Math.max(fontSize-fontStep,minFontSize);fakeView.style.fontSize=fontSize+'px';rect=fakeView.getBoundingClientRect();}
return fontSize;}};;'use strict';var Voicemail={check:function vm_check(number,callback){var voicemail=navigator.mozVoicemail;if(voicemail){var voicemailNumber=voicemail.getNumber();if(voicemailNumber==number){callback(true);return;}}
var settings=navigator.mozSettings;var req=settings.createLock().get('ril.iccInfo.mbdn');req.onsuccess=function getVoicemailNumber(){var isVoicemailNumber=false;var voicemailNumbers=req.result['ril.iccInfo.mbdn'];var voicemailNumber;if(typeof voicemailNumbers=='string'){voicemailNumber=voicemailNumbers;}else{voicemailNumber=voicemailNumbers&&voicemailNumbers[0];}
if(voicemailNumber===number){isVoicemailNumber=true;}
callback(isVoicemailNumber);};req.onerror=function getVoicemailNumberError(){callback(false);};}};;'use strict';var CallScreen={_ticker:null,_screenWakeLock:null,_typedNumber:'',callEndPromptTime:2000,body:document.body,screen:document.getElementById('call-screen'),views:document.getElementById('views'),calls:document.getElementById('calls'),groupCalls:document.getElementById('group-call-details'),groupCallsList:document.getElementById('group-call-details-list'),mainContainer:document.getElementById('main-container'),contactBackground:document.getElementById('contact-background'),callToolbar:document.getElementById('co-advanced'),muteButton:document.getElementById('mute'),speakerButton:document.getElementById('speaker'),bluetoothButton:document.getElementById('bt'),keypadButton:document.getElementById('keypad-visibility'),placeNewCallButton:document.getElementById('place-new-call'),bluetoothMenu:document.getElementById('bluetooth-menu'),switchToDeviceButton:document.getElementById('btmenu-btdevice'),switchToReceiverButton:document.getElementById('btmenu-receiver'),switchToSpeakerButton:document.getElementById('btmenu-speaker'),bluetoothMenuCancel:document.getElementById('btmenu-cancel'),answerButton:document.getElementById('callbar-answer'),rejectButton:document.getElementById('callbar-hang-up'),holdButton:document.getElementById('callbar-hold'),showGroupButton:document.getElementById('group-show'),hideGroupButton:document.getElementById('group-hide'),incomingContainer:document.getElementById('incoming-container'),incomingNumber:document.getElementById('incoming-number'),incomingSim:document.getElementById('incoming-sim'),incomingNumberAdditionalInfo:document.getElementById('incoming-number-additional-info'),incomingAnswer:document.getElementById('incoming-answer'),incomingEnd:document.getElementById('incoming-end'),incomingIgnore:document.getElementById('incoming-ignore'),lockedClockTime:document.getElementById('lockscreen-clock-time'),lockedDate:document.getElementById('lockscreen-date'),statusMessage:document.getElementById('statusMsg'),configs:{lockMode:'incoming-call'},showStatusMessage:function cs_showStatusMesssage(text){var STATUS_TIME=2000;var self=this;self.statusMessage.querySelector('p').textContent=text;self.statusMessage.classList.add('visible');self.statusMessage.addEventListener('transitionend',function tend(evt){evt.stopPropagation();self.statusMessage.removeEventListener('transitionend',tend);setTimeout(function hide(){self.statusMessage.classList.remove('visible');},STATUS_TIME);});},updateCallsDisplay:function cs_updateCallsDisplay(){var enabled=(this.calls.querySelectorAll('section:not([hidden])').length<=1);this.calls.classList.toggle('single-line',enabled);this.calls.classList.toggle('big-duration',enabled);CallsHandler.updateAllPhoneNumberDisplays();},set holdAndAnswerOnly(enabled){this.incomingContainer.classList.toggle('hold-and-answer-only',enabled);},set cdmaCallWaiting(enabled){this.calls.classList.toggle('switch',enabled);this.callToolbar.classList.toggle('no-add-call',enabled);},get inStatusBarMode(){return window.innerHeight<=40;},init:function cs_init(){this.muteButton.addEventListener('click',this.toggleMute.bind(this));this.keypadButton.addEventListener('click',this.showKeypad.bind(this));this.placeNewCallButton.addEventListener('click',this.placeNewCall.bind(this));this.speakerButton.addEventListener('click',this.toggleSpeaker.bind(this));this.bluetoothButton.addEventListener('click',this.toggleBluetoothMenu.bind(this));this.answerButton.addEventListener('click',CallsHandler.answer);this.rejectButton.addEventListener('click',CallsHandler.end);this.holdButton.addEventListener('mouseup',CallsHandler.toggleCalls);this.showGroupButton.addEventListener('click',this.showGroupDetails.bind(this));this.hideGroupButton.addEventListener('click',this.hideGroupDetails.bind(this));this.switchToDeviceButton.addEventListener('click',this.switchToDefaultOut.bind(this,false));this.switchToReceiverButton.addEventListener('click',this.switchToReceiver.bind(this));this.switchToSpeakerButton.addEventListener('click',this.switchToSpeaker.bind(this));this.bluetoothMenuCancel.addEventListener('click',this.toggleBluetoothMenu.bind(this));this.incomingAnswer.addEventListener('click',CallsHandler.holdAndAnswer);this.incomingEnd.addEventListener('click',CallsHandler.endAndAnswer);this.incomingIgnore.addEventListener('click',CallsHandler.ignore);this.calls.addEventListener('click',CallsHandler.toggleCalls.bind(this));this.setWallpaper();window.addEventListener('resize',this.resizeHandler.bind(this));window.addEventListener('hashchange',this.hashchangeHandler.bind(this));this.hashchangeHandler();this.syncSpeakerEnabled();},_slideInitialized:false,initLockScreenSlide:function cs_initLockScreenSlide(){if(this._slideInitialized){return;}
this._slideInitialized=true;this.hangUpIcon=document.getElementById('lockscreen-area-hangup');this.pickUpIcon=document.getElementById('lockscreen-area-pickup');this.initUnlockerEvents();new LockScreenSlide({IDs:{overlay:'main-container',areas:{left:'lockscreen-area-hangup',right:'lockscreen-area-pickup'}},colors:{left:{touchedColor:'255, 0, 0',touchedColorStop:'255, 178, 178'},right:{touchedColor:'132, 200, 44',touchedColorStop:'218, 238, 191'}},resources:{larrow:'/style/images/larrow.png',rarrow:'/style/images/rarrow.png'},handle:{autoExpand:{sentinelOffset:80}}});},_wallpaperReady:false,_toggleWaiting:false,_toggleCallback:null,setWallpaper:function cs_setWallpaper(){if(!navigator.mozSettings){this._onWallpaperReady();return;}
var self=this;var req=navigator.mozSettings.createLock().get('wallpaper.image');req.onsuccess=function cs_wi_onsuccess(){var wallpaperImage=req.result['wallpaper.image'];var isString=(typeof wallpaperImage=='string');var image=isString?wallpaperImage:URL.createObjectURL(wallpaperImage);self.mainContainer.style.backgroundImage='url('+image+')';setTimeout(self._onWallpaperReady.bind(self));};req.onerror=this._onWallpaperReady.bind(this);},_onWallpaperReady:function cs_onWallpaperReady(){this._wallpaperReady=true;if(this._toggleWaiting){this.toggle(this._toggleCallback);this._toggleCallback=null;this._toggleWaiting=false;}},_transitioning:false,_transitionDone:false,_contactBackgroundWaiting:false,_contactImage:null,toggle:function cs_toggle(callback){if(!this._wallpaperReady){this._toggleWaiting=true;this._toggleCallback=callback;return;}
var screen=this.screen;screen.classList.toggle('displayed');var skipTransition=this._transitioning||(this.screen.dataset.layout==='incoming-locked');if(skipTransition){if(callback&&typeof(callback)=='function'){setTimeout(callback);}
this._onTransitionDone();return;}
var self=this;self._transitioning=true;screen.addEventListener('transitionend',function trWait(evt){if(evt.target!=screen){return;}
screen.removeEventListener('transitionend',trWait);self._transitioning=false;if(callback&&typeof(callback)=='function'){callback();}
self._onTransitionDone();});},_onTransitionDone:function cs_onTransitionDone(){this._transitionDone=true;if(this._contactBackgroundWaiting){this.setCallerContactImage(this._contactImage);this._contactBackgroundWaiting=false;}},setCallerContactImage:function cs_setContactImage(blob,force){if(!this._transitionDone){this._contactImage=blob;this._contactBackgroundWaiting=true;return;}
if(this._contactImage==blob&&!this._contactBackgroundWaiting){return;}
this._contactImage=blob;this.contactBackground.classList.remove('ready');var background=blob?'url('+URL.createObjectURL(blob)+')':'';this.contactBackground.style.backgroundImage=background;this.contactBackground.classList.add('ready');},setEmergencyWallpaper:function cs_setEmergencyWallpaper(){this.mainContainer.classList.add('emergency-active');},insertCall:function cs_insertCall(node){this.calls.appendChild(node);this.updateCallsDisplay();},removeCall:function cs_removeCall(node){node.parentNode.removeChild(node);this.updateCallsDisplay();},moveToGroup:function cs_moveToGroup(node){this.groupCallsList.appendChild(node);},resizeHandler:function cs_resizeHandler(){if(!this.body.classList.contains('showKeypad')){return;}
if(this.inStatusBarMode){this._typedNumber=KeypadManager._phoneNumber;KeypadManager.restorePhoneNumber();}else{KeypadManager.updatePhoneNumber(this._typedNumber,'begin',true);}},hashchangeHandler:function cs_hashchangeHandler(){if(window.location.hash.startsWith('#locked')){this.showClock(new Date());this.initLockScreenSlide();if(!this.screen.dataset.layout){this.render('incoming-locked');}}},toggleMute:function cs_toggleMute(){this.muteButton.classList.toggle('active-state');this.calls.classList.toggle('muted');CallsHandler.toggleMute();},unmute:function cs_unmute(){this.muteButton.classList.remove('active-state');this.calls.classList.remove('muted');CallsHandler.unmute();},toggleSpeaker:function cs_toggleSpeaker(){this.speakerButton.classList.toggle('active-state');CallsHandler.toggleSpeaker();},toggleBluetoothMenu:function cs_toggleBluetoothMenu(value){if(typeof value!='boolean'){this.bluetoothMenu.classList.toggle('display');}else{this.bluetoothMenu.classList.toggle('display',value);}},switchToSpeaker:function cs_switchToReceiver(){this.speakerButton.classList.add('active-state');this.bluetoothButton.classList.add('active-state');CallsHandler.switchToSpeaker();this.toggleBluetoothMenu(false);},switchToReceiver:function cs_switchToReceiver(){this.speakerButton.classList.remove('active-state');this.bluetoothButton.classList.remove('active-state');CallsHandler.switchToReceiver();this.toggleBluetoothMenu(false);},switchToDefaultOut:function cs_switchToDefaultOut(doNotConnect){this.speakerButton.classList.remove('active-state');this.bluetoothButton.classList.add('active-state');CallsHandler.switchToDefaultOut(doNotConnect);this.toggleBluetoothMenu(false);},setBTReceiverIcon:function cs_setBTReceiverIcon(enabled){if(enabled){this.speakerButton.classList.add('hide');this.bluetoothButton.classList.remove('hide');}else{this.speakerButton.classList.remove('hide');this.bluetoothButton.classList.add('hide');}},showKeypad:function cs_showKeypad(){KeypadManager.render('oncall');this.body.classList.add('showKeypad');},hideKeypad:function cs_hideKeypad(){KeypadManager.restorePhoneNumber();KeypadManager.restoreAdditionalContactInfo();this.body.classList.remove('showKeypad');},placeNewCall:function cs_placeNewCall(){new MozActivity({name:'dial',data:{type:'webtelephony/number',number:''}});window.resizeTo(100,40);},render:function cs_render(layout_type){this.screen.dataset.layout=layout_type;if(layout_type!=='connected'){this.disableKeypad();}},showClock:function cs_showClock(now){LazyL10n.get(function localized(_){var f=new navigator.mozL10n.DateTimeFormat();var timeFormat=_('shortTimeFormat').replace('%p','<span>%p</span>');var dateFormat=_('longDateFormat');this.lockedClockTime.innerHTML=f.localeFormat(now,timeFormat);this.lockedDate.textContent=f.localeFormat(now,dateFormat);}.bind(this));},showIncoming:function cs_showIncoming(){this.body.classList.remove('showKeypad');this.callToolbar.classList.add('transparent');this.incomingContainer.classList.add('displayed');this._screenWakeLock=navigator.requestWakeLock('screen');},hideIncoming:function cs_hideIncoming(){this.callToolbar.classList.remove('transparent');this.incomingContainer.classList.remove('displayed');if(this._screenWakeLock){this._screenWakeLock.unlock();this._screenWakeLock=null;}
var hc=CallsHandler.activeCall;if(hc){this.setCallerContactImage(hc.photo);}else{this.setCallerContactImage(null);}},syncSpeakerEnabled:function cs_syncSpeakerEnabled(){if(navigator.mozTelephony.speakerEnabled){this.speakerButton.classList.add('active-state');}else{this.speakerButton.classList.remove('active-state');}},enableKeypad:function cs_enableKeypad(){this.keypadButton.removeAttribute('disabled');},disableKeypad:function cs_disableKeypad(){this.keypadButton.setAttribute('disabled','disabled');},showGroupDetails:function cs_showGroupDetails(evt){if(evt){evt.stopPropagation();}
this.groupCalls.classList.add('display');},hideGroupDetails:function cs_hideGroupDetails(evt){if(evt){evt.preventDefault();}
this.groupCalls.classList.remove('display');},createTicker:function(durationNode){var durationChildNode=durationNode.querySelector('span');if(durationNode.dataset.tickerId)
return false;durationChildNode.textContent='00:00';durationNode.classList.add('isTimer');function padNumber(n){return n>9?n:'0'+n;}
LazyL10n.get(function localized(_){var ticker=setInterval(function ut_updateTimer(startTime){var delta=Math.round((Date.now()-startTime)/1000)*1000;var elapsed=new Date(delta);var duration={h:padNumber(elapsed.getUTCHours()),m:padNumber(elapsed.getUTCMinutes()),s:padNumber(elapsed.getUTCSeconds())};durationChildNode.textContent=_(elapsed.getUTCHours()>0?'callDurationHours':'callDurationMinutes',duration);},1000,Date.now());durationNode.dataset.tickerId=ticker;});return true;},stopTicker:function(durationNode){durationNode.classList.remove('isTimer');clearInterval(durationNode.dataset.tickerId);delete durationNode.dataset.tickerId;},setEndConferenceCall:function cs_setEndConferenceCall(){var callElems=this.groupCallsList.getElementsByTagName('SECTION');for(var i=0;i<callElems.length;i++){callElems[i].dataset.groupHangup='groupHangup';}},handleEvent:function cs_handleEvent(evt){var state=null,statePrev=null;switch(evt.type){case'lockscreenslide-unlocker-initializer':break;case'lockscreenslide-near-left':state=evt.detail.state;statePrev=evt.detail.statePrev;if(state==='accelerating'){CallScreen.hangUpIcon.classList.add('triggered');}else{CallScreen.hangUpIcon.classList.remove('triggered');}
break;case'lockscreenslide-near-right':state=evt.detail.state;statePrev=evt.detail.statePrev;if(state==='accelerating'){CallScreen.pickUpIcon.classList.add('triggered');}else{CallScreen.pickUpIcon.classList.remove('triggered');}
break;case'lockscreenslide-unlocking-start':break;case'lockscreenslide-unlocking-stop':break;case'lockscreenslide-activate-left':CallsHandler.end();break;case'lockscreenslide-activate-right':CallsHandler.answer();break;case'lockscreen-mode-on':this.modeSwitch(evt.detail,true);break;case'lockscreen-mode-off':this.modeSwitch(evt.detail,false);break;}},modeSwitch:function cs_modeSwitch(mode,switcher){if(switcher){if(mode!==this.configs.lockMode){this.suspendUnlockerEvents();}}else{if(mode!==this.configs.lockMode){this.initUnlockerEvents();}}},initUnlockerEvents:function cs_initUnlockerEvents(){window.addEventListener('lockscreenslide-unlocker-initializer',this);window.addEventListener('lockscreenslide-near-left',this);window.addEventListener('lockscreenslide-near-right',this);window.addEventListener('lockscreenslide-unlocking-start',this);window.addEventListener('lockscreenslide-activate-left',this);window.addEventListener('lockscreenslide-activate-right',this);window.addEventListener('lockscreenslide-unlocking-stop',this);},suspendUnlockerEvents:function cs_initUnlockerEvents(){window.removeEventListener('lockscreenslide-unlocker-initializer',this);window.removeEventListener('lockscreenslide-near-left',this);window.removeEventListener('lockscreenslide-near-right',this);window.removeEventListener('lockscreenslide-unlocking-start',this);window.removeEventListener('lockscreenslide-activate-left',this);window.removeEventListener('lockscreenslide-activate-right',this);window.removeEventListener('lockscreenslide-unlocking-stop',this);}};;var BluetoothHelper=function(){var profiles={'HFP':0x111E,'A2DP':0x110D};var _bluetooth=window.navigator.mozBluetooth;var _isReady=false;var _callbacks=[];var _adapter=null;var _ready=function(callback){if(!callback||!_bluetooth){return;}
if(_isReady){callback();}else{_callbacks.push(callback);}};var _handleRequest=function(request,callback,errorcb){request.onsuccess=function(){if(callback){callback(request.result);}};request.onerror=function(){console.log('Error handling bluetooth request');if(errorcb){errorcb();}};};var _getAdapter=function(){var req=_bluetooth.getDefaultAdapter();req.onsuccess=function(){_isReady=true;_adapter=req.result;_callbacks.forEach(function(callback){callback();});};req.onerror=function(){};};if(_bluetooth){_bluetooth.addEventListener('enabled',_getAdapter);_bluetooth.addEventListener('adapteradded',_getAdapter);_getAdapter();}
return{profiles:profiles,answerWaitingCall:function(){_ready(function(){_adapter.answerWaitingCall();});},ignoreWaitingCall:function(){_ready(function(){_adapter.ignoreWaitingCall();});},toggleCalls:function(){_ready(function(){_adapter.toggleCalls();});},getConnectedDevicesByProfile:function(profileID,cb){_ready(function(){_handleRequest(_adapter.getConnectedDevices(profileID),cb);});},connectSco:function(cb){_ready(function(){_handleRequest(_adapter.connectSco(),cb);});},disconnectSco:function(cb){_ready(function(){_handleRequest(_adapter.disconnectSco(),cb);});},set onhfpstatuschanged(callback){_ready(function(){_adapter.onhfpstatuschanged=callback;});},set onscostatuschanged(callback){_ready(function(){_adapter.onscostatuschanged=callback;});}};};;'use strict';var CallsHandler=(function callsHandler(){var CALLS_LIMIT=2;var handledCalls=[];var toneInterval=null;var telephony=window.navigator.mozTelephony;telephony.oncallschanged=onCallsChanged;var displayed=false;var closing=false;var conn=window.navigator.mozMobileConnection||window.navigator.mozMobileConnections&&window.navigator.mozMobileConnections[0];if(conn&&conn.voice&&conn.voice.network&&conn.voice.network.mcc){SimplePhoneMatcher.mcc=conn.voice.network.mcc;}
var btHelper=new BluetoothHelper();var screenLock;function setup(){if(telephony){telephony.muted=false;}
btHelper.getConnectedDevicesByProfile(btHelper.profiles.HFP,function(result){CallScreen.setBTReceiverIcon(!!(result&&result.length));});btHelper.onhfpstatuschanged=function(evt){CallScreen.setBTReceiverIcon(evt.status);};var acm=navigator.mozAudioChannelManager;if(acm){acm.addEventListener('headphoneschange',function onheadphoneschange(){if(acm.headphones){CallScreen.switchToDefaultOut();}});}
btHelper.onscostatuschanged=function onscostatuschanged(evt){if(evt.status){CallScreen.switchToDefaultOut();}};navigator.mozSetMessageHandler('headset-button',handleHSCommand);navigator.mozSetMessageHandler('bluetooth-dialer-command',handleBTCommand);}
var highPriorityWakeLock=null;function onCallsChanged(){if(!highPriorityWakeLock&&telephony.calls.length>0){highPriorityWakeLock=navigator.requestWakeLock('high-priority');}
if(highPriorityWakeLock&&telephony.calls.length==0){highPriorityWakeLock.unlock();highPriorityWakeLock=null;}
telephony.calls.forEach(function callIterator(call){var alreadyAdded=handledCalls.some(function hcIterator(hc){return(hc.call==call);});if(!alreadyAdded){addCall(call);}});for(var index=(handledCalls.length-1);index>=0;index--){var hc=handledCalls[index];var stillHere=telephony.calls.some(function hcIterator(call){return(call==hc.call);});stillHere=stillHere||telephony.conferenceGroup.calls.some(function hcIterator(call){return(call==hc.call);});if(!stillHere){removeCall(index);}}
if(cdmaCallWaiting()){handleCallWaiting(telephony.calls[0]);}
if(handledCalls.length===0){exitCallScreen(false);}else if(!displayed&&!closing){toggleScreen();}}
function addCall(call){if(handledCalls.length&&(call.state!='incoming')&&(call.state!='dialing')){return;}
if(telephony.calls.length>CALLS_LIMIT){new HandledCall(call);call.hangUp();return;}
if(handledCalls.length==0){CallScreen.unmute();CallScreen.switchToDefaultOut(true);}
var hc=new HandledCall(call);handledCalls.push(hc);CallScreen.insertCall(hc.node);if(call.state==='incoming'){if(handledCalls.length===1){handleFirstIncoming(call);}}
if(handledCalls.length>1){if(call.state==='incoming'){hc.hide();handleCallWaiting(call);}else{hc.show();}}else{if(window.location.hash.startsWith('#locked')&&(call.state=='incoming')){CallScreen.render('incoming-locked');}else{CallScreen.render(call.state);}}}
function removeCall(index){var removedCall=handledCalls[index];handledCalls.splice(index,1);if(handledCalls.length===0){exitCallScreen(true);return;}
CallScreen.hideIncoming();var remainingCall=handledCalls[0];if(remainingCall.call.state=='incoming'){remainingCall.show();setTimeout(function nextTick(){if(remainingCall.call.state=='incoming'){CallScreen.render('incoming');}});return;}
if(remainingCall.call.group){remainingCall.call.group.resume();}else{remainingCall.call.resume();}}
function handleFirstIncoming(call){screenLock=navigator.requestWakeLock('screen');call.addEventListener('statechange',function callStateChange(){call.removeEventListener('statechange',callStateChange);if(screenLock){screenLock.unlock();screenLock=null;}});}
function handleCallWaiting(call){LazyL10n.get(function localized(_){var number=(call.secondNumber?call.secondNumber:call.number);if(!number){CallScreen.incomingNumber.textContent=_('withheld-number');return;}
if(navigator.mozIccManager.iccIds.length>1){CallScreen.incomingSim.textContent=_('sim-number',{n:call.serviceId+1});}else{CallScreen.incomingSim.hidden=true;}
Contacts.findByNumber(number,function lookupContact(contact,matchingTel){if(contact&&contact.name){CallScreen.incomingNumber.textContent=contact.name;CallScreen.incomingNumberAdditionalInfo.textContent=Utils.getPhoneNumberAdditionalInfo(matchingTel);return;}
CallScreen.incomingNumber.textContent=number;CallScreen.incomingNumberAdditionalInfo.textContent='';});});if(cdmaCallWaiting()){CallScreen.holdAndAnswerOnly=true;}
CallScreen.showIncoming();playWaitingTone(call);}
function toggleScreen(){displayed=!displayed;CallScreen.toggle(function transitionend(){if(!displayed){closeWindow();}});}
function updateKeypadEnabled(){if(telephony.active){CallScreen.enableKeypad();}else{CallScreen.disableKeypad();}}
function exitCallScreen(animate){if(closing){return;}
closing=true;if(animate&&displayed){toggleScreen();}else{closeWindow();}}
function closeWindow(){closing=false;window.close();}
function updateAllPhoneNumberDisplays(){handledCalls.forEach(function(call){call.restorePhoneNumber();});}
window.addEventListener('resize',updateAllPhoneNumberDisplays);function handleBTCommand(message){var command=message['command'];switch(command){case'CHUP':end();break;case'ATA':answer();break;case'CHLD=0':hangupWaitingCalls();break;case'CHLD=1':if((handledCalls.length===1)&&!cdmaCallWaiting()){end();}else{endAndAnswer();}
break;case'CHLD=2':if((handledCalls.length===1)&&!cdmaCallWaiting()){holdOrResumeSingleCall();}else{holdAndAnswer();}
break;case'CHLD=3':if(!telephony.conferenceGroup.state&&telephony.calls.length==2){telephony.conferenceGroup.add(telephony.calls[0],telephony.calls[1]);break;}
if(telephony.conferenceGroup.state&&telephony.calls.length==1){telephony.conferenceGroup.add(telephony.calls[0]);break;}
console.warn('Cannot join conference call.');break;default:var partialCommand=command.substring(0,3);if(partialCommand==='VTS'){KeypadManager.press(command.substring(4));}
break;}}
var lastHeadsetPress=0;function handleHSCommand(message){switch(message){case'headset-button-press':lastHeadsetPress=Date.now();return;break;case'headset-button-release':if((Date.now()-lastHeadsetPress)>1000)
return;break;default:return;}
if(telephony.active){end();}else if((handledCalls.length>1)||cdmaCallWaiting()){holdAndAnswer();}else{answer();}}
function answer(){if(!handledCalls.length){return;}
handledCalls[0].call.answer();CallScreen.render('connected');}
function holdAndAnswer(){if((handledCalls.length<2)&&!cdmaCallWaiting()){return;}
if(telephony.active){telephony.active.hold();if(cdmaCallWaiting()){btHelper.answerWaitingCall();}}else if(handledCalls.length>=2){var lastCall=handledCalls[handledCalls.length-1].call;lastCall.answer();}else{handledCalls[0].call.hold();}
CallScreen.hideIncoming();if(cdmaCallWaiting()){handledCalls[0].updateCallNumber();CallScreen.cdmaCallWaiting=true;stopWaitingTone();}}
function endAndAnswer(){if((handledCalls.length<2)&&!cdmaCallWaiting()){return;}
if(telephony.active==telephony.conferenceGroup){endConferenceCall();CallScreen.hideIncoming();return;}
if(cdmaCallWaiting()){handledCalls[0].call.hold();stopWaitingTone();btHelper.answerWaitingCall();}else{var callToEnd=telephony.active||handledCalls[handledCalls.length-2].call;var callToAnswer;handledCalls.some(function(handledCall){if(handledCall.call!==callToEnd){callToAnswer=handledCall.call;return true;}});if(callToEnd&&callToAnswer){callToEnd.addEventListener('disconnected',function ondisconnected(){callToEnd.removeEventListener('disconnected',ondisconnected);callToAnswer.answer();});callToEnd.hangUp();}else if(callToEnd){callToEnd.hangUp();}else if(callToAnswer){callToAnswer.answer();}}
CallScreen.hideIncoming();if(cdmaCallWaiting()){handledCalls[0].updateCallNumber();CallScreen.cdmaCallWaiting=true;}}
function toggleCalls(){if(CallScreen.incomingContainer.classList.contains('displayed')&&!cdmaCallWaiting()){return;}
var openLines=telephony.calls.length+
(telephony.conferenceGroup.calls.length?1:0);if(openLines<2&&!cdmaCallWaiting()){if(!telephony.active){holdOrResumeSingleCall();}
return;}
telephony.active.hold();btHelper.toggleCalls();}
function holdOrResumeSingleCall(){var openLines=telephony.calls.length+
(telephony.conferenceGroup.calls.length?1:0);if(openLines!==1){return;}
if(telephony.calls.length&&telephony.calls[0].state==='incoming'){return;}
if(telephony.active){telephony.active.hold();CallScreen.render('connected-hold');}else{var line=telephony.calls.length?telephony.calls[0]:telephony.conferenceGroup;line.resume();CallScreen.render('connected');}}
function hangupWaitingCalls(){handledCalls.forEach(function(handledCall){var callState=handledCall.call.state;if(callState==='held'||(callState==='incoming'&&handledCalls.length>1)){handledCall.call.hangUp();}});}
function ignore(){if(cdmaCallWaiting()){stopWaitingTone();btHelper.ignoreWaitingCall();}else{var ignoreIndex=handledCalls.length-1;handledCalls[ignoreIndex].call.hangUp();}
CallScreen.hideIncoming();}
function endConferenceCall(){var callsToEnd=telephony.conferenceGroup.calls;CallScreen.setEndConferenceCall();for(var i=(callsToEnd.length-1);i>=0;i--){var call=callsToEnd[i];call.hangUp();}}
function end(){if(telephony.active==telephony.conferenceGroup){endConferenceCall();return;}
if(telephony.active){telephony.active.hangUp();return;}
if(!handledCalls.length){exitCallScreen(true);return;}
var lastCallIndex=handledCalls.length-1;handledCalls[lastCallIndex].call.hangUp();}
function unmute(){telephony.muted=false;}
function switchToSpeaker(){btHelper.disconnectSco();if(!telephony.speakerEnabled){telephony.speakerEnabled=true;}}
function switchToDefaultOut(doNotConnect){if(telephony.speakerEnabled){telephony.speakerEnabled=false;}
if(!doNotConnect&&displayed){btHelper.connectSco();}}
function switchToReceiver(){btHelper.disconnectSco();if(telephony.speakerEnabled){telephony.speakerEnabled=false;}}
function toggleMute(){telephony.muted=!telephony.muted;}
function toggleSpeaker(){if(telephony.speakerEnabled){CallsHandler.switchToDefaultOut();}else{CallsHandler.switchToSpeaker();}}
function playWaitingTone(call){var sequence=[[440,440,100],[0,0,100],[440,440,100]];toneInterval=window.setInterval(function playTone(){TonePlayer.playSequence(sequence);},10000);TonePlayer.playSequence(sequence);call.addEventListener('statechange',function callStateChange(){call.removeEventListener('statechange',callStateChange);window.clearInterval(toneInterval);});}
function stopWaitingTone(){window.clearInterval(toneInterval);}
function activeCall(){var telephonyActiveCall=telephony.active;var activeCall=null;for(var i=0;i<handledCalls.length;i++){var handledCall=handledCalls[i];if(telephonyActiveCall===handledCall.call){activeCall=handledCall;break;}}
return activeCall;}
function cdmaCallWaiting(){return((telephony.calls.length==1)&&(telephony.calls[0].state=='connected')&&telephony.calls[0].secondNumber);}
function mergeActiveCallWith(call){if(telephony.active==telephony.conferenceGroup){telephony.conferenceGroup.add(call);}else{telephony.conferenceGroup.add(telephony.active,call);}}
function mergeConferenceGroupWithActiveCall(){telephony.conferenceGroup.add(telephony.active);}
return{setup:setup,answer:answer,holdAndAnswer:holdAndAnswer,endAndAnswer:endAndAnswer,toggleCalls:toggleCalls,ignore:ignore,end:end,updateKeypadEnabled:updateKeypadEnabled,toggleMute:toggleMute,toggleSpeaker:toggleSpeaker,unmute:unmute,switchToReceiver:switchToReceiver,switchToSpeaker:switchToSpeaker,switchToDefaultOut:switchToDefaultOut,checkCalls:onCallsChanged,mergeActiveCallWith:mergeActiveCallWith,mergeConferenceGroupWithActiveCall:mergeConferenceGroupWithActiveCall,updateAllPhoneNumberDisplays:updateAllPhoneNumberDisplays,get activeCall(){return activeCall();}};})();;'use strict';var ConferenceGroupHandler=(function(){var groupLine=document.getElementById('group-call');var groupLabel=document.getElementById('group-call-label');var groupDetails=document.getElementById('group-call-details');var groupDetailsHeader=groupDetails.querySelector('header');var groupDuration=document.querySelector('#group-call > .duration');var groupDurationChildNode=groupDuration.querySelector('span');var mergeButton=groupLine.querySelector('.merge-button');mergeButton.onclick=function(evt){if(evt){evt.stopPropagation();}
CallsHandler.mergeConferenceGroupWithActiveCall();};var telephony=window.navigator.mozTelephony;telephony.conferenceGroup.oncallschanged=onCallsChanged;telephony.conferenceGroup.onstatechange=onStateChange;telephony.conferenceGroup.onerror=onConferenceError;function onCallsChanged(){var calls=telephony.conferenceGroup.calls;CallScreen.updateCallsDisplay();if(!calls.length){CallScreen.hideGroupDetails();}
LazyL10n.get(function localized(_){groupDetailsHeader.textContent=groupLabel.textContent=_('group-call',{n:calls.length});});if(telephony.conferenceGroup.calls.length>=2){CallsHandler.checkCalls();}}
function show(){groupLine.hidden=false;groupLine.classList.remove('ended');groupLine.classList.remove('held');groupDurationChildNode.textContent=null;CallScreen.createTicker(groupDuration);CallScreen.setCallerContactImage(null);}
function end(){LazyL10n.get(function localized(_){groupDurationChildNode.textContent=_('callEnded');});groupLine.classList.add('ended');groupLine.classList.remove('held');CallScreen.stopTicker(groupDuration);setTimeout(function(evt){groupLine.hidden=true;},CallScreen.callEndPromptTime);}
function onStateChange(){switch(telephony.conferenceGroup.state){case'resuming':case'connected':show();break;case'held':groupLine.classList.add('held');break;case'':end();CallsHandler.checkCalls();break;}}
function onConferenceError(evt){LazyL10n.get(function localized(_){var errorMsg;if(evt.name=='addError'){errorMsg=_('conferenceAddError');}else{errorMsg=_('conferenceRemoveError');}
CallScreen.showStatusMessage(errorMsg);});}})();;'use strict';function HandledCall(aCall){this.photo=null;this._leftGroup=false;this.call=aCall;aCall.addEventListener('statechange',this);aCall.ongroupchange=(function onGroupChange(){if(this.call.group){CallScreen.moveToGroup(this.node);this._leftGroup=false;}else if(this._wasUnmerged()){CallScreen.insertCall(this.node);this._leftGroup=false;}else{this._leftGroup=!this.node.dataset.groupHangup;}}).bind(this);this._initialState=this.call.state;this._cachedInfo='';this._cachedAdditionalInfo='';this._removed=false;this.node=document.getElementById('handled-call-template').cloneNode(true);this.node.id='';this.node.classList.add('handled-call');this.node.hidden=false;this.durationNode=this.node.querySelector('.duration');this.durationChildNode=this.node.querySelector('.duration span');this.viaSimNode=this.node.querySelector('.sim .via-sim');this.simNumberNode=this.node.querySelector('.sim .sim-number');this.numberNode=this.node.querySelector('.numberWrapper .number');this.additionalInfoNode=this.node.querySelector('.additionalContactInfo');this.hangupButton=this.node.querySelector('.hangup-button');this.hangupButton.onclick=(function(){this.call.hangUp();}.bind(this));this.mergeButton=this.node.querySelector('.merge-button');this.mergeButton.onclick=(function(evt){if(evt){evt.stopPropagation();}
CallsHandler.mergeActiveCallWith(this.call);}).bind(this);this.updateCallNumber();LazyL10n.get((function localized(_){var durationMessage=(this.call.state=='incoming')?_('incoming'):_('connecting');this.durationChildNode.textContent=durationMessage;if(navigator.mozIccManager.iccIds.length>1){var n=this.call.serviceId+1;this.viaSimNode.textContent=_('via-sim',{n:n});this.simNumberNode.textContent=_('sim-number',{n:n});}else{this.viaSimNode.hidden=true;this.simNumberNode.hidden=true;}}).bind(this));this.updateDirection();if(this._initialState==='connected'){this.connected();}}
HandledCall.prototype._wasUnmerged=function hc_wasUnmerged(){return!this.node.dataset.groupHangup&&this.call.state!='disconnecting'&&this.call.state!='disconnected';};HandledCall.prototype.handleEvent=function hc_handle(evt){switch(evt.call.state){case'dialing':case'alerting':CallsHandler.updateKeypadEnabled();break;case'connected':CallScreen.render('connected');this.connected();break;case'disconnected':this.disconnected();break;case'held':CallsHandler.updateKeypadEnabled();this.node.classList.add('held');break;}};HandledCall.prototype.updateCallNumber=function hc_updateCallNumber(){var number=this.call.number;var secondNumber=this.call.secondNumber;var node=this.numberNode;var additionalInfoNode=this.additionalInfoNode;var self=this;CallScreen.setCallerContactImage(null);if(secondNumber){LazyL10n.get(function localized(_){node.textContent=_('switch-calls');self._cachedInfo=_('switch-calls');self._cachedAdditionalInfo='';self.replaceAdditionalContactInfo('');self.numberNode.style.fontSize='';});return;}
if(!number){LazyL10n.get(function localized(_){node.textContent=_('withheld-number');self._cachedInfo=_('withheld-number');});return;}
var isEmergencyNumber=this.call.emergency;if(isEmergencyNumber){this.node.classList.add('emergency-call');LazyL10n.get(function localized(_){node.textContent=_('emergencyNumber');self._cachedInfo=_('emergencyNumber');});CallScreen.setEmergencyWallpaper();return;}
var self=this;Voicemail.check(number,function(isVoicemailNumber){if(isVoicemailNumber){LazyL10n.get(function localized(_){node.textContent=_('voiceMail');self._cachedInfo=_('voiceMail');});}else{Contacts.findByNumber(number,lookupContact);checkICCMessage();}});function checkICCMessage(){var callMessageReq=navigator.mozSettings.createLock().get('icc.callmessage');callMessageReq.onsuccess=function onCallMessageSuccess(){self._iccCallMessage=callMessageReq.result['icc.callmessage'];if(self._iccCallMessage){self.replacePhoneNumber(self._iccCallMessage,'end',true);self._cachedInfo=self._iccCallMessage;var clearReq=navigator.mozSettings.createLock().set({'icc.callmessage':null});}};}
function lookupContact(contact,matchingTel,contactsWithSameNumber){if(self._iccCallMessage){return;}
if(contact){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);var contactCopy={id:contact.id,name:contact.name,org:contact.org,tel:contact.tel};if(primaryInfo){node.textContent=primaryInfo;self._cachedInfo=primaryInfo;}else{LazyL10n.get(function gotL10n(_){self._cachedInfo=_('withheld-number');node.textContent=self._cachedInfo;});}
self.formatPhoneNumber('end',true);self._cachedAdditionalInfo=Utils.getPhoneNumberAdditionalInfo(matchingTel);self.replaceAdditionalContactInfo(self._cachedAdditionalInfo);var photo=ContactPhotoHelper.getFullResolution(contact);if(photo){self.photo=photo;CallScreen.setCallerContactImage(photo);var thumbnail=ContactPhotoHelper.getThumbnail(contact);contactCopy.photo=[thumbnail];}
return;}
self._cachedInfo=number;node.textContent=self._cachedInfo;self.replaceAdditionalContactInfo(self._cachedAdditionalInfo);self.formatPhoneNumber('end',true);}};HandledCall.prototype.replaceAdditionalContactInfo=function hc_replaceAdditionalContactInfo(additionalContactInfo){if(!additionalContactInfo||additionalContactInfo.trim()===''){this.additionalInfoNode.textContent='';this.node.classList.remove('additionalInfo');}else{this.additionalInfoNode.textContent=additionalContactInfo;this.node.classList.add('additionalInfo');}};HandledCall.prototype.restoreAdditionalContactInfo=function hc_restoreAdditionalContactInfo(){this.replaceAdditionalContactInfo(this._cachedAdditionalInfo);};HandledCall.prototype.formatPhoneNumber=function hc_formatPhoneNumber(ellipsisSide,maxFontSize){if(this._removed){return;}
if(CallScreen.inStatusBarMode){this.numberNode.style.fontSize='';return;}
var fakeView=this.node.querySelector('.fake-number');var view=this.numberNode;var newFontSize;if(maxFontSize){newFontSize=KeypadManager.maxFontSize;}else{newFontSize=Utils.getNextFontSize(view,fakeView,KeypadManager.maxFontSize,KeypadManager.minFontSize,kFontStep);}
view.style.fontSize=newFontSize+'px';Utils.addEllipsis(view,fakeView,ellipsisSide);};HandledCall.prototype.replacePhoneNumber=function hc_replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize){this.numberNode.textContent=phoneNumber;this.formatPhoneNumber(ellipsisSide,maxFontSize);};HandledCall.prototype.restorePhoneNumber=function hc_restorePhoneNumber(){this.numberNode.textContent=this._cachedInfo;this.formatPhoneNumber('end',true);};HandledCall.prototype.updateDirection=function hc_updateDirection(){var classList=this.node.classList;if(this._initialState=='incoming'){classList.add('incoming');}else{classList.add('outgoing');}
if(this.call.state=='connected'){classList.add('ongoing');}};HandledCall.prototype.remove=function hc_remove(){this._removed=true;this.call.removeEventListener('statechange',this);this.photo=null;var self=this;CallScreen.stopTicker(this.durationNode);LazyL10n.get(function localized(_){self.durationNode.classList.remove('isTimer');self.durationChildNode.textContent=_('callEnded');});this.node.classList.add('ended');setTimeout(function(evt){CallScreen.removeCall(self.node);self.node=null;},CallScreen.callEndPromptTime);};HandledCall.prototype.connected=function hc_connected(){this.show();this.node.classList.remove('held');this.updateDirection();CallScreen.createTicker(this.durationNode);CallScreen.enableKeypad();CallScreen.syncSpeakerEnabled();if(!this.call.group){CallScreen.setCallerContactImage(this.photo);}};HandledCall.prototype.disconnected=function hc_disconnected(){var self=this;if(this._leftGroup){LazyL10n.get(function localized(_){CallScreen.showStatusMessage(_('caller-left-call',{caller:self._cachedInfo}));});self._leftGroup=false;}
this.remove();};HandledCall.prototype.show=function hc_show(){if(this.node){this.node.hidden=false;}
CallScreen.updateCallsDisplay();};HandledCall.prototype.hide=function hc_hide(){if(this.node){this.node.hidden=true;}
CallScreen.updateCallsDisplay();};;'use strict';(function(exports){var LockScreenSlide=function(opts){this.initialize(opts);};var LockScreenSlidePrototype={canvas:null,layout:'',track:{length:{tiny:'280',large:'410'},color:'rgba(255, 255, 255, 0.4)',from:0,to:0,radius:0,width:0},arrows:{left:null,right:null,ldraw:{x:null,y:null},rdraw:{x:null,y:null}},slides:{left:null,right:null},areas:{left:null,right:null},area:null,overlay:null,width:0,height:80,center:{x:null,y:null},handle:{autoExpand:{accState:'normal',accFactor:1.02,sentinelOffset:40,sentinelWidth:0},bounceBackTime:200,radius:28,lineWidth:1.6,maxWidth:0,towardLeft:false,touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239'},colors:{left:{touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239'},right:{touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239'}},states:{initialized:false,sliding:false,slideReachEnd:false,slidingColorful:false,slidingColorGradientEnd:false,touch:{id:'',touched:false,initX:-1,pageX:-1,pageY:-1,tx:-1,prevX:-1,deltaX:0}},IDs:{overlay:'lockscreen',area:'lockscreen-area',canvas:'lockscreen-canvas',areas:{left:'lockscreen-area-camera',right:'lockscreen-area-unlock'}},resources:{larrow:'/style/lockscreen/images/larrow.png',rarrow:'/style/lockscreen/images/rarrow.png'}};LockScreenSlidePrototype.initialize=function(opts){if(opts)
this._overwriteSettings(opts);this._initializeCanvas();this.publish('lockscreenslide-unlocker-initializer');this.states.initialized=true;};LockScreenSlidePrototype._overwriteSettings=function(options){var iterate=function _iterate(opts,settings){for(var property in opts){if(opts.hasOwnProperty(property)){if('object'===typeof opts[property]){iterate(opts[property],settings[property]);}
else{settings[property]=opts[property];}}}};iterate(options,this);};LockScreenSlidePrototype.handleEvent=function(evt){switch(evt.type){case'screenchange':if(evt.detail.screenOffBy=='proximity'){break;}
this._clearCanvas();this._drawTrack();this._resetArrows();this._resetHandle();break;case'touchstart':evt.preventDefault();if(evt.target!==this.area||evt.touches.length>1){return;}
this.states.touch.id=evt.touches[0].identifier;this._onSlideBegin(this._dpx(evt.touches[0].pageX));window.addEventListener('touchend',this);window.addEventListener('touchmove',this);break;case'touchmove':if(evt.touches.length>1){this._endGesture();return;}
this._onTouchMove(this._dpx(evt.touches[0].pageX),this._dpx(evt.touches[0].pageY));if(this.states.sliding){this._onSliding(this._dpx(evt.touches[0].pageX));}
break;case'touchend':if(evt.changedTouches[0].identifier!==this.states.touch.id)
return;this._endGesture();break;}};LockScreenSlidePrototype._initializeCanvas=function lss_initializeCanvas(){this.overlay=document.getElementById(this.IDs.overlay);this.area=document.getElementById(this.IDs.area);this.canvas=document.getElementById(this.IDs.canvas);this.areas.left=document.getElementById(this.IDs.areas.left);this.areas.right=document.getElementById(this.IDs.areas.right);this.area.addEventListener('touchstart',this);this.layout=(ScreenLayout&&ScreenLayout.getCurrentLayout)?ScreenLayout.getCurrentLayout():'tiny';var center=this.center;this.arrows.left=new Image();this.arrows.right=new Image();var larrow=this.arrows.left;var rarrow=this.arrows.right;larrow.src=this.resources.larrow;rarrow.src=this.resources.rarrow;larrow.onload=(function(){this.arrows.ldraw.x=center.x-(this.arrows.left.width<<1);this.arrows.ldraw.y=center.y-(this.arrows.left.height>>1);var ctx=this.canvas.getContext('2d');ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y);}).bind(this);rarrow.onload=(function(){this.arrows.rdraw.x=center.x+(this.arrows.right.width);this.arrows.rdraw.y=center.y-(this.arrows.right.height>>1);var ctx=this.canvas.getContext('2d');ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y);}).bind(this);this.width=this._dpx(window.innerWidth);this.height=this._dpx(80);this.canvas.width=this.width;this.canvas.height=this.height;this.canvas.style.width=window.innerWidth+'px';this.canvas.style.height=80+'px';this.center.x=this.canvas.offsetLeft+this.canvas.width>>1;this.center.y=this.canvas.offsetTop+this.canvas.height>>1;this.handle.radius=this._dpx(this.handle.radius);this.track.radius=this.handle.radius+this._dpx(1);this.handle.lineWidth=this._dpx(this.handle.lineWidth);this.handle.autoExpand.sentinelOffset=this._dpx(this.handle.autoExpand.sentinelOffset);this.canvas.getContext('2d').save();this.canvas.getContext('2d',this.handle.radius<<1,0);this._resetHandle();this._resetTouchStates();var trackLength='tiny'===this.layout?this.track.length.tiny:this.track.length.large;trackLength=this._dpx(trackLength);var maxWidth=(trackLength-
(this.handle.radius<<1))>>1;maxWidth-=2;this.handle.maxWidth=maxWidth;this.handle.autoExpand.sentinelWidth=maxWidth-this.handle.autoExpand.sentinelOffset;this.track.width=trackLength;this.track.from=this.center.x-maxWidth;this.track.to=this.center.x+maxWidth;this.track.y=this.center.y;this._drawTrack();};LockScreenSlidePrototype._finalizeCanvas=function lss_finalizeCanvas(){this.states.slidingColorful=false;this.states.slidingColorGradientEnd=false,this._clearCanvas();};LockScreenSlidePrototype._onSliding=function lss_onSliding(tx){var mtx=this._mapCoord(tx,0)[0];var isLeft=tx-this.center.x<0;this._clearCanvas();var expandSentinelR=this.center.x+
this.handle.autoExpand.sentinelWidth;var expandSentinelL=this.center.x-
this.handle.autoExpand.sentinelWidth;var center=this.center;var radius=this.handle.radius;var ctx=this.canvas.getContext('2d');if(tx>expandSentinelR||tx<expandSentinelL){var prevState=this.handle.autoExpand.accState;this.handle.autoExpand.accState='accelerating';var currentState=this.handle.autoExpand.accState;var slow=false;if(isLeft){slow=this.states.touch.deltaX>0;if(prevState!==currentState)
this.publish('lockscreenslide-near-left',{'currentState':currentState,'prevState':prevState});}else{slow=this.states.touch.deltaX<0;if(prevState!==currentState)
this.publish('lockscreenslide-near-right',{'currentState':currentState,'prevState':prevState});}}else{var prevState=this.handle.autoExpand.accState;this.handle.autoExpand.accState='normal';var currentState=this.handle.autoExpand.accState;if(prevState!==currentState){if(isLeft){if(prevState!==currentState)
this.publish('lockscreenslide-near-left',{'currentState':currentState,'prevState':prevState});}else{if(prevState!==currentState)
this.publish('lockscreenslide-near-right',{'currentState':currentState,'prevState':prevState});}}}
mtx=this._accelerateSlide(tx);this._drawTrack();this._drawArrowsTo(mtx);this._drawSlideTo(mtx);};LockScreenSlidePrototype._onSlideBegin=function lss_onSlideBegin(tx){var canvasCenterX=this.canvas.clientWidth>>1;var center=this.center;var boundaryR=center.x+this.handle.radius;var boundaryL=center.x-this.handle.radius;if(tx>boundaryR||tx<boundaryL){this.states.sliding=false;return;}
this.publish('lockscreenslide-unlocking-start');this.states.touch.initX=tx;this.states.sliding=true;this._lightIcons();};LockScreenSlidePrototype._endGesture=function lss_endGesture(){window.removeEventListener('touchmove',this);window.removeEventListener('touchend',this);this.states.sliding=false;this._onSlideEnd();this._resetTouchStates();this.overlay.classList.remove('touched');this.states.slideReachEnd=false;};LockScreenSlidePrototype._onSlideEnd=function lss_onSlideEnd(){var isLeft=this.states.touch.pageX-this.center.x<0;var bounceEnd=(function _bounceEnd(){this._clearCanvas();this._drawTrack();this._resetArrows();this._resetHandle();}).bind(this);if(false===this.states.slideReachEnd){this._bounceBack(this.states.touch.pageX,bounceEnd);}else{var intention=isLeft?'lockscreenslide-activate-left':'lockscreenslide-activate-right';this.publish(intention);var appLaunchDelay=400;setTimeout(bounceEnd,appLaunchDelay);}
this.publish('lockscreenslide-unlocking-stop');this._darkIcons();};LockScreenSlidePrototype._onTouchMove=function ls_handleMove(pageX,pageY){var touch=this.states.touch;if(!touch.touched){if(!this.states.sliding)
return;touch.touched=true;touch.initX=pageX;var overlay=this.overlay;overlay.classList.add('touched');}
touch.tx=pageX-touch.initX;touch.pageX=pageX;if(-1!==touch.pageX){touch.deltaX=pageX-touch.prevX;}
touch.prevX=pageX;};LockScreenSlidePrototype._accelerateSlide=function lss_accelerateSlide(tx){var isLeft=tx-this.center.x<0;var dx=Math.abs(tx-this.center.x);var accFactor=this.handle.autoExpand.accFactor;var acc=Math.pow(dx,accFactor);var accTx=tx+acc;if(isLeft)
accTx=tx-acc;if(accTx<0)
accTx=0;return accTx;};LockScreenSlidePrototype._clearCanvas=function lss_clearCanvas(){var canvas=this.canvas;var ctx=canvas.getContext('2d');ctx.clearRect(0,0,canvas.width,canvas.height);};LockScreenSlidePrototype._bounceBack=function lss_bounceBack(tx,cb){var canvas=this.canvas;var ctx=canvas.getContext('2d');var duration=this.handle.bounceBackTime;var center=this.center;var nextTx=tx;var tsBegin=null;var mspf=0;var interval=1;var isLeft=tx-center.x<0;var drawIt=(function _drawIt(ts){if(null===tsBegin)
tsBegin=ts;if(ts-tsBegin<duration){if(0===mspf)
mspf=ts-tsBegin;interval=Math.abs(center.x-tx)/(duration/mspf);nextTx=isLeft?nextTx+interval:nextTx-interval;if((isLeft&&nextTx<center.x)||(!isLeft&&nextTx>=center.x)){this._clearCanvas();this._drawTrack();this._drawArrowsTo(nextTx);this._drawSlideTo(nextTx);}
requestAnimationFrame(drawIt);}else{this._clearCanvas();this._drawTrack();this._drawArrowsTo(center.x);this._drawSlideTo(center.x);if(cb)
cb();}}).bind(this);requestAnimationFrame(drawIt);};LockScreenSlidePrototype._darkIcons=function lss_darkIcons(){this.areas.left.classList.add('dark');this.areas.right.classList.add('dark');};LockScreenSlidePrototype._drawArrowsTo=function lss_drawArrows(tx){var canvas=this.canvas;var ctx=canvas.getContext('2d');var radius=this.handle.radius;var center=this.center;var offset=tx-center.x;var isLeft=offset<0;if(this.handle.maxWidth<Math.abs(offset)){this.states.slideReachEnd=true;return;}
this.states.slideReachEnd=false;if(isLeft){ctx.drawImage(this.arrows.left,tx-(this.arrows.left.width<<1),this.arrows.ldraw.y);ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.ldraw.y);}else{ctx.drawImage(this.arrows.right,tx+this.arrows.right.width,this.arrows.rdraw.y);ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y);}};LockScreenSlidePrototype._drawTrack=function lss_drawTrack(){var canvas=this.canvas;var ctx=canvas.getContext('2d');var radius=this.track.radius;var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var strokeStyle=this.track.color;ctx.fillStyle='rgba(0, 0, 0, 0)';ctx.lineWidth=this.handle.lineWidth;ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(this.track.from,this.track.y,radius,endAngle,startAngle,false);ctx.lineTo(this.track.from,this.track.y-radius);ctx.lineTo(this.track.to,this.track.y-radius);ctx.arc(this.track.to,this.track.y,radius,startAngle,endAngle,false);ctx.lineTo(this.track.from,this.track.y+radius);ctx.stroke();ctx.closePath();};LockScreenSlidePrototype._drawSlideTo=function lss_drawSlideTo(tx){var canvas=this.canvas;var ctx=canvas.getContext('2d');var maxWidth=this.handle.maxWidth;var offset=tx;var radius=this.handle.radius;var center=this.center;var rw=offset-center.x;var urw=Math.abs(rw);if(this.handle.maxWidth<urw){offset=rw>0?center.x+maxWidth:center.x-maxWidth;}
var counterclock=false;if(offset-center.x<0){counterclock=true;}
var isLeft=counterclock;if(isLeft&&!this.handle.towardLeft){this.handle.towardLeft=true;this.handle.touchedColor=this.colors.left.touchedColor;this.handle.touchedColorStop=this.colors.left.touchedColorStop;}
if(!isLeft&&this.handle.towardLeft){this.handle.towardLeft=false;this.handle.touchedColor=this.colors.right.touchedColor;this.handle.touchedColorStop=this.colors.right.touchedColorStop;}
var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var fillAlpha=0.0;var strokeStyle='white';const GRADIENT_LENGTH=50;if(urw>15&&true!==this.states.slidingColorful){fillAlpha=(urw-15)/GRADIENT_LENGTH;if(fillAlpha>1.0){fillAlpha=1.0;this.states.slidingColorGradientEnd=true;}
var borderAlpha=1.0-fillAlpha;strokeStyle='rgba('+this.handle.touchedColorStop+','+borderAlpha+')';this.states.slidingColorful=true;}else{if(0===urw){fillAlpha=0.0;var color='255,255,255';}else{fillAlpha=(urw-15)/GRADIENT_LENGTH;if(fillAlpha>1.0){fillAlpha=1.0;}
var color=this.handle.touchedColorStop;}
var borderAlpha=1.0-fillAlpha;strokeStyle='rgba('+color+','+borderAlpha+')';}
ctx.fillStyle='rgba('+this.handle.touchedColor+','+fillAlpha+')';ctx.lineWidth=this.handle.lineWidth;ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(center.x,center.y,radius,endAngle,startAngle,counterclock);ctx.lineTo(center.x,center.y-radius);ctx.lineTo(center.x+(offset-center.x),center.y-radius);ctx.arc(offset,center.y,radius,startAngle,endAngle,counterclock);ctx.lineTo(center.x,center.y+radius);ctx.fill();ctx.stroke();ctx.closePath();};LockScreenSlidePrototype._dpx=function lss_dpx(px){return px*window.devicePixelRatio;};LockScreenSlidePrototype._lightIcons=function lss_lightIcons(){this.areas.left.classList.remove('dark');this.areas.right.classList.remove('dark');};LockScreenSlidePrototype._mapCoord=function lss_mapCoord(x,y){var cw=this.canvas.clientWidth;var ch=this.canvas.clientHeight;return[cw*x/window.innerWidth,ch*y/window.innerHeight];};LockScreenSlidePrototype._resetArrows=function lss_restoreArrows(){var canvas=this.canvas;var ctx=canvas.getContext('2d');var center=this.center;ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y);ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y);};LockScreenSlidePrototype._resetHandle=function lss_resetHandle(){this.states.slidingColorful=false;this.states.slidingColorGradientEnd=false;var canvas=this.canvas;var centerx=this.center.x;this._drawSlideTo(centerx);};LockScreenSlidePrototype._resetTouchStates=function lss_resetTouchStates(){this.states.touch={id:null,touched:false,initX:this.center.x,pageX:this.center.x,pageY:this.center.y,tx:0,prevX:this.center.x,deltaX:0};};LockScreenSlidePrototype.publish=function lss_publish(type,detail){window.dispatchEvent(new CustomEvent(type,{'detail':detail}));};LockScreenSlide.prototype=LockScreenSlidePrototype;exports.LockScreenSlide=LockScreenSlide;})(window);;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media)
continue;window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();