;'use strict';var GestureDetector=(function(){function GD(e,options){this.element=e;this.options=options||{};this.options.panThreshold=this.options.panThreshold||GD.PAN_THRESHOLD;this.options.mousePanThreshold=this.options.mousePanThreshold||GD.MOUSE_PAN_THRESHOLD;this.state=initialState;this.timers={};this.listeningForMouseEvents=true;}
GD.prototype.startDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.addEventListener(t,self);});};GD.prototype.stopDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.removeEventListener(t,self);});};GD.prototype.handleEvent=function(e){var handler=this.state[e.type];if(!handler)return;if(e.changedTouches){if(this.listeningForMouseEvents){this.listeningForMouseEvents=false;this.element.removeEventListener('mousedown',this);}
if(e.type==='touchend'&&e.changedTouches.length>1){console.warn('gesture_detector.js: spurious extra changed touch on '+'touchend. See '+'https://bugzilla.mozilla.org/show_bug.cgi?id=785554');}
for(var i=0;i<e.changedTouches.length;i++){handler(this,e,e.changedTouches[i]);handler=this.state[e.type];}}
else{handler(this,e);}};GD.prototype.startTimer=function(type,time){this.clearTimer(type);var self=this;this.timers[type]=setTimeout(function(){self.timers[type]=null;var handler=self.state[type];if(handler)
handler(self,type);},time);};GD.prototype.clearTimer=function(type){if(this.timers[type]){clearTimeout(this.timers[type]);this.timers[type]=null;}};GD.prototype.switchTo=function(state,event,touch){this.state=state;if(state.init)
state.init(this,event,touch);};GD.prototype.emitEvent=function(type,detail){if(!this.target){console.error('Attempt to emit event with no target');return;}
var event=this.element.ownerDocument.createEvent('CustomEvent');event.initCustomEvent(type,true,true,detail);this.target.dispatchEvent(event);};GD.HOLD_INTERVAL=1000;GD.PAN_THRESHOLD=20;GD.MOUSE_PAN_THRESHOLD=15;GD.DOUBLE_TAP_DISTANCE=50;GD.DOUBLE_TAP_TIME=500;GD.VELOCITY_SMOOTHING=.5;GD.SCALE_THRESHOLD=20;GD.ROTATE_THRESHOLD=22.5;GD.THRESHOLD_SMOOTHING=0.9;var abs=Math.abs,floor=Math.floor,sqrt=Math.sqrt,atan2=Math.atan2;var PI=Math.PI;var eventtypes=['touchstart','touchmove','touchend','mousedown'];function eventTime(e){var ts=e.timeStamp;if(ts>2*Date.now())
return Math.floor(ts/1000);else
return ts;}
function coordinates(e,t){return Object.freeze({screenX:t.screenX,screenY:t.screenY,clientX:t.clientX,clientY:t.clientY,timeStamp:eventTime(e)});}
function midpoints(e,t1,t2){return Object.freeze({screenX:floor((t1.screenX+t2.screenX)/2),screenY:floor((t1.screenY+t2.screenY)/2),clientX:floor((t1.clientX+t2.clientX)/2),clientY:floor((t1.clientY+t2.clientY)/2),timeStamp:eventTime(e)});}
function mouseCoordinates(e){return Object.freeze({screenX:e.screenX,screenY:e.screenY,clientX:e.clientX,clientY:e.clientY,timeStamp:eventTime(e)});}
function between(c1,c2){var r=GD.THRESHOLD_SMOOTHING;return Object.freeze({screenX:floor(c1.screenX+r*(c2.screenX-c1.screenX)),screenY:floor(c1.screenY+r*(c2.screenY-c1.screenY)),clientX:floor(c1.clientX+r*(c2.clientX-c1.clientX)),clientY:floor(c1.clientY+r*(c2.clientY-c1.clientY)),timeStamp:floor(c1.timeStamp+r*(c2.timeStamp-c1.timeStamp))});}
function touchDistance(t1,t2){var dx=t2.screenX-t1.screenX;var dy=t2.screenY-t1.screenY;return sqrt(dx*dx+dy*dy);}
function touchDirection(t1,t2){return atan2(t2.screenY-t1.screenY,t2.screenX-t1.screenX)*180/PI;}
function touchRotation(d1,d2){var angle=d2-d1;if(angle>180)
angle-=360;else if(angle<=-180)
angle+=360;return angle;}
function isDoubleTap(lastTap,thisTap){var dx=abs(thisTap.screenX-lastTap.screenX);var dy=abs(thisTap.screenY-lastTap.screenY);var dt=thisTap.timeStamp-lastTap.timeStamp;return(dx<GD.DOUBLE_TAP_DISTANCE&&dy<GD.DOUBLE_TAP_DISTANCE&&dt<GD.DOUBLE_TAP_TIME);}
var initialState={name:'initialState',init:function(d){d.target=null;d.start=d.last=null;d.touch1=d.touch2=null;d.vx=d.vy=null;d.startDistance=d.lastDistance=null;d.startDirection=d.lastDirection=null;d.lastMidpoint=null;d.scaled=d.rotated=null;},touchstart:function(d,e,t){d.switchTo(touchStartedState,e,t);},mousedown:function(d,e){d.switchTo(mouseDownState,e);}};var touchStartedState={name:'touchStartedState',init:function(d,e,t){d.target=e.target;d.touch1=t.identifier;d.start=d.last=coordinates(e,t);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},touchstart:function(d,e,t){d.clearTimer('holdtimeout');d.switchTo(transformState,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;if(abs(t.screenX-d.start.screenX)>d.options.panThreshold||abs(t.screenY-d.start.screenY)>d.options.panThreshold){d.clearTimer('holdtimeout');d.switchTo(panStartedState,e,t);}},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=coordinates(e,t);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(holdState);}};var panStartedState={name:'panStartedState',init:function(d,e,t){d.start=d.last=between(d.start,coordinates(e,t));if(e.type==='touchmove')
panStartedState.touchmove(d,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:e.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};var holdState={name:'holdState',init:function(d){d.emitEvent('holdstart',d.start);},touchmove:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},touchend:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var transformState={name:'transformState',init:function(d,e,t){d.touch2=t.identifier;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);d.startDistance=d.lastDistance=touchDistance(t1,t2);d.startDirection=d.lastDirection=touchDirection(t1,t2);d.scaled=d.rotated=false;},touchmove:function(d,e,t){if(t.identifier!==d.touch1&&t.identifier!==d.touch2)
return;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);var midpoint=midpoints(e,t1,t2);var distance=touchDistance(t1,t2);var direction=touchDirection(t1,t2);var rotation=touchRotation(d.startDirection,direction);if(!d.scaled){if(abs(distance-d.startDistance)>GD.SCALE_THRESHOLD){d.scaled=true;d.startDistance=d.lastDistance=floor(d.startDistance+
GD.THRESHOLD_SMOOTHING*(distance-d.startDistance));}
else
distance=d.startDistance;}
if(!d.rotated){if(abs(rotation)>GD.ROTATE_THRESHOLD)
d.rotated=true;else
direction=d.startDirection;}
if(d.scaled||d.rotated){d.emitEvent('transform',{absolute:{scale:distance/d.startDistance,rotate:touchRotation(d.startDirection,direction)},relative:{scale:distance/d.lastDistance,rotate:touchRotation(d.lastDirection,direction)},midpoint:midpoint});d.lastDistance=distance;d.lastDirection=direction;d.lastMidpoint=midpoint;}},touchend:function(d,e,t){if(t.identifier===d.touch2)
d.touch2=null;else if(t.identifier===d.touch1){d.touch1=d.touch2;d.touch2=null;}
else
return;if(d.scaled||d.rotated){d.emitEvent('transformend',{absolute:{scale:d.lastDistance/d.startDistance,rotate:touchRotation(d.startDirection,d.lastDirection)},relative:{scale:1,rotate:0},midpoint:d.lastMidpoint});}
d.switchTo(afterTransformState);}};var afterTransformState={name:'afterTransformState',touchstart:function(d,e,t){d.switchTo(transformState,e,t);},touchend:function(d,e,t){if(t.identifier===d.touch1)
d.switchTo(initialState);}};var mouseDownState={name:'mouseDownState',init:function(d,e){d.target=e.target;var doc=d.element.ownerDocument;doc.addEventListener('mousemove',d,true);doc.addEventListener('mouseup',d,true);d.start=d.last=mouseCoordinates(e);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},mousemove:function(d,e){if(abs(e.screenX-d.start.screenX)>d.options.mousePanThreshold||abs(e.screenY-d.start.screenY)>d.options.mousePanThreshold){d.clearTimer('holdtimeout');d.switchTo(mousePannedState,e);}},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=mouseCoordinates(e);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(mouseHoldState);}};var mouseHoldState={name:'mouseHoldState',init:function(d){d.emitEvent('holdstart',d.start);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},mouseup:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var mousePannedState={name:'mousePannedState',init:function(d,e){d.start=d.last=between(d.start,mouseCoordinates(e));if(e.type==='mousemove')
mousePannedState.mousemove(d,e);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);var current=mouseCoordinates(e);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:current.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};return GD;}());;(function(exports){'use strict';function round(x){return Math.round(x*100)/100;}
function MozSampleSize(n,scale){return Object.freeze({dimensionScale:round(scale),areaScale:round(scale*scale),toString:function(){return'#-moz-samplesize='+n;},scale:function(x){return Math.ceil(x*scale);}});}
var NONE=Object.freeze({dimensionScale:1,areaScale:1,toString:function(){return'';},scale:function(x){return x;}});var fragments=[NONE,MozSampleSize(2,1/2),MozSampleSize(3,3/8),MozSampleSize(4,1/4),MozSampleSize(8,1/8)];function sizeAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.dimensionScale<=scale){return f;}}
return fragments[fragments.length-1];}
function sizeNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.dimensionScale>=scale){return f;}}
return NONE;}
function areaAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.areaScale<=scale){return f;}}
return fragments[fragments.length-1];}
function areaNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.areaScale>=scale){return f;}}
return NONE;}
exports.Downsample={sizeAtLeast:sizeAtLeast,sizeNoMoreThan:sizeNoMoreThan,areaAtLeast:areaAtLeast,areaNoMoreThan:areaNoMoreThan,NONE:NONE,MAX_SIZE_REDUCTION:1/fragments[fragments.length-1].dimensionScale,MAX_AREA_REDUCTION:1/fragments[fragments.length-1].areaScale};}(window));;function MediaFrame(container,includeVideo,maxImageSize){if(typeof container==='string')
container=document.getElementById(container);this.container=container;this.maximumImageSize=maxImageSize||0;if(includeVideo!==false){this.video=new VideoPlayer(container);this.video.hide();}
this.displayingVideo=false;this.displayingImage=false;this.imageblob=null;this.previewblob=null;this.videoblob=null;this.posterblob=null;this.url=null;var self=this;}
MediaFrame.prototype.displayImage=function displayImage(blob,width,height,preview,rotation,mirrored)
{var self=this;this.clear();this.imageblob=blob;this.preview=preview;this.fullSampleSize=computeFullSampleSize(blob,width,height);this.fullsizeWidth=this.fullSampleSize.scale(width);this.fullsizeHeight=this.fullSampleSize.scale(height);this.rotation=rotation||0;this.mirrored=mirrored||false;this.displayingImage=true;function usePreview(preview){if(!preview)
return false;if(!preview.width||!preview.height)
return false;if(!preview.start&&!preview.filename)
return false;if(Math.abs(width/height-preview.width/preview.height)>0.01)
return false;if(self.minimumPreviewWidth&&self.minimumPreviewHeight){return Math.max(preview.width,preview.height)>=Math.max(self.minimumPreviewWidth,self.minimumPreviewHeight)&&Math.min(preview.width,preview.height)>=Math.min(self.minimumPreviewWidth,self.minimumPreviewHeight);}
var screenWidth=window.innerWidth*window.devicePixelRatio;var screenHeight=window.innerHeight*window.devicePixelRatio;return((preview.width>=screenWidth||preview.height>=screenHeight)&&(preview.width>=screenHeight||preview.height>=screenWidth));}
if(usePreview(preview)){if(preview.start){this.previewblob=blob.slice(preview.start,preview.end,'image/jpeg');this.previewSampleSize=Downsample.NONE;this._displayImage(this.previewblob,true);}
else{var storage=navigator.getDeviceStorage('pictures');var getreq=storage.get(preview.filename);getreq.onsuccess=function(){self.previewblob=getreq.result;self.previewSampleSize=Downsample.NONE;self._displayImage(self.previewblob,true);};getreq.onerror=function(){self.preview=null;self.previewblob=null;self.previewSampleSize=computePreviewSampleSize(blob,width,height);self._displayImage(blob,self.previewSampleSize!==Downsample.NONE);};}}
else{this.preview=null;this.previewblob=null;this.previewSampleSize=computePreviewSampleSize(blob,width,height);this._displayImage(blob,this.previewSampleSize!==Downsample.NONE);}
function computeFullSampleSize(blob,width,height){if(blob.type!=='image/jpeg'){return Downsample.NONE;}
if(!self.maximumImageSize||width*height<=self.maximumImageSize){return Downsample.NONE;}
return Downsample.areaAtLeast(self.maximumImageSize/(width*height));}
function computePreviewSampleSize(blob,width,height){if(blob.type!=='image/jpeg'){return Downsample.NONE;}
var screenWidth=window.innerWidth*window.devicePixelRatio;var screenHeight=window.innerHeight*window.devicePixelRatio;var portraitScale=Math.min(screenWidth/width,screenHeight/height);var landscapeScale=Math.min(screenHeight/width,screenWidth/height);var scale=Math.max(portraitScale,landscapeScale);return Downsample.sizeNoMoreThan(scale);}};MediaFrame.prototype._displayImage=function _displayImage(blob,isPreview){var self=this;this._clearImage();this.image=document.createElement('img');this.image.style.transformOrigin='center center';this.image.style.display='none';this.container.appendChild(this.image);this.displayingPreview=isPreview;if(this.url)
URL.revokeObjectURL(this.url);this.url=URL.createObjectURL(blob);this.image.onerror=function(e){console.error('failed to load image',self.image.url,e);if(self.onerror)
self.onerror(e);};this.image.onload=function(e){self.image.onload=null;if(self.rotation==0||self.rotation==180){self.itemWidth=self.image.width;self.itemHeight=self.image.height;}else{self.itemWidth=self.image.height;self.itemHeight=self.image.width;}
self.computeFit();self.setPosition();self.image.style.display='block';};this.image.src=this.url+
(isPreview?this.previewSampleSize:this.fullSampleSize);};MediaFrame.prototype._switchToFullSizeImage=function _switchToFull(){if(!this.displayingImage||!this.displayingPreview)
return;var self=this;this.displayingPreview=false;var oldimage=this.oldimage=this.image;var newimage=this.image=document.createElement('img');newimage.style.transformOrigin='center center';if(this.previewblob){URL.revokeObjectURL(this.url);this.url=URL.createObjectURL(this.imageblob);}
newimage.src=this.url+this.fullSampleSize;newimage.onerror=oldimage.onerror;oldimage.onerror=null;this.container.insertBefore(newimage,oldimage);if(this.rotation==0||this.rotation==180){this.itemWidth=this.oldimage.width=this.fullsizeWidth;this.itemHeight=this.oldimage.height=this.fullsizeHeight;}else{this.itemWidth=this.oldimage.height=this.fullsizeHeight;this.itemHeight=this.oldimage.width=this.fullsizeWidth;}
this.computeFit();this.setPosition();if(this.oldimage){var temp=this.oldimage.clientLeft;temp=this.image.clientLeft;}
newimage.onload=function imageLoaded(){newimage.onload=null;if(newimage.width!==self.fullsizeWidth){console.warn('#-moz-samplesize did not scale as expected',newimage.width,self.fullsizeWidth);self.itemWidth=self.fullsizeWidth=newimage.width;self.itemHeight=self.fullsizeHeight=newimage.height;}
self.imageSwitchTimeout=setTimeout(function(){self.imageSwitchTimeout=null;if(self.oldimage){self.container.removeChild(self.oldimage);self.oldimage.onload=null;self.oldimage.src='';self.oldimage=null;}},1000);};};MediaFrame.prototype._switchToPreviewImage=function _switchToPreview(){if(!this.displayingImage||this.displayingPreview)
return;this._displayImage(this.previewblob||this.imageblob,true);};MediaFrame.prototype.displayVideo=function displayVideo(videoblob,posterblob,width,height,rotation)
{if(!this.video)
return;this.clear();this.displayingVideo=true;this.videoblob=videoblob;this.posterblob=posterblob;this.videourl=URL.createObjectURL(videoblob);this.posterurl=URL.createObjectURL(posterblob);this.video.load(this.videourl,this.posterurl,width,height,rotation||0);this.video.show();};MediaFrame.prototype._clearImage=function _clearImage(){if(this.image){this.container.removeChild(this.image);this.image.onload=null;this.image.onerror=null;this.image.src='';this.image=null;}};MediaFrame.prototype.clear=function clear(){this.displayingImage=false;this.displayingPreview=false;this.displayingVideo=false;this.itemWidth=this.itemHeight=null;this.imageblob=null;this.previewblob=null;this.videoblob=null;this.posterblob=null;this.fullsizeWidth=this.fullsizeHeight=null;this.preview=null;this.fit=null;if(this.url){URL.revokeObjectURL(this.url);this.url=null;}
this._clearImage();if(this.imageSwitchTimeout){clearTimeout(this.imageSwitchTimeout);this.imageSwitchTimeout=null;}
if(this.oldimage){this.container.removeChild(this.oldimage);this.oldimage.onload=null;this.oldimage.onerror=null;this.oldimage.src='';this.oldimage=null;}
if(this.video){this.video.reset();this.video.hide();if(this.videourl)
URL.revokeObjectURL(this.videourl);if(this.posterurl)
URL.revokeObjectURL(this.posterurl);}};MediaFrame.prototype.setPosition=function setPosition(){if(!this.fit||!this.displayingImage)
return;var dx=this.fit.left,dy=this.fit.top;switch(this.rotation){case 0:case 180:dx+=(this.fit.width-this.itemWidth)/2;dy+=(this.fit.height-this.itemHeight)/2;break;case 90:case 270:dx+=(this.fit.width-this.itemHeight)/2;dy+=(this.fit.height-this.itemWidth)/2;break;}
var sx=this.mirrored?-this.fit.scale:this.fit.scale;var sy=this.fit.scale;var transform='translate('+dx+'px, '+dy+'px) '+'scale('+sx+','+sy+')'+'rotate('+this.rotation+'deg) ';this.image.style.transform=transform;if(this.oldimage)
this.oldimage.style.transform=transform;};MediaFrame.prototype.computeFit=function computeFit(){if(!this.displayingImage)
return;this.viewportWidth=this.container.offsetWidth;this.viewportHeight=this.container.offsetHeight;var scalex=this.viewportWidth/this.itemWidth;var scaley=this.viewportHeight/this.itemHeight;var scale=Math.min(Math.min(scalex,scaley),1);var width=Math.floor(this.itemWidth*scale);var height=Math.floor(this.itemHeight*scale);this.fit={width:width,height:height,left:Math.floor((this.viewportWidth-width)/2),top:Math.floor((this.viewportHeight-height)/2),scale:scale,baseScale:scale};};MediaFrame.prototype.reset=function reset(){if(this.displayingImage&&!this.displayingPreview&&(this.previewblob||this.previewSampleSize!==Downsample.NONE)){this._switchToPreviewImage();return;}
this.computeFit();this.setPosition();if(this.displayingVideo)
this.video.setPlayerSize();};MediaFrame.prototype.resize=function resize(){var oldWidth=this.viewportWidth;var oldHeight=this.viewportHeight;var newWidth=this.container.offsetWidth;var newHeight=this.container.offsetHeight;var oldfit=this.fit;if(!oldfit)
return;this.computeFit();var newfit=this.fit;if(Math.abs(oldfit.scale-oldfit.baseScale)<0.01||newfit.baseScale>oldfit.scale){this.reset();return;}
oldfit.left+=(newWidth-oldWidth)/2;oldfit.top+=(newHeight-oldHeight)/2;oldfit.baseScale=newfit.baseScale;this.fit=oldfit;this.setPosition();};MediaFrame.prototype.zoom=function zoom(scale,fixedX,fixedY,time){if(!this.displayingImage)
return;if(this.displayingPreview)
this._switchToFullSizeImage();if(this.fit.scale*scale>1){scale=1/(this.fit.scale);}
else if(this.fit.scale*scale<this.fit.baseScale){scale=this.fit.baseScale/this.fit.scale;}
this.fit.scale=this.fit.scale*scale;this.fit.width=Math.floor(this.itemWidth*this.fit.scale);this.fit.height=Math.floor(this.itemHeight*this.fit.scale);var photoX=fixedX-this.fit.left;var photoY=fixedY-this.fit.top;photoX=Math.floor(photoX*scale);photoY=Math.floor(photoY*scale);this.fit.left=fixedX-photoX;this.fit.top=fixedY-photoY;if(this.fit.width<=this.viewportWidth){this.fit.left=(this.viewportWidth-this.fit.width)/2;}
else{if(this.fit.left>0)
this.fit.left=0;if(this.fit.left+this.fit.width<this.viewportWidth){this.fit.left=this.viewportWidth-this.fit.width;}}
if(this.fit.height<=this.viewportHeight){this.fit.top=(this.viewportHeight-this.fit.height)/2;}
else{if(this.fit.top>0)
this.fit.top=0;if(this.fit.top+this.fit.height<this.viewportHeight){this.fit.top=this.viewportHeight-this.fit.height;}}
if(time){var transition='transform '+time+'ms ease';this.image.style.transition=transition;if(this.oldimage)
this.oldimage.style.transition=transition;var self=this;this.image.addEventListener('transitionend',function done(){self.image.removeEventListener('transitionend',done);self.image.style.transition=null;});}
this.setPosition();};MediaFrame.prototype.pan=function(dx,dy){if(!this.displayingImage){return dx;}
if(this.fit.height>this.viewportHeight){this.fit.top+=dy;if(this.fit.top>0)
this.fit.top=0;if(this.fit.top+this.fit.height<this.viewportHeight)
this.fit.top=this.viewportHeight-this.fit.height;}
var extra=0;if(this.fit.width<=this.viewportWidth){extra=dx;}
else{this.fit.left+=dx;if(this.fit.left>0){extra=this.fit.left;this.fit.left=0;}
if(this.fit.left+this.fit.width<this.viewportWidth){extra=this.fit.left+this.fit.width-this.viewportWidth;this.fit.left=this.viewportWidth-this.fit.width;}}
this.setPosition();return extra;};MediaFrame.prototype.setMinimumPreviewSize=function(w,h){this.minimumPreviewWidth=w;this.minimumPreviewHeight=h;};;'use strict';var BlobView=(function(){function fail(msg){throw Error(msg);}
function BlobView(blob,sliceOffset,sliceLength,slice,viewOffset,viewLength,littleEndian)
{this.blob=blob;this.sliceOffset=sliceOffset;this.sliceLength=sliceLength;this.slice=slice;this.viewOffset=viewOffset;this.viewLength=viewLength;this.littleEndian=littleEndian;this.view=new DataView(slice,viewOffset,viewLength);this.buffer=slice;this.byteLength=viewLength;this.byteOffset=viewOffset;this.index=0;}
BlobView.get=function(blob,offset,length,callback,littleEndian){if(offset<0)
fail('negative offset');if(length<0)
fail('negative length');if(offset>blob.size)
fail('offset larger than blob size');if(offset+length>blob.size)
length=blob.size-offset;var slice=blob.slice(offset,offset+length);var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){var result=null;if(reader.result){result=new BlobView(blob,offset,length,reader.result,0,length,littleEndian||false);}
callback(result,reader.error);};};BlobView.prototype={constructor:BlobView,getMore:function(offset,length,callback){if(offset>=this.sliceOffset&&offset+length<=this.sliceOffset+this.sliceLength){callback(new BlobView(this.blob,this.sliceOffset,this.sliceLength,this.slice,offset-this.sliceOffset,length,this.littleEndian));}
else{BlobView.get(this.blob,offset,length,callback,this.littleEndian);}},littleEndian:function(){this.littleEndian=true;},bigEndian:function(){this.littleEndian=false;},getUint8:function(offset){return this.view.getUint8(offset);},getInt8:function(offset){return this.view.getInt8(offset);},getUint16:function(offset,le){return this.view.getUint16(offset,le!==undefined?le:this.littleEndian);},getInt16:function(offset,le){return this.view.getInt16(offset,le!==undefined?le:this.littleEndian);},getUint32:function(offset,le){return this.view.getUint32(offset,le!==undefined?le:this.littleEndian);},getInt32:function(offset,le){return this.view.getInt32(offset,le!==undefined?le:this.littleEndian);},getFloat32:function(offset,le){return this.view.getFloat32(offset,le!==undefined?le:this.littleEndian);},getFloat64:function(offset,le){return this.view.getFloat64(offset,le!==undefined?le:this.littleEndian);},readByte:function(){return this.view.getInt8(this.index++);},readUnsignedByte:function(){return this.view.getUint8(this.index++);},readShort:function(le){var val=this.view.getInt16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readUnsignedShort:function(le){var val=this.view.getUint16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readInt:function(le){var val=this.view.getInt32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readUnsignedInt:function(le){var val=this.view.getUint32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readFloat:function(le){var val=this.view.getFloat32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readDouble:function(le){var val=this.view.getFloat64(this.index,le!==undefined?le:this.littleEndian);this.index+=8;return val;},tell:function(){return this.index;},remaining:function(){return this.byteLength-this.index;},seek:function(index){if(index<0)
fail('negative index');if(index>this.byteLength)
fail('index greater than buffer size');this.index=index;},advance:function(n){var index=this.index+n;if(index<0)
fail('advance past beginning of buffer');if(index>this.byteLength)
fail('advance past end of buffer');this.index=index;},getUnsignedByteArray:function(offset,n){return new Uint8Array(this.buffer,offset+this.viewOffset,n);},readUnsignedByteArray:function(n){var val=new Uint8Array(this.buffer,this.index+this.viewOffset,n);this.index+=n;return val;},getBit:function(offset,bit){var byte=this.view.getUint8(offset);return(byte&(1<<bit))!==0;},getUint24:function(offset,le){var b1,b2,b3;if(le!==undefined?le:this.littleEndian){b1=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b3=this.view.getUint8(offset+2);}
else{b3=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b1=this.view.getUint8(offset+2);}
return(b3<<16)+(b2<<8)+b1;},readUint24:function(le){var value=this.getUint24(this.index,le);this.index+=3;return value;},getASCIIText:function(offset,len){var bytes=new Uint8Array(this.buffer,offset+this.viewOffset,len);return String.fromCharCode.apply(String,bytes);},readASCIIText:function(len){var bytes=new Uint8Array(this.buffer,this.index+this.viewOffset,len);this.index+=len;return String.fromCharCode.apply(String,bytes);},getUTF8Text:function(offset,len){function fail(){throw new Error('Illegal UTF-8');}
var pos=offset;var end=offset+len;var charcode;var s='';var b1,b2,b3,b4;while(pos<end){var b1=this.view.getUint8(pos);if(b1<128){s+=String.fromCharCode(b1);pos+=1;}
else if(b1<194){fail();}
else if(b1<224){if(pos+1>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();charcode=((b1&0x1f)<<6)+(b2&0x3f);s+=String.fromCharCode(charcode);pos+=2;}
else if(b1<240){if(pos+2>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();b3=this.view.getUint8(pos+2);if(b3<128||b3>191)
fail();charcode=((b1&0x0f)<<12)+((b2&0x3f)<<6)+(b3&0x3f);s+=String.fromCharCode(charcode);pos+=3;}
else if(b1<245){if(pos+3>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();b3=this.view.getUint8(pos+2);if(b3<128||b3>191)
fail();b4=this.view.getUint8(pos+3);if(b4<128||b4>191)
fail();charcode=((b1&0x07)<<18)+
((b2&0x3f)<<12)+
((b3&0x3f)<<6)+
(b4&0x3f);charcode-=0x10000;s+=String.fromCharCode(0xd800+((charcode&0x0FFC00)>>>10));s+=String.fromCharCode(0xdc00+(charcode&0x0003FF));pos+=4;}
else{fail();}}
return s;},readUTF8Text:function(len){try{return this.getUTF8Text(this.index,len);}
finally{this.index+=len;}},getID3Uint28BE:function(offset){var b1=this.view.getUint8(offset)&0x7f;var b2=this.view.getUint8(offset+1)&0x7f;var b3=this.view.getUint8(offset+2)&0x7f;var b4=this.view.getUint8(offset+3)&0x7f;return(b1<<21)|(b2<<14)|(b3<<7)|b4;},readID3Uint28BE:function(){var value=this.getID3Uint28BE(this.index);this.index+=4;return value;},readNullTerminatedLatin1Text:function(size){var s='';for(var i=0;i<size;i++){var charcode=this.view.getUint8(this.index+i);if(charcode===0){i++;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;},readNullTerminatedUTF8Text:function(size){for(var len=0;len<size;len++){if(this.view.getUint8(this.index+len)===0)
break;}
var s=this.readUTF8Text(len);if(len<size)
this.advance(1);return s;},readNullTerminatedUTF16Text:function(size,le){if(le==null){var BOM=this.readUnsignedShort();size-=2;if(BOM===0xFEFF)
le=false;else
le=true;}
var s='';for(var i=0;i<size;i+=2){var charcode=this.getUint16(this.index+i,le);if(charcode===0){i+=2;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;}};return{get:BlobView.get};}());;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;'use strict';function parseJPEGMetadata(file,metadataCallback,metadataError){var metadata={};BlobView.get(file,0,Math.min(16*1024,file.size),function(data){if(data.byteLength<2||data.getUint8(0)!==0xFF||data.getUint8(1)!==0xD8){metadataError('Not a JPEG file');return;}
getSegment(data,2,segmentHandler);});function getSegment(data,offset,callback){try{var header=data.getUint8(offset);if(header!==0xFF){metadataError('Malformed JPEG file: bad segment header');return;}
var type=data.getUint8(offset+1);var size=data.getUint16(offset+2)+2;var start=data.sliceOffset+data.viewOffset+offset;var isLast=(start+size>=file.size);var length=isLast?size:size+4;data.getMore(start,length,function(data){callback(type,size,data,isLast);});}
catch(e){metadataError(e.toString()+'\n'+e.stack);}}
function segmentHandler(type,size,data,isLastSegment){try{switch(type){case 0xC0:case 0xC1:case 0xC2:case 0xC3:metadata.height=data.getUint16(5);metadata.width=data.getUint16(7);metadataCallback(metadata);break;case 0xE1:parseAPP1(data);default:if(isLastSegment){metadataError('unexpected end of JPEG file');return;}
getSegment(data,size,segmentHandler);}}
catch(e){metadataError(e.toString()+'\n'+e.stack);}}
function parseAPP1(data){if(data.getUint32(4,false)===0x45786966){var exif=parseEXIFData(data);if(exif.THUMBNAIL&&exif.THUMBNAILLENGTH){var start=data.sliceOffset+data.viewOffset+10+exif.THUMBNAIL;metadata.preview={start:start,end:start+exif.THUMBNAILLENGTH};}
switch(exif.ORIENTATION){case undefined:case 1:metadata.rotation=0;metadata.mirrored=false;break;case 2:metadata.rotation=0;metadata.mirrored=true;break;case 3:metadata.rotation=180;metadata.mirrored=false;break;case 4:metadata.rotation=180;metadata.mirrored=true;break;case 5:metadata.rotation=90;metadata.mirrored=true;break;case 6:metadata.rotation=90;metadata.mirrored=false;break;case 7:metadata.rotation=270;metadata.mirrored=true;break;case 8:metadata.rotation=270;metadata.mirrored=false;break;default:throw Error('Unknown Exif code for orientation');}}}
function parseEXIFData(data){var exif={};var byteorder=data.getUint8(10);if(byteorder===0x4D){byteorder=false;}else if(byteorder===0x49){byteorder=true;}else{throw Error('invalid byteorder in EXIF segment');}
if(data.getUint16(12,byteorder)!==42){throw Error('bad magic number in EXIF segment');}
var offset=data.getUint32(14,byteorder);parseIFD(data,offset+10,byteorder,exif,true);var ifd0entries=data.getUint16(offset+10,byteorder);var ifd1=data.getUint32(offset+12+12*ifd0entries,byteorder);if(ifd1!==0)
parseIFD(data,ifd1+10,byteorder,exif,true);return exif;}
function parseIFD(data,offset,byteorder,exif,onlyParseOne){var numentries=data.getUint16(offset,byteorder);for(var i=0;i<numentries;i++){parseEntry(data,offset+2+12*i,byteorder,exif);}
if(onlyParseOne)
return;var next=data.getUint32(offset+2+12*numentries,byteorder);if(next!==0&&next<file.size){parseIFD(data,next+10,byteorder,exif);}}
var typesize=[0,1,1,2,4,8,1,1,2,4,8,4,8];var tagnames={'274':'ORIENTATION','513':'THUMBNAIL','514':'THUMBNAILLENGTH'};function parseEntry(data,offset,byteorder,exif){var tag=data.getUint16(offset,byteorder);var tagname=tagnames[tag];if(!tagname||exif[tagname])
return;var type=data.getUint16(offset+2,byteorder);var count=data.getUint32(offset+4,byteorder);var total=count*typesize[type];var valueOffset=total<=4?offset+8:data.getUint32(offset+8,byteorder);exif[tagname]=parseValue(data,valueOffset,type,count,byteorder);}
function parseValue(data,offset,type,count,byteorder){if(type===2){var codes=[];for(var i=0;i<count-1;i++){codes[i]=data.getUint8(offset+i);}
return String.fromCharCode.apply(String,codes);}else{if(count==1){return parseOneValue(data,offset,type,byteorder);}else{var values=[];var size=typesize[type];for(var i=0;i<count;i++){values[i]=parseOneValue(data,offset+size*i,type,byteorder);}
return values;}}}
function parseOneValue(data,offset,type,byteorder){switch(type){case 1:case 7:return data.getUint8(offset);case 2:return null;case 3:return data.getUint16(offset,byteorder);case 4:return data.getUint32(offset,byteorder);case 5:return data.getUint32(offset,byteorder)/data.getUint32(offset+4,byteorder);case 6:return data.getInt8(offset);case 8:return data.getInt16(offset,byteorder);case 9:return data.getInt32(offset,byteorder);case 10:return data.getInt32(offset,byteorder)/data.getInt32(offset+4,byteorder);case 11:return data.getFloat32(offset,byteorder);case 12:return data.getFloat64(offset,byteorder);}
return null;}};function getImageSize(blob,callback,error){'use strict';BlobView.get(blob,0,Math.min(1024,blob.size),function(data){if(data.byteLength<=8){error('corrupt image file');return;}
var magic=data.getASCIIText(0,8);if(magic.substring(0,4)==='GIF8'){try{callback({type:'gif',width:data.getUint16(6,true),height:data.getUint16(8,true)});}
catch(e){error(e.toString());}}
else if(magic.substring(0,8)==='\x89PNG\r\n\x1A\n'){try{callback({type:'png',width:data.getUint32(16,false),height:data.getUint32(20,false)});}
catch(e){error(e.toString());}}
else if(magic.substring(0,2)==='\xFF\xD8'){parseJPEGMetadata(blob,function(metadata){metadata.type='jpeg';callback(metadata);},error);}
else{error('unknown image type');}});};'use strict';function getStorageIfAvailable(kind,size,success,error){var storage=navigator.getDeviceStorage(kind);storage.available().onsuccess=function(e){if(e.target.result!=='available'){if(error)
error(e.target.result);}
else{storage.freeSpace().onsuccess=function(e){if(e.target.result<size){if(error)
error(e.target.result);}
else{success(storage);}};}};};'use strict';function getUnusedFilename(storage,name,callback){var getreq=storage.get(name);getreq.onerror=function(){callback(name);};getreq.onsuccess=function(){var version=0;var p=name.lastIndexOf('/');var dir=name.substring(0,p+1);var file=name.substring(p+1);p=file.lastIndexOf('.');if(p===-1)
p=file.length;var ext=file.substring(p);var base=file.substring(0,p);var parts=base.match(/^(.*)_(\d{1,2})$/);if(parts){base=parts[1];version=parseInt(parts[2]);}
var newname=dir+base+'_'+(version+1)+ext;getUnusedFilename(storage,newname,callback);};};var CONFIG_MAX_IMAGE_PIXEL_SIZE=5242880;var CONFIG_MAX_SNAPSHOT_PIXEL_SIZE=5242880;var CONFIG_MAX_PICK_PIXEL_SIZE=0;var CONFIG_MAX_EDIT_PIXEL_SIZE=0;var CONFIG_MAX_IMAGE_FILE_SIZE=10485760;var CONFIG_MAX_UNKNOWN_IMAGE_FILE_SIZE=524288;var CONFIG_MAX_GIF_IMAGE_FILE_SIZE=2097152;var CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH=0;var CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT=0;;window.addEventListener('localized',function(){var activity;var activityData;var blob;var frame;var saved=false;var storage;var title;navigator.mozSetMessageHandler('activity',handleOpenActivity);function $(id){return document.getElementById(id);}
var MAX_FILE_SIZE=.5*1024*1024;function handleOpenActivity(request){activity=request;activityData=activity.source.data;if(!frame){$('back').addEventListener('click',done);$('save').addEventListener('click',save);frame=new MediaFrame($('frame'),false,CONFIG_MAX_IMAGE_PIXEL_SIZE);if(CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH){frame.setMinimumPreviewSize(CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH,CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT);}
var gestureDetector=new GestureDetector(frame.container);gestureDetector.startDetecting();frame.container.addEventListener('dbltap',handleDoubleTap);frame.container.addEventListener('transform',handleTransform);frame.container.addEventListener('pan',handlePan);frame.container.addEventListener('swipe',handleSwipe);window.addEventListener('resize',frame.resize.bind(frame));frame.onerror=function invalid(){displayError('imageinvalid');};}
title=baseName(activityData.filename||'');$('filename').textContent=title;$('menu').hidden=true;blob=activityData.blob;open(blob);}
function open(blob){if(activityData.allowSave&&activityData.filename&&checkFilename()){getStorageIfAvailable('pictures',blob.size,function(ds){storage=ds;$('menu').hidden=false;});}
getImageSize(blob,success,error);function success(metadata){var pixels=metadata.width*metadata.height;var imagesizelimit=CONFIG_MAX_IMAGE_PIXEL_SIZE;if(blob.type==='image/jpeg')
imagesizelimit*=Downsample.MAX_AREA_REDUCTION;var filesizelimit=2*CONFIG_MAX_IMAGE_PIXEL_SIZE;if(pixels>imagesizelimit||blob.size>filesizelimit){displayError('imagetoobig');return;}
if(blob.size>CONFIG_MAX_IMAGE_FILE_SIZE){displayError('imagetoobig');return;}
if(blob.type==='image/gif'&&blob.size>CONFIG_MAX_GIF_IMAGE_FILE_SIZE){displayError('imagetoobig');return;}
if(!metadata.preview||pixels<512*1024){frame.displayImage(blob,metadata.width,metadata.height,null,metadata.rotation,metadata.mirrored);}
else{parseJPEGMetadata(blob.slice(metadata.preview.start,metadata.preview.end,'image/jpeg'),function success(previewmetadata){metadata.preview.width=previewmetadata.width;metadata.preview.height=previewmetadata.height;frame.displayImage(blob,metadata.width,metadata.height,metadata.preview,metadata.rotation,metadata.mirrored);},function error(){frame.displayImage(blob,metadata.width,metadata.height,null,metadata.rotation,metadata.mirrored);});}}
function error(msg){if(blob.size<CONFIG_MAX_UNKNOWN_IMAGE_FILE_SIZE){frame.displayImage(blob);}
else{displayError('imagetoobig');}}}
function checkFilename(){if(activityData.filename.indexOf('.gallery/')!=-1){return false;}
else{var dotIdx=activityData.filename.lastIndexOf('.');if(dotIdx>-1){var ext=activityData.filename.substr(dotIdx+1);return MimeMapper.guessTypeFromExtension(ext)===blob.type;}else{return false;}}}
function displayError(msgid){alert(navigator.mozL10n.get(msgid));done();}
function done(){activity.postResult({saved:saved});activity=null;}
function handleDoubleTap(e){var scale;if(frame.fit.scale>frame.fit.baseScale)
scale=frame.fit.baseScale/frame.fit.scale;else
scale=2;frame.zoom(scale,e.detail.clientX,e.detail.clientY,200);}
function handleTransform(e){frame.zoom(e.detail.relative.scale,e.detail.midpoint.clientX,e.detail.midpoint.clientY);}
function handlePan(e){frame.pan(e.detail.relative.dx,e.detail.relative.dy);}
function handleSwipe(e){var direction=e.detail.direction;var velocity=e.detail.vy;if(direction==='down'&&velocity>2)
done();}
function save(){$('menu').hidden=true;$('filename').textContent=$('filename').textContent;getUnusedFilename(storage,activityData.filename,function(filename){var savereq=storage.addNamed(blob,filename);savereq.onsuccess=function(){saved=filename;showBanner(navigator.mozL10n.get('saved',{filename:title}));};savereq.onerror=function(e){console.error('Error saving',filename,e);};});}
function showBanner(msg){$('message').textContent=msg;$('banner').hidden=false;setTimeout(function(){$('banner').hidden=true;},3000);}
function baseName(filename){return filename.substring(filename.lastIndexOf('/')+1);}});